#include <spi_nand/spi_nand_core.h>
#include <spi_nand/spi_nand_common.h>

/************************************************
  *  FORESEE (LONGSYS), Manufacture ID: 0xCD
  ***********************************************/
static void foresee_ecc_encode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare){ return; }

static int foresee_ecc_decode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare)
{
    uint8_t ecst = snand_get_ecfail(info, cs);
    VERBOSE("%s ecfail %x\n", __FUNCTION__, ecst);
    switch(ecst)
    {
        case SNAF_ECC_NO_BITFLIPS:
            return 0;
        case SNAF_ECC_UNCOR_ERROR:
            ERROR("ECC Uncorrected Error Detected\n");
            return -2;
        case SNAF_ECC_HAS_LT_BITFLIPS:
            return info->pm.ecc_bits;    // max bit-flips
        default:
            break;
    }
    return -1;
}

void foresee_quad_enable(snaf_info_t *info, uint8_t cs, uint8_t v)
{
    uint8_t wpe = (v==1)?0:1;
    snand_quad_enable2(info, cs, wpe);  // 0xA0, WP-Enable
}

static void foresee_init(snaf_info_t *info)
{
    uint32_t cs;
    uint32_t ondie_en = CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC);
    uint32_t extra = CHECK_ARCH(info->pm.mode, SNAF_EXTRA_ECSP);
    for (cs=0; cs<info->num_lun; cs++) {
        snand_reset(info, cs);
        snand_wait_oip(info, cs, 500, __FUNCTION__);
        snand_unlock(info, cs);
        foresee_quad_enable(info, cs, CHECK_ARCH(info->pm.mode, SNAF_QUAD_IO));
        snand_set_ecc_en(info, cs, CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC));
    }
    if (ondie_en) {
        info->ecc_decode = foresee_ecc_decode;
        info->ecc_encode = foresee_ecc_encode;
        if(extra) info->pm.spare_size -= 1;    // hide internal ecc space
    }
    info->tprog = 800;
    info->tread = 450;
    info->tberase = 10000;
}

#define FORESEE_OPS   (SNAF_ON_DIE_ECC|SNAF_SERIAL_IO)

/*    Manu ID, Device ID, num of block, init func, options */
const snaf_pm_t foresee_chips_info[] = {
    /*********** 3.3 V ***********/
    SNDB(MID_FORESEE, "FS35ND01G", 0xEA11, 1024, 64, 2048, 64, 4, FORESEE_OPS), // 1Gb
    SNDB(MID_FORESEE, "FS35ND02G", 0xEB11, 2048, 64, 2048, 64, 4, FORESEE_OPS), // 2Gb
    SNDB(MID_FORESEE, "FS35ND04G", 0xEC11, 4096, 64, 2048, 64, 4, FORESEE_OPS), // 4Gb

    /*********** 1.8 V ***********/
};

const snaf_manu_t foresee_manu_info = {
    .mid = MID_FORESEE,
    .mname = "FORESEE",     // follow parameter page namespace
    .nchips = ARRAY_SIZE(foresee_chips_info),
    .chips = foresee_chips_info,
    .init = foresee_init,
};
