#include <spi_nand/spi_nand_core.h>
#include <spi_nand/spi_nand_common.h>

/************************************************
  *  ETRON, Manufacture ID: 0xD5
  ***********************************************/
static void etron_ecc_encode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare){ return; }

static int etron_ecc_decode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare)
{
    uint8_t ecst = snand_get_ecfail(info, cs);
    VERBOSE("%s ecfail %x\n", __FUNCTION__, ecst);
    switch(ecst)
    {
        case SNAF_ECC_NO_BITFLIPS:
            return 0;
        case SNAF_ECC_UNCOR_ERROR:
            ERROR("ECC Uncorrected Error Detected\n");
            return -2;
        case SNAF_ECC_HAS_LT_BITFLIPS:
        case SNAF_ECC_HAS_ELT_BITFLIPS:
            // internal ECC read (C7 command, only available for 1Gb)
            // so return max ecc bits
            return info->pm.ecc_bits;
        default:
            break;
    }
    return -1;
}

static void etron_init(snaf_info_t *info)
{
    uint32_t cs;
    uint32_t ondie_en = CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC);
    uint32_t extra = CHECK_ARCH(info->pm.mode, SNAF_EXTRA_ECSP);
    for (cs=0; cs<info->num_lun; cs++) {
        snand_reset(info, cs);
        snand_wait_oip(info, cs, 600, __FUNCTION__);
        snand_unlock(info, cs);
        snand_quad_enable(info, cs, CHECK_ARCH(info->pm.mode, SNAF_QUAD_IO));
        snand_set_ecc_en(info, cs, ondie_en);
    }
    if (ondie_en) {
        info->ecc_decode = etron_ecc_decode;
        info->ecc_encode = etron_ecc_encode;
        if(extra) info->pm.spare_size -= 1;    // hide internal ecc space
    }
    info->tprog   = 700;
    info->tread   = 140;
    info->tberase = 3000;  // after test, spec is wrong?
}

#define ETRON_OPS   (SNAF_ON_DIE_ECC|SNAF_EXTRA_ECSP|SNAF_SERIAL_IO)

const snaf_pm_t etron_chips_info[] = {
    /*********** 3.3 V ***********/
    /* SNDB(MID_ETRON, "EM73C044VCC-H", 0x22, 1024, 64, 2048,  64, 4, SNAF_SERIAL_IO), // 1Gb, no parameter page */
    SNDB(MID_ETRON, "EM73C044VCF-H", 0x25, 1024, 64, 2048,  64, 4, ETRON_OPS), // 1Gb
    SNDB(MID_ETRON, "EM73D044VCL-H", 0x2E, 2048, 64, 2048, 128, 8, ETRON_OPS), // 2Gb
    SNDB(MID_ETRON, "EM73E044VCB-H", 0x2F, 4096, 64, 2048, 128, 8, ETRON_OPS), // 4Gb
    SNDB(MID_ETRON, "EM73F044VCA-H", 0x2D, 4096, 64, 4096, 256, 8, ETRON_OPS), // 8Gb

    /*********** 1.8 V ***********/
    SNDB(MID_ETRON, "EM78D044VCM-H", 0x8E, 2048, 64, 2048, 128, 8, ETRON_OPS), // 2Gb
    SNDB(MID_ETRON, "EM78E044VCD-H", 0x8F, 4096, 64, 2048, 128, 8, ETRON_OPS), // 4Gb
    SNDB(MID_ETRON, "EM78F044VCA-H", 0x8D, 4096, 64, 4096, 256, 8, ETRON_OPS), // 8Gb
};

const snaf_manu_t etron_manu_info = {
    .mid = MID_ETRON,
    .mname = "ETRON",     // follow parameter page namespace
    .nchips = ARRAY_SIZE(etron_chips_info),
    .chips = etron_chips_info,
    .init = etron_init,
};