#include <spi_nand/spi_nand_core.h>
#include <spi_nand/spi_nand_common.h>

/************************************************
  *  ESMT, Manufacture ID: 0xC8
  ***********************************************/
static void esmt_ecc_encode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare){ return; }

static int esmt_ecc_decode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare)
{
    uint8_t ecst = snand_get_ecfail(info, cs);
    VERBOSE("%s ecfail %x\n", __FUNCTION__, ecst);
    switch(ecst)
    {
        case SNAF_ECC_NO_BITFLIPS:
            return 0;
        case SNAF_ECC_UNCOR_ERROR:
            ERROR("ECC Uncorrected Error Detected\n");
            return -2;
        case SNAF_ECC_HAS_LT_BITFLIPS:
            return info->pm.ecc_bits;    // max bit-flips
        default:
            break;
    }
    return -1;
}

void esmt_quad_enable(snaf_info_t *info, uint8_t cs, uint8_t v)
{
    uint8_t wpe = (v==1)?0:1;
    snand_quad_enable2(info, cs, wpe);
}

static void esmt_init(snaf_info_t *info)
{
    uint32_t cs;
    uint32_t ondie_en = CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC);
    uint32_t extra = CHECK_ARCH(info->pm.mode, SNAF_EXTRA_ECSP);
    for (cs=0; cs<info->num_lun; cs++) {
        snand_reset(info, cs);
        snand_wait_oip(info, cs, 615, __FUNCTION__);
        snand_unlock(info, cs);
        esmt_quad_enable(info, cs, CHECK_ARCH(info->pm.mode, SNAF_QUAD_IO));
        snand_set_ecc_en(info, cs, CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC));
    }
    if (ondie_en) {
        info->ecc_decode = esmt_ecc_decode;
        info->ecc_encode = esmt_ecc_encode;
        if(extra) info->pm.spare_size -= 1;    // hide internal ecc space
    }
    info->tprog = 600;
    info->tread = 120;
    info->tberase = 10000;
}

#define ESMT_OPS   (SNAF_ON_DIE_ECC|SNAF_SERIAL_IO)

/*    Manu ID, Device ID, num of block, init func, options */
const snaf_pm_t esmt_chips_info[] = {
    /*********** 3.3 V ***********/
    // from micron
    // "F50L2G41XA", 2Gb, is same as Micron MT29F2G01ABAGD
    // "F50L4G41XB", 4Gb, is same as Micron MT29F4G01ABAFD

    // from GD
    SNDB(MID_ESMT, "F50L1G41LB", 0x01, 1024, 64, 2048, 64, 1, ESMT_OPS), // 1Gb
    SNDB(MID_ESMT, "F50L2G41LB", 0x0A, 2048, 64, 2048, 64, 1, ESMT_OPS|SNAF_STACK_DIE), // 2Gb

    /*********** 1.8 V ***********/
    // from micron
    // "F50D4G41XB", 2Gb, is same as Micron MT29F2G01ABBGD
    // "F50L4G41XB", 4Gb, is same as Micron MT29F4G01ABBFD

    // from GD
    SNDB(MID_ESMT, "F50D1G41LB", 0x11, 1024, 64, 2048, 64, 1, ESMT_OPS), // 1Gb
    SNDB(MID_ESMT, "F50D2G41LB", 0x1A, 2048, 64, 2048, 64, 1, ESMT_OPS|SNAF_STACK_DIE), // 2Gb
};

const snaf_manu_t esmt_manu_info = {
    .mid = MID_ESMT,
    .mname = "ESMT",     // follow parameter page namespace
    .nchips = ARRAY_SIZE(esmt_chips_info),
    .chips = esmt_chips_info,
    .init = esmt_init,
};
