#include <spi_nand/spi_nand_core.h>
#include <spi_nand/spi_nand_common.h>

/************************************************
  *  DOSILICON, Manufacture ID: 0xE5
  ***********************************************/
static void dosilicon_ecc_encode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare){ return; }

static int dosilicon_ecc_decode(struct snaf_info_s *info, uint8_t cs, uint8_t cap, uint8_t *payload, uint8_t *spare)
{
    uint8_t ecst = snand_get_ecfail(info, cs);
    VERBOSE("%s ecfail %x\n", __FUNCTION__, ecst);
    switch(ecst)
    {
        case SNAF_ECC_NO_BITFLIPS:
            return 0;
        case SNAF_ECC_UNCOR_ERROR:
            ERROR("ECC Uncorrected Error Detected\n");
            return -2;
        case SNAF_ECC_HAS_LT_BITFLIPS:
            return info->pm.ecc_bits;    // max bit-flips
        default:
            break;
    }
    return -1;
}

static void dosilicon_init(snaf_info_t *info)
{
    uint32_t cs;
    uint32_t ondie_en = CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC);
    uint32_t extra = CHECK_ARCH(info->pm.mode, SNAF_EXTRA_ECSP);
    for (cs=0; cs<info->num_lun; cs++) {
        snand_reset(info, cs);
        snand_wait_oip(info, cs, 550, __FUNCTION__);
        snand_unlock(info, cs);
        snand_quad_enable(info, cs, CHECK_ARCH(info->pm.mode, SNAF_QUAD_IO));
        snand_set_ecc_en(info, cs, CHECK_ARCH(info->pm.mode, SNAF_ON_DIE_ECC));
    }
    if (ondie_en) {
        info->ecc_decode = dosilicon_ecc_decode;
        info->ecc_encode = dosilicon_ecc_encode;
        if(extra) info->pm.spare_size -= 1;    // hide internal ecc space
    }
    info->tprog = 700;
    info->tread = 70;
    info->tberase = 10000;
}

#define DOSILICON_OPS   (SNAF_ON_DIE_ECC|SNAF_SERIAL_IO)

/*    Manu ID, Device ID, num of block, init func, options */
const snaf_pm_t dosilicon_chips_info[] = {
    /*********** 3.3 V ***********/
    // A generation, ~104MHz
    SNDB(MID_DOSILICON, "DS35Q1GA", 0x71, 1024, 64, 2048,  64, 4, DOSILICON_OPS), // 1Gb
    SNDB(MID_DOSILICON, "DS35Q2GA", 0x72, 2048, 64, 2048,  64, 4, DOSILICON_OPS), // 2Gb
    // B generation, ~84MHz
    SNDB(MID_DOSILICON, "DS35Q2GB", 0xF2, 2048, 64, 2048, 128, 8, DOSILICON_OPS|SNAF_EXTRA_ECSP), // 2Gb
    SNDB(MID_DOSILICON, "DS35Q4GM", 0xF4, 4096, 64, 2048, 128, 8, DOSILICON_OPS|SNAF_EXTRA_ECSP), // 4Gb

    /*********** 1.8 V ***********/
    // A generation, ~104MHz
    SNDB(MID_DOSILICON, "DS35M1GA", 0x21, 1024, 64, 2048,  64, 4, DOSILICON_OPS), // 1Gb
    SNDB(MID_DOSILICON, "DS35M2GA", 0x22, 2048, 64, 2048,  64, 4, DOSILICON_OPS), // 2Gb
    // B generation, ~84MHz
    SNDB(MID_DOSILICON, "DS35M2GB", 0xA2, 2048, 64, 2048, 128, 8, DOSILICON_OPS|SNAF_EXTRA_ECSP), // 2Gb
    SNDB(MID_DOSILICON, "DS35M4GM", 0xA4, 4096, 64, 2048, 128, 8, DOSILICON_OPS|SNAF_EXTRA_ECSP), // 4Gb
};

const snaf_manu_t dosilicon_manu_info = {
    .mid = MID_DOSILICON,
    .mname = "DOSILICON",     // follow parameter page namespace
    .nchips = ARRAY_SIZE(dosilicon_chips_info),
    .chips = dosilicon_chips_info,
    .init = dosilicon_init,
};
