#ifndef SPI_NAND_COMMON_H
#define SPI_NAND_COMMON_H

#define SNDB(_mid, _mname, _did, _num_b, _num_p, \
                _p_size, _s_size, _ecc, _mode)\
            { .mid = _mid, .did = _did, .did_len = ((_did)>0xff)?2:1,   \
              .num_blk = SNAF_MODEL_NUM_BLK_##_num_b,            \
              .num_page = SNAF_MODEL_NUM_PAGE_##_num_p,           \
              .page_size = SNAF_MODEL_PAGE_SIZE_##_p_size##B,         \
              .spare_size = SNAF_MODEL_SPARE_SIZE_##_s_size##B,        \
              .mode = SNAF_DEF_IO_MODE, \
              .ecc_bits = _ecc, \
              .mode = _mode,\
            }

#define SNDB_2K(_mid, _mname, _did, _num_b, _ecc, _mode)\
                SNDB(_mid, _mname, _did, _num_b, 64, 2048, 64, _ecc,   _mode)

#define SNDB_4K(_mid, _mname, _did, _num_b, _ecc, _mode)\
                SNDB(_mid, _mname, _did, _num_b, 64, 4096, 128, _ecc,  _mode)

// MANUFACTOR LIST
typedef struct {
    uint8_t mid;
    char *mname;
    uint16_t nchips;
    const snaf_pm_t *chips;
    void (*init)(snaf_info_t *info);
} snaf_manu_t;

struct nand_param_page {
        /* Rev information and feature block */
        uint32_t page_sig;              /* Byte 0-3 */
        uint16_t rev;                   /* Byte 4-5 */
        uint16_t features;              /* Byte 6-7 */
        uint16_t opt_cmd;               /* Byte 8-9 */
        uint8_t jtg;                    /* Byte 10 */
        uint8_t train_cmd;              /* Byte 11 */
        uint16_t ext_param_length;      /* Byte 12-13 */
        uint8_t nb_param_pages;         /* Byte 14 */
        uint8_t reserved1[17];          /* Byte 15-31 */
        /* Manufacturer information */
        uint8_t manufacturer[12];       /* Byte 32-43 */
        uint8_t model[20];              /* Byte 44-63 */
        uint8_t manufacturer_id;        /* Byte 64 */
        uint16_t data_code;             /* Byte 65-66 */
        uint8_t reserved2[13];          /* Byte 67-79 */
        /* Memory organization */
        uint32_t bytes_per_page;        /* Byte 80-83 */
        uint16_t spare_per_page;        /* Byte 84-85 */
        uint32_t bytes_per_partial;     /* Byte 86-89 */
        uint16_t spare_per_partial;     /* Byte 90-91 */
        uint32_t num_pages_per_blk;     /* Byte 92-95 */
        uint32_t num_blk_in_lun;        /* Byte 96-99 */
        uint8_t num_lun;                /* Byte 100 */
        uint8_t num_addr_cycles;        /* Byte 101 */
        uint8_t bit_per_cell;           /* Byte 102 */
        uint16_t max_bb_per_lun;        /* Byte 103-104 */
        uint16_t blk_endur;             /* Byte 105-106 */
        uint8_t valid_blk_begin;        /* Byte 107 */
        uint16_t blk_enbur_valid;       /* Byte 108-109 */
        uint8_t nb_prog_page;           /* Byte 110 */
        uint8_t partial_prog_attr;      /* Byte 111 */
        uint8_t nb_ecc_bits;            /* Byte 112 */
        uint8_t plane_addr;             /* Byte 113 */
        uint8_t mplanes_ops;            /* Byte 114 */
        uint8_t ez_nand;                /* Byte 115 */
        uint8_t reserved3[12];          /* Byte 116-127 */
        /* Electrical parameters */
        uint8_t io_pin_cap_max;         /* Byte 128 */
        uint16_t sdr_timing_mode;       /* Byte 129-130 */
        uint16_t sdr_prog_cache_timing; /* Byte 131-132 */
        uint16_t tprog;                 /* Byte 133-134 */
        uint16_t tbers;                 /* Byte 135-136 */
        uint16_t tr;                    /* Byte 137-138 */
        uint16_t tccs;                  /* Byte 139-140 */
        uint8_t nvddr_timing_mode;      /* Byte 141 */
        uint8_t nvddr2_timing_mode;     /* Byte 142 */
        uint8_t nvddr_features;         /* Byte 143 */
        uint16_t clk_input_cap_typ;     /* Byte 144-145 */
        uint16_t io_pin_cap_typ;        /* Byte 146-147 */
        uint16_t input_pin_cap_typ;     /* Byte 148-149 */
        uint8_t input_pin_cap_max;      /* Byte 150 */
        uint8_t drv_strength_support;   /* Byte 151 */
        uint16_t tr_max;                /* Byte 152-153 */
        uint16_t tadl;                  /* Byte 154-155 */
        uint16_t tr_typ;                /* Byte 156-157 */
        uint8_t reserved4[6];           /* Byte 158-163 */
        /* Vendor block */
        uint16_t vendor_revision;       /* Byte 164-165 */
        uint8_t vendor[88];             /* Byte 166-253 */
        uint16_t crc16;                 /* Byte 254-255 */
} __packed;

extern const snaf_manu_t dosilicon_manu_info;
extern const snaf_manu_t esmt_manu_info;
extern const snaf_manu_t etron_manu_info;
extern const snaf_manu_t foresee_manu_info;
extern const snaf_manu_t gd_manu_info;
extern const snaf_manu_t hyt_manu_info;
extern const snaf_manu_t kioxia_manu_info;
extern const snaf_manu_t micron_manu_info;
extern const snaf_manu_t mxic_manu_info;
extern const snaf_manu_t winbond_manu_info;
extern const snaf_manu_t xtx_manu_info;

// Tier-IV (Function include Operations and ECC check)
void spi_nand_init(snaf_info_t *info);
int spi_nand_probe(uint32_t mode);
void spi_nand_ecc_encode(struct snaf_info_s *info, uint8_t cs, uint8_t conf, uint8_t *payload, uint8_t *spare);
int spi_nand_ecc_decode(struct snaf_info_s *info, uint8_t cs, uint8_t conf, uint8_t *payload, uint8_t *spare);
int spi_nand_block_is_bad(struct snaf_info_s *info, uint8_t cs, uint32_t off);

#endif //SPI_NAND_COMMON_H
