#ifndef __ECC_H__
#define __ECC_H__ 1

#include <sihnah.h>
#include <_reg_ecc.h>

#define ECC_DATA_SZ_B (512)
#define ECC_TAG_SZ_B (6)
#define ECC_BCH6_SYNDROME_SZ_B (10)
#define ECC_BCH12_SYNDROME_SZ_B (20)

#define ECC_DECODE (0)
#define ECC_ENCODE (1)

#define ECC_BCH6 (0x0)
#define ECC_BCH12 (0x1)

typedef struct {
	uint8_t algo;
	uint8_t act;
} sihnah_ecc_t;

int ecc_action(const sihnah_ecc_t *op, uint8_t *data, uint8_t *tag, uint8_t *syndrome);

#endif
