#ifndef ___REG_ECC_H__
#define ___REG_ECC_H__ 1
#include <reg_skc35.h>

#ifndef __BYTE_ORDER__
#	error "__BYTE_ORDER__ is not defined"
#endif

#if (__BYTE_ORDER__ != __ORDER_BIG_ENDIAN__) && \
    (__BYTE_ORDER__ != __ORDER_LITTLE_ENDIAN__)
#	error "unknown __BYTE_ORDER__ value"
#endif

#ifndef _REG_ECC
#	define _REG_ECC (0x0102c000)
#endif

SKC35_REG_DEC(
	ECCFR, (_REG_ECC + 0x0),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 30);
	RFIELD(29, 28, ecc_cfg);
	RF_RSV(27, 27);
	RFIELD(26, 24, debug_select);
	RFIELD(23, 23, dhc_tag2byte);
	RFIELD(22, 22, rbo);
	RFIELD(21, 21, wbo);
	RFIELD(20, 20, ie);
	RF_RSV(19, 15);
	RFIELD(14, 14, slv_endian);
	RFIELD(13, 13, dma_endian);
	RFIELD(12, 12, precise);
	RF_RSV(11, 2);
	RFIELD(1, 0, lbc_bsz);
#else
	RFIELD(1, 0, lbc_bsz);
	RF_RSV(11, 2);
	RFIELD(12, 12, precise);
	RFIELD(13, 13, dma_endian);
	RFIELD(14, 14, slv_endian);
	RF_RSV(19, 15);
	RFIELD(20, 20, ie);
	RFIELD(21, 21, wbo);
	RFIELD(22, 22, rbo);
	RFIELD(23, 23, dhc_tag2byte);
	RFIELD(26, 24, debug_select);
	RF_RSV(27, 27);
	RFIELD(29, 28, ecc_cfg);
	RF_RSV(31, 30);
#endif
	);

//skip offset 0x4 ~ 0x4 due to reserved

SKC35_REG_DEC(
	ECDTR, (_REG_ECC + 0x8),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 1);
	RFIELD(0, 0, dmare);
#else
	RFIELD(0, 0, dmare);
	RF_RSV(31, 1);
#endif
	);

SKC35_REG_DEC(
	ECDSAR, (_REG_ECC + 0xc),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, addr);
#else
	RFIELD(31, 0, addr);
#endif
	);

SKC35_REG_DEC(
	ECDTAR, (_REG_ECC + 0x10),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, addr);
#else
	RFIELD(31, 0, addr);
#endif
	);

SKC35_REG_DEC(
	ECSR, (_REG_ECC + 0x14),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 20);
	RFIELD(19, 12, eccn);
	RF_RSV(11, 9);
	RFIELD(8, 8, eccer);
	RF_RSV(7, 5);
	RFIELD(4, 4, all_one);
	RF_RSV(3, 2);
	RFIELD(1, 1, dmars);
	RFIELD(0, 0, eos);
#else
	RFIELD(0, 0, eos);
	RFIELD(1, 1, dmars);
	RF_RSV(3, 2);
	RFIELD(4, 4, all_one);
	RF_RSV(7, 5);
	RFIELD(8, 8, eccer);
	RF_RSV(11, 9);
	RFIELD(19, 12, eccn);
	RF_RSV(31, 20);
#endif
	);

SKC35_REG_DEC(
	ECIR, (_REG_ECC + 0x18),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 1);
	RFIELD(0, 0, dma_ip);
#else
	RFIELD(0, 0, dma_ip);
	RF_RSV(31, 1);
#endif
	);

SKC35_REG_DEC(
	ECDCDSR, (_REG_ECC + 0x1c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 20);
	RFIELD(19, 0, clenc);
#else
	RFIELD(19, 0, clenc);
	RF_RSV(31, 20);
#endif
	);

//skip offset 0x20 ~ 0x30 due to reserved

SKC35_REG_DEC(
	ECIDSR, (_REG_ECC + 0x34),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, dbsts);
#else
	RFIELD(31, 0, dbsts);
#endif
	);

//skip offset 0x38 ~ 0x44 due to reserved

SKC35_REG_DEC(
	ECNAPR1_1, (_REG_ECC + 0x48),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr1_1);
#else
	RFIELD(31, 0, napr1_1);
#endif
	);

SKC35_REG_DEC(
	ECNAPR1_2, (_REG_ECC + 0x4c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr1_2);
#else
	RFIELD(31, 0, napr1_2);
#endif
	);

SKC35_REG_DEC(
	ECNAPR1_3, (_REG_ECC + 0x50),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr1_3);
#else
	RFIELD(31, 0, napr1_3);
#endif
	);

SKC35_REG_DEC(
	ECNAPR2_1, (_REG_ECC + 0x54),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr2_1);
#else
	RFIELD(31, 0, napr2_1);
#endif
	);

SKC35_REG_DEC(
	ECNAPR2_2, (_REG_ECC + 0x58),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr2_2);
#else
	RFIELD(31, 0, napr2_2);
#endif
	);

SKC35_REG_DEC(
	ECNAPR2_3, (_REG_ECC + 0x5c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr2_3);
#else
	RFIELD(31, 0, napr2_3);
#endif
	);

SKC35_REG_DEC(
	ECNAPR3_1, (_REG_ECC + 0x60),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr2_1);
#else
	RFIELD(31, 0, napr2_1);
#endif
	);

SKC35_REG_DEC(
	ECNAPR3_2, (_REG_ECC + 0x64),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr2_2);
#else
	RFIELD(31, 0, napr2_2);
#endif
	);

SKC35_REG_DEC(
	ECNAPR3_3, (_REG_ECC + 0x68),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr2_3);
#else
	RFIELD(31, 0, napr2_3);
#endif
	);

SKC35_REG_DEC(
	ECNAPR4_1, (_REG_ECC + 0x6c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr2_1);
#else
	RFIELD(31, 0, napr2_1);
#endif
	);

#endif
