#include <sihnah.h>
#include <pnand.h>

/* all the one-time jobs */
void pnand_cntlr_init(void) {
	RMOD(
		NACR,
		rbo, 1,
		wbo, 1);
	return;
}

void pnand_write_cmd(int ce, uint8_t cmd) {
	NACMR_T nacmr = {0};

	nacmr.f.cecs0 = !ce;
	nacmr.f.cecs1 = !!ce;

	nacmr.f.ce_cmd = cmd;
	/* printf("DD: %s: NACMR: %08x... ", __FUNCTION__, nacmr.v); */
	writel(nacmr.v, RRVAL(NACMR));
	/* puts("done\n"); */

	return;
}

int pnand_write_addr(uint8_t *addr, int addr_byte_cnt) {
	NAADR_T naadr = {0};

	if (addr_byte_cnt) {
		naadr.f.ennextadcyc = 1;
		naadr.f.ad0en = 1;
		while (addr_byte_cnt-- > 1) {
			/* printf("DD: %s:%d NAADR: %08x...\n", __FUNCTION__, __LINE__, naadr.v | *addr); */
			writel(naadr.v | *addr++, RRVAL(NAADR));
		}
		naadr.f.ennextadcyc = 0;
		/* printf("DD: %s:%d NAADR: %08x...", __FUNCTION__, __LINE__, naadr.v | *addr); */
		writel(naadr.v | *addr, RRVAL(NAADR));
		/* puts("done\n"); */
	}

	return 0;
}

uint8_t pnand_read_byte(uint32_t *dat, uint8_t *dat_avl) {
	uint8_t ret;

	if (*dat_avl == 0) {
		*dat = readl(RRVAL(NADR));
		*dat_avl = 4;
		/* printf("DD: %s:%d NADR: %08x...\n", __FUNCTION__, __LINE__, *dat); */
	}

	*dat_avl -= 1;
	ret = *dat & 0xff;
	*dat = *dat >> 8;

	/* printf("DD: %s:%d ret: %02x...\n", __FUNCTION__, __LINE__, ret); */

	return ret;
}

void pnand_read_buf(uint8_t *buf, int len) {
	uint32_t *buf_w = (uint32_t *)buf;
	uint8_t *buf_b;
	uint32_t tmp;
	uint8_t avl;

	while (len >= 4) {
		*buf_w++ = readl(RRVAL(NADR));
		len -= 4;
	}

	buf_b = (uint8_t *)buf_w;
	avl = 0;
	while (len--) {
		*buf_b++ = pnand_read_byte(&tmp, &avl);
	}

	return;
}

void pnand_write_buf(const uint8_t *buf, int len) {
	uint32_t *buf_w = (uint32_t *)buf;

	/* some garbage might be put to flash if not aligned. This is cntlr. limit. */
	while (len > 0) {
		writel(*buf_w++, RRVAL(NADR));
		len -= 4;
	}

	return;
}

int pnand_ready(void) {
	return RFLD(NACR, ready);
}

void pnand_wait_ready(void) {
	while (RFLD(NACR, ready) == 0) {
		;
	}
	return;
}
