#ifndef __PNAND_H__
#define __PNAND_H__ 1

#include <_reg_parallel_nand.h>

typedef struct {
	uint64_t num_block:16; //up to 8K blocks in g2 driver
	uint64_t page_size_b:16; //up to 8KB pages size in g2 driver
	uint64_t num_page_per_block:12; //up to 1K page per block in g2 driver
	uint64_t spare_size_b:12; //up to 256B in g2 driver
	uint64_t ecc_req:1; //6T or 12T; default 12T
	uint64_t read_cmd_seq:1; //(00 + addr) & (00 + addr + 30)
	uint64_t row_addr_c:2; //row addr. cycle; both 0 & 1 are not allowed.
	uint64_t ce:1;
	uint64_t reserved:3;
} pnand_info_t;

skc35_assert(sizeof(pnand_info_t) == sizeof(uint64_t));

__attribute__ ((unused))
static uint8_t *pnand_addr_to_array(uint8_t *array, uint32_t addr) {
	array[0] = addr & 0xff;
	array[1] = (addr >> 8) & 0xff;
	array[2] = (addr >> 16) & 0xff;

	return array;
}

void pnand_cntlr_init(void);

void pnand_write_cmd(int ce, uint8_t cmd);
int pnand_write_addr(uint8_t *addr, int addr_byte_cnt);
uint8_t pnand_read_byte(uint32_t *dat, uint8_t *dat_avl);
void pnand_read_buf(uint8_t *buf, int len);
void pnand_write_buf(const uint8_t *buf, int len);
int pnand_ready(void);
void pnand_wait_ready(void);

#endif
