#include <sihnah.h>
#include <biffen.h>
#include <pnand.h>

/* read page at the given idx, refine the given info if 1st biffen chunk met. */
static int biffen_pnand_probe_1st_chunk(
	pnand_info_t *info,
	bfn_info_t *binfo,
	const uint32_t page_idx)
{
	bfn_medium_t med __attribute__ ((aligned (4)));
	int seq = 0;

	uint8_t addr[6] = {0};

	sihnah_memset(&med, 0, sizeof(bfn_medium_t));

	/* read cmd. */
	pnand_write_cmd(0, 0x00);

	/* read addr. */
	pnand_addr_to_array(&addr[2], page_idx);
	pnand_write_addr(addr, 2 + info->row_addr_c);

	if (info->read_cmd_seq == BFN_RD_SEQ_CMD_ADDR_CMD) {
		pnand_write_cmd(0, 0x30);
	}

	pnand_wait_ready();

	do {
		pnand_read_buf((uint8_t *)&med, sizeof(med));

		if (biffen_verify_chunk(&med, seq)) {
			break;
		}

		if (seq == 0) {
			binfo->page_idx_start = page_idx;
			binfo->total_chunks = med.tag.attr;
		}

		seq++;
		info->page_size_b += 512; //page_size_b was init. to 0.
	} while (1);

	if (info->page_size_b > 0) {
		INFO("page size: %d\n", info->page_size_b);
		INFO("page_idx_start: %d\n", binfo->page_idx_start);
		INFO("total chunk: %d\n", binfo->total_chunks);
		return info->page_size_b;
	} else {
		return 0;
	}
}

uint32_t *biffen_pnand_probe(pnand_info_t *info, bfn_info_t *binfo) {
	int page_idx;
	int rd_seq;
	int raddr_cycle;
	int res;

	for (page_idx = 0; page_idx < 4096; page_idx+=32) {
		for (rd_seq = 0; rd_seq < BFN_RD_SEQ_NUM; rd_seq++) {
			/* supporting 3 and 2 is enough, while it is most likely 3. */
			for (raddr_cycle = 3; raddr_cycle > 1; raddr_cycle--) {
				VERBOSE(
					"page idx.: %d, RD cmd. seq.: %d: %s, row addr. cycle: %d => ",
					page_idx, rd_seq, rd_seq_msg[rd_seq], raddr_cycle);
				info->row_addr_c = raddr_cycle;
				info->read_cmd_seq = rd_seq;
				info->page_size_b = 0;

				res = biffen_pnand_probe_1st_chunk(info, binfo, page_idx);

				if (res) {
					VERBOSE("pass\n");
					return 0;
				} else {
					VERBOSE("fail\n");
				}
			}
		}
	}

	return 0;
}
