#ifndef ___REG_PARALLEL_NAND_H__
#define ___REG_PARALLEL_NAND_H__ 1
#include <reg_skc35.h>

#ifndef __BYTE_ORDER__
#	error "__BYTE_ORDER__ is not defined"
#endif

#if (__BYTE_ORDER__ != __ORDER_BIG_ENDIAN__) && \
    (__BYTE_ORDER__ != __ORDER_LITTLE_ENDIAN__)
#	error "unknown __BYTE_ORDER__ value"
#endif

#ifndef _REG_PARALLEL_NAND
#	define _REG_PARALLEL_NAND (0x01028000)
#endif

SKC35_REG_DEC(
	NACFR, (_REG_PARALLEL_NAND + 0x0),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 30, nafc_rc);
	RFIELD(29, 28, nafc_ac);
	RFIELD(27, 27, nafc_nf);
	RFIELD(26, 24, debug_select);
	RFIELD(23, 23, wp_b);
	RFIELD(22, 22, bch12_en);
	RFIELD(21, 21, bch24_en);
	RF_RSV(20, 5);
	RFIELD(4, 4, trhz);
	RFIELD(3, 0, ce_tdh);
#else
	RFIELD(3, 0, ce_tdh);
	RFIELD(4, 4, trhz);
	RF_RSV(20, 5);
	RFIELD(21, 21, bch24_en);
	RFIELD(22, 22, bch12_en);
	RFIELD(23, 23, wp_b);
	RFIELD(26, 24, debug_select);
	RFIELD(27, 27, nafc_nf);
	RFIELD(29, 28, nafc_ac);
	RFIELD(31, 30, nafc_rc);
#endif
	);

SKC35_REG_DEC(
	NACR, (_REG_PARALLEL_NAND + 0x4),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 31, ready);
	RFIELD(30, 30, ecc);
	RFIELD(29, 29, rbo);
	RFIELD(28, 28, wbo);
	RFIELD(27, 27, ie);
	RF_RSV(26, 20);
	RFIELD(19, 16, ce_twp);
	RFIELD(15, 12, ce_twh);
	RFIELD(11, 8, ce_trr);
	RFIELD(7, 4, ce_th);
	RFIELD(3, 0, ce_ts);
#else
	RFIELD(3, 0, ce_ts);
	RFIELD(7, 4, ce_th);
	RFIELD(11, 8, ce_trr);
	RFIELD(15, 12, ce_twh);
	RFIELD(19, 16, ce_twp);
	RF_RSV(26, 20);
	RFIELD(27, 27, ie);
	RFIELD(28, 28, wbo);
	RFIELD(29, 29, rbo);
	RFIELD(30, 30, ecc);
	RFIELD(31, 31, ready);
#endif
	);

SKC35_REG_DEC(
	NACMR, (_REG_PARALLEL_NAND + 0x8),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 31, cecs1);
	RFIELD(30, 30, cecs0);
	RF_RSV(29, 8);
	RFIELD(7, 0, ce_cmd);
#else
	RFIELD(7, 0, ce_cmd);
	RF_RSV(29, 8);
	RFIELD(30, 30, cecs0);
	RFIELD(31, 31, cecs1);
#endif
	);

SKC35_REG_DEC(
	NAADR, (_REG_PARALLEL_NAND + 0xc),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 28);
	RFIELD(27, 27, ennextadcyc);
	RFIELD(26, 26, ad2en);
	RFIELD(25, 25, ad1en);
	RFIELD(24, 24, ad0en);
	RFIELD(23, 16, ce_addr2);
	RFIELD(15, 8, ce_addr1);
	RFIELD(7, 0, ce_addr0);
#else
	RFIELD(7, 0, ce_addr0);
	RFIELD(15, 8, ce_addr1);
	RFIELD(23, 16, ce_addr2);
	RFIELD(24, 24, ad0en);
	RFIELD(25, 25, ad1en);
	RFIELD(26, 26, ad2en);
	RFIELD(27, 27, ennextadcyc);
	RF_RSV(31, 28);
#endif
	);

SKC35_REG_DEC(
	NADCRR, (_REG_PARALLEL_NAND + 0x10),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 9);
	RFIELD(8, 7, tag_sel);
	RFIELD(6, 6, tag_dis);
	RFIELD(5, 5, decs1);
	RFIELD(4, 4, decs0);
	RFIELD(3, 3, dmare);
	RFIELD(2, 2, dmawe);
	RFIELD(1, 0, lbc_bsz);
#else
	RFIELD(1, 0, lbc_bsz);
	RFIELD(2, 2, dmawe);
	RFIELD(3, 3, dmare);
	RFIELD(4, 4, decs0);
	RFIELD(5, 5, decs1);
	RFIELD(6, 6, tag_dis);
	RFIELD(8, 7, tag_sel);
	RF_RSV(31, 9);
#endif
	);

SKC35_REG_DEC(
	NADR, (_REG_PARALLEL_NAND + 0x14),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 24, data3);
	RFIELD(23, 16, data2);
	RFIELD(15, 8, data1);
	RFIELD(7, 0, data0);
#else
	RFIELD(7, 0, data0);
	RFIELD(15, 8, data1);
	RFIELD(23, 16, data2);
	RFIELD(31, 24, data3);
#endif
	);

SKC35_REG_DEC(
	NADFSAR, (_REG_PARALLEL_NAND + 0x18),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, addr);
#else
	RFIELD(31, 0, addr);
#endif
	);

SKC35_REG_DEC(
	NADFSAR2, (_REG_PARALLEL_NAND + 0x1c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, addr);
#else
	RFIELD(31, 0, addr);
#endif
	);

SKC35_REG_DEC(
	NADRSAR, (_REG_PARALLEL_NAND + 0x20),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, addr);
#else
	RFIELD(31, 0, addr);
#endif
	);

SKC35_REG_DEC(
	NADTSAR, (_REG_PARALLEL_NAND + 0x24),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, addr);
#else
	RFIELD(31, 0, addr);
#endif
	);

SKC35_REG_DEC(
	NASR, (_REG_PARALLEL_NAND + 0x28),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RF_RSV(31, 9);
	RFIELD(8, 8, all_one);
	RFIELD(7, 4, necn);
	RFIELD(3, 3, nrer);
	RFIELD(2, 2, nwer);
	RFIELD(1, 1, ndrs);
	RFIELD(0, 0, ndws);
#else
	RFIELD(0, 0, ndws);
	RFIELD(1, 1, ndrs);
	RFIELD(2, 2, nwer);
	RFIELD(3, 3, nrer);
	RFIELD(7, 4, necn);
	RFIELD(8, 8, all_one);
	RF_RSV(31, 9);
#endif
	);

//skip offset 0x2c ~ 0x38 due to reserved

SKC35_REG_DEC(
	NAPR1_1, (_REG_PARALLEL_NAND + 0x3c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr1_1);
#else
	RFIELD(31, 0, napr1_1);
#endif
	);

SKC35_REG_DEC(
	NAPR1_2, (_REG_PARALLEL_NAND + 0x40),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr1_2);
#else
	RFIELD(31, 0, napr1_2);
#endif
	);

SKC35_REG_DEC(
	NAPR1_3, (_REG_PARALLEL_NAND + 0x44),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr1_3);
#else
	RFIELD(31, 0, napr1_3);
#endif
	);

SKC35_REG_DEC(
	NAPR2_1, (_REG_PARALLEL_NAND + 0x48),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr2_1);
#else
	RFIELD(31, 0, napr2_1);
#endif
	);

SKC35_REG_DEC(
	NAPR2_2, (_REG_PARALLEL_NAND + 0x4c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr2_2);
#else
	RFIELD(31, 0, napr2_2);
#endif
	);

SKC35_REG_DEC(
	NAPR2_3, (_REG_PARALLEL_NAND + 0x50),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr2_3);
#else
	RFIELD(31, 0, napr2_3);
#endif
	);

SKC35_REG_DEC(
	NAPR3_1, (_REG_PARALLEL_NAND + 0x54),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr3_1);
#else
	RFIELD(31, 0, napr3_1);
#endif
	);

SKC35_REG_DEC(
	NAPR3_2, (_REG_PARALLEL_NAND + 0x58),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr3_2);
#else
	RFIELD(31, 0, napr3_2);
#endif
	);

SKC35_REG_DEC(
	NAPR3_3, (_REG_PARALLEL_NAND + 0x5c),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr3_3);
#else
	RFIELD(31, 0, napr3_3);
#endif
	);

SKC35_REG_DEC(
	NAPR4_1, (_REG_PARALLEL_NAND + 0x60),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr4_1);
#else
	RFIELD(31, 0, napr4_1);
#endif
	);

SKC35_REG_DEC(
	NAPR4_2, (_REG_PARALLEL_NAND + 0x64),
#if (__BYTE_ORDER__ == __ORDER_BIG_ENDIAN__)
	RFIELD(31, 0, napr4_2);
#else
	RFIELD(31, 0, napr4_2);
#endif
	);

#endif
