#include <sihnah.h>
#include <ecc.h>
#include <asm/io.h>
#include <asm/delay.h>
#include <linux/mtd/flashchip.h>
#include <asm/cacheflush.h>
#include <linux/dma-mapping.h>
#include <linux/slab.h>

#define TRUNC_64_TO_32(_val) ((uint32_t)(((long)(_val)) & 0xffffffff))

extern dma_addr_t tns_phy_base;
extern dma_addr_t data_phy_base;
extern uint8_t *tns_vir_base;
extern uint8_t *data_vir_base;

int ecc_get_device(int new_state);
void ecc_release_device(void);
/* return:
	 1...24: ecc decode with n correction
	 0: ecc decode without correction, or encode done
	 -1: FUBAR
 */
int ecc_action(const sihnah_ecc_t *op, uint8_t *data, uint8_t *tag, uint8_t *syndrome) {
	static int flag = 0;
	int ret;
	ecc_get_device(FL_WRITING);
	flag++;
	if (flag > 1) {
		BUG();
	}

	sihnah_memcpy(data_vir_base, data, ECC_DATA_SZ_B);
     /* simply set to the max. tag + syndrome of this cntlr. */
		
	const ECCFR_T eccfr = {
		.f.rbo = 0,
		.f.wbo = 0,
		.f.slv_endian = 0,
		.f.dma_endian = 1,
		.f.ecc_cfg = op->algo,
		.f.ie = 0,
		.f.precise = 1,
		.f.lbc_bsz = 3,
	};
	ECSR_T ecsr;
	int syndrome_sz_b;

	if (((long)data) & (SIHNAH_CACHE_LINE_SIZE - 1)) {
		flag--;
		ecc_release_device();
		ERROR("data ptr. is not cache-line aligned.\n");
		return -2;
	}

	if (op->algo == ECC_BCH12) {
		syndrome_sz_b = ECC_BCH12_SYNDROME_SZ_B;
	} else {
		syndrome_sz_b = ECC_BCH6_SYNDROME_SZ_B;
	}

	sihnah_memcpy(tns_vir_base, tag, ECC_TAG_SZ_B);
	if (op->act == ECC_DECODE) {
		sihnah_memcpy(tns_vir_base + ECC_TAG_SZ_B, syndrome, syndrome_sz_b);
	}
	/* append 0xff for all one check */
	sihnah_memset(
		tns_vir_base + ECC_TAG_SZ_B + syndrome_sz_b,
		0xff,
		sizeof(tns_vir_base) - ECC_TAG_SZ_B - syndrome_sz_b);

	writel(eccfr.v, ERVAL(ECCFR));
	ERMOD(ECDSAR, addr, data_phy_base); //data start addr.
	ERMOD(ECDTAR, addr, tns_phy_base); //tag + syndrome start addr.
	ERMOD(ECDTR, dmare, op->act); //1 for encode

	do {
		ecsr.v = readl(ERVAL(ECSR));
	} while (ecsr.v & 0x3);

	if (op->act == ECC_ENCODE) {
		/* return syndrome for encode */
		sihnah_memcpy(syndrome, tns_vir_base+ECC_TAG_SZ_B, syndrome_sz_b);
		flag--;
		ecc_release_device();
		return 0;
	}

	sihnah_memcpy(tag, tns_vir_base, ECC_TAG_SZ_B);

	flag--;
	ecc_release_device();
	/* return correction result for decode */
	if (ecsr.f.all_one) {
		return 0;
	} else if (ecsr.f.eccer) {
		return -1;
	} else {		
		return ecsr.f.eccn;
	}
}