#include <linux/mtd/physmap.h>
#include <linux/platform_device.h>
#include <flash/flash_partition.h>
#include <nor_spif_core.h>

static struct mtd_partition luna_snof_g3_mtd_partition_sample[RTK_MTD_PARTITION_NUM] = {
};

static struct physmap_flash_data luna_snof_g3_data = {
	.width = 4,
	.nr_parts	= ARRAY_SIZE(luna_snof_g3_mtd_partition_sample),
	.parts = luna_snof_g3_mtd_partition_sample,
	.probe_type  = "map_rom"
};

//#define NORSF_CFLASH_BASE 0x08000000UL
#define NORSF_CFLASH_BASE 0x01020000
#define NORSF_CFLASH_BASE_END 0x01023FFF
static struct resource luna_snof_g3_resource = {
	.start = (NORSF_CFLASH_BASE & 0x3fffffff),
	.end = NORSF_CFLASH_BASE_END,
	.flags = IORESOURCE_MEM
};

static struct platform_device luna_snof_g3_device = {
	.name = "physmap-flash",
	.id = -1, /* This has to be -1, otherwise MTD appends it to name, e.g., physmap-flash.0 */
	.dev = {
		.platform_data = &luna_snof_g3_data,
	},
	.num_resources = 1,
	.resource	= &luna_snof_g3_resource,
};

static int __init luna_snof_g3_add_devices(void) {
	int err;
	int ret = 0;
	int i = 0;
    rtk_partition_entry_t partition_table[RTK_MTD_PARTITION_NUM];
    ret = rtk_flash_partition_table_get(norsf_flashsize_get(), partition_table);
	for (i = 0; i < RTK_MTD_PARTITION_NUM; i++) {
		/* [NTA-178] */
		if (0 == i) {
			luna_snof_g3_mtd_partition_sample[i].mask_flags = MTD_WRITEABLE;
		}
		luna_snof_g3_mtd_partition_sample[i].name = partition_table[i].name;
		luna_snof_g3_mtd_partition_sample[i].size = partition_table[i].size;
		luna_snof_g3_mtd_partition_sample[i].offset = partition_table[i].offset;
	}
	err = platform_device_register(&luna_snof_g3_device);
	if (err) {
		platform_device_unregister(&luna_snof_g3_device);
	}
  return err;
}

late_initcall(luna_snof_g3_add_devices);
