/* Stub implementations for miniupnpd pinhole functions
 * Used for discovery-only mode without iptables dependency
 * MiniUPnP project stub for embedded systems
 */

#include <sys/types.h>
#include <syslog.h>
#include "iptpinhole.h"

#ifdef ENABLE_UPNPPINHOLE

int find_pinhole(const char * ifname,
                 const char * rem_host, unsigned short rem_port,
                 const char * int_client, unsigned short int_port,
                 int proto,
                 char *desc, int desc_len, unsigned int * timestamp)
{
    /* No pinholes exist in stub mode */
    return -1;
}

int add_pinhole(const char * ifname,
                const char * rem_host, unsigned short rem_port,
                const char * int_client, unsigned short int_port,
                int proto, const char *desc, unsigned int timestamp)
{
    syslog(LOG_WARNING, "add_pinhole: Stub mode - no pinholes added");
    return -1; /* Fail to add pinholes in discovery mode */
}

int update_pinhole(unsigned short uid, unsigned int timestamp)
{
    /* Cannot update non-existent pinholes */
    return -1;
}

int delete_pinhole(unsigned short uid)
{
    /* Nothing to delete in stub mode */
    return 0;
}

int
get_pinhole_info(unsigned short uid,
                 char * rem_host, int rem_hostlen, unsigned short * rem_port,
                 char * int_client, int int_clientlen,
                 unsigned short * int_port,
                 int * proto, char * desc, int desclen,
                 unsigned int * timestamp,
                 u_int64_t * packets, u_int64_t * bytes)
{
    /* No pinholes exist in stub mode */
    return -1;
}

int get_pinhole_uid_by_index(int index)
{
    /* No pinholes exist in stub mode */
    return -1;
}

int clean_pinhole_list(unsigned int * next_timestamp)
{
    /* Nothing to clean in stub mode */
    if (next_timestamp)
        *next_timestamp = 0;
    return 0;
}

#endif /* ENABLE_UPNPPINHOLE */