/* Stub implementations for miniupnpd netfilter functions
 * Used for discovery-only mode without iptables dependency
 * MiniUPnP project stub for embedded systems
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <stdint.h>
#include <string.h>
#include <syslog.h>
#include "../commonrdr.h"
#include "iptcrdr.h"

/* Suppress unused parameter warnings */
#define UNUSED(x) ((void)(x))

/* Stub implementations return success but do nothing */

int
init_redirect(void)
{
    return 0;
}

void
shutdown_redirect(void)
{
    /* Nothing to cleanup in stub mode */
}

int
get_redirect_rule_count(const char * ifname)
{
    UNUSED(ifname);
    /* Return 0 rules - no port mappings in discovery mode */
    return 0;
}

int
get_redirect_rule(const char * ifname, unsigned short eport, int proto,
                  char * iaddr, int iaddrlen, unsigned short * iport,
                  char * desc, int desclen,
                  char * rhost, int rhostlen,
                  unsigned int * timestamp,
                  u_int64_t * packets, u_int64_t * bytes)
{
    /* No rules exist in stub mode */
    return -1;
}

int
get_redirect_rule_by_index(int index,
                           char * ifname, unsigned short * eport,
                           char * iaddr, int iaddrlen, unsigned short * iport,
                           int * proto, char * desc, int desclen,
                           char * rhost, int rhostlen,
                           unsigned int * timestamp,
                           u_int64_t * packets, u_int64_t * bytes)
{
    /* No rules exist in stub mode */
    return -1;
}

unsigned short *
get_portmappings_in_range(unsigned short startport, unsigned short endport,
                          int proto, unsigned int * number)
{
    /* No port mappings exist */
    *number = 0;
    return NULL;
}

int
update_portmapping(const char * ifname, unsigned short eport, int proto,
                   unsigned short iport, const char * desc,
                   unsigned int timestamp)
{
    /* Cannot update non-existent mappings */
    return -1;
}

int
update_portmapping_desc_timestamp(const char * ifname,
                   unsigned short eport, int proto,
                   const char * desc, unsigned int timestamp)
{
    /* Cannot update non-existent mappings */
    return -1;
}

/* Functions from iptcrdr.h */

int
add_redirect_rule2(const char * ifname,
                   const char * rhost, unsigned short eport,
                   const char * iaddr, unsigned short iport, int proto,
                   const char * desc, unsigned int timestamp)
{
    syslog(LOG_WARNING, "add_redirect_rule2: Stub mode - no rules added");
    return -1; /* Fail to add rules in discovery mode */
}

int
add_peer_redirect_rule2(const char * ifname,
                   const char * rhost, unsigned short rport,
                   const char * eaddr, unsigned short eport,
                   const char * iaddr, unsigned short iport, int proto,
                   const char * desc, unsigned int timestamp)
{
    syslog(LOG_WARNING, "add_peer_redirect_rule2: Stub mode - no rules added");
    return -1;
}

int
add_filter_rule2(const char * ifname,
                 const char * rhost, const char * iaddr,
                 unsigned short eport, unsigned short iport,
                 int proto, const char * desc)
{
    syslog(LOG_WARNING, "add_filter_rule2: Stub mode - no rules added");
    return -1;
}

int
delete_redirect_and_filter_rules(unsigned short eport, int proto)
{
    /* Nothing to delete in stub mode */
    return 0;
}

int
delete_filter_rule(const char * ifname, unsigned short port, int proto)
{
    /* Nothing to delete in stub mode */
    return 0;
}

int
add_peer_dscp_rule2(const char * ifname,
                   const char * rhost, unsigned short rport,
                   unsigned char dscp,
                   const char * iaddr, unsigned short iport, int proto,
                   const char * desc, unsigned int timestamp)
{
    syslog(LOG_WARNING, "add_peer_dscp_rule2: Stub mode - no rules added");
    return -1;
}

int get_nat_ext_addr(struct sockaddr* src, struct sockaddr *dst, uint8_t proto,
                     struct sockaddr* ret_ext)
{
    /* Cannot determine NAT external address in stub mode */
    return -1;
}

int
get_peer_rule_by_index(int index,
                           char * ifname, unsigned short * eport,
                           char * iaddr, int iaddrlen, unsigned short * iport,
                           int * proto, char * desc, int desclen,
                           char * rhost, int rhostlen, unsigned short * rport,
                           unsigned int * timestamp,
                           u_int64_t * packets, u_int64_t * bytes)
{
    /* No peer rules in stub mode */
    return -1;
}

int
get_nat_redirect_rule(const char * nat_chain_name, const char * ifname, unsigned short eport, int proto,
                  char * iaddr, int iaddrlen, unsigned short * iport,
                  char * desc, int desclen,
                  char * rhost, int rhostlen,
                  unsigned int * timestamp,
                  u_int64_t * packets, u_int64_t * bytes)
{
    /* No NAT rules in stub mode */
    return -1;
}

int
list_redirect_rule(const char * ifname)
{
    syslog(LOG_INFO, "list_redirect_rule: Stub mode - no rules to list");
    return 0;
}

#ifdef USE_NETFILTER
int set_rdr_name(rdr_name_type param, const char *string)
{
    /* Accept but ignore name settings in stub mode */
    return 0;
}
#endif