#ifdef RTK_NETSNMP_PATCH
/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.old-api.conf 14476 2006-04-18 17:36:51Z hardaker $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include <net-snmp/agent/sysORTable.h>

#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/types.h>

#include <ctype.h>
#if HAVE_UTSNAME_H
#include <utsname.h>
#else
#if HAVE_SYS_UTSNAME_H
#include <sys/utsname.h>
#endif
#endif
#if HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#include "util_funcs.h"
#include "system_mib.h"
#include "struct.h"
#include "sysORTable.h"

#include <libsal/sal_sys.h>
#include <libsal/sal_util.h>
#include <libsal/sal_snmp.h>
#include <libfds/fds_export.h>

/*
 * system_variables_oid:
 *   this is the top level oid that we want to register under.  This
 *   is essentially a prefix, with the suffix appearing in the
 *   variable below.
 */

oid system_variables_oid[] = { 1,3,6,1,2,1,1 };

#define SYSDESCR        1
#define SYSOBJECTID     2
#define SYSUPTIME       3
#define SYSCONTACT      4
#define SYSNAME     5
#define SYSLOCATION     6
#define SYSSERVICES     7
#define SYSORLASTCHANGE     8
#define SYSORINDEX      9
#define SYSORID     10
#define SYSORDESCR      11
#define SYSORUPTIME     12

#define SYS_STRING_LEN      256

char            version_descr[CAPA_SYS_DESC_LEN+128+1] = NETSNMP_VERS_DESC;
char            sysContact[CAPA_SYS_CONTACT_LEN+1] ;
char            sysName[CAPA_SYS_NAME_LEN+1] ;
char            sysLocation[CAPA_SYS_LOCATION_LEN+1];
oid             sysObjectID[MAX_OID_LEN];
size_t          sysObjectIDLength;


extern oid      version_sysoid[];
extern int      version_sysoid_len;

int             sysServices = 79; /*support layer 1,2,3,4,7*/
int             sysServicesConfiged = 0;


oid             system_module_oid[] = { SNMP_OID_SNMPMODULES, 1 };
int             system_module_oid_len =
    sizeof(system_module_oid) / sizeof(oid);
int             system_module_count = 0;

#ifdef USING_MIBII_SYSORTABLE_MODULE
extern u_long             sysORLastChange;
#endif
/*
 * variable4 system_variables:
 *   this variable defines function callbacks and type return information
 *   for the system mib section
 */

struct variable1 system_variables[] = {
/*  magic number        , variable type , ro/rw , callback fn  , L, oidsuffix */
{SYSDESCR,  ASN_OCTET_STR,  RONLY ,  var_system, 1,  { 1 }},

{SYSOBJECTID,  ASN_OBJECT_ID,  RONLY ,  var_system, 1,  { 2 }},

{SYSUPTIME,  ASN_TIMETICKS,  RONLY ,  var_system, 1,  { 3 }},

{SYSCONTACT,  ASN_OCTET_STR,  RWRITE,  var_system, 1,  { 4 }},

{SYSNAME,  ASN_OCTET_STR,  RWRITE,  var_system, 1,  { 5 }},

{SYSLOCATION,  ASN_OCTET_STR,  RWRITE,  var_system, 1,  { 6 }},

{SYSSERVICES,  ASN_INTEGER,  RONLY ,  var_system, 1,  { 7 }},

{SYSORLASTCHANGE,  ASN_TIMETICKS,  RONLY ,  var_system, 1,  { 8 }},

};
/*    (L = length of the oidsuffix) */


/** Initializes the system module */
void
init_system_mib(void)
{
    struct utsname  utsName;

    DEBUGMSGTL(("system", "Initializing\n"));

    /* register ourselves with the agent to handle our mib tree */
    REGISTER_MIB("system", system_variables, variable1,
               system_variables_oid);

     if (++system_module_count == 3)
        REGISTER_SYSOR_ENTRY(system_module_oid,
                             "The MIB module for SNMPv2 entities");

    /* place any other initialization junk you need here */
}

/*
 * var_system():
 *   This function is called every time the agent gets a request for
 *   a scalar variable that might be found within your mib section
 *   registered above.  It is up to you to do the right thing and
 *   return the correct value.
 *     You should also correct the value of "var_len" if necessary.
 *
 *   Please see the documentation for more information about writing
 *   module extensions, and check out the examples in the examples
 *   and mibII directories.
 */
unsigned char *
var_system(struct variable *vp,
                oid     *name,
                size_t  *length,
                int     exact,
                size_t  *var_len,
                WriteMethod **write_method)
{
    /* variables we may use later */
     static u_long   ulret;

    if (header_generic(vp,name,length,exact,var_len,write_method)
                                  == MATCH_FAILED )
    return NULL;

    /*
   * this is where we do the value assignments for the mib results.
   */
    switch(vp->magic) {
    case SYSDESCR:
    {
        sys_sysinfo_t sysinfo;
        char productName[CAPA_SYS_DESC_LEN+128+1];

        SYS_MEM_CLEAR(sysinfo);
        SYS_MEM_CLEAR(productName);

        sal_sys_sysinfo_get(&sysinfo);

        osal_sprintf(productName, "%s, Software Version %s, Boot Version %s",
                sysinfo.description, DFLT_SYS_VER, sysinfo.loaderVer);
        osal_strlcpy(version_descr, productName, sizeof(version_descr));
        *var_len = osal_strlen(version_descr);
        return (u_char *) version_descr;
    }
    case SYSOBJECTID:
        fds_sys_objid_array_get((uint8 *)sysObjectID);
        sysObjectIDLength = SYS_OBJECT_ID_LEN;
        *var_len = sysObjectIDLength * sizeof(sysObjectID[0]);
        return (u_char *)sysObjectID;
    case SYSUPTIME:
        ulret = netsnmp_get_agent_uptime();
        return ((u_char *) & ulret);
    case SYSCONTACT:
        sal_sys_systemContact_get(sysContact);
        *var_len = osal_strlen(sysContact);
        *write_method = write_sysContact;
        return (u_char *) sysContact;
    case SYSNAME:
         sal_sys_systemName_get(sysName);
        *var_len = osal_strlen(sysName);
        *write_method = write_sysName;
        return (u_char *) sysName;
    case SYSLOCATION:
        sal_sys_systemLocation_get(sysLocation);
        *var_len = osal_strlen(sysLocation);
        *write_method = write_sysLocation;
        return (u_char *) sysLocation;
    case SYSSERVICES:
         ulret = sysServices;
        return (u_char *) & ulret;
    case SYSORLASTCHANGE:
       ulret = sysORLastChange;
        return ((u_char *) & ulret);

    default:
        DEBUGMSGTL(("snmpd", "unknown sub-id %d in var_system\n",
                    vp->magic));
    }
    return NULL;
}


int
write_sysContact(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
    char value;
    int size;
    u_char  *cp;
    int count;

    switch ( action ) {
        case RESERVE1:
          if (var_val_type != ASN_OCTET_STR) {
              fprintf(stderr, "write to system not ASN_OCTET_STR\n");
              return SNMP_ERR_WRONGTYPE;
          }
          if (var_val_len > CAPA_SYS_CONTACT_LEN) {
              fprintf(stderr,"write to system: bad length\n");
              return SNMP_ERR_WRONGLENGTH;
          }

          osal_memset(sysContact,0,sizeof(sysContact));
          osal_memcpy(sysContact, var_val, var_val_len);
          SYS_SNMP_ERR_CHK(STRING_VALIDATE(sysContact, TRUE), SNMP_ERR_WRONGVALUE);
          break;

        case RESERVE2:
          size  = var_val_len;
          value = * (char *) var_val;
           osal_memset(sysContact,0,sizeof(sysContact));
           osal_memcpy(sysContact, var_val, var_val_len);
           SYS_SNMP_ERR_CHK(sal_sys_systemContact_set(sysContact), SNMP_ERR_RESOURCEUNAVAILABLE);
          break;

        case FREE:
             /* Release any resources that have been allocated */
          break;

        case ACTION:
             /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
          break;

        case UNDO:
             /* Back out any changes made in the ACTION case */
          break;

        case COMMIT:
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */

#if 0
#ifdef CONFIG_SYS_UI_SNMP
    /* update snmp config file */
            sal_snmp_confFile_update();
#endif
#endif
          break;
    }
    return SNMP_ERR_NOERROR;
}


int
write_sysName(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
    char value;
    int size;
    u_char  *cp;

    switch ( action ) {
        case RESERVE1:
          if (var_val_type != ASN_OCTET_STR) {
              fprintf(stderr, "write to system not ASN_OCTET_STR\n");
              return SNMP_ERR_WRONGTYPE;
          }
          if (var_val_len > CAPA_SYS_NAME_LEN){
              fprintf(stderr,"write to system: bad length\n");
              return SNMP_ERR_WRONGLENGTH;
          }

          osal_memset(sysName,0,sizeof(sysName));
          osal_memcpy(sysName, var_val, var_val_len);
          SYS_SNMP_ERR_CHK(STRING_VALIDATE(sysName, TRUE), SNMP_ERR_WRONGVALUE);
          break;

        case RESERVE2:
          size  = var_val_len;
          value = * (char *) var_val;
           osal_memset(sysName,0,sizeof(sysName));
           osal_memcpy(sysName, var_val, var_val_len);
           SYS_SNMP_ERR_CHK(sal_sys_systemName_set(sysName), SNMP_ERR_RESOURCEUNAVAILABLE);
          break;

        case FREE:
             /* Release any resources that have been allocated */
          break;

        case ACTION:
             /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
          break;

        case UNDO:
             /* Back out any changes made in the ACTION case */
          break;

        case COMMIT:
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */

          break;
    }
    return SNMP_ERR_NOERROR;
}


int
write_sysLocation(int      action,
            u_char   *var_val,
            u_char   var_val_type,
            size_t   var_val_len,
            u_char   *statP,
            oid      *name,
            size_t   name_len)
{
    char value;
    int size;

    switch ( action ) {
        case RESERVE1:
          if (var_val_type != ASN_OCTET_STR) {
              fprintf(stderr, "write to system not ASN_OCTET_STR\n");
              return SNMP_ERR_WRONGTYPE;
          }
          if (var_val_len > CAPA_SYS_LOCATION_LEN) {
              fprintf(stderr,"write to system: bad length\n");
              return SNMP_ERR_WRONGLENGTH;
          }

          osal_memset(sysLocation,0,sizeof(sysLocation));
          osal_memcpy(sysLocation, var_val, var_val_len);
          SYS_SNMP_ERR_CHK(STRING_VALIDATE(sysLocation, TRUE), SNMP_ERR_WRONGVALUE);
          break;

        case RESERVE2:
          size  = var_val_len;
          value = * (char *) var_val;
          osal_memset(sysLocation,0,sizeof(sysLocation));
          osal_memcpy(sysLocation, var_val, var_val_len);
          SYS_SNMP_ERR_CHK(sal_sys_systemLocation_set(sysLocation), SNMP_ERR_RESOURCEUNAVAILABLE);
          break;

        case FREE:
             /* Release any resources that have been allocated */
          break;

        case ACTION:
             /*
              * The variable has been stored in 'value' for you to use,
              * and you have just been asked to do something with it.
              * Note that anything done here must be reversable in the UNDO case
              */
          break;

        case UNDO:
             /* Back out any changes made in the ACTION case */
          break;

        case COMMIT:
             /*
              * Things are working well, so it's now safe to make the change
              * permanently.  Make sure that anything done here can't fail!
              */

          break;
    }

    return SNMP_ERR_NOERROR;
}


#else
/*
 *  System MIB group implementation - system.c
 *
 */
/* Portions of this file are subject to the following copyright(s).  See
 * the Net-SNMP's COPYING file for more details and other copyrights
 * that may apply:
 */
/*
 * Portions of this file are copyrighted by:
 * Copyright � 2003 Sun Microsystems, Inc. All rights reserved.
 * Use is subject to license terms specified in the COPYING file
 * distributed with the Net-SNMP package.
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-features.h>

#if HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif
#include <sys/types.h>

#if HAVE_UTSNAME_H
#include <utsname.h>
#else
#if HAVE_SYS_UTSNAME_H
#include <sys/utsname.h>
#endif
#endif

#if defined(cygwin) || defined(mingw32)
#include <winerror.h>
#endif

#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include <net-snmp/agent/sysORTable.h>

#include "util_funcs.h"
#include "system_mib.h"
#include "updates.h"
#include "agent_global_vars.h"

netsnmp_feature_require(watcher_read_only_int_scalar);

        /*********************
	 *
	 *  Kernel & interface information,
	 *   and internal forward declarations
	 *
	 *********************/

#define SYS_STRING_LEN	256
static char     version_descr[SYS_STRING_LEN] = NETSNMP_VERS_DESC;
static char     sysContact[SYS_STRING_LEN] = NETSNMP_SYS_CONTACT;
static char     sysName[SYS_STRING_LEN] = NETSNMP_SYS_NAME;
static char     sysLocation[SYS_STRING_LEN] = NETSNMP_SYS_LOC;
static oid      sysObjectID[MAX_OID_LEN];
static size_t sysObjectIDByteLength;

static int      sysServices = 72;
static int      sysServicesConfiged = 0;

static int      sysContactSet = 0, sysLocationSet = 0, sysNameSet = 0;

#if (defined (WIN32) && defined (HAVE_WIN32_PLATFORM_SDK)) || defined (mingw32)
static void     windowsOSVersionString(char [], size_t);
#endif

        /*********************
	 *
	 *  snmpd.conf config parsing
	 *
	 *********************/

static void
system_parse_config_string2(const char *token, char *cptr,
                            char* value, size_t size)
{
    if (strlen(cptr) < size) {
        strcpy(value, cptr);
    } else {
        netsnmp_config_error("%s token too long (must be < %lu):\n\t%s",
                             token, (unsigned long)size, cptr);
    }
}

static void
system_parse_config_string(const char *token, char *cptr,
                           const char *name, char* value, size_t size,
                           int* guard)
{
    if (*token == 'p') {
        if (*guard < 0) {
            /*
             * This is bogus (and shouldn't happen anyway) -- the value is
             * already configured read-only.
             */
            snmp_log(LOG_WARNING,
                     "ignoring attempted override of read-only %s.0\n", name);
            return;
        } else {
            *guard = 1;
        }
    } else {
        if (*guard > 0) {
            /*
             * This is bogus (and shouldn't happen anyway) -- we already read a
             * persistent value which we should ignore in favour of this one.
             */
            snmp_log(LOG_WARNING,
                     "ignoring attempted override of read-only %s.0\n", name);
            /*
             * Fall through and copy in this value.
             */
        }
        *guard = -1;
    }

    system_parse_config_string2(token, cptr, value, size);
}

static void
system_parse_config_sysdescr(const char *token, char *cptr)
{
    system_parse_config_string2(token, cptr, version_descr,
                                sizeof(version_descr));
}

static void
system_parse_config_sysloc(const char *token, char *cptr)
{
    system_parse_config_string(token, cptr, "sysLocation", sysLocation,
                               sizeof(sysLocation), &sysLocationSet);
}

static void
system_parse_config_syscon(const char *token, char *cptr)
{
    system_parse_config_string(token, cptr, "sysContact", sysContact,
                               sizeof(sysContact), &sysContactSet);
}

static void
system_parse_config_sysname(const char *token, char *cptr)
{
    system_parse_config_string(token, cptr, "sysName", sysName,
                               sizeof(sysName), &sysNameSet);
}

static void
system_parse_config_sysServices(const char *token, char *cptr)
{
    sysServices = atoi(cptr);
    sysServicesConfiged = 1;
}

static void
system_parse_config_sysObjectID(const char *token, char *cptr)
{
    size_t sysObjectIDLength = MAX_OID_LEN;
    if (!read_objid(cptr, sysObjectID, &sysObjectIDLength)) {
	netsnmp_config_error("sysobjectid token not a parsable OID:\n\t%s",
			     cptr);
        sysObjectIDByteLength = version_sysoid_len  * sizeof(oid);
        memcpy(sysObjectID, version_sysoid, sysObjectIDByteLength);
    } else

		sysObjectIDByteLength = sysObjectIDLength * sizeof(oid);
}


        /*********************
	 *
	 *  Initialisation & common implementation functions
	 *
	 *********************/

oid             system_module_oid[] = { SNMP_OID_SNMPMODULES, 1 };
int             system_module_oid_len = OID_LENGTH(system_module_oid);
int             system_module_count = 0;

static int
system_store(int a, int b, void *c, void *d)
{
    char            line[SNMP_MAXBUF_SMALL];

    if (sysLocationSet > 0) {
        snprintf(line, SNMP_MAXBUF_SMALL, "psyslocation %s", sysLocation);
        snmpd_store_config(line);
    }
    if (sysContactSet > 0) {
        snprintf(line, SNMP_MAXBUF_SMALL, "psyscontact %s", sysContact);
        snmpd_store_config(line);
    }
    if (sysNameSet > 0) {
        snprintf(line, SNMP_MAXBUF_SMALL, "psysname %s", sysName);
        snmpd_store_config(line);
    }

    return 0;
}

static int
handle_sysServices(netsnmp_mib_handler *handler,
                   netsnmp_handler_registration *reginfo,
                   netsnmp_agent_request_info *reqinfo,
                   netsnmp_request_info *requests)
{
#if NETSNMP_NO_DUMMY_VALUES
    if (reqinfo->mode == MODE_GET && !sysServicesConfiged)
        netsnmp_request_set_error(requests, SNMP_NOSUCHINSTANCE);
#endif
    return SNMP_ERR_NOERROR;
}

static int
handle_sysUpTime(netsnmp_mib_handler *handler,
                   netsnmp_handler_registration *reginfo,
                   netsnmp_agent_request_info *reqinfo,
                   netsnmp_request_info *requests)
{
    snmp_set_var_typed_integer(requests->requestvb, ASN_TIMETICKS,
                               netsnmp_get_agent_uptime());
    return SNMP_ERR_NOERROR;
}

void
init_system_mib(void)
{

#ifdef HAVE_UNAME
    struct utsname  utsName;

    uname(&utsName);
    snprintf(version_descr, sizeof(version_descr),
            "%s %s %s %s %s", utsName.sysname,
            utsName.nodename, utsName.release, utsName.version,
            utsName.machine);
    version_descr[ sizeof(version_descr)-1 ] = 0;
#else
#if HAVE_EXECV
    struct extensible extmp;

    /*
     * set default values of system stuff 
     */
    if (asprintf(&extmp.command, "%s -a", UNAMEPROG) < 0)
        extmp.command = NULL;
    /*
     * setup defaults 
     */
    extmp.type = EXECPROC;
    extmp.next = NULL;
    exec_command(&extmp);
    strlcpy(version_descr, extmp.output, sizeof(version_descr));
    if (strlen(version_descr) >= 1)
        version_descr[strlen(version_descr) - 1] = 0; /* chomp new line */
#else
#if (defined (WIN32) && defined (HAVE_WIN32_PLATFORM_SDK)) || defined (mingw32)
    windowsOSVersionString(version_descr, sizeof(version_descr));
#else
    strcpy(version_descr, "unknown");
#endif
#endif
#endif

#ifdef HAVE_GETHOSTNAME
    gethostname(sysName, sizeof(sysName));
#else
#ifdef HAVE_UNAME
    strlcpy(sysName, utsName.nodename, sizeof(sysName));
#else
#if defined (HAVE_EXECV) && !defined (mingw32)
    if (asprintf(&extmp.command, "%s -n", UNAMEPROG) < 0)
        extmp.command = NULL;
    /*
     * setup defaults 
     */
    extmp.type = EXECPROC;
    extmp.next = NULL;
    exec_command(&extmp);
    strlcpy(sysName, extmp.output, sizeof(sysName));
    if (strlen(sysName) >= 1)
        sysName[strlen(sysName) - 1] = 0; /* chomp new line */
#else
    strcpy(sysName, "unknown");
#endif                          /* HAVE_EXECV */
#endif                          /* HAVE_UNAME */
#endif                          /* HAVE_GETHOSTNAME */

#if (defined (WIN32) && defined (HAVE_WIN32_PLATFORM_SDK)) || defined (mingw32)
    {
      HKEY hKey;
      /* Default sysContact is the registered windows user */
      if (RegOpenKeyEx(HKEY_LOCAL_MACHINE,
                       "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", 0,
                       KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS) {
          char registeredOwner[256] = "";
          DWORD registeredOwnerSz = 256;
          if (RegQueryValueEx(hKey, "RegisteredOwner", NULL, NULL,
                              (LPBYTE)registeredOwner,
                              &registeredOwnerSz) == ERROR_SUCCESS) {
              strlcpy(sysContact, registeredOwner, sizeof(sysContact));
          }
          RegCloseKey(hKey);
      }
    }
#endif

    /* default sysObjectID */
    memcpy(sysObjectID, version_sysoid, version_sysoid_len * sizeof(oid));
    sysObjectIDByteLength = version_sysoid_len * sizeof(oid);

    {
        const oid sysDescr_oid[] = { 1, 3, 6, 1, 2, 1, 1, 1 };
        static netsnmp_watcher_info sysDescr_winfo;
        netsnmp_register_watched_scalar(
            netsnmp_create_handler_registration(
                "mibII/sysDescr", NULL, sysDescr_oid, OID_LENGTH(sysDescr_oid),
                HANDLER_CAN_RONLY),
            netsnmp_init_watcher_info(&sysDescr_winfo, version_descr, 0,
				      ASN_OCTET_STR, WATCHER_SIZE_STRLEN));
    }
    {
        const oid sysObjectID_oid[] = { 1, 3, 6, 1, 2, 1, 1, 2 };
        static netsnmp_watcher_info sysObjectID_winfo;
        netsnmp_register_watched_scalar(
            netsnmp_create_handler_registration(
                "mibII/sysObjectID", NULL,
                sysObjectID_oid, OID_LENGTH(sysObjectID_oid),
                HANDLER_CAN_RONLY),
            netsnmp_init_watcher_info6(
		&sysObjectID_winfo, sysObjectID, 0, ASN_OBJECT_ID,
                WATCHER_MAX_SIZE | WATCHER_SIZE_IS_PTR,
                MAX_OID_LEN, &sysObjectIDByteLength));
    }
    {
        const oid sysUpTime_oid[] = { 1, 3, 6, 1, 2, 1, 1, 3 };
        netsnmp_register_scalar(
            netsnmp_create_handler_registration(
                "mibII/sysUpTime", handle_sysUpTime,
                sysUpTime_oid, OID_LENGTH(sysUpTime_oid),
                HANDLER_CAN_RONLY));
    }
    {
        const oid sysContact_oid[] = { 1, 3, 6, 1, 2, 1, 1, 4 };
        static netsnmp_watcher_info sysContact_winfo;
#ifndef NETSNMP_NO_WRITE_SUPPORT
        netsnmp_register_watched_scalar(
            netsnmp_create_update_handler_registration(
                "mibII/sysContact", sysContact_oid, OID_LENGTH(sysContact_oid), 
                HANDLER_CAN_RWRITE, &sysContactSet),
            netsnmp_init_watcher_info(
                &sysContact_winfo, sysContact, SYS_STRING_LEN - 1,
                ASN_OCTET_STR, WATCHER_MAX_SIZE | WATCHER_SIZE_STRLEN));
#else  /* !NETSNMP_NO_WRITE_SUPPORT */
        netsnmp_register_watched_scalar(
            netsnmp_create_update_handler_registration(
                "mibII/sysContact", sysContact_oid, OID_LENGTH(sysContact_oid),
                HANDLER_CAN_RONLY, &sysContactSet),
            netsnmp_init_watcher_info(
                &sysContact_winfo, sysContact, SYS_STRING_LEN - 1,
                ASN_OCTET_STR, WATCHER_MAX_SIZE | WATCHER_SIZE_STRLEN));
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
    }
    {
        const oid sysName_oid[] = { 1, 3, 6, 1, 2, 1, 1, 5 };
        static netsnmp_watcher_info sysName_winfo;
#ifndef NETSNMP_NO_WRITE_SUPPORT
        netsnmp_register_watched_scalar(
            netsnmp_create_update_handler_registration(
                "mibII/sysName", sysName_oid, OID_LENGTH(sysName_oid),
                HANDLER_CAN_RWRITE, &sysNameSet),
            netsnmp_init_watcher_info(
                &sysName_winfo, sysName, SYS_STRING_LEN - 1, ASN_OCTET_STR,
                WATCHER_MAX_SIZE | WATCHER_SIZE_STRLEN));
#else  /* !NETSNMP_NO_WRITE_SUPPORT */
        netsnmp_register_watched_scalar(
            netsnmp_create_update_handler_registration(
                "mibII/sysName", sysName_oid, OID_LENGTH(sysName_oid),
                HANDLER_CAN_RONLY, &sysNameSet),
            netsnmp_init_watcher_info(
                &sysName_winfo, sysName, SYS_STRING_LEN - 1, ASN_OCTET_STR,
                WATCHER_MAX_SIZE | WATCHER_SIZE_STRLEN));
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
    }
    {
        const oid sysLocation_oid[] = { 1, 3, 6, 1, 2, 1, 1, 6 };
        static netsnmp_watcher_info sysLocation_winfo;
#ifndef NETSNMP_NO_WRITE_SUPPORT
        netsnmp_register_watched_scalar(
            netsnmp_create_update_handler_registration(
                "mibII/sysLocation", sysLocation_oid,
                OID_LENGTH(sysLocation_oid),
                HANDLER_CAN_RWRITE, &sysLocationSet),
            netsnmp_init_watcher_info(
		&sysLocation_winfo, sysLocation, SYS_STRING_LEN - 1,
		ASN_OCTET_STR, WATCHER_MAX_SIZE | WATCHER_SIZE_STRLEN));
#else  /* !NETSNMP_NO_WRITE_SUPPORT */
        netsnmp_register_watched_scalar(
            netsnmp_create_update_handler_registration(
                "mibII/sysLocation", sysLocation_oid,
                OID_LENGTH(sysLocation_oid),
                HANDLER_CAN_RONLY, &sysLocationSet),
            netsnmp_init_watcher_info(
		&sysLocation_winfo, sysLocation, SYS_STRING_LEN - 1,
		ASN_OCTET_STR, WATCHER_MAX_SIZE | WATCHER_SIZE_STRLEN));
#endif /* !NETSNMP_NO_WRITE_SUPPORT */
    }
    {
        const oid sysServices_oid[] = { 1, 3, 6, 1, 2, 1, 1, 7 };
        netsnmp_register_read_only_int_scalar(
            "mibII/sysServices", sysServices_oid, OID_LENGTH(sysServices_oid),
            &sysServices, handle_sysServices);
    }
    if (++system_module_count == 3)
        REGISTER_SYSOR_ENTRY(system_module_oid,
                             "The MIB module for SNMPv2 entities");

    sysContactSet = sysLocationSet = sysNameSet = 0;

    /*
     * register our config handlers 
     */
    snmpd_register_config_handler("sysdescr",
                                  system_parse_config_sysdescr, NULL,
                                  "description");
    snmpd_register_config_handler("syslocation",
                                  system_parse_config_sysloc, NULL,
                                  "location");
    snmpd_register_config_handler("syscontact", system_parse_config_syscon,
                                  NULL, "contact-name");
    snmpd_register_config_handler("sysname", system_parse_config_sysname,
                                  NULL, "node-name");
    snmpd_register_config_handler("psyslocation",
                                  system_parse_config_sysloc, NULL, NULL);
    snmpd_register_config_handler("psyscontact",
                                  system_parse_config_syscon, NULL, NULL);
    snmpd_register_config_handler("psysname", system_parse_config_sysname,
                                  NULL, NULL);
    snmpd_register_config_handler("sysservices",
                                  system_parse_config_sysServices, NULL,
                                  "NUMBER");
    snmpd_register_config_handler("sysobjectid",
                                  system_parse_config_sysObjectID, NULL,
                                  "OID");
    snmp_register_callback(SNMP_CALLBACK_LIBRARY, SNMP_CALLBACK_STORE_DATA,
                           system_store, NULL);
}

        /*********************
	 *
	 *  Internal implementation functions - None
	 *
	 *********************/

#if (defined (WIN32) && defined (HAVE_WIN32_PLATFORM_SDK)) || defined (mingw32)
static DWORD RegReadDword(HKEY hKey, LPCTSTR lpSubkey, LPCTSTR lpValueName)
{
    HKEY hSubkey;
    LONG qres;
    DWORD key_type;
    DWORD result = 0;
    DWORD result_len = sizeof(result);

    if (RegOpenKeyEx(hKey, lpSubkey, 0, KEY_READ, &hSubkey) != ERROR_SUCCESS)
        goto out;
    qres = RegQueryValueEx(hSubkey, lpValueName, NULL, &key_type,
                           (void *)&result, &result_len);
    if (qres != ERROR_SUCCESS || key_type != REG_DWORD ||
        result_len != sizeof(DWORD))
        result = 0;
    RegCloseKey(hKey);

out:
    return result;
}

static BOOL RegReadString(HKEY hKey, LPCTSTR lpSubkey, LPCTSTR lpValueName,
                          char *str, DWORD *str_len)
{
    HKEY hSubkey;
    LONG qres;
    DWORD key_type;
    BOOL result = FALSE;

    if (RegOpenKeyEx(hKey, lpSubkey, 0, KEY_READ, &hSubkey) != ERROR_SUCCESS)
        goto out;
    qres = RegQueryValueEx(hSubkey, lpValueName, NULL, &key_type, (void *)str,
			   str_len);
    if (qres == ERROR_SUCCESS && key_type == REG_SZ)
        result = TRUE;
    RegCloseKey(hKey);

out:
    return result;
}

static void
windowsOSVersionString(char stringbuf[], size_t stringbuflen)
{
    /* copy OS version to string buffer in 'uname -a' format */
    static const char wcv[] = "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion";
    char windowsVersion[256] = "?";
    DWORD windowsVersionSz = sizeof(windowsVersion);
    char build[256] = "?";
    DWORD buildSz = sizeof(256);
    DWORD dwMajorVersion;
    DWORD dwMinorVersion;
    char hostname[256] = "?";
    char identifier[256] = "?";
    DWORD identifierSz = sizeof(identifier);

    dwMajorVersion = RegReadDword(HKEY_LOCAL_MACHINE, wcv,
                                  "CurrentMajorVersionNumber");
    dwMinorVersion = RegReadDword(HKEY_LOCAL_MACHINE, wcv,
                                  "CurrentMinorVersionNumber");
    if (!RegReadString(HKEY_LOCAL_MACHINE, wcv, "CurrentBuildNumber",
                       build, &buildSz))
        RegReadString(HKEY_LOCAL_MACHINE, wcv, "CurrentBuild",
                      build, &buildSz);

    gethostname(hostname, sizeof(hostname));

    RegReadString(HKEY_LOCAL_MACHINE, wcv, "ProductName", windowsVersion,
                  &windowsVersionSz);
    RegReadString(HKEY_LOCAL_MACHINE,
                  "HARDWARE\\DESCRIPTION\\System\\CentralProcessor\\0",
                  "Identifier", identifier, &identifierSz);

    /* Output is made to look like results from uname -a */
    snprintf(stringbuf, stringbuflen, "Windows %s %d.%d.%s %s %s",
             hostname, (int)dwMajorVersion, (int)dwMinorVersion, build,
             windowsVersion, identifier);
}
#endif /* WIN32 and HAVE_WIN32_PLATFORM_SDK or mingw32 */
#endif /* RTK_NETSNMP_PATCH */
