OTTO_INC_DIR := arch/otto40/plr/src/include
OTTO_IP_DIR  := arch/otto40/plr/src/soc

OTTO_XENV_H := include/asm/arch/cross_env.h
OTTO_RMU_H  := include/asm/arch/reg_map_util.h

OTTO40_PRJNAME  := 9300_nor_demo

.PHONY: $(OTTO_SOC_H) .otto.v

$(OTTO_SOC_H): otto_arch_sync
	@if [ ! -e $(OTTO_RELEASE_DIR)/conf.h ]; then \
		if [ ! -e $@ ]; then \
			echo "EE: Missing $@" ; \
			exit 1; \
		fi \
	else \
		cmp $@ $(OTTO_RELEASE_DIR)/conf.h > /dev/null 2>&1 ; \
		if [ "$$?" -ne 0 ]; then \
			echo -n "[MISC] Generating $@... " ; \
			sed -e '/^#define USE_ON_FLASH_SECTION$$/d' -e '/^#define .\+SECTION.\+/d' $(OTTO_RELEASE_DIR)/conf.h > $@ ; \
			echo "done" ; \
		fi \
	fi

otto_arch_sync:
	@$(call get_otto_file, $(OTTO_XENV_H),   $(OTTO_INC_DIR)/cross_env.h)
	@$(call get_otto_file, $(OTTO_RMU_H),    $(OTTO_INC_DIR)/reg_map_util.h)
	@$(call get_otto_dir,  $(OTTO_NORSF_G3), $(OTTO_IP_DIR)/nor_spi_gen3)
	@cd ./arch/otto40/include/asm/arch && rm -f nor_spi && ln -s ../../../lib/nor_spi_gen3 nor_spi

