/*
 * Copyright (C) 2009-2016 Realtek Semiconductor Corp.
 * All Rights Reserved.
 *
 * This program is the proprietary software of Realtek Semiconductor
 * Corporation and/or its licensors, and only be used, duplicated,
 * modified or distributed under the authorized license from Realtek.
 *
 * ANY USE OF THE SOFTWARE OTHER THAN AS AUTHORIZED UNDER
 * THIS LICENSE OR COPYRIGHT LAW IS PROHIBITED.
 *
 * $Revision: 79738 $
 * $Date: 2017-06-16 14:34:52 +0800 (Fri, 16 Jun 2017) $
 *
 * Purpose : Define commands for U-Boot
 *
 * Feature : Upgrade loader and runtime commands for U-Boot
 *
 */

/*
 * Include Files
 */
#include <common.h>
#include <command.h>

#include <environment.h>
#include <spi_flash.h>
#include <osal/lib.h>
#include <image.h>
#include <rtk_flash_common.h>
#include <turnkey/sysinfo.h>

#include <rtk/led.h>
#include <hwp/hw_profile.h>
#include <drv/gpio/generalCtrl_gpio.h>
#include <osal/time.h>
#include <uboot/cmd/uboot_cmd.h>

/*
 * Symbol Definition
 */
static int tp_mac_w(char *macStr)
{
    int i = 0;
    int j = 0;
    char macFinal[20];

    if (strlen(macStr) != 12)
        goto invalid_mac;

    osal_memset(macFinal, 0, sizeof(macFinal));

    for (i = 0; i < 12; i++)
    {
        if ((macStr[i] >= '0' && macStr[i] <= '9')
            || (macStr[i] >= 'A' && macStr[i] <= 'F')
            || (macStr[i] >= 'a' && macStr[i] <= 'f'))
        {
            macFinal[j] = macStr[i];
            j++;

            if ((i % 2) == 1 && (i != 11))
            {
                macFinal[j] = ':';
                j++;
            }
        }
        else
        {
            goto invalid_mac;
        }
    }

    printf("Save MAC '%s'\n", macFinal);

    setenv("ethaddr", macFinal);
    saveenv();

    return 0;

invalid_mac:

    return 1;
}

static int tp_mac_r(void)
{
    char *macStr = NULL;

    macStr = getenv("ethaddr");

    printf("%s\n", macStr);

    return 0;
}

static int tp_sn_w(char *snStr)
{
    printf("write SN '%s'\n", snStr);

    setsys("SN", snStr);
    savesys();
    setenv("SN", snStr);
    saveenv();

    return 0;
}

static int tp_sn_r(void)
{
    char *snStr = NULL;

    snStr = getsys("SN");

    printf("%s\n", snStr);

    return 0;
}

#define BUTTON_TEST_TIMEOUT 60
static int _tp_button_monitor(int pin)
{
    uint i = 0;
    uint pinSts = 1;
    uint pressed = 0;
    uint msec = 0;
    uint secPrint = 0;

    for (i = 0; i < (BUTTON_TEST_TIMEOUT * 10); i++)
    {
        rtk_intGpio_pin_get(pin, &pinSts);

        if (!pinSts)
        {
            pressed++;
        }
        else
        {
            if (pressed >= 2)
            {
                if (pressed < 10)
                {
                    printf("%c%c0.%d", 0x8, 0x8, pressed);
                }
                else if (pressed >= 10 && pressed < 19)
                {
                    printf("%c%c%d", 0x8, 0x8, 1);
                }

                printf(" ");

                return 0;
            }
            else
            {
                pressed = 0;
            }
        }

        osal_time_udelay(100000);

        msec++;

        if (pressed >= 2)
        {
            if ((pressed % 10) == 1)
            {
                if (secPrint)
                    printf("%c%c", 0x8, 0x8);

                printf("%2d", (pressed/10));

                secPrint = 1;
            }
        }
        else
        {
            if ((msec % 10) == 1)
            {
                if (secPrint)
                    printf("%c%c", 0x8, 0x8);

                printf("%2d", (BUTTON_TEST_TIMEOUT - (msec/10)));

                secPrint = 1;
            }
        }
    }

    if (secPrint)
        printf("%c%c", 0x8, 0x8);

    return 1;
}

static int tp_button_test(void)
{
    int ret = 0;

    printf("waiting button 'Reset' ... ");
    if (_tp_button_monitor(9))
    {
        printf("FAIL\n");
        ret = 1;
    }
    else
    {
        printf("SUCCESS\n");
    }

    printf("waiting button 'Factory Default' ... ");
    if (_tp_button_monitor(12))
    {
        printf("FAIL\n");
        ret = 1;
    }
    else
    {
        printf("SUCCESS\n");
    }

    printf("waiting button 'LED Mode' ... ");
    if (_tp_button_monitor(22))
    {
        printf("FAIL\n");
        ret = 1;
    }
    else
    {
        printf("SUCCESS\n");
    }

    return ret;
}

static int __mw(char *addr, char *val, char *num)
{
    cmd_tbl_t *run;
    char *argu[5];

    run = find_cmd("mw");
    if (NULL == run) {
        printf("mw command is not supported!\n");
        return 1;
    }
    argu[0] = "mw";
    argu[1] = addr;
    argu[2] = val;
    argu[3] = num;
    argu[4] = NULL;

    if (NULL == num)
        return run->cmd(run, 0, 3, argu);
    else
        return run->cmd(run, 0, 4, argu);
}
#define MW(addr, val) __mw(addr, val, NULL)
#define MW_MULTI(addr, val, num) __mw(addr, val, num)
static int _led_init = 0;
static void _tp_led_swctrl(int enable)
{
    int isPort28 = 0;

    if (HWP_IDENTIFIER_ID() == HWP_GS728TPv2 || HWP_IDENTIFIER_ID() == HWP_GS728TPPv2)
        isPort28 = 1;

    if (enable)
    {
        if (isPort28)
        {
            MW_MULTI("0xbb00012c", "0x3fffffff", "5");
        }
        else
        {
            MW_MULTI("0xbb00012c", "0x3fffffff", "5");
            MW("0xbb000140", "0x0000003f");
        }
    }
    else
    {
        MW_MULTI("0xbb00012c", "0x0", "6");
    }

    return;
}

static int tp_led_port(char *mode)
{
    int isPort28 = 0;

    if (HWP_IDENTIFIER_ID() == HWP_GS728TPv2 || HWP_IDENTIFIER_ID() == HWP_GS728TPPv2)
        isPort28 = 1;

    if (!_led_init)
    {
        MW("0xbb0000e4", "0x0070f568");
        MW("0xbb0000e8", "0x00000000");
        MW("0xbb0000ec", "0x00007dea");

        printf("board id = %d\n", HWP_IDENTIFIER_ID());

        if (isPort28)
        {
            MW("0xbb000110", "0x00ffffff");
            MW("0xbb000114", "0x00000000");
            MW("0xbb000118", "0x0f000000");
            MW("0xbb00011c", "0x00000000");
            MW("0xbb000120", "0x0f000000");
            MW("0xbb000124", "0x00000000");
        }
        else
        {
            MW("0xbb000110", "0xffffffff");
            MW("0xbb000114", "0x0000ffff");
            MW("0xbb000118", "0x00000000");
            MW("0xbb00011c", "0x000f0000");
            MW("0xbb000120", "0x00000000");
            MW("0xbb000124", "0x000f0000");
        }

        _led_init = 1;
    }

    if (mode[0] == 'g')
    {
        _tp_led_swctrl(1);
        if (isPort28)
            MW_MULTI("0xbb000144", "0x7", "28");
        else
            MW_MULTI("0xbb000144", "0x7", "52");
        MW("0xbb000128", "1");
        printf("PORT_LED: 'GREEN'\n");
    }
    else if (mode[0] == 'a')
    {
        /* amber */
        if (strlen(mode) >= 2 && mode[1] == 'm')
        {
            _tp_led_swctrl(1);
            if (isPort28)
                MW_MULTI("0xbb000144", "0x38", "28");
            else
                MW_MULTI("0xbb000144", "0x38", "52");
            MW("0xbb000128", "1");
            printf("PORT_LED: 'AMBER'\n");
        }
        /* auto */
        else
        {
            _tp_led_swctrl(0);
        }
    }
    else if (mode[0] == 'o')
    {
        _tp_led_swctrl(1);
        if (isPort28)
            MW_MULTI("0xbb000144", "0", "28");
        else
            MW_MULTI("0xbb000144", "0", "52");
        MW("0xbb000128", "1");
        printf("PORT_LED: 'OFF'\n");
    }
    else
    {
        printf("PORT_LED: NOT SUPPORT\n");
    }

    return 0;
}

static int tp_led_sys(char *mode)
{
    if (mode[0] == 'g')
    {
        drv_generalCtrlGPIO_dataBit_set(0, GEN_GPIO_DEV_ID1, 8, 1); /* Power LED */
        drv_generalCtrlGPIO_dataBit_set(0, GEN_GPIO_DEV_ID1, 10, 1); /* LED Mode */

        printf("SYS_LED: 'GREEN'\n");
    }
    else if (mode[0] == 'a')
    {
        drv_generalCtrlGPIO_dataBit_set(0, GEN_GPIO_DEV_ID1, 8, 0); /* Power LED */
        drv_generalCtrlGPIO_dataBit_set(0, GEN_GPIO_DEV_ID1, 10, 0); /* LED Mode */

        printf("SYS_LED: 'AMBER'\n");
    }
    else
    {
        printf("SYS_LED: NOT SUPPORT\n");
    }

    return 0;
}

static int _mac_read(char *buf)
{
    char c;
    uint idx = 0;

    while (1)
    {
        c = getc();

        if (c == '\r')
        {
            if (strlen(buf) == 12)
                return 0;
            else
                return 1;
        }

        if (c == 0x8) /* backspace */
        {
            if (idx > 0)
            {
                idx--;
                buf[idx] = 0x0;
                printf("\33[2K\r");
                printf("%s", buf);
            }
        }

        if (idx > 11)
            continue;

        if ((c >= '0' && c <= '9')
            || (c >= 'A' && c <= 'F')
            || (c >= 'a' && c <= 'f'))
        {
            putc(c);

            buf[idx] = c;
            idx++;
        }
    }

    return 0;
}

#define TP_SN_LEN 32
static int _sn_read(char *buf)
{
    char c;
    uint idx = 0;

    while (1)
    {
        c = getc();

        if (c == '\r')
        {
            if (strlen(buf) <= TP_SN_LEN)
                return 0;
            else
                return 1;
        }

        if (c == 0x8) /* backspace */
        {
            if (idx > 0)
            {
                idx--;
                buf[idx] = 0x0;
                printf("\33[2K\r");
                printf("%s", buf);
            }
        }

        if (idx >= TP_SN_LEN)
            continue;

        if ((c >= ' ' && c <= '~'))
        {
            putc(c);

            buf[idx] = c;
            idx++;
        }
    }

    return 0;
}


static int tp_run(int step)
{
    uint retry = 3;
    uint i = 0;
    uint j = 0;
    char c = 0;
    char macStr[13];
    char snStr[TP_SN_LEN];
    char *value = NULL;

    memset(macStr, 0, sizeof(macStr));
    memset(snStr, 0, sizeof(snStr));

    if (0 == step)
    {
        printf("\n");
        printf("**************\n");
        printf("** Start TP **\n");
        printf("**************\n");
    }

    /* MAC */
    if (0 == step || 1 == step)
    {
        printf("\n");
        printf("@@@@@@@@@\n");
        printf("@@ MAC @@\n");
        printf("@@@@@@@@@\n");

        printf("###### Write MAC\n");
        printf("Please enter your MAC:\n");
        while (retry > 0)
        {
            if (_mac_read(macStr))
            {
                retry--;
            }
            else
            {
                printf("\n");
                if (tp_mac_w(macStr))
                    goto fail;
                break;
            }

            if (retry == 0)
                goto fail;
        }

        printf("###### Read MAC ");
        value = getenv("ethaddr");
        printf("'%s'\n", value);

        printf("###### Compare MAC\n");
        j = 0;
        for (i = 0; i < 12; i++)
        {
            if (macStr[i] != value[j])
            {
                printf("[%s != %s]\n", macStr, value);
                goto fail;
            }

            j++;

            if ((i % 2) == 1)
                j++;
        }
        printf("[SUCCESS]\n");
    }

    /* SN */
    if (0 == step || 2 == step)
    {
        printf("\n");
        printf("@@@@@@@@\n");
        printf("@@ SN @@\n");
        printf("@@@@@@@@\n");

        printf("###### Write SN\n");
        printf("Please enter your SN:\n");
        while (retry > 0)
        {
            if (_sn_read(snStr))
            {
                retry--;
            }
            else
            {
                printf("\n");
                if (tp_sn_w(snStr))
                    goto fail;

                break;
            }
        }

        printf("###### Read SN ");
        value = getsys("SN");
        printf("'%s'\n", value);

        printf("###### Compare SN\n");
        if (0 != strcmp(snStr, value))
        {
            printf("%s != %s\n", snStr, value);
            goto fail;
        }
        printf("[SUCCESS]\n");
    }

    /* Button */
    if (0 == step || 3 == step)
    {
        printf("\n");
        printf("@@@@@@@@@@@@@@@@@\n");
        printf("@@ BUTTON TEST @@\n");
        printf("@@@@@@@@@@@@@@@@@\n");

        if (tp_button_test())
            goto fail;
    }


    /* LED - SYS */
    if (0 == step || 4 == step)
    {
        printf("\n");
        printf("\n");
        printf("@@@@@@@@@@@@@\n");
        printf("@@ SYS LED @@\n");
        printf("@@@@@@@@@@@@@\n");

        tp_led_sys("green");
        printf("Press any key for yes and 'n' for no: ");
        c = getc();
        printf("\33[2K\r");
        if ('n' == c)
            goto fail;

        tp_led_sys("amber");
        printf("Press any key for yes and 'n' for no: ");
        c = getc();
        printf("\33[2K\r");
        if ('n' == c)
            goto fail;

        printf("[SUCCESS]\n");
    }

    /* LED - Port */
    if (0 == step || 5 == step)
    {
        printf("\n");
        printf("@@@@@@@@@@@@@@\n");
        printf("@@ PORT LED @@\n");
        printf("@@@@@@@@@@@@@@\n");

        tp_led_port("green");
        printf("Press any key for yes and 'n' for no: ");
        c = getc();
        printf("\33[2K\r");
        if ('n' == c)
            goto fail;

        tp_led_port("amber");
        printf("Press any key for yes and 'n' for no: ");
        c = getc();
        printf("\33[2K\r");
        if ('n' == c)
            goto fail;

        tp_led_port("off");
        printf("Press any key for yes and 'n' for no: ");
        c = getc();
        printf("\33[2K\r");
        if ('n' == c)
            goto fail;

        tp_led_port("auto");

        printf("[SUCCESS]\n");
    }

    if (0 == step)
    {
        printf("\n");
        printf("*****************\n");
        printf("** ALL SUCCESS **\n");
        printf("*****************\n");
    }

    return 0;

fail:
    printf("[FAIL]\n");

    if (0 == step)
    {
        printf("\n");
        printf("**********\n");
        printf("** FAIL **\n");
        printf("**********\n");
    }
    return 1;
}

int do_tp (cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
    if (argc <= 1)
        goto show_usage;

    /* tp run [(mac|sn|button|sysled|portled)] */
    if (argv[1][0] == 'r')
    {
        if (argc == 2)
        {
            tp_run(0);
        }
        else if (argc == 3)
        {
            if (argv[2][0] == 'm')
                tp_run(1);
            else if (argv[2][0] == 's' && argv[2][1] == 'n')
                tp_run(2);
            else if (argv[2][0] == 'b')
                tp_run(3);
            else if (argv[2][0] == 's' && argv[2][1] == 'y')
                tp_run(4);
            else if (argv[2][0] == 'p')
                tp_run(5);
            else
                goto show_usage;
        }
        else
        {
            goto show_usage;
        }
    }
    /* tp mac w XXXXXXXXXXXX
       tp mac r               */
    else if (argv[1][0] == 'm')
    {
        if (argc <= 2)
            goto show_usage;

        if (argv[2][0] == 'w')
        {
            if (argc <= 3)
                goto show_usage;

            tp_mac_w(argv[3]);
        }
        else if (argv[2][0] == 'r')
        {
            tp_mac_r();
        }
        else
        {
            goto show_usage;
        }
    }
    /* tp sn w SN
       tp sn r    */
    else if (argv[1][0] == 's')
    {
        if (argc <= 2)
            goto show_usage;

        if (argv[2][0] == 'w')
        {
            if (argc <= 3)
                goto show_usage;

            tp_sn_w(argv[3]);
        }
        else if (argv[2][0] == 'r')
        {
            tp_sn_r();
        }
        else
        {
            goto show_usage;
        }
    }
    /* tp button test */
    else if (argv[1][0] == 'b')
    {
        if (argc <= 2)
            goto show_usage;

        if (argv[2][0] == 't')
        {
            tp_button_test();
        }
        else
        {
            goto show_usage;
        }
    }
    /* tp led port (green|amber|off)
       tp led sys (green|amber)      */
    else if (argv[1][0] == 'l')
    {
        if (argc <= 2)
            goto show_usage;

        if (argv[2][0] == 'p')
        {
            if (argc <= 3)
                goto show_usage;

            tp_led_port(argv[3]);
        }
        else if (argv[2][0] == 's')
        {
            if (argc <= 3)
                goto show_usage;

            tp_led_sys(argv[3]);
        }
        else
        {
            goto show_usage;
        }
    }
    else
    {
        goto show_usage;
    }

    return 0;

show_usage:
    return cmd_usage(cmdtp);
}

U_BOOT_CMD(
    tp, 4, 0, do_tp,
    "Mass production TP",
    #if 0
    "run [(mac|sn|button|sysled|portled)]\n" \
    "    * run full procedure of TP\n" \
    "      - mac:     run MAC write and check\n" \
    "      - sn:      run SN write and check\n" \
    "      - button:  run button test\n" \
    "      - sysled:  run system LED test\n" \
    "      - portled: run port LED test\n" \
    "tp mac w XXXXXXXXXXXX\n" \
    "    * write MAC address\n" \
    "      - XXXXXXXXXXXX: MAC address\n" \
    "tp mac r\n" \
    "    * read MAC address\n" \
    "tp sn w SN\n" \
    "    * write serial number\n" \
    "      - SN: serial number\n" \
    "tp sn r\n" \
    "    * read serial number\n" \
    "tp button test\n" \
    "    * run button test procedure\n" \
    "tp led port (green|amber|off|auto)\n" \
    "    * set led mode of all ports\n" \
    "      - green: turn on all ports led with greeen\n" \
    "      - amber: turn on all ports led with amber\n" \
    "      - off:   turn off all ports led\n" \
    "tp led sys (green|amber)\n" \
    "    * set led mode of system leds\n" \
    "      - green: turn on system leds with greeen\n" \
    "      - amber: turn on system leds with amber\n" \
    ""
    #else
    ""
    #endif
);


