#include <soc.h>
#include <dram/memcntlr.h>
#include <cg/cg.h>

#ifndef SECTION_CG
#define SECTION_CG
#endif
#ifndef SECTION_CG_INFO
#define SECTION_CG_INFO
#endif

#define _MEM_FREQ(ncode, fcode, pdiv)  (25*(ncode+3+(fcode/2048))/(pdiv))
#define _NCODE(freq, pdiv)      ((((freq)*(pdiv))/25)-3)
#define MEM_FREQ(ncode, fcode)  _MEM_FREQ(ncode, fcode, 1)
#define NCODE(freq)             _NCODE(freq, 1)
#define FCODE(freq)             ((((freq*1000)/25-(freq/25)*1000)*2046)+999)/1000


u32_t cg_guery_mem_freq(void) {
    /* FIXME */
    return 0;
}

#ifndef PROJECT_ON_FPGA

#define MEM_PLL_CTL3_400_500    (0x40505254)
#define MEM_PLL_CTL3_500_600    (0x42D05374)
#define MEM_PLL_CTL3_600_725    (0x42D05475)
#define MEM_PLL_CTL3_725_850    (0x45505475)
//

extern cg_info_t cg_info_query SECTION_CG_INFO;

UTIL_FAR SECTION_CG
u32_t mem_pll_init(cg_config_t *c) {

    u32_t n_code = NCODE(cg_info_query.dev_freq.mem_mhz);
    u32_t f_code = FCODE(cg_info_query.dev_freq.mem_mhz);
    u32_t pll_ctl3;

    u32_t f = MEM_FREQ(n_code, f_code);
    printf("DD: setting memory freq. is %d %d(n:%d, f:%d)\n", f, cg_info_query.dev_freq.mem_mhz, n_code, f_code);
    if (f>=400 && f<500) {
        pll_ctl3 = MEM_PLL_CTL3_400_500;
    } else if (f>=500 && f<600) {
        pll_ctl3 = MEM_PLL_CTL3_500_600;
    } else if (f>=600 && f<725) {
        pll_ctl3 = MEM_PLL_CTL3_600_725;
    } else if (f>=725 && f<850) {
        pll_ctl3 = MEM_PLL_CTL3_725_850;
    } else {
        return 1;
    }

    /* Enable clk for dcphy and pll reg */
    RMOD_DPI_DLL(reg_clken_dcphy, 0x1, reg_clken_pllreg, 0x1);

    /* PLL LDO Enable */
    //RMOD_CRT_RST_CTL(ptr_rst_n, 0, rst_n, 1, pll_ssc_dig_rst_n, 0, pll_ldo_rst_n, 0);
    RMOD_CRT_RST_CTL(rst_n, 1);
    udelay(1000);

    /* apply PLL setting */
    PLL_CTL3rv = pll_ctl3;
    RMOD_SSC3(dpi_n_code_t, n_code);
    RMOD_SSC2(dpi_f_code_t, f_code);

    /*  DCC initial value setting */
    DCC_DQS_0_T dcc_initv = {.v = DCC_DQS_0rv};
    dcc_initv.f.dpi_dcc_dqs_duty_sel = 0x0;
    dcc_initv.f.dpi_dcc_dqs_dsp_stop = 0x1;
    dcc_initv.f.dpi_dcc_dqs_div = 0x3;
    dcc_initv.f.dpi_dcc_dqs_int_gain = 0x1;
    dcc_initv.f.dpi_dcc_dqs_duty = 0x28;
    dcc_initv.f.dpi_dcc_dqs_duty_presetb = 0x3;
    dcc_initv.f.dpi_dcc_dqs_duty_preseta = 0x3;

    DCC_DQS_0rv = dcc_initv.v; //DQS0 close loop mode
    DCC_DQS_1rv = dcc_initv.v; //DQS1 close loop mode
    DCC_DQS_2rv = dcc_initv.v; //DQS2 close loop mode
    DCC_DQS_3rv = dcc_initv.v; //DQS3 close loop mode
    DCC_DQ_0rv  = dcc_initv.v; //DQ0 close loop mode
    DCC_DQ_1rv  = dcc_initv.v; //DQ1 close loop mode
    DCC_DQ_2rv  = dcc_initv.v; //DQ2 close loop mode
    DCC_DQ_3rv  = dcc_initv.v; //DQ3 close loop mode
    DCC_CK_0rv  = dcc_initv.v; //DCK close loop mode
    DCC_CK_1rv  = dcc_initv.v; //DCK close loop mode
    DCC_CMDrv   = dcc_initv.v; //CMD close loop mode
    DCC_CSrv    = dcc_initv.v; //CS close loop mode
    DCC_CS1rv   = dcc_initv.v; //CS1 close loop mode

    /* DPI initial value setting */
    #define __DQS_PI 0x1
    #define __DQ_PI  0x8

    RMOD_PLL_PI0(dpi_post_pi_sel3, __DQS_PI,\
                 dpi_post_pi_sel2, __DQS_PI,\
                 dpi_post_pi_sel0, 0x6);
    RMOD_PLL_PI1(dpi_post_pi_sel6, __DQ_PI,\
                 dpi_post_pi_sel5, __DQS_PI,\
                 dpi_post_pi_sel4, __DQS_PI);    //dpi_post_pi_sel6 = 'h8
    RMOD_PLL_PI2(dpi_post_pi_sel7, __DQ_PI,\
                 dpi_post_pi_sel8, __DQ_PI,\
                 dpi_post_pi_sel9, __DQ_PI);    //dpi_post_pi_sel7/8/9 = 'h8
    // !! If the value of dpi_post_pi_sel* >15, set oesync_op_sel[*] = 1

    /* delay DQ/DQS nT */
    #define __DQS_DQ_DELAY    0x2;
    RMOD_AFIFO_STR_0(dqs_rd_str_num_3, __DQS_DQ_DELAY,\
                     dq_rd_str_num_3,  __DQS_DQ_DELAY,\
                     dqs_rd_str_num_2, __DQS_DQ_DELAY,\
                     dq_rd_str_num_2,  __DQS_DQ_DELAY,\
                     dqs_rd_str_num_1, __DQS_DQ_DELAY,\
                     dq_rd_str_num_1,  __DQS_DQ_DELAY,\
                     dqs_rd_str_num_0, __DQS_DQ_DELAY,\
                     dq_rd_str_num_0,  __DQS_DQ_DELAY);

    /* mode & pin mux setting (choose one mode) */
    // before dram setting, read from strapped pin
    u32_t dt = RFLD_PSR0(pin_dramtype);
    u8_t pmld3, pmd3;
    pmld3 = dt>>1;
    pmd3 = !(dt&0x1);
    /* DDR4: 0b00, DDR3: 0b01, LPDDR3: 0b10 */
    RMOD_CRT_CTL(pin_mux_ddr3, pmd3, pin_mux_lpddr3, pmld3);

    // Set pll_ssc_dig_rst_n  = 1'b1
    //RMOD_CRT_RST_CTL(ptr_rst_n, 1, rst_n, 0, pll_ssc_dig_rst_n, 1, pll_ldo_rst_n, 1);
    //udelay(1);
    // Set ptr_rst_n = 1'b0
    RMOD_CRT_RST_CTL(ptr_rst_n, 0, rst_n, 0, pll_ssc_dig_rst_n, 1, pll_ldo_rst_n, 1);
    // Set rst_n = 1'b1 & ptr_rst_n = 1'b1
    RMOD_CRT_RST_CTL(ptr_rst_n, 1, rst_n, 1, pll_ssc_dig_rst_n, 1, pll_ldo_rst_n, 1);
    udelay(1000);

    // OC_EN 0->1
    RMOD_SSC3(dpi_oc_en, 0x1);
    udelay(1000);
    // OC_EN 1->0, ensure N_code, F_code load successfully
    RMOD_SSC3(dpi_oc_en, 0x0);
    // Flag_initial =1
    RMOD_SSC0(dpi_ssc_flag_init, 0x1);

    /* Turn on clock flow */
    RMOD_PLL_CTL4(dpi_dly_sel, 0, dpi_dly_sel_ck1, 0, dpi_en_post_pi, 0x3FFF);
    //  pll_clk_en,  ICG_clk_en (????)
    //RMOD_PLL_CTL0(dpi_pll_clk_en, 0x1FFF, dpi_mck_clk_en, 0x1C3F);
    RMOD_PLL_CTL0(dpi_pll_clk_en, 0x1FFF, dpi_mck_clk_en, 0x1FFF);
    //  clk_oe
    RMOD_PLL_CTL1(dpi_clk_oe, 0x7);
    // check pll_stable (bit0)  if ==1 (stable)  ( CHIP_TOP register ) (FIXME!!!)
    // 0 or 1 is stable? figure out!!!
    u32_t cnt=0;
    while(1==RFLD_DPI_DLL(pll_stable)) {
        if (++cnt>0x100000) break;
    }

    // level shift enable(3.3v)
    REG32(0xBB000410) = 0x1;
    udelay(1000);

    // set force rst_n = 0
    RMOD_CRT_CTL(force_rstn, 0);
    udelay(1000);
    // set data_pre[21] =1'b1(better DQ timing)
    RMOD_DPI_CTRL_0(data_pre, 1);
    // set en_dcc[31] = 1'b1 , pd_ck[30] 1=1'b0
    RMOD_PAD_BUS_0(en_dcc, 1, pd_ck, 0);
    udelay(1000);

    return 0;
}

//REG_INIT_FUNC(mem_pll_init,           14);
#endif
