#ifndef _MEMCNTLR_UTIL_
#define _MEMCNTLR_UTIL_

#ifndef MEMCNTLR_SECTION
#define MEMCNTLR_SECTION
#endif

#ifndef MEMCNTLR_DATA_SECTION
#define MEMCNTLR_DATA_SECTION
#endif

#define _X_OCD_ODT(ocd, odt)    ((ocd)<<16)|(odt)

#define DBG_PRINTF(...)         printf("DD: "__VA_ARGS__)
#define ERR_PRINTF(...)         printf("EE: "__VA_ARGS__)
#define WARN_PRINTF(...)        printf("WW: "__VA_ARGS__)
#define INFO_PRINTF(...)        printf("II: "__VA_ARGS__)


u32_t cg_query_freq(u32_t);
#define GET_MEM_MHZ() cg_query_freq(1)

#define DDR_TYPE_SPIN       (0)
#define DDR_TYPE_DDR3       (3)
#define DDR_TYPE_DDR4       (4)
#define DDR_TYPE_LPDDR3     (11)

#define DDR_ZQ_TYPE_CMD     (0)
#define DDR_ZQ_TYPE_DQS_DQ  (1)

enum {
    zq_dq_odt_sel=0,
    zq_dq_ocd_sel,
    zq_dqs_p_odt_sel,
    zq_dqs_n_odt_sel,
    zq_dqs_ocd_sel,
    zq_cke_ocd_sel,
    zq_adr_ocd_sel,
    zq_ck_ocd_sel,
    zq_end_sel
};

MEMCNTLR_SECTION void mc_info_probe(void);
MEMCNTLR_SECTION void mc_info_translation(void);
MEMCNTLR_SECTION void mc_info_to_reg(void);
MEMCNTLR_SECTION void mc_cntlr_zq_calibration(void);
MEMCNTLR_SECTION void mc_calibration(void);
MEMCNTLR_SECTION void mc_result_decode(void);
MEMCNTLR_SECTION u32_t r480_calibration(void);
MEMCNTLR_SECTION u32_t zq_calibration(u32_t ocd_odt[]);

#include <init_result_helper.h>

INIT_RESULT_GROUP(probe,
                  MEM_PROBE_UNINIT,
                  MEM_PROBE_OK,
                  MEM_PROBE_FAIL,
                  MEM_PROBE_FUNC_MISSING);

INIT_RESULT_GROUP(xlat,                  
                  MEM_XLAT_UNINIT,
                  MEM_XLAT_OK,
                  MEM_DRAM_TYPE_ERROR,
                  MEM_BANK_NUM_ERROR,
                  MEM_BUS_WIDTH_ERROR,
                  MEM_ROW_NUM_ERROR,
                  MEM_PAGE_SIZE_ERROR,
                  MEM_BL_ERROR,
                  MEM_REF_NUM_ERROR,
                  MEM_DFI_RATE_ERROR,
                  MEM_RTTNOM_ERROR,
                  MEM_RTTWR_ERROR
                  );

INIT_RESULT_GROUP(cntlr_zq,
                  MEM_CNTLR_ZQ_R480_UNINIT,
                  MEM_CNTLR_R480_TIMEOUT,
                  MEM_CNTLR_ZQ_TIMEOUT,                  
                  MEM_CNTLR_R480_ERROR,
                  MEM_CNTLR_ZQ_ERROR,
                  MEM_CNTLR_ZQ_R480_OK);

INIT_RESULT_GROUP(to_reg,
                  MEM_TO_REG_UNINIT,
                  MEM_TO_REG_OK);

INIT_RESULT_GROUP(cal,
                  MEM_CAL_UNINIT,
                  MEM_CAL_OK,
                  MEM_CAL_FAIL);

/* BSTC */
#ifndef PACKED
#define PACKED          __attribute__ ((packed))
#endif

#define RXI310_BUS_WIDTH     (128)
#define RXI310_DQ_WIDTH      (16)	// FIXME, 32
// maximum bank, row, column support bit
#define RXI310_MAX_BANK_BIT  (4)     //4
#define RXI310_MAX_ROW_BIT   (17)    //17
#define RXI310_MAX_COL_BIT   (11)

#define BSTC_BASE            (0xBF800000)
#define BSTC_SRAM_CMD_BASE   (BSTC_BASE)
#define BSTC_SRAM_CMD_BUSW   (RXI310_MAX_BANK_BIT+RXI310_MAX_ROW_BIT+(RXI310_MAX_COL_BIT+1)+4+1)           // BusWidth=BANK+ROW+COL(DQ32 need +1)+BST_LEN+CMD
#define BSTC_SRAM_CMD_ENTY   (32)
#define BSTC_SRAM_CMD_SIZE   (SRAM_CMD_ENTY*SRAM_CMD_BUSW)

#define BSTC_SRAM_MSK_BASE   (BSTC_BASE+0x01000)
#define BSTC_SRAM_MSK_BUSW   (16)
#define BSTC_SRAM_MSK_ENTY   (32)
#define BSTC_SRAM_MSK_SIZE   (SRAM_MSK_ENTY*SRAM_MSK_BUSW)

#define BSTC_SRAM_WD_BASE    (BSTC_BASE+0x03800)
#define BSTC_SRAM_WD_BUSW    (128)
#define BSTC_SRAM_WD_ENTY    (128)
#define BSTC_SRAM_WD_SIZE    (SRAM_WD_BUSW*SRAM_WD_ENTY)

#define BSTC_SRAM_RG_BASE    (BSTC_BASE+0x0C000)
#define BSTC_SRAM_RG_BUSW    (128)
#define BSTC_SRAM_RG_ENTY    (128)
#define BSTC_SRAM_RG_SIZE    (SRAM_RG_BUSW*SRAM_RG_ENTY)

#define BSTC_SRAM_RD_BASE    (BSTC_BASE+0x14800)
#define BSTC_SRAM_RD_BUSW    (128)
#define BSTC_SRAM_RD_ENTY    (128)
#define BSTC_SRAM_RD_SIZE    (SRAM_RD_BUSW*SRAM_RD_ENTY)

#define BSTC_WR_CMD          (1)
#define BSTC_RD_CMD          (0)

// BSTC UTIL
#define BSTC_CMD_WRITE(addr, data)   REG32((addr))     = data.v[1];\
                                     REG32((addr+0x4)) = data.v[0];
                                
#define BSTC_VA2COL(info, addr) (((addr)&((1<<info.col_size)-1))>>4)
#define BSTC_VA2BNK(info, addr) (((addr)>>(info.col_size))&((1<<info.bnk_size)-1))
#define BSTC_VA2ROW(info, addr) (((addr)&0xFFFFFFF)>>(info.col_size+info.bnk_size))

#define BSTC_PA2COL(info, addr) (((addr)&((1<<info.col_size)-1))>>4)
#define BSTC_PA2BNK(info, addr) (((addr)>>(info.col_size))&((1<<info.bnk_size)-1))
#define BSTC_PA2ROW(info, addr) ((addr)>>(info.col_size+info.bnk_size))

#define get_col_size() ({ 8+RFLD_MISC(page_size); })
#define get_bnk_size() ({ 1+RFLD_MISC(bank_size); })

typedef union {
    struct {
        unsigned int dummy:(64-BSTC_SRAM_CMD_BUSW) PACKED;
        unsigned int bank:(RXI310_MAX_BANK_BIT) PACKED;
        unsigned int row:(RXI310_MAX_ROW_BIT) PACKED;
        unsigned int col:(RXI310_MAX_COL_BIT+1) PACKED;
        unsigned int bl:(4) PACKED;
        unsigned int cmd:(1) PACKED;
    }f;
    unsigned int v[2];
} BSTC_CMD_T;

typedef struct {
    unsigned int bnk_size;
    unsigned int col_size;
    unsigned int wr_ent_cnt;
    unsigned int rd_ent_cnt;
} BSTC_INFO_T;

#define mc_disable_bstc()  RMOD_CSR(bstc_idle, 1, mem_idle, 0)

typedef struct {
    unsigned int v;
    unsigned int z;
} ZQ_XLAT_T;

//#define PRINT_REG(reg)  printf("DD: (0x%08X)=0x%08X\n", reg##ar, reg##rv)
//#define PRINT_REG(reg)  

// assume: cache line size: 4 ways * 32Byte
#define UNROLLING_MCPY_128BYTE(src, dst)    ({  \
            *(dst)    = *(src);             \
            *(dst+8)  = *(src+8);           \
            *(dst+16) = *(src+16);          \
            *(dst+24) = *(src+24);          \
            *(dst+1)  = *(src+1);           \
            *(dst+2)  = *(src+2);           \
            *(dst+3)  = *(src+3);           \
            *(dst+4)  = *(src+4);           \
            *(dst+5)  = *(src+5);           \
            *(dst+6)  = *(src+6);           \
            *(dst+7)  = *(src+7);           \
            *(dst+9)  = *(src+9);           \
            *(dst+10) = *(src+10);          \
            *(dst+11) = *(src+11);          \
            *(dst+12) = *(src+12);          \
            *(dst+13) = *(src+13);          \
            *(dst+14) = *(src+14);          \
            *(dst+15) = *(src+15);          \
            *(dst+17) = *(src+17);          \
            *(dst+18) = *(src+18);          \
            *(dst+19) = *(src+19);          \
            *(dst+20) = *(src+20);          \
            *(dst+21) = *(src+21);          \
            *(dst+22) = *(src+22);          \
            *(dst+23) = *(src+23);          \
            *(dst+25) = *(src+25);          \
            *(dst+26) = *(src+26);          \
            *(dst+27) = *(src+27);          \
            *(dst+28) = *(src+28);          \
            *(dst+29) = *(src+29);          \
            *(dst+30) = *(src+30);          \
            *(dst+31) = *(src+31);          })            

#endif
