#ifndef _MEMCNTLR_H_
#define _MEMCNTLR_H_

#include <soc.h>
#include <register_map.h>
#include <dram/memcntlr_util.h>

typedef union {
	struct {
		u16_t mbz_0:3;
		u16_t fast_exit_en:1;
		u16_t wr:3;
		u16_t dll_reset:1;
		u16_t test_mode_en:1;
		u16_t cl_h:3;
		u16_t rd_interleave:1;
		u16_t cl_l:1;
		u16_t burst_len:2;
	} f;
	u16_t v;
} ddr3_mr0;

typedef union {
	struct {
		u16_t mbz_0:3;
		u16_t output_buf_dis:1;
		u16_t tdqs_en:1;
		u16_t mbz_1:1;
		u16_t rtt_nom_h:1;
		u16_t mbz_2:1;
		u16_t write_lvl_en:1;
		u16_t rtt_nom_m:1;
		u16_t output_drv_imp_ctl_h:1;
		u16_t al:2;
		u16_t rtt_nom_l:1;
		u16_t output_drv_imp_ctl_l:1;
		u16_t dll_dis:1;
	} f;
	u16_t v;
} ddr3_mr1;

typedef union {
	struct {
		u16_t mbz_0:5;
		u16_t rtt_wr:2;
		u16_t mbz_1:1;
		u16_t ext_temp_range_en:1;
		u16_t auto_self_ref_en:1;
		u16_t cwl:3;
		u16_t partial_ary_self_ref:3;
	} f;
	u16_t v;
} ddr3_mr2;

typedef union {
	struct {
		u16_t mbz_0:13;
		u16_t mpr_en:1;
		u16_t mpr_pattern:2;
	} f;
	u16_t v;
} ddr3_mr3;

typedef struct {
    /* MISC */
    unsigned int dram_type:3;
    unsigned int bankcnt:5;
    unsigned int pagesize:16;
    unsigned int rowcnt:5;
    unsigned int burst:6;
    /* DRR */
    unsigned int ref_num:4;
    unsigned int min_tref_ns:16;       //tREF,  unit is "ns"
    unsigned int min_trfc_ns:10;       //tRFC,  unit is "ns"
    /* TPR0 */
    unsigned int min_tzqcs_tck:10;     //tZQCS, unit is "tCK"
    unsigned int min_tcke_ns:10;       //tCKE,  unit is "ns"
    unsigned int min_trtp_ns:10;       //tRTP,  unit is "ns"
    unsigned int min_twr_ns:10;        //tWR,   unit is "ns"
    unsigned int min_tras_ns:10;       //tRAS,  unit is "ns"
    unsigned int min_trp_ns:10;        //tRP,   unit is "ns"
    /* TPR1 */
    unsigned int min_tfaw_ns:10;       //tFAW,  unit is "ns"
    unsigned int min_trtw_tck:10;      //tRTW,  unit is "tCK"
    unsigned int min_twtr_ns:10;       //tWTR,  unit is "ns"
    unsigned int min_tccd_tck:10;      //tCCD,  unit is "tCK"
    unsigned int min_trcd_ns:10;       //tRCD,  unit is "ns"
    unsigned int min_trc_ns:10;        //tRC,   unit is "ns"
    unsigned int min_trrd_ns:10;       //tRRD,  unit is "ns"
    /* TPR2 */
    unsigned int min_tmrd_tck:10;      //tMRD,  unit is "tCK"
    /* TPR3 (for DDR4) */
    unsigned int min_tccd_r_tck:10;    //tCCD_R, unit is "tCK"
    unsigned int min_twtr_s_ns:10;     //tWTR_S, unit is "ns"
    unsigned int min_tccd_s_tck:10;    //tCCD_S, unit is "tCK"
    unsigned int min_dpin_cmd_lat:10;  //DPIN_CMD_LAT, tCAL?, unit is "tCK"
    /* MR_INFO */
    unsigned int add_lat:4;            //add_lat
    unsigned int rd_lat:4;             //rd_lat
    unsigned int wr_lat:4;             //wr_lat
} mc_dram_param_t;

typedef struct {
    /* CCR */
    unsigned int flush_fifo:1;          // for FLUSH_FIFO
    unsigned int dpit_en:1;             // for DPIT
    unsigned int btt_en:1;              // for BTT
    unsigned int init:1;                // for INIT
    /* DCR */
    unsigned int dq32_en:2;             // for HALF_DQ and DQ_32
    unsigned int dfi_rate:3;            // for DFI_RATE
    unsigned int zqc_en:1;              // for ZQC
    unsigned int rank2_en:1;            // for RANK2 (CS)
    unsigned int gear_down:1;           // for enable geardown function (DDR4)
    unsigned int dbi:1;                 // for enable dbi funciotn (DDR4)
    /* IOCR */
    unsigned int tphy_rdata:8;          // for TPHY_RDATA_EN
    unsigned int tphy_wlat:8;           // for TPHY_WLAT
    unsigned int tphy_wdata:8;          // for TPHY_WDATA
    unsigned int stc_odt_en:1;          // for STC_ODT
    unsigned int stc_cke_en:1;          // for STC_CKE
    /* CSR */
    unsigned int bstc_idle:1;           // for BSTC_IDLE
    unsigned int mem_idle:1;            // for MEM_IDLE
    /* DRR */
    unsigned int zqcl_inv:4;
    unsigned int ref_dis:1;
    /* backward*/
    unsigned int rttnom;
    unsigned int rttwr;
} mc_cntlr_opt_t;

typedef struct {
    unsigned int rzq_ext:1;              // R480 calibration enable
    unsigned int dzq_auto_up:1;          // zq auto update
    // for dq31~dq0 and dqs3~dqs0
    unsigned int ocd_odt[8];
    unsigned int dpi_long_cali:1;
    unsigned int dck_pi:5;
    unsigned int dqs_pi:5;
    unsigned int dq_pi:5;
    unsigned int cs_pi:5;
} mc_dpi_opt_t;

typedef struct {
	CCR_T ccr;
	DCR_T dcr;
	IOCR_T iocr;
	CSR_T csr;
	DRR_T drr;
	TPR0_T tpr0;
	TPR1_T tpr1;
	TPR2_T tpr2;
	TPR3_T tpr3;
	MR0_T mr0;
	MR1_T mr1;
	MR2_T mr2;
	MR3_T mr3;
	MR_INFO_T mrinfo;
	MISC_T misc;
	PAD_CTRL_PROG_T pcpr;
	PAD_CTRL_ZPROG_0_T zprog0;
	PAD_CTRL_ZPROG_1_T zprog1;
	PAD_CTRL_ZPROG_2_T zprog2;
	PAD_CTRL_ZPROG_3_T zprog3;
	PAD_CTRL_ZPROG_4_T zprog4;
	PAD_CTRL_ZPROG_5_T zprog5;
	PAD_CTRL_ZPROG_6_T zprog6;
	PAD_CTRL_ZPROG_7_T zprog7;
} mc_register_set_t;


typedef struct {
	mc_dram_param_t   *dram_param;
	mc_cntlr_opt_t    *cntlr_opt;
	mc_dpi_opt_t	  *dpi_opt;
	mc_register_set_t *register_set;
} mc_info_t;

#endif
