//#include <string.h>
#include <soc.h>
#include <dram/memcntlr.h>
#include <cli/cli_util.h>
#include <cli/cli_access.h>

#ifndef SECTION_CLI_ACCESS
#define SECTION_CLI_ACCESS
#endif

// Re-Probe dram information
cli_cmd_ret_t
cli_ddr_probe(const void *user, u32_t argc, const char *argv[]){
	mc_info_probe();
	puts("II: Probed ddr info\n");
	return CCR_OK;
}

cli_add_node(ddr_probe, call, cli_ddr_probe);
cli_add_help(ddr_probe, "call ddr_probe");

cli_cmd_ret_t
cli_ddr_setup(const void *user, u32_t argc, const char *argv[]) {
	mem_pll_init();
	mc_info_translation();
	mc_info_to_reg();
	mc_cntlr_zq_calibration();
	mc_calibration();
	mc_result_decode();
	return CCR_OK;
}

cli_cmd_ret_t
cli_ddr_calibration(const void *user, u32_t argc, const char *argv[]) {
        dpi_calibration();
        return CCR_OK;
}

cli_add_node(ddr_k, call, cli_ddr_calibration);
cli_add_help(ddr_k, "call ddr_k");


cli_cmd_ret_t
cli_cache_flush(const void *user, u32_t argc, const char *argv[]) {
	_soc.bios.dcache_writeback_invalidate_all();
	return CCR_OK;
}

cli_add_node(cache_flush, call, cli_cache_flush);
cli_add_help(cache_flush, "cache_flush");

#define DRAM_INFO	((mc_info_t *)(_soc.dram_info))
#define DRAM_INFO_R     (DRAM_INFO->register_set)
#define DRAM_INFO_O     (DRAM_INFO->cntlr_opt)
#define DRAM_INFO_P     (DRAM_INFO->dram_param)

#define DEFINE_DDR_INT_VAR(name, family, is_dec, get_func_body, set_func_body) \
	SECTION_CLI_VAR int _CLI_VAR_DDR_ ## name ## _get_int_(u32_t *result) {get_func_body; return 0;} \
	SECTION_CLI_VAR int _CLI_VAR_DDR_ ## name ## _set_int_(u32_t value) {set_func_body; return 0;} \
	CLI_DEFINE_VAR(name, family, 1, 0, is_dec, \
	               _CLI_VAR_DDR_ ## name ## _get_int_, \
	               _CLI_VAR_DDR_ ## name ## _set_int_)

//#define DEFINE_DDR_STR_VAR(name, get_func_body, set_func_body)
#define DEFINE_DDR_STR_VAR(name, family, get_func_body, set_func_body)  \
	SECTION_CLI_VAR int _CLI_VAR_DDR_ ## name ## _get_str_(char *result) {get_func_body; return 0;} \
	SECTION_CLI_VAR int _CLI_VAR_DDR_ ## name ## _set_str_(const char *value) {set_func_body; return 0;} \
	CLI_DEFINE_VAR(name, family, 1, 0, 0, \
	               _CLI_VAR_DDR_ ## name ## _get_str_, \
	               _CLI_VAR_DDR_ ## name ## _set_str_)

#define DEFINE_DDR_INT_VAR_P_INT(var) 	  DEFINE_DDR_INT_VAR(var, ddr, 1, \
	                     {*result=DRAM_INFO_P->var; }, \
	                     {DRAM_INFO_P->var=value;})

#define DEFINE_DDR_INT_VAR_O_INT(var) 	  DEFINE_DDR_INT_VAR(var, ddr, 1, \
	                     {*result=DRAM_INFO_O->var; }, \
	                     {DRAM_INFO_O->var=value;})

#define DEFINE_DDR_INT_VAR_O_ARY(var,idx) DEFINE_DDR_INT_VAR(var##_##idx, ddr, 1, \
                                                             {*result=DRAM_INFO_O->var[idx]; }, \
                                                             {DRAM_INFO_O->var[idx]=value;})

#define DEFINE_DDR_INT_VAR_R_HEX(var)	  DEFINE_DDR_INT_VAR(var, ddr_reg, 0, \
	                     {*result=DRAM_INFO_R->var.v; }, \
	                     {DRAM_INFO_R->var.v=value;})

#define DEFINE_DDR_INT_VAR_R_ARY(var,idx) DEFINE_DDR_INT_VAR(var##_##idx, ddr_reg, 0, \
                                                             {*result=DRAM_INFO_R->var[idx].v; }, \
                                                             {DRAM_INFO_R->var[idx].v=value;})

cli_add_node(ddr, get, VZERO);
cli_add_parent(ddr, set);
cli_add_node(ddr_reg, get, VZERO);
cli_add_parent(ddr_reg, set);

// DRAM Parameters
DEFINE_DDR_INT_VAR_P_INT(dram_type);
DEFINE_DDR_INT_VAR_P_INT(bankcnt);
DEFINE_DDR_INT_VAR_P_INT(pagesize);
DEFINE_DDR_INT_VAR_P_INT(burst);
DEFINE_DDR_INT_VAR_P_INT(ref_num);
DEFINE_DDR_INT_VAR_P_INT(min_tref_ns);
DEFINE_DDR_INT_VAR_P_INT(min_trfc_ns);
DEFINE_DDR_INT_VAR_P_INT(min_tzqcs_tck);
DEFINE_DDR_INT_VAR_P_INT(min_tcke_ns);
DEFINE_DDR_INT_VAR_P_INT(min_trtp_ns);
DEFINE_DDR_INT_VAR_P_INT(min_twr_ns);
DEFINE_DDR_INT_VAR_P_INT(min_tras_ns);
DEFINE_DDR_INT_VAR_P_INT(min_trp_ns);
DEFINE_DDR_INT_VAR_P_INT(min_tfaw_ns);
DEFINE_DDR_INT_VAR_P_INT(min_trtw_tck);
DEFINE_DDR_INT_VAR_P_INT(min_twtr_ns);
DEFINE_DDR_INT_VAR_P_INT(min_tccd_tck);
DEFINE_DDR_INT_VAR_P_INT(min_trcd_ns);
DEFINE_DDR_INT_VAR_P_INT(min_trc_ns);
DEFINE_DDR_INT_VAR_P_INT(min_trrd_ns);
DEFINE_DDR_INT_VAR_P_INT(min_tmrd_tck);
DEFINE_DDR_INT_VAR_P_INT(min_tccd_r_tck);
DEFINE_DDR_INT_VAR_P_INT(min_twtr_s_ns);
DEFINE_DDR_INT_VAR_P_INT(min_tccd_s_tck);
DEFINE_DDR_INT_VAR_P_INT(min_dpin_cmd_lat);
DEFINE_DDR_INT_VAR_P_INT(add_lat);
DEFINE_DDR_INT_VAR_P_INT(rd_lat);
DEFINE_DDR_INT_VAR_P_INT(wr_lat);

// Control Option
DEFINE_DDR_INT_VAR_O_INT(flush_fifo);
DEFINE_DDR_INT_VAR_O_INT(dpit_en);
DEFINE_DDR_INT_VAR_O_INT(btt_en);
DEFINE_DDR_INT_VAR_O_INT(init);
DEFINE_DDR_INT_VAR_O_INT(dq32_en);
DEFINE_DDR_INT_VAR_O_INT(dfi_rate);
DEFINE_DDR_INT_VAR_O_INT(zqc_en);
DEFINE_DDR_INT_VAR_O_INT(rank2_en);
DEFINE_DDR_INT_VAR_O_INT(tphy_rdata);
DEFINE_DDR_INT_VAR_O_INT(tphy_wlat);
DEFINE_DDR_INT_VAR_O_INT(tphy_wdata);
DEFINE_DDR_INT_VAR_O_INT(stc_odt_en);
DEFINE_DDR_INT_VAR_O_INT(stc_cke_en);
DEFINE_DDR_INT_VAR_O_INT(bstc_idle);
DEFINE_DDR_INT_VAR_O_INT(mem_idle);
DEFINE_DDR_INT_VAR_O_INT(zqcl_inv);
DEFINE_DDR_INT_VAR_O_INT(ref_dis);
//DEFINE_DDR_INT_VAR_O_INT(mr0);
//DEFINE_DDR_INT_VAR_O_INT(mr1);
//DEFINE_DDR_INT_VAR_O_INT(mr2);
//DEFINE_DDR_INT_VAR_O_INT(mr3);

// Register Set
DEFINE_DDR_INT_VAR_R_HEX(ccr);
DEFINE_DDR_INT_VAR_R_HEX(dcr);
DEFINE_DDR_INT_VAR_R_HEX(iocr);
DEFINE_DDR_INT_VAR_R_HEX(csr);
DEFINE_DDR_INT_VAR_R_HEX(drr);
DEFINE_DDR_INT_VAR_R_HEX(tpr0);
DEFINE_DDR_INT_VAR_R_HEX(tpr1);
DEFINE_DDR_INT_VAR_R_HEX(tpr2);
DEFINE_DDR_INT_VAR_R_HEX(tpr3);
DEFINE_DDR_INT_VAR_R_HEX(mr0);
DEFINE_DDR_INT_VAR_R_HEX(mr1);
DEFINE_DDR_INT_VAR_R_HEX(mr2);
DEFINE_DDR_INT_VAR_R_HEX(mr3);
DEFINE_DDR_INT_VAR_R_HEX(mrinfo);
DEFINE_DDR_INT_VAR_R_HEX(misc);
