#ifndef __GLB_PLL_H__
#define __GLB_PLL_H__


typedef union {
	struct {
		unsigned int mbz0:17; //reserved and don't care 
		unsigned int cpu_clk_sel:1; 
		unsigned int nor_clk_sel:1; 
		unsigned int lxb_clk_sel:1;
		unsigned int mbz1:1;
		unsigned int cpu_pll_rdy:1;
        unsigned int mbz2:4;    
        unsigned int en_pll:6;
        
	} f;
	unsigned int v;
} PLL_GLB_CTRL_T;
#define PLL_GLB_CTRLrv (*((regval)0xBB00D900))
#define PLL_GLB_CTRLdv (0x0000003F)
#define RMOD_PLL_GLB_CTRL(...) rset(PLL_GLB_CTRL, PLL_GLB_CTRLrv, __VA_ARGS__)
#define RIZS_PLL_GLB_CTRL(...) rset(PLL_GLB_CTRL, 0, __VA_ARGS__)
#define RFLD_PLL_GLB_CTRL(fld) (*((const volatile PLL_GLB_CTRL_T *)0xBB00D900)).f.fld

typedef union {
	struct {
		unsigned int mbz0:4; //reserved and don't care 
		unsigned int cmu_test_en_cpu:1; 
		unsigned int cmu_divn3_cpu:2; 
		unsigned int cpu_cmu_fcode_in:13;
		unsigned int cpu_cmu_ncode_in:8;
		unsigned int cpu_cmu_bypass_pi:1;
        unsigned int cpu_cmu_sel_div4:1;    
        unsigned int cpu_cmu_sel_prediv:2;        
	} f;
	unsigned int v;
} PLL_CPU_CTRL0_T;
#define PLL_CPU_CTRL0rv (*((regval)0xBB00D904))
#define PLL_CPU_CTRL0dv (0x020002E8)
#define RMOD_PLL_CPU_CTRL0(...) rset(PLL_CPU_CTRL0, PLL_CPU_CTRL0rv, __VA_ARGS__)
#define RIZS_PLL_CPU_CTRL0(...) rset(PLL_CPU_CTRL0, 0, __VA_ARGS__)
#define RFLD_PLL_CPU_CTRL0(fld) (*((const volatile PLL_CPU_CTRL0_T *)0xBB00D904)).f.fld

typedef union {
	struct {
		unsigned int cpu_cmu_en_ssc:1;
		unsigned int cpu_cmu_step_in:13;
		unsigned int cpu_cmu_tbase_in:12;
		unsigned int cpu_cmu_ssc_order:1;
		unsigned int cpu_cmu_time2_rst_width:2;
		unsigned int cpu_cmu_time0_ck:3;
	} f;
	unsigned int v;
} PLL_CPU_CTRL1_T;
#define PLL_CPU_CTRL1rv (*((regval)0xBB00D908))
#define PLL_CPU_CTRL1dv (0x0514C38B)
#define RMOD_PLL_CPU_CTRL1(...) rset(PLL_CPU_CTRL1, PLL_CPU_CTRL1rv, __VA_ARGS__)
#define RIZS_PLL_CPU_CTRL1(...) rset(PLL_CPU_CTRL1, 0, __VA_ARGS__)
#define RFLD_PLL_CPU_CTRL1(fld) (*((const volatile PLL_CPU_CTRL1_T *)0xBB00D908)).f.fld

typedef union {
	struct {
		unsigned int mbz0:1;
		unsigned int cpu_cmu_en:1;
		unsigned int cpu_cmu_clkrdy:2;
		unsigned int cpu_cmu_config:21;
        unsigned int reg_cmu_divn2_cpu:3;
        unsigned int reg_cmu_divn2_dll:3;
        unsigned int cpu_cmu_en_dll:1;
	} f;
	unsigned int v;
} PLL_CPU_MISC_CTRL_T;
#define PLL_CPU_MISC_CTRLrv (*((regval)0xBB00D90C))
#define PLL_CPU_MISC_CTRLdv (0x5A33EE13)
#define RMOD_PLL_CPU_MISC_CTRL(...) rset(PLL_CPU_MISC_CTRL, PLL_CPU_MISC_CTRLrv, __VA_ARGS__)
#define RIZS_PLL_CPU_MISC_CTRL(...) rset(PLL_CPU_MISC_CTRL, 0, __VA_ARGS__)
#define RFLD_PLL_CPU_MISC_CTRL(fld) (*((const volatile PLL_CPU_MISC_CTRL_T *)0xBB00D908)).f.fld

typedef union {
	struct {
		unsigned int mbz0:6; //reserved and don't care 
		unsigned int cmu_test_en_sw:1; 
		unsigned int sw_cmu_fcode_in:13;
		unsigned int sw_cmu_ncode_in:8;
		unsigned int sw_cmu_bypass_pi:1;
        unsigned int sw_cmu_sel_div4:1;    
        unsigned int sw_cmu_sel_prediv:2;        
	} f;
	unsigned int v;
} PLL_SW_CTRL0_T;
#define PLL_SW_CTRL0rv (*((regval)0xBB00D910))
#define PLL_SW_CTRL0dv (0x000002E8)
#define RMOD_PLL_SW_CTRL0(...) rset(PLL_SW_CTRL0, PLL_SW_CTRL0rv, __VA_ARGS__)
#define RIZS_PLL_SW_CTRL0(...) rset(PLL_SW_CTRL0, 0, __VA_ARGS__)
#define RFLD_PLL_SW_CTRL0(fld) (*((const volatile PLL_SW_CTRL0_T *)0xBB00D910)).f.fld

typedef union {
	struct {
        unsigned int mbz0:6;
		unsigned int sw_cmu_en_ssc:1;
		unsigned int sw_cmu_step_in:13;
		unsigned int sw_cmu_tbase_in:12;
	} f;
	unsigned int v;
} PLL_SW_CTRL1_T;
#define PLL_SW_CTRL1rv (*((regval)0xBB00D914))
#define PLL_SW_CTRL1dv (0x0134F30E)
#define RMOD_PLL_SW_CTRL1(...) rset(PLL_SW_CTRL1, PLL_SW_CTRL1rv, __VA_ARGS__)
#define RIZS_PLL_SW_CTRL1(...) rset(PLL_SW_CTRL1, 0, __VA_ARGS__)
#define RFLD_PLL_SW_CTRL1(fld) (*((const volatile PLL_SW_CTRL1_T *)0xBB00D914)).f.fld

typedef union {
	struct {
		unsigned int mbz0:3;
		unsigned int sw_cmu_config:29;
	} f;
	unsigned int v;
} PLL_SW_MISC_CTRL_T;
#define PLL_SW_MISC_CTRLrv (*((regval)0xBB00D918))
#define PLL_SW_MISC_CTRLdv (0x05B467DC)
#define RMOD_PLL_SW_MISC_CTRL(...) rset(PLL_SW_MISC_CTRL, PLL_SW_MISC_CTRLrv, __VA_ARGS__)
#define RIZS_PLL_SW_MISC_CTRL(...) rset(PLL_SW_MISC_CTRL, 0, __VA_ARGS__)
#define RFLD_PLL_SW_MISC_CTRL(fld) (*((const volatile PLL_SW_MISC_CTRL_T *)0xBB00D918)).f.fld

typedef union {
	struct {
		unsigned int mbz0:14;
        unsigned int sw_cmu_en:1;
		unsigned int cmu_divn2_spi_nor:4;
        unsigned int cmu_divn2_lxb:4;
        unsigned int cmu_divn2_sw:4;
        unsigned int cmu_divn2_gphy:4;
        unsigned int en_gphy_dbg_pll:1;
	} f;
	unsigned int v;
} PLL_SW_DIV_CTRL_T;
#define PLL_SW_DIV_CTRLrv (*((regval)0xBB00D91C))
#define PLL_SW_DIV_CTRLdv (0x00028826)
#define RMOD_PLL_SW_DIV_CTRL(...) rset(PLL_SW_DIV_CTRL, PLL_SW_DIV_CTRLrv, __VA_ARGS__)
#define RIZS_PLL_SW_DIV_CTRL(...) rset(PLL_SW_DIV_CTRL, 0, __VA_ARGS__)
#define RFLD_PLL_SW_DIV_CTRL(fld) (*((const volatile PLL_SW_DIV_CTRL_T *)0xBB00D91C)).f.fld

#endif // CPU_LX_PLL_H
