#include <dram/memcntlr.h>
#include <util.h>
#include <cg/cg.h>
#include <plr_sections.h>

#define SECTION_PROBEINFO __attribute__ ((section (".parameters")))

#undef _soc

#ifndef SECTION_SOC
    #define SECTION_SOC      __attribute__ ((section (".sdata.soc_stru")))
#endif

extern init_table_entry_t start_of_init_func_table, end_of_init_func_table;
extern symbol_table_entry_t start_of_symble_table, end_of_symble_table;
extern void writeback_invalidate_dcache_all(void);
extern void writeback_invalidate_dcache_range(u32_t base_addr, u32_t end_addr);
extern void invalidate_icache_all(void);
extern void invalidate_icache_range(u32_t base_addr, u32_t end_addr);

#ifndef PLR_VERSION
    #define PLR_VERSION 0
#endif

soc_t _soc SECTION_SOC = {
    .bios={
        .header= {
            .signature=SIGNATURE_PLR,
            .export_symb_list=&start_of_symble_table,
            .end_of_export_symb_list=&end_of_symble_table,
            .init_func_list=&start_of_init_func_table,
            .end_of_init_func_list=&end_of_init_func_table,
        },
        .isr=VZERO,
        .size_of_plr_load_firstly=0,
        .uart_putc=VZERO,
        .uart_getc=VZERO,
        .uart_tstc=VZERO,
        .dcache_writeback_invalidate_all=&writeback_invalidate_dcache_all,
        .dcache_writeback_invalidate_range=&writeback_invalidate_dcache_range,
        .icache_invalidate_all=&invalidate_icache_all,
        .icache_invalidate_range=&invalidate_icache_range,
    },
};

const mc_dram_param_t ddr3_database_para SECTION_PROBEINFO = {
    #include "dram_models/nanya_NT5CC256M16EP-EK.h"
};

const mc_cntlr_opt_t ddr3_cntlr_opt SECTION_PROBEINFO = {
    /* CCR */
    .flush_fifo     = 0,
    .dpit_en        = 0,
    .btt_en         = 0,
    .init           = 1,
    /* DCR */
    .dq32_en        = 0,    // half DQ, 0: DQ16, 1: DQ32, 2:  from strapped pin
    .dfi_rate       = 2,    // dfi ratio 2:1
    .zqc_en         = 0,
    .rank2_en       = 0,
    /* IOCR */
    .tphy_rdata     = 2,    // smallest value is 1
    .tphy_wlat      = 0,
    .tphy_wdata     = 2,    // smallest value is 1
    .stc_odt_en     = 0,
    .stc_cke_en     = 0,
    /* CSR */
    .bstc_idle      = 1,
    .mem_idle       = 0,
    /* DRR */
    .zqcl_inv       = 0,
    .ref_dis        = 0,
    /* PHY */
    .rttnom         = 60,
    .rttwr          = 0,
};

const mc_dpi_opt_t ddr3_dpi_opt SECTION_PROBEINFO = {
    .rzq_ext        = 1,    // internal R480 enable
    .dzq_auto_up    = 1,    // Auto Update
    .ocd_odt        = { _X_OCD_ODT(120, 60),
                        _X_OCD_ODT(120, 60),
                        _X_OCD_ODT(120, 60),
                        _X_OCD_ODT(120, 60),
                        _X_OCD_ODT(120, 60),
                        _X_OCD_ODT(120, 60),
                        _X_OCD_ODT(120, 60),
                        _X_OCD_ODT(120, 60),
                      },
    // add data_pre
};

const mc_register_set_t regset SECTION_PROBEINFO = {
    .ccr.v      = CCRdv,
    .dcr.v      = DCRdv,
    .iocr.v     = IOCRdv,
    .csr.v      = CSRdv,
    .tpr0.v     = TPR0dv,
    .tpr1.v     = TPR1dv,
    .tpr2.v     = TPR2dv,
    .tpr3.v     = TPR3dv,
    .mr0.v      = MR0dv,
    .mr1.v      = MR1dv,
    .mr2.v      = MR2dv,
    .mr3.v      = MR3dv,
};


const mc_info_t mi[] SECTION_PROBEINFO = {
	{(mc_dram_param_t *)&ddr3_database_para,
	 (mc_cntlr_opt_t *)&ddr3_cntlr_opt,
	 (mc_dpi_opt_t *)&ddr3_dpi_opt,
	 (mc_register_set_t *)&regset},
};

MEMCNTLR_SECTION
const mc_info_t *
proj_mc_info_select(void) {
	return &mi[0];
}


u32_t uart_baud_rate  = 115200;
const cg_info_t cg_info_proj SECTION_PROBEINFO = {
	.dev_freq ={
		.cpu_mhz  = 1000,
		.mem_mhz  = 800,
		.lx_mhz   = 200,
		.spif_mhz = 25,
	},
};

symb_fdefine(SF_SYS_UDELAY, otto_sys_udelay);
symb_fdefine(SF_SYS_QUERY_FREQ, cg_query_freq);


