/* dhcpc.h */
#ifndef _DHCPC_H
#define _DHCPC_H

#include "autoconf.h"

#define INIT_SELECTING	0
#define REQUESTING	1
#define BOUND		2
#define RENEWING	3
#define REBINDING	4
#define INIT_REBOOT	5
#define RENEW_REQUESTED 6
#define RELEASED	7


struct client_config_t {
	char foreground;		/* Do not fork */
	char quit_after_lease;		/* Quit after obtaining lease */
	char abort_if_no_lease;		/* Abort if no lease */
	char *interface;		/* The name of the interface to use */
	char *pidfile;			/* Optionally store the process ID */
	char *script;			/* User script to run at dhcp events */
	unsigned char *clientid;	/* Optional client id to use */
	unsigned char *hostname;	/* Optional hostname to use */
	unsigned char *domain_name;	/* Optional domain_name to use */
	int ifindex;			/* Index number of the interface to use */
	unsigned char mtu[4];      /* MTU */
	char *vendorid;   /* vendor id */
	unsigned char arp[6];		/* Our arp address */
	unsigned char Infacearp[6];		/* Our inerface arp address */
  unsigned char defroute; /* 0=> No Route;1=> Install Route */
  #ifdef ENABLE_OPT42
  unsigned char ntpsvr_req; /* 0=> NTP Server not requested;1=> NTP Server requested */
  #endif
/*    Modify by Zhengmingming  2012-07-19
  
*/
  #ifdef ENABLE_OPT57
  unsigned char maximum[4]; /* Maximum message size */
  #endif
};

extern struct client_config_t client_config;


#endif
