#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>
#include <errno.h>
#include <linux/if_ether.h>


#define BUFLEN 256
#define PORT 8000

typedef struct ngr_msg_T{       
    unsigned char  Dmac[6];  
	unsigned char  Smac[6];
	unsigned short proto;
	unsigned char  Msg[1500];
}ngr_msg;


typedef struct ip_hdr{        // ipv4 header 
    unsigned int ip_length:4; // little-endian 
    unsigned int ip_version:4; 
    unsigned char ip_tos; 
    unsigned short ip_total_length; 
    unsigned short ip_id; 
    unsigned short ip_flags; 
    unsigned char ip_ttl; 
    unsigned char ip_protocol; 
    unsigned short ip_cksum; 
    unsigned int ip_source; 
    unsigned int ip_dest; 
}ip_hdr;

typedef struct udp_hdr{       // udp header 
    unsigned short s_port;
    unsigned short d_port;
    unsigned short length;
    unsigned short cksum;
}udp_hdr;

typedef struct psd_header{   // persuade header for checksum
    unsigned int s_ip;       //source ip
    unsigned int d_ip;       //dest ip
    unsigned char mbz;       //0
    unsigned char proto;     //proto type
    unsigned short plen;     //length
}psd_header;

//void swap(unsigned int *a, unsigned int *b)// nutual change
//{
//    *a = (*a)^(*b);
//    *b = (*a)^(*b);
//    *a = (*a)^(*b);
//}

unsigned short checksum(unsigned short* buffer, int size)//for checksum
{
    unsigned long cksum = 0;
    while(size>1)
    {
        cksum += *buffer++;
        size -= sizeof(unsigned short);
    }
    if(size)
    {
        cksum += *(unsigned char*)buffer;
    }
        cksum = (cksum>>16) + (cksum&0xffff); //upper 16 bits add lower 16 bits
        cksum += (cksum>>16);                
    return (unsigned short)(~cksum);
}
#if 0
int main(int argc, char *argv[])
{
    int i = 0;
    int sockfd = -1;
	ngr_msg ngr_detect_msg;
    printf("__________%s___%d_____\n",__FUNCTION__,__LINE__);
    struct sockaddr_in host_addr;
    struct sockaddr host;
    if(sockfd =socket(PF_PACKET,SOCK_RAW,htons(ETH_P_ALL))<0)
    {
        printf("socket() error!\n");
        exit(1);
    }
	printf("__________%s___%d_____\n",__FUNCTION__,__LINE__);

    memset(&host_addr, 0, sizeof(host_addr));
    host_addr.sin_family = PF_PACKET;
    host_addr.sin_port = htons(PORT);
    host_addr.sin_addr.s_addr = inet_addr("192.168.0.13");

	memset(&host, 0, sizeof(host));
	strcpy(host.sa_data,"br0");

	ngr_detect_msg.Dmac[0]=0x0;//00:01:02:03:04:05
	ngr_detect_msg.Dmac[1]=0x1;
	ngr_detect_msg.Dmac[2]=0x2;
	ngr_detect_msg.Dmac[3]=0x3;
	ngr_detect_msg.Dmac[4]=0x4;
	ngr_detect_msg.Dmac[5]=0x5;
	
	ngr_detect_msg.Smac[0]=0x0;//00:23:45:1C:DE:89
	ngr_detect_msg.Smac[1]=0x23;
	ngr_detect_msg.Smac[2]=0x45;
	ngr_detect_msg.Smac[3]=0x1C;
	ngr_detect_msg.Smac[4]=0xDE;
	ngr_detect_msg.Smac[5]=0x89;
    ngr_detect_msg.proto= htons(0x0800);

	for(i=0;i<150;i++)
	{
        ngr_detect_msg.Msg[i] = 0xA5;
	}
	printf("__________%s___%d_____\n",__FUNCTION__,__LINE__);

    //int res =sendto(sockfd, ngr_detect_msg, sizeof(ngr_detect_msg), 0, (struct sockaddr*)&host_addr, sizeof(host_addr));
	int res =sendto(sockfd, &ngr_detect_msg, sizeof(ngr_detect_msg), 0, (struct sockaddr*)&host, sizeof(host));
	printf("__________%s___%d_____res=%d\n",__FUNCTION__,__LINE__,res);

	sleep(1);

    return 0;

}
#endif
#include <stdio.h>

#include <stdlib.h>

#include <unistd.h>           // close()

#include <string.h>           // strcpy, memset(), and memcpy()

#include <netdb.h>            // struct addrinfo

#include <sys/types.h>        // needed for socket(), uint8_t, uint16_t, uint32_t

#include <sys/socket.h>       // needed for socket()

#include <netinet/in.h>       // IPPROTO_ICMP, INET_ADDRSTRLEN

#include <netinet/ip.h>       // struct ip and IP_MAXPACKET (which is 65535)

#include <netinet/ip_icmp.h>  // struct icmp, ICMP_ECHO

#include <arpa/inet.h>        // inet_pton() and inet_ntop()


#include <sys/ioctl.h>        // macro ioctl is defined

#include <bits/ioctls.h>      // defines values for argument "request" of ioctl.

//#include <net/if.h>           // struct ifreq

#include <linux/if_ether.h>   // ETH_P_IP = 0x0800, ETH_P_IPV6 = 0x86DD

#include <linux/if_packet.h>  // struct sockaddr_ll (see man 7 packet)

#include <net/ethernet.h>

#include <errno.h>            // errno, perror()

#include <stdio.h>
#include <stdint.h>
#include <unistd.h>
#include <crypt.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <linux/errno.h>
#include <string.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <stdarg.h>
#include <ctype.h>
#include <math.h>
#include <errno.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <linux/types.h>
#include <linux/wireless.h>





#define ETH_P_DEAN 0x8874 //Զ̫Эtype


#define MAX_LEN_OF_MAC_TABLE 256
#define MAX_STA_NUM                    256

#define MAC_ADDR_LENGTH     6
#define MAX_IPADDR_LEN                 16

#if WIRELESS_EXT <= 11
#ifndef SIOCDEVPRIVATE
#define SIOCDEVPRIVATE                              0x8BE0
#endif
#define SIOCIWFIRSTPRIV								SIOCDEVPRIVATE
#endif
#define RTPRIV_IOCTL_GET_MAC_TABLE					(SIOCIWFIRSTPRIV + 0x0F)


/*---------------------------------------------------------------*/
/*-------------DEFINE--WIFI_INSTANCE--END------------------------*/
/*---------------------------------------------------------------*/
typedef struct
{
    unsigned char MacAddr[MAC_ADDR_LENGTH];
	char IpAddr[MAX_IPADDR_LEN];
    unsigned int TxRate;
    unsigned int RSSI;
    unsigned int state;
}TStationInfo;

typedef struct TSTAINFOLst
{
    unsigned int count;
    TStationInfo StationList[MAX_STA_NUM];
}TStationInfoList;

#define APCLI0_MAC  0
#define RA0_MAC     1
#define APCLII0_MAC 2
#define RAI0_MAC    3


unsigned char g_MacAddr[8][MAC_ADDR_LENGTH] = {0};


typedef union  _MACHTTRANSMIT_SETTING {
	struct  {
		unsigned short      MCS:7;                 // MCS
		unsigned short      BW:1;   //channel bandwidth 20MHz or 40 MHz
		unsigned short      ShortGI:1;
		unsigned short      STBC:2; //SPACE
		unsigned short      rsv:3;
		unsigned short      MODE:2; // Use definition MODE_xxx.
	}   field;
	unsigned short      word;
} MACHTTRANSMIT_SETTING, *PMACHTTRANSMIT_SETTING;

typedef struct _RT_802_11_MAC_ENTRY {
	unsigned char       ApIdx;
	unsigned char       Addr[MAC_ADDR_LENGTH];
	unsigned char       Aid;
	unsigned char       Psm;     //used for ssidindex
	unsigned char       MimoPs;  // 0:MMPS_STATIC, 1:MMPS_DYNAMIC, 3:MMPS_Enabled
	signed char     AvgRssi0;
	signed char     AvgRssi1;
	signed char     AvgRssi2;
	unsigned int        ConnectedTime;
	MACHTTRANSMIT_SETTING   TxRate;
	unsigned long      LastRxRate;
	signed short       StreamSnr[3];               /* BF SNR from RXWI. Units=0.25 dB. 22 dB offset removed */
	signed short       SoundingRespSnr[3];         /* SNR from Sounding Response. Units=0.25 dB. 22 dB offset removed */
} RT_802_11_MAC_ENTRY, *PRT_802_11_MAC_ENTRY;


typedef struct _RT_802_11_MAC_TABLE {
	unsigned long       Num;
	RT_802_11_MAC_ENTRY Entry[MAX_LEN_OF_MAC_TABLE];
} RT_802_11_MAC_TABLE, *PRT_802_11_MAC_TABLE;
/*=========================================================================*/
/*  : tbsMatch                                                     */
/*  : ַƥ亯                                               */
/*      : pszString Ҫƥַ                                     */
/*            pszPattern   ƥ                                        */
/*      : BOOL   TRUE:ƥɹFALSEƥ                          */
/*      : tbs / 2008-04-19                                             */
/*=========================================================================*/
#include <regex.h>
int CheckIfUp(char *pszIfName)
{
    FILE *fd = NULL;
    char result[512]={0};
    char szCmd[128] = {0};
    int iRet = 0;

    sprintf(szCmd, "ifconfig | grep \"%s\"",pszIfName);

    /*ڽбвinetdǷ*/
    fd = (FILE *)popen(szCmd, "r");   
    if(NULL == fd)   
    {
    	return iRet;
    }

    while (1)
    {
        if (fgets(result, sizeof(result), fd) == NULL)
        {
            break;
        }
		else
		{
           if(strstr(result,"Link encap"))
           	{
		       iRet = 1;
		       break;
           	}
		}
    }
    
    pclose(fd);
#if 0	
    if(1 == iRet)
		printf ("raw CheckIfUp() %s is up\n", pszIfName);
	else 
		printf ("raw CheckIfUp %s is down\n", pszIfName);
#endif	
    return iRet;
}

int tbsMatch(const char *pszString, const char *pszPattern)
{
    int status;
    regex_t re;

    if (NULL == pszString || NULL == pszPattern)
    {
        return 0;
    }

    if (regcomp(&re, pszPattern, REG_EXTENDED|REG_NOSUB) != 0)
    {
        return 0; /* report error */
    }

    status = regexec(&re, pszString, (size_t) 0, NULL, 0);
    regfree(&re);

    if (status != 0)
    {
        return 0; /* report error */
    }

    return 1; /* match */
}

int tbsCheckMac( char *pcMac)
{
    unsigned int arr[6], index;
    const char *pattern = "^[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}:[0-9a-fA-F]{2}$";

	if(pcMac == NULL)
		return 0;

	if(0 == tbsMatch(pcMac, pattern))
	{
		return 0;
	}

	if(sscanf(pcMac,"%02x:%02x:%02x:%02x:%02x:%02x",\
				&arr[0],&arr[1],&arr[2],&arr[3],&arr[4],&arr[5]) != 6 )
		return 0;

#if 1
    /* MACַǷΪ㲥ȫMAC */
    if (0 == strcasecmp(pcMac, "00:00:00:00:00:00")
       || 0 == strcasecmp(pcMac, "FF:FF:FF:FF:FF:FF")
    )
    {
        return 0;
    }

    /*MACַǷΪಥMACַ*/
    if( arr[0]%2 > 0 )
        return 0;
#endif

    /*MACַǷϷ*/
    for(index = 1; index < 6; index ++)
    {
        if(arr[index] > 0xff)
        {
        	return 0;
        }
    }
    return 1;
}


tbsCnvtMacFromStr( char *pszMac, unsigned char *pstMac)
{
    unsigned int mac[6] = {0};
    int ret = 0;
    //printf("tbsCnvtMacFromStr:pszMac=%s\n",pszMac);
    ret = sscanf(pszMac, "%x:%x:%x:%x:%x:%x",
           &mac[0], &mac[1], &mac[2], &mac[3], &mac[4], &mac[5]);
    if(ret != 6)
    {
    	return NULL;
    }
    
    pstMac[0] = (unsigned char)mac[0];
    pstMac[1] = (unsigned char)mac[1];
    pstMac[2] = (unsigned char)mac[2];
    pstMac[3] = (unsigned char)mac[3];
    pstMac[4] = (unsigned char)mac[4];
    pstMac[5] = (unsigned char)mac[5];

    return pstMac;
}

int get_apcli_uperAp_mac(char *pIntfName,unsigned char *pMac)
{
	FILE * fp_if = NULL;
	FILE *fp_ext = NULL;
	char buf[256] = {0};
	char szCmd[256] = {0};
	int iLinkState = -1;
	char *tmp = NULL;
	char macStr[256] = {0};

	sprintf(szCmd, "iwconfig %s", pIntfName);
	fp_if = popen(szCmd, "r");
	if(NULL != fp_if)
	{
	    if(fread(buf, 1, 256, fp_if))
		{   /*
               # iwconfig apcli0 
				apcli0    RTWIFI SoftAP  ESSID:"Hero1015"  
			    Mode:Managed  Channel=11  Access Point: 48:F8:B3:56:F2:7A   
			    Bit Rate=300 Mb/s   
			  # 
		   */
		   /*
				# iwconfig apclii0
				  apclii0	 RTWIFI SoftAP	ESSID:""  
				  Mode:Managed  Channel=36  Access Point: Not-Associated   
				  Bit Rate:150 Mb/s	 								 
				# 
			*/
	        /* if not link return 0, else return 1*/
		    //if(strstr(buf, "Not-Associated") || strstr(buf, "Invalid") || strstr(buf, "None"))
			if(strstr(buf, "RTWIFI SoftAP  ESSID:\"\"") && strstr(buf, "Access Point: Not-Associated"))
		    {
			    iLinkState = 0;
		    }    
		    else 
		    {
		        tmp = strstr(buf, "Access Point:");
				if(NULL != tmp)
				{
                    snprintf(macStr,18,"%s",(tmp+strlen("Access Point:")+1));
					if(1 == tbsCheckMac(macStr))
					    tbsCnvtMacFromStr(macStr,pMac);
					else
					{
						pclose(fp_if);
						return 0;
					}
				}
					
			    iLinkState = 0;

		     	/*Ƿж*/
			    sprintf(szCmd, "iwpriv %s show assoc", pIntfName);
			    //system(szCmd);
				if(0 == strcmp(pIntfName,"apcli0"))
		       	    sprintf(szCmd,"/proc/mt7628/iwconfig_assoc_flag");
				else if(0 == strcmp(pIntfName,"apclii0"))
		       	    sprintf(szCmd,"/proc/mt7612/iwconfig_assoc_flag");
				else
				{
				    iLinkState = 0;
		       	    pclose(fp_if);
				    return iLinkState;
				}
				fp_ext = fopen(szCmd, "r");
				if(NULL != fp_ext)
				{
					fread(buf, 1, 256, fp_ext);
	    			if(0 == atoi(buf)) 
	    			{
						//״̬Ϊ0˵Ǽ
	    				iLinkState = 0;
	    			}
	    			else if(1 == atoi(buf))
	    			{
	    				//״̬Ϊ1˵ӳɹ
	          			iLinkState = 1;
	    			}

	                fclose(fp_ext);
				}
		        else
		        {
		        	//procĿ¼ʧ
		            iLinkState = 0;
		        } 

		    }    
		}
	    pclose(fp_if);
	}
	else
	{
	    iLinkState = 0;
	}
    return iLinkState;
}

int get_intf_mac(char* pIntfName,unsigned char *pMac)
{
    int i,sd;
	struct ifreq ifr;
    // Submit request for a socket descriptor to look up interface.

    if ((sd = socket (PF_PACKET, SOCK_RAW, htons (ETH_P_ALL))) < 0) {//һδsocketΪ˻ȡϢ

        perror ("socket() failed to get socket descriptor for using ioctl() ");

        return (EXIT_FAILURE);

    }

    // Use ioctl() to look up interface name and get its MAC address.

    memset (&ifr, 0, sizeof (ifr));

    snprintf (ifr.ifr_name, sizeof (ifr.ifr_name), "%s", pIntfName);

    if (ioctl (sd, SIOCGIFHWADDR, &ifr) < 0) {
		close (sd);

        perror ("ioctl() failed to get source MAC address ");

        return (EXIT_FAILURE);

    }

    close (sd);
	// Copy source MAC address.

    memcpy (pMac, ifr.ifr_hwaddr.sa_data, 6);

    // Report source MAC address to stdout.

    printf ("MAC address for interface %s is ", pIntfName);

    for (i=0; i<5; i++) {

        printf ("%02x:", pMac[i]);

    }

    printf ("%02x\n", pMac[5]);
	return EXIT_SUCCESS;

}

/*************************************************************************
:
:
:
ע:
*************************************************************************/
static int list_stations_info(char*DevName,TStationInfoList *pstation_list)
{
	struct iwreq wrq;
	RT_802_11_MAC_TABLE *mp = NULL;
	int i,j, ret, socket_id;
	char *data;
	
    if(0 == CheckIfUp(DevName))// interfce is down ,juest return
		return 0;

	data = (char*)malloc(sizeof(RT_802_11_MAC_TABLE));
	if (data == NULL)
		return 0;

	memset( data, 0, 2048 );
	sprintf(wrq.ifr_name, "%s", DevName);
	wrq.u.data.length = 2048;
 	wrq.u.data.pointer = data;
 	wrq.u.data.flags = 0;

	socket_id = socket( AF_INET, SOCK_DGRAM, 0 );
	if ( socket_id == -1 ) {
		free(data);
		return 0;
	}
	ret = ioctl( socket_id, RTPRIV_IOCTL_GET_MAC_TABLE, &wrq );
	if ( ret != 0 ) {
		free(data);
    	close(socket_id);
		return 0;
	}

	mp = (RT_802_11_MAC_TABLE *)wrq.u.data.pointer;
	if ( mp->Num == 0 ) {
		free(data);
		close(socket_id);
		return 0;
	}

	for ( i = 0,j=0;  i< MAX_LEN_OF_MAC_TABLE; j++ )
	{
	        if ( mp->Entry[j].Aid == 0 ) 
			{
				break;
			}
			memcpy(pstation_list->StationList[i].MacAddr,mp->Entry[j].Addr,MAC_ADDR_LENGTH);
			pstation_list->StationList[i].RSSI = mp->Entry[j].AvgRssi0;
			pstation_list->StationList[i].state =  1;//mp->Entry[j].bfState;
			pstation_list->StationList[i].TxRate = mp->Entry[j].TxRate.word/1024;//mp->Entry[j].CurTxRate;
			i++;
	}

	free(data);
	close(socket_id);

    pstation_list->count = i;
    return pstation_list->count ;
}

int send_netgear_detect_packet(char *pSrcIntfName,char* pDstMac)
{

    int i, j,datalen,frame_length, sd, bytes;

    char data[IP_MAXPACKET];

    unsigned char src_mac[6];

    unsigned char dst_mac[6];
	
	ngr_msg ngr_detect_msg;

    char ether_frame[IP_MAXPACKET];

    struct sockaddr_ll device;

    struct ifreq ifr;
	int intf_idx = 0;
	
	if((pDstMac[0] == 0) && (pDstMac[1] == 0) && (pDstMac[2] == 0)
		&& (pDstMac[3] == 0)&& (pDstMac[4] == 0)&& (pDstMac[5] == 0))
	{
        return 0;
	}
	if(0 == strcmp(pSrcIntfName,"apcli0"))
	{
		intf_idx = 0;
	}
	else if(0 == strcmp(pSrcIntfName,"ra0"))
	{
		intf_idx = 1;
	}
	else if(0 == strcmp(pSrcIntfName,"apclii0"))
	{
		intf_idx = 2;
	}
	else if(0 == strcmp(pSrcIntfName,"rai0"))
	{
		intf_idx = 3;
	}
	else
	{
		intf_idx = 0;
	}
#if 0
	TStationInfoList StationInfoList24;
	TStationInfoList StationInfoList58;
	memset(&StationInfoList24,0,sizeof(TStationInfoList));
	memset(&StationInfoList58,0,sizeof(TStationInfoList));


	list_stations_info("ra0",&StationInfoList24);
	printf("list_stations_info(ra0) StationInfoList24.count =%d\n",StationInfoList24.count);
	for(j=0;j<StationInfoList24.count;j++)
	{
	     if((0 != StationInfoList24.StationList[j].MacAddr[0])
		 	&& (0 != StationInfoList24.StationList[j].MacAddr[1])
		 	&& (0 != StationInfoList24.StationList[j].MacAddr[2])
		 	&& (0 != StationInfoList24.StationList[j].MacAddr[3])
		 	&& (0 != StationInfoList24.StationList[j].MacAddr[4])
		 	&& (0 != StationInfoList24.StationList[j].MacAddr[5]))
         printf("list_stations_info(ra0) %d mac:%02x:%02x:%02x:%02x:%02x:%02x\n",j,
		 	 StationInfoList24.StationList[j].MacAddr[0]
		 	,StationInfoList24.StationList[j].MacAddr[1]
		 	,StationInfoList24.StationList[j].MacAddr[2]
		 	,StationInfoList24.StationList[j].MacAddr[3]
		 	,StationInfoList24.StationList[j].MacAddr[4]
		 	,StationInfoList24.StationList[j].MacAddr[5]);

	}
	
	list_stations_info("rai0",&StationInfoList58);
	printf("list_stations_info(rai0) StationInfoList58.count =%d\n",StationInfoList58.count);
	for(j=0;j<StationInfoList58.count;j++)
	{
	    if((0 != StationInfoList58.StationList[j].MacAddr[0])
		 	&& (0 != StationInfoList58.StationList[j].MacAddr[1])
		 	&& (0 != StationInfoList58.StationList[j].MacAddr[2])
		 	&& (0 != StationInfoList58.StationList[j].MacAddr[3])
		 	&& (0 != StationInfoList58.StationList[j].MacAddr[4])
		 	&& (0 != StationInfoList58.StationList[j].MacAddr[5]))
         printf("list_stations_info(rai0) %d mac:%02x:%02x:%02x:%02x:%02x:%02x\n",j,
		 	 StationInfoList58.StationList[j].MacAddr[0]
		 	,StationInfoList58.StationList[j].MacAddr[1]
		 	,StationInfoList58.StationList[j].MacAddr[2]
		 	,StationInfoList58.StationList[j].MacAddr[3]
		 	,StationInfoList58.StationList[j].MacAddr[4]
		 	,StationInfoList58.StationList[j].MacAddr[5]);
	}
#endif

    // Find interface index from interface name and store index in

    // struct sockaddr_ll device, which will be used as an argument of sendto().

    memset (&device, 0, sizeof (device));

    if ((device.sll_ifindex = if_nametoindex (pSrcIntfName)) == 0) {

        perror ("if_nametoindex() failed to obtain interface index ");

        exit (EXIT_FAILURE);

    }

    //printf ("Index for interface %s is %i\n", pSrcIntfName, device.sll_ifindex);

    // Set destination MAC address: you need to fill these out

    ngr_detect_msg.Dmac[0] = pDstMac[0];//0xDC;//Ŀַ DC:EF:09:9E:B6:DF

    ngr_detect_msg.Dmac[1] = pDstMac[1];//0xEF;

    ngr_detect_msg.Dmac[2] = pDstMac[2];//0x09;

    ngr_detect_msg.Dmac[3] = pDstMac[3];//0x9E;

    ngr_detect_msg.Dmac[4] = pDstMac[4];//0xB6;

    ngr_detect_msg.Dmac[5] = pDstMac[5];//0xDF;
    
	
	memcpy (ngr_detect_msg.Smac, g_MacAddr[intf_idx], 6);//srcַ

	ngr_detect_msg.proto= htons(0x0800);

	for(i=0;i<1500;i++)//ñ
	{
		ngr_detect_msg.Msg[i] = 0xA5;
	}
	

    // Fill out sockaddr_ll.

    device.sll_family = AF_PACKET;

    memcpy (device.sll_addr, src_mac, 6);

    device.sll_halen = htons (6);


    // Submit request for a raw socket descriptor.

    if ((sd = socket (PF_PACKET, SOCK_RAW, htons (ETH_P_ALL))) < 0) {//淢͵socket

        perror ("socket() failed ");

        return (EXIT_FAILURE);

    }

    // Send ethernet frame to socket.

    if ((bytes = sendto (sd, &ngr_detect_msg, sizeof(ngr_detect_msg), 0, (struct sockaddr *) &device, sizeof (device))) <= 0) {

        perror ("sendto() failed");
        close (sd);
        return (EXIT_FAILURE);

    }
    if(0) //for debug
    {
        printf ("%s SrcMac %02x:%02x:%02x:%02x:%02x:%02x send to Dmac %02x:%02x:%02x:%02x:%02x:%02x num=%d bytes\n",pSrcIntfName,
		          ngr_detect_msg.Smac[0],ngr_detect_msg.Smac[1],ngr_detect_msg.Smac[2],ngr_detect_msg.Smac[3],ngr_detect_msg.Smac[4],ngr_detect_msg.Smac[5],
		          ngr_detect_msg.Dmac[0],ngr_detect_msg.Dmac[1],ngr_detect_msg.Dmac[2],ngr_detect_msg.Dmac[3],ngr_detect_msg.Dmac[4],ngr_detect_msg.Dmac[5],bytes);     
    }
    // Close socket descriptor.

    close (sd);

    return (EXIT_SUCCESS);

}	

#if 1
#define SLEEP_TIME  1

void timer_handler()	
{  
	int i, j;
	TStationInfoList StationInfoList24;
	TStationInfoList StationInfoList58;
	memset(&StationInfoList24,0,sizeof(TStationInfoList));
	memset(&StationInfoList58,0,sizeof(TStationInfoList));


	list_stations_info("ra0",&StationInfoList24);
	//printf("list_stations_info(ra0) StationInfoList24.count =%d\n",StationInfoList24.count);
	for(j=0;j<StationInfoList24.count;j++)
	{
      #if 0   
         printf("list_stations_info(ra0) %d mac:%02x:%02x:%02x:%02x:%02x:%02x\n",j,
		 	 StationInfoList24.StationList[j].MacAddr[0]
		 	,StationInfoList24.StationList[j].MacAddr[1]
		 	,StationInfoList24.StationList[j].MacAddr[2]
		 	,StationInfoList24.StationList[j].MacAddr[3]
		 	,StationInfoList24.StationList[j].MacAddr[4]
		 	,StationInfoList24.StationList[j].MacAddr[5]);
	  #endif
		 send_netgear_detect_packet("ra0",StationInfoList58.StationList[j].MacAddr);

	}
	
	list_stations_info("rai0",&StationInfoList58);
	//printf("list_stations_info(rai0) StationInfoList58.count =%d\n",StationInfoList58.count);
	for(j=0;j<StationInfoList58.count;j++)
	{
	     #if 0
         printf("list_stations_info(rai0) %d mac:%02x:%02x:%02x:%02x:%02x:%02x\n",j,
		 	 StationInfoList58.StationList[j].MacAddr[0]
		 	,StationInfoList58.StationList[j].MacAddr[1]
		 	,StationInfoList58.StationList[j].MacAddr[2]
		 	,StationInfoList58.StationList[j].MacAddr[3]
		 	,StationInfoList58.StationList[j].MacAddr[4]
		 	,StationInfoList58.StationList[j].MacAddr[5]);
		 #endif
		send_netgear_detect_packet("rai0",StationInfoList58.StationList[j].MacAddr);
	}
	
	unsigned char apcli0_UperApMac[6] = {0};
	unsigned char apclii0_UperApMac[6] = {0};
	int connectstate = -1;
	connectstate = get_apcli_uperAp_mac("apcli0",apcli0_UperApMac);
	if(1 == connectstate)
	{
        send_netgear_detect_packet("apcli0",apcli0_UperApMac);
	}
	
	connectstate = get_apcli_uperAp_mac("apclii0",apclii0_UperApMac);
	if(1 == connectstate)
	{
        send_netgear_detect_packet("apclii0",apclii0_UperApMac);
	}
	
	//printf("apcli0  uperAP mac is %02x:%02x:%02x:%02x:%02x:%02x\n",apcli0_UperApMac[0],apcli0_UperApMac[1],apcli0_UperApMac[2],apcli0_UperApMac[3],apcli0_UperApMac[4],apcli0_UperApMac[5]);
    //printf("apcli0  uperAP mac is %02x:%02x:%02x:%02x:%02x:%02x\n",apclii0_UperApMac[0],apclii0_UperApMac[1],apclii0_UperApMac[2],apclii0_UperApMac[3],apclii0_UperApMac[4],apclii0_UperApMac[5]);
   
    alarm(SLEEP_TIME);//ӣ׼˯  
	
}  


int main (int argc, char **argv)

{
    get_intf_mac("apcli0",g_MacAddr[APCLI0_MAC]);
    get_intf_mac("ra0",g_MacAddr[RA0_MAC]);
    get_intf_mac("apclii0",g_MacAddr[APCLII0_MAC]);
    get_intf_mac("rai0",g_MacAddr[RAI0_MAC]);

	printf("apcli0  mac is %02x:%02x:%02x:%02x:%02x:%02x\n",g_MacAddr[APCLI0_MAC][0],g_MacAddr[APCLI0_MAC][1],g_MacAddr[APCLI0_MAC][2],g_MacAddr[APCLI0_MAC][3],g_MacAddr[APCLI0_MAC][4],g_MacAddr[APCLI0_MAC][5]);
    printf("ra0     mac is %02x:%02x:%02x:%02x:%02x:%02x\n",g_MacAddr[RA0_MAC][0],g_MacAddr[RA0_MAC][1],g_MacAddr[RA0_MAC][2],g_MacAddr[RA0_MAC][3],g_MacAddr[RA0_MAC][4],g_MacAddr[RA0_MAC][5]);
	printf("apclii0 mac is %02x:%02x:%02x:%02x:%02x:%02x\n",g_MacAddr[APCLII0_MAC][0],g_MacAddr[APCLII0_MAC][1],g_MacAddr[APCLII0_MAC][2],g_MacAddr[APCLII0_MAC][3],g_MacAddr[APCLII0_MAC][4],g_MacAddr[APCLII0_MAC][5]);
	printf("rai0    mac is %02x:%02x:%02x:%02x:%02x:%02x\n",g_MacAddr[RAI0_MAC][0],g_MacAddr[RAI0_MAC][1],g_MacAddr[RAI0_MAC][2],g_MacAddr[RAI0_MAC][3],g_MacAddr[RAI0_MAC][4],g_MacAddr[RAI0_MAC][5]);
    signal(SIGALRM, timer_handler); //ں׼һܵSIGALARMź,ִ handler  
    alarm(SLEEP_TIME);//ӣ׼˯  
    while(1)
    {
       sleep(5);
	}
    return (EXIT_SUCCESS);

}
#else
int main (int argc, char **argv)

{

    int i, datalen,frame_length, sd, bytes;

    char *interface="apcli0";;

    char data[IP_MAXPACKET];

    char src_mac[6];

    char dst_mac[6];;

    char ether_frame[IP_MAXPACKET];

    struct sockaddr_ll device;

    struct ifreq ifr;

    // Submit request for a socket descriptor to look up interface.

    if ((sd = socket (PF_PACKET, SOCK_RAW, htons (ETH_P_ALL))) < 0) {//һδsocketΪ˻ȡϢ

        perror ("socket() failed to get socket descriptor for using ioctl() ");

        exit (EXIT_FAILURE);

    }

    // Use ioctl() to look up interface name and get its MAC address.

    memset (&ifr, 0, sizeof (ifr));

    snprintf (ifr.ifr_name, sizeof (ifr.ifr_name), "%s", interface);

    if (ioctl (sd, SIOCGIFHWADDR, &ifr) < 0) {

        perror ("ioctl() failed to get source MAC address ");

        return (EXIT_FAILURE);

    }

    close (sd);

    // Copy source MAC address.

    memcpy (src_mac, ifr.ifr_hwaddr.sa_data, 6);

    // Report source MAC address to stdout.

    printf ("MAC address for interface %s is ", interface);

    for (i=0; i<5; i++) {

        printf ("%02x:", src_mac[i]);

    }

    printf ("%02x\n", src_mac[5]);

    // Find interface index from interface name and store index in

    // struct sockaddr_ll device, which will be used as an argument of sendto().

    memset (&device, 0, sizeof (device));

    if ((device.sll_ifindex = if_nametoindex (interface)) == 0) {

        perror ("if_nametoindex() failed to obtain interface index ");

        exit (EXIT_FAILURE);

    }

    printf ("Index for interface %s is %i\n", interface, device.sll_ifindex);

    // Set destination MAC address: you need to fill these out

    dst_mac[0] = 0x10;//Ŀַ

    dst_mac[1] = 0x78;

    dst_mac[2] = 0xd2;

    dst_mac[3] = 0xc6;

    dst_mac[4] = 0x2f;

    dst_mac[5] = 0x89;

    // Fill out sockaddr_ll.

    device.sll_family = AF_PACKET;

    memcpy (device.sll_addr, src_mac, 6);

    device.sll_halen = htons (6);

    // ͵dataȿ⣬ץʱСݳΪ46̫Э涨,̫֡򲿷СΪ46ֽڣԶ㴦

    datalen = 12;

    data[0] = 'h';

    data[1] = 'e';

    data[2] = 'l';

    data[3] = 'l';

    data[4] = 'o';

    data[5] = ' ';

    data[6] = 'w';

    data[7] = 'o';

    data[8] = 'r';

    data[9] = 'l';

    data[10] = 'd';

    data[11] = '!';

    // Fill out ethernet frame header.

    frame_length = 6 + 6 + 2   + datalen;

    // Destination and Source MAC addresses

    memcpy (ether_frame, dst_mac, 6);

    memcpy (ether_frame + 6, src_mac, 6);

    ether_frame[12] = ETH_P_DEAN / 256;

    ether_frame[13] = ETH_P_DEAN % 256;

    // data

    memcpy (ether_frame + 14 , data, datalen);

    

    // Submit request for a raw socket descriptor.

    if ((sd = socket (PF_PACKET, SOCK_RAW, htons (ETH_P_ALL))) < 0) {//淢͵socket

        perror ("socket() failed ");

        exit (EXIT_FAILURE);

    }

    // Send ethernet frame to socket.

    if ((bytes = sendto (sd, ether_frame, frame_length, 0, (struct sockaddr *) &device, sizeof (device))) <= 0) {

        perror ("sendto() failed");

        exit (EXIT_FAILURE);

    }

    printf ("send num=%d,read num=%d\n",frame_length,bytes);     

    // Close socket descriptor.

    close (sd);

    return (EXIT_SUCCESS);

}
#endif




