/* Shared library add-on to iptables to add bridge port matching support. */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <getopt.h>
#include <ctype.h>
#include <ip6tables.h>
#include <linux/netfilter/xt_realdev.h>
#if defined(__GLIBC__) && __GLIBC__ == 2
#include <net/ethernet.h>
#else
#include <linux/if_ether.h>
#endif

static void
help(void)
{
	printf(
"realdev v%s options:\n"
" --realdev-in [!] input name[+]		interface name ([+] for wildcard)\n"
"\n", IPTABLES_VERSION);
}

static struct option opts[] = {
	{ "realdev-in", 1, 0, '1' },
	{0}
};

static void
init(struct ip6t_entry_match *m, unsigned int *nfcache)
{
}

static int
parse(int c, char **argv, int invert, unsigned int *flags,
      unsigned int *nfcache,
      struct ip6t_entry_match **match)
{
	struct xt_realdev_info *info =
		(struct xt_realdev_info*)(*match)->data;


	switch (c) {
	case '1':
		if (*flags & XT_REALDEV_OP_IN)
			goto multiple_use;
		xtables_check_inverse(optarg, &invert, &optind, 0, argv);
		xtables_parse_interface(argv[optind-1], info->physindev,
				(unsigned char *)info->in_mask);
		if (invert)
			info->invert |= XT_REALDEV_OP_IN;
		info->bitmask |= XT_REALDEV_OP_IN;
		*flags |= XT_REALDEV_OP_IN;

		break;

	default:
		return 0;
	}

	return 1;
multiple_use:
	xtables_error(PARAMETER_PROBLEM,
	   "multiple use of the same realdev option is not allowed");

}

static void final_check(unsigned int flags)
{
	if (flags == 0)
		xtables_error(PARAMETER_PROBLEM, "PHYSDEV: no realdev option specified");
}

static void
print(const struct ip6t_ip6 *ip,
      const struct ip6t_entry_match *match,
      int numeric)
{
	struct xt_realdev_info *info =
		(struct xt_realdev_info*)match->data;

	printf("PHYSDEV match");
	if (info->bitmask & XT_REALDEV_OP_IN)
		printf("%s --realdev-in %s",
		(info->invert & XT_REALDEV_OP_IN) ? " !":"", info->physindev);

	printf(" ");
}

static void save(const struct ip6t_ip6 *ip, const struct ip6t_entry_match *match)
{
	struct xt_realdev_info *info =
		(struct xt_realdev_info*)match->data;

	if (info->bitmask & XT_REALDEV_OP_IN)
		printf("%s --realdev-in %s",
		(info->invert & XT_REALDEV_OP_IN) ? " !":"", info->physindev);

	printf(" ");
}

static struct xtables_match realdev = {
	.name		= "realdev",
	.version	= XTABLES_VERSION,
	.family     = NFPROTO_IPV6,
	.size		= XT_ALIGN(sizeof(struct xt_realdev_info)),
	.userspacesize	= XT_ALIGN(sizeof(struct xt_realdev_info)),
	.help		= &help,
	.init		= &init,
	.parse		= &parse,
	.final_check	= &final_check,
	.print		= &print,
	.save		= &save,
	.extra_opts	= opts,
};

void _init(void)
{
	xtables_register_match(&realdev);
}


