/* mini_httpd - small HTTP server
**
** Copyright  1999,2000 by Jef Poskanzer <jef@acme.com>.
** All rights reserved.
**
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
*/

//-------------------------------------------------------------------------------------
// Copyright 2005, Texas Instruments Incorporated
//
// This program has been modified from its original operation by Texas Instruments
// to do the following:
//
// 1. NSP Policy Routing Framework
//
// THIS MODIFIED SOFTWARE AND DOCUMENTATION ARE PROVIDED
// "AS IS," AND TEXAS INSTRUMENTS MAKES NO REPRESENTATIONS
// OR WARRENTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO, WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY
// PARTICULAR PURPOSE OR THAT THE USE OF THE SOFTWARE OR
// DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS,
// COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.
//-------------------------------------------------------------------------------------

#include "version.h"
#include "mini_httpd.h"

#include <unistd.h>
#include <stdlib.h>
#include <stdarg.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <limits.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <time.h>
#include <pwd.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <ctype.h>
#include <sys/wait.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <dirent.h>

#include <sys/ioctl.h>
#include <net/if.h>
//#include <linux/pr.h>
#include "port.h"
#include "match.h"
#include "tdate_parse.h"


//cmm
#include "tbsmsg.h"
#include "tbserror.h"
#include "cfg_api.h"
#include "pc_api.h"
#include "tbsutil.h"
#include "warnlog.h"
#include "common.h"
//#include "timer.h"

//#include "cmmif.h"
#include <memory.h>

 #include <sys/socket.h>
 #include <netinet/in.h>
 #include <arpa/inet.h>
 #include <sys/times.h>
 //cmm end
 
//#define  HTTPD_SOAP_DEBUG
#ifdef HTTPD_SOAP_DEBUG
#define syslog(x, fmt, args...)    printf("%25s:%4d "fmt "\r", __func__, __LINE__,##args)
#endif
#define USE_SEM_SEMUN 1

#ifdef USE_SEM_SEMUN
// gxw / 2015-11-11 / ӽ̵cgi򻥳
#include <sys/sem.h>
#endif

#ifdef TR069
//#include "cm_message.h"
#endif
#include "tbstype.h"
#include "tbsmsg.h"


#ifdef HAVE_SENDFILE
# ifdef HAVE_LINUX_SENDFILE
# include <sys/sendfile.h>
# else /* HAVE_LINUX_SENDFILE */
#  include <sys/uio.h>
# endif /* HAVE_LINUX_SENDFILE */
#endif /* HAVE_SENDFILE */

#ifdef USE_SSL
#include <openssl/ssl.h>
#include <openssl/err.h>
#endif /* USE_SSL */

extern char* crypt( const char* key, const char* setting );
//#define INTF_FILE	"/proc/net/port_trap"

//this file is temp, TR69_ENV_VAR_USER & TR69_ENV_VAR_PASSWORD are saved it it.
//we read them from it to authenticat the ACS
#define UP_FILE_NAME   "/var/tmp/tr069up"
#define BUF_SIZE 1024*10


//#if defined(AF_INET6) && defined(IN6_IS_ADDR_V4MAPPED)
//#define USE_IPV6
//#endif

#ifndef STDIN_FILENO
#define STDIN_FILENO 0
#endif
#ifndef STDOUT_FILENO
#define STDOUT_FILENO 1
#endif
#ifndef STDERR_FILENO
#define STDERR_FILENO 2
#endif

#ifndef SHUT_WR
#define SHUT_WR 1
#endif

#ifndef SIZE_T_MAX
#define SIZE_T_MAX 2147483647L
#endif

#ifndef HAVE_INT64T
typedef long long int64_t;
#endif

#ifdef __CYGWIN__
#define timezone  _timezone
#endif

#ifndef MAX
#define MAX(a,b) ((a) > (b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a) < (b) ? (a) : (b))
#endif


#ifndef ERR_DIR
#define ERR_DIR "errors"
#endif /* ERR_DIR */
#ifndef DEFAULT_HTTP_PORT
#define DEFAULT_HTTP_PORT 80
#endif /* DEFAULT_HTTP_PORT */
#ifdef USE_SSL
#ifndef DEFAULT_HTTPS_PORT
#define DEFAULT_HTTPS_PORT 443
#endif /* DEFAULT_HTTPS_PORT */
#ifndef DEFAULT_CERTFILE
#define DEFAULT_CERTFILE "/usr/www/mini_httpd.pem"
#endif /* DEFAULT_CERTFILE */
#endif /* USE_SSL */
#ifndef DEFAULT_USER
#define DEFAULT_USER "nobody"
#endif /* DEFAULT_USER */
#ifndef CGI_NICE
#define CGI_NICE 10
#endif /* CGI_NICE */
#ifndef CGI_PATH
#define CGI_PATH "/usr/local/bin:/usr/ucb:/bin:/usr/bin"
#endif /* CGI_PATH */
#ifndef CGI_LD_LIBRARY_PATH
#define CGI_LD_LIBRARY_PATH "/usr/local/lib:/usr/lib"
#endif /* CGI_LD_LIBRARY_PATH */
#ifndef AUTH_FILE
#define AUTH_FILE ".htpasswd"
#endif /* AUTH_FILE */
#ifndef READ_TIMEOUT
#define READ_TIMEOUT 60
#endif /* READ_TIMEOUT */
#ifndef WRITE_TIMEOUT
#define WRITE_TIMEOUT 300
#endif /* WRITE_TIMEOUT */
#ifndef DEFAULT_CHARSET
#define DEFAULT_CHARSET "iso-8859-1"
#endif /* DEFAULT_CHARSET */


#define METHOD_UNKNOWN 0
#define METHOD_GET 1
#define METHOD_HEAD 2
#define METHOD_POST 3

/* Incase of change please also change in cfgmgr/src/tr069/TR069Module.c*/
#ifdef TR069
#define TR069_USER_NAME_LEN     256
#define TR69_DEFAULT_USER       "00E0A6-111"
#define TR69_DEFAULT_PASSW      "00E0A6-111"
#define TR69_ENV_VAR_ENABLE       "ConnectionRequestEnable"
#define TR69_ENV_VAR_USER       "ConnectionRequestUsername"
#define TR69_ENV_VAR_PASSW      "ConnectionRequestPassword"
#define ENV_FILE_LEN    	16000
#define safe_strcmp safestrcmp
#define safe_strncmp safestrncmp
#else
#define safe_strcmp strcmp
#define safe_strncmp strncmp
#endif

//traffic
#define LIMIT_WARNING_STR_VLM_OVER     "VolumeOver"
#define LIMIT_WARNING_STR_TIME_OVER    "TimeOver"
//traffic end

typedef struct tagST_URL_TABLE
{
   char *pszMatchVal;           
   char *pszUrlFmt;              
	
}ST_URL_TABLE;


static ST_URL_TABLE g_stUrlTable[] = {
	//var:menu=fwUpdate
	{"AUTO_download_image.html",			"/cgi-bin/webproc?getpage=html/index.html&var:menu=fwUpdate&var:page="},
	{"AUTO_search.html",					"/cgi-bin/webproc?getpage=html/index.html&var:menu=fwUpdate&var:page="},	 
	{"AUTO_upgrade_no_internet.html",		"/cgi-bin/webproc?getpage=html/index.html&var:menu=fwUpdate&var:page="},	 
	{"AUTO_upgrade_noversion.html",			"/cgi-bin/webproc?getpage=html/index.html&var:menu=fwUpdate&var:page="},
	{"AUTO_write_language.html",			"/cgi-bin/webproc?getpage=html/index.html&var:menu=fwUpdate&var:page="},
	{"upg_abort.html",						"/cgi-bin/webproc?getpage=html/index.html&var:menu=fwUpdate&var:page="},
	{"UPG_check_version.html",				"/cgi-bin/webproc?getpage=html/index.html&var:menu=fwUpdate&var:page="},	 
	{"upg_downimage_fail.html",				"/cgi-bin/webproc?getpage=html/index.html&var:menu=fwUpdate&var:page="},	 
	{"upg_MD5_fail.html",					"/cgi-bin/webproc?getpage=html/index.html&var:menu=fwUpdate&var:page="},
	{"upg_size_fail.html",					"/cgi-bin/webproc?getpage=html/index.html&var:menu=fwUpdate&var:page="},
	{"UPG_warning.htm",						"/cgi-bin/webproc?getpage=html/index.html&var:menu=fwUpdate&var:page="},
	{"fwUpdate.htm",						"/cgi-bin/webproc?getpage=html/index.html&var:menu=fwUpdate&var:page="},
	//var:menu=set
	{"BAK_cfm.html",						"/cgi-bin/webproc?getpage=html/index.html&var:menu=set&var:page="},
	{"bupSettings.html",					"/cgi-bin/webproc?getpage=html/index.html&var:menu=set&var:page="},
	{"Connected_Devices.html",				"/cgi-bin/webproc?getpage=html/index.html&var:menu=set&var:page="},
	{"pwdSettings.html",					"/cgi-bin/webproc?getpage=html/index.html&var:menu=set&var:page="},
	{"Reboot_cfm.html",						"/cgi-bin/webproc?getpage=html/index.html&var:menu=set&var:page="},
	{"wifiSettings.html",					"/cgi-bin/webproc?getpage=html/index.html&var:menu=set&var:page="},
	//var:menu=more
	{"guestSettings.html",					"/cgi-bin/webproc?getpage=html/index.html&var:menu=more&var:page="},
	{"fastLane.html",						"/cgi-bin/webproc?getpage=html/index.html&var:menu=more&var:page="},
	{"serviceManagement.html",				"/cgi-bin/webproc?getpage=html/index.html&var:menu=more&var:page="},
	{"wps.html",							"/cgi-bin/webproc?getpage=html/index.html&var:menu=more&var:page="},
	{"accessSchedule.html",					"/cgi-bin/webproc?getpage=html/index.html&var:menu=more&var:page="},
	//var:menu=status
	{"status.html",							"/cgi-bin/webproc?getpage=html/index.html&var:menu=status&var:page="},
	{"updataGui.html",						"/cgi-bin/webproc?getpage=html/index.html&var:menu=status&var:page="},
	//main
	{"main.html",							"/cgi-bin/webproc?getpage=html/main.html&var:page="},
	//wizard_index.htm and no getpage val
	{"IA_hijack.html",						"/cgi-bin/webproc?getpage=html/wizard_index.html&var:page="},
	{"screen3-extender.html",				"/cgi-bin/webproc?getpage=html/wizard_index.html&var:page="},
	{"screen4-extender.html",				"/cgi-bin/webproc?getpage=html/wizard_index.html&var:page="},
	{"screen5-extender.html",				"/cgi-bin/webproc?getpage=html/wizard_index.html&var:page="},
	{"screen5-extender-disconnect.html",	"/cgi-bin/webproc?getpage=html/wizard_index.html&var:page="},
	{"screen6-extender-single.html",		"/cgi-bin/webproc?getpage=html/wizard_index.html&var:page="},
	{"screen8-notConnected.html",			"/cgi-bin/webproc?getpage=html/wizard_index.html&var:page="},
	//html/page/.html  getpage = var: page 
	{"accessScheduleNote.html",				"/cgi-bin/webproc?getpage=html/page/accessScheduleNote.html&var:page="},
	{"AddWPSNote.html",						"/cgi-bin/webproc?getpage=html/page/AddWPSNote.html&var:page="},	 
	{"connectedeviceInfo.html",				"/cgi-bin/webproc?getpage=html/page/connectedeviceInfo.html&var:page="},	 
	{"networkTypeNote.html",				"/cgi-bin/webproc?getpage=html/page/networkTypeNote.html&var:page="},
	{"registerInfoNote.html",				"/cgi-bin/webproc?getpage=html/page/registerInfoNote.html&var:page="},
	{"securitySettingsNote.html",			"/cgi-bin/webproc?getpage=html/page/securitySettingsNote.html&var:page="},
	{"selectNetworkNote.html",				"/cgi-bin/webproc?getpage=html/page/selectNetworkNote.html&var:page="},	
	{"update_setting_one.html",				"/cgi-bin/webproc?getpage=html/page/update_setting_one.html&var:page="},	
	{"update_setting_two.html",				"/cgi-bin/webproc?getpage=html/page/update_setting_two.html&var:page="},
	{"wps_method.html",						"/cgi-bin/webproc?getpage=html/page/wps_method.html&var:page="},
	{"wps_result.htm",						"/cgi-bin/webproc?getpage=html/page/wps_result.html&var:page="},
	{"AUTO_upgrade_process.html",			"/cgi-bin/webproc?getpage=html/page/AUTO_upgrade_process.html&var:page="},
	//.htm	
	{"login_pwd_setup.htm",					"/cgi-bin/webproc?getpage=html/login_pwd_setup.htm&var:page="},
	{"login_cancel_pr.htm",					"/cgi-bin/webproc?getpage=html/login_cancel_pr.htm&var:page="},
	{"release_notes.htm",					"/cgi-bin/webproc?getpage=html/page/release_notes.htm&var:page="}
};

#define URL_TABLE_SIZE (sizeof(g_stUrlTable)/sizeof(g_stUrlTable[0]))

static ST_URL_TABLE g_stUrlJs[] = {

	{"apupconn.ajax.js",					"/cgi-bin/webproc?getpage=html/page/%s&var:page=*"},
	{"apupscan.ajax.js",					"/cgi-bin/webproc?getpage=html/page/%s&var:page=*"},	 
	{"portforwd.ajax.js",					"/cgi-bin/webproc?getpage=html/page/%s&var:page=*"},	 
	{"wanconnect.ajax.js",					"/cgi-bin/webproc?getpage=html/page/%s&var:page=*"},
	{"wps_setup.ajax.js",					"/cgi-bin/webproc?getpage=html/page/%s&var:page=*"},
	{"wps_status.ajax.js",					"/cgi-bin/webproc?getpage=html/page/%s&var:page=*"},
	{"setting.ajax.js",						"/cgi-bin/webproc?getpage=html/page/%s&var:page=*"},
	{"POT.js",								"/cgi-bin/webproc?getpage=html/js/%s&var:page=POT"},
	{"test_version.js",						"/cgi-bin/webproc?getpage=html/js/%s&var:page=test_version"},
	{"debug.js",							"/cgi-bin/webproc?getpage=html/js/%s&var:page=debug"},
	{"webupg",								"/cgi-bin/%s"}  //Ϊ⣬js ׺
};
#define URL_JS_SIZE (sizeof(g_stUrlJs)/sizeof(g_stUrlJs[0]))

static ST_URL_TABLE g_stUrlPro[] = {

	{"webupg",					"/cgi-bin/webupg"},
	{"webproc",					"/cgi-bin/webproc"}
};
#define URL_PRO_SIZE (sizeof(g_stUrlPro)/sizeof(g_stUrlPro[0]))




/* A multi-family sockaddr. */
typedef union {
    struct sockaddr sa;
    struct sockaddr_in sa_in;
#ifdef USE_IPV6
    struct sockaddr_in6 sa_in6;
    struct sockaddr_storage sa_stor;
#endif /* USE_IPV6 */
    } usockaddr;
typedef struct
{
	char infname[10];
	char infaddr[16];
}devinf;
devinf inf[MAX_INTERFACES];

int max_services = 1;

static char* argv0;
static int debug;
static unsigned short port;
static char* dir;
static char* data_dir;
static int do_chroot;
static int vhost;
static char *user ;
static char* cgi_pattern;
static char *cgi_pattern_tmp;
static char* url_pattern;
static int no_empty_referers;
static char* local_pattern;
static char* hostname;
static char hostname_buf[50];
static char* logfile;
static char* pidfile;
static char* charset;
static char* p3p;
static int max_age;
static FILE* logfp;
static int listen4_fd, listen6_fd;
#ifdef USE_SSL
static int do_ssl;
static int do_ssl_child;
static int do_ssl_con;
static char* certfile;
static char* keyfile;
static char* cipher;
static SSL_CTX* ssl_ctx;
#endif /* USE_SSL */
static char cwd[MAXPATHLEN];
static int got_hup;
static int lfd;
#ifdef TR069
static int do_tr69;
#endif
static int ifcnt;
static int fds[10];
static int j;
//static struct sockaddr_in sarray[10];
static usockaddr sarray[10];
static int fcount;
/* Request variables. */
static int conn_fd;
static int conn_fds[10];
int child_listen_fd = -1;
int child_accept_fd = -1;

#ifdef USE_SSL
static SSL* ssl;
#endif /* USE_SSL */
static usockaddr client_addr;
static char* request;
static size_t request_size, request_len, request_idx;
static int method;
static char* path;
static char* file;
static char* pathinfo;
struct stat sb;
static char* query;
static char* protocol;
static int status;
static off_t bytes;
static char* req_hostname;

static char* authorization;
static size_t content_length;
static char* content_type;
static char* cookie;
static char* host;
static time_t if_modified_since;
static char* referer;
static char* useragent;
static char* soapaction;
static char *method_type;
static char* remoteuser;
static char *Language;
static int g_iswebupg = 0;

time_t upgradeFw_t0,upgradeFw_t1;

/* Forwards. */
static char *parse_digest(char *,char *);
static void usage( void );
static void read_config( char* filename );
static void value_required( char* name, char* value );
static void no_value_required( char* name, char* value );
static int initialize_listen_socket( usockaddr* usaP );
static int initialize_listen_sockets(void);
static void handle_request( int );
static void de_dotdot( char* file );
static int get_pathinfo( void );
static void send_redirect2page();
static void do_file( void );
static void do_dir( void );
static void handle_usr(int);
int get_interface(void);
static void send_Digest(void);
//extern int CalcDigest(char *,char *,char *,char *,char *,char *,char *,char *,char *,char **);
#ifdef HAVE_SCANDIR
static char* file_details( const char* dir, const char* name );
static void strencode( char* to, size_t tosize, const char* from );
#endif /* HAVE_SCANDIR */
static void do_cgi( void );
static void cgi_interpose_input( int wfd );
static void post_post_garbage_hack( void );
static void cgi_interpose_output( int rfd, int parse_headers );
static char** make_argp( void );
static char** make_envp( void );
static char* build_env( char* fmt, char* arg );
static void auth_check( char* dirname );
static void send_authenticate( char* realm );
static char* virtual_file( char* file );
static void send_error( int s, char* title, char* extra_header, char* text );
static void send_error_body( int s, char* title, char* text );
static int send_error_file( char* filename );
static void send_error_tail( void );
static void add_headers( int s, char* title, char* extra_header, char* me, char* mt, off_t b, time_t mod );
static void start_request( void );
static void add_to_request( char* str, size_t len );
static char* get_request_line( void );
static void start_response( void );
static void add_to_response( char* str, size_t len );
static void send_response( void );
static void send_via_write( int fd, off_t size );
static ssize_t my_read( char* buf, size_t size );
static ssize_t my_write( char* buf, size_t size );
#ifdef HAVE_SENDFILE
static int my_sendfile( int fd, int socket, off_t offset, size_t nbytes );
#endif /* HAVE_SENDFILE */
static void add_to_buf( char** bufP, size_t* bufsizeP, size_t* buflenP, char* str, size_t len );
static void make_log_entry( void );
static void check_referer( void );
static int really_check_referer( void );
static char* get_method_str( int m );
static void init_mime( void );
static const char* figure_mime( char* name, char* me, size_t me_size );
static void handle_sigterm( int sig );
static void handle_sighup( int sig );
static void handle_sigchld( int sig );
static void re_open_logfile( void );
static void handle_read_timeout( int sig );
static void handle_write_timeout( int sig );
static void lookup_hostname( usockaddr* usa4P, size_t sa4_len, int* gotv4P, usockaddr* usa6P, size_t sa6_len, int* gotv6P );
static char* ntoa( usockaddr* usaP );
static int sockaddr_check( usockaddr* usaP );
static size_t sockaddr_len( usockaddr* usaP );
static void strdecode( char* to, char* from );
static int hexit( char c );
static int b64_decode( const char* str, unsigned char* space, int size );
static void set_ndelay( int fd );
static void clear_ndelay( int fd );
static void* e_malloc( size_t size );
static void* e_realloc( void* optr, size_t size );
static char* e_strdup( char* ostr );
int childpid;
#ifdef NO_SNPRINTF
static int snprintf( char* str, size_t size, const char* format, ... );
#endif /* NO_SNPRINTF */
static void accept_conn(void);
static void httpd_cleanup(void);
fd_set lfdset;
int maxfd;
usockaddr usa;
int sz,r;
static void dmn(void);
static void ssl_start(void);
void ssl_cleanup(void);
static void ssl_exit(void);
char *env_getvar(char *name) ;

int safe_strcmp(const char *s1, const char *s2);
int safe_strncmp(const char *s1, const char *s2, size_t n);

// gxw / 2015-11-11 / ӽ̵cgi򻥳
#ifdef USE_SEM_SEMUN
union semun
{
    int val;
    struct semid_ds *buf;
    unsigned short int *array;
    struct seminfo *__buf;
};

static int concurrency_cunt = 10;
static int sem_id = -1;
int sem_init()
{
	int iKey = 0;
	int iRet = 0;
	union  semun unSemArg;
	
	system(">/var/httpd_sem_id");
	
	iKey = ftok("/var/httpd_sem_id", 1);

	sem_id = semget(iKey, 1, IPC_CREAT | IPC_EXCL | 0666);
	if (sem_id < 0) {
		system(">/var/semget_failed");
	}

	unSemArg.val = 1;
	iRet = semctl(sem_id, 0, SETVAL, unSemArg);
	if (iRet < 0) {
		system(">/var/semctl_failed");
	}

}

int sem_get()
{
	int iRet = 0;

	struct sembuf stAskForRes = {0, -1, SEM_UNDO};
	iRet = semop(sem_id, &stAskForRes, 1);
}

int sem_free()
{
	int iRet = 0;

	struct sembuf stFreeRes = {0, 1, SEM_UNDO};
	iRet = semop(sem_id, &stFreeRes, 1);
}
void Minihttp_Log(char *szFmt, ...)
{
    static char buff[1024];
    long nLen;
    memset(buff,0, 1024);
    vsnprintf(buff, sizeof(buff), szFmt, (va_list)(&szFmt + 1));
    nLen = strlen(buff);
    if (nLen < 0)
        strcpy(buff, "Overflow");
    else if (nLen > (sizeof(buff) - 4))
        buff[sizeof(buff) - 1] = 0; /* Make sure terminated */

    FILE *fp = fopen("/var/minihttp.txt", "a");
    fprintf(fp, "%s", buff);
    fclose(fp);
}

#endif


//cmm

#ifdef CMMIF_DEBUG
#define CMMIF_TRACE(fmt, args...) \
	printf("%s:%s:%d "fmt,  __FILE__, __func__, __LINE__, ##args)
#else
#define CMMIF_TRACE(fmt, args...) ((void)(fmt))
#endif

static int g_iInit = 0;	/* 0 - uninitialized; 1 - initialized success; 2 - initialized failed */
static unsigned int g_uMsgId = 0;
#define CMM_INIT_NONE			0
#define CMM_INIT_SUCCESS		1
#define CMM_INIT_FAILED		2

#define CMM_SUCCESS	MSG_OK
#define CMM_FAIL		(MSG_OK+1)
#define CMM_ERR_SEND	(MSG_OK+2)
#define CMM_ERR_RECV	(MSG_OK+3)
#define CMM_ERR_TIMEOUT	(MSG_OK+4)
#define CMM_ERR_MEM	(MSG_OK+5)

#define CALL_CMM_TIMEOUT	5 /* seconds */

int CMM_Init()
{
	MSG_RET iRet;
	if (g_iInit==CMM_INIT_NONE) {
		iRet = MSG_RegModule(MID_MINIHTTPD_SELF, NULL);	/* CMM_Call()ԼϢԲҪϢѭ */
		if (RET_FAILED(iRet)) {
			g_iInit = CMM_INIT_FAILED;
			CMMIF_TRACE("err: register module STAT failed (%d)!\n", iRet);
		} else {
			MSG_AllModStartOK();
			g_iInit = CMM_INIT_SUCCESS;
			CMMIF_TRACE("msg: register module STAT successed.\n");
		} 
	}

	return g_iInit;
}

void CMM_Free()
{
	if (g_iInit==CMM_INIT_SUCCESS) {
		MSG_UnregModule(MID_MINIHTTPD_SELF, NULL);
		g_iInit = CMM_INIT_NONE;
		CMMIF_TRACE("msg: unregistered module STAT.\n");
	}
}

#if 1
int CMM_Call(ST_MSG* pReq, ST_MSG** ppRsp)
{
	MSG_RET iRet;
	time_t t0, t1, t;


	iRet = MSG_SendMessage(pReq);
	if (iRet!=MSG_OK) {
		CMMIF_TRACE("err: send request to CMM failed (%d)!\n", iRet);
		return CMM_ERR_SEND;
	}
#ifdef CMMIF_DEBUG
	SNMPA_ShowMessage(pReq);
#endif

//ע⣬ΪǲãԲ
//wulihua 2010-3-16 add 
	if(pReq->stMsgHead.usMsgType == MSG_CMM_SET_VAL)
	{
		return CMM_SUCCESS; 
	}

	
	t = t0 = time(NULL);
	t1 = t0+CALL_CMM_TIMEOUT;
	for (;;) {
		t = time(NULL);
		if (t>t1) {	/* ȴӦʱ */
			CMMIF_TRACE("err: wait CMM response timeout (%d seconds)!\n", CALL_CMM_TIMEOUT);
			return CMM_ERR_TIMEOUT;
		}

		iRet = MSG_ReceiveMessage(ppRsp, t1-t);
		if (iRet!=MSG_OK) {
			CMMIF_TRACE("err: receive response from CMM failed (%d)!\n", iRet);
			//return CMM_ERR_RECV; //wulihua 2010-3-10 ˳ˣ֪ʲôԭ

			continue;
		}
		/*  յһϢ */
		if (*ppRsp) {
			ST_MSG* pRsp = *ppRsp;
			if (pRsp->stMsgHead.ulMsgID==pReq->stMsgHead.ulMsgID&&
				pRsp->stMsgHead.usDstMID==pReq->stMsgHead.usSrcMID&&
				pRsp->stMsgHead.usSrcMID==pReq->stMsgHead.usDstMID)
			{
				/* յӦӦϢ˳ѭ */
#ifdef CMMIF_DEBUG
				SNMPA_ShowMessage(pRsp);
#endif
				break;
			} else {
#ifdef ZTE_HOT_AP_SNMP_IF
				/* ǶӦӦϢǷsnmpa_MsgProcessҪģ */
#if 0 
			  if(snmpa_MsgProcess(pRsp) == TBS_SUCCESS)
                            {
                                safe_free_msg(pRsp);
                            }
                            else 
#endif
//			snmpa_MsgProcess(pRsp) ;
                        safe_free_msg(pRsp);
#endif
//                                MSG_ReleaseMessage(*ppRsp);
			}
		} else {
			CMMIF_TRACE("err: received a null response, why?!\n");
			return CMM_FAIL;
		}
	}
	return CMM_SUCCESS;
}



ST_MSG* CMM_CreateMessage(
	unsigned short usSrcMID, unsigned short usDstMID,
	unsigned short usMsgType, unsigned long ulBodyLength)
{
	ST_MSG* pMsg = (ST_MSG*)NULL;
	pMsg = MSG_CreateMessage(ulBodyLength);
	if (!pMsg) {
		CMMIF_TRACE("err: %s() failed - MSG_CreateMessage() returned NULL(SrcMID=%04x,DstMID=%04x,MsgType=%04x,BodySize=%08x)!\n",
			__func__, usSrcMID, usDstMID, usMsgType, (unsigned int)ulBodyLength);
		return  (ST_MSG* )NULL;
	}
	pMsg->stMsgHead.usSrcMID = usSrcMID;
	pMsg->stMsgHead.usDstMID = usDstMID;
	pMsg->stMsgHead.ulMsgID = ++g_uMsgId;
	pMsg->stMsgHead.usMsgType = usMsgType;
	pMsg->stMsgHead.ulBodyLength = ulBodyLength;
	return pMsg;
}	
ST_MSG* CMM_CreateGetValMessage(const char* szLeafName)
{
	unsigned long ulBodySize = (sizeof(unsigned long)+strlen(szLeafName)+1);
	ST_MSG* pMsg = CMM_CreateMessage(
		MID_MINIHTTPD_SELF, MID_CMM,
		MSG_CMM_GET_VAL, ulBodySize);

	if (!pMsg) {
		return NULL;
	}

	/* Body */
	*((unsigned long*)pMsg->szMsgBody) = 1;	/* PathCount */
	strcpy(pMsg->szMsgBody+sizeof(unsigned long), szLeafName);		/* Path1 */

	return pMsg;
}

int CMM_GetStr(const char* szLeafName, char* szValue, unsigned int uSize, char **pv, int pvLen)
{
	MSG_RET iRet = CMM_SUCCESS;
	ST_MSG* pReq = NULL;
	ST_MSG* pRsp = NULL;
	char* pcItem = NULL;
	char* pc = NULL;
	u_long ulResult = 0;

	pReq = CMM_CreateGetValMessage(szLeafName);
	if (!pReq) {
		iRet = CMM_ERR_MEM;
		goto EXIT1;
	}

	iRet = CMM_Call(pReq, &pRsp);
	if (iRet!=CMM_SUCCESS) {
		goto EXIT2;
	}

	ulResult = *((u_long*)pRsp->szMsgBody);
	if (0!=ulResult) {
		iRet = CMM_FAIL;
		CMMIF_TRACE("err: get node value failed (%s result=%lu)!\n",
			szLeafName, ulResult);
		goto EXIT3;
	}

	pcItem = pRsp->szMsgBody+sizeof(unsigned long)+sizeof(unsigned long);	/* Result + Status */
	CMMIF_TRACE("msg: %s()--->%s\n", __func__, pcItem);
	pc = strtok(pcItem, "=");
	pc = strtok(NULL, "\n\r");
	if (pc) {
		strncpy(szValue, pc, uSize-1);
		szValue[uSize-1] = 0;
	} else {
		*szValue = 0;
	}
	CMMIF_TRACE("msg: value='%s'\n", szValue);

       /*map the pv and try to find the matched value*/
       if(pv && pvLen > 1) /*at least pvlen is 2*/
       {
            int found = 0;
            int i = 0;
            char *p = pv[i];
            while(1)
            {
                if(strcasecmp(szValue, pv[i]) == 0) /*compare name: value read from CMM*/
                {
                    found = 1;
                    strcpy(szValue, pv[i+1]); /*retrieve the value: value transfered to SNMP manager*/
                    break;
                }

                i += 2;
                if(i >= pvLen) break;
                
                p = pv[i];
            }
            
            if(found == 0) 
            {
               // SNMPA_TRACE("Failed to get %s, because being unmathced!\n", szLeafName);
                //iRet = CMM_FAIL; /*If no item matched the value, return it as successful*/
            }
       }

EXIT3:
	MSG_ReleaseMessage(pRsp);
EXIT2:
	MSG_ReleaseMessage(pReq);
EXIT1:
	return iRet;
}

#endif
//cmm end
int
main( int argc, char** argv )
{
    int argn;
    /* START - Added on 28-04-2006 Missedout during merging */
    #ifdef CLEAREOC
        FILE *http_pid=NULL;
    #endif
    /* END   - Added on 28-04-2006 Missedout during merging */
    struct passwd* pwd;
    uid_t uid = 0;
    gid_t gid = 0;
	int ret=-1;/*Added*/
	struct stat sbuf;/*Added*/
    usockaddr host_addr4;
    usockaddr host_addr6;
    int gotv4, gotv6;
    char* cp;


    /* Parse args. */
    argv0 = argv[0];
    debug = 0;
    port = 0;
    dir = (char*) 0;
    data_dir = (char*) 0;
    do_chroot = 0;
    vhost = 0;
    cgi_pattern = (char*) 0;
    url_pattern = (char*) 0;
    no_empty_referers = 0;
    local_pattern = (char*) 0;
    charset = DEFAULT_CHARSET;
    p3p = (char*) 0;
    max_age = -1;
    //user = DEFAULT_USER;
    hostname = (char*) 0;
    logfile = (char*) 0;
    pidfile = (char*) 0;
    logfp = (FILE*) 0;
#ifdef USE_SSL
    do_ssl = 0;
	do_ssl_child = 0;
	do_ssl_con = 0;
//    certfile = DEFAULT_CERTFILE;
    cipher = (char*) 0;
#endif /* USE_SSL */
    argn = 1;

	/***Command Line Parsing***/
    while ( argn < argc && argv[argn][0] == '-' )
	{
		if ( safe_strcmp( argv[argn], "-V" ) == 0 )
		{
			(void) printf( "%s\n", SERVER_SOFTWARE );
			exit( 0 );
		}
		else if ( safe_strcmp( argv[argn], "-C" ) == 0 && argn + 1 < argc )
		{
			++argn;
			read_config( argv[argn] );
		}
		else if ( safe_strcmp( argv[argn], "-D" ) == 0 )
			debug = 1;
	#ifdef USE_SSL
		else if ( safe_strcmp( argv[argn], "-S" ) == 0 )
			do_ssl = 1;
		else if ( safe_strcmp( argv[argn], "-E" ) == 0 && argn + 1 < argc )
		{
			++argn;
			certfile = argv[argn];
		}
		else if ( safe_strcmp( argv[argn], "-K" ) == 0 && argn + 1 < argc )
		{
			++argn;
			keyfile = argv[argn];
		}
		else if ( safe_strcmp( argv[argn], "-Y" ) == 0 && argn + 1 < argc )
		{
			++argn;
			cipher = argv[argn];
		}
	#endif /* USE_SSL */
		else if ( safe_strcmp( argv[argn], "-p" ) == 0 && argn + 1 < argc )
		{
			++argn;
			port = (unsigned short) atoi( argv[argn] );
		}
		else if ( safe_strcmp( argv[argn], "-d" ) == 0 && argn + 1 < argc )
		{
			++argn;
			dir = argv[argn];
		}
		else if ( safe_strcmp( argv[argn], "-dd" ) == 0 && argn + 1 < argc )
		{
			++argn;
			data_dir = argv[argn];
		}
		else if ( safe_strcmp( argv[argn], "-c" ) == 0 && argn + 1 < argc )
		{
			++argn;
			cgi_pattern = argv[argn];
			if(cgi_pattern[0]=='/')
			{
				cgi_pattern++;
				cgi_pattern_tmp=strdup(cgi_pattern);
			}

		}
		else if ( safe_strcmp( argv[argn], "-u" ) == 0 && argn + 1 < argc )
		{
			++argn;
			user = argv[argn] ;
		}
		else if ( safe_strcmp( argv[argn], "-h" ) == 0 && argn + 1 < argc )
		{
			++argn;
			hostname = argv[argn];
		}
		else if ( safe_strcmp( argv[argn], "-r" ) == 0 )
			do_chroot = 1;
		else if ( safe_strcmp( argv[argn], "-v" ) == 0 )
			vhost = 1;
		else if ( safe_strcmp( argv[argn], "-l" ) == 0 && argn + 1 < argc )
		{
			++argn;
			logfile = argv[argn];
		}
		else if ( safe_strcmp( argv[argn], "-i" ) == 0 && argn + 1 < argc )
		{
			++argn;
			pidfile = argv[argn];
		}
		else if ( safe_strcmp( argv[argn], "-T" ) == 0 && argn + 1 < argc )
		{
			++argn;
			charset = argv[argn];
		}
		else if ( safe_strcmp( argv[argn], "-P" ) == 0 && argn + 1 < argc )
		{
			++argn;
			p3p = argv[argn];
		}
		else if ( safe_strcmp( argv[argn], "-M" ) == 0 && argn + 1 < argc )
		{
			++argn;
			max_age = atoi( argv[argn] );
		}
		else
			usage();
		++argn;
	}/***End Command Line Parsing***/
    if ( argn != argc )
		usage();

    cp = strrchr( argv0, '/' );
    if ( cp != (char*) 0 )
		++cp;
    else
		cp = argv0;
    openlog( cp, LOG_NDELAY|LOG_PID, LOG_DAEMON );

	dmn();

    if ( port == 0 )
	{
		#ifdef USE_SSL
			if ( do_ssl )
				port = DEFAULT_HTTPS_PORT;
			else
				port = DEFAULT_HTTP_PORT;
		#else /* USE_SSL */
			port = DEFAULT_HTTP_PORT;
		#endif /* USE_SSL */
	}
    /* If we're root and we're going to become another user, get the uid/gid
    ** now.
    */
#if 0
    if ( getuid() == 0 )
	{
		pwd = getpwnam( user );
		if ( pwd == (struct passwd*) 0 )
		{
			syslog( LOG_CRIT, "unknown user - '%s'", user );
			(void) fprintf( stderr, "%s: unknown user - '%s'\n", argv0, user );
			exit( 1 );
		}
		uid = pwd->pw_uid;
		gid = pwd->pw_gid;
	}
#endif
    /* Log file. */
    if ( logfile != (char*) 0 )
	{
		logfp = fopen( logfile, "a" );
		if ( logfp == (FILE*) 0 )
		{
			syslog( LOG_CRIT, "%s - %m", logfile );
			perror( logfile );
			exit( 1 );
		}
		if ( logfile[0] != '/' )
		{
			syslog( LOG_WARNING, "logfile is not an absolute path, you may not be able to re-open it" );
			(void) fprintf( stderr, "%s: logfile is not an absolute path, you may not be able to re-open it\n", argv0 );
		}
		if ( getuid() == 0 )
		{
			/* If we are root then we chown the log file to the user we'll
			** be switching to.
			*/
			if ( fchown( fileno( logfp ), uid, gid ) < 0 )
			{
				syslog( LOG_WARNING, "fchown logfile - %m" );
				perror( "fchown logfile" );
			}
		}
	}

    if ( pidfile != (char*) 0 )
    {
		/* Write the PID file. */
		FILE* pidfp = fopen( pidfile, "w" );
		if ( pidfp == (FILE*) 0 )
		{
			syslog( LOG_CRIT, "%s - %m", pidfile );
			perror( pidfile );
			exit( 1 );
		}
			(void) fprintf( pidfp, "%d\n", (int) getpid() );
			(void) fclose( pidfp );
	}

    /* START - Added on 28-04-2006 Missedout during merging */
     #ifdef CLEAREOC
        http_pid = fopen( "/var/tmp/httpd_pid", "w");
        if (http_pid)
        {
                (void)fprintf(http_pid,"%d\n",(int)getpid());
                (void)fclose(http_pid);
        }
    #endif
    /* END   - Added on 28-04-2006 Missedout during merging */

    /* Read zone info now, in case we chroot(). */
    tzset();

    /* If we're root, start becoming someone else. */
    if ( getuid() == 0 )
	{
		/* Set aux groups to null. */
		if ( setgroups( 0, (gid_t*) 0 ) < 0 )
		{
			syslog( LOG_CRIT, "setgroups - %m" );
			perror( "setgroups" );
			exit( 1 );
		}
		/* Set primary group. */
		if ( setgid( gid ) < 0 )
		{
			syslog( LOG_CRIT, "setgid - %m" );
			perror( "setgid" );
			exit( 1 );
		}
		/* Try setting aux groups correctly - not critical if this fails. */
		if ( initgroups( user, gid ) < 0 )
		{
			syslog( LOG_ERR, "initgroups - %m" );
			perror( "initgroups" );
		}
	#ifdef HAVE_SETLOGIN
		/* Set login name. */
		(void) setlogin( user );
	#endif /* HAVE_SETLOGIN */
	}

    /* Switch directories if requested. */
    if ( dir != (char*) 0 )
	{
		if ( chdir( dir ) < 0 )
		{
			syslog( LOG_CRIT, "chdir - %m" );
			perror( "chdir" );
			exit( 1 );
		}
	}

    /* Get current directory. */
    (void) getcwd( cwd, sizeof(cwd) - 1 );
    if ( cwd[strlen( cwd ) - 1] != '/' )
		(void) strcat( cwd, "/" );

    /* Chroot if requested. */
    if ( do_chroot )
	{
		if ( chroot( cwd ) < 0 )
		{
			syslog( LOG_CRIT, "chroot - %m" );
			perror( "chroot" );
			exit( 1 );
		}
		/* If we're logging and the logfile's pathname begins with the
		** chroot tree's pathname, then elide the chroot pathname so
		** that the logfile pathname still works from inside the chroot
		** tree.
		*/
		if ( logfile != (char*) 0 )
			if ( safe_strncmp( logfile, cwd, strlen( cwd ) ) == 0 )
			{
				(void) strcpy( logfile, &logfile[strlen( cwd ) - 1] );
				/* (We already guaranteed that cwd ends with a slash, so leaving
				** that slash in logfile makes it an absolute pathname within
				** the chroot tree.)
				*/
			}
			else
			{
				syslog( LOG_WARNING, "logfile is not within the chroot tree, you will not be able to re-open it" );
				(void) fprintf( stderr, "%s: logfile is not within the chroot tree, you will not be able to re-open it\n", argv0 );
			}
		(void) strcpy( cwd, "/" );
		/* Always chdir to / after a chroot. */
		if ( chdir( cwd ) < 0 )
		{
			syslog( LOG_CRIT, "chroot chdir - %m" );
			perror( "chroot chdir" );
			exit( 1 );
		}

	}

    /* Switch directories again if requested. */
    if ( data_dir != (char*) 0 )
	{
	if ( chdir( data_dir ) < 0 )
	    {
	    syslog( LOG_CRIT, "data_dir chdir - %m" );
	    perror( "data_dir chdir" );
	    exit( 1 );
	    }
	}

    /* If we're root, become someone else. */
    if ( getuid() == 0 )
	{
		/* Set uid. */
		if ( setuid( uid ) < 0 )
		{
			syslog( LOG_CRIT, "setuid - %m" );
			perror( "setuid" );
			exit( 1 );
		}
	}
    /* Catch various signals. */
#ifdef HAVE_SIGSET
    (void) sigset( SIGTERM, handle_sigterm );
    (void) sigset( SIGINT, handle_sigterm );
    (void) sigset( SIGUSR1, handle_sigterm );
    (void) sigset( SIGHUP, handle_sighup );
    (void) sigset( SIGCHLD, handle_sigchld );
    (void) sigset( SIGPIPE, SIG_IGN );
#else /* HAVE_SIGSET */
    (void) signal( SIGTERM, handle_sigterm );
    (void) signal( SIGINT, handle_sigterm );
    (void) signal( SIGUSR1, handle_sigterm );
    (void) signal( SIGHUP, handle_sighup );
    (void) signal( SIGCHLD, handle_sigchld );
    (void) signal( SIGPIPE, SIG_IGN );
#endif /* HAVE_SIGSET */

#if 1
	if (CMM_INIT_SUCCESS != CMM_Init())
	{
		printf("[stat]:%s:%d:CMM_Init failed , existing ...\n",
		__FUNCTION__,__LINE__);
		CMM_Free();
		exit(-1);			
	}
#endif
	
    got_hup = 0;
    init_mime();

#ifdef USE_SEM_SEMUN	
	// gxw / 2015-11-11 / ӽ̵cgi򻥳
	sem_init();
#endif	
	initialize_listen_sockets();
	ssl_start();

	accept_conn();
	
	CMM_Free();
}
static void dmn()
{
    if ( ! debug )
	{
		/* Make ourselves a daemon. */
	#ifdef HAVE_DAEMON
		if ( daemon( 1, 1 ) < 0 )
		{
			syslog( LOG_CRIT, "daemon - %m" );
			perror( "daemon" );
			exit( 1 );
		}
	#else
		switch ( fork() )
		{
			case 0:
			break;
			case -1:
			syslog( LOG_CRIT, "fork - %m" );
			perror( "fork" );
			exit( 1 );
			default:
			exit( 0 );
		}
	#ifdef HAVE_SETSID
		(void) setsid();
	#endif
	#endif
	}
    else
	{
	/* Even if we don't daemonize, we still want to disown our parent
	** process.
	*/
#ifdef HAVE_SETSID
	(void) setsid();
#endif /* HAVE_SETSID */
	}
}

static void
usage( void )
{
#ifdef USE_SSL
    (void) fprintf( stderr, "usage:  %s [-C configfile] [-D] [-S] [-E certfile] [-Y cipher] [-p port] [-d dir] [-dd data_dir] [-c cgipat] [-u user] [-h hostname] [-r] [-v] [-l logfile] [-i pidfile] [-T charset] [-P P3P] [-M maxage]\n", argv0 );
#else /* USE_SSL */
    (void) fprintf( stderr, "usage:  %s [-C configfile] [-D] [-p port] [-d dir] [-dd data_dir] [-c cgipat] [-u user] [-h hostname] [-r] [-v] [-l logfile] [-i pidfile] [-T charset] [-P P3P] [-M maxage]\n", argv0 );
#endif /* USE_SSL */
    exit( 1 );
}


static void
read_config( char* filename )
{
    FILE* fp;
    char *line;/*[10000]*/
    char* cp;
    char* cp2;
    char* name;
    char* value;
    char* user1 ;
	if((line=(char *)malloc(LARGE_BUFF))==NULL)
	{
		syslog( LOG_CRIT, "out of memory exiting" );
		exit(1);
	}


    fp = fopen( filename, "r" );
    if ( fp == (FILE*) 0 )
	{
		syslog( LOG_CRIT, "%s - %m", filename );
		perror( filename );
		free(line);
		exit( 1 );
	}

    while ( fgets( line,LARGE_BUFF, fp ) != (char*) 0 )
	{
		/* Trim comments. */
		if ( ( cp = strchr( line, '#' ) ) != (char*) 0 )
			*cp = '\0';

		/* Skip leading whitespace. */
		cp = line;
		cp += strspn( cp, " \t\012\015" );

		/* Split line into words. */
		while ( *cp != '\0' )
		{
			/* Find next whitespace. */
			cp2 = cp + strcspn( cp, " \t\012\015" );
			/* Insert EOS and advance next-word pointer. */
			while ( *cp2 == ' ' || *cp2 == '\t' || *cp2 == '\012' || *cp2 == '\015' )
				*cp2++ = '\0';
			/* Split into name and value. */
			name = cp;
			value = strchr( name, '=' );
			if ( value != (char*) 0 )
				*value++ = '\0';
			/* Interpret. */
			if ( strcasecmp( name, "debug" ) == 0 )
			{
				no_value_required( name, value );
				debug = 1;
			}
			else if ( strcasecmp( name, "port" ) == 0 )
			{
				value_required( name, value );
				port = (unsigned short) atoi( value );
			}
			else if ( strcasecmp( name, "dir" ) == 0 )
			{
				value_required( name, value );
				dir = e_strdup( value );
			}
			else if ( strcasecmp( name, "data_dir" ) == 0 )
			{
				value_required( name, value );
				data_dir = e_strdup( value );
			}
			else if ( strcasecmp( name, "chroot" ) == 0 )
			{
				no_value_required( name, value );
				do_chroot = 1;
			}
			else if ( strcasecmp( name, "nochroot" ) == 0 )
			{
				no_value_required( name, value );
				do_chroot = 0;
			}
			else if ( strcasecmp( name, "user" ) == 0 )
			{
				value_required( name, value );
				user = e_strdup( value );
			}
			else if ( strcasecmp( name, "cgipat" ) == 0 )
			{
				value_required( name, value );
				cgi_pattern = e_strdup( value );
			}
			else if ( strcasecmp( name, "urlpat" ) == 0 )
			{
				value_required( name, value );
				url_pattern = e_strdup( value );
			}
			else if ( strcasecmp( name, "noemptyreferers" ) == 0 )
			{
				value_required( name, value );
				no_empty_referers = 1;
			}
			else if ( strcasecmp( name, "localpat" ) == 0 )
			{
				value_required( name, value );
				local_pattern = e_strdup( value );
			}
			else if ( strcasecmp( name, "host" ) == 0 )
			{
				value_required( name, value );
				hostname = e_strdup( value );
			}
			else if ( strcasecmp( name, "logfile" ) == 0 )
			{
				value_required( name, value );
				logfile = e_strdup( value );
			}
			else if ( strcasecmp( name, "vhost" ) == 0 )
			{
				no_value_required( name, value );
				vhost = 1;
			}
			else if ( strcasecmp( name, "pidfile" ) == 0 )
			{
				value_required( name, value );
				pidfile = e_strdup( value );
			}
			else if ( strcasecmp( name, "charset" ) == 0 )
			{
				value_required( name, value );
				charset = e_strdup( value );
			}
			else if ( strcasecmp( name, "p3p" ) == 0 )
			{
				value_required( name, value );
				p3p = e_strdup( value );
			}
			else if ( strcasecmp( name, "max_age" ) == 0 )
			{
				value_required( name, value );
				max_age = atoi( value );
			}
	#ifdef USE_SSL
			else if ( strcasecmp( name, "ssl" ) == 0 )
			{
				no_value_required( name, value );
				do_ssl = 1;
			}
			else if ( strcasecmp( name, "certfile" ) == 0 )
			{
				value_required( name, value );
				certfile = e_strdup( value );
			}
			else if ( strcasecmp( name, "cipher" ) == 0 )
			{
				value_required( name, value );
				cipher = e_strdup( value );
			}
	#endif /* USE_SSL */
			else
			{
				(void)fprintf(stderr,"%s:unknown config option '%s'\n", argv0,name);
				free(line);
				exit( 1 );
			}

			/* Advance to next word. */
			cp = cp2;
			cp += strspn( cp, " \t\012\015" );
		}
	}
	free(line);
    (void) fclose( fp );
}


static void
value_required( char* name, char* value )
{
    if ( value == (char*) 0 )
	{
		(void) fprintf(
			stderr, "%s: value required for %s option\n", argv0, name );
		exit( 1 );
	}
}

static void
no_value_required( char* name, char* value )
{
    if ( value != (char*) 0 )
	{
		(void) fprintf(
			stderr, "%s: no value required for %s option\n",argv0,name);
		exit( 1 );
	}
}
static int
initialize_listen_socket( usockaddr* usaP )
{
    int listen_fd;
    int i;

    /* Check sockaddr. */
    if ( ! sockaddr_check( usaP ) )
	{
		syslog(
			LOG_ERR, "unknown sockaddr family on listen socket - %d",
			usaP->sa.sa_family );
		(void) fprintf(
			stderr, "%s: unknown sockaddr family on listen socket - %d\n",
			argv0, usaP->sa.sa_family );
		return -1;
	}

    listen_fd = socket( usaP->sa.sa_family, SOCK_STREAM, 0 );
    if ( listen_fd < 0 )
	{
		syslog( LOG_CRIT, "socket %.80s - %m", ntoa( usaP ) );

		perror( "socket" );
		return -1;
	}

    (void) fcntl( listen_fd, F_SETFD, 1 );

    i = 1;
    if ( setsockopt( listen_fd, SOL_SOCKET, SO_REUSEADDR, (void*) &i, sizeof(i) ) < 0 )
	{
		syslog( LOG_CRIT, "setsockopt SO_REUSEADDR - %m" );
		perror( "setsockopt SO_REUSEADDR" );
		close(listen_fd);
		return -1;
	}

    if ( bind( listen_fd, &usaP->sa, sockaddr_len( usaP ) ) < 0 )
	{
		syslog( LOG_CRIT, "bind %.80s - %m", ntoa( usaP ) );
		perror( "bind" );
		close(listen_fd);
		return -1;
	}

    if ( listen( listen_fd, 1024 ) < 0 )
	{
		syslog( LOG_CRIT, "listen - %m" );
		perror( "listen" );
		close(listen_fd);
		return -1;
	}

#ifdef HAVE_ACCEPT_FILTERS
    {
		struct accept_filter_arg af;
		(void) bzero( &af, sizeof(af) );
		(void) strcpy( af.af_name, ACCEPT_FILTER_NAME );
		(void) setsockopt( listen_fd, SOL_SOCKET, SO_ACCEPTFILTER, (char*) &af, sizeof(af) );
    }
#endif /* HAVE_ACCEPT_FILTERS */
    return listen_fd;
}

static int
initialize_listen_sockets(void)
{
	int loop;
	int i;
	int j;
	struct sockaddr_in addr;
	int cnt = 0;
	FILE *fp;
	bzero(&addr,sizeof(addr));
	fp=fopen("/var/webport","w+");
	if(fp==NULL)
	{
		syslog(LOG_WARNING,"XXX\tCould not open the port file\n");
	}

#ifdef TR069
	//comm_start("miniHttpd", 0); //wei changed it ==>
       if(MSG_RegModule(MID_TR069_HTTPD, NULL) != 0)
      {
        syslog(LOG_WARNING, "[TR069_HTTPD]TR069_HTTPD_ModuleInit....Failed\n");
      }
	  MSG_AllModStartOK();
#endif

#ifdef USE_IPV6
		/*IPV6 HTTP*/
		sarray[cnt].sa_in6.sin6_family = AF_INET6;
		sarray[cnt].sa_in6.sin6_port = htons(HTTP_PORT);
		sarray[cnt].sa_in6.sin6_addr = in6addr_any;
	
    #ifdef USE_SSL
		/*IPV6 HTTPS*/
		sarray[++cnt].sa_in6.sin6_family = AF_INET6;
		sarray[cnt].sa_in6.sin6_port = htons(HTTPS_PORT);
		sarray[cnt].sa_in6.sin6_addr = in6addr_any;
		max_services++;
    #endif
	
    #ifdef TR069
		/*IPV6 TR069*/
		sarray[++cnt].sa_in6.sin6_family = AF_INET6;
		sarray[cnt].sa_in6.sin6_port = htons(TR69PORT);
		sarray[cnt].sa_in6.sin6_addr = in6addr_any;
		max_services++;
    #endif
#else
		/*IPV4 HTTP*/
		sarray[cnt].sa_in.sin_family = AF_INET;
		sarray[cnt].sa_in.sin_port=htons(HTTP_PORT);
		sarray[cnt].sa_in.sin_addr.s_addr=htonl(INADDR_ANY);
#ifdef USE_SSL
		/*IPV4 HTTPS*/
		sarray[++cnt].sa_in.sin_family = AF_INET;
		sarray[cnt].sa_in.sin_port=htons(HTTPS_PORT);
		sarray[cnt].sa_in.sin_addr.s_addr=htonl(INADDR_ANY);
		max_services++;
	
#endif
	
#if 0
		/*IPV4 TR069*/
		sarray[++cnt].sa_in.sin_family = AF_INET;
		sarray[cnt].sa_in.sin_port=htons(TR69PORT);
		/* Need to bind to a specific TR069 interface. For testing purpose, binding to INADDR_ANY */
		sarray[cnt].sa_in.sin_addr.s_addr=htonl(INADDR_ANY);
		max_services++;
	
	
#if 0
				for(loop=0;loop<ifcnt-1;loop++)
				{
					if(safe_strcmp(inf[loop].infname,TR69INF)==0)
						inet_aton(inf[loop].infaddr,&sarray[2].sin_addr);
				}
#endif
#endif
#endif

	for(cnt = 0; cnt < max_services; cnt++)
	{
		fds[cnt]=socket(sarray[cnt].sa.sa_family,SOCK_STREAM,0);
		if (fds[cnt]<0)
		{
			syslog(LOG_CRIT,"socket - %m");
			perror( "socket" );
			fclose(fp);
			remove("/var/webport");
			return -1;
		}
		fcntl(fds[cnt],F_SETFL,fcntl(fds[cnt],F_GETFL,0)|O_NONBLOCK);
		(void)fcntl(fds[cnt],F_SETFD,1);

		i = 1;
		if (setsockopt(fds[cnt], SOL_SOCKET, SO_REUSEADDR,(void*) &i,sizeof(i) )< 0)
		{
			syslog( LOG_CRIT, "setsockopt SO_REUSEADDR - %m" );
			perror( "setsockopt SO_REUSEADDR" );
			fclose(fp);
			remove("/var/webport");
			return -1;
		}
		if ( bind(fds[cnt], (struct sockaddr *)&sarray[cnt].sa,sockaddr_len(&sarray[cnt]))<0)
		{
			syslog( LOG_CRIT, "bind - %m" );
			perror( "bind" );
			fclose(fp);
			remove("/var/webport");
			return -1;
		}

		if ( listen(fds[cnt], 1024 ) < 0 )
		{
			syslog( LOG_CRIT, "listen - %m" );
			perror( "listen" );
			fclose(fp);
			remove("/var/webport");
			return -1;
		}

		#ifdef HAVE_ACCEPT_FILTERS
		{
			struct accept_filter_arg af;
			(void) bzero( &af, sizeof(af) );
			(void) strcpy( af.af_name, ACCEPT_FILTER_NAME );
			(void) setsockopt(fds[cnt],SOL_SOCKET,SO_ACCEPTFILTER,(char*)&af,sizeof(af) );
		}
		#endif /* HAVE_ACCEPT_FILTERS */
		if (fp != NULL)
		{
            if (sarray[cnt].sa.sa_family == AF_INET)
    			fprintf(fp,"ipv4:%d\n",ntohs(sarray[cnt].sa_in.sin_port));
#ifdef USE_IPV6
            if (sarray[cnt].sa.sa_family == AF_INET6)
                fprintf(fp,"ipv6:%d\n",ntohs(sarray[cnt].sa_in6.sin6_port));
#endif
		}
	}
	fclose(fp);
	return 0;
}

static void accept_conn(void)
{
    //struct sockaddr_in tmpaddr;
    usockaddr tmpaddr;
    unsigned short tmpport;
	int sze;
	int kidstatus;
	int parent_con_fd;
	/* Main loop. */
	for (;;)
	{
		/* Do we need to re-open the log file? */
		int cnt=0;
		int ret;
		if ( got_hup )
		{
			re_open_logfile();
			got_hup = 0;
		}

		/* Do a select() on at least one and possibly two listen fds.
		** If there's only one listen fd then we could skip the select
		** and just do the (blocking) accept(), saving one system call;
		** that's what happened up through version 1.18.  However there
		** is one slight drawback to that method: the blocking accept()
		** is not interrupted by a signal call.  Since we definitely want
		** signals to interrupt a waiting server, we use select() even
		** if there's only one fd.
		*/
		FD_ZERO( &lfdset);
		maxfd = -1;
		for(cnt = 0; cnt < max_services; cnt++)
		{
			if (fds[cnt] != -1)
			{
				FD_SET(fds[cnt],&lfdset);
				if (fds[cnt]>maxfd )
					maxfd=fds[cnt];
			}
		}
        /* Jyothi Changing the timout to zero instead of timeout which is 15 secs */
		if ((ret=select( maxfd + 1, &lfdset, (fd_set*) 0, (fd_set*) 0, (struct timeval*) 0))<0)
		{
			if ( errno == EINTR || errno == EAGAIN )
				continue;	/* try again */
/* Jyothi Removing this error messge. Need to fix this
 * 			syslog( LOG_CRIT, "select - %m" );
 */

			perror( "select" );
			httpd_cleanup();
			ssl_exit();
			exit( 1 );
		}
		if(ret==0)
			continue;
		/* Accept the new connection. */
		sz = sizeof(usa);

		for(cnt = 0; cnt < max_services; cnt++)
		{
			if (fds[cnt] != -1 && FD_ISSET(fds[cnt], &lfdset))
			{
				parent_con_fd= accept(fds[cnt], &usa.sa, &sz );
				if (parent_con_fd<0)
				{
					if ( errno == EINTR || errno == EAGAIN )
					continue;	/* try again */
			#ifdef EPROTO
					if ( errno == EPROTO )
					continue;	/* try again */
			#endif /* EPROTO */
					syslog( LOG_CRIT, "accept - %m" );
					perror( "accept" );
					httpd_cleanup();
					ssl_exit();
					exit( 1 );
				}

				r = fork();
				if ( r < 0 )
				{
					syslog( LOG_CRIT, "fork - %m" );
					perror( "fork" );
					httpd_cleanup();
					ssl_exit();
					exit( 1 );
				}
				if ( r == 0 )
				{
					memset(&tmpaddr, 0, sizeof(usockaddr));
					sze = (int)sizeof(usockaddr);
#ifdef USE_SSL
					do_ssl_child = do_ssl;
#endif
					child_listen_fd = fds[cnt];
					child_accept_fd = parent_con_fd;

					/* Child process. */
					client_addr = usa;

					getsockname(child_listen_fd,(struct sockaddr *)&tmpaddr.sa,&sze);

					if (tmpaddr.sa.sa_family == AF_INET)
					{
                        tmpport = ntohs(tmpaddr.sa_in.sin_port);
					}
#ifdef USE_IPV6
                    else if (tmpaddr.sa.sa_family == AF_INET6)
					{
                        tmpport = ntohs(tmpaddr.sa_in6.sin6_port);
					}
#endif
                    else
                    {
                        syslog( LOG_CRIT, "getsockname - %m" );
                        perror("getsockname");
                        httpd_cleanup();

                        exit(1);
                    }
					if(tmpport == TR69PORT)
					{
#ifdef TR069
						do_tr69=1;
#endif
#ifdef USE_SSL
						if (do_ssl_child)
							do_ssl_con = 0;
#endif

					}
					if(tmpport == HTTPS_PORT)
					{
#ifdef USE_SSL
						do_ssl_con = 1;

#endif
#ifdef TR069
						do_tr69=0;
#endif
					}
					else if(tmpport == HTTP_PORT)
					{
#ifdef USE_SSL
						if (do_ssl_child)
							do_ssl_con = 0;
#endif
#ifdef TR069
						do_tr69=0;
#endif
					}
					if ( child_listen_fd != -1 )
						(void) close(child_listen_fd);

					handle_request(child_accept_fd);
					close(child_accept_fd);
					httpd_cleanup();
					ssl_cleanup();
/* ޸: chenyuedong ⵥ: 0000101 ޸: һ */
                    exit(0);
				}
				if(wait(&kidstatus) != r)
	  			;
#ifdef USE_SEM_SEMUN
				// gxw / 2015-11-11 / ӽ̵cgi򻥳
				if(0 == (--concurrency_cunt))
				{
					wait(&kidstatus);
					concurrency_cunt++;

					//handle_sigchld(0);
				}
#endif
				(void) close( parent_con_fd );
			}
			else
			{
				continue;
			}
		}
		/* Fork a sub-process to handle the connection. */
	}
}

//#define HTTP_SOAP_NETGEAR_GENIE
//#define HTTP_WITH_PARENT_CONTROL
#define REWRITE_CURRENTSETTING_HTM
#define FILE_CURRENTSETTING_HTM "currentsetting.htm"
#define NEW_FILE_CURRENTSETTING_HTM "/var/currentsetting.htm"
//#define REWRITE_DEBUGINFO_HTM
#define FILE_DEBUGINFO_HTM "debuginfo.htm"
#define NEW_FILE_DEBUGINFO_HTM "/var/debuginfo.htm"
#define MAX_SHORT_PATH 128


#ifdef REWRITE_CURRENTSETTING_HTM
int rewrite_currentsetting_file(void)
{
    FILE *pf = NULL;
    char szSV[32] = {0}; //SV = SoftwareVersion
    char szSOAPV[32] = {0}; //SV = SoftwareVersion
    char szRG[16] = {0}; //RG = Region
    char szMN[32] = {0}; //MN = Model Name
    char szObjPath[MAX_SHORT_PATH] = "InternetGatewayDevice.DeviceInfo.";
    char szFullPath[MAX_SHORT_PATH] = {0};
    char szLine[MAX_SHORT_PATH] = {0};
 #ifdef CONFIG_APPS_LOGIC_APCLIENT
    char szConnect_24g[MAX_SHORT_PATH] = {0};
    char szConnect_5g[MAX_SHORT_PATH] = {0};
 #endif
	
    //ȡSoftwareVersion
    snprintf(szFullPath, MAX_SHORT_PATH, "%s%s", szObjPath, "SoftwareVersion");
    CMM_GetStr(szFullPath,szSV,sizeof(szSV)-1, NULL, 0);

    //ȡX_NETGEAR-COM_Region
    snprintf(szFullPath, MAX_SHORT_PATH, "%s%s", szObjPath, "X_TWSZ-COM_Region");
    CMM_GetStr(szFullPath,szRG,sizeof(szRG)-1, NULL, 0);

    //ȡModelName
    snprintf(szFullPath, MAX_SHORT_PATH, "%s%s", szObjPath, "ModelName");
    CMM_GetStr(szFullPath,szMN,sizeof(szMN)-1, NULL, 0);

#ifdef CONFIG_APPS_LOGIC_APCLIENT
    //ȡModelName
    snprintf(szFullPath, MAX_SHORT_PATH, "InternetGatewayDevice.LANDevice.1.X_TWSZ-COM_ApCliConfiguration.1.ApCliRootapConnState");
    CMM_GetStr(szFullPath,szConnect_24g,sizeof(szConnect_24g)-1, NULL, 0);

	snprintf(szFullPath, MAX_SHORT_PATH, "InternetGatewayDevice.LANDevice.1.X_TWSZ-COM_ApCliConfiguration.2.ApCliRootapConnState");
    CMM_GetStr(szFullPath,szConnect_5g,sizeof(szConnect_5g)-1, NULL, 0);
	
#endif
	//ȡ SOAPVersion
	snprintf(szFullPath, MAX_SHORT_PATH, "%s%s", szObjPath, "SOAPVersion");
	CMM_GetStr(szFullPath,szSOAPV,sizeof(szSOAPV)-1, NULL, 0);
	
    /*regionд,Ϊbeta*/
	//snprintf(szRG, sizeof(szRG), "ww");

    //ļ
    pf = fopen(NEW_FILE_CURRENTSETTING_HTM, "w+");
    if (pf == NULL)
    {
        syslog(LOG_ERR, "create %s fail\n", NEW_FILE_CURRENTSETTING_HTM);
        return -1;
    }

    /*дļ*/

    //1.ļд Firmware=V1.0.0.24
    //ӽڵȡѾVȥV
    snprintf(szLine, MAX_SHORT_PATH, "Firmware=%s\n", szSV);
    fwrite(szLine, strlen(szLine), 1, pf);

    //2.ļд RegionTag=WNDR3800_WW
    snprintf(szLine, MAX_SHORT_PATH, "RegionTag=%s_%s\n", szMN, szRG);
    fwrite(szLine, strlen(szLine), 1, pf);

    //3.ļд Region=ww
    snprintf(szLine, MAX_SHORT_PATH, "Region=%s\n", szRG);
    fwrite(szLine, strlen(szLine), 1, pf);

    //4.ļд Model=WNDR3800
    snprintf(szLine, MAX_SHORT_PATH, "Model=%s\n", szMN);
    fwrite(szLine, strlen(szLine), 1, pf);

#ifdef CONFIG_APPS_LOGIC_APCLIENT
	if(0 == safe_strcmp(szConnect_24g, "0") && 0 == safe_strcmp(szConnect_5g, "0"))
	{
    //5.ļд InternetConnectionStatus=Down
    snprintf(szLine, MAX_SHORT_PATH, "InternetConnectionStatus=Down\n");
    }
    else
#endif
    {
    //5.ļд InternetConnectionStatus=Up
    snprintf(szLine, MAX_SHORT_PATH, "InternetConnectionStatus=Up\n");
    }
    fwrite(szLine, strlen(szLine), 1, pf);

#ifdef CONFIG_APPS_LOGIC_APCLIENT
    //6.ļд ParentalControlSupported=1
    snprintf(szLine, MAX_SHORT_PATH, "ParentalControlSupported=0\n");
#else
	snprintf(szLine, MAX_SHORT_PATH, "ParentalControlSupported=1\n");
#endif
    fwrite(szLine, strlen(szLine), 1, pf);


    //7.ļд SOAPVersion=V1.8
    //snprintf(szLine, MAX_SHORT_PATH, "SOAPVersion=V1.8\n");	
    // snprintf(szLine, MAX_SHORT_PATH, "SOAPVersion=%s\n", szSOAPV);	
    // fwrite(szLine, strlen(szLine), 1, pf);

    //8.ļд ReadyShareSupportedLevel=7
    //add zhmm genie now isn'tsupport ReadyShareReadyShareSupportedLevel=0
    snprintf(szLine, MAX_SHORT_PATH, "ReadyShareSupportedLevel=0\n");
    fwrite(szLine, strlen(szLine), 1, pf);

    //رļ
    fclose(pf);
}
#endif


#ifdef HTTP_WITH_PARENT_CONTROL
#define MAX_SOAP_HTTP_HEADER  256
#define MAX_SOAP_HTTP_CONTENT 2048
#define MAX_SOAP_LEN (MAX_SOAP_HTTP_HEADER+MAX_SOAP_HTTP_CONTENT)



#ifdef HTTP_SOAP_NETGEAR_GENIE
#define SOAP_GET_NODE_VALUE(name, val_buf) \
{ \
        ret = soap_get_node_val(szSoapContent, name, val_buf, sizeof(val_buf)); \
        if (ret != 0) \
        { \
            syslog(LOG_ERR, "[%s:%d]call soap_get_node_val OF [%S] fail\n", __FUNCTION__, __LINE__, name); \
            return -1; \
        } \
}
#endif

#ifdef REWRITE_DEBUGINFO_HTM
int rewrite_debuginfo_file(void)	
{
    FILE *pf = NULL;
    char szMN[32] = {0}; //MN = Model Name
    char szObjPath[MAX_SHORT_PATH] = "InternetGatewayDevice.DeviceInfo.";
    char szFullPath[MAX_SHORT_PATH] = {0};
    char szLine[MAX_SHORT_PATH] = {0};

    //ȡModelName
    snprintf(szFullPath, MAX_SHORT_PATH, "%s%s", szObjPath, "ModelName");
    CMM_GetStr(szFullPath,szMN,sizeof(szMN)-1, NULL, 0);
	
    //ļ
    pf = fopen(NEW_FILE_DEBUGINFO_HTM, "w+");
    if (pf == NULL)
    {
        syslog(LOG_ERR, "create %s fail\n", NEW_FILE_DEBUGINFO_HTM);
        return -1;
    }

    /*дļ*/

	/*<br>ҳҪֻ֧*/
	//fwrite("<br>\n", strlen("<br>\n"), 1, pf);
	//1.ļд WAN connection type
    snprintf(szLine, MAX_SHORT_PATH, "<br> WAN connection type: %s\n", "DHCP"); //repeart ֻdhcpģʽ
    fwrite(szLine, strlen(szLine), 1, pf);

	//fwrite("<br>\n", strlen("<br>\n"), 1, pf);
	
    //2.ļд Model=EX6100
    snprintf(szLine, MAX_SHORT_PATH, "<br> Product model name: %s\n", szMN);
    fwrite(szLine, strlen(szLine), 1, pf);

	//fwrite("<br>\n", strlen("<br>\n"), 1, pf);
	
    //رļ
    fclose(pf);
}





#endif

int soap_generate_httpheader(char *pszBuf, int iBufLen, int iContentLen)
{
    if (!pszBuf || (iContentLen < 0))
    {
        syslog(LOG_ERR, "bad input parameter\n");
        return -1; //err
    }
    
    snprintf(pszBuf, iBufLen,
            "HTTP/1.0 200 OK\r\n" \
            "Content-Length: %d\r\n" \
            "Content-Type: text/xml; charset=\"UTF-8\"\r\n" \
            "Server: Linux/2.6.30 uhttpd/1.0.0 soap/1.0\r\n"
            "\r\n", iContentLen);

    return 0; //ok
}

/*
 *: ȡҶڵֵ(ҶڵsoapбΨһ)
 *: pszSoap : ָsoap
 *      pszNodeName : Ҷڵ
 *      pszValBuf : Ľڵֵ()
 *      iBufLen   : pszValBufռֽڴС
 *ֵ: 0 ʾɹʾʧ
 *ע  :Ҫڵܳ61ֽ
 */
int soap_get_node_val(char *pszSoap, char *pszNodeName, char *pszValBuf, int iBufLen)
{
    char *pszPosStart = NULL;
    char *pszPosEnd = NULL;
    char szSpeStr1[64] = {0};
    char szSpeStr2[64] = {0};
    
    if (!pszSoap || !pszNodeName)
    {
        syslog(LOG_ERR, "bad input parameter\n");
        return -1;//err
    }

    /*ַ
     *ڵвͬĸʽ:
     * <NewUsername xsi:type="xsd:string" xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance">admin</NewUsername>
     * <NewUsername>admin</NewUsername>
     */
    snprintf(szSpeStr1, sizeof(szSpeStr1), "<%s>", pszNodeName);
    snprintf(szSpeStr2, sizeof(szSpeStr1), "<%s ", pszNodeName);

    /*
     *ȡnodeֵ
     */
    pszPosStart = strstr(pszSoap, szSpeStr1);
    if (!pszPosStart)
    {
        pszPosStart = strstr(pszSoap, szSpeStr2);
        if (!pszPosStart)
        {
            syslog(LOG_ERR, "[%s:%d]call no enable value\n", __FUNCTION__, __LINE__);
            return -1;
        }
    }
    //now, pszPosStart point to '<' of "<NewUsername",and we will find the end char '>'
    do 
    {
        ++pszPosStart;
    }while(pszPosStart[0] && (pszPosStart[0]!='>'));
    if (pszPosStart[0])
    {
        pszPosStart++;//skip '>'
    }
    else
    {
        syslog(LOG_ERR, "[%s:%d]call no enable value\n", __FUNCTION__, __LINE__);
    }
    
    pszPosEnd = strchr(pszPosStart, '<');
    if (!pszPosStart)
    {
        syslog(LOG_ERR, "[%s:%d]call no enable value\n", __FUNCTION__, __LINE__);
        return -1;
    }

    strncpy(pszValBuf, pszPosStart, MIN(pszPosEnd-pszPosStart, iBufLen));

    return 0;
}

int soap_response(char *pszHttpHeader, char *pszSoapContent)
{
    start_response();

    //httpͷд뻺
    add_to_response(pszHttpHeader, strlen(pszHttpHeader));
    //http(soap)д뻺
    add_to_response(pszSoapContent, strlen(pszSoapContent));

    //http
    send_response();

    //ռõԴ
	close(child_accept_fd);
	httpd_cleanup();
	ssl_cleanup();
    exit( 1 );
}

/* 401
HTTP/1.0 200 OK
Content-Length: 286
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.30 uhttpd/1.0.0 soap/1.0


<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Body>
<ResponseCode>401</ResponseCode>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
void soap_sendErr()
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "<ResponseCode>401</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader, 
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));
        
    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}

/* Unknown Error
HTTP/1.0 200 OK
Content-Length: 286
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.30 uhttpd/1.0.0 soap/1.0


<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Body>
<ResponseCode>1</ResponseCode>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
void soap_sendUnkonwErr()
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "<ResponseCode>1</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader, 
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));
        
    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}

void soap_sendSupportErr()
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "<ResponseCode>1</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader, 
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));
        
    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}
/*


/*
POST /soap/server_sa/ HTTP/1.0
Content-Type: text/xml; charset=utf-8
Accept: text/xml
SOAPAction: urn:NETGEAR-ROUTER:service:ParentalControl:1#EnableParentalControl
Host: routerlogin.net
Content-Length: 312

...<?xml version="1.0" encoding="utf-8" ?> 
<env:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
        xmlns:env="http://schemas.xmlsoap.org/soap/envelope/">
  <env:Body>
    <EnableParentalControl>
      <NewEnable>1</NewEnable>
    </EnableParentalControl>
  </env:Body> 
</env:Envelope>
*/
int soap_EnableParentalControl(void)
{
    int ret = 0;
    char szEnableValue[64] = {0};
    char szSoapContent[MAX_SOAP_LEN] = {0};

    //http(soap)
    ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
        return -1;//error
    }

    ret = soap_get_node_val(szSoapContent, "NewEnable", szEnableValue, 64);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_node_val fail\n", __FUNCTION__, __LINE__);
        return -1;
    }
    
    syslog(LOG_INFO, "[%s:%d]enable value is :[%s]\n", __FUNCTION__, __LINE__, szEnableValue);

    ret = COMM_MakeAndSendCustomMsg(MSG_PARENT_SET_ENABLE, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 1,
            "Enable", szEnableValue);    
    
    return 0;
}

/*
HTTP/1.0 200 OK
Content-Length: 426
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Body>
   <m:EnableParentalControlResponse
      xmlns:m="urn:NETGEAR-ROUTER:service:ParentalControl:1">
   </m:EnableParentalControlResponse>
   <ResponseCode>0</ResponseCode>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
void soap_EnableParentalControlResponse(void)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "   <m:EnableParentalControlResponse\r\n" \
            "      xmlns:m=\"urn:NETGEAR-ROUTER:service:ParentalControl:1\">\r\n" \
            "   </m:EnableParentalControlResponse>\r\n" \
            "   <ResponseCode>0</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}

/*
POST /soap/server_sa/ HTTP/1.0
Content-Type: text/xml; charset=utf-8
Accept: text/xml
SOAPAction: "urn:NETGEAR-ROUTER:service:ParentalControl:1#SetDNSMasqDeviceID"
Host: routerlogin.net
Content-Length: 370

...<?xml version="1.0" encoding="utf-8" ?> 
<env:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
        xmlns:env="http://schemas.xmlsoap.org/soap/envelope/">
  <env:Body>
    <SetDNSMasqDeviceID>
      <NewMACAddress>default</NewMACAddress>
      <NewDeviceID>00005A0CF565C448</NewDeviceID>
    </SetDNSMasqDeviceID>
  </env:Body> 
</env:Envelope>
*/
int soap_SetDNSMasqDeviceID(void)
{
    int ret = 0;
    char szMAC[64] = {0};
    char szDID[64] = {0};
    char szSoapContent[MAX_SOAP_LEN] = {0};

    //http(soap)
    ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
        return -1;//error
    }

    //mac
    ret = soap_get_node_val(szSoapContent, "NewMACAddress", szMAC, 64);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_node_val fail\n", __FUNCTION__, __LINE__);
        return -1;
    }

    //device id
    ret = soap_get_node_val(szSoapContent, "NewDeviceID", szDID, 64);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_node_val fail\n", __FUNCTION__, __LINE__);
        return -1;
    }
    
    syslog(LOG_INFO, "[%s:%d]mac:[%s], device id:[%s]\n", __FUNCTION__, __LINE__, szMAC, szDID);

    ret = COMM_MakeAndSendCustomMsg(MSG_PARENT_MAC_DID_MAP, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 3,
            "Operation", "Add",
            "MAC", szMAC,
            "DID", szDID);    
    
    return 0;
}

/*
HTTP/1.0 200 OK
Content-Length: 420
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Body>
   <m:SetDNSMasqDeviceIDResponse
      xmlns:m="urn:NETGEAR-ROUTER:service:ParentalControl:1">
   </m:SetDNSMasqDeviceIDResponse>
   <ResponseCode>0</ResponseCode>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
void soap_SetDNSMasqDeviceIDResponse(void)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "   <m:SetDNSMasqDeviceIDResponse\r\n" \
            "      xmlns:m=\"urn:NETGEAR-ROUTER:service:ParentalControl:1\">\r\n" \
            "   </m:SetDNSMasqDeviceIDResponse>\r\n" \
            "   <ResponseCode>0</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};
    
    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}

int soap_GetDNSMasqDeviceID(void)
{
    return 0;
}

/*
HTTP/1.0 200 OK
Content-Length: 471
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Body>
   <m:GetDNSMasqDeviceIDResponse
      xmlns:m="urn:NETGEAR-ROUTER:service:ParentalControl:1">
      <NewDeviceID>00005A0CF565C448</NewDeviceID>
   </m:GetDNSMasqDeviceIDResponse>
   <ResponseCode>0</ResponseCode>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetDNSMasqDeviceIDResponse(void)
{
#if 1
    int ret = 0;
    ST_MSG* pRsp = NULL;
    char szMAC[64] = {0};
    char szDID[64] = {0};
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};
    char szSoapContent[MAX_SOAP_LEN] = {0};

    //http(soap)
    ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
        return -1;//error
    }

    //mac
    SOAP_GET_NODE_VALUE("NewMACAddress", szMAC);
    
    syslog(LOG_INFO, "[%s:%d]mac:[%s]\n", __FUNCTION__, __LINE__, szMAC);

    ret = COMM_MakeAndSendCustomMsg(MSG_PARENT_GET_DID_BY_MAC, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 2,
            "Operation", "Get",
            "MAC", szMAC);  
    if (ret != 0) 
    {
        syslog(LOG_ERR, "[%s:%d]call COMM_MakeAndSendCustomMsg fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "DeviceID", szDID);

    //ϢҪͷŵ
    if (pRsp)
    {
        MSG_ReleaseMessage(pRsp);
        pRsp = NULL;
    }

    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
    }

    syslog(LOG_INFO, "[%s:%d]will send response,device id:[%s]\n", __FUNCTION__, __LINE__, szDID);

    //http
    snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
            		"<m:GetDNSMasqDeviceIDResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
                    "   <NewDeviceID>%s</NewDeviceID>\r\n" \
            		"</m:GetDNSMasqDeviceIDResponse>\r\n" \
            		"<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", szDID);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);

    return 0;
#else
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "   <m:GetDNSMasqDeviceIDResponse\r\n" \
            "      xmlns:m=\"urn:NETGEAR-ROUTER:service:ParentalControl:1\">\r\n" \
            "      <NewDeviceID>00005A0CF565C448</NewDeviceID>\r\n" \
            "   </m:GetDNSMasqDeviceIDResponse>\r\n" \
            "   <ResponseCode>0</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
#endif
}

int soap_GetAllMACAddresses(void)
{
    return 0;
}

void soap_GetAllMACAddressesResponse(void)
{
    return ;
}

int soap_DeleteMACAddress(void)
{
#if 0
    int ret = 0;
    char szMAC[64] = {0};
    char szDID[64] = {0};
    char szSoapContent[MAX_SOAP_LEN] = {0};

    //http(soap)
    ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
        return -1;//error
    }

    //mac
    ret = soap_get_node_val(szSoapContent, "NewMACAddress", szMAC, 64);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_node_val fail\n", __FUNCTION__, __LINE__);
        return -1;
    }

    //device id
    ret = soap_get_node_val(szSoapContent, "NewDeviceID", szDID, 64);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_node_val fail\n", __FUNCTION__, __LINE__);
        return -1;
    }
    
    syslog(LOG_INFO, "[%s:%d]mac:[%s], device id:[%s]\n", __FUNCTION__, __LINE__, szMAC, szDID);

    ret = COMM_MakeAndSendCustomMsg(MSG_PARENT_MAC_DID_MAP, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 3,
            "Operation", "Add",
            "MAC", szMAC,
            "DID", szDID);    
#endif
    return 0;
}

void soap_DeleteMACAddressResponse(void)
{
    return ;
}

/*
POST /soap/server_sa/ HTTP/1.0
Content-Type: text/xml; charset=utf-8
Accept: text/xml
SOAPAction: urn:NETGEAR-ROUTER:service:ParentalControl:1#GetEnableStatus
Host: routerlogin.net
Content-Length: 260

...<?xml version="1.0" encoding="utf-8" ?> 
<env:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
        xmlns:env="http://schemas.xmlsoap.org/soap/envelope/">
  <env:Body>
<GetEnableStatus></GetEnableStatus>
  </env:Body> 
</env:Envelope>
*/
//APIҪԲҪ,Բsoap
int soap_GetEnableStatus(void)
{
    return 0;
}

/*
HTTP/1.0 200 OK
Content-Length: 458
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Body>
   <m:GetEnableStatusResponse
      xmlns:m="urn:NETGEAR-ROUTER:service:ParentalControl:1">
      <ParentalControl>0</ParentalControl>
   </m:GetEnableStatusResponse>
   <ResponseCode>0</ResponseCode>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
void soap_GetEnableStatusResponse(void)
{
#if 0  
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "   <m:GetEnableStatusResponse\r\n" \
            "      xmlns:m=\"urn:NETGEAR-ROUTER:service:ParentalControl:1\">\r\n" \
            "      <ParentalControl>0</ParentalControl>\r\n" \
            "   </m:GetEnableStatusResponse>\r\n" \
            "   <ResponseCode>0</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
#else
    int iRet = TBS_SUCCESS;
    char szEnableValue[64] = {0};
    char szPath[MAX_PATH_LEN] = "InternetGatewayDevice.X_TWSZ-COM_ParentCtl.Enable";
    
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

    //ȡenable status
    CMM_GetStr(szPath,szEnableValue,sizeof(szEnableValue)-1, NULL, 0);

    syslog(LOG_CRIT,"[%s:%d]enable:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);
    snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "   <m:GetEnableStatusResponse\r\n" \
            "      xmlns:m=\"urn:NETGEAR-ROUTER:service:ParentalControl:1\">\r\n" \
            "      <ParentalControl>\%s</ParentalControl>\r\n" \
            "   </m:GetEnableStatusResponse>\r\n" \
            "   <ResponseCode>0</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", szEnableValue);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
#endif
}

/**********************************************************************
*
*	صϢȡ char_compare ֶεֵ
*
*	whole_MSG: 		Ϣ
*	char_compare:	ҪȽϵֶ
*	store:			ڷش洢ֶ
**********************************************************************/
int Get_Result(ST_MSG *whole_MSG, const char *char_compare, char *store)
{
	char *p = whole_MSG->szMsgBody;
	char *p_store = NULL; 
	int i;
	for(i = 0; i < whole_MSG->stMsgHead.ulBodyLength; i++)
	{
		p_store = strstr(p, char_compare);
		if(p_store != NULL)
		{
			p_store = strstr(p, "=");
			if(p_store != NULL)
			{
				p_store++;
				strcpy(store, p_store);
				return 0;
			}
			else
			{
				return -1;
			}
		}
		else
		{
			;
		}
		p++;
	}
	return -1;
}


int soap_isAuthYetCheck()
{
	    int ret = 0;
		ST_MSG* pRsp = NULL;
		char szResult[32] = {0};
		char szSoapContent[MAX_SOAP_LEN] = {0};
	    char *client_ip = NULL;//20121105
        client_ip = ntoa( &client_addr );//20121105
		//֤Ϣ
		ret = COMM_MakeAndSendCustomMsg(MSG_CCHEK_AUTH_BYIP, 
				MID_MINIHTTPD_SELF, MID_AUTH, 1,
				"soapipaddress", client_ip);
		if (ret != 0)
		{
			return -1;//send massage fail
		}
	
		//ȴӦ,ʱʱΪ5
		syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
		ret = MSG_ReceiveMessage(&pRsp, 5);
		if (ret != MSG_OK) 
		{
			syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
			return -1;//receive message fail
		}
		//ϢҪֶεֵ
		ret = Get_Result(pRsp, "result", szResult);
		//ϢҪͷŵ
		if (pRsp)
		{
			MSG_ReleaseMessage(pRsp);
			pRsp = NULL;
		}
	
		if (ret != 0)
		{
			syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
			return -1;//auth fail
		}
		syslog(LOG_INFO, "[%s:%d]result is:[%s]\n", __FUNCTION__, __LINE__, szResult);
		if (strcmp(szResult, "0") != 0)
		{
			return -1;//auth fail
		}
		return 0;

}


/*
POST /soap/server_sa/ HTTP/1.0
Content-Type: text/xml; charset=utf-8
Accept: text/xml
SOAPAction: "urn:NETGEAR-ROUTER:service:ParentalControl:1#Authenticate"
Host: routerlogin.net
Content-Length: 344

...<?xml version="1.0" encoding="utf-8" ?> 
<env:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
        xmlns:env="http://schemas.xmlsoap.org/soap/envelope/">
  <env:Body>
    <Authenticate>
      <NewUsername>admin</NewUsername>
      <NewPassword>password</NewPassword>
    </Authenticate>
  </env:Body> 
</env:Envelope>
*/
int soap_Authenticate(void)
{
    int ret = 0;
    ST_MSG* pRsp = NULL;
    char szUsename[64] = {0};
    char szPassword[64] = {0};
    char szResult[32] = {0};
    char szSoapContent[MAX_SOAP_LEN] = {0};
	char *client_ip = NULL;
    client_ip = ntoa( &client_addr );

    //http(soap)
    ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
        return -1;//error
    }

    //usename
    ret = soap_get_node_val(szSoapContent, "NewUsername", szUsename, 64);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_node_val fail\n", __FUNCTION__, __LINE__);
        return -1;
    }

    //password
    ret = soap_get_node_val(szSoapContent, "NewPassword", szPassword, 64);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_node_val fail\n", __FUNCTION__, __LINE__);
        return -1;
    }

    syslog(LOG_INFO, "[%s:%d]usename:[%s], password:[%s]\n", __FUNCTION__, __LINE__, szUsename, szPassword);
    //֤Ϣ
    ret = COMM_MakeAndSendCustomMsg(MSG_AUTH, 
            MID_MINIHTTPD_SELF, MID_AUTH, 4,
            "username", Base64_Encode(szUsename,strlen(szUsename)),
            "password", Base64_Encode(szPassword,strlen(szPassword)),
            "soapipaddress", client_ip,
            "action", "parent_control_login");
    if (ret != 0)
    {
        return -1;//send massage fail
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

	//ϢҪֶεֵ
	ret = Get_Result(pRsp, "result", szResult);

    //ϢҪͷŵ
    if (pRsp)
    {
        MSG_ReleaseMessage(pRsp);
        pRsp = NULL;
    }

    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
    }

    syslog(LOG_INFO, "[%s:%d]result is:[%s]\n", __FUNCTION__, __LINE__, szResult);
    if (strcmp(szResult, "0") != 0)
    {
        return -2;//auth fail
    }

    return 0;
}

/*
HTTP/1.0 200 OK
Content-Length: 286
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Body>
<ResponseCode>000</ResponseCode>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
void soap_AuthenticateResponse(int result)
{	

    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};
	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "<ResponseCode>%s</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n",(result == 0) ? "000" : ((result == -1) ? "401" : "900"));
			
    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}

int soap_ConfigurationStarted(void)
{
	int ret = 0;
	char szNewConfigStatus[8] = {0};
	
	char szSoapContent[MAX_SOAP_LEN] = {0};
	char szResult[8] = {0};
	ST_MSG* pRsp = NULL;

	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
		syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
		return -1;//error
	}

	//get parameters
	//SOAP_GET_NODE_VALUE("NewConfigStatus", szNewConfigStatus);
    sprintf(szNewConfigStatus,"%s","start");//ûɶãֻΪ˲ĶCOMM_MakeAndSendCustomMsg
	
	syslog(LOG_INFO, "[%s:%d][%s] [%s] \n", __FUNCTION__, __LINE__, szNewConfigStatus);

	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_CFG_START, 
			MID_MINIHTTPD_SELF, MID_PARENTCTL, 1,
			"NewConfigStatus", szNewConfigStatus);
	if (ret != 0)
	{
		syslog(LOG_ERR, "[%s:%d]call COMM_MakeAndSendCustomMsg fail\n", __FUNCTION__, __LINE__);
		return -1;
	}

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
		syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
		return -1;//receive message fail
	}

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szResult);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szResult);
	
	return 0;
}


/*
HTTP/1.0 200 OK
Content-Length: 405
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.30 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Body>
<m:ConfigurationStartedResponse xmlns:m="urn:NETGEAR-ROUTER:service:DeviceConfig:1"></m:ConfigurationStartedResponse>
<ResponseCode>000</ResponseCode>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
void soap_ConfigurationStartedResponse(void)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "<m:ConfigurationStartedResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\"></m:ConfigurationStartedResponse>\r\n" \
            "<ResponseCode>000</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
	
	
}

int soap_ConfigurationFinished(void)
{
	int ret = 0;
	char szNewConfigStatus[8] = {0};
	
	char szSoapContent[MAX_SOAP_LEN] = {0};
	char szResult[8] = {0};
	ST_MSG* pRsp = NULL;

	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
		syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
		return -1;//error
	}

	//get parameters
	SOAP_GET_NODE_VALUE("NewConfigStatus", szNewConfigStatus);

	
	syslog(LOG_INFO, "[%s:%d][%s] [%s] \n", __FUNCTION__, __LINE__, szNewConfigStatus);

	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_CFG_END, 
			MID_MINIHTTPD_SELF, MID_PARENTCTL, 1,
			"NewConfigStatus", szNewConfigStatus);
	if (ret != 0)
	{
		syslog(LOG_ERR, "[%s:%d]call COMM_MakeAndSendCustomMsg fail\n", __FUNCTION__, __LINE__);
		return -1;
	}

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
		syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
		return -1;//receive message fail
	}

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szResult);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szResult);
	
	return 0;
}



/*
HTTP/1.0 200 OK
Content-Length: 407
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Body>
<m:ConfigurationFinishedResponse xmlns:m="urn:NETGEAR-ROUTER:service:DeviceConfig:1"></m:ConfigurationFinishedResponse>
<ResponseCode>000</ResponseCode>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
void soap_ConfigurationFinishedResponse(void)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "<m:ConfigurationFinishedResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\"></m:ConfigurationFinishedResponse>\r\n" \
            "<ResponseCode>000</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
	
}

#ifdef HTTP_SOAP_NETGEAR_GENIE
/*
POST /soap/server_sa/ HTTP/1.0
SOAPAction: urn:NETGEAR-ROUTER:service:WLANConfiguration:1#GetInfo
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 512


<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<SOAP-ENV:Envelope xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema"
 xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" 
 xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" 
 xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">
 
	 <SOAP-ENV:Header>
		<SessionID>E6A88AE69687E58D9A00</SessionID>
	 </SOAP-ENV:Header>
	 
	 <SOAP-ENV:Body>
		<M1:GetInfo xmlns:M1="urn:NETGEAR-ROUTER:service:WLANConfiguration:1"></M1:GetInfo>
	 </SOAP-ENV:Body>
</SOAP-ENV:Envelope>
 */
int soap_GetInfo(void)
{
    return 0;//ok
}

/*
HTTP/1.0 200 OK

Content-Length: 864
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
	<SOAP-ENV:Body>
		<m:GetInfoResponse xmlns:m="urn:NETGEAR-ROUTER:service:WLANConfiguration:1">  
			<NewEnable>1</NewEnable>
			<NewSSIDBroadcast>1</NewSSIDBroadcast>
			<NewStatus>Up</NewStatus>
			<NewSSID>NETGEAR13</NewSSID>
			<NewRegion>Europe</NewRegion>
			<NewChannel>AUTO</NewChannel>
			<NewWirelessMode>300Mbps</NewWirelessMode>
			<NewBasicEncryptionModes>None</NewBasicEncryptionModes>
			<NewWEPAuthType>Automatic</NewWEPAuthType>
			<NewWPAEncryptionModes>None</NewWPAEncryptionModes>
			<NewWLANMACAddress>204E7F5AC2BF</NewWLANMACAddress>
		</m:GetInfoResponse>

		<ResponseCode>000</ResponseCode>
	</SOAP-ENV:Body>

</SOAP-ENV:Envelope>
*/
int soap_GetInfoResponse(void)
{
#if 1
    int ret = 0;
    ST_MSG* pRsp = NULL;
    char szEnable[4] = {0};
    char szBroadcast[4] = {0};
    char szStatus[16] = {0};
    char szSSID[64] = {0};
    char szRegion[32] = {0};
    char szChannel[4] = {0};
    char szWirelessMode[16] = {0};
    char szEncryMode[32] = {0};
    char szAuthType[32] = {0};
    char szWPAEncryModes[32] = {0};
    char szMacAddr[16] = {0};
    char Manufacturer[32] = {0};
    char Description[32] = {0};
    char SerialNumber[32] = {0};
    char FirmwareVersion[32] = {0};
    char LanguageVersion[32] = {0};
    char SOAPVersion[32] = {0};
    char HardwareVersion[32] = {0};
    char FirstUseDate[32] = {0};
    char IsResetToDefault[32] = {0};
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

    syslog(LOG_INFO, "[%s:%d]into soap_GetInfoResponse\n", __FUNCTION__, __LINE__);

    //ͻȡϢ
    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_DEV_INFO, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);
    if (ret != 0)
    {
        return -1;//send massage fail
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Description SerialNumber Firmwareversion Hardwareversion FirstUseDate LanguageVersion IsResetToDefault SOAPVersion", 
	                       Description,SerialNumber,FirmwareVersion,HardwareVersion,FirstUseDate,LanguageVersion,IsResetToDefault,SOAPVersion);

    //ϢҪͷŵ
    if (pRsp)
    {
        MSG_ReleaseMessage(pRsp);
        pRsp = NULL;
    }

    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
    }

    syslog(LOG_INFO, "will send response\n", __FUNCTION__, __LINE__);

    //http
    snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
            		"<m:GetInfoResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
            			"<Manufacturer>%s</Manufacturer>\r\n" \
            			"<Description>%s</Description>\r\n" \
            			"<SerialNumber>%s</SerialNumber>\r\n" \
            			"<FirmwareVersion>%s</FirmwareVersion>\r\n" \
            			"<LanguageVersion>%s</LanguageVersion>\r\n" \
            			"<SOAPVersion>%s</SOAPVersion>\r\n" \
            			"<HardwareVersion>%s</HardwareVersion>\r\n" \
            			"<FirstUseDate>%s</FirstUseDate>\r\n" \
            			"<IsResetToDefault>%s</IsResetToDefault>\r\n" \
            		"</m:GetInfoResponse>\r\n" \
            		"<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n","Netgear",Description,SerialNumber,FirmwareVersion,LanguageVersion,SOAPVersion,HardwareVersion,FirstUseDate,IsResetToDefault);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);

    return 0;
#else
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
            		"<m:GetInfoResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
            			"<NewEnable>1</NewEnable>\r\n" \
            			"<NewSSIDBroadcast>1</NewSSIDBroadcast>\r\n" \
            			"<NewStatus>Up</NewStatus>\r\n" \
            			"<NewSSID>NETGEAR13</NewSSID>\r\n" \
            			"<NewRegion>Europe</NewRegion>\r\n" \
            			"<NewChannel>AUTO</NewChannel>\r\n" \
            			"<NewWirelessMode>300Mbps</NewWirelessMode>\r\n" \
            			"<NewBasicEncryptionModes>None</NewBasicEncryptionModes>\r\n" \
            			"<NewWEPAuthType>Automatic</NewWEPAuthType>\r\n" \
            			"<NewWPAEncryptionModes>None</NewWPAEncryptionModes>\r\n" \
            			"<NewWLANMACAddress>204E7F5AC2BF</NewWLANMACAddress>\r\n" \
            		"</m:GetInfoResponse>\r\n" \
            		"<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
#endif
}

/*
POST /soap/server_sa/ HTTP/1.0
SOAPAction: urn:NETGEAR-ROUTER:service:WLANConfiguration:1#GetWPASecurityKeys
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 534

<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<SOAP-ENV:Envelope 
   xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema" 
   xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" 
   xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" 
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">
   
   <SOAP-ENV:Header>
	  <SessionID>E6A88AE69687E58D9A00</SessionID>
   </SOAP-ENV:Header>
   <SOAP-ENV:Body>
	  <M1:GetWPASecurityKeys xmlns:M1="urn:NETGEAR-ROUTER:service:WLANConfiguration:1"></M1:GetWPASecurityKeys>
   </SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetWPASecurityKeys(void)
{
    return 0;//ok
}


/*
HTTP/1.0 200 OK
Content-Length: 458
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">

	<SOAP-ENV:Body>
		<m:GetWPASecurityKeysResponse xmlns:m="urn:NETGEAR-ROUTER:service:WLANConfiguration:1">   
			<NewWPAPassphrase>hjhhahaha</NewWPAPassphrase>
		</m:GetWPASecurityKeysResponse>

		<ResponseCode>000</ResponseCode>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetWPASecurityKeysResponse(void)
{
#if 0
    int ret = 0;
    ST_MSG* pRsp = NULL;
    char szKey[16] = {0};
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

    syslog(LOG_INFO, "[%s:%d]into soap_GetWEPSecurityKeysResponse\n", __FUNCTION__, __LINE__);

    //ͻȡϢ
    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_WLAN_WPA_KEY, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);
    if (ret != 0)
    {
        return -1;//send massage fail
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "WPAPassphrase", szKey);

    //ϢҪͷŵ
    if (pRsp)
    {
        MSG_ReleaseMessage(pRsp);
        pRsp = NULL;
    }

    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
    }

    syslog(LOG_INFO, "will send response\n", __FUNCTION__, __LINE__);

    //http
    snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
            		"<m:GetWPASecurityKeysResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
                    "	<NewWPAPassphrase>%s</NewWPAPassphrase>\r\n" \
            		"</m:GetWPASecurityKeysResponse>\r\n" \
            		"<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", szKey);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);

    return 0;
#else
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
            		"<m:GetWPASecurityKeysResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
            			"<NewWPAPassphrase>hjhhahaha</NewWPAPassphrase>\r\n" \
            		"</m:GetWPASecurityKeysResponse>\r\n" \
            		"<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
#endif
}

/*
POST /soap/server_sa/ HTTP/1.0
SOAPAction: urn:NETGEAR-ROUTER:service:WLANConfiguration:1#GetWEPSecurityKeys
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 534

<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<SOAP-ENV:Envelope xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema" 
	xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" 
	xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">
	<SOAP-ENV:Header>
		<SessionID>E6A88AE69687E58D9A00</SessionID>
	</SOAP-ENV:Header>
	<SOAP-ENV:Body>
		<M1:GetWEPSecurityKeys xmlns:M1="urn:NETGEAR-ROUTER:service:WLANConfiguration:1">
		</M1:GetWEPSecurityKeys>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetWEPSecurityKeys(void)
{
    return 0;//ok
}

/*
HTTP/1.0 200 OK
Content-Length: 504
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
<SOAP-ENV:Body>
<m:GetWEPSecurityKeysResponse xmlns:m="urn:NETGEAR-ROUTER:service:WLANConfiguration:1">
    <NewWEPKey>12345612345612345612345612</NewWEPKey>
    <NewWEPPassphrase></NewWEPPassphrase>
</m:GetWEPSecurityKeysResponse>
<ResponseCode>000</ResponseCode>
</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetWEPSecurityKeysResponse(void)
{
#if 0
    int ret = 0;
    ST_MSG* pRsp = NULL;
    char szKey[16] = {0};
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

    syslog(LOG_INFO, "[%s:%d]into soap_GetWEPSecurityKeysResponse\n", __FUNCTION__, __LINE__);

    //ͻȡϢ
    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_WLAN_WEP_KEY, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);
    if (ret != 0)
    {
        return -1;//send massage fail
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "WEPKey", szKey);

    //ϢҪͷŵ
    if (pRsp)
    {
        MSG_ReleaseMessage(pRsp);
        pRsp = NULL;
    }

    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
    }

    syslog(LOG_INFO, "will send response\n", __FUNCTION__, __LINE__);

    //http
    snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
            		"<m:GetWEPSecurityKeysResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
                    "   <NewWEPKey>%s</NewWEPKey>\r\n" \
                    "   <NewWEPPassphrase></NewWEPPassphrase>\r\n" \
            		"</m:GetWEPSecurityKeysResponse>\r\n" \
            		"<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", szKey);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);

    return 0;
#else
	//ӦNetgearbugʾNewWPAPassphrase Ϣ
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
            		"<m:GetWEPSecurityKeysResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
            		"</m:GetWEPSecurityKeysResponse>\r\n" \
            		"<ResponseCode>900</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
#endif
}

/*
POST /soap/server_sa/ HTTP/1.0

SOAPAction: urn:NETGEAR-ROUTER:service:WLANConfiguration:1#GetGuestAccessEnabled
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 540



<?xml version="1.0" encoding="UTF-8" standalone="no"?>
  <SOAP-ENV:Envelope xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema"
  xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" 
  xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" 
  xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">
	 <SOAP-ENV:Header>
		 <SessionID>E6A88AE69687E58D9A00</SessionID>
	  </SOAP-ENV:Header>
	  
	  <SOAP-ENV:Body>
		 <M1:GetGuestAccessEnabled xmlns:M1="urn:NETGEAR-ROUTER:service:WLANConfiguration:1">
		 </M1:GetGuestAccessEnabled>
	  </SOAP-ENV:Body>
  </SOAP-ENV:Envelope>
*/
int soap_GetGuestAccessEnabled(void)
{
    return 0;//ok
}

/*
HTTP/1.0 200 OK

Content-Length: 466
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>

<SOAP-ENV:Envelope

   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">

	<SOAP-ENV:Body>
	
		<m:GetGuestAccessEnabledResponse xmlns:m="urn:NETGEAR-ROUTER:service:WLANConfiguration:1">   
			<NewGuestAccessEnabled>0</NewGuestAccessEnabled>
		</m:GetGuestAccessEnabledResponse>

		<ResponseCode>000</ResponseCode>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetGuestAccessEnabledResponse(void)
{
    int iRet = TBS_SUCCESS;
    char szEnableValue[64] = {0};
    char szPath[MAX_PATH_LEN] = "InternetGatewayDevice.LANDevice.1.WLANConfiguration.2.Enable";
    
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

    //ȡenable status
    CMM_GetStr(szPath,szEnableValue,sizeof(szEnableValue)-1, NULL, 0);

    syslog(LOG_CRIT,"[%s:%d]enable:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);
    snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
		    "		<m:GetGuestAccessEnabledResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \   
			"			<NewGuestAccessEnabled>%s</NewGuestAccessEnabled>\r\n" \
		    "		</m:GetGuestAccessEnabledResponse>\r\n" \
		    "       <ResponseCode>000</ResponseCode>\r\n" \
            "    </SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", szEnableValue);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);

    return 0;
}

/*
POST /soap/server_sa/ HTTP/1.0
SOAPAction: urn:NETGEAR-ROUTER:service:WLANConfiguration:1#GetGuestAccessNetworkInfo
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 548

<?xml version="1.0" encoding="UTF-8" standalone="no"?>
	<SOAP-ENV:Envelope xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema" 
	xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" 
	xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">
	
	<SOAP-ENV:Header>
		<SessionID>E6A88AE69687E58D9A00</SessionID>
	</SOAP-ENV:Header>
	
	<SOAP-ENV:Body>
	    <M1:GetGuestAccessNetworkInfo xmlns:M1="urn:NETGEAR-ROUTER:service:WLANConfiguration:1">
		</M1:GetGuestAccessNetworkInfo>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetGuestAccessNetworkInfo(void)
{
    return 0;//ok
}

/*
HTTP/1.0 200 OK

Content-Length: 526
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
	<SOAP-ENV:Body>
		<m:GetGuestAccessNetworkInfoResponse xmlns:m="urn:NETGEAR-ROUTER:service:WLANConfiguration:1">   
			<NewSSID>NETGEAR-Guest</NewSSID>
			<NewSecurityMode>None</NewSecurityMode>
			<NewKey></NewKey>
		</m:GetGuestAccessNetworkInfoResponse>

		<ResponseCode>000</ResponseCode>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetGuestAccessNetworkInfoResponse(void)
{
#if 1
    int ret = 0;
    ST_MSG* pRsp = NULL;
    char szSSID[64] = {0};
    char szSecurityMode[32] = {0};
    char szKey[128] = {0};
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

    syslog(LOG_INFO, "[%s:%d]into soap_GetGuestAccessNetworkInfoResponse\n", __FUNCTION__, __LINE__);

    //ͻȡϢ
    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_GUEST_INFO, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);
    if (ret != 0)
    {
        return -1;//send massage fail
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "SSID SecurityMode Key" ,
	                    szSSID, szSecurityMode, szKey);

    //ϢҪͷŵ
    if (pRsp)
    {
        MSG_ReleaseMessage(pRsp);
        pRsp = NULL;
    }

    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
    }

    syslog(LOG_INFO, "will send response\n", __FUNCTION__, __LINE__);

    //http
    snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
            		"<m:GetGuestAccessNetworkInfoResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
                    "			<NewSSID>%s</NewSSID>\r\n" \
                    "			<NewSecurityMode>%s</NewSecurityMode>\r\n" \
                    "			<NewKey>%s</NewKey>\r\n" \
            		"</m:GetGuestAccessNetworkInfoResponse>\r\n" \
            		"<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", szSSID, szSecurityMode, szKey);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);

    return 0;
#else
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "	<SOAP-ENV:Body>\r\n" \
            "		<m:GetGuestAccessNetworkInfoResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
            "			<NewSSID>NETGEAR-Guest</NewSSID>\r\n" \
            "			<NewSecurityMode>None</NewSecurityMode>\r\n" \
            "			<NewKey></NewKey>\r\n" \
            "		</m:GetGuestAccessNetworkInfoResponse>\r\n" \
            "		<ResponseCode>000</ResponseCode>\r\n" \
            "	</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
#endif
}

/*
POST /soap/server_sa/ HTTP/1.0
SOAPAction: urn:NETGEAR-ROUTER:service:DeviceConfig:1#GetTrafficMeterEnabled
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 537


<?xml version="1.0" encoding="UTF-8" standalone="no"?>
	<SOAP-ENV:Envelope xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema" 
	xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" 
	xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">
	
	<SOAP-ENV:Header>
		<SessionID>E6A88AE69687E58D9A00</SessionID>
	</SOAP-ENV:Header>
	
	<SOAP-ENV:Body>
		<M1:GetTrafficMeterEnabled xmlns:M1="urn:NETGEAR-ROUTER:service:DeviceConfig:1">
		</M1:GetTrafficMeterEnabled>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetTrafficMeterEnabled(void)
{
    return 0;//ok
}

/*
HTTP/1.0 200 OK

Content-Length: 444
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">

   <SOAP-ENV:Body>
	  <m:GetTrafficMeterEnabled xmlns:m="urn:NETGEAR-ROUTER:service:DeviceConfig:1">.
		 <NewTrafficMeterEnable>1</NewTrafficMeterEnable>
	  </m:GetTrafficMeterEnabled>

	 <ResponseCode>000</ResponseCode>
   </SOAP-ENV:Body>

</SOAP-ENV:Envelope>
*/
int soap_GetTrafficMeterEnabledResponse(void)
{
    int iRet = TBS_SUCCESS;
    char szEnableValue[64] = {0};
    char szPath[MAX_PATH_LEN] = "InternetGatewayDevice.X_TWSZ-COM_TrafficMeter.Enable";
    
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

    //ȡenable status
    CMM_GetStr(szPath,szEnableValue,sizeof(szEnableValue)-1, NULL, 0);

    syslog(LOG_CRIT,"[%s:%d]enable:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);
    snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "<m:GetTrafficMeterEnabled xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
            "<NewTrafficMeterEnable>%s</NewTrafficMeterEnable>\r\n" \
            "</m:GetTrafficMeterEnabled>\r\n" \
            "<ResponseCode>000</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", szEnableValue);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);

    return 0;
}

/*
POST /soap/server_sa/ HTTP/1.0
SOAPAction: urn:NETGEAR-ROUTER:service:DeviceConfig:1#GetTrafficMeterOptions
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 537


<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<SOAP-ENV:Envelope xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema" 
xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" 
xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" 
xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">

	<SOAP-ENV:Header>
		<SessionID>E6A88AE69687E58D9A00</SessionID>
	</SOAP-ENV:Header>
	
	<SOAP-ENV:Body>
		<M1:GetTrafficMeterOptions xmlns:M1="urn:NETGEAR-ROUTER:service:DeviceConfig:1">
		</M1:GetTrafficMeterOptions>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetTrafficMeterOptions(void)
{
    return 0;//ok
}

/*
HTTP/1.0 200 OK

Content-Length: 577
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">

	<SOAP-ENV:Body>

		<m:GetTrafficMeterOptions xmlns:m="urn:NETGEAR-ROUTER:service:DeviceConfig:1">.
			<NewControlOption>No Limit</NewControlOption>
			.<NewMonthlyLimit>0</NewMonthlyLimit>
			.<RestartHour>00</RestartHour>
			.<RestartMinute>00</RestartMinute>
			.<RestartDay>1</RestartDay>
		</m:GetTrafficMeterOptions>

		<ResponseCode>000</ResponseCode>

	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetTrafficMeterOptionsResponse(void)
{
    int ret = 0;
    ST_MSG* pRsp = NULL;
    char szControlOpt[16] = {0};
    char szMonthLimit[4] = {0};
    char szHour[16] = {0};
    char szMinute[64] = {0};
    char szDay[32] = {0};
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

    syslog(LOG_INFO, "into soap_GetTrafficMeterOptionsResponse\n", __FUNCTION__, __LINE__);

    //ͻȡϢ
    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_TafficMeter_OPTION, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);
    if (ret != 0)
    {
        return -1;//send massage fail
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "ControlOption MonthlyLimit RestartHour " \
	                       "RestartMinute RestartDay" , 
	                       szControlOpt, szMonthLimit, szHour, szMinute,szDay);

    //ϢҪͷŵ
    if (pRsp)
    {
        MSG_ReleaseMessage(pRsp);
        pRsp = NULL;
    }

    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
    }

    syslog(LOG_INFO, "will send response\n", __FUNCTION__, __LINE__);

    //http
    snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
                "		<m:GetTrafficMeterOptions xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
                "			<NewControlOption>%s</NewControlOption>\r\n" \
                "			<NewMonthlyLimit>%s</NewMonthlyLimit>\r\n" \
                "			<RestartHour>%s</RestartHour>\r\n" \
                "			<RestartMinute>%s</RestartMinute>\r\n" \
                "			<RestartDay>%s</RestartDay>\r\n" \
                "		</m:GetTrafficMeterOptions>\r\n" \
                "		<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", szControlOpt, szMonthLimit, \
            szHour, szMinute, szDay);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);

    return 0;
}

/*
POST /soap/server_sa/ HTTP/1.0
SOAPAction: urn:NETGEAR-ROUTER:service:DeviceConfig:1#SetTrafficMeterOptions
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 711

<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<SOAP-ENV:Envelope xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema" xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">
	<SOAP-ENV:Header><SessionID>E6A88AE69687E58D9A00</SessionID></SOAP-ENV:Header>
	<SOAP-ENV:Body><M1:SetTrafficMeterOptions xmlns:M1="urn:NETGEAR-ROUTER:service:DeviceConfig:1">
		<NewControlOption>Download only</NewControlOption>
		<NewMonthlyLimit>100</NewMonthlyLimit>
		<RestartDay>1</RestartDay>
		<RestartHour>8</RestartHour>
		<RestartMinute>7</RestartMinute>
	</M1:SetTrafficMeterOptions>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_SetTrafficMeterOptions(void)
{
    int ret = 0;
    char szCtrlOpt[16] = {0};
    char szMthLimit[16] = {0};
    char szRestartDay[8] = {0};
    char szRestartHour[8] = {0};
    char szRestartMinute[8] = {0};
    char szResult[8] = {0};
    char szSoapContent[MAX_SOAP_LEN] = {0};
    ST_MSG* pRsp = NULL;

    //http(soap)
    ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
        return -1;//error
    }

    //get NewControl Option
    SOAP_GET_NODE_VALUE("NewControlOption", szCtrlOpt);

    //get Monthly Limit
    SOAP_GET_NODE_VALUE("NewMonthlyLimit", szMthLimit);

    //get Restart Day
    SOAP_GET_NODE_VALUE("RestartDay", szRestartDay);

    //get Restart Hour
    SOAP_GET_NODE_VALUE("RestartHour", szRestartHour);

    //get Restart Minute
    SOAP_GET_NODE_VALUE("RestartMinute", szRestartMinute);

    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_TafficMeter_OPTION, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 5,
            "ControlOption", szCtrlOpt,
            "MonthlyLimit", szMthLimit,
            "RestartDay", szRestartDay,
            "RestartHour", szRestartHour,
            "RestartMinute", szRestartMinute);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call COMM_MakeAndSendCustomMsg fail\n", __FUNCTION__, __LINE__);
        return -1;
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

    //ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szResult);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szResult);
    
    return 0;
}

int soap_SetTrafficMeterOptionsResponse(void)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "		<m:EnableTrafficMeterResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\"></m:EnableTrafficMeterResponse>\r\n" \
            "		<ResponseCode>000</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}

/*
POST /soap/server_sa/ HTTP/1.0
SOAPAction: urn:NETGEAR-ROUTER:service:DeviceConfig:1#GetTrafficMeterStatistics
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 543


<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<SOAP-ENV:Envelope xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema"
 xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" 
 xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" 
 xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">
	<SOAP-ENV:Header>
		<SessionID>E6A88AE69687E58D9A00</SessionID>
	</SOAP-ENV:Header>
	
	<SOAP-ENV:Body><M1:GetTrafficMeterStatistics xmlns:M1="urn:NETGEAR-ROUTER:service:DeviceConfig:1">
	</M1:GetTrafficMeterStatistics>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetTrafficMeterStatistics(void)
{
    return 0;//ok
}

/*
HTTP/1.0 200 OK

Content-Length: 1244
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
   
	<SOAP-ENV:Body>
		<m:GetTrafficMeterStatisticsResponse xmlns:m="urn:NETGEAR-ROUTER:service:DeviceConfig:1">   
		<NewTodayConnectionTime>0:18</NewTodayConnectionTime>
		<NewTodayUpload>5.85</NewTodayUpload>
		<NewTodayDownload>90.20</NewTodayDownload>
		<NewYesterdayConnectionTime>0:0</NewYesterdayConnectionTime>
		<NewYesterdayUpload>0.00</NewYesterdayUpload>
		<NewYesterdayDownload>0.00</NewYesterdayDownload>
		<NewWeekConnectionTime>0:18</NewWeekConnectionTime>
		<NewWeekUpload>5.85/1.95</NewWeekUpload>
		<NewWeekDownload>90.20/30.07</NewWeekDownload>
		<NewMonthConnectionTime>42:14</NewMonthConnectionTime>
		<NewMonthUpload>57.56/5.76</NewMonthUpload>
		<NewMonthDownload>374.38/37.44</NewMonthDownload>
		<NewLastMonthConnectionTime>43:16</NewLastMonthConnectionTime>
		<NewLastMonthUpload>141.68/4.57</NewLastMonthUpload>
		<NewLastMonthDownload>1,030/33.25</NewLastMonthDownload>
		</m:GetTrafficMeterStatisticsResponse>
		<ResponseCode>000</ResponseCode>
	</SOAP-ENV:Body>

</SOAP-ENV:Envelope>
*/
int soap_GetTrafficMeterStatisticsResponse(void)
{
#if 1
    int ret = 0;
    ST_MSG* pRsp = NULL;
    char szTdConnTime[32] = {0};
    char szTdUpload[32] = {0};
    char szTdDownload[32] = {0};
    char szYdConnTime[32] = {0};
    char szYdUpload[32] = {0};
    char szYdDownload[32] = {0};
    char szWkConnTime[32] = {0};
    char szWkUpload[32] = {0};
    char szWkDownload[32] = {0};
    char szMthConnTime[32] = {0};
    char szMthUpload[32] = {0};
    char szMthDownload[32] = {0};
    char szLastMthConnTime[32] = {0};
    char szLastMthUpload[32] = {0};
    char szLastMthDownload[32] = {0};
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

    syslog(LOG_INFO, "into soap_GetTrafficMeterStatisticsResponse\n", __FUNCTION__, __LINE__);

    //ͻȡϢ
    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_TrafficMeter_STA, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);
    if (ret != 0)
    {
        return -1;//send massage fail
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "TodayConnectionTime TodayUpload TodayDownload "  \
	                       "YesterdayConnectionTime YesterdayUpload YesterdayDownload " \
	                       "WeekConnectionTime WeekUpload WeekDownload MonthConnectionTime " \
	                       "MonthUpload MonthDownload LastMonthConnectionTime " \
	                       "LastMonthUpload LastMonthDownload ",
	                       szTdConnTime, szTdUpload, szTdDownload, szYdConnTime, 
	                       szYdUpload, szYdDownload, szWkConnTime, szWkUpload,
	                       szWkDownload, szMthConnTime, szMthUpload,szMthDownload,
	                       szLastMthConnTime, szLastMthUpload, szLastMthDownload);

    //ϢҪͷŵ
    if (pRsp)
    {
        MSG_ReleaseMessage(pRsp);
        pRsp = NULL;
    }

    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
    }

    syslog(LOG_INFO, "will send response\n", __FUNCTION__, __LINE__);

    //http
    snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
            		"<m:GetTrafficMeterStatisticsResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
                    "		<NewTodayConnectionTime>%s</NewTodayConnectionTime>\r\n" \
                    "		<NewTodayUpload>%s</NewTodayUpload>\r\n" \
                    "		<NewTodayDownload>%s</NewTodayDownload>\r\n" \
                    "		<NewYesterdayConnectionTime>%s</NewYesterdayConnectionTime>\r\n" \
                    "		<NewYesterdayUpload>%s</NewYesterdayUpload>\r\n" \
                    "		<NewYesterdayDownload>%s</NewYesterdayDownload>\r\n" \
                    "		<NewWeekConnectionTime>%s</NewWeekConnectionTime>\r\n" \
                    "		<NewWeekUpload>%s</NewWeekUpload>\r\n" \
                    "		<NewWeekDownload>%s</NewWeekDownload>\r\n" \
                    "		<NewMonthConnectionTime>%s</NewMonthConnectionTime>\r\n" \
                    "		<NewMonthUpload>%s</NewMonthUpload>\r\n" \
                    "		<NewMonthDownload>%s</NewMonthDownload>\r\n" \
                    "		<NewLastMonthConnectionTime>%s</NewLastMonthConnectionTime>\r\n" \
                    "		<NewLastMonthUpload>%s</NewLastMonthUpload>\r\n" \
                    "		<NewLastMonthDownload>%s</NewLastMonthDownload>\r\n" \
            		"</m:GetTrafficMeterStatisticsResponse>\r\n" \
            		"<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", szTdConnTime, szTdUpload, szTdDownload, 
            szYdConnTime, szYdUpload, szYdDownload, szWkConnTime, szWkUpload, 
            szWkDownload, szMthConnTime, szMthUpload, szMthDownload,
            szLastMthConnTime, szLastMthUpload, szLastMthDownload);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);

    return 0;
#else
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
                "		<m:GetTrafficMeterStatisticsResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
                "		<NewTodayConnectionTime>0:18</NewTodayConnectionTime>\r\n" \
                "		<NewTodayUpload>5.85</NewTodayUpload>\r\n" \
                "		<NewTodayDownload>90.20</NewTodayDownload>\r\n" \
                "		<NewYesterdayConnectionTime>0:0</NewYesterdayConnectionTime>\r\n" \
                "		<NewYesterdayUpload>0.00</NewYesterdayUpload>\r\n" \
                "		<NewYesterdayDownload>0.00</NewYesterdayDownload>\r\n" \
                "		<NewWeekConnectionTime>0:18</NewWeekConnectionTime>\r\n" \
                "		<NewWeekUpload>5.85/1.95</NewWeekUpload>\r\n" \
                "		<NewWeekDownload>90.20/30.07</NewWeekDownload>\r\n" \
                "		<NewMonthConnectionTime>42:14</NewMonthConnectionTime>\r\n" \
                "		<NewMonthUpload>57.56/5.76</NewMonthUpload>\r\n" \
                "		<NewMonthDownload>374.38/37.44</NewMonthDownload>\r\n" \
                "		<NewLastMonthConnectionTime>43:16</NewLastMonthConnectionTime>\r\n" \
                "		<NewLastMonthUpload>141.68/4.57</NewLastMonthUpload>\r\n" \
                "		<NewLastMonthDownload>1,030/33.25</NewLastMonthDownload>\r\n" \
                "		</m:GetTrafficMeterStatisticsResponse>\r\n" \
            	"<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
#endif
}

/*
POST /soap/server_sa/ HTTP/1.0
SOAPAction: urn:NETGEAR-ROUTER:service:DeviceInfo:1#GetAttachDevice
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 521


<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<SOAP-ENV:Envelope xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema" 
xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" 
xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" 
xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">

	<SOAP-ENV:Header>
		<SessionID>58DEE6006A88A967E89A</SessionID>
	</SOAP-ENV:Header>
	
	<SOAP-ENV:Body>
		<M1:GetAttachDevice xmlns:M1="urn:NETGEAR-ROUTER:service:DeviceInfo:1"></M1:GetAttachDevice>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetAttachDevice(void)
{
    return 0;//ok
}

/*
HTTP/1.0 200 OK

Content-Length: 663
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0


<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">

	<SOAP-ENV:Body>
		<m:GetAttachDeviceResponse xmlns:m="urn:NETGEAR-ROUTER:service:DeviceInfo:1">  
		  <NewAttachDevice>3@1;192.168.1.1;WNDR4300;11:22:33:44:55:60;;rootAP;300;100@2;192.168.1.2;Peter'sNB;11:22:33:44:55:66;02:0F:B5:33:44:55;wired;;100@3;192.168.1.3;William'sNB;11:22:33:44:55:77;02:0F:B5:44:55:77;wireless;300;100</NewAttachDevice>
		</m:GetAttachDeviceResponse>

		<ResponseCode>000</ResponseCode>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetAttachDeviceResponse(void)
{
#if 0
    int ret = 0;
    ST_MSG* pRsp = NULL;
    char szAttachDev[1024] = {0};
    char szDeviceNum[16] = {0};
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};
    char *client_ip = NULL;//20121105

    syslog(LOG_INFO, "into soap_GetAttachDeviceResponse\n", __FUNCTION__, __LINE__);

    client_ip = ntoa( &client_addr );//20121105
    //ͻȡϢ
    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_ATTACH_DEV, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 1,//add by zhengmingming 20121105
            "Client_addr", client_ip);
    if (ret != 0)
    {
        return -1;//send massage fail
    }

    //ȴӦ,ʱʱΪ10
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 10);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "AttachDevice DeviceNum", szAttachDev, szDeviceNum);

    //ϢҪͷŵ
    if (pRsp)
    {
        MSG_ReleaseMessage(pRsp);
        pRsp = NULL;
    }

    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
    }

    syslog(LOG_INFO, "will send response\n", __FUNCTION__, __LINE__);

    //http
    snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
                "		<m:GetAttachedDeviceResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceInfo:1\">\r\n" \
                "		<AttachededDeviceList>%s%s</AttachededDeviceList>\r\n" \
                "		</m:GetAttachedDeviceResponse>\r\n" \
            	"		<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", szDeviceNum, szAttachDev);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);

    return 0;
#else
	//ӦNetgear bugʾGetAttachDeviceϢ
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
                "		<m:GetAttachDeviceResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
                "		</m:GetAttachDeviceResponse>\r\n" \
            	"		<ResponseCode>900</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
#endif
}

/*
POST /soap/server_sa/ HTTP/1.0
SOAPAction: urn:NETGEAR-ROUTER:service:DeviceConfig:1#EnableTrafficMeter
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 577


<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<SOAP-ENV:Envelope xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema" 
xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" 
xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" 
xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">

	<SOAP-ENV:Header>
		<SessionID>E6A88AE69687E58D9A00</SessionID>
	</SOAP-ENV:Header>

	<SOAP-ENV:Body>
		<M1:EnableTrafficMeter xmlns:M1="urn:NETGEAR-ROUTER:service:DeviceConfig:1">
		<NewTrafficMeterEnable>0</NewTrafficMeterEnable>
		</M1:EnableTrafficMeter>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_EnableTrafficMeter(void)
{
    int ret = 0;
    char szEnableValue[64] = {0};
    char szSoapContent[MAX_SOAP_LEN] = {0};
    ST_MSG* pRsp = NULL;

    //http(soap)
    ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
        return -1;//error
    }

    ret = soap_get_node_val(szSoapContent, "NewTrafficMeterEnable", szEnableValue, 64);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_node_val fail\n", __FUNCTION__, __LINE__);
        return -1;
    }
    
    syslog(LOG_INFO, "[%s:%d]enable value is :[%s]\n", __FUNCTION__, __LINE__, szEnableValue);

    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_TRAFFIC_METER_ENABLE, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 1,
            "Enable", szEnableValue);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call COMM_MakeAndSendCustomMsg fail\n", __FUNCTION__, __LINE__);
        return -1;
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

    memset(szEnableValue, 0, sizeof(szEnableValue));
    //ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szEnableValue);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);
    
    return 0;
}

/*
HTTP/1.0 200 OK

Content-Length: 401
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
	<SOAP-ENV:Body>
		<m:EnableTrafficMeterResponse xmlns:m="urn:NETGEAR-ROUTER:service:DeviceConfig:1"></m:EnableTrafficMeterResponse>
		<ResponseCode>000</ResponseCode>
	</SOAP-ENV:Body>

</SOAP-ENV:Envelope>
*/
int soap_EnableTrafficMeterResponse(void)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "		<m:EnableTrafficMeterResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\"></m:EnableTrafficMeterResponse>\r\n" \
            "		<ResponseCode>000</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}

int soap_GetBlockDeviceEnableStatus(void)
{
    return 0;//ok
}

int soap_GetBlockDeviceEnableStatusResponse(void)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "		<ResponseCode>501</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}

int soap_SetGuestAccessEnabled(void)
{
    int ret = 0;
    char szEnableValue[64] = {0};
    char szSoapContent[MAX_SOAP_LEN] = {0};
    ST_MSG* pRsp = NULL;

    //http(soap)
    ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
        return -1;//error
    }

    SOAP_GET_NODE_VALUE("NewGuestAccessEnabled", szEnableValue);
    
    syslog(LOG_INFO, "[%s:%d]enable value is :[%s]\n", __FUNCTION__, __LINE__, szEnableValue);

    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_GUEST_ACCESS_DISABLE, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 1,
            "Enable", szEnableValue);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call COMM_MakeAndSendCustomMsg fail\n", __FUNCTION__, __LINE__);
        return -1;
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

    memset(szEnableValue, 0, sizeof(szEnableValue));
    //ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szEnableValue);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);
    
    return 0;
}

int soap_SetGuestAccessEnabledResponse(void)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "		<m:SetGuestAccessEnabledResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\"></m:SetGuestAccessEnabledResponse>\r\n" \
            "		<ResponseCode>000</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}

/*
POST /soap/server_sa/ HTTP/1.0
SOAPAction: urn:NETGEAR-ROUTER:service:WLANConfiguration:1#SetGuestAccessEnabled2
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 740

<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<SOAP-ENV:Envelope xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema" 
   xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" 
   xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" 
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">
   
		<SOAP-ENV:Header>
			<SessionID>E6A88AE69687E58D9A00</SessionID>
		</SOAP-ENV:Header>

		<SOAP-ENV:Body>
		   <M1:SetGuestAccessEnabled2 xmlns:M1="urn:NETGEAR-ROUTER:service:WLANConfiguration:1">
				  <NewGuestAccessEnabled>1</NewGuestAccessEnabled>
					 <NewKey1></NewKey1>
					 <NewKey2>0</NewKey2>
					 <NewKey3>0</NewKey3>
					 <NewKey4>0</NewKey4>
					 <NewSSID>NETGEAR-Guest</NewSSID>
					 <NewSecurityMode>None</NewSecurityMode>
			</M1:SetGuestAccessEnabled2>
		</SOAP-ENV:Body>
		
</SOAP-ENV:Envelope>
*/
int soap_SetGuestAccessEnabled2(void)
{
    int ret = 0;
    char szEnableValue[8] = {0};
    char szKey[128] = {0};
    char szSSID[64] = {0};
    char szSecurityMode[32] = {0};

    char szSoapContent[MAX_SOAP_LEN] = {0};
    ST_MSG* pRsp = NULL;

    //http(soap)
    ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
        return -1;//error
    }

    //get parameters
    //SOAP_GET_NODE_VALUE("NewGuestAccessEnabled", szEnableValue);//iphoneĲͬ,ʧ
    SOAP_GET_NODE_VALUE("NewKey1", szKey);
    SOAP_GET_NODE_VALUE("NewSSID", szSSID);
    SOAP_GET_NODE_VALUE("NewSecurityMode", szSecurityMode);
    
    syslog(LOG_INFO, "[%s:%d][%s] [%s] [%s] [%s]\n", __FUNCTION__, __LINE__, 
        szEnableValue, szKey, szSSID, szSecurityMode);

    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_GUEST_ACCESS_ENABLE, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 4,
            "Enable", "1",//Ѿ˷ÿ硣֧iphone
            "Key", szKey,
            "SSID", szSSID,
            "SecurityMode", szSecurityMode);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call COMM_MakeAndSendCustomMsg fail\n", __FUNCTION__, __LINE__);
        return -1;
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

    memset(szEnableValue, 0, sizeof(szEnableValue));
    //ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szEnableValue);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);
    
    return 0;
}

int soap_SetGuestAccessEnabled2Response(void)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "		<m:SetGuestAccessEnabled2Response xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\"></m:SetGuestAccessEnabled2Response>\r\n" \
            "		<ResponseCode>000</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}

int soap_SetGuestAccessNetwork(void)
{
    int ret = 0;
    char szEnableValue[8] = {0};
    char szKey[128] = {0};
    char szSSID[64] = {0};
    char szSecurityMode[32] = {0};

    char szSoapContent[MAX_SOAP_LEN] = {0};
    ST_MSG* pRsp = NULL;

    //http(soap)
    ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
        return -1;//error
    }

    //get parameters
    SOAP_GET_NODE_VALUE("NewKey1", szKey);
    SOAP_GET_NODE_VALUE("NewSSID", szSSID);
    SOAP_GET_NODE_VALUE("NewSecurityMode", szSecurityMode);
    
    syslog(LOG_INFO, "[%s:%d] [%s] [%s] [%s]\n", __FUNCTION__, __LINE__, 
        szKey, szSSID, szSecurityMode);

    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_GUEST_ACCESS_NETWORK, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 3,
            "Key", szKey,
            "SSID", szSSID,
            "SecurityMode", szSecurityMode);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call COMM_MakeAndSendCustomMsg fail\n", __FUNCTION__, __LINE__);
        return -1;
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

    memset(szEnableValue, 0, sizeof(szEnableValue));
    //ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szEnableValue);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);
    
    return 0;
}

int soap_SetGuestAccessNetworkResponse(void)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "		<m:SetGuestAccessNetworkResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\"></m:SetGuestAccessNetworkResponse>\r\n" \
            "		<ResponseCode>000</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}

/*
POST /soap/server_sa/ HTTP/1.0
SOAPAction: urn:NETGEAR-ROUTER:service:WLANConfiguration:1#SetWLANNoSecurity
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 697


<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<SOAP-ENV:Envelope xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema" 
xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" 
xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" 
xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">

	<SOAP-ENV:Header>
		<SessionID>E6A88AE69687E58D9A00</SessionID>
	</SOAP-ENV:Header>
	
	<SOAP-ENV:Body>
		<M1:SetWLANNoSecurity xmlns:M1="urn:NETGEAR-ROUTER:service:WLANConfiguration:1">
			<NewChannel>Auto</NewChannel>
			<NewRegion>Europe</NewRegion>
			<NewSSID>NETGEAR13</NewSSID>
			<NewWPAPassphrase></NewWPAPassphrase>
			<NewWirelessMode>300Mbps</NewWirelessMode>
		</M1:SetWLANNoSecurity>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_SetWLANNoSecurity(void)
{
    int ret = 0;
    char szRadio[8] = {0};
    char szVerify[8] = {0};
    char szChannel[8] = {0};
    char szRegion[128] = {0};
    char szSSID[64] = {0};
    char szWirelessMode[16] = {0};

    char szSoapContent[MAX_SOAP_LEN] = {0};
    char szResult[8] = {0};
    ST_MSG* pRsp = NULL;

    //http(soap)
    ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
        return -1;//error
    }

    //get parameters
    SOAP_GET_NODE_VALUE("NewRadio", szRadio);
    SOAP_GET_NODE_VALUE("NewChannel", szChannel);
    //SOAP_GET_NODE_VALUE("NewRegion", szRegion);
    SOAP_GET_NODE_VALUE("NewSSID", szSSID);
    SOAP_GET_NODE_VALUE("NewWirelessMode", szWirelessMode);
    SOAP_GET_NODE_VALUE("NewVerify", szVerify);
    
    syslog(LOG_INFO, "[%s:%d][%s] [%s] [%s] [%s][%s]\n", __FUNCTION__, __LINE__, 
        szRadio,szChannel, szSSID, szWirelessMode,szVerify);

    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_WLAN_NO_SECURITY, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 5,
            "Radio", szRadio,
            "Channel", szChannel,
            "SSID", szSSID,
            "WirelessMode", szWirelessMode,
            "Verify", szVerify);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call COMM_MakeAndSendCustomMsg fail\n", __FUNCTION__, __LINE__);
        return -1;
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

    //ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szResult);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szResult);
    
    return 0;
}

int soap_SetWLANNoSecurityResponse(void)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "		<m:SetWLANNoSecurityResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\"></m:SetWLANNoSecurityResponse>\r\n" \
            "		<ResponseCode>000</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}

/*
POST /soap/server_sa/ HTTP/1.0
SOAPAction: urn:NETGEAR-ROUTER:service:WLANConfiguration:1#SetWLANWPAPSKByPassphrase
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 777

<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<SOAP-ENV:Envelope 
xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema" 
xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" 
xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" 
xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">
	<SOAP-ENV:Header>
		<SessionID>E6A88AE69687E58D9A00</SessionID>
	</SOAP-ENV:Header>
	<SOAP-ENV:Body>
		<M1:SetWLANWPAPSKByPassphrase xmlns:M1="urn:NETGEAR-ROUTER:service:WLANConfiguration:1">
			<NewChannel>06</NewChannel>
			<NewRegion>Europe</NewRegion>
			<NewSSID>NETGEAR16</NewSSID>
			<NewWPAEncryptionModes>WPA2-PSK</NewWPAEncryptionModes>
			<NewWPAPassphrase>hjhhahahakk</NewWPAPassphrase>
			<NewWirelessMode>300Mbps</NewWirelessMode>
		</M1:SetWLANWPAPSKByPassphrase>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
/**жǷַ*/
int isvaildkey(char *key, int keylen)
{
	int i = 0;

	if(keylen < 8)
		return -1;
	/*Ϸ*/
	if(keylen <= 63)
		return 0;
	if(keylen > 64) 
		return -1;
	
	for(i=0; i<keylen; i++){
		if(strchr("0123456789qwertyuiopasdfghjklzxcvbnmQWERTYUIOPASDFGHJKLZXCVBNM",key[i]))
			continue;
		else
			return -1;
	}

	return 0;
}

int soap_SetWLANWPAPSKByPassphrase(void)
{
    int ret = 0;
    char szChannel[8] = {0};
   // char szRegion[128] = {0};
    char szSSID[64] = {0};
    char szWirelessMode[16] = {0};
    char szWPAEncryModes[32] = {0};
    char szKey[128] = {0};
    char szResult[8] = {0};
	char szRadio[8] = {0};
	
    char szSoapContent[MAX_SOAP_LEN] = {0};
    ST_MSG* pRsp = NULL;

    //http(soap)
    ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
        return -1;//error
    }

    //get parameters
    SOAP_GET_NODE_VALUE("NewRadio", szRadio);
    SOAP_GET_NODE_VALUE("NewChannel", szChannel);
    //SOAP_GET_NODE_VALUE("NewRegion", szRegion);
    SOAP_GET_NODE_VALUE("NewSSID", szSSID);
    SOAP_GET_NODE_VALUE("NewWirelessMode", szWirelessMode);
    SOAP_GET_NODE_VALUE("NewWPAEncryptionModes", szWPAEncryModes);
    SOAP_GET_NODE_VALUE("NewWPAPassphrase", szKey);
    
    syslog(LOG_INFO, "[%s:%d][%s] [%s] [%s] [%s] [%s] [%s]\n", __FUNCTION__, __LINE__, 
       szRadio, szChannel, szSSID, szWirelessMode, szWPAEncryModes, szKey);

	/*Ϊtkipܷʽ豸֧֣ȥҪflash*/
	/*һҪãҪΪ54mbps, ΪҳѾûиˣô˲ʧ*/
    if((strstr(szWirelessMode, "g & b") != NULL) && (strstr(szWPAEncryModes,"WPA-PSK/WPA2-PSK") == NULL)){
		return -1;
    }
	if(isvaildkey(szKey, strlen(szKey)) != 0)
		return -1;
	
    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_WLAN_WPA2_SECURITY, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 6,
            "Channel", szChannel,
            "Radio", szRadio,
            "SSID", szSSID,
            "WPAEncryptionModes", szWPAEncryModes,
            "WPAPassphrase", szKey,
            "WirelessMode", szWirelessMode);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call COMM_MakeAndSendCustomMsg fail\n", __FUNCTION__, __LINE__);
        return -1;
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

    //ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szResult);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szResult);
    
    return 0;
}

/*
HTTP/1.0 200 OK
Content-Length: 420
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
	<SOAP-ENV:Body>
		<m:SetWLANWPAPSKByPassphraseResponse xmlns:m="urn:NETGEAR-ROUTER:service:WLANConfiguration:1">
		</m:SetWLANWPAPSKByPassphraseResponse>

		<ResponseCode>000</ResponseCode>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_SetWLANWPAPSKByPassphraseResponse(void)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "		<m:SetWLANWPAPSKByPassphraseResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\"></m:SetWLANWPAPSKByPassphraseResponse>\r\n" \
            "		<ResponseCode>000</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}


int soap_SetRouterWLANWPAPSKByPassphrase(void)
{
    int ret = 0;
    char szChannel[8] = {0};
    char szVerify[8] = {0};
    char szSSID[64] = {0};
    char szWirelessMode[16] = {0};
    char szWPAEncryModes[32] = {0};
    char szKey[128] = {0};
    char szResult[8] = {0};
	char szRadio[8] = {0};
	
    char szSoapContent[MAX_SOAP_LEN] = {0};
    ST_MSG* pRsp = NULL;

    //http(soap)
    ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
        return -1;//error
    }


    //get parameters
    SOAP_GET_NODE_VALUE("NewRadio", szRadio);
    SOAP_GET_NODE_VALUE("NewSSID", szSSID);
	SOAP_GET_NODE_VALUE("NewChannel", szChannel);
    SOAP_GET_NODE_VALUE("NewWirelessMode", szWirelessMode);
    SOAP_GET_NODE_VALUE("NewWPAEncryptionModes", szWPAEncryModes);
    SOAP_GET_NODE_VALUE("NewWPAPassphrase", szKey);
	SOAP_GET_NODE_VALUE("NewVerify", szVerify);
    
    syslog(LOG_INFO, "[%s:%d][%s] [%s] [%s] [%s] [%s] [%s] [%s]\n", __FUNCTION__, __LINE__, 
       szRadio, szChannel, szSSID, szWirelessMode, szWPAEncryModes, szKey, szVerify);

	/*Ϊtkipܷʽ豸֧֣ȥҪflash*/
	/*һҪãҪΪ54mbps, ΪҳѾûиˣô˲ʧ*/
    if((strstr(szWirelessMode, "g & b") != NULL) && (strstr(szWPAEncryModes,"WPA-PSK/WPA2-PSK") == NULL)){
		return -1;
    }
	if(isvaildkey(szKey, strlen(szKey)) != 0)
		return -1;
	
    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_ROUTER_WLAN_WPA2_SECURITY, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 7,
            "Channel", szChannel,
            "Radio", szRadio,
            "SSID", szSSID,
            "WPAEncryptionModes", szWPAEncryModes,
            "WPAPassphrase", szKey,
            "WirelessMode", szWirelessMode,
            "Verify", szVerify);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call COMM_MakeAndSendCustomMsg fail\n", __FUNCTION__, __LINE__);
        return -1;
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

    //ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szResult);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szResult);
    
    return 0;
}

/*
HTTP/1.0 200 OK
Content-Length: 420
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
	<SOAP-ENV:Body>
		<m:SetRouterWLANWPAPSKByPassphrase xmlns:m="urn:NETGEAR-ROUTER:service:WLANConfiguration:1">
		</m:SetRouterWLANWPAPSKByPassphrase>

		<ResponseCode>000</ResponseCode>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_SetRouterWLANWPAPSKByPassphraseResponse(void)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "		<m:SetRouterWLANWPAPSKByPassphrase xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\"></m:SetRouterWLANWPAPSKByPassphrase>\r\n" \
            "		<ResponseCode>000</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}



/*
POST /soap/server_sa/ HTTP/1.0
SOAPAction: urn:NETGEAR-ROUTER:service:DeviceConfig:1#Reboot
content-type: text/xml;charset=utf-8
HOST: www.routerlogin.com
User-Agent: SOAP Toolkit 3.0
connection: keep-Alive
Cache-Control: no-cache
Pragma: no-cache
content-length: 505


<?xml version="1.0" encoding="UTF-8" standalone="no"?>
<SOAP-ENV:Envelope 
	xmlns:SOAPSDK1="http://www.w3.org/2001/XMLSchema" 
	xmlns:SOAPSDK2="http://www.w3.org/2001/XMLSchema-instance" 
	xmlns:SOAPSDK3="http://schemas.xmlsoap.org/soap/encoding/" 
	xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/">

	<SOAP-ENV:Header>
		<SessionID>E6A88AE69687E58D9A00</SessionID>
	</SOAP-ENV:Header>
	<SOAP-ENV:Body>
		<M1:Reboot xmlns:M1="urn:NETGEAR-ROUTER:service:DeviceConfig:1"></M1:Reboot>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_Reboot(void)
{
    return 0;//ok
}

/*
HTTP/1.0 200 OK
Content-Length: 380
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
   
	<SOAP-ENV:Body>
		<m:RebootResponse  xmlns:m="urn:NETGEAR-ROUTER:service:DeviceConfig:1"></m:RebootResponse>
		<ResponseCode>000</ResponseCode>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_RebootResponse(void)
{
    int iRet = TBS_SUCCESS;
    char szEnableValue[64] = {0};
    char szPath[MAX_PATH_LEN] = "InternetGatewayDevice.X_TWSZ-COM_TrafficMeter.Enable";
    
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

    //ȡenable status
    CMM_GetStr(szPath,szEnableValue,sizeof(szEnableValue)-1, NULL, 0);

    syslog(LOG_CRIT,"[%s:%d]enable:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);
    snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "<m:RebootResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
            "<RebootTime>%d<RebootTime>\r\n"\
            "</m:RebootResponse>\r\n" \
            "<ResponseCode>0</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", 180);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));
    soap_response(bufErrResponseHeader, bufErrSOAPResponse);

    //reboot
    sleep(2);
    system("reboot");
    return 0;
}

/*
POST /soap/server_sa/ HTTP/1.1
Content-Type: text/xml; charset=utf-8
Accept: text/xml
SOAPAction: "urn:NETGEAR-ROUTER:service:DeviceInfo:1#GetInfo_DeviceInfo"
Content-Length: 344
Connection: Keep-Alive
Accept-Encoding: gzip
Accept-Language: zh-CN,en,*
User-Agent: Mozilla/5.0
Host: routerlogin.net


...<?xml version="1.0" encoding="utf-8" ?> 
<env:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
        xmlns:env="http://schemas.xmlsoap.org/soap/envelope/">

  <env:Header>
	 <SessionID>E6A88AE69687E58D9A88</SessionID>
  </env:Header>

  <env:Body>
    <GetInfo_DeviceInfo></GetInfo_DeviceInfo>
  </env:Body> 
</env:Envelope>
*/
int soap_GetInfo_DeviceInfo(void)
{
    return 0;//ok
}

/*
HTTP/1.0 200 OK
Content-Length: 952
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
	<SOAP-ENV:Body>
		<m:GetInfoResponse xmlns:m="urn:NETGEAR-ROUTER:service:DeviceInfo:1">  
			<ModelName>WNDR3800</ModelName>
			<Description>Netgear Smart Wizard 3.0, specification 1.6 version</Description>
			<SerialNumber>2M81185900083</SerialNumber>
			<Firmwareversion>V1.0.0.24</Firmwareversion>
			<SmartAgentversion>3.0</SmartAgentversion>
			<FirewallVersion>net-wall 2.0</FirewallVersion>
			<VPNVersion>PPP 2.4.3</VPNVersion>
			<OthersoftwareVersion>N/A</OthersoftwareVersion>
			<Hardwareversion>N/A</Hardwareversion>
			<Otherhardwareversion>N/A</Otherhardwareversion>
			<FirstUseDate>Sunday, 30 Sep 2007 01:10:03</FirstUseDate>
		</m:GetInfoResponse>

		<ResponseCode>000</ResponseCode>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetInfo_DeviceInfoResponse(void)
{
#if 1
    int ret = 0;
    ST_MSG* pRsp = NULL;
    char szModelName[32] = {0};
    char szDesc[128] = {0};
    char szSerialNum[16] = {0};
    char szFVer[16] = {0};
    char szSVer[16] = {0};
    char szFirewallVer[16] = {0};
    char szVVer[16] = {0};
    char szOFVer[16] = {0};
    char szHVer[16] = {0};
    char szOHVer[16] = {0};
    char szFirstUseDate[32] = {0};
    
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

    syslog(LOG_INFO, "into soap_GetInfo_DeviceInfoResponse\n");

    //ͻȡϢ
    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_DEV_INFO, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);
    if (ret != 0)
    {
        return -1;//send massage fail
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "ModelName Description SerialNumber " \
	                       "Firmwareversion SmartAgentversion FirewallVersion " \
	                       "VPNVersion OthersoftwareVersion Hardwareversion " \
	                       "Otherhardwareversion FirstUseDate" , szModelName,
	                       szDesc, szSerialNum, szFVer, szSVer,szFirewallVer,
	                       szVVer, szOFVer, szHVer, szOHVer, szFirstUseDate);

    //ϢҪͷŵ
    if (pRsp)
    {
        MSG_ReleaseMessage(pRsp);
        pRsp = NULL;
    }

    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
    }

    syslog(LOG_INFO, "will send response\n", __FUNCTION__, __LINE__);

    //http
    snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
                "		<m:GetInfoResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
                "			<Manufacturer>%s</Manufacturer>\r\n" \
                "			<ModelName>%s</ModelName>\r\n" \
                "			<Description>%s</Description>\r\n" \
                "			<SerialNumber>%s</SerialNumber>\r\n" \
                "			<Firmwareversion>%s</Firmwareversion>\r\n" \
                "			<SmartAgentversion>%s</SmartAgentversion>\r\n" \
                "			<FirewallVersion>%s</FirewallVersion>\r\n" \
                "			<VPNVersion>%s</VPNVersion>\r\n" \
                "			<OthersoftwareVersion>%s</OthersoftwareVersion>\r\n" \
                "			<Hardwareversion>%s</Hardwareversion>\r\n" \
                "			<Otherhardwareversion>%s</Otherhardwareversion>\r\n" \
                "			<FirstUseDate>%s</FirstUseDate>\r\n" \
                "		</m:GetInfoResponse>\r\n" \
                "		<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", "Netgear", szModelName, szDesc, szSerialNum,
            szFVer, szSVer, szFirewallVer, szVVer, szOFVer, szHVer, szOHVer,
            szFirstUseDate);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);

    return 0;
#else
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
                "		<m:GetInfoResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
                "			<ModelName>WNDR3800</ModelName>\r\n" \
                "			<Description>Netgear Smart Wizard 3.0, specification 1.6 version</Description>\r\n" \
                "			<SerialNumber>2M81185900083</SerialNumber>\r\n" \
                "			<Firmwareversion>V1.0.0.24</Firmwareversion>\r\n" \
                "			<SmartAgentversion>3.0</SmartAgentversion>\r\n" \
                "			<FirewallVersion>net-wall 2.0</FirewallVersion>\r\n" \
                "			<VPNVersion>PPP 2.4.3</VPNVersion>\r\n" \
                "			<OthersoftwareVersion>N/A</OthersoftwareVersion>\r\n" \
                "			<Hardwareversion>N/A</Hardwareversion>\r\n" \
                "			<Otherhardwareversion>N/A</Otherhardwareversion>\r\n" \
                "			<FirstUseDate>Sunday, 30 Sep 2007 01:10:03</FirstUseDate>\r\n" \
                "		</m:GetInfoResponse>\r\n" \
            	"		<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
#endif
}

/*
POST /soap/server_sa/ HTTP/1.1
Content-Type: text/xml; charset=utf-8
Accept: text/xml
SOAPAction: "urn:NETGEAR-ROUTER:service:WANIPConnection:1#GetInfo_WANIPConnection"
Content-Length: 354
Connection: Keep-Alive
Accept-Encoding: gzip
Accept-Language: zh-CN,en,*
User-Agent: Mozilla/5.0
Host: routerlogin.net

...<?xml version="1.0" encoding="utf-8" ?> 
<env:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
        xmlns:env="http://schemas.xmlsoap.org/soap/envelope/">

  <env:Header>
	 <SessionID>E6A88AE69687E58D9A88</SessionID>
  </env:Header>

  <env:Body>
    <GetInfo_WANIPConnection></GetInfo_WANIPConnection>
  </env:Body> 

  
</env:Envelope>
*/
int soap_GetInfo_WANIPConnection(void)
{
    return 0;//ok
}

/*
HTTP/1.0 200 OK
Content-Length: 932
Content-Type: text/xml; charset="UTF-8"
Server: Linux/2.6.15 uhttpd/1.0.0 soap/1.0

<?xml version="1.0" encoding="UTF-8"?>
<SOAP-ENV:Envelope
   xmlns:SOAP-ENV="http://schemas.xmlsoap.org/soap/envelope/"
   SOAP-ENV:encodingStyle="http://schemas.xmlsoap.org/soap/encoding/">
	<SOAP-ENV:Body>
		<m:GetInfoResponse xmlns:m="urn:NETGEAR-ROUTER:service:WANIPConnection:1">    <NewEnable>1</NewEnable>
			<NewConnectionType>PPPoE</NewConnectionType>
			<NewExternalIPAddress>183.37.78.11</NewExternalIPAddress>
			<NewSubnetMask>255.255.255.255</NewSubnetMask>
			<NewAddressingType>PPPoE</NewAddressingType>
			<NewDefaultGateway>183.37.78.11</NewDefaultGateway>
			<NewMACAddress>204E7F5AC2C0</NewMACAddress>
			<NewMACAddressOverride>0</NewMACAddressOverride>
			<NewMaxMTUSize>1492</NewMaxMTUSize>
			<NewDNSEnabled>1</NewDNSEnabled>
			<NewDNSServers>202.96.128.166 202.96.134.133</NewDNSServers>
		</m:GetInfoResponse>
		<ResponseCode>000</ResponseCode>
	</SOAP-ENV:Body>
</SOAP-ENV:Envelope>
*/
int soap_GetInfo_WANIPConnectionResponse(void)
{
#if 1
    int ret = 0;
    ST_MSG* pRsp = NULL;
    char szConnType[16] = {0};
    char szIpAddr[64] = {0};
    char szNetmask[16] = {0};
    char szIpAddrType[16] = {0};
    char szDefaultGw[64] = {0};
    char szMACAddr[16] = {0};
    char szMACAddrOverride[4] = {0};
    char szMaxMTU[16] = {0};
    char szDNSEnable[4] = {0};
    char szDNSServer[128] = {0};
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

    syslog(LOG_INFO, "into soap_GetInfo_WANIPConnectionResponse\n", __FUNCTION__, __LINE__);

    //ͻȡϢ
    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_WANIP_INFO, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);
    if (ret != 0)
    {
        return -1;//send massage fail
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "ConnType ExternalIPAddr SubnetMask AddressingType " \
	                       "DefaultGateway MACAddress MACAddrOverride MaxMTUSize " \
	                       "DNSEnabled DNSServers" , szConnType, szIpAddr, szNetmask,
	                       szIpAddrType, szDefaultGw, szMACAddr, szMACAddrOverride,
	                       szMaxMTU, szDNSEnable, szDNSServer);

    //ϢҪͷŵ
    if (pRsp)
    {
        MSG_ReleaseMessage(pRsp);
        pRsp = NULL;
    }

    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
    }

    syslog(LOG_INFO, "will send response\n", __FUNCTION__, __LINE__);

    //http
    snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
                "		<m:GetInfoResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
                "			<NewConnectionType>%s</NewConnectionType>\r\n" \
                "			<NewExternalIPAddress>%s</NewExternalIPAddress>\r\n" \
                "			<NewSubnetMask>%s</NewSubnetMask>\r\n" \
                "			<NewAddressingType>%s</NewAddressingType>\r\n" \
                "			<NewDefaultGateway>%s</NewDefaultGateway>\r\n" \
                "			<NewMACAddress>%s</NewMACAddress>\r\n" \
                "			<NewMACAddressOverride>%s</NewMACAddressOverride>\r\n" \
                "			<NewMaxMTUSize>%s</NewMaxMTUSize>\r\n" \
                "			<NewDNSEnabled>%s</NewDNSEnabled>\r\n" \
                "			<NewDNSServers>%s</NewDNSServers>\r\n" \
                "		</m:GetInfoResponse>\r\n" \
                "		<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", szConnType, szIpAddr, szNetmask,
            szIpAddrType, szDefaultGw, szMACAddr, szMACAddrOverride,
            szMaxMTU, szDNSEnable, szDNSServer);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);

    return 0;
#else
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
                "		<m:GetInfoResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
                "			<NewConnectionType>DHCP</NewConnectionType>\r\n" \
                "			<NewExternalIPAddress>192.168.128.111</NewExternalIPAddress>\r\n" \
                "			<NewSubnetMask>255.255.255.0</NewSubnetMask>\r\n" \
                "			<NewAddressingType>DHCP</NewAddressingType>\r\n" \
                "			<NewDefaultGateway>192.168.128.1</NewDefaultGateway>\r\n" \
                "			<NewMACAddress>001EE3E60530</NewMACAddress>\r\n" \
                "			<NewMACAddressOverride>1</NewMACAddressOverride>\r\n" \
                "			<NewMaxMTUSize>1492</NewMaxMTUSize>\r\n" \
                "			<NewDNSEnabled>1</NewDNSEnabled>\r\n" \
                "			<NewDNSServers>192.168.128.1</NewDNSServers>\r\n" \
                "		</m:GetInfoResponse>\r\n" \
            	"		<ResponseCode>000</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
#endif
}

/* Device Config*/
int soap_Exit(void)
{
	return 0;
}

/*********************************************************
:soap_ExitResponse
:Ƿָ
:
:
ֵ: 0
*********************************************************/
int soap_ExitResponse(void)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "   <m:ExitResponse\r\n" \
            "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
            "   </m:ExitResponse>\r\n" \
            "   <ResponseCode>0</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n"};

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
    return 0;
}

/*********************************************************
:soap_SetEnable
:Ƿָ
:
:
ֵ: 0
*********************************************************/
int soap_SetEnable()
{	
	int ret = 0;
	char eanble[8] = {0};
	ST_MSG* pRsp = NULL;
	char szSoapContent[MAX_SOAP_LEN] = {0};
	char szEnableValue[8] = {0};
	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}
	
	SOAP_GET_NODE_VALUE("NewEnable",eanble);
	syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content, NewEnable: %d\n", __FUNCTION__, __LINE__,atoi(eanble));

	//ͻȡϢ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_RESTORE_ENABLE_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 1, "NewEnable",eanble);
	if (ret != 0)
	{
	    return 1;//send massage fail
	}

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
		syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
		return -1;//receive message fail
	}

	memset(szEnableValue, 0, sizeof(szEnableValue));
	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szEnableValue);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);
	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	
	return 0;
}

/*********************************************************
:soap_SetEnableResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_SetEnableResponse(int ret)
{
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

     snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "   <m:SetEnableResponse\r\n" \
            "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
            "   </m:SetEnableResponse>\r\n" \
            "   <ResponseCode>0</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n");

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
    return 0;
}

int soap_GetEnable(void)
{
	return 0;
}

/*********************************************************
:soap_GetEnableResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_GetEnableResponse()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char NewEnable[8] = {0};
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

		//ͻȡϢ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_RESTORE_ENABLE_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);
	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);

	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return 1;//receive message fail
	}

		//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "NewEnable",NewEnable);

	if(ret == 0){
		 snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:GetEnableResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "<NewEnable>%d<NewEnable>\r\n"\
		        "   </m:GetEnableResponse>\r\n" \
		        "   <ResponseCode>0</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n",atoi(NewEnable));
	}else{
		 snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:GetEnableResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "   </m:GetEnableResponse>\r\n" \
		        "   <ResponseCode>1</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n");
	}

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}
	return 0;
}
#if 1
#define MINI_FIRMWARE_FTP_SERVER1 "ftp://updates1.netgear.com/"
#define MINI_FIRMWARE_FTP_SERVER2 "ftp://updates2.netgear.com/"
#define MINI_FIRMWARE_FTP_SERVER3 "ftp://updates3.netgear.com/"
#define MINI_FTP_SERVER_NUM 3
char ngNewVer[56] = {0};
char ngCurrVer[56] = {0};
typedef struct RegionFtpServerTable
{
	char region[10];
	char folder[10];
}RegionFolderTable;

RegionFolderTable RegionFtpTable[] = {
		{"NA","us"},
		{"CA","ca"},
		{"WW","ww"},
		{"GR","de"},
		{"PR","cn"},
		{"RU","ru"},
		{"BZ","br"},
		{"IN","in"},
		{"KO","kr"},
		{"JP","jp"},
		{"AU","au"},
		{"US","us"}			
};

int findStrInFile(char *pszFileName, char *pszStr)
{
    FILE *fd = NULL;
    char result[512]={0};
    int iRet = TBS_FAILED;

    /*ڽбвinetdǷ*/
    fd = fopen(pszFileName, "r");
    if(NULL == fd)
    {
    	syslog(LOG_CRIT,"[%s:%d] findStrInFile open %s failed\n", __FUNCTION__, __LINE__,pszFileName);
    	return iRet;
    }

    while (1)
    {
        if (fgets(result, sizeof(result), fd) == NULL)
        {
            break;
        }
        if (strstr(result, pszStr) != NULL)
        {
            iRet = TBS_SUCCESS;
            break;
        }
    }

    fclose(fd);

    return iRet;
}

char *StrSkipChar(char src[],char remove)
{
 int t=0;
 char *str=NULL;
 str=strdup(src);
 char* p=str;
 while (*p) {
  if (remove!=*p)
  { str[t]=*p;
   t++;
  }
   p++;
  }
 str[t]='\0';
 return str;
}

int findSoftwareVersion()
{
	FILE *fd = NULL;
	char result[512]={0};
	char *pstr = NULL;char *pstr2 = NULL;
	int version = 0;
	char tempstr[56] = {0};
	char *verstr = NULL;
	fd= fopen("/var/fileinfo.txt","r");
	if(fd == NULL){
		syslog(LOG_CRIT,"[%s:%d] findStrInFile open %s failed\n", __FUNCTION__, __LINE__,"/var/fileinfo.txt");
		return -1;
	}

	while(fgets(result, sizeof(result), fd) != NULL){
		if(strstr(result, "file=")){
			if((pstr = strstr(result, "-V")) != NULL){
				strcpy(tempstr, pstr+2);
				verstr = StrSkipChar((char *)tempstr,'.');
				version = atoi(verstr);
				pstr2 = strstr(pstr,".img");
				memset(ngNewVer, 0, 56);
				strncpy(ngNewVer,pstr+2,pstr2 - (pstr+2));
				free(verstr);
				break;
			}
		}
		memset(result, 0, sizeof(result));
	}
	fclose(fd);

	return version;
}

int findCurrSoftwareVersion()
{
	int currVersion = 0;
	char tempstr[56] = {0};
	char a[8] = {0};char b[8] = {0};char c[8] = {0};char d[8] = {0};
	char *verstr = NULL;
	strcpy(tempstr,CONFIG_SW_VERSION);
	verstr= StrSkipChar((char *)tempstr,'.');
	currVersion = atoi(verstr);
	free(verstr);

	return currVersion;
}
int soap_CheckNewFirmware()
{
	int iRet = TBS_FAILED;
	int i = 0, newVersion = 0, currVersion =0;
	char szCmd[MAX_CMD_LEN] = {0};
	char szFtpServers[MINI_FTP_SERVER_NUM][128] = {
	    MINI_FIRMWARE_FTP_SERVER1,
	    MINI_FIRMWARE_FTP_SERVER2,
	    MINI_FIRMWARE_FTP_SERVER3};
#if defined(CONFIG_APPS_HTML_WEB_STYLE_GENIE_EXT_R2) || defined(CONFIG_APPS_HTML_WEB_STYLE_GENIE_PLW_AP) || defined(CONFIG_APPS_HTML_WEB_STYLE_GENIE_PLW1000_AP)	
		char FolderName[10]={0};
		char ContentBuf[10] = {0};
		FILE *szfp = NULL;
		int ii = 0;
#endif

	/*ӷϻȡļļϢ*/
	/*ظȡļǰҪɾǰȡļʾ*/
#if defined(CONFIG_APPS_HTML_WEB_STYLE_GENIE_EXT_R2) || defined(CONFIG_APPS_HTML_WEB_STYLE_GENIE_PLW_AP) || defined(CONFIG_APPS_HTML_WEB_STYLE_GENIE_PLW1000_AP)
	if(szfp = fopen("/proc/llconfig/region","r"))
	{
		fgets(ContentBuf,sizeof(ContentBuf),szfp);
		if(strlen(ContentBuf)>0)
		{
			for(ii=0;ii<sizeof(RegionFtpTable)/sizeof(RegionFolderTable);ii++)
			{
				if(strcmp(ContentBuf,RegionFtpTable[ii].region)==0)
				{
					sprintf(FolderName,"%s",RegionFtpTable[ii].folder);
					break;
				}
			}
			if(ii == sizeof(RegionFtpTable)/sizeof(RegionFolderTable))
			{
				
				strcat(FolderName,"ww");		
			}
		}
		else
			strcat(FolderName,"ww");		
		fclose(szfp);
	}
	else
		strcat(FolderName,"ww");	
	#else
	strcat(FolderName,"ww");
	#endif
	for(i = 0; i < 3; i++)
	{
		system("rm /var/wget.log -rf");
		system("rm /var/fileinfo -rf");
		system("rm /var/fileinfo.txt -rf");
		snprintf(szCmd, MAX_CMD_LEN, "cd /var/;wget %s%s/%s/%s %s %s>/var/wget.log 2>&1",
            			szFtpServers[i], CONFIG_SW_MODEL, FolderName, "fileinfo.txt", "", "");
		iRet = system(szCmd);
	

		if(0 == findStrInFile("/var/wget.log", "we get file success")){
			syslog(LOG_CRIT,"[%s:%d]call soap_CheckNewFimware get file success\n", __FUNCTION__, __LINE__);
			break;
		}
	}

	/*صfileinfoе汾*/
	newVersion = findSoftwareVersion();
	/*ǰİ汾*/
	currVersion = findCurrSoftwareVersion();
	
	if(newVersion > currVersion){
		syslog(LOG_CRIT,"[%s:%d]call soap_CheckNewFimware success\n", __FUNCTION__, __LINE__);
		return 0;
	}
		
	return 1;
}

int soap_CheckNewFirmwareResponse(int ret)
{
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};
	
	/*ɹ*/
	if((ret == 0) || (ret == 1)){
	    //http
	    snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
	            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	            "<SOAP-ENV:Envelope\r\n" \
	               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	            	"<SOAP-ENV:Body>\r\n" \
	                "		<m:CheckNewFirmwareResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	                "			<CurrentVersion>V%s</CurrentVersion>\r\n" \
	                "			<NewVersion>V%s</NewVersion>\r\n" \
	                "			<ReleaseNote>%s</ReleaseNote>\r\n" \
	                "		</m:CheckNewFirmwareResponse>\r\n" \
	                "		<ResponseCode>000</ResponseCode>\r\n" \
	            	"</SOAP-ENV:Body>\r\n" \
	            "</SOAP-ENV:Envelope>\r\n", CONFIG_SW_VERSION, ngNewVer, ".r.+.r.+n, ReleaseNote with index 2 hreadd");

		    //httpͷ
		    soap_generate_httpheader(bufErrResponseHeader,
		        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

		    soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

		return 0;
	}

	if(ret < 0)
	{
	    //http
	    snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
	            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	            "<SOAP-ENV:Envelope\r\n" \
	               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	            	"<SOAP-ENV:Body>\r\n" \
	                "		<m:CheckNewFirmwareResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	                "			<CurrentVersion>V%s</CurrentVersion>\r\n" \
	                "			<NewVersion>V%s</NewVersion>\r\n" \
	                "			<ReleaseNote>%s</ReleaseNote>\r\n" \
	                "		</m:CheckNewFirmwareResponse>\r\n" \
	                "		<ResponseCode>501</ResponseCode>\r\n" \
	            	"</SOAP-ENV:Body>\r\n" \
	            "</SOAP-ENV:Envelope>\r\n", CONFIG_SW_VERSION, "", " ");

		    //httpͷ
		    soap_generate_httpheader(bufErrResponseHeader,
		        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

		    soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

		return 0;
	}

	return 0;
}
#else
int soap_CheckNewFirmware()
{
	return 0;
}

/*********************************************************
:soap_CheckNewFirmwareResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_CheckNewFirmwareResponse(int ret)
{
	int temp = 0;
	ST_MSG* pRsp = NULL;
	char CurrentFWVersion[24] = {0};
	char NewFWVersion[24] = {0};
	char CurrentLanguageVersion[24] = {0};
	char NewLanguageVersion[24] = {0};
	char ReleaseNote[512] = {0};
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};
	int check_falg = 0;

	//Ϣlangģfirmware
	temp = COMM_MakeAndSendCustomMsg(MSG_GENIE_CHECK_NEW_FIRMWARE, 
	        MID_MINIHTTPD_SELF, MID_LANG, 0);
	if (temp != 0)
	{
	    return -1;//send massage fail
	}

	//ȴ90s δյӦʾʧ
	temp = MSG_ReceiveMessage(&pRsp, 90);
	if (temp != MSG_OK) 
	{	
	 	check_falg = 1;  
	}
	
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;

	}	

	//ͻȡϢ
	temp = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_NEW_VERSION, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);
	if (temp != 0)
	{
	    return -1;//send massage fail
	}

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	temp = MSG_ReceiveMessage(&pRsp, 5);
	if (temp != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return -1;//receive message fail
	}
	 

	//ϢҪֶεֵ
	temp = COMM_ParseCustomMsg(pRsp, "CurrentFWVersion NewFWVersion CurrentFWVersion NewLanguageVersion",
			CurrentFWVersion, NewFWVersion, CurrentLanguageVersion, NewLanguageVersion);

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	
	
	printf("[%s:%d]check_falg=%d, CurrentFWVersion=%s, NewFWVersion=%s, CurrentLanguageVersion=%s, NewLanguageVersion=%s \n", __FUNCTION__, __LINE__, 
			check_falg, CurrentFWVersion, NewFWVersion, CurrentLanguageVersion, NewLanguageVersion);
	
	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:CheckNewFirmwareResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	        "<CurrentFWVersion>%s<CurrentFWVersion>\r\n"\
	        "<NewFWVersion>%s<NewFWVersion>\r\n"\
	        "<CurrentLanguageVersion>%s<CurrentLanguageVersion>\r\n"\
	        "<NewLanguageVersion>%s<NewLanguageVersion>\r\n"\
	        "<ReleaseNote>%s<ReleaseNote>\r\n"\
	        "   </m:CheckNewFirmwareResponse>\r\n" \
	        "   <ResponseCode>%d</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n",CurrentFWVersion, check_falg? " " : NewFWVersion, CurrentLanguageVersion, check_falg? " " : NewLanguageVersion, " ", ret);

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);		
	return 0;
}
#endif
int soap_UpdateNewFirmware()
{
	
	int ret = 0;
	char YesOrNo[8] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};
	ST_MSG* pRsp = NULL;
	char szResult[8] = {0};
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	
	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}
	
	SOAP_GET_NODE_VALUE("YesOrNo",YesOrNo);

	if((atoi(YesOrNo) != 0) && (atoi(YesOrNo) != 1))
		return 10;
	
	if(atoi(YesOrNo) == 0)
		return 0;
	
	/*do download*/
	//Ϣlangģimg
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_DOWNLOAD_IMG, 
			MID_MINIHTTPD_SELF, MID_LANG, 0);
	if (ret != 0)
	{
		return 1;//error
	}
	
	//ȴ250s δյӦʾʧ
	ret = MSG_ReceiveMessage(&pRsp, 250);
	if (ret != MSG_OK) 
	{	
		printf("[%s:%d] Download IMG fail\n", __FUNCTION__, __LINE__);
	    return 901;//error
	}
	
	if (pRsp)
	{
		//ϢҪֶεֵ
		COMM_ParseCustomMsg(pRsp, "Result", szResult);	
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
		if (safe_strcmp(szResult, "1") == 0)
		{
			printf("[%s:%d] Download IMG fail\n", __FUNCTION__, __LINE__);
	   		return 901;//error
		}
		
	}	
	
	//Ϣlangģimg
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_UPGRADE_IMG, 
			MID_MINIHTTPD_SELF, MID_LANG, 0);
	if (ret != 0)
	{
		return 1;//error
	}

	//ȴ30 δյӦ
	ret = MSG_ReceiveMessage(&pRsp, 30);
	if (ret != MSG_OK) 
	{	
		printf("[%s:%d] Upgrade IMG fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}
	
	if (pRsp)
	{
		//ϢҪֶεֵ
		ret = COMM_ParseCustomMsg(pRsp, "Result", szResult);	
		MSG_ReleaseMessage(pRsp);
		pRsp = NULL;
		
		if (safe_strcmp(szResult, "0") == 0)
 			ret = 2;
		else
			ret = 1;
	}

	return ret;
}

/*********************************************************
:soap_UpdateNewFirmwareResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_UpdateNewFirmwareResponse(int ret)
{
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:UpdateNewFirmwareResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	        "		  <RebootTime>%d<RebootTime>\r\n"\
	        "   </m:UpdateNewFirmwareResponse>\r\n" \
	        "   <ResponseCode>%d</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n",(ret==2)?180:0,(ret==2)?0:ret);
	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);
	
	/*У鶼ɹ*/
	if(ret == 0){
		/*do reboot */
		//system("reboot");
	}
		
	return 0;		
}

/*********************************************************
:soap_ResetToFactoryDefault
:ָ
:
:
ֵ: 0
*********************************************************/
int soap_ResetToFactoryDefault()
{
	int temp = 0;
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char SerialNumber[64] = {0};
	char SerialNumber2[64] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}
	
	SOAP_GET_NODE_VALUE("SerialNumber",SerialNumber);

	if(strlen(SerialNumber) > 16)
		return 10;

	//ͻȡϢ
	temp = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_DEV_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);
	if (temp != 0)
	{
	    return 1;//send massage fail
	}

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	temp = MSG_ReceiveMessage(&pRsp, 5);
	if (temp != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return 1;//receive message fail
	}

	//ϢҪֶεֵ
	temp = COMM_ParseCustomMsg(pRsp, "SerialNumber",
			SerialNumber2);

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	

	if(strncmp(SerialNumber, SerialNumber2, strlen(SerialNumber)) != 0)
		temp = 900;//900: Incorrect serial number

	 snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:UpdateNewFirmwareResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	        "			<RebootTime>%d<RebootTime>\r\n"\
	        "   </m:UpdateNewFirmwareResponse>\r\n" \
	        "   <ResponseCode>%d</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n",180,temp);

	if(temp != 0)
		return 0;

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

	temp = COMM_MakeAndSendCustomMsg(MSG_CMM_RECOVER_CFG, MID_MINIHTTPD_SELF, MID_CMM, 0);
	if (temp != 0)
	{
	    return 1;//send massage fail
	}

	temp = MSG_ReceiveMessage(&pRsp, 5);
	if (temp != MSG_OK) 
	{
	    return 1;//receive message fail
	}	

	if((unsigned long)(pRsp->szMsgBody) != MSG_OK) 
		temp = 1;
	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}
	return temp;
}

int soap_ResetToFactoryDefaultResponse(int ret)
{
	return 0;
}

/*********************************************************
:soap_SetDeviceIPAddress
:豸ipϢ
:
:
ֵ: 0
*********************************************************/
int soap_SetDeviceIPAddress()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char szEnableValue[8] = {0};
	char dhcpOrStatic[8] = {0}; /*0: dhcp; 1: static ip*/
	char NewStaticAddress[32] = {0};
	char NewStaticSubnet[32] = {0};
	char NewStaticGateway[32] = {0};
	char NewStaticDNS[32] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};

	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_SetDeviceIPAddress fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}
	
	SOAP_GET_NODE_VALUE("NewAddressMode",dhcpOrStatic);
	SOAP_GET_NODE_VALUE("NewStaticAddress",NewStaticAddress);
	SOAP_GET_NODE_VALUE("NewStaticSubnet",NewStaticSubnet);
	SOAP_GET_NODE_VALUE("NewStaticGateway",NewStaticGateway);
	SOAP_GET_NODE_VALUE("NewStaticDNS",NewStaticDNS);

	 syslog(LOG_INFO, "[%s:%d][%s] [%s] [%s] [%s] [%s]\n", __FUNCTION__, __LINE__, 
        dhcpOrStatic, NewStaticAddress, NewStaticSubnet, NewStaticGateway,NewStaticDNS);

	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_LAN_IP_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 4,
	        "NewStaticAddress", NewStaticAddress,//Ѿ˷ÿ硣֧iphone
	        "NewStaticSubnet", NewStaticSubnet,
	        "NewStaticGateway", NewStaticGateway,
	        "NewStaticDNS", NewStaticDNS);	 

	if (ret != 0)
	{
		syslog(LOG_ERR, "[%s:%d]call soap_SetDeviceIPAddress fail\n", __FUNCTION__, __LINE__);
		return -1;
	}

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
		syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
		return -1;//receive message fail
	}

	memset(szEnableValue, 0, sizeof(szEnableValue));
	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szEnableValue);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);
	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	
	return 0;
}

/*********************************************************
:soap_SetDeviceIPAddressResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_SetDeviceIPAddressResponse(int ret)
{
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	 snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:SetDeviceIPAddressResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	        "   </m:SetDeviceIPAddressResponse>\r\n" \
	        "   <ResponseCode>%d</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n",ret);
	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

	return 0;
}

int soap_GetDeviceIPAddress()
{
	return 0;
}

/*********************************************************
:soap_GetDeviceIPAddressResponse
:ȡ豸ipϢ
:
:
ֵ: 0
*********************************************************/
int soap_GetDeviceIPAddressResponse()
{
	int temp = 0;
	ST_MSG* pRsp = NULL;
	char NewStaticAddress[32] = {0};
	char NewStaticSubnet[32] = {0};
	char NewStaticGateway[32] = {0};
	char NewStaticDNS[32] = {0};
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	//ͻȡϢ
	temp = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_LAN_IP_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);

	temp = MSG_ReceiveMessage(&pRsp, 5);
	if (temp != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return 1;//receive message fail
	}

		//ϢҪֶεֵ
	temp = COMM_ParseCustomMsg(pRsp, "NewStaticAddress NewStaticSubnet NewStaticGateway NewStaticDNS",
			NewStaticAddress,NewStaticSubnet,NewStaticGateway,NewStaticDNS);

	if(temp == 0){
		 snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:GetDeviceIPAddressResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "<NewAddressMode>1</NewAddressMode>\r\n" \
		        "<NewStaticAddress>%s</NewStaticAddress>\r\n" \
		        "<NewStaticSubnet>%s</NewStaticSubnet>\r\n" \
		        "<NewStaticGateway>%s</NewStaticGateway>\r\n" \
		        "<NewStaticDNS>%s</NewStaticDNS>\r\n" \
		        "   </m:GetDeviceIPAddressResponse>\r\n" \
		        "   <ResponseCode>0</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n",NewStaticAddress,NewStaticSubnet,NewStaticGateway,NewStaticDNS);	
	}else{
		 snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:GetDeviceIPAddressResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "   </m:GetDeviceIPAddressResponse>\r\n" \
		        "   <ResponseCode>1</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n");	
	}
	
		//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}
	return 0;
}

/*********************************************************
:soap_SetTimeZone
:ʱϢ
:
:
ֵ: 0
*********************************************************/
int soap_SetTimeZone()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char szEnableValue[8] = {0};
	char LocalTimeZone[32] = {0};	
	char DaylightSaving[32] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};
	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_SetTimeZone fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}	

	SOAP_GET_NODE_VALUE("NewTimeZone",LocalTimeZone);
	SOAP_GET_NODE_VALUE("NewDaylightSaving",DaylightSaving);

	 syslog(LOG_INFO, "[%s:%d][%s] [%s]\n", __FUNCTION__, __LINE__, 
        LocalTimeZone, DaylightSaving);

	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_TIME_ZONE_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 2,
	        "LocalTimeZone", LocalTimeZone,//Ѿ˷ÿ硣֧iphone
	        "DaylightSavingsUsed", DaylightSaving);	 

	if (ret != 0)
	{
		syslog(LOG_ERR, "[%s:%d]call soap_SetTimeZone fail\n", __FUNCTION__, __LINE__);
		return -1;
	}

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
		syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
		return -1;//receive message fail
	}

	memset(szEnableValue, 0, sizeof(szEnableValue));
	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szEnableValue);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}
	return 0;
}

/*********************************************************
:soap_SetTimeZoneResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_SetTimeZoneResponse()
{
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	 snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:SetTimeZoneResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	        "   </m:SetTimeZoneResponse>\r\n" \
	        "   <ResponseCode>0</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n");
	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

	return 0;	
}

int soap_GetTimeZone()
{
	return 0;
}

/*********************************************************
:soap_GetTimeZoneResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_GetTimeZoneResponse()
{
	int temp = 0;
	ST_MSG* pRsp = NULL;
	char LocalTimeZone[32] = {0};	
	char DaylightSaving[32] = {0};	
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	

	//ͻȡϢ
	temp = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_TIME_ZONE_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);	

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);

	temp = MSG_ReceiveMessage(&pRsp, 5);
	if (temp != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return 1;//receive message fail
	}

	//ϢҪֶεֵ
	temp = COMM_ParseCustomMsg(pRsp, "LocalTimeZone DaylightSavingsUsed",
			LocalTimeZone,DaylightSaving);

	if(temp == 0){
		 snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:GetTimeZoneResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "<NewTimeZone>%s</NewTimeZone>\r\n" \
		        "<NewDaylightSaving>%s</NewStaticAddress>\r\n" \
		        "   </m:GetTimeZoneResponse>\r\n" \
		        "   <ResponseCode>0</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n",LocalTimeZone,DaylightSaving);	
	}else{
		 snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:GetTimeZoneResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "   </m:GetTimeZoneResponse>\r\n" \
		        "   <ResponseCode>1</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n");	
	}
	
		//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}

	return 0;	
}

int soap_BackupDeviceConfigFileResponse(char *FileName, char* ConfigFileContent, int ResponseCode);
#define MINI_HTTPD_MODELNAME "/proc/llconfig/model"
#define FIRM_FILE_NAME 	        "/var/image.img"
#define CONFIG_SIZE			    1024
enum
{
	NONE,
 	IMG_WRITE,
 	CONFIG_READ,
 	CONFIG_WRITE
};
int soap_BackupDeviceConfigFile()
{
	int status = TBS_SUCCESS;
    int iRet;
    pid_t child;
    ST_MSG *pstMsg = NULL;
    unsigned long ulResult = 0;

	FILE *fp = NULL;
	char model_name[16 + 1] = { 0 };
	char full_model_name[64 + 1] = {0};

	fp = fopen(MINI_HTTPD_MODELNAME, "r+");
	if( NULL == fp )
	{
		printf("[%s:%d]open %s failed ...\n",__FUNCTION__, __LINE__, MINI_HTTPD_MODELNAME);
        return 1;
	}
	
	if( NULL == fgets(model_name, sizeof(model_name), fp))
	{
		printf("[%s:%d]fgets %s failed ...\n",__FUNCTION__, __LINE__, MINI_HTTPD_MODELNAME);
		fclose(fp);
        return 1;
	}
	fclose(fp);
	

	
    int src;
    char tmpBuf[CONFIG_SIZE];
    int rd;
	
    /*  */
    if ((child = fork()) < 0)
    {
		printf("[%s:%d]fork process for download config failed ...\n",__FUNCTION__, __LINE__);
        return 1;
    }
    else if (child == 0)
    {
        /*  -c  ,CONFIG_READǶļ -u MINIHTTPD_SELFMINIHTTPD_SELFģupgrader*/
        execlp("upgrader",  "upgrader", "-c", CONFIG_READ, "-p", FIRM_FILE_NAME, "-u", "MINIHTTPD_SELF",  0);
    }

	iRet = MSG_ReceiveMessage(&pstMsg, 10);   //10 need detailed consideration
    if (iRet == TBS_SUCCESS)
    {
        ulResult = *(unsigned long *)pstMsg->szMsgBody;
        status =(int)ulResult;
        if(status== TBS_SUCCESS)
        {
            /* ȡóɹ*/
            printf("[%s:%d]download config file ok ...\n", __FUNCTION__, __LINE__);
			sprintf(full_model_name,"NETGEAR_%s.cfg",model_name);
			

            /* ļ*/
            src = open(FIRM_FILE_NAME, O_RDONLY);
            if(src < 0)
            {
                printf("[%s:%d]open config file  failed !\n", __FUNCTION__, __LINE__);
                return 900;
            }

      
            memset(tmpBuf,0,CONFIG_SIZE);
            while((rd = read(src, tmpBuf, CONFIG_SIZE)) != 0)
            {
                if(rd  == -1 )
                {
                    status = 1;
                    break;
                }
                // ļ
				soap_BackupDeviceConfigFileResponse(full_model_name, tmpBuf, 0); /*ѭļͽ*/
                memset(tmpBuf,0,CONFIG_SIZE);
				 /*status = 3; ʹãΪȡļѾʼֱ
				   status=3ʱ򣬾ͲҪٴηӦ*/
				status = 3;
            }
            close(src);
            unlink(FIRM_FILE_NAME);
        }

        safe_free_msg(pstMsg);
    }
    else
    {
        status = 1;
        printf("SOAP_DownloadFile :status %d\n", status);
    }

    return status;
}


/*********************************************************
:soap_BackupDeviceConfigFileResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_BackupDeviceConfigFileResponse(char *FileName, char* ConfigFileContent, int Ret)
{
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};
	
	 snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:BackupDeviceConfigFileResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	        "      		<FileName>%s</FileName>\r\n" \		
	        "      		<ConfigFileContent>%s</ConfigFileContent>\r\n" \			
	        "   </m:BackupDeviceConfigFileResponse>\r\n" \
	        "   <ResponseCode>%d</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n", FileName, ConfigFileContent, Ret);	
	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
	return 0;	
}


/*************************************************************************
: ļǷϷ
: 
: ״̬
*************************************************************************/
#define CONFIG_FILE_NAME 	        "/var/config.img"
int SOAP_CheckConfigFile(void)
{
    FILE *pFile = fopen(CONFIG_FILE_NAME, "r");
    char *p = NULL;
    char szBuffer[512] = {0};

    if (pFile == NULL)
    {
        printf("unable to open %s for read\n", CONFIG_FILE_NAME);
        return ERR_INVALID_VARIABLE_ERROR;
    }

    while (fgets(szBuffer, sizeof(szBuffer), pFile))
    {
    
#ifdef CONFIG_APPS_LOGIC_APCLIENT
		/*RepeaterƷõıʶ*/
		p = strstr(szBuffer,  "Netgear Extender");
#else
        p = strstr(szBuffer,  "Netgear Wireless Router");
#endif

        if (p != NULL)
        {
            fclose(pFile);
            return TBS_SUCCESS;
        }
    }

    fclose(pFile);
    return 900;
}

/**************************************************************************
: ļ
: 
: ״̬
**************************************************************************/
int SOAP_DoConfigUpgrade(void)
{
    int status = 0;
    int iRet;
    pid_t child;
    ST_MSG *pstMsg = NULL;
    unsigned long ulResult = 0;

    /*  */
    if ((child = fork()) < 0)
    {
        printf("fork process to  update config failed ...\n");
        return 1;
    }
    else if (child == 0)
    {
        /*  -c  ,CONFIG_WRITEдļ -u MINIHTTPD_SELFMINIHTTPD_SELFģupgrader*/
        execlp("upgrader",  "upgrader", "-c", CONFIG_WRITE, "-p", CONFIG_FILE_NAME, "-u" , "MINIHTTPD_SELF",  0);
    }

    printf("in SOAP_DoConfigUpgrade before  MSG_ReceiveMessage...\n");

    /* ȴϢȡ״̬*/
    iRet = MSG_ReceiveMessage(&pstMsg, 10);

    if (iRet  == TBS_SUCCESS)
    {
        ulResult = *(unsigned long *)pstMsg->szMsgBody;
        status =(int)ulResult;
		
		if (status != TBS_SUCCESS)
			status = 900;
		
        safe_free_msg(pstMsg);
    }
    else
    {
        /* ȴϢʧܣʾϢҳ*/
        printf("receive  message  error  ...\n");
        status =1;
    }

    return status;

}

int soap_RestoreDeviceConfigFile()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char szConfigFile[64] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};
	char szFile[MAX_SOAP_LEN] = {0};	
	int totalLength = 0;
	long nSize=0;
	FILE *pFile = NULL;
	
	unlink(CONFIG_FILE_NAME);
    if ((pFile = fopen(CONFIG_FILE_NAME, "wb")) == NULL)
    {
    	printf("filename: %s\n", CONFIG_FILE_NAME);
        return 1;
    }
	
    totalLength = 0;
    while (1)
    {
	   //http(soap)
		ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
		if (ret != 0)
		{
		    printf("[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
		    break;
		}	

		ret = soap_get_node_val(szSoapContent, "NewConfigFile", szConfigFile, sizeof(szConfigFile));
		if (ret != 0)
		{
		    printf("[%s:%d]call soap_get_node_val get NewConfigFile fail\n", __FUNCTION__, __LINE__);
		    break;
		}	
		
		ret = soap_get_node_val(szSoapContent, "File", szFile, sizeof(szFile)); 
		if (ret != 0)
		{
		    printf("[%s:%d]call soap_get_node_val fail\n", __FUNCTION__, __LINE__);
		    break;
		}	
		
        /* дڴļ */
        nSize = strlen(szFile);
        fwrite(szFile, sizeof(char), nSize, pFile);
        totalLength += nSize;
    }

	fclose(pFile);
	
	ret = SOAP_CheckConfigFile();

	if (ret  == TBS_SUCCESS)
    {
        printf("upload config file ok!\n");                
        ret = SOAP_DoConfigUpgrade();
    }
	 
	
	return ret;
}

int soap_RestoreDeviceConfigFileResponse(int ret)
{
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	
	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:RestoreDeviceConfigFileResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	        "   </m:RestoreDeviceConfigFileResponse>\r\n" \
	        "   <ResponseCode>%d</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n", ret);		

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
	return 0;	
}




/*device info*/
int soap_IsExtender()
{
	return 0;
}

/*********************************************************
:soap_IsExtenderResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_IsExtenderResponse()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char IsExtender[16] = {0};
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	

	//ͻȡϢ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_DEV_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);

	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return 1;//receive message fail
	}

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "IsExtender",IsExtender);	

	if(ret == 0){
		 snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:IsExtenderResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "<IsExtender>%s</IsExtender>\r\n" \
		        "   </m:IsExtenderResponse>\r\n" \
		        "   <ResponseCode>0</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n",IsExtender);	
	}else{
		 snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:IsExtenderResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "   </m:IsExtenderResponse>\r\n" \
		        "   <ResponseCode>1</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n");	
	}

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}
	return 0;		
}

int soap_GetSysUpTime()
{
	return 0;
}

/*********************************************************
:soap_GetSysUpTimeResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_GetSysUpTimeResponse()
{
	FILE *fp = NULL;
	int i = 0,len = 0,dd=0,hh=0,mm=0,ss=0;
	char *p = NULL,*p1 = NULL;
	char timeLine[64] = {0};
	int uptime;
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	
	fp = fopen("/proc/uptime","r");
	if(fp != NULL){
		fgets(timeLine, 63, fp);
/*һ24*60*60=86400s
һСʱ60*60=3600s
һ60s*/
#if 0
		p1 = timeLine;
		p = strchr(p1,'.');
		len = p - p1;
		for(i = 0; i < len; i++){
			uptime = uptime + atoi(timeLine[i])*(len - i -1)*10;
		}
#endif
		uptime = atoi(timeLine);
		/**/
		dd =  uptime/86400;
		if(dd < 1)
			dd = 0;
		hh = (uptime - dd*86400)/3600;
		if(hh < 0)
			hh = 0;
		mm = (uptime - dd*86400 - hh*3600)/60;
		if(mm < 0)
			mm = 0;
		ss = uptime -dd*86400 - hh*3600 - mm*60;
		 snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:GetSysUpTimeResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "<SysUpTime>%d:%d:%d:%d</SysUpTime>\r\n" \
		        "   </m:GetSysUpTimeResponse>\r\n" \
		        "   <ResponseCode>0</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n",dd,hh,mm,ss);	
	}else{
		 snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:GetSysUpTimeResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "   </m:GetSysUpTimeResponse>\r\n" \
		        "   <ResponseCode>1</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n");			
	}

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
	return 0;
}

int soap_GetSysLog()
{
	return 0;
}

int soap_GetSysLogResponse()
{
	return 0;
}
/*LANConfigSecurity*/
int soap_SetConfigPassword()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char szEnableValue[8] = {0};
	char Password[32] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};
	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_SetConfigPassword fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}	

	SOAP_GET_NODE_VALUE("NewPassword",Password);	
	    //֤Ϣ
	ret = COMM_MakeAndSendCustomMsg(MSG_AUTH, 
	        MID_MINIHTTPD_SELF, MID_AUTH, 2,
	        "password", Base64_Encode(Password, strlen(Password)),
	        "action", "soap_setpassword");

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return -1;//receive message fail
	}
	
	memset(szEnableValue, 0, sizeof(szEnableValue));
	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szEnableValue);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);

	  //ϢҪͷŵ
	    if (pRsp)
	    {
	        MSG_ReleaseMessage(pRsp);
	        pRsp = NULL;
	    }
	return 0;
}

/*********************************************************
:soap_SetConfigPasswordResponse
:Ϣ
:
:
ֵ: 0
*********************************************************/
int soap_SetConfigPasswordResponse()
{
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	
	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:SetConfigPasswordResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	        "   </m:SetConfigPasswordResponse>\r\n" \
	        "   <ResponseCode>0</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n");		

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
	return 0;	
}

/*WALNConfiguration*/
int soap_Is5GSupported()
{
	return 0;
}

/*********************************************************
:soap_SetRadioEnable
:soapϢ
:
:
ֵ: 0
*********************************************************/
int soap_Is5GSupportedResponse()
{
#if 0
	int ret = 0,support = 0;
	ST_MSG* pRsp = NULL;
	char Frequency[32] = {0};
#endif
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	

#if 0
	//ͻȡϢ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);
	
	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);

	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return 1;//receive message fail
	}

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Frequency",Frequency);

	if(strstr(Frequency,"5"))
		support = 1;
#endif
	/*AC1200֧5G, ˴ֱд֧5G*/
	int support = 1;  

	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:Is5GSupportedResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	        "<5GSupported>%d</5GSupported>\r\n" \
	        "   </m:Is5GSupportedResponse>\r\n" \
	        "   <ResponseCode>0</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n",support);		

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
#if 0

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	
#endif

	return 0;		
}

/*********************************************************
:soap_SetRadioEnable
:ߵĵƵ
:
:
ֵ: 0
*********************************************************/
int soap_SetRadioEnable()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char szEnableValue[8] = {0};
	char NewEnable[32] = {0};
	char NewRadio[32] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};

	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_SetRadioEnableResponse fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}	

	SOAP_GET_NODE_VALUE("NewEnable",NewEnable);
	SOAP_GET_NODE_VALUE("NewRadio",NewRadio);

	syslog(LOG_ERR, "[%s:%d]NewEnable=%s,NewRadio=%s\n", __FUNCTION__, __LINE__,NewEnable, NewRadio);
	    //Ϣ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_RADIO_ENABLE_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 2,
	        "NewEnable", NewEnable,
	        "NewRadio", NewRadio);
	//ȴӦ,ʱʱΪ10
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	ret = MSG_ReceiveMessage(&pRsp, 10);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return -1;//receive message fail
	}

	memset(szEnableValue, 0, sizeof(szEnableValue));
	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szEnableValue);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);
	
	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	
	return 0;
}

/*********************************************************
:soap_SetRadioEnableResponse
:soapϢ
:
:
ֵ: 0
*********************************************************/
int soap_SetRadioEnableResponse()
{
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	
	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:SetRadioEnableResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	        "   </m:SetRadioEnableResponse>\r\n" \
	        "   <ResponseCode>0</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n");		

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
	return 0;	
}

/*
ֵ
0: Success
1: Unknown Error
10: Invalid argument
*/
int soap_SetExtenderMode()
{

	int ret = 0;
	ST_MSG* pRsp = NULL;
	char szResult[8] = {0};
	char NewExtenderMode[32] = {0};
	char New2GRadioMode[16] = {0};
	char New5GRadioMode[16] = {0};
	char NewBondEthernet[16] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};

	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_SetRadioEnableResponse fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}	


	SOAP_GET_NODE_VALUE("NewExtenderMode",NewExtenderMode);
	SOAP_GET_NODE_VALUE("New2GRadioMode",New2GRadioMode);
	SOAP_GET_NODE_VALUE("New5GRadioMode",New5GRadioMode);
	SOAP_GET_NODE_VALUE("NewBondEthernet",NewBondEthernet);

	syslog(LOG_ERR, "[%s:%d]NewExtenderMode=%s,New2GRadioMode=%s,New5GRadioMode=%s,NewBondEthernet=%s\n", 
			__FUNCTION__, __LINE__, NewExtenderMode, New2GRadioMode, New5GRadioMode, NewBondEthernet);

	if (safe_strcmp(NewExtenderMode, "Internet Surfing") == 0 || safe_strcmp(NewExtenderMode, "FastLane") == 0)
	{
	
		//Ϣ
		ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_EXTENDER_MODE, 
		        MID_MINIHTTPD_SELF, MID_PARENTCTL, 4,
		        "NewExtenderMode", NewExtenderMode,
		        "New2GRadioMode", New2GRadioMode,
		        "New5GRadioMode", New5GRadioMode,
		        "NewBondEthernet", NewBondEthernet);
	
	}
	else
	{
		return 10; //10: Invalid argument
	}
	//ȴӦ,ʱʱΪ15
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	ret = MSG_ReceiveMessage(&pRsp, 15);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return 1;//receive message fail
	}

	memset(szResult, 0, sizeof(szResult));
	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szResult);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szResult);


	if (safe_strcmp(szResult, "0") != 0) 
	{
		return 10;

	}
	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	


	return 0;
}



void soap_sendSpecErr(int err)
{
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,
	        "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
            "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
            "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            "<SOAP-ENV:Body>\r\n" \
            "<ResponseCode>%d</ResponseCode>\r\n" \
            "</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", err);
			
    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader, 
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));
        
    soap_response(bufErrResponseHeader, bufErrSOAPResponse);
}


int soap_SetExtenderModeResponse()
{
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	
	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:SetExtenderModeResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
	        "   </m:SetExtenderModeResponse>\r\n" \
	        "   <ResponseCode>0</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n");		

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
	return 0;	
}


int soap_GetExtenderMode()
{
	return 0;
}

int soap_GetExtenderModeResponse()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char sz2GRadioMode[16] = {0};
	char sz5GRadioMode[16] = {0};
	char szBondEthernet[16] = {0};
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	
	    //Ϣ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_EXTENDER_MODE, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);

	ret = MSG_ReceiveMessage(&pRsp, 8);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return 1;//receive message fail
	}

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "New2GRadioMode New5GRadioMode NewBondEthernet",
									sz2GRadioMode, 
									sz5GRadioMode, 
									szBondEthernet);
	
	
	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:GetExtenderModeResponse\r\n" \
	        "   	xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
	        "		<New2GRadioMode>%s</New2GRadioMode>\r\n" \
	        "		<New5GRadioMode>%s</New5GRadioMode>\r\n" \
	        "		<NewBondEthernet>%s</NewBondEthernet>\r\n" \
	        "   </m:GetExtenderModeResponse>\r\n" \
	        "   <ResponseCode>0</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n",sz2GRadioMode,sz5GRadioMode,szBondEthernet);	
			
	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	

	return 0;
}


/*********************************************************
:soap_SetWirelessRegion
:ߵ
:
:
ֵ: 0
*********************************************************/
int soap_SetWirelessRegion()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char szEnableValue[8] = {0};
	char region[32] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};

	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_SetRadioEnableResponse fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}	

	SOAP_GET_NODE_VALUE("NewWirelessRegion",region);

	    //Ϣ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_REGION_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 1,
	        "NewWirelessRegion", region);
	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return -1;//receive message fail
	}	

	memset(szEnableValue, 0, sizeof(szEnableValue));
	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szEnableValue);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);
	
	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	
	
	return 0;
}

/*********************************************************
:soap_SetWirelessRegionResponse
:soapϢ
:
:
ֵ: 0
*********************************************************/
int soap_SetWirelessRegionResponse()
{
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	
	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:SetWirelessRegionResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	        "   </m:SetWirelessRegionResponse>\r\n" \
	        "   <ResponseCode>0</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n");		

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
	return 0;		
}

int soap_GetWirelessRegion()
{
	return 0;
}

/*********************************************************
:soap_GetWirelessRegionResponse
:soapϢ
:
:
ֵ: 0
*********************************************************/
int soap_GetWirelessRegionResponse()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char region[32] = {0};
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	    //Ϣ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_DEV_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);

	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return 1;//receive message fail
	}

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Region",region);

	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:GetWirelessRegionResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	        "<WirelessRegion>%s</WirelessRegion>\r\n" \
	        "   </m:GetWirelessRegionResponse>\r\n" \
	        "   <ResponseCode>0</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n",region);	
			
	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	

	return 0;
}

int soap_GetWirelessRegionList()
{
	return 0;
}

int soap_GetWirelessRegionListResponse()
{
	return 0;
}

int soap_GetWirelessMode()
{
	return 0;
}

/*********************************************************
:soap_GetWirelessModeResponse
:soapϢ
:
:
ֵ: 0
*********************************************************/
int soap_GetWirelessModeResponse()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char NewRadio[32] = {0};
	char WirelessMode[32] = {0};
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	char szSoapContent[MAX_SOAP_LEN] = {0};
	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_GetWirelessModeResponse fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}	
	

	SOAP_GET_NODE_VALUE("NewRadio",NewRadio);

	if((memcmp(NewRadio, "2.4G",strlen("2.4G")) != 0) && (memcmp(NewRadio, "5G",strlen("5G")) != 0)){
		snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:GetWirelessRegionResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "   </m:GetWirelessRegionResponse>\r\n" \
		        "   <ResponseCode>900</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n");	
				
		//httpͷ
		soap_generate_httpheader(bufErrResponseHeader,
		    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

		soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
		return 0;
	}

	    //Ϣ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 1, "NewRadio", NewRadio);

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	
	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return 1;//receive message fail
	}

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "WirelessMode",WirelessMode);

	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:GetWirelessRegionResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	        "<WirelessMode>%s</WirelessMode>\r\n" \
	        "   </m:GetWirelessRegionResponse>\r\n" \
	        "   <ResponseCode>0</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n",WirelessMode);	
			
	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	

	return 0;	
}

int soap_GetAvailableChannel()
{
	return 0;
}

/*********************************************************
:soap_GetAvailableChannelResponse
:soapϢ
:
:
ֵ: 0
*********************************************************/
int soap_GetAvailableChannelResponse()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char NewRadio[32] = {0};
	char NewWirelessMode[32] = {0};
	char AvailableChannel[32] = {0};
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	char szSoapContent[MAX_SOAP_LEN] = {0};

	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_GetAvailableChannelResponse fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}	

	SOAP_GET_NODE_VALUE("NewRadio",NewRadio);
	SOAP_GET_NODE_VALUE("NewWirelessMode",NewWirelessMode);

	if((memcmp(NewRadio, "2.4G",strlen("2.4G")) != 0) && (memcmp(NewRadio, "5G",strlen("5G")) != 0)){
		snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:GetWirelessRegionResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "   </m:GetWirelessRegionResponse>\r\n" \
		        "   <ResponseCode>900</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n");	
				
		//httpͷ
		soap_generate_httpheader(bufErrResponseHeader,
		    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

		soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
		return 0;
	}

	    //Ϣ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 1, "NewRadio", NewRadio);

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);

	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return 1;//receive message fail
	}

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Channel",AvailableChannel);

	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:GetWirelessRegionResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
	        "<AvailableChannel>%s</AvailableChannel>\r\n" \
	        "   </m:GetWirelessRegionResponse>\r\n" \
	        "   <ResponseCode>0</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n",AvailableChannel);	
			
	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	

	return 0;
}

int soap_GetAPInfo()
{
	return 0;
}

int soap_GetAPInfoResponse()
{
	int ret = 0;
    ST_MSG* pRsp = NULL;
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};
	char NewRadio[32] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};
	char szAPlist[2048] = {0};
	
    syslog(LOG_INFO, "[%s:%d]into soap_GetAPInfoResponse\n", __FUNCTION__, __LINE__);

	SOAP_GET_NODE_VALUE("NewRadio",NewRadio);

	if((memcmp(NewRadio, "2.4G",strlen("2.4G")) != 0) && (memcmp(NewRadio, "5G",strlen("5G")) != 0)){
		snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:GetAPInfoResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
		        "   </m:GetAPInfoResponse>\r\n" \
		        "   <ResponseCode>900</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n");	
				
		//httpͷ
		soap_generate_httpheader(bufErrResponseHeader,
		    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

		soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
		return 0;
	}

	    //Ϣ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_APINFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 1, "NewRadio", NewRadio);

	//ȴӦ,ʱʱΪ15
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);

	ret = MSG_ReceiveMessage(&pRsp, 15);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return 1;//receive message fail
	}
	
	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "APList",szAPlist);
	
	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
			"<SOAP-ENV:Envelope\r\n" \
			"	xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
			"	SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
			"<SOAP-ENV:Body>\r\n" \
			"	<m:GetAPInfoResponse\r\n" \
			"		xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
			"		<APList>%s</APList>\r\n" \
			"	</m:GetAPInfoResponse>\r\n" \
			"	<ResponseCode>0</ResponseCode>\r\n" \
			"</SOAP-ENV:Body>\r\n" \
			"</SOAP-ENV:Envelope>\r\n",szAPlist);	
		
	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
		MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));
	
	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
	
	//ϢҪͷŵ
	if (pRsp)
	{
		MSG_ReleaseMessage(pRsp);
		pRsp = NULL;
	}	

	return 0;
}

int soap_SetWLANWEPByKeys()
{
    int ret = 0;
    char szChannel[8] = {0};
    char szSSID[64] = {0};
    char szWirelessMode[16] = {0};
    char szNewWEPAuthType[32] = {0};
	char szRadio[8] = {0};
	char szNewWEPLength[8] = {0};
	char szNewKeyIndex[8] = {0};
	char szNewKey1[32] = {0};
	char szNewKey2[32] = {0};
	char szNewKey3[32] = {0};
	char szNewKey4[32] = {0};
	char szResult[8] = {0};
    char szSoapContent[MAX_SOAP_LEN] = {0};
    ST_MSG* pRsp = NULL;

    //http(soap)
    ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call soap_get_soap_content fail\n", __FUNCTION__, __LINE__);
        return -1;//error
    }

    //get parameters
    SOAP_GET_NODE_VALUE("NewRadio", szRadio);
	SOAP_GET_NODE_VALUE("NewSSID", szSSID);
    SOAP_GET_NODE_VALUE("NewChannel", szChannel);
    SOAP_GET_NODE_VALUE("NewWirelessMode", szWirelessMode);
    SOAP_GET_NODE_VALUE("NewWEPAuthType", szNewWEPAuthType);
    SOAP_GET_NODE_VALUE("NewWEPLength", szNewWEPLength);
	SOAP_GET_NODE_VALUE("NewKeyIndex", szNewKeyIndex);
    SOAP_GET_NODE_VALUE("NewKey1", szNewKey1);
	SOAP_GET_NODE_VALUE("NewKey2", szNewKey2);
	SOAP_GET_NODE_VALUE("NewKey3", szNewKey3);
	SOAP_GET_NODE_VALUE("NewKey4", szNewKey4);

	
    syslog(LOG_INFO, "[%s:%d][%s] [%s] [%s] [%s] [%s] [%s] [%s] [%s] [%s] [%s] [%s]\n", __FUNCTION__, __LINE__, 
       szRadio, szSSID, szChannel, szWirelessMode, szNewWEPAuthType, szNewWEPLength, szNewKeyIndex, szNewKey1, szNewKey2, szNewKey3, szNewKey4);

	
    ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_WLAN_WEP_BY_KEY_SECURITY, 
            MID_MINIHTTPD_SELF, MID_PARENTCTL, 11,
            "Radio", szRadio,
            "SSID", szSSID,
            "Channel", szChannel,
            "WirelessMode", szWirelessMode,
            "WEPAuthType", szNewWEPAuthType,
            "WEPLength", szNewWEPLength,
            "NewKeyIndex", szNewKeyIndex,
            "NewKey1", szNewKey1,
            "NewKey2", szNewKey2,
            "NewKey3", szNewKey3,
            "NewKey4", szNewKey4);

	
    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]call COMM_MakeAndSendCustomMsg fail\n", __FUNCTION__, __LINE__);
        return -1;
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }

    //ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szResult);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szResult);
    
    return 0;
}




int soap_SetWLANWEPByKeysResponse()
{
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	
	snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        "<SOAP-ENV:Body>\r\n" \
	        "   <m:SetWLANWEPByKeysResponse\r\n" \
	        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
	        "   </m:SetWLANWEPByKeysResponse>\r\n" \
	        "   <ResponseCode>0</ResponseCode>\r\n" \
	        "</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n");		

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
	return 0;		
}


int soap_SetWLANWEPByPassphrase()
{
	return 0;
}

int soap_SetWLANWEPByPassphraseResponse()
{
	return 0;
}

int soap_GetWLANInfo()
{
	return 0;
}

/*********************************************************
:soap_GetWLANInfoResponse
:soapϢ
:
:
ֵ: 0
*********************************************************/
int soap_GetWLANInfoResponse(void)
{
    int ret = 0;
    ST_MSG* pRsp = NULL;
    char szEnable[4] = {0};
    char szBroadcast[4] = {0};
    char szStatus[16] = {0};
    char szSSID[64] = {0};
    char szRegion[32] = {0};
    char szChannel[4] = {0};
    char szWirelessMode[16] = {0};
    char szEncryMode[32] = {0};
    char szAuthType[32] = {0};
    char szWPAEncryModes[32] = {0};
    char szMacAddr[16] = {0};
    char szBasicEncryMode[32] = {0};
    char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
    char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};
	char NewRadio[32] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};
	
    syslog(LOG_INFO, "[%s:%d]into soap_GetWLANInfoResponse\n", __FUNCTION__, __LINE__);



	SOAP_GET_NODE_VALUE("NewRadio",NewRadio);

	if((memcmp(NewRadio, "2.4G",strlen("2.4G")) != 0) && (memcmp(NewRadio, "5G",strlen("5G")) != 0)){
		snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:GetWirelessRegionResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "   </m:GetWirelessRegionResponse>\r\n" \
		        "   <ResponseCode>900</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n");	
				
		//httpͷ
		soap_generate_httpheader(bufErrResponseHeader,
		    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

		soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
		return 0;
	}

	    //Ϣ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 1, "NewRadio", NewRadio);
	
    if (ret != 0)
    {
        return -1;//send massage fail
    }

    //ȴӦ,ʱʱΪ5
    syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
    ret = MSG_ReceiveMessage(&pRsp, 5);
    if (ret != MSG_OK) 
    {
        syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
        return -1;//receive message fail
    }
			
	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Enable Broadcast Satus SSID Region Channel " \
	                       "WirelessMode BasicEncryMode AuthType WPAEncryModes MacAddr" , 
	                       szEnable, szBroadcast, szStatus, szSSID, szRegion,
	                       szChannel, szWirelessMode,szBasicEncryMode,szAuthType,
	                       szWPAEncryModes, szMacAddr);

    //ϢҪͷŵ
    if (pRsp)
    {
        MSG_ReleaseMessage(pRsp);
        pRsp = NULL;
    }

    if (ret != 0)
    {
        syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
    }

    syslog(LOG_INFO, "will send response\n", __FUNCTION__, __LINE__);

	tbsStringReplace(szSSID,"<","&lt;");
	tbsStringReplace(szSSID,">","&gt;");

    //http
    snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
            "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
            "<SOAP-ENV:Envelope\r\n" \
               "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
               "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
            	"<SOAP-ENV:Body>\r\n" \
            		"<m:GetWLANInfoResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
    				"<NewEnable>%s</NewEnable>\r\n" \
    				"<NewSSIDBroadcast>%s</NewSSIDBroadcast>\r\n"\
    				"<NewStatus>%s</NewStatus>\r\n" \
    				"<NewSSID>%s</NewSSID>\r\n" \
    				"<NewRegion>%s</NewRegion>\r\n"\
    				"<NewChannel>%s</NewChannel>\r\n" \
    				"<NewWirelessMode>%s</NewWirelessMode>\r\n" \
    				"<NewBasicEncryptionModes>%s</NewBasicEncryptionModes>\r\n"\
    				"<NewWEPAuthType>%s</NewWEPAuthType>\r\n"\
    				"<NewWPAEncryptionModes>%s</NewWPAEncryptionModes>\r\n" \
    				"<NewWLANMACAddress>%s</NewWLANMACAddress>\r\n" \
            		"</m:GetWLANInfoResponse>\r\n" \
            		"<ResponseCode>0</ResponseCode>\r\n" \
            	"</SOAP-ENV:Body>\r\n" \
            "</SOAP-ENV:Envelope>\r\n", szEnable, szBroadcast, szStatus,\
             szSSID, szRegion, szChannel, szWirelessMode, szBasicEncryMode, szAuthType,\
            szWPAEncryModes, szMacAddr);

    //httpͷ
    soap_generate_httpheader(bufErrResponseHeader,
        MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

    soap_response(bufErrResponseHeader, bufErrSOAPResponse);

    return 0;
}

int soap_GetWLANWPSEnable()
{
	return 0;
}

/*********************************************************
:soap_GetWLANWPSEnableResponse
:soapϢ
:
:
ֵ: 0
*********************************************************/
int soap_GetWLANWPSEnableResponse()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char NewEnable[32] = {0};
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};

	syslog(LOG_INFO, "[%s:%d]into soap_GetWLANWPSEnableResponse\n", __FUNCTION__, __LINE__);

	//ͻȡϢ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_WPS_INFO, 
	    MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);
	if (ret != 0)
	{
		return -1;//send massage fail
	}
	
	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return -1;//receive message fail
	}

	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "NewEnable" , NewEnable);

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}

	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
	}

	syslog(LOG_INFO, "will send response\n", __FUNCTION__, __LINE__);

	//http
	snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
	        "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	           "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	           "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        	"<SOAP-ENV:Body>\r\n" \
	        		"<m:GetWLANWPSEnableResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
				"<NewEnable>%s</NewEnable>\r\n" \
	        		"</m:GetWLANWPSEnableResponse>\r\n" \
	        		"<ResponseCode>0</ResponseCode>\r\n" \
	        	"</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n", NewEnable);

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

	return 0;
}

/*********************************************************
:soap_SetWLANWPSEnable
:wpsϢ
:
:
ֵ: 0
*********************************************************/
int soap_SetWLANWPSEnable()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char szEnableValue[8] = {0};
	char NewEnable[32] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};

	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_SetWLANWPSEnable fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}

	SOAP_GET_NODE_VALUE("NewEnable",NewEnable);
	
	    //Ϣ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_WPS_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 1,
	        "NewEnable", NewEnable);
	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d NewEnable: %s]wait for response message\n", __FUNCTION__, __LINE__,NewEnable);

	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return -1;//receive message fail
	}	

	memset(szEnableValue, 0, sizeof(szEnableValue));
	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szEnableValue);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);
	
	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	

	return 0;
}

/*********************************************************
:soap_SetWLANWPSEnableResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_SetWLANWPSEnableResponse()
{
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	

	//http
	snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
	        "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	           "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	           "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        	"<SOAP-ENV:Body>\r\n" \
	        		"<m:SetWLANWPSEnableResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
	        		"</m:SetWLANWPSEnableResponse>\r\n" \
	        		"<ResponseCode>0</ResponseCode>\r\n" \
	        	"</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n");

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

	return 0;	
}

int soap_GetWLANWEPInfo()
{
	return 0;
}

/*********************************************************
:soap_GetWLANWEPInfoResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_GetWLANWEPInfoResponse()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char NewEnable[32] = {0};
	char NewWEPLength[32] = {0};
	char NewWEPPassphrase[32] = {0};
	char NewKeyIndex[32] = {0};
	char NewKey1[32] = {0};
	char NewKey2[32] = {0};
	char NewKey3[32] = {0};
	char NewKey4[32] = {0};
	char NewWEPAuthType[32] = {0};
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};
	char NewRadio[32] = {0};
	
	syslog(LOG_INFO, "[%s:%d]into soap_GetWLANWEPInfoResponse\n", __FUNCTION__, __LINE__);

	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_GetWLANWEPInfoResponse fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}

	SOAP_GET_NODE_VALUE("NewRadio",NewRadio);

	if((memcmp(NewRadio, "2.4G",strlen("2.4G")) != 0) && (memcmp(NewRadio, "5G",strlen("5G")) != 0)){
		snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:GetWLANWEPInfoResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "   </m:GetWLANWEPInfoResponse>\r\n" \
		        "   <ResponseCode>900</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n");	
				
		//httpͷ
		soap_generate_httpheader(bufErrResponseHeader,
		    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

		soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
		return 0;
	}
	
	//ͻȡϢ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_WEP_INFO, 
	    MID_MINIHTTPD_SELF, MID_PARENTCTL, 1, "NewRadio", NewRadio);
	if (ret != 0)
	{
		return -1;//send massage fail
	}
	
	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return -1;//receive message fail
	}
	
	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "NewWEPLength NewWEPPassphrase NewKeyIndex NewKey1 NewKey2 NewKey3 NewKey4 NewWEPAuthType", 
	         NewWEPLength, NewWEPPassphrase, NewKeyIndex, NewKey1, NewKey2, NewKey3, NewKey4, NewWEPAuthType);

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}

	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
	}

	//http
	snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
	        "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	           "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	           "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        	"<SOAP-ENV:Body>\r\n" \
	        		"<m:GetWLANWEPInfoResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
	        		"<NewWEPLength>%s</NewWEPLength>\r\n" \
	        		"<NewWEPPassphrase>%s</NewWEPPassphrase>\r\n" \
	        		"<NewKeyIndex>%s</NewKeyIndex>\r\n" \
	        		"<NewKey1>%s</NewKey1>\r\n" \
	        		"<NewKey2>%s</NewKey2>\r\n" \
	        		"<NewKey3>%s</NewKey3>\r\n" \
	        		"<NewKey4>%s</NewKey4>\r\n" \
	        		"<NewWEPAuthType>%s</NewWEPAuthType>\r\n" \
	        		"</m:GetWLANWEPInfoResponse>\r\n" \
	        		"<ResponseCode>0</ResponseCode>\r\n" \
	        	"</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n",NewWEPLength, NewWEPPassphrase, NewKeyIndex, NewKey1, NewKey2, NewKey3, NewKey4, NewWEPAuthType);

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

	return 0;
}

int soap_GetWLANWPAInfo()
{
	return 0;
}

/*********************************************************
:soap_GetWLANWPAInfoResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_GetWLANWPAInfoResponse()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};
	char NewRadio[32] = {0};
	char NewWPAPassphrase[32] ={0};

	syslog(LOG_INFO, "[%s:%d]into soap_GetWLANWPAInfoResponse\n", __FUNCTION__, __LINE__);
	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_GetWLANWPAInfoResponse fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}

	SOAP_GET_NODE_VALUE("NewRadio",NewRadio);

	if((memcmp(NewRadio, "2.4G",strlen("2.4G")) != 0) && (memcmp(NewRadio, "5G",strlen("5G")) != 0)){
		snprintf(bufErrSOAPResponse, MAX_SOAP_HTTP_CONTENT,"<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		        "   xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		        "   SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        "<SOAP-ENV:Body>\r\n" \
		        "   <m:GetWLANWEPInfoResponse\r\n" \
		        "      xmlns:m=\"urn:NETGEAR-ROUTER:service:DeviceConfig:1\">\r\n" \
		        "   </m:GetWLANWEPInfoResponse>\r\n" \
		        "   <ResponseCode>900</ResponseCode>\r\n" \
		        "</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n");	
				
		//httpͷ
		soap_generate_httpheader(bufErrResponseHeader,
		    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

		soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
		return 0;
	}	

	//ͻȡϢ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_WPA_INFO, 
	    MID_MINIHTTPD_SELF, MID_PARENTCTL, 1, "NewRadio", NewRadio);
	if (ret != 0)
	{
		return -1;//send massage fail
	}
	
	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return -1;//receive message fail
	}
	
	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "NewWPAPassphrase", NewWPAPassphrase);

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	

	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
	}

	//http
	snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
	        "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	           "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	           "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        	"<SOAP-ENV:Body>\r\n" \
	        		"<m:GetWLANWEPInfoResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
	        		"<NewWPAPassphrase>%s</NewWPAPassphrase>\r\n" \
	        		"</m:GetWLANWEPInfoResponse>\r\n" \
	        		"<ResponseCode>0</ResponseCode>\r\n" \
	        	"</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n",NewWPAPassphrase);

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	

	return 0;	
}


int soap_UpdateNewFirmwareFromURL()
{
	return 0;
}

/*********************************************************
:soap_UpdateNewFirmwareFromURLResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_UpdateNewFirmwareFromURLResponse()
{
	int ret = 0;
	char ipaddr[32] = {0};
	char upname[32] = {0};
	char cmdtftp[256] = {0};
	char cmdupgrade[256] = {0};
	char *p = NULL, *p1= NULL, *p2= NULL;
	ST_MSG* pRsp = NULL;
	char NewFirwmareURL[256] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	

	syslog(LOG_INFO, "[%s:%d]into soap_UpdateNewFirmwareFromURLResponse\n", __FUNCTION__, __LINE__);
	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_UpdateNewFirmwareFromURLResponse fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}

	SOAP_GET_NODE_VALUE("NewFirwmareURL",NewFirwmareURL);

	if((p = strstr(NewFirwmareURL,"http://"))!= NULL){
		p1=strstr(p+7, "/");
		strncpy(ipaddr,p+7,p1-(p+7));
		p2 = strstr(p1+1, "/");
		strcpy(upname,p2+1);
	}else if((p = strstr(NewFirwmareURL,"https://")) != NULL){
		p=strstr(NewFirwmareURL, "@");
		p1=strstr(p,"/");
		strncpy(ipaddr,p+1,p1-(p+1));
		p2=strstr(p1+1,"/");
		strcpy(upname,p2+1);	
	}else{
		snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
		        "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
		        "<SOAP-ENV:Envelope\r\n" \
		           "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
		           "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
		        	"<SOAP-ENV:Body>\r\n" \
		        		"<m:UpdateNewFirmwareFromURLResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
		        		"</m:UpdateNewFirmwareFromURLResponse>\r\n" \
		        		"<ResponseCode>1</ResponseCode>\r\n" \
		        	"</SOAP-ENV:Body>\r\n" \
		        "</SOAP-ENV:Envelope>\r\n");

		//httpͷ
		soap_generate_httpheader(bufErrResponseHeader,
		    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

		soap_response(bufErrResponseHeader, bufErrSOAPResponse);			
		return 0;
	}

	sprintf(cmdtftp,"tftp -g -r %s -l /var/image.img %s  69",upname,ipaddr);
	tbsSystemMute(cmdtftp);

	//http壬ȻӦ
	snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
	        "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	           "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	           "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        	"<SOAP-ENV:Body>\r\n" \
	        		"<m:UpdateNewFirmwareFromURLResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
	        		"<RebootTime>%d</RebootTime>\r\n" \
	        		"</m:UpdateNewFirmwareFromURLResponse>\r\n" \
	        		"<ResponseCode>0</ResponseCode>\r\n" \
	        	"</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n",180);

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);		
#define IMG_WRITE 1
	sprintf(cmdupgrade,"upgrader -c %d -p /var/image.img -u TFTPUPG",IMG_WRITE);
	tbsSystemMute(cmdupgrade);
	return 0;
}

int soap_GetDHCPServerEnable()
{	
	return 0;
}

/*********************************************************
:soap_GetDHCPServerEnableResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_GetDHCPServerEnableResponse()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char NewDHCPServer[32] = {0};
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	
	//ͻȡϢ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_GET_DHCPS_INFO, 
	    MID_MINIHTTPD_SELF, MID_PARENTCTL, 0);
	if (ret != 0)
	{
		return -1;//send massage fail
	}

	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return -1;//receive message fail
	}
	
	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "NewDHCPServer", NewDHCPServer);

	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}	

	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]resove response message fail\n", __FUNCTION__, __LINE__);
		return -1;//auth fail
	}

	//http
	snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
	        "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	           "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	           "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        	"<SOAP-ENV:Body>\r\n" \
	        		"<m:GetDHCPServerEnableResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
	        		"<NewDHCPServer>%s</NewDHCPServer>\r\n" \
	        		"</m:GetDHCPServerEnableResponse>\r\n" \
	        		"<ResponseCode>0</ResponseCode>\r\n" \
	        	"</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n",NewDHCPServer);

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);		
	return 0;
}

/*********************************************************
:soap_SetDHCPServerEnable
:ÿرdhcp server
:
:
ֵ: 0
*********************************************************/
int soap_SetDHCPServerEnable()
{
	int ret = 0;
	ST_MSG* pRsp = NULL;
	char szEnableValue[8] = {0};
	char NewDHCPServer[32] = {0};
	char szSoapContent[MAX_SOAP_LEN] = {0};
	
	syslog(LOG_INFO, "[%s:%d]into soap_SetDHCPServerEnable\n", __FUNCTION__, __LINE__);
	//http(soap)
	ret = soap_get_soap_content(szSoapContent, MAX_SOAP_LEN);
	if (ret != 0)
	{
	    syslog(LOG_ERR, "[%s:%d]call soap_SetDHCPServerEnable fail\n", __FUNCTION__, __LINE__);
	    return 1;//error
	}

	SOAP_GET_NODE_VALUE("NewDHCPServer",NewDHCPServer);

	    //Ϣ
	ret = COMM_MakeAndSendCustomMsg(MSG_GENIE_SET_DHCPS_INFO, 
	        MID_MINIHTTPD_SELF, MID_PARENTCTL, 1,
	        "NewDHCPServer", NewDHCPServer);
	//ȴӦ,ʱʱΪ5
	syslog(LOG_ERR, "[%s:%d]wait for response message\n", __FUNCTION__, __LINE__);
	ret = MSG_ReceiveMessage(&pRsp, 5);
	if (ret != MSG_OK) 
	{
	    syslog(LOG_ERR, "[%s:%d]call MSG_ReceiveMessage fail\n", __FUNCTION__, __LINE__);
	    return -1;//receive message fail
	}	

	memset(szEnableValue, 0, sizeof(szEnableValue));
	//ϢҪֶεֵ
	ret = COMM_ParseCustomMsg(pRsp, "Result", szEnableValue);
	syslog(LOG_ERR, "[%s:%d]result:[%s]\n", __FUNCTION__, __LINE__, szEnableValue);
	
	//ϢҪͷŵ
	if (pRsp)
	{
	    MSG_ReleaseMessage(pRsp);
	    pRsp = NULL;
	}
	
	return 0;
}

/*********************************************************
:soap_SetDHCPServerEnableResponse
:Ϣsoap
:
:
ֵ: 0
*********************************************************/
int soap_SetDHCPServerEnableResponse()
{
	char bufErrResponseHeader[MAX_SOAP_HTTP_HEADER] = {0};
	char bufErrSOAPResponse[MAX_SOAP_HTTP_CONTENT] = {0};	


	//http
	snprintf(bufErrSOAPResponse, sizeof(bufErrSOAPResponse), \
	        "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n" \
	        "<SOAP-ENV:Envelope\r\n" \
	           "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"\r\n" \
	           "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n" \
	        	"<SOAP-ENV:Body>\r\n" \
	        		"<m:SetDHCPServerEnableResponse xmlns:m=\"urn:NETGEAR-ROUTER:service:WLANConfiguration:1\">\r\n" \
	        		"</m:SetDHCPServerEnableResponse>\r\n" \
	        		"<ResponseCode>0</ResponseCode>\r\n" \
	        	"</SOAP-ENV:Body>\r\n" \
	        "</SOAP-ENV:Envelope>\r\n");

	//httpͷ
	soap_generate_httpheader(bufErrResponseHeader,
	    MAX_SOAP_HTTP_HEADER, strlen(bufErrSOAPResponse));

	soap_response(bufErrResponseHeader, bufErrSOAPResponse);	
	
	return 0;	
}
#endif

/*---------------------------------------------------------
 *Զ̵
 *Զ̵:
 *    1.EnableParentalControl
 *    2.SetDNSMasqDeviceID
 *    3.GetDNSMasqDeviceID
 *    4.GetAllMACAddresses
 *    5.DeleteMACAddress
 *    6.GetEnableStatus
 *    7.Authenticate
 *    8.ConfigurationStarted
 *    9.ConfigurationFinished
 *---------------------------------------------------------*/
int soap_parent_ctrl_handle(const char *pszMethodName)
{
    int ret = 0;
    if (!pszMethodName)
    {
        //soap_sendErr();
        return 0;
    }

    if (strcmp(pszMethodName, "EnableParentalControl") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_EnableParentalControl\n", __FUNCTION__, __LINE__);
        ret = soap_EnableParentalControl();
        soap_EnableParentalControlResponse();
    }
    else if (strcmp(pszMethodName, "SetDNSMasqDeviceID") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_SetDNSMasqDeviceID\n", __FUNCTION__, __LINE__);
        ret = soap_SetDNSMasqDeviceID();
        soap_SetDNSMasqDeviceIDResponse();
    }
    else if (strcmp(pszMethodName, "GetDNSMasqDeviceID") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_GetDNSMasqDeviceID\n", __FUNCTION__, __LINE__);
        ret = soap_GetDNSMasqDeviceID();
        soap_GetDNSMasqDeviceIDResponse();
    }
    else if (strcmp(pszMethodName, "GetAllMACAddresses") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_GetAllMACAddresses\n", __FUNCTION__, __LINE__);
        ret = soap_GetAllMACAddresses();
        soap_GetAllMACAddressesResponse();
    }
    else if (strcmp(pszMethodName, "DeleteMACAddress") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_DeleteMACAddress\n", __FUNCTION__, __LINE__);
        ret = soap_DeleteMACAddress();
        soap_DeleteMACAddressResponse();
    }
    else if (strcmp(pszMethodName, "GetEnableStatus") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_GetEnableStatus\n", __FUNCTION__, __LINE__);
        ret = soap_GetEnableStatus();
        soap_GetEnableStatusResponse();
    }
    else if (strcmp(pszMethodName, "Authenticate") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_Authenticate\n", __FUNCTION__, __LINE__);
        ret = soap_Authenticate();
        soap_AuthenticateResponse(ret);
 
    }
    else if (strcmp(pszMethodName, "ConfigurationStarted") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_ConfigurationStarted\n", __FUNCTION__, __LINE__);
        soap_ConfigurationStarted();
        soap_ConfigurationStartedResponse();
    }
    else if (strcmp(pszMethodName, "ConfigurationFinished") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_ConfigurationFinished\n", __FUNCTION__, __LINE__);
        soap_ConfigurationFinished();
        soap_ConfigurationFinishedResponse();
    }
#ifdef HTTP_SOAP_NETGEAR_GENIE
	if(0 != soap_isAuthYetCheck())
	{
        soap_sendErr();
		return 0;	
	}
    if (strcmp(pszMethodName, "GetInfo") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_GetInfo\n", __FUNCTION__, __LINE__);
        ret = soap_GetInfo();
        if (ret == 0)
            soap_GetInfoResponse();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "GetWPASecurityKeys") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_GetWPASecurityKeys\n", __FUNCTION__, __LINE__);
        ret = soap_GetWPASecurityKeys();
        if (ret == 0)
            soap_GetWPASecurityKeysResponse();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "GetWEPSecurityKeys") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_GetWPASecurityKeys\n", __FUNCTION__, __LINE__);
        ret = soap_GetWEPSecurityKeys();
        if (ret == 0)
            soap_GetWEPSecurityKeysResponse();
        else
            soap_sendErr();
    }
#if 0   /*PLWûзÿ*/
    else if (strcmp(pszMethodName, "GetGuestAccessEnabled") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call GetGuestAccessEnabled\n", __FUNCTION__, __LINE__);
        ret = soap_GetGuestAccessEnabled();
        if (ret == 0)
            soap_GetGuestAccessEnabledResponse();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "GetGuestAccessNetworkInfo") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call GetGuestAccessNetworkInfo\n", __FUNCTION__, __LINE__);
        ret = soap_GetGuestAccessNetworkInfo();
        if (ret == 0)
            soap_GetGuestAccessNetworkInfoResponse();
        else
            soap_sendErr();
    }
#endif
    else if (strcmp(pszMethodName, "GetTrafficMeterEnabled") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call GetTrafficMeterEnabled\n", __FUNCTION__, __LINE__);
        ret = soap_GetTrafficMeterEnabled();
        if (ret == 0)
            soap_GetTrafficMeterEnabledResponse();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "GetTrafficMeterOptions") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call GetTrafficMeterEnabled\n", __FUNCTION__, __LINE__);
        ret = soap_GetTrafficMeterOptions();
        if (ret == 0)
            soap_GetTrafficMeterOptionsResponse();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "GetTrafficMeterStatistics") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call GetTrafficMeterEnabled\n", __FUNCTION__, __LINE__);
        ret = soap_GetTrafficMeterStatistics();
        if (ret == 0)
            soap_GetTrafficMeterStatisticsResponse();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "GetBlockDeviceEnableStatus") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call GetBlockDeviceEnableStatus\n", __FUNCTION__, __LINE__);
        ret = soap_GetBlockDeviceEnableStatus();
        if (ret == 0)
            soap_GetBlockDeviceEnableStatusResponse();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "GetAttachDevice") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call GetAttachDevice\n", __FUNCTION__, __LINE__);
        ret = soap_GetAttachDevice();
        if (ret == 0)
            soap_GetAttachDeviceResponse();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "EnableTrafficMeter") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call GetAttachDevice\n", __FUNCTION__, __LINE__);
        ret = soap_EnableTrafficMeter();
        if (ret == 0)
            soap_EnableTrafficMeterResponse();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "SetTrafficMeterOptions") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call SetTrafficMeterOptions\n", __FUNCTION__, __LINE__);
        ret = soap_SetTrafficMeterOptions();
        if (ret == 0)
            soap_SetTrafficMeterOptionsResponse();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "SetGuestAccessEnabled") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_SetGuestAccessEnabled\n", __FUNCTION__, __LINE__);
        ret = soap_SetGuestAccessEnabled();
        if (ret == 0)
            soap_SetGuestAccessEnabledResponse();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "SetGuestAccessEnabled2") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_SetGuestAccessEnabled2\n", __FUNCTION__, __LINE__);
        ret = soap_SetGuestAccessEnabled2();
        if (ret == 0)
            soap_SetGuestAccessEnabled2Response();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "SetGuestAccessNetwork") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_SetGuestAccessNetwork\n", __FUNCTION__, __LINE__);
        ret = soap_SetGuestAccessNetwork();
        if (ret == 0)
            soap_SetGuestAccessNetworkResponse();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "SetWLANNoSecurity") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_SetWLANNoSecurity\n", __FUNCTION__, __LINE__);
        ret = soap_SetWLANNoSecurity();
        if (ret == 0)
            soap_SetWLANNoSecurityResponse();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "SetWLANWPAPSKByPassphrase") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_SetWLANWPAPSKByPassphrase\n", __FUNCTION__, __LINE__);
        ret = soap_SetWLANWPAPSKByPassphrase();
        if (ret == 0)
            soap_SetWLANWPAPSKByPassphraseResponse();
        else
            soap_sendErr();
    }
    else if (strcmp(pszMethodName, "Reboot") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_Reboot\n", __FUNCTION__, __LINE__);
        ret = soap_Reboot();
        if (ret == 0)
            soap_RebootResponse();
    }
    else if (strcmp(pszMethodName, "GetInfo_DeviceInfo") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_Reboot\n", __FUNCTION__, __LINE__);
        ret = soap_GetInfo_DeviceInfo();
        if (ret == 0)
            soap_GetInfo_DeviceInfoResponse();
    }
    else if (strcmp(pszMethodName, "GetInfo_WANIPConnection") == 0)
    {
        syslog(LOG_CRIT,"[%s:%d]call soap_Reboot\n", __FUNCTION__, __LINE__);
        ret = soap_GetInfo_WANIPConnection();
        if (ret == 0)
            soap_GetInfo_WANIPConnectionResponse();
    }
	/*Device Config*/
	else if(strcmp(pszMethodName,"Exit") == 0)
	{
		 syslog(LOG_CRIT,"[%s:%d]call soap_Exit\n", __FUNCTION__, __LINE__);
		 ret = soap_Exit();
		 if(ret == 0)
		 	soap_ExitResponse();
	}
	else if(strcmp(pszMethodName,"SetEnable") == 0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_SetEnable\n", __FUNCTION__, __LINE__);
		ret = soap_SetEnable();
		if(ret == 0)
			soap_SetEnableResponse(ret);
		else 
			soap_sendUnkonwErr();
	}
	else if(strcmp(pszMethodName,"GetEnable") == 0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetEnable\n", __FUNCTION__, __LINE__);
		ret = soap_GetEnable();
		if(ret == 0)
			soap_GetEnableResponse();
		else
			soap_sendUnkonwErr();
	}
	else if(strcmp(pszMethodName,"CheckNewFirmware") == 0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_CheckNewFirmware\n", __FUNCTION__, __LINE__);
		ret = soap_CheckNewFirmware();
		soap_CheckNewFirmwareResponse(ret);
	}
	else if(strcmp(pszMethodName,"UpdateNewFirmware") == 0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_UpdateNewFirmware\n", __FUNCTION__, __LINE__);
		ret = soap_UpdateNewFirmware();
		soap_UpdateNewFirmwareResponse(ret);
	}
	else if(strcmp(pszMethodName,"ResetToFactoryDefault") == 0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_ResetToFactoryDefault\n", __FUNCTION__, __LINE__);
		ret = soap_ResetToFactoryDefault();
		soap_ResetToFactoryDefaultResponse(ret);
	}
	else if(strcmp(pszMethodName,"SetDeviceIPAddress") == 0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_SetDeviceIPAddress\n", __FUNCTION__, __LINE__);
		ret = soap_SetDeviceIPAddress();
		soap_SetDeviceIPAddressResponse(ret);
	}
	else if(strcmp(pszMethodName,"GetDeviceIPAddress") == 0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetDeviceIPAddress\n", __FUNCTION__, __LINE__);
		ret = soap_GetDeviceIPAddress();
		if(ret == 0)
			soap_GetDeviceIPAddressResponse();
	}
	else if(strcmp(pszMethodName,"SetTimeZone") == 0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_SetTimeZone\n", __FUNCTION__, __LINE__);
		ret = soap_SetTimeZone();
		if(ret == 0)
			soap_SetTimeZoneResponse();
		else
			soap_sendErr();	
	}
	else if(strcmp(pszMethodName,"GetTimeZone") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetTimeZone\n", __FUNCTION__, __LINE__);
		ret = soap_GetTimeZone();
		if(ret == 0)
			soap_GetTimeZoneResponse();
	}
	else if(strcmp(pszMethodName,"BackupDeviceConfigFile") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_BackupDeviceConfigFile\n", __FUNCTION__, __LINE__);
		ret = soap_BackupDeviceConfigFile();
		if (ret != 3)
			soap_BackupDeviceConfigFileResponse(NULL, NULL, ret);
	}
	else if(strcmp(pszMethodName,"RestoreDeviceConfigFile") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_RestoreDeviceConfigFile\n", __FUNCTION__, __LINE__);
		ret = soap_RestoreDeviceConfigFile();
		soap_RestoreDeviceConfigFileResponse(ret);
	}
	/*Device info*/
	else if(strcmp(pszMethodName,"IsExtender") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_IsExtender\n", __FUNCTION__, __LINE__);
		ret = soap_IsExtender();
		if(ret == 0)
			soap_IsExtenderResponse();
	}
	else if(strcmp(pszMethodName,"GetSysUpTime") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetSysUpTime\n", __FUNCTION__, __LINE__);
		ret = soap_GetSysUpTime();
		if(ret == 0)
			soap_GetSysUpTimeResponse();
	}
	else if(strcmp(pszMethodName,"GetSysLog") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetSysLog\n", __FUNCTION__, __LINE__);
		ret = soap_GetSysLog();
		if(ret == 0)
			soap_GetSysLogResponse();
	}
	/*LANConfigSecurity*/
	else if(strcmp(pszMethodName,"SetConfigPassword") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_SetConfigPassword\n", __FUNCTION__, __LINE__);
		ret = soap_SetConfigPassword();
		if(ret == 0)
			soap_SetConfigPasswordResponse();
		else
			soap_sendUnkonwErr();
	}
	/*WALNConfiguration*/
	else if(strcmp(pszMethodName,"Is5GSupported") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_Is5GSupported\n", __FUNCTION__, __LINE__);
		ret = soap_Is5GSupported();
		if(ret == 0)
			soap_Is5GSupportedResponse();
	}
	else if(strcmp(pszMethodName,"SetRadioEnable") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_SetRadioEnable\n", __FUNCTION__, __LINE__);
		ret = soap_SetRadioEnable();
		if(ret == 0)
			soap_SetRadioEnableResponse();
		else
			soap_sendSupportErr();
	}
	else if(strcmp(pszMethodName,"SetExtenderMode") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_SetExtenderMode\n", __FUNCTION__, __LINE__);
		ret = soap_SetExtenderMode();
		if(ret == 0)
			soap_SetExtenderModeResponse();
		else
			soap_sendSpecErr(ret);
	}
	else if(strcmp(pszMethodName,"GetExtenderMode") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetExtenderMode\n", __FUNCTION__, __LINE__);
		ret = soap_GetExtenderMode();
		if(ret == 0)
			soap_GetExtenderModeResponse();
	}
	else if(strcmp(pszMethodName,"SetWirelessRegion") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_SetWirelessRegion\n", __FUNCTION__, __LINE__);
		ret = soap_SetWirelessRegion();
		if(ret == 0)
			soap_SetWirelessRegionResponse();
		else 
			soap_sendUnkonwErr();
	}
	else if(strcmp(pszMethodName,"GetWirelessRegion") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetWirelessRegion\n", __FUNCTION__, __LINE__);
		ret = soap_GetWirelessRegion();
		if(ret == 0)
			soap_GetWirelessRegionResponse();
	}
	else if(strcmp(pszMethodName,"GetWirelessRegionList") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetWirelessRegionList\n", __FUNCTION__, __LINE__);
		ret = soap_GetWirelessRegionList();
		if(ret == 0)
			soap_GetWirelessRegionListResponse();
	}
	else if(strcmp(pszMethodName,"GetWirelessMode") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetWirelessMode\n", __FUNCTION__, __LINE__);
		ret = soap_GetWirelessMode();
		if(ret == 0)
			soap_GetWirelessModeResponse();
	}
	else if(strcmp(pszMethodName,"GetAvailableChannel") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetAvailableChannel\n", __FUNCTION__, __LINE__);
		ret = soap_GetAvailableChannel();
		if(ret == 0)
			soap_GetAvailableChannelResponse();
	}
	else if(strcmp(pszMethodName,"GetAPInfo") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetAPInfo\n", __FUNCTION__, __LINE__);
		ret = soap_GetAPInfo();
		if(ret == 0)
			soap_GetAPInfoResponse();
	}
	else if(strcmp(pszMethodName,"SetWLANWEPByKeys") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_SetWLANWEPByKeys\n", __FUNCTION__, __LINE__);
		ret = soap_SetWLANWEPByKeys();
		if(ret == 0)
			soap_SetWLANWEPByKeysResponse();
		else
			soap_sendUnkonwErr();
	}
	else if(strcmp(pszMethodName,"SetWLANWEPByPassphrase") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_SetWLANWEPByPassphrase\n", __FUNCTION__, __LINE__);
		ret = soap_SetWLANWEPByPassphrase();
		if(ret == 0)
			soap_SetWLANWEPByPassphraseResponse();
	}
	else if(strcmp(pszMethodName,"GetWLANInfo") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetWLANInfo\n", __FUNCTION__, __LINE__);
		ret = soap_GetWLANInfo();
		if(ret == 0)
			soap_GetWLANInfoResponse();
	}
	else if(strcmp(pszMethodName,"GetWLANWPSEnable") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetWLANWPSEnable\n", __FUNCTION__, __LINE__);
		ret = soap_GetWLANWPSEnable();
		if(ret == 0)
			soap_GetWLANWPSEnableResponse();
	}
	else if(strcmp(pszMethodName,"SetWLANWPSEnable") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_SetWLANWPSEnable\n", __FUNCTION__, __LINE__);
		ret = soap_SetWLANWPSEnable();
		if(ret == 0)
			soap_SetWLANWPSEnableResponse();
		else
			soap_sendUnkonwErr();
	}
	else if(strcmp(pszMethodName,"GetWLANWEPInfo") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetWLANWEPInfo\n", __FUNCTION__, __LINE__);
		ret = soap_GetWLANWEPInfo();
		if(ret == 0)
			soap_GetWLANWEPInfoResponse();
	}
	else if(strcmp(pszMethodName,"GetWLANWPAInfo") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetWLANWPAInfo\n", __FUNCTION__, __LINE__);
		ret = soap_GetWLANWPAInfo();
		if(ret == 0)
			soap_GetWLANWPAInfoResponse();
	}
	else if(strcmp(pszMethodName,"SetRouterWLANWPAPSKByPassphrase") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_SetRouterWLANWPAPSKByPassphrase\n", __FUNCTION__, __LINE__);
		ret = soap_SetRouterWLANWPAPSKByPassphrase();
		if(ret == 0)
			soap_SetRouterWLANWPAPSKByPassphraseResponse();
	}
#if 0
	else if(strcmp(pszMethodName,"GetRouterWLANInfo") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetRouterWLANInfo\n", __FUNCTION__, __LINE__);
		ret = soap_GetRouterWLANInfo();
		if(ret == 0)
			soap_GetRouterWLANInfoResponse();
	}
	else if(strcmp(pszMethodName,"GetRouterWLANVerifyResult") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetRouterWLANVerifyResult\n", __FUNCTION__, __LINE__);
		ret = soap_GetRouterWLANVerifyResult();
		if(ret == 0)
			soap_GetRouterWLANVerifyResultResponse();
	}
	else if(strcmp(pszMethodName,"GetRouterWLANWEPInfo") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetRouterWLANWEPInfo\n", __FUNCTION__, __LINE__);
		ret = soap_GetRouterWLANWEPInfo();
		if(ret == 0)
			soap_GetRouterWLANWEPInfoResponse();
	}
	else if(strcmp(pszMethodName,"GetRouterWLANWPAInfo") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetRouterWLANWPAInfo\n", __FUNCTION__, __LINE__);
		ret = soap_GetRouterWLANWPAInfo();
		if(ret == 0)
			soap_GetRouterWLANWPAInfoResponse();
	}
#endif
	/*SPBU*/
	else if(strcmp(pszMethodName,"UpdateNewFirmwareFromURL") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_UpdateNewFirmwareFromURL\n", __FUNCTION__, __LINE__);
		ret = soap_UpdateNewFirmwareFromURL();
		if(ret == 0)
			soap_UpdateNewFirmwareFromURLResponse();
	}
	else if(strcmp(pszMethodName,"GetDHCPServerEnable") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetDHCPServerEnable\n", __FUNCTION__, __LINE__);
		ret = soap_GetDHCPServerEnable();
		if(ret == 0)
			soap_GetDHCPServerEnableResponse();
	}
	else if(strcmp(pszMethodName,"SetDHCPServerEnable") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_SetDHCPServerEnable\n", __FUNCTION__, __LINE__);
		ret = soap_SetDHCPServerEnable();
		if(ret == 0)
			soap_SetDHCPServerEnableResponse();
		else
			soap_sendUnkonwErr();
	}
#if 0
	else if(strcmp(pszMethodName,"GetTelnetServerEnable") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetTelnetServerEnable\n", __FUNCTION__, __LINE__);
		ret = soap_GetTelnetServerEnable();
		if(ret == 0)
			soap_GetTelnetServerEnableResponse();
	}
	else if(strcmp(pszMethodName,"SetTelnetServerEnable") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_SetTelnetServerEnable\n", __FUNCTION__, __LINE__);
		ret = soap_SetTelnetServerEnable();
		if(ret == 0)
			soap_SetTelnetServerEnableResponse();
	}
	else if(strcmp(pszMethodName,"GetDiagnostics") ==0)
	{
		syslog(LOG_CRIT,"[%s:%d]call soap_GetDiagnostics\n", __FUNCTION__, __LINE__);
		ret = soap_GetDiagnostics();
		if(ret == 0)
			soap_GetDiagnosticsResponse();
	}
#endif
#endif
    else
    {
        syslog(LOG_CRIT,"[%s:%d]call bad methos:[%s]\n", __FUNCTION__, __LINE__, pszMethodName);
        //soap_sendErr();
        return 0;
    }

    return 0;
}

/*
 * 0 : ʾɹ
 *     1 : ʾʧ
 */
int soap_get_soap_content(char *pBuf, int iBufLen)
{
#ifndef NO_DEBUG
    size_t c;
    char *buf;
    int j = 0;
    ssize_t r, r2;

    c = request_len - request_idx;
    // MAX_SOAP_LEN ֽڵsoap
    if (c >= iBufLen)
    {
        syslog(LOG_CRIT,"[%s:%d]too many soap content.max is %d\n", __FUNCTION__, __LINE__, iBufLen);
        return -1;
    }

    //ռ
    if((buf=(char *)malloc(iBufLen))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		exit(1);
	}

    //һζĳhttpͷĲ
    if ( c > 0 )
	{
	    strncpy(&(pBuf[j]), &(request[request_idx]), c);
		j += c;
	}

	//httpݻû꣬
    while ( c < content_length )
    {
        r = my_read( buf, MIN(4*BUFF_SIZE, content_length - c ) );
        if ( r < 0 && ( errno == EINTR || errno == EAGAIN ) )
        {
            sleep(1);
            continue;
        }

        if ( r <= 0 )
        {
            free(buf);
    	    return 0;
    	}

        if (iBufLen-j <= 0)
        {
            syslog(LOG_CRIT,"[%s:%d]too many soap content.max is %d\n", __FUNCTION__, __LINE__, iBufLen);
            free(buf);
            return -1;
        }
        
    	strncpy(&(pBuf[j]),buf, MIN(iBufLen-j, r));

        c += r;
    }

    if (buf)
        free(buf);

    strdecode(pBuf, pBuf);
    return 0;
#else
    char tmpBuf[4096] = {0}; int j = 0;
    size_t c;
    char *buf;
    ssize_t r, r2;

    c = request_len - request_idx;
    syslog(LOG_CRIT,"[%s:%d],..into[%d-%d].[%d-%d].\n", __FUNCTION__, __LINE__, c, content_length, request_len, request_idx);
    if((buf=(char *)malloc(LARGE_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		exit(1);
	}
	syslog(LOG_CRIT,"[%s:%d],....\n", __FUNCTION__, __LINE__);
    while ( c < content_length )
    {
		syslog(LOG_CRIT,"[%s:%d],....\n", __FUNCTION__, __LINE__);
        r = my_read( buf, MIN(4*BUFF_SIZE, content_length - c ) );
        if ( r < 0 && ( errno == EINTR || errno == EAGAIN ) )
        {
            sleep(1);
            continue;
        }
        syslog(LOG_CRIT,"[%s:%d]....\n", __FUNCTION__, __LINE__);
        if ( r <= 0 )
        {
            free(buf);
    	    return;
    	}
   	    syslog(LOG_CRIT,"[%s:%d],....\n", __FUNCTION__, __LINE__);
    	add_to_request( buf, r );
        c += r;
    }

    syslog(LOG_CRIT,"[%s:%d],....\n", __FUNCTION__, __LINE__);
    if (buf)
        free(buf);
    c = request_len - request_idx;
    syslog(LOG_CRIT,"[%s:%d],..c:[%d]..\n", __FUNCTION__, __LINE__,c );
    strncpy(tmpBuf, &(request[request_idx]), c);
    strdecode(tmpBuf, tmpBuf);
    syslog(LOG_CRIT,"[%s:%d-%d]%s\n", __FUNCTION__, __LINE__, j, tmpBuf);
#endif
}
#endif
/*1360 ƷҪtelnetرգΪ˲Ӱ,⵽Ҫʱtelnet*/
static int start_telnet(void)
{
    FILE *pFile = NULL;
    
    pFile = fopen("/etc/inetd.conf", "w");/* ļ */
    if ( NULL == pFile )
    {
        printf("Open file /etc/inetd.conf faild.\n");
        return -1;
    }

    fprintf(pFile, "telnet stream tcp nowait root /usr/sbin/telnetd telnetd\n");/* ʱtelnet */
    fclose(pFile); /* رļ */

    system("killall -9 inetd");/*ɱԭinetd*/
    sleep(1);
    system("/usr/sbin/inetd &");/*inetd*/
    system("echo \"1\">/var/telnetd");//Ӧò㣬telnet
    return 0;
}

static void send_redirect2page()
{
    char buf[] = 
    {"<script type=\"text/javascript\">\n\
<!--\n\
window.location.href = \"/cgi-bin/webproc?getpage=html/page/start_telnet.htm&var:page=start_telnet\";\n\
-->\n\
</script>\n\
\n\
"
    };
    int buf_len = strlen(buf);
    
    add_headers( 200, "Ok", "", "", "text/html; charset=%s", buf_len, sb.st_mtime );
    if ( method != METHOD_HEAD )
        add_to_response( buf, buf_len);
    send_response();
	close(child_accept_fd);
	httpd_cleanup();
	ssl_cleanup();
    exit(0);
}

#define NETGEAR_REQ_URL_SECURITY
/* This runs in a child process, and exits when done, so cleanup is
** not needed.
*/
static void
handle_request( int rfd )
{
    char* method_str;
    char* line;
    char* cp;
    int r, file_len, i;
    int err_flag = FALSE;
    char *tmpGetpage;     // save the getpage's start address in the path.
    char tmppath[256] = {0};    //  save the path for analysis
#ifdef HTTP_WITH_PARENT_CONTROL
    char szMethodName[64] = {0};
#endif
#ifdef USE_SSL
	struct timeval tv;
#endif
    const char* index_names[] = {
	"index.htm", "index.xhtml", "index.xht", "Default.htm",
	"index.cgi" };
    /* GUIȫ,  */

	const char *allow_url[] = {
//	"debuginfo.htm",
	"Default.htm",
//	"debug.htm",
	"POT.htm",
	"currentsetting.htm",
//	"super_setting.htm",
	"index.htm",
//	"test_version.htm",
	"cgi-bin/webupg",
	"start_telnet"};

    /* Set up the timeout for reading. */
#ifdef HAVE_SIGSET
    (void) sigset( SIGALRM, handle_read_timeout );
#else /* HAVE_SIGSET */
    (void) signal( SIGALRM, handle_read_timeout );
#endif /* HAVE_SIGSET */
    (void) alarm( READ_TIMEOUT );
    /* Initialize the request variables. */
    remoteuser = (char*) 0;
	Language = (char*) 0;
    method = METHOD_UNKNOWN;
    path = (char*) 0;
    file = (char*) 0;
    pathinfo = (char*) 0;
    query = "";
    protocol = (char*) 0;
    status = 0;
    bytes = -1;
    req_hostname = (char*) 0;

    authorization = (char*) 0;
    content_type = (char*) 0;
    content_length = -1;
    cookie = (char*) 0;
    host = (char*) 0;
    if_modified_since = (time_t) -1;
    referer = "";
    useragent = "";
	conn_fd=rfd;
	childpid=getpid();
#ifdef TCP_NOPUSH
    /* Set the TCP_NOPUSH socket option, to try and avoid the 0.2 second
    ** delay between sending the headers and sending the data.  A better
    ** solution is writev() (as used in thttpd), or send the headers with
    ** send(MSG_MORE) (only available in Linux so far).
    */
	conn_fd=rfd;

    r = 1;
    (void) setsockopt(conn_fd,IPPROTO_TCP,TCP_NOPUSH,(void*)&r,sizeof(r));
#endif /* TCP_NOPUSH */

//


//

#ifdef USE_SSL
	tv.tv_sec = 5;
	tv.tv_usec = 0;
	(void)setsockopt(conn_fd, SOL_SOCKET, SO_RCVTIMEO, (void *)&tv, sizeof(tv));
	if (do_ssl_child && do_ssl_con)
	{
		ssl = SSL_new( ssl_ctx );
		SSL_set_fd( ssl, conn_fd );
		if ( SSL_accept( ssl ) == 0 )
		{
			//ERR_print_errors_fp( stderr );
			close(conn_fd);
			httpd_cleanup();
			ssl_cleanup();
			exit( 1 );
		}
	}
#endif /* USE_SSL */

	/* Read in the request. */
	start_request();
	for (;;)
	{
		char *buf;/*[10000]*/
		int r;
		if((buf=(char *)malloc(LARGE_BUFF))==NULL)
		{
			syslog(LOG_CRIT,"out of memory exiting");
			close(conn_fd);
			httpd_cleanup();
			ssl_cleanup();
			exit(1);
		}
		r=my_read( buf, LARGE_BUFF);
		
		if ( r < 0 && ( errno == EINTR || errno == EAGAIN ) )
		{
			free(buf);
			continue;
		}
		if ( r <= 0 )
		{
			free(buf);
			return; /*Add by sudenghai 2014-8-22ֶΪգֱӷأ´󣬱
			            ֱӷ400 bad requestֹỰԭ400 bad requestGoogle׳*/
			//break;
		}
		(void) alarm( READ_TIMEOUT );
		
		add_to_request( buf, r );
		if ( strstr( request, "\015\012\015\012" ) != (char*) 0 ||
			 strstr( request, "\012\012" ) != (char*) 0 )
		{
			free(buf);
			break;
		}
        /* TBS_TAG: by laisimin 2011-2-10 Desc: ͷmallocڴ */
        free(buf);
	}

    /* Parse the first line of the request. */
    method_str = get_request_line();
	
#ifdef NETGEAR_REQ_URL_SECURITY
	//printf("mini_http [before] method_str=%s \n" , method_str);
	if(method_str != (char*) 0 && 
		!strstr(method_str, "/cgi-bin") && 
		0 != safe_strncmp(method_str, "GET /html/", strlen("GET /html/"))
		)
	{

		int action_len = 0, suffix_len = 0;
		char *suffix_point = NULL, *search_point = NULL;
		char buf_tmp1[128] = {0}, buf_tmp2[128] = {0};
		char line_str[512] = {0};
		strcpy(line_str, method_str);
		method_str = line_str;

		if(0==safe_strncmp(method_str, "GET ", 4))
		{
			action_len = 4;

			/*http://192.168.2.1/wizard.html => GET /wizard.html HTTP/1.1 */
			if(action_len && (*(method_str + action_len + 1) != ' '))
			{

				/*copy /wizard.html HTTP/1.1 to buf_tmp1*/
				strncpy(buf_tmp1, method_str+action_len, sizeof(buf_tmp1));

				if(suffix_point = strstr(method_str, ".html"))
				{
					suffix_len = 5;
				}
				else if(suffix_point = strstr(method_str, ".htm"))
				{
					suffix_len = 4;
				}

				/*find .html or .htm, make sure it is html or htm files*/
				if(suffix_point)	
				{

					/*chip the " HTTP/1.1" from "/wizard.html HTTP/1.1"*/
					search_point = strstr(buf_tmp1, ".htm");
					*(search_point + suffix_len) = '\0';
						
					for (i = 0; i < URL_TABLE_SIZE; i++)
					{	
						if(0 == safe_strncmp(buf_tmp1+1, g_stUrlTable[i].pszMatchVal, strlen(g_stUrlTable[i].pszMatchVal)))
						{
							//matched
							snprintf(buf_tmp2, sizeof(buf_tmp2), "%s", g_stUrlTable[i].pszUrlFmt);

							/*chip .htm or .html => GET /wizard HTTP/1.1*/
							memmove(suffix_point, suffix_point+suffix_len, strlen(suffix_point));
							/*make GET <-strlen(buf_tmp2)->wizard HTTP/1.1*/
							memmove(method_str+(strlen(buf_tmp2)+action_len), method_str+action_len+1, (strlen(method_str)-action_len-1));
							/*make GET /cgi-bin/webproc?getpage=html/index.html&var:menu=lan&var:page=wizard HTTP/1.1*/
							strncpy(method_str+action_len, buf_tmp2, strlen(buf_tmp2));
									
							//printf("mini_http [after] method_str=%s \n" , method_str);
							break;
						}

					}
				}
				else //dealwith js
				{
					for (i = 0; i < URL_JS_SIZE; i++)
					{	
						if(0 == safe_strncmp(buf_tmp1+1, g_stUrlJs[i].pszMatchVal, strlen(g_stUrlJs[i].pszMatchVal)))
						{
							//matched
							snprintf(buf_tmp2, sizeof(buf_tmp2), g_stUrlJs[i].pszUrlFmt, g_stUrlJs[i].pszMatchVal);

							/*make GET <-strlen(buf_tmp2)-> HTTP/1.1*/
							memmove(method_str+(strlen(buf_tmp2)+action_len), method_str+action_len+ strlen(g_stUrlJs[i].pszMatchVal)+1, (strlen(method_str)-action_len-strlen(g_stUrlJs[i].pszMatchVal)-1));
							/*make GET /cgi-bin/webproc?getpage=html/page/apupscan.ajax.js&var:page=* HTTP/1.1*/
							strncpy(method_str+action_len, buf_tmp2, strlen(buf_tmp2));
									
							//printf("mini_http [after] method_str=%s \n" , method_str);
							break;
						}

					}
				}
				
				
			}
		
		}
		else if(0==safe_strncmp(method_str, "POST ", 5))
		{
			
			action_len = 5;
			if(action_len && (*(method_str + action_len + 1) != ' '))
			{

				strncpy(buf_tmp1, method_str+action_len, sizeof(buf_tmp1));
				for (i = 0; i < URL_PRO_SIZE; i++)
				{	
					if(0 == safe_strncmp(buf_tmp1+1, g_stUrlPro[i].pszMatchVal, strlen(g_stUrlPro[i].pszMatchVal)))
					{
						//matched
						snprintf(buf_tmp2, sizeof(buf_tmp2), g_stUrlPro[i].pszUrlFmt, g_stUrlPro[i].pszMatchVal);

						/*make POST <-strlen(buf_tmp2)-> HTTP/1.1*/
						memmove(method_str+(strlen(buf_tmp2)+action_len), method_str+action_len+ strlen(g_stUrlPro[i].pszMatchVal)+1, (strlen(method_str)-action_len-strlen(g_stUrlPro[i].pszMatchVal)-1));
						/*make POST /cgi-bin/webproc HTTP/1.1*/
						strncpy(method_str+action_len, buf_tmp2, strlen(buf_tmp2));
								
						//printf("mini_http [after] method_str=%s \n" , method_str);
						break;
					}

				}

			}
		}

	}
#endif
    if ( method_str == (char*) 0 )
    {
          send_error( 400, "Bad Request", "", "Can't parse request." );
    }
    else
    {
		if((strstr(method_str,"/cgi-bin/webupg"))&&
		    ((strstr(method_str,"<"))||(strstr(method_str,">"))||(strstr(method_str,"%"))||(strstr(method_str,"\'"))||(strstr(method_str,"\""))))
		{
		    return;
		}
    }
    path = strpbrk( method_str, " \t\012\015" );

    if ( path == (char*) 0 )
		send_error( 400, "Bad Request", "", "Can't parse request." );
    *path++ = '\0';
    path += strspn( path, " \t\012\015" );
    protocol = strpbrk( path, " \t\012\015" );
    if ( protocol == (char*) 0 )
		send_error( 400, "Bad Request", "", "Can't parse request." );
    *protocol++ = '\0';
    protocol += strspn( protocol, " \t\012\015" );
    query = strchr( path, '?' );
 // found getpage and save the address
    if ( (tmpGetpage = strstr(path, "getpage=")) != NULL ){
        if ( strstr ((tmpGetpage + 7), "getpage=") != NULL){
            // if has two getpage, send 400 error.
            send_error(400,"Bad Request","","Illegal File access");	
        }
    }

    snprintf(tmppath, sizeof(tmppath), "%s", tmpGetpage == NULL ? path: tmpGetpage);
    tmpGetpage = NULL;
    if ( query == (char*) 0 )
		query = "";
    else
		*query++ = '\0';
    /* Parse the rest of the request headers. */
    while ( ( line = get_request_line() ) != (char*) 0 )
	{
		if ( line[0] == '\0' )
			break;
		else if ( strncasecmp( line, "Authorization:", 14 ) == 0 )
		{
			cp = &line[14];
			cp += strspn( cp, " \t" );
			authorization = cp;
		}
		else if ( strncasecmp( line, "Content-Length:", 15 ) == 0 )
		{
			cp = &line[15];
			cp += strspn( cp, " \t" );
			content_length = (unsigned int)atoi( cp );
		}
		else if ( strncasecmp( line, "Content-Type:", 13 ) == 0 )
		{
			cp = &line[13];
			cp += strspn( cp, " \t" );
			content_type = cp;
		}
		else if ( strncasecmp( line, "Cookie:", 7 ) == 0 )
		{
			cp = &line[7];
			cp += strspn( cp, " \t" );
			//ֻٶصϢʱʧܣٶԶCookiecookieḲǣsessionУʧܶʧ
			/*
			Cookie: sessionid=cLhpuua9qMP9TamNSF2tlmteoX4K
			Host: 192.168.33.1
			Connection: Keep-Alive
			Cookie: token_sys=8JXP6NdX+9YIM2Oz18UzQVmv+0ap
			Cookie2: $Version=1
			lxb add 2015-11-28
			*/
			//ԭʼcookieֱӽȥǷsessionid 
			//if (strstr(cp,"sessionid") != NULL)
			cookie = cp;
		}
		else if ( strncasecmp( line, "Host:", 5 ) == 0 )
		{
			cp = &line[5];
			cp += strspn( cp, " \t" );
			host = cp;
			if ( strchr( host, '/' ) != (char*) 0 || host[0] == '.' )
			send_error( 400, "Bad Request", "", "Can't parse request." );
		}
		else if ( strncasecmp( line, "If-Modified-Since:", 18 ) == 0 )
		{
			cp = &line[18];
			cp += strspn( cp, " \t" );
			if_modified_since = tdate_parse( cp );
		}
		else if ( strncasecmp( line, "Referer:", 8 ) == 0 )
		{
			cp = &line[8];
			cp += strspn( cp, " \t" );
			referer = cp;
		}
		else if ( strncasecmp( line, "User-Agent:", 11 ) == 0 )
		{
			cp = &line[11];
			cp += strspn( cp, " \t" );
			useragent = cp;
		}
		else if ( strncasecmp( line, "Accept-Language: ", 17 ) == 0)
		{
			cp = &line[17];
			cp += strspn( cp, " \t" );
			Language = cp;
			//printf("#######MINI_HTTP#####Accept-Language:%s \n", Language);
		}
#ifdef HTTP_WITH_PARENT_CONTROL
		//like : SOAPAction: urn:NETGEAR-ROUTER:service:ParentalControl:1#EnableParentalControl
		//or like: SOAPAction: "urn:NETGEAR-ROUTER:service:ParentalControl:1#EnableParentalControl"
		else if ( strncasecmp( line, "SOAPAction", 10 ) == 0 )
		{
			cp = &line[10];
			cp += strspn( cp, " \t" );
			soapaction = cp;

	        char *pszPos = strrchr(line, '#');
	        if (pszPos)
	        {
	            snprintf(szMethodName, 64, "%s", ++pszPos);
	            //ȥַ"
	            if (szMethodName[strlen(szMethodName)-1] == '"')
	                szMethodName[strlen(szMethodName)-1] = '\0';
	            syslog(LOG_CRIT,"[%s:%d][%s]\n", __FUNCTION__, __LINE__, szMethodName);
	        }
			/*GetInfo  ֻǱӰ̫󣬱Ͼ汾Ѿȶ*/
			if(strcmp(szMethodName,"GetInfo")==0)
			{
				if(strstr(soapaction,"WANIPConnection"))
					strcpy(szMethodName,"GetInfo_WANIPConnection");
				
				if(strstr(soapaction,"DeviceInfo"))
					strcpy(szMethodName,"GetInfo_DeviceInfo");

				if(strstr(soapaction,"WLANConfiguration"))
					strcpy(szMethodName,"GetWLANInfo");
				
			}
		}
#endif
	}

	if((method_type=(char *)malloc(strlen(method_str)*sizeof(char)))==NULL)
	{
		syslog(LOG_INFO,"Memory allocation failed exiting\n");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
	strcpy(method_type,method_str);
    if ( strcasecmp( method_str, get_method_str( METHOD_GET ) ) == 0 )
		method = METHOD_GET;
    else if ( strcasecmp( method_str, get_method_str( METHOD_HEAD ) ) == 0 )
		method = METHOD_HEAD;
    else if ( strcasecmp( method_str, get_method_str( METHOD_POST ) ) == 0 )
		method = METHOD_POST;
    else
	{
		free(method_type);
		send_error( 501, "Not Implemented", "", "That method is not implemented." );
	}
    strdecode( path, path );

#ifdef HTTP_WITH_PARENT_CONTROL
    if ((method == METHOD_POST) && (szMethodName[0]))
    {
        soap_parent_ctrl_handle(szMethodName);
    }
#endif

    if ( path[0] != '/' )
	{
		free(method_type);
		send_error( 400, "Bad Request", "", "Bad filename." );
	}
    file = &(path[1]);
	if(file!=NULL)
    {
        if(safe_strcmp(file,"start_telnet")==0)
		{
			//send_redirect2page();
			start_telnet();
        }
    }
    if(file!=NULL)
    {
        if(safe_strcmp(file,"cgi-bin/")==0)
                send_error(400,"Bad Request","","Illegal File access");
    }
#ifdef TR069
	if(do_tr69)
	{
		if(strstr(file,TR69URL)!=NULL)
			syslog(LOG_WARNING,"XXX\tTR-069 URL Match Found\n");
	}
#endif
   if(strlen(file)  > 1)
       {
        /*
            ȫ, ҪҪֹҳĿ¼ļ, /etc/passwd.˼·:
            Χfile, ֵֿܵ
            1. cgi-bin/webproc, Ƕȡҳ, webprocҳʱõ, ǸȻgetpage
                getpageĿ¼ǷΪhtmlͷ, Ϳֹͨgetpageȡļ.
            2. cgi-bin/upgcgi   ñ, fwcgi, getpage, fileΪ
                ʱ, ӹ.
            3. html/xxx/xxx test_version.html  ЩҳhtmlӦjsű, ͼƬĶ, Щ
                صҳ, ͼƬ,css, js, ǷΪ"html/"ʼļ, ҳͨ
                һҳ allow_url Աȷ.
            
        */
        
        if ( strcmp(file, "cgi-bin/webproc") == 0 )
            {
            
            /*  forbidden  getpage outof folder /usr/www/html */
            if(  safe_strncmp (tmppath,"getpage", 7 ) == 0 )
            {
                if ( strstr(tmppath, "getpage=html") == NULL && !strstr(tmppath, "getpage=debug.htm"))
                {
                    err_flag = TRUE;
                }
            }
        }
        else if (strncmp(file, "html/", 5) == 0)
        { /* allow direct accesss file under usr/www/html/ for get html skin/css..etc */
			if (!strstr(file, ".js")  && !strstr(file, ".htm") && !strstr(file, ".html") && !strstr(file, ".css") &&
				!strstr(file, ".jpg") && !strstr(file, ".png") && !strstr(file, "gif") && !strstr(file, "ico"))
				err_flag = TRUE; //add by wyh at 2015-10-15 to full fill customer's requirement that should not feedback the files under 'html/', such as languages, js, and so on 
        }
        else{
            /* deny other all */
            err_flag = TRUE;
        }

        // only flag is true, need check the special page list
        if(err_flag){
       	for (i = 0; i < sizeof(allow_url) / sizeof(char *); ++i)
            {
		        /* check special page, allow this page */
			    if (strcmp(file, allow_url[i]) == 0)
			    {
	            	err_flag = FALSE;
	        	}
    		}
        }

        /* forbidden relative path */
        if (strstr (tmppath, "../") != NULL ) 
        {
			err_flag = TRUE;
        }

	   	//add by wfj 20170321 ĳЩֻڻָ²ܵ¼Զת¼
		if(access("/var/unconfig", F_OK) ==0)
		{		
			//ֹapple ϵͳwifi Զҳ
			if (strcmp(file, "hotspot-detect.html") == 0 || 
				strcmp(file, "library/test/success.html") == 0 ||
				strcmp(file, "rYf5lGJhu.html") == 0)
			{

				//ƻϵͳ״ӵʱʲôҲ, ʹʧ
				close(child_accept_fd);
				httpd_cleanup();
				ssl_cleanup();
				exit(1);
			}
			else
			{
				err_flag = FALSE;
			}
				
		}
   //     free(tmppath);
        if(err_flag)
	     {
	        send_error(400,"Bad Request","","Illegal File access");
	     }	 
   	}

    de_dotdot( file );
    if ( file[0] == '\0' )
		file = "./";
    if ( file[0] == '/' ||
	 ( file[0] == '.' && file[1] == '.' &&
	   ( file[2] == '\0' || file[2] == '/' ) ) )
		send_error( 400, "Bad Request", "", "Illegal filename." );
    if ( vhost )
		file = virtual_file( file );

    /* Set up the timeout for writing. */
#ifdef HAVE_SIGSET
    (void) sigset( SIGALRM, handle_write_timeout );
#else /* HAVE_SIGSET */
    (void) signal( SIGALRM, handle_write_timeout );
#endif /* HAVE_SIGSET */
    (void) alarm( WRITE_TIMEOUT );

    r = stat( file, &sb );
    if ( r < 0 )
		r = get_pathinfo();
    if ( r < 0 )
	{
		free(method_type);
		#if 1
//ȡ·ĸ澯״̬
char szWarning[40]={0};
#ifdef CONFIG_DNS_HTTP_HIJACK
char szIPAddr[40]= {0}; //get the current LAN Management IP Address
CMM_GetStr("InternetGatewayDevice.LANDevice.1.LANHostConfigManagement.IPInterface.1.IPInterfaceIPAddress",szIPAddr,sizeof(szIPAddr)-1, NULL, 0);
#endif
CMM_GetStr("InternetGatewayDevice.X_TWSZ-COM_TrafficMeter.TrffcLimitWarningReached",szWarning,sizeof(szWarning)-1, NULL, 0);
		if((!strcmp(szWarning,LIMIT_WARNING_STR_TIME_OVER))||(!strcmp(szWarning,LIMIT_WARNING_STR_VLM_OVER)))

        {
        #if 0
        char szIPAddr[40]= {0};
	 if(CMM_SUCCESS == CMM_GetStr("InternetGatewayDevice.LANDevice.1.LANHostConfigManagement.IPRouters",szIPAddr,sizeof(szIPAddr)-1, NULL, 0))
	{
		system("echo ========mini_httpd get sucess!======\n");
		FILE *fp;
		fp=fopen("/var/testmini","w+");
		if(fp)
			{
			fprintf(fp,"%s",szIPAddr);
			fclose(fp);
			}
	}
	 #endif
            send_error( 302, "Found", "Location:/cgi-bin/webproc?getpage=html/page/traffic_reachlimit.htm&var:page=traffic_reachlimit", "Directories must end with a slash." );

        }
		else
		#endif
		{
#ifdef CONFIG_DNS_HTTP_HIJACK		//to deal with the problem that 'ddddd.com/ddd/eee' URL can not redirect to 'http://www.mywifiext.net'
			if (strcmp(host,szIPAddr) && strcmp(host,"www.mywifiext.com")&& strcmp(host,"www.mywifiext.net")
				&& strcmp(host,"mywifiext.com")&& strcmp(host,"mywifiext.net"))
				send_error( 302, "Found", "Location:http://www.mywifiext.net", "Directories must end with a slash." ); //redirect action
			/*޸ http://192.168.1.250/new_index.htm
   				  http://www.mywifiext.com/welcome.htmᵯ½ʾ sudenghai 2014-12-30*/
			else if ((0 == strcmp(host,szIPAddr) || 0 == strcmp(host,"www.mywifiext.com") || 0 == strcmp(host,"www.mywifiext.net")
				|| 0 == strcmp(host,"mywifiext.com") || 0 == strcmp(host,"mywifiext.net")) && file && (strlen(file)>0))
				send_error( 302, "Found", "Location:http://www.mywifiext.net", "Directories must end with a slash." ); //redirect action
			else
#endif				
				send_error( 404, "Not Found", "", "File not found." );
		}
	}

	/* MT : method_type is global required for CalcDigest - its freed after it */
    file_len = strlen( file );
    if ( ! S_ISDIR( sb.st_mode ) )
	{
		/* Not a directory. */
		while ( file[file_len - 1] == '/' )
		{
			file[file_len - 1] = '\0';
			--file_len;
		}
		do_file();
	}
    else
	{
		char *idx;/*[10000]*/
		if((idx=(char *)malloc(LARGE_BUFF))==NULL)
		{
			syslog(LOG_CRIT,"out of memory exiting");
			close(child_accept_fd);
			httpd_cleanup();
			ssl_cleanup();
			exit(1);
		}
		/* The filename is a directory.  Is it missing the trailing slash? */
		if ( file[file_len - 1] != '/' && pathinfo == (char*) 0 )
		{
			char *location;/*[10000]*/
			if((location=(char *)malloc(LARGE_BUFF))==NULL)
			{
				syslog(LOG_CRIT,"out of memory exiting");
				close(child_accept_fd);
				httpd_cleanup();
				ssl_cleanup();
				free(idx);
				exit(1);
			}
			if ( query[0] != '\0' )
				(void) snprintf(location,LARGE_BUFF, "Location: %s/?%s", path,query);
			else
				(void) snprintf(location,LARGE_BUFF, "Location: %s/", path );
			free(location);
			free(idx);
			send_error( 302, "Found", location, "Directories must end with a slash." );
		}

	//host·IPaddressӦȫʱת
	//ο/etc/hosts
//ȡ·IPַ͸澯״̬
char szIPAddr[40]= {0};
char szWarning[40]={0};
CMM_GetStr("InternetGatewayDevice.LANDevice.1.LANHostConfigManagement.IPInterface.1.IPInterfaceIPAddress",szIPAddr,sizeof(szIPAddr)-1, NULL, 0);
CMM_GetStr("InternetGatewayDevice.X_TWSZ-COM_TrafficMeter.TrffcLimitWarningReached",szWarning,sizeof(szWarning)-1, NULL, 0);
#ifndef CONFIG_DNS_HTTP_HIJACK
        if(strcmp(host,szIPAddr)&&strcmp(host,"www.routerlogin.com")&&strcmp(host,"www.routerlogin.net"))
			&&strcmp(host,"routerlogin.com")&&strcmp(host,"routerlogin.net"))
#else //while the input url not equal to local IP, www.mywifiext.com, www.mywifiext.net, mywifiext.com, mywifiext.net, then redirect to http://www.mywifiext.net
		if(strcmp(host,szIPAddr)&&strcmp(host,"www.mywifiext.com")&&strcmp(host,"www.mywifiext.net")
			&&strcmp(host,"mywifiext.com")&&strcmp(host,"mywifiext.net")  //modify by wyh at 2014-06-18 to enable loginAgain redirect while finish 'Password Recovery' setting
			&&strcmp(host,"routerlogin.com")&&strcmp(host,"routerlogin.net"))
#endif
        {
        #if 0
        char szIPAddr[40]= {0};
	 if(CMM_SUCCESS == CMM_GetStr("InternetGatewayDevice.LANDevice.1.LANHostConfigManagement.IPRouters",szIPAddr,sizeof(szIPAddr)-1, NULL, 0))
	{
		system("echo ========mini_httpd get sucess!======\n");
		FILE *fp;
		fp=fopen("/var/testmini","w+");
		if(fp)
			{
			fprintf(fp,"%s",szIPAddr);
			fclose(fp);
			}
	}
	 #endif
	 	//жԶ̷·ָ澯ҳBUG
		 if((!strcmp(szWarning,LIMIT_WARNING_STR_TIME_OVER))||(!strcmp(szWarning,LIMIT_WARNING_STR_VLM_OVER)))
	 	{
            send_error( 302, "Found", "Location:/cgi-bin/webproc?getpage=html/page/traffic_reachlimit.htm&var:page=traffic_reachlimit", "Directories must end with a slash." );
            free(idx);
		}
#ifdef CONFIG_DNS_HTTP_HIJACK
		
		if (access("/var/unconfig", F_OK)!=0) //ָʱҪָҳ棬Ҫ
		{
			int result = 0;
			struct sockaddr_in sa;
   			result = inet_pton(AF_INET, host, &(sa.sin_addr));
			if (result == 1) //IP ַҪضhttp://www.mywifiext.com
			{
				//Ҫǽ޸IP ַǰһεIPתhttp://www.mywifiext.com
				free(idx);
				goto got_one;
			} 
			else
			{
				send_error( 302, "Found", "Location:http://www.mywifiext.com", "Directories must end with a slash." ); //redirect action
				free(idx);
			}
			
			
		}
#endif

        }
		/*λʱ,κضΪwww.routerlogin.net (·ipܱ)*/
		if(access("/var/unconfig", F_OK)==0 && !strstr(host,szIPAddr))
 		{
 			
 			if(!strcmp(host,"www.mywifiext.com") || !strcmp(host,"www.mywifiext.net")
			|| !strcmp(host,"mywifiext.com") || !strcmp(host,"mywifiext.net")
			|| !strcmp(host,"routerlogin.com") || !strcmp(host,"routerlogin.net"))
			{
				/*⼸¼ľֱӵ¼Ҫת*/
				(void) snprintf( idx,LARGE_BUFF, "%s%s", file, index_names[0] );
			}
			else
			{		
				(void) snprintf( idx,LARGE_BUFF, "%s%s", file, index_names[3] );
			}
			
			if ( stat( idx, &sb ) >= 0 )
			{
				file = idx;
				do_file();
				goto got_one;
			}
		}
		else
		{		
			/* Check for an index file. */
			for ( i = 0; i < sizeof(index_names) / sizeof(char*); ++i )
			{
				(void) snprintf( idx,LARGE_BUFF, "%s%s", file, index_names[i] );
				if ( stat( idx, &sb ) >= 0 )
				{
					file = idx;
					do_file();
					goto got_one;
				}
			}
		}
		/* Nope, no index file, so it's an actual directory request. */
		do_dir();
		free(idx);
		got_one: ;
	}	
#ifdef USE_SSL
	if (do_ssl_child && do_ssl_con)
	{
    	SSL_free( ssl );
	}
#endif /* USE_SSL */
}


static void
de_dotdot( char* file )
{
    char* cp;
    char* cp2;
    int l;

    /* Collapse any multiple / sequences. */
    while ( ( cp = strstr( file, "//") ) != (char*) 0 )
	{
		for ( cp2 = cp + 2; *cp2 == '/'; ++cp2 )
			continue;
		(void) strcpy( cp + 1, cp2 );
	}

    /* Remove leading ./ and any /./ sequences. */
    while ( safe_strncmp( file, "./", 2 ) == 0 )
		(void) strcpy( file, file + 2 );
    while ( ( cp = strstr( file, "/./") ) != (char*) 0 )
		(void) strcpy( cp, cp + 2 );

    /* Alternate between removing leading ../ and removing xxx/../ */
    for (;;)
	{
		while ( safe_strncmp( file, "../", 3 ) == 0 )
			(void) strcpy( file, file + 3 );
		cp = strstr( file, "/../" );
		if ( cp == (char*) 0 )
			break;
		for ( cp2 = cp - 1; cp2 >= file && *cp2 != '/'; --cp2 )
			continue;
		(void) strcpy( cp2 + 1, cp + 4 );
	}

    /* Also elide any xxx/.. at the end. */
    while ( ( l = strlen( file ) ) > 3 &&
	    safe_strcmp( ( cp = file + l - 3 ), "/.." ) == 0 )
	{
		for ( cp2 = cp - 1; cp2 >= file && *cp2 != '/'; --cp2 )
			continue;
		if ( cp2 < file )
			break;
		*cp2 = '\0';
	}
}


static int
get_pathinfo( void )
{
    int r;

    pathinfo = &file[strlen(file)];
    for (;;)
	{
		do
		{
			--pathinfo;
			if ( pathinfo <= file )
			{
				pathinfo = (char*) 0;
				return -1;
			}
		}
		while ( *pathinfo != '/' );
			*pathinfo = '\0';
		r = stat( file, &sb );
		if ( r >= 0 )
		{
			++pathinfo;
			return r;
		}
		else
			*pathinfo = '/';
	}
}


static void
do_file( void )
{
    char *buf;/*[10000]*/
    char *mime_encodings;/*[500]*/
    const char* mime_type;
    char *fixed_mime_type;/*[500]*/
    char* cp;
    int fd;
	if((mime_encodings=(char *)malloc(5*SMALL_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
	if((fixed_mime_type=(char *)malloc(5*SMALL_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		free(mime_encodings);
		exit(1);
	}
	if((buf=(char *)malloc(LARGE_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		free(mime_encodings);
		free(fixed_mime_type);
		exit(1);
	}
    /* Check authorization for this directory. */
    (void) strncpy( buf, file,LARGE_BUFF);
    cp = strrchr( buf, '/' );
    if ( cp == (char*) 0 )
		(void) strcpy( buf, "." );
    else
		*cp = '\0';

/* ޸: chenyuedong ⵥ: 0000103 ޸: ȥһ */
//	syslog(LOG_CRIT,"out of memory exiting");
	auth_check( buf );

#ifdef TR069
	if (do_tr69)
	{
		free(mime_encodings);
		free(fixed_mime_type);
		free(buf);
		shutdown(child_accept_fd, SHUT_RDWR);
		syslog(LOG_WARNING, "shutdown 1728");
		httpd_cleanup();
		syslog(LOG_WARNING, "cleanup 1728");
#ifdef USE_SSL
		ssl_cleanup();
#endif
		return;
	}
#endif

    /* Check if the filename is the AUTH_FILE itself - that's verboten. */
    if ( safe_strcmp( file, AUTH_FILE ) == 0 ||
	 ( safe_strcmp( &(file[strlen(file) - sizeof(AUTH_FILE) + 1]), AUTH_FILE ) == 0 &&
	   file[strlen(file) - sizeof(AUTH_FILE)] == '/' ) )
	{
		syslog(
			LOG_NOTICE, "%.80s URL \"%.80s\" tried to retrieve an auth file",
			ntoa( &client_addr ), path );
		free(mime_encodings);
		free(fixed_mime_type);
		free(buf);
		send_error( 403, "Forbidden", "", "File is protected." );
	}

    /* Referer check. */
    check_referer();
    /* Is it CGI? */
	if (cgi_pattern != (char*) 0 && match( cgi_pattern_tmp,file))
    //if ( cgi_pattern != (char*) 0 && (strstr(cgi_pattern,file)!=NULL))
	{
#ifdef USE_SEM_SEMUN
		// gxw / 2015-11-11 / ӽ̵cgi򻥳
		sem_get();
#endif
		do_cgi();
#ifdef USE_SEM_SEMUN		
		// gxw / 2015-11-11 / ӽ̵cgi򻥳
		sem_free();
#endif		
		free(mime_encodings);
		free(fixed_mime_type);
		free(buf);
		return;
	}
    else if ( pathinfo != (char*) 0 )
	{
		free(mime_encodings);
		free(fixed_mime_type);
		free(buf);
		send_error( 404, "Not Found", "", "File not found." );
	}
#if (defined(REWRITE_CURRENTSETTING_HTM))
    syslog(LOG_CRIT, "file:[%s] [%s]\n",file, FILE_CURRENTSETTING_HTM);
    if (file && (strcasestr(file, FILE_CURRENTSETTING_HTM)))
    {
        syslog(LOG_CRIT, "file:[here]\n");
        rewrite_currentsetting_file();
        fd = open( NEW_FILE_CURRENTSETTING_HTM, O_RDONLY );

		/*Add by Sudenghai 2014-8-26 Ҫ»ȡļԣЩʧܻlogic*/
        if(stat( NEW_FILE_CURRENTSETTING_HTM, &sb ) < 0)
        {
        	send_error( 404, "Not Found", "", "File not found." );

        	free(mime_encodings);
			free(fixed_mime_type);
			free(buf);
			close(fd);
			return;
        }
        /*End by Sudenghai 2014-8-26*/
    }
	else 
#endif
#if (defined(REWRITE_DEBUGINFO_HTM))
	if (file && (strcasestr(file, FILE_DEBUGINFO_HTM)))
	{
        syslog(LOG_CRIT, "debuginfo.htm:[here]\n");
        rewrite_debuginfo_file();
		
        fd = open( NEW_FILE_DEBUGINFO_HTM, O_RDONLY );
        if(stat( NEW_FILE_DEBUGINFO_HTM, &sb ) < 0)
        {
        	send_error( 404, "Not Found", "", "File not found." );

        	free(mime_encodings);
			free(fixed_mime_type);
			free(buf);
			close(fd);
			return;
        }
	}
	else
#endif
    fd = open( file, O_RDONLY );
    if ( fd < 0 )
	{
		syslog(
			LOG_INFO, "%.80s File \"%.80s\" is protected",
			ntoa( &client_addr ), path );
		free(mime_encodings);
		free(fixed_mime_type);
		free(buf);
		send_error( 403, "Forbidden", "", "File is protected." );
	}
    mime_type = figure_mime( file, mime_encodings,(5*SMALL_BUFF) );
    (void) snprintf(
	fixed_mime_type,(5*SMALL_BUFF), mime_type, charset );
    if ( if_modified_since != (time_t) -1 &&
	 if_modified_since >= sb.st_mtime )
	{
		add_headers(
			304, "Not Modified", "", mime_encodings, fixed_mime_type,
			(off_t) -1, sb.st_mtime );
		send_response();
		free(mime_encodings);
		free(fixed_mime_type);
		free(buf);
		close(fd);
		return;
	}
    add_headers(
	200, "Ok", "", mime_encodings, fixed_mime_type, sb.st_size,
	sb.st_mtime );
    send_response();
    if ( method == METHOD_HEAD )
    {
		free(mime_encodings);
		free(fixed_mime_type);
		free(buf);
		close(fd);
		return;
	}

    if ( sb.st_size > 0 )	/* ignore zero-length files */
	{
	#ifdef HAVE_SENDFILE

	#ifndef USE_SSL
		(void) my_sendfile( fd, conn_fd, 0, sb.st_size );
	#else /* USE_SSL */
		if ( do_ssl_child && do_ssl_con )
			send_via_write( fd, sb.st_size );
		else
			(void) my_sendfile( fd, conn_fd, 0, sb.st_size );
	#endif /* USE_SSL */

	#else /* HAVE_SENDFILE */

		send_via_write( fd, sb.st_size );

	#endif /* HAVE_SENDFILE */
	}
    (void) close( fd );
	free(mime_encodings);
	free(fixed_mime_type);
	free(buf);
}


static void
do_dir( void )
{
    char *buf;/*[10000]*/
    size_t buflen;
    char* contents;
    size_t contents_size, contents_len;
#ifdef HAVE_SCANDIR
    int n, i;
    struct dirent **dl;
    char* name_info;
#else /* HAVE_SCANDIR */
    char *command;/*[10000]*/
    FILE* fp;
	if((command=(char *)malloc(LARGE_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
#endif /* HAVE_SCANDIR */
	if((buf=(char *)malloc(LARGE_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
#ifndef HAVE_SCANDIR
		free(command);
#endif
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
    if ( pathinfo != (char*) 0 )
	{
#ifndef HAVE_SCANDIR
		free(command);
#endif
		free(buf);
		send_error( 404, "Not Found", "", "File not found." );
	}

	syslog(LOG_CRIT,"Inside do_dir");
    /* Check authorization for this directory. */
    auth_check( file );

#ifdef TR069
	if (do_tr69)
	{
#ifndef HAVE_SCANDIR
		free(command);
#endif
		free(buf);
		shutdown(child_accept_fd, SHUT_RDWR);
		syslog(LOG_WARNING, "shutdown 1882");
		httpd_cleanup();
		syslog(LOG_WARNING, "cleanup 1882");
#ifdef USE_SSL
		ssl_cleanup();
#endif
		return;
	}
#endif


    /* Referer check. */
    check_referer();

#ifdef HAVE_SCANDIR
    n = scandir( file, &dl, NULL, alphasort );
    if ( n < 0 )
	{
		syslog(
			LOG_INFO, "%.80s Directory \"%.80s\" is protected",
			ntoa( &client_addr ), path );
		free(buf);
		send_error( 403, "Forbidden", "", "Directory is protected." );
	}
#endif /* HAVE_SCANDIR */

    contents_size = 0;
    buflen = snprintf( buf,LARGE_BUFF, "\
<HTML>\n\
<HEAD><TITLE>Index of %s</TITLE></HEAD>\n\
<BODY BGCOLOR=\"#99cc99\" TEXT=\"#000000\" LINK=\"#2020ff\" VLINK=\"#4040cc\">\n\
<H4>Index of %s</H4>\n\
<PRE>\n",
	file, file );
    add_to_buf( &contents, &contents_size, &contents_len, buf, buflen );

#ifdef HAVE_SCANDIR

    for ( i = 0; i < n; ++i )
	{
		name_info = file_details( file, dl[i]->d_name );
		add_to_buf(
			&contents, &contents_size, &contents_len, name_info,
			strlen( name_info ) );
	}

#else /* HAVE_SCANDIR */
    /* Magic HTML ls command! */
    if ( strchr( file, '\'' ) == (char*) 0 )
	{
		(void) snprintf(
			command,LARGE_BUFF,
			"ls -lgF '%s' | tail +2 | sed -e 's/^\\([^ ][^ ]*\\)\\(  *[^ ][^ ]*  *[^ ][^ ]*  *[^ ][^ ]*\\)\\(  *[^ ][^ ]*\\)  *\\([^ ][^ ]*  *[^ ][^ ]*  *[^ ][^ ]*\\)  *\\(.*\\)$/\\1 \\3  \\4  |\\5/' -e '/ -> /!s,|\\([^*]*\\)$,|<A HREF=\"\\1\">\\1</A>,' -e '/ -> /!s,|\\(.*\\)\\([*]\\)$,|<A HREF=\"\\1\">\\1</A>\\2,' -e '/ -> /s,|\\([^@]*\\)\\(@* -> \\),|<A HREF=\"\\1\">\\1</A>\\2,' -e 's/|//'",
			file );
		fp = popen( command, "r" );
		for (;;)
		{
			size_t r;
			r = fread( buf, 1,LARGE_BUFF, fp );
			if ( r == 0 )
				break;
			add_to_buf( &contents, &contents_size, &contents_len, buf, r );
		}
		(void) pclose( fp );
	}
#endif /* HAVE_SCANDIR */

    buflen = snprintf( buf, LARGE_BUFF, "\
</PRE>\n\
<HR>\n\
<ADDRESS><A HREF=\"%s\">%s</A></ADDRESS>\n\
</BODY>\n\
</HTML>\n",
	SERVER_URL, SERVER_SOFTWARE );
    add_to_buf( &contents, &contents_size, &contents_len, buf, buflen );

    add_headers( 200, "Ok", "", "", "text/html; charset=%s", contents_len, sb.st_mtime );
    if ( method != METHOD_HEAD )
		add_to_response( contents, contents_len );
    send_response();
#ifndef HAVE_SCANDIR
	free(command);
#endif
#ifdef HAVE_SCANDIR
	if(name_info!=NULL)
		free(name_info);
#endif
	free(buf);
}


#ifdef HAVE_SCANDIR

static char*
file_details( const char* dir, const char* name )
{
    struct stat sb;
    char f_time[20];
    static char *encname;/*[1000]*/
    static char *buf;/*[2000]*/
	if((encname=(char *)malloc(MEDIUM_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		exit(1);
	}
	if((buf=(char *)malloc(2*MEDIUM_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		free(encname);
		exit(1);
	}

    (void) snprintf( buf,2*MEDIUM_BUFF, "%s/%s", dir, name );
    if ( lstat( buf, &sb ) < 0 )
	{
		free(encname);
		free(buf);
		return "???";
	}
    (void) strftime( f_time, sizeof( f_time ), "%d%b%Y %H:%M", localtime( &sb.st_mtime ) );
    strencode( encname,MEDIUM_BUFF, name );
    (void) snprintf(
	buf,2*MEDIUM_BUFF, "<A HREF=\"%s\">%-32.32s</A>    %15s %14lld\n",
	encname, name, f_time, (int64_t) sb.st_size );
	free(encname);
    return buf;
}


/* Copies and encodes a string. */
static void
strencode( char* to, size_t tosize, const char* from )
{
    int tolen;

    for ( tolen = 0; *from != '\0' && tolen + 4 < tosize; ++from )
	{
		if ( isalnum(*from) || strchr( "/_.-~", *from ) != (char*) 0 )
	    {
			*to = *from;
			++to;
			++tolen;
	    }
		else
	    {
			(void) sprintf( to, "%%%02x", (int) *from & 0xff );
			to += 3;
			tolen += 3;
	    }
	}
    *to = '\0';
}

#endif /* HAVE_SCANDIR */


static void
do_cgi( void )
{
    char** argp;
    char** envp;
    int parse_headers;
    char* binary;
    char* directory;
	if(1)
	{
	    char* binary1;
        char* directory1;
		directory1 = e_strdup( file );
		binary1 = strrchr( directory1, '/' );
		if ( binary1 == (char*) 0 )
			binary1 = file;
		else
		{
			*binary1++ = '\0';
			(void) chdir( directory1 );	/* ignore errors */
		}
		if(0 == strcmp(binary1,"webupg"))
		{
            g_iswebupg = 1;
		}
		else
		{
			g_iswebupg = 0;
		}

	}
    if ( method != METHOD_GET && method != METHOD_POST )
		send_error( 501, "Not Implemented", "", "That method is not implemented for CGI." );

    (void) fcntl( conn_fd, F_SETFD, 0 );

    /* If the socket happens to be using one of the stdin/stdout/stderr
    ** descriptors, move it to another descriptor so that the dup2 calls
    ** below don't screw things up.  We arbitrarily pick fd 3 - if there
    ** was already something on it, we clobber it, but that doesn't matter
    ** since at this point the only fd of interest is the connection.
    ** All others will be closed on exec.
    */
    if ( conn_fd == STDIN_FILENO || conn_fd == STDOUT_FILENO || conn_fd == STDERR_FILENO )
	{
		int newfd = dup2( conn_fd, STDERR_FILENO + 1 );
		if ( newfd >= 0 )
			conn_fd = newfd;
		/* If the dup2 fails, shrug.  We'll just take our chances.
		** Shouldn't happen though.
		*/
	}

    /* Make the environment vector. */
    envp = make_envp();
    /* Make the argument vector. */
    argp = make_argp();

	 /* Setting the process group ID here in the child thread.
	  * Let "webcm" and its children the CGI Interposer processes belong to the
	  * same process group. Parent "mini_httpd" needs to be running always
	  * as a daemon and is kept out of this process group.
	  */
    setpgrp();

    /* Set up stdin.  For POSTs we may have to set up a pipe from an
    ** interposer process, depending on if we've read some of the data
    ** into our buffer.  We also have to do this for all SSL CGIs.
    */
#ifdef USE_SSL
    if ( ( method == METHOD_POST && request_len > request_idx ) || do_ssl_child )
#else /* USE_SSL */
    if ( ( method == METHOD_POST && request_len > request_idx ) )
#endif /* USE_SSL */
	{
		int p[2];
		int r;
		int iRetryCount = 0;
		
		if(pipe( p ) < 0){
			send_error( 500, "Internal Error", "", "Something unexpected went wrong making a pipe." );
		}
		
try_fork_1:
		r = fork();
		if(r < 0){
			//fork ʧ֮³
			if(iRetryCount <= 3){
				iRetryCount++;
				//1sٳ
				sleep(1);
				//ת³fork
				goto try_fork_1;
			}
			send_error( 500, "Internal Error", "", "Something unexpected went wrong forking an interposer." );
		}
		
		if ( r == 0 )
		{
			/* Interposer process. */
			(void) close( p[0] );
			cgi_interpose_input( p[1] );
			close(child_accept_fd);
			ssl_cleanup();
			exit( 0 );
		}
		(void) close( p[1] );
		if ( p[0] != STDIN_FILENO )
		{
			(void) dup2( p[0], STDIN_FILENO );
			(void) close( p[0] );
		}
	}
    else
	{
	/* Otherwise, the request socket is stdin. */
		if ( conn_fd != STDIN_FILENO )
			(void) dup2( conn_fd, STDIN_FILENO );
	}

    /* Set up stdout/stderr.  For SSL, or if we're doing CGI header parsing,
    ** we need an output interposer too.
    */
    if ( safe_strncmp( argp[0], "nph-", 4 ) == 0 )
		parse_headers = 0;
    else
		parse_headers = 1;
#ifdef USE_SSL
    if ( parse_headers || do_ssl_child )
#else /* USE_SSL */
    if ( parse_headers )
#endif /* USE_SSL */
	{
		int p[2];
		int r;
		int iRetryCount = 0;
		
		if(pipe( p ) < 0){
			send_error( 500, "Internal Error", "", "Something unexpected went wrong making a pipe." );
		}
		
try_fork:
		r = fork();
		if ( r < 0 ){
			//fork ʧ֮³
			if(iRetryCount <= 3){
				iRetryCount++;
				//1sٳ
				sleep(1);
				//ת³fork
				goto try_fork;
			}
			send_error( 500, "Internal Error", "", "Something unexpected went wrong forking an interposer." );
		}
		
		if ( r == 0 )
		{
			/* Interposer process. */
			(void) close( p[1] );
			cgi_interpose_output( p[0], parse_headers );
			close(child_accept_fd);
			httpd_cleanup();
			ssl_cleanup();
			exit( 0 );
		}
		(void) close( p[0] );
		if ( p[1] != STDOUT_FILENO )
			(void) dup2( p[1], STDOUT_FILENO );
		if ( p[1] != STDERR_FILENO )
			(void) dup2( p[1], STDERR_FILENO );
		if ( p[1] != STDOUT_FILENO && p[1] != STDERR_FILENO )
			(void) close( p[1] );
	}
    else
	{
	/* Otherwise, the request socket is stdout/stderr. */
		if ( conn_fd != STDOUT_FILENO )
			(void) dup2( conn_fd, STDOUT_FILENO );
		if ( conn_fd != STDERR_FILENO )
			(void) dup2( conn_fd, STDERR_FILENO );
	}

    /* At this point we would like to set conn_fd to be close-on-exec.
    ** Unfortunately there seems to be a Linux problem here - if we
    ** do this close-on-exec in Linux, the socket stays open but stderr
    ** gets closed - the last fd duped from the socket.  What a mess.
    ** So we'll just leave the socket as is, which under other OSs means
    ** an extra file descriptor gets passed to the child process.  Since
    ** the child probably already has that file open via stdin stdout
    ** and/or stderr, this is not a problem.
    */
    /* (void) fcntl( conn_fd, F_SETFD, 1 ); */

    /* Close the log file. */
    if ( logfp != (FILE*) 0 )
		(void) fclose( logfp );

    /* Close syslog. */
    closelog();

    /* Set priority. */
    (void) nice( CGI_NICE );
    /* Split the program into directory and binary, so we can chdir()
    ** to the program's own directory.  This isn't in the CGI 1.1
    ** spec, but it's what other HTTP servers do.
    */
    directory = e_strdup( file );
    binary = strrchr( directory, '/' );
    if ( binary == (char*) 0 )
		binary = file;
    else
	{
		*binary++ = '\0';
		(void) chdir( directory );	/* ignore errors */
	}
    /* Default behavior for SIGPIPE. */
#ifdef HAVE_SIGSET
    (void) sigset( SIGPIPE, SIG_DFL );
#else /* HAVE_SIGSET */
    (void) signal( SIGPIPE, SIG_DFL );
#endif /* HAVE_SIGSET */

	(void) execve( binary, argp, envp );


    /* Something went wrong. */
    send_error( 500, "Internal Error", "", "Something unexpected went wrong running a CGI program." );
}


/* This routine is used only for POST requests.  It reads the data
** from the request and sends it to the child process.  The only reason
** we need to do it this way instead of just letting the child read
** directly is that we have already read part of the data into our
** buffer.
**
** Oh, and it's also used for all SSL CGIs.
*/
static void
cgi_interpose_input( int wfd )
{
    size_t c;
    ssize_t r, r2;
    char *buf;/*[1024]*/
	time_t upgradeFw_t_now;
	if(1 == g_iswebupg)
	    upgradeFw_t0 = time(NULL);
	if((buf=(char *)malloc(4*BUFF_SIZE))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
    c = request_len - request_idx;
    if ( c > 0 )
	{
		if ( write( wfd, &(request[request_idx]), c ) != c )
		{
			free(buf);
			if(1 != getppid())//webupg˳,̻1Ẓ̌ʱҪźţϵͳɹ
			    kill(getppid(), SIGUSR2);//򸸽̷ź  
			return;
		}
	}
    while ( c < content_length )
	{
	    if(1 == g_iswebupg)
	        upgradeFw_t_now = time(NULL);

		if((1==g_iswebupg) && ((upgradeFw_t_now-upgradeFw_t0)>120))//Ϊ120+40=160s
		{
			free(buf);
			
			if(1 != getppid())//webupg˳,̻1Ẓ̌ʱҪźţϵͳɹ
			    kill(getppid(), SIGUSR2);//򸸽̷ź  
			
			return;
		}

		if (1 == g_iswebupg)
			r = my_read_for_cig_input( buf, MIN(4*BUFF_SIZE, content_length - c ) );
		else
			r = my_read( buf, MIN(4*BUFF_SIZE, content_length - c ) );
		if ( r < 0 && ( errno == EINTR || errno == EAGAIN ) )
		{
			sleep( 1 );
			continue;
		}
		if ( r <= 0 )
		{
			free(buf);
			
			if(1 != getppid())//webupg˳,̻1Ẓ̌ʱҪźţϵͳɹ
			    kill(getppid(), SIGUSR2);//򸸽̷ź  
			
			return;
		}
		for (;;)
		{
			r2 = write( wfd, buf, r );
			if ( r2 < 0 && ( errno == EINTR || errno == EAGAIN ) )
			{
				sleep( 1 );
				continue;
			}
			if ( r2 != r )
			{
				free(buf);
				if(1 != getppid())//webupg˳,̻1Ẓ̌ʱҪźţϵͳɹ
				    kill(getppid(), SIGUSR2);//򸸽̷ź  
			
				return;
			}
			break;
		}
		c += r;
	}
    post_post_garbage_hack();
	free(buf);
			
}


/* Special hack to deal with broken browsers that send a LF or CRLF
** after POST data, causing TCP resets - we just read and discard up
** to 2 bytes.  Unfortunately this doesn't fix the problem for CGIs
** which avoid the interposer process due to their POST data being
** short.  Creating an interposer process for all POST CGIs is
** unacceptably expensive.
*/
static void
post_post_garbage_hack( void )
{
    char buf[2];

#ifdef USE_SSL
    if ( do_ssl_child && do_ssl_con )
	/* We don't need to do this for SSL, since the garbage has
	** already been read.  Probably.
	*/
		return;
#endif /* USE_SSL */

    set_ndelay( conn_fd );
    (void) read( conn_fd, buf, sizeof(buf) );
    clear_ndelay( conn_fd );
}


/*read*/
static ssize_t
nonblock_read(int rfd, char* buf, size_t size )
{
    fd_set fds;
    struct timeval tv;
    int iSelect = 0;
	
TRYONCE:
  	FD_ZERO(&fds);
    FD_SET(rfd, &fds);
    tv.tv_sec = 15;    /*ʱ15s*/
    tv.tv_usec = 0;
    iSelect = select(rfd + 1, &fds, NULL, NULL, &tv);
    if(iSelect <= 0)
	{
		if ( errno == EINTR || errno == EAGAIN)
		{
			goto TRYONCE;
		}
		
		return 0;
	}

    return read( rfd, buf, size);
}

/* This routine is used for parsed-header CGIs and for all SSL CGIs. */
static void
cgi_interpose_output( int rfd, int parse_headers )
{
    ssize_t r, r2;
    char *buf;/*[1024]*/

	if((buf=(char *)malloc(4*BUFF_SIZE))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
    if ( ! parse_headers )
	{
		/* If we're not parsing headers, write out the default status line
		** and proceed to the echo phase.
		*/
		char http_head[] = "HTTP/1.0 200 OK\015\012";
		(void) my_write( http_head, sizeof(http_head) );
	}
    else
	{
		/* Header parsing.  The idea here is that the CGI can return special
		** headers such as "Status:" and "Location:" which change the return
		** status of the response.  Since the return status has to be the very
		** first line written out, we have to accumulate all the headers
		** and check for the special ones before writing the status.  Then
		** we write out the saved headers and proceed to echo the rest of
		** the response.
		*/
		size_t headers_size, headers_len;
		char* headers;
		char* br;
		int status;
		char* title;
		char* cp;

		/* Slurp in all headers. */
		headers_size = 0;
		add_to_buf( &headers, &headers_size, &headers_len, (char*) 0, 0 );
		for (;;)
		{
            if(1 == g_iswebupg)
            {
			    r = read( rfd, buf, 4*BUFF_SIZE );  
            }
            else	
            {
				//ʹ÷read滻ʱweb޷ʣmini_httpd̿ס
				r = nonblock_read( rfd, buf, 4*BUFF_SIZE );
            }

			if ( r < 0 && ( errno == EINTR || errno == EAGAIN ) )
			{
				sleep( 1 );
				continue;
			}
			if ( r <= 0 )
			{
				br = &(headers[headers_len]);
				break;
			}
			add_to_buf( &headers, &headers_size, &headers_len, buf, r );
			if ( ( br = strstr( headers, "\015\012\015\012" ) ) != (char*) 0 ||
			 ( br = strstr( headers, "\012\012" ) ) != (char*) 0 )
				break;
		}

		/* If there were no headers, bail. */
		if ( headers[0] == '\0' )
		{
			free(buf);
			return;
		}

		/* Figure out the status. */
		status = 200;
		if ( ( cp = strstr( headers, "Location:" ) ) != (char*) 0 &&
			 cp < br &&
			 ( cp == headers || *(cp-1) == '\012' ) )
			status = 302;
		if ( ( cp = strstr( headers, "Status:" ) ) != (char*) 0 &&
			 cp < br &&
			 ( cp == headers || *(cp-1) == '\012' ) )
		{
			cp += 7;
			cp += strspn( cp, " \t" );
			status = atoi( cp );
		}

		/* Write the status line. */
		switch ( status )
		{
			case 200: title = "OK"; break;
			case 302: title = "Found"; break;
			case 304: title = "Not Modified"; break;
			case 400: title = "Bad Request"; break;
			case 401: title = "Unauthorized"; break;
			case 403: title = "Forbidden"; break;
			case 404: title = "Not Found"; break;
			case 408: title = "Request Timeout"; break;
			case 500: title = "Internal Error"; break;
			case 501: title = "Not Implemented"; break;
			case 503: title = "Service Temporarily Overloaded"; break;
			default: title = "Something"; break;
		}
		(void) snprintf(
			buf,4*BUFF_SIZE, "HTTP/1.0 %d %s\015\012", status, title );
		(void) my_write( buf, strlen( buf ) );

		/* Write the saved headers. */
		(void) my_write( headers, headers_len );
	}

    /* Echo the rest of the output. */
    for (;;)
	{
		if(1 == g_iswebupg)
		{
			r = read( rfd, buf, 4*BUFF_SIZE );	
		}
		else	
		{
			//ʹ÷read滻ʱweb޷ʣmini_httpd̿ס
			r = nonblock_read( rfd, buf, 4*BUFF_SIZE );
		}

		if ( r < 0 && ( errno == EINTR || errno == EAGAIN ) )
		{
			sleep( 1 );
			continue;
		}
		if ( r <= 0 )
			goto done;
		for (;;)
		{
			r2 = my_write( buf, r );
			if ( r2 < 0 && ( errno == EINTR || errno == EAGAIN ) )
			{
			sleep( 1 );
			continue;
			}
			if ( r2 != r )
			goto done;
			break;
		}
	}
    done:

	shutdown( conn_fd, SHUT_WR );
	free(buf);
}


/* Set up CGI argument vector.  We don't have to worry about freeing
** stuff since we're a sub-process.  This gets done after make_envp() because
** we scribble on query.
*/
static char**
make_argp( void )
{
    char** argp;
    int argn;
    char* cp1;
    char* cp2;

    /* By allocating an arg slot for every character in the query, plus
    ** one for the filename and one for the NULL, we are guaranteed to
    ** have enough.  We could actually use strlen/2.
    */
    argp = (char**) malloc( ( strlen( query ) + 2 ) * sizeof(char*) );
    if ( argp == (char**) 0 )
		return (char**) 0;

    argp[0] = strrchr( file, '/' );
    if ( argp[0] != (char*) 0 )
		++argp[0];
    else
		argp[0] = file;

    argn = 1;
    /* According to the CGI spec at http://hoohoo.ncsa.uiuc.edu/cgi/cl.html,
    ** "The server should search the query information for a non-encoded =
    ** character to determine if the command line is to be used, if it finds
    ** one, the command line is not to be used."
    */
    if ( strchr( query, '=' ) == (char*) 0 )
	{
		for ( cp1 = cp2 = query; *cp2 != '\0'; ++cp2 )
		{
			if ( *cp2 == '+' )
			{
				*cp2 = '\0';
				strdecode( cp1, cp1 );
				argp[argn++] = cp1;
				cp1 = cp2 + 1;
			}
		}
		if ( cp2 != cp1 )
		{
			strdecode( cp1, cp1 );
			argp[argn++] = cp1;
		}
	}

    argp[argn] = (char*) 0;
    return argp;
}


static int GetMacByIPFromArpTable(char *pszIp,char *pszMac)
{

    FILE *pHost = NULL;
    char szCmd[256] = { 0 };
    char szHostLine[256] = { 0 };
    char szIp[17] = { 0 };
    char szMac[18] = { 0 };
    unsigned int nMac[6] = { 0 };
    int iCount = 0;
    
    snprintf(szCmd, MAX_CMD_LEN, "arp -n -i br0 > /var/hosts.arp");
    system(szCmd);


     /* ʱļ*/
    pHost = fopen("/var/hosts.arp", "r");
    if ( NULL == pHost )
    {
        printf("minihttpd GetMacByIPFromArpTable() open /var/hosts.arp fail\n");
        return -1;
    }

    /* ѭȡÿһ̬Ϣ*/
    while ( NULL != fgets(szHostLine, MAX_LINE_LEN, pHost) )
    {
        if ( 2 != sscanf(szHostLine, "? (%16s at %17s", szIp, szMac) )
        {
            continue;
        }

        if(( strlen(szIp) > 0 ) && (NULL != pszIp))
        {
            szIp[ strlen(szIp) - 1 ] = '\0';
        
	        if(0 == strcmp(pszIp,szIp))
	        {
		        /* MAC ַǷЧ*/
		        iCount = sscanf(szMac, "%x:%x:%x:%x:%x:%x", &nMac[0], &nMac[1], &nMac[2], &nMac[3], &nMac[4], &nMac[5]);
		        if ( 6 != iCount )
		        {
		            printf("minihttpd GetMacByIPFromArpTable() Invalid mac\n");
		            continue;
		        }
				sprintf(pszMac,"%s",szMac);
				break;
	        }
		}
    }
    fclose(pHost);
    return 0;    
}



/* Set up CGI environment variables. Be real careful here to avoid
** letting malicious clients overrun a buffer.  We don't have
** to worry about freeing stuff since we're a sub-process.
*/
static char**
make_envp( void )
{
    static char* envp[50];
    int envn;
    char* cp;
    char *buf;/*[256]*/
	char szMac[18] = { 0 };
    envn = 0;
	if((buf=(char *)malloc(BUFF_SIZE))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
    if ( ! vhost )
	cp = hostname;
    else
	cp = req_hostname;	/* already computed by virtual_file() */
    if ( cp != (char*) 0 )
		envp[envn++] = build_env( "SERVER_NAME=%s", cp );
    envp[envn++] = "GATEWAY_INTERFACE=CGI/1.1";
    envp[envn++] = "SERVER_PROTOCOL=HTTP/1.0";
    (void) snprintf( buf,BUFF_SIZE, "%d", (int) port );
    envp[envn++] = build_env( "SERVER_PORT=%s", buf );
    envp[envn++] = build_env(
	"REQUEST_METHOD=%s", get_method_str( method ) );
    envp[envn++] = build_env( "SCRIPT_NAME=%s", path );
    if ( pathinfo != (char*) 0 )
	{
		envp[envn++] = build_env( "PATH_INFO=/%s", pathinfo );
		(void) snprintf( buf,BUFF_SIZE, "%s%s", cwd, pathinfo );
		envp[envn++] = build_env( "PATH_TRANSLATED=%s", buf );
	}
    if ( query[0] != '\0' )
		envp[envn++] = build_env( "QUERY_STRING=%s", query );
    envp[envn++] = build_env( "REMOTE_ADDR=%s", ntoa( &client_addr ) );
	GetMacByIPFromArpTable(ntoa( &client_addr ),szMac);

	envp[envn++] = build_env( "REMOTE_MACADDR=%s", szMac);
	
    if ( referer[0] != '\0' )
		envp[envn++] = build_env( "HTTP_REFERER=%s", referer );
    if ( useragent[0] != '\0' )
		envp[envn++] = build_env( "HTTP_USER_AGENT=%s", useragent );
    if ( cookie != (char*) 0 )
		envp[envn++] = build_env( "HTTP_COOKIE=%s", cookie );
    if ( host != (char*) 0 )
	envp[envn++] = build_env( "HTTP_HOST=%s", host );
    if ( content_type != (char*) 0 )
		envp[envn++] = build_env( "CONTENT_TYPE=%s", content_type );
    if ( content_length != -1 )
	{
		(void) snprintf(
			buf,BUFF_SIZE, "%lu", (unsigned long) content_length );
		envp[envn++] = build_env( "CONTENT_LENGTH=%s", buf );
	}
    if ( remoteuser != (char*) 0 )
		envp[envn++] = build_env( "REMOTE_USER=%s", remoteuser );
    if ( authorization != (char*) 0 )
		envp[envn++] = build_env( "AUTH_TYPE=%s", authorization );
    if ( getenv( "TZ" ) != (char*) 0 )
		envp[envn++] = build_env( "TZ=%s", getenv( "TZ" ) );
	if ( Language != (char*) 0 ) 
		envp[envn++] = build_env( "ACCEPT_LANGUAGE=%s", Language );
	envp[envn++] = build_env( "CGI_PATTERN=%s", cgi_pattern_tmp );
    envp[envn] = (char*) 0;
	free(buf);
    return envp;
}


static char*
build_env( char* fmt, char* arg )
{
    char* cp;
    int size;
    static char* buf;
    static int maxbuf = 0;

    size = strlen( fmt ) + strlen( arg );
    if ( size > maxbuf )
	{
		if ( maxbuf == 0 )
		{
			maxbuf = MAX( 200, size + 100 );
			buf = (char*) e_malloc( maxbuf );
		}
		else
		{
			maxbuf = MAX( maxbuf * 2, size * 5 / 4 );
			buf = (char*) e_realloc( (void*) buf, maxbuf );
		}
	}
    (void) snprintf( buf, maxbuf, fmt, arg );
    cp = e_strdup( buf );
    return cp;
}


static void
auth_check( char* dirname )
{
    char *authpath;//[10000]
    struct stat sb;
    char *authinfo;//[500]
    char* authpass;
    char* colon;
    static char *line;//[10000]
    int l;
    FILE* fp;
    char* cryp;
	char *value, *tok, *key, *dp, *sp;
	int	seenComma;
#ifdef TR069
	int	tr069SetMessageRetVal = 0 ; /* Added for TR-69 support */
#endif


	if((authpath=(char *)malloc(BUFF_SIZE*sizeof(char)))==NULL)
	{
		syslog(LOG_WARNING,"unable to allocate memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
	if((authinfo=(char *)malloc(SMALL_BUFF*sizeof(char)))==NULL)
	{
		syslog(LOG_WARNING,"unable to allocate memory exiting");
		free(authpath);
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
	if((line=(char *)malloc(LARGE_BUFF*sizeof(char)))==NULL)
	{
		syslog(LOG_WARNING,"unable to allocate memory exiting");
		free(authinfo);
		free(authpath);
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
#ifdef TR069
	if(do_tr69)
	{
		char 	*cnonce = NULL,
			*nc = NULL,
			*nonce= NULL,
			*opaque = NULL,
			*qop = NULL,
			*realm = NULL,
			*responseDigest = NULL,
			*uri = NULL,
			*userName = NULL,
			*digest1 = NULL,
			*tmp = NULL,
			*password = NULL ,
		  	*enableconn =NULL;

    /* Construct auth filename. */
    	if ( dirname[strlen(dirname) - 1] == '/' )
			(void) snprintf( authpath, BUFF_SIZE, "%s%s", dirname, AUTH_DGST_FILE );
    	else
			(void) snprintf( authpath, BUFF_SIZE, "%s/%s", dirname, AUTH_DGST_FILE );

			/* Does this directory have an auth file? */
    	if ( stat( authpath, &sb ) < 0 )
		{
		/* Nope, let the request go through. */
			free(authpath);
			free(authinfo);
			free(line);
			return;
		}
    /* Does this request contain authorization info? */

	    if ( authorization == (char*) 0 )
			/* Nope, return a 401 Unauthorized. */
			send_Digest();

		if ( safe_strncmp( authorization,"Digest ", 7 ) != 0 )
			send_Digest();

		userName = parse_digest(authorization,"username=");
		realm = parse_digest(authorization,"realm=");
		nonce = parse_digest(authorization,"nonce=");
		uri = parse_digest(authorization,"uri=");
		qop = parse_digest(authorization,"qop=");
		responseDigest = parse_digest(authorization,"response=");
		cnonce = parse_digest(authorization,"cnonce=");
		nc = parse_digest(authorization,"nc=");




#if 0
		/* Retreive password from file */
		fp = fopen( authpath, "r" );
		if ( fp == (FILE*) 0 )
		{
		/* The file exists but we can't open it?  Disallow access. */
			syslog(
				LOG_ERR, "%.80s auth file %.80s could not be opened - %m",
				ntoa( &client_addr ), authpath );
			free(authpath);
			free(authinfo);
			free(line);
			send_error( 403, "Forbidden", "", "File is protected." );
		}

    /* Read it. */
 		while ( fgets( line,LARGE_BUFF, fp ) != (char*) 0 )
		{
			/* Nuke newline. */
			l = strlen( line );
			if ( line[l - 1] == '\n' )
				line[l - 1] = '\0';
			/* Split into user and encrypted password. */
			cryp = strchr( line, ':' );
			tmp=cryp;
			tmp++;
			if ( cryp == (char*) 0 )
				continue;
			*cryp++ = '\0';
			if((user=(char *)malloc(cryp-line))==NULL)
			{
				syslog(LOG_WARNING,"unable to allocate memory:%d for user",cryp-line);
				free(authpath);
				free(authinfo);
				free(line);
				close(child_accept_fd);
				httpd_cleanup();
				ssl_cleanup();
				exit(1);
			}
			strncpy(user,line,(cryp-line));
			cryp++;
			cryp=strchr(cryp,':');
			if((realm=(char *)malloc(cryp-tmp))==NULL)
			{
				syslog(LOG_WARNING,"unable to allocate memory:%d for realm",cryp-tmp);
				free(authpath);
				free(authinfo);
				free(line);
				free(user);
				close(child_accept_fd);
				httpd_cleanup();
				ssl_cleanup();
				exit(1);
			}
			strncpy(realm,tmp,(cryp-tmp));
			if((password=(char *)malloc(strlen(cryp)))==NULL)
			{
				syslog(LOG_WARNING,"unable to allocate memory:%d for password",cryp);
				free(authpath);
				free(authinfo);
				free(line);
				free(user);
				free(realm);
				close(child_accept_fd);
				httpd_cleanup();
				ssl_cleanup();
				exit(1);
			}
			cryp++;
			strcpy(password,cryp);
			if(!safe_strcmp(user,userName))
				break;

		}
		fclose(fp);

#endif
		if(!safe_strcmp(userName, TR69_DEFAULT_USER))/* Case of default user*/
		{
			user = malloc(TR069_USER_NAME_LEN) ;
			if(!user)
			{
				syslog(LOG_ERR, "TR069Mini_httpd: Malloc Failure\n") ;
				exit(1) ;
			}
			memset(user, 0, TR069_USER_NAME_LEN) ;
			strcpy(user, TR69_DEFAULT_USER) ;

			password = malloc(TR069_USER_NAME_LEN) ;
			if(!password)
			{
				syslog(LOG_ERR, "TR069Mini_httpd: Malloc Failure\n") ;
				exit(1) ;
			}
			memset(password, 0, TR069_USER_NAME_LEN) ;
			strcpy(password, TR69_DEFAULT_PASSW) ;
		}
		else	/* Not a default user*/
		{
                     if(access(UP_FILE_NAME, F_OK) != 0) //UP file not found ,inform the tr069 proxy module to create it
                     {
				int ret = 0;
				char t_szBody[64] = {0};
				int t_iBodyLen = 0;
				ST_MSG *pstMsg = NULL;

				sprintf(t_szBody, "command/create_upfile");
				t_iBodyLen = strlen(t_szBody) + 1;
				pstMsg = MSG_CreateMessage(t_iBodyLen);
				if (NULL != pstMsg)
				{
					pstMsg->stMsgHead.usSrcMID = MID_TR069_HTTPD; //tr069 httpd
					pstMsg->stMsgHead.usDstMID = MID_TR069BE; //tr069 proxy module
					pstMsg->stMsgHead.ulMsgID = 0;
					pstMsg->stMsgHead.usMsgType = MSG_TR069_HTTPD_CREATE_UPFILE; //acs requests connection inform
					pstMsg->stMsgHead.ulBodyLength = t_iBodyLen;
					strcpy(pstMsg->szMsgBody, t_szBody);
					tr069SetMessageRetVal = MSG_SendMessage(pstMsg);
					if(tr069SetMessageRetVal < 0)
					{
						syslog(LOG_WARNING,"Error Sending message to start TR069\n");
					}
					else
					{
						syslog(LOG_WARNING,"message sent successfully\n");
					}
					MSG_ReleaseMessage(pstMsg);
					pstMsg = NULL;

                                   sleep(2); //wait 2 secs when tr069 proxy moudle is creating UP file
				}
				else
					syslog(LOG_DEBUG, "tr069_httpd :errors in building message.");
                     }

			enableconn = env_getvar(TR69_ENV_VAR_ENABLE) ;

			user = env_getvar(TR69_ENV_VAR_USER) ;
			
			if(!safe_strcmp(enableconn,"1")){

	        	        if(!user)    /* check if NULL is returned*/
				{
					syslog(LOG_ERR, "TR069Mini_httpd: Error reading the user name or user name not set\nUser - %s\n",user) ;
					exit(1) ;
				}

				else if(safe_strcmp(user,userName))	/* Unauthorised user*/
				{
					syslog(LOG_WARNING, "TR069Mini_httpd: Unauthorised user\nUser - %s\n", user) ;
					send_Digest() ;
				}
			}
			// Read Password now
			password = env_getvar(TR69_ENV_VAR_PASSW) ;
        	        if(!password) // check if NULL is returned
			{
				syslog(LOG_ERR, "TR069Mini_httpd: Error reading the password or password not set\n") ;
				exit(1) ;
				}
			
		}

/**Pass**/

		CalcDigest(userName,password,realm,uri,nonce,qop,nc,cnonce,method_type,&digest1);

		if(userName);
		free(userName);
		if(user);
			free(user);
		if(password);
		free(password);
		if(realm);
			free(realm);
		if(uri);
		free(uri);
		if(nonce);
		free(nonce);
		if(cnonce);
		free(cnonce);
		if(qop);
		free(qop);
		if(nc);
		free(nc);
		if(opaque);
		free(opaque);


		/* MT - free method_type is done here */
		if(method_type!=NULL)
			free(method_type);

		if(safe_strcmp(enableconn,"1")||!safe_strcmp(digest1,responseDigest))
		{
#ifdef TR069
			if(do_tr69)		// If the Auth is in case of ACS request to start TR069
			{
				/* Sending the empty response on auth success*/
				send_emptyResponse() ;
				#if 0
				tr069SetMessageRetVal = msgr_sendTransSet("miniHttpd", "tr069glue", "TR069_StartMessage_Group", "command/connect", NULL) ;
				#else
				{
				int ret = 0;
				char t_szBody[256] = {0};
				int t_iBodyLen = 0;
				ST_MSG *pstMsg = NULL;

				sprintf(t_szBody, "command/connect");
				t_iBodyLen = strlen(t_szBody) + 1;
				pstMsg = MSG_CreateMessage(t_iBodyLen);
				if (NULL != pstMsg)
				{
					pstMsg->stMsgHead.usSrcMID = MID_TR069_HTTPD; //tr069 httpd
					pstMsg->stMsgHead.usDstMID = MID_TR069BE; //tr069 proxy module
					pstMsg->stMsgHead.ulMsgID = 0;
					pstMsg->stMsgHead.usMsgType = MSG_TR069_HTTPD_CONNECT; //acs requests connection inform
					pstMsg->stMsgHead.ulBodyLength = t_iBodyLen;
					strcpy(pstMsg->szMsgBody, t_szBody);
					tr069SetMessageRetVal = MSG_SendMessage(pstMsg);
					if(tr069SetMessageRetVal < 0)
					{
						syslog(LOG_WARNING,"Error Sending message to start TR069\n");
					}
					else
					{
						syslog(LOG_WARNING,"message sent successfully\n");
					}
					MSG_ReleaseMessage(pstMsg);
					pstMsg = NULL;
				}
				else
					syslog(LOG_DEBUG, "tr069_httpd :errors in building message.");
			    }

				#endif
			}
#endif
		}
		else
		{
			syslog(LOG_WARNING,"XXX Digest Match Not Found\n");
			send_Digest();
		}
		if(authpath);
			free(authpath);
		if(authinfo);
			free(authinfo);
		if(line);
			free(line);
		if(digest1);
		free(digest1);
		if(responseDigest);
		free(responseDigest);
		return;
	}
#endif /* TR069 */
}


#ifdef TR069
/* Added for TR069 requirement of sending an empty response after the auth success*/
void send_emptyResponse()
{
	int buflen ;
    	time_t now, expires;
    	char *timebuf;/*[100]*/
    	char *buf ;/*[10000]*/
    	const char* rfc1123_fmt = "%a, %d %b %Y %H:%M:%S GMT";

	if((timebuf=(char *)malloc(SMALL_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
	if((buf=(char *)malloc(LARGE_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		free(timebuf);
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
	/* Adding the status line*/
        start_response();
        buflen = snprintf( buf,LARGE_BUFF, "HTTP/1.1 200 OK\015\012");
        add_to_response( buf, buflen );

	/* Adding the server name*/
        buflen = snprintf( buf,LARGE_BUFF, "Server: %s\015\012", SERVER_SOFTWARE );
        add_to_response( buf, buflen );

	/* Adding Time and date*/
        now = time( (time_t*) 0 );
        (void) strftime( timebuf,SMALL_BUFF, rfc1123_fmt, gmtime( &now ) );
        buflen = snprintf( buf,LARGE_BUFF, "Date: %s\015\012", timebuf );
        add_to_response( buf, buflen );

	/* Adding the content length header*/
	buflen = snprintf(buf,LARGE_BUFF, "Content-Length: %d\015\012", 0 );
	add_to_response( buf, buflen );

	/* Sending the empty response*/
	send_response() ;
	
	if(timebuf)
		free(timebuf);
	if(buf)
		free(buf);
}
#endif
/*********************************************************************************/


static void send_Digest(void)
{
    char *header;/*[10000]*/
    char *nonce_str;

	CalcNonce(&nonce_str);

	if((header=(char *)malloc(LARGE_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
	snprintf(header, LARGE_BUFF, "WWW-Authenticate: Digest realm=\"dirname\", nonce=\"%s\", uri=\"/\", opaque=\"0123456789987654\", algorithm=MD5, qop=auth", nonce_str);
	free(nonce_str);

    send_error( 401, "Unauthorized", header, "Authorization required." );
}

static void
send_authenticate( char* realm )
{
    char *header;/*[10000]*/
	if((header=(char *)malloc(LARGE_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
    (void) snprintf(
	header,LARGE_BUFF, "WWW-Authenticate: Basic realm=\"%s\"", realm );
    send_error( 401, "Unauthorized", header, "Authorization required." );
}


static char*
virtual_file( char* file )
{
    char* cp;
    static char *vfile;/*[10000]*/
	if((vfile=(char *)malloc(LARGE_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
    /* Use the request's hostname, or fall back on the IP address. */
    if ( host != (char*) 0 )
		req_hostname = host;
    else
	{
		usockaddr usa;
		int sz = sizeof(usa);
		if ( getsockname( conn_fd, &usa.sa, &sz ) < 0 )
			req_hostname = "UNKNOWN_HOST";
		else
			req_hostname = ntoa( &usa );
	}
    /* Pound it to lower case. */
    for ( cp = req_hostname; *cp != '\0'; ++cp )
		if ( isupper( *cp ) )
			*cp = tolower( *cp );
    (void) snprintf( vfile, sizeof(vfile), "%s/%s", req_hostname, file );
    return vfile;
}


static void
send_error( int s, char* title, char* extra_header, char* text )
{
    add_headers(
	s, title, extra_header, "", "text/html; charset=%s", (off_t) -1, (time_t) -1 );

    send_error_body( s, title, text );

    send_error_tail();

//MODIFY by 20120709
	send_response();
	if(NULL != extra_header)
		free(extra_header);

	close(child_accept_fd);
	httpd_cleanup();
	ssl_cleanup();
    exit( 1 );
}


static void
send_error_body( int s, char* title, char* text )
{
    char *filename;/*[1000]*/
    char *buf;/*[10000]*/
    int buflen;
	if((filename=(char *)malloc(MEDIUM_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
	if((buf=(char *)malloc(LARGE_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		free(filename);
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
    if ( vhost && req_hostname != (char*) 0 )
	{
		/* Try virtual-host custom error page. */
		(void) snprintf(
			filename,MEDIUM_BUFF, "%s/%s/err%d.html",
			req_hostname, ERR_DIR, s );
		if ( send_error_file( filename ) )
		{
			free(filename);
			free(buf);
			return;
		}
	}

    /* Try server-wide custom error page. */
    (void) snprintf(
	filename,MEDIUM_BUFF, "%s/err%d.html", ERR_DIR, s );
    if ( send_error_file( filename ) )
	{
		free(filename);
		free(buf);
		return;
	}

    /* Send built-in error page. */
    buflen = snprintf(
	buf, LARGE_BUFF, "\
<HTML>\n\
<HEAD><TITLE>%d %s</TITLE></HEAD>\n\
<BODY BGCOLOR=\"#cc9999\" TEXT=\"#000000\" LINK=\"#2020ff\" VLINK=\"#4040cc\">\n\
<H4>%d %s</H4>\n",
	s, title, s, title );
    add_to_response( buf, buflen );
    buflen = snprintf( buf,LARGE_BUFF, "%s\n", text );
    add_to_response( buf, buflen );
	free(filename);
	free(buf);
}


static int
send_error_file( char* filename )
{
    FILE* fp;
    char *buf;/*[1000]*/
    size_t r;
	if((buf=(char *)malloc(MEDIUM_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
    fp = fopen( filename, "r" );
    if ( fp == (FILE*) 0 )
	{
		free(buf);
		return 0;
	}
    for (;;)
	{
		r = fread( buf, 1,MEDIUM_BUFF, fp );
		if ( r == 0 )
			break;
		add_to_response( buf, r );
	}
    (void) fclose( fp );
	free(buf);
    return 1;
}


static void
send_error_tail( void )
{
    char *buf;/*[500];*/
    int buflen;
	if((buf=(char *)malloc(5*SMALL_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
    if ( match( "**MSIE**", useragent ) )
	{
		int n;
		buflen = snprintf( buf,5*SMALL_BUFF, "<!--\n" );
		add_to_response( buf, buflen );
		for ( n = 0; n < 6; ++n )
		{
			buflen = snprintf( buf,5*SMALL_BUFF, "Padding so that MSIE deigns to show this error instead of its own canned one.\n" );
			add_to_response( buf, buflen );
		}
		buflen = snprintf( buf,5*SMALL_BUFF, "-->\n" );
		add_to_response( buf, buflen );
	}

    buflen = snprintf( buf,5*SMALL_BUFF, "\
<HR>\n\
<ADDRESS><A HREF=\"%s\">%s</A></ADDRESS>\n\
</BODY>\n\
</HTML>\n",
	SERVER_URL, SERVER_SOFTWARE );
    add_to_response( buf, buflen );
	free(buf);
}


static void
add_headers( int s, char* title, char* extra_header, char* me, char* mt, off_t b, time_t mod )
{
    time_t now, expires;
    char *timebuf;/*[100]*/
    char *buf;/*[10000]*/
    int buflen;
    int s100;
    const char* rfc1123_fmt = "%a, %d %b %Y %H:%M:%S GMT";
	if((timebuf=(char *)malloc(SMALL_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
	if((buf=(char *)malloc(LARGE_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		free(timebuf);
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
    status = s;
    bytes = b;
    make_log_entry();
    start_response();
    buflen = snprintf( buf,LARGE_BUFF, "%s %d %s\015\012", protocol, status, title );
    add_to_response( buf, buflen );
    buflen = snprintf( buf,LARGE_BUFF, "Server: %s\015\012", SERVER_SOFTWARE );
    add_to_response( buf, buflen );
    now = time( (time_t*) 0 );
    (void) strftime( timebuf,SMALL_BUFF, rfc1123_fmt, gmtime( &now ) );
    buflen = snprintf( buf,LARGE_BUFF, "Date: %s\015\012", timebuf );
    add_to_response( buf, buflen );
    s100 = status / 100;
	
	/*add by wyh at 2015-09-29 to add the X-Frame-Option in the HTTP head to avoid the Clickjacking attack*/
	buflen = snprintf( buf,LARGE_BUFF, "X-Frame-Options : %s\015\012", "SAMEORIGIN");
	add_to_response( buf, buflen );
	/*add by wyh end*/
    if ( s100 != 2 && s100 != 3 )
	{
		buflen = snprintf( buf,LARGE_BUFF, "Cache-Control: no-cache,no-store\015\012" );
		add_to_response( buf, buflen );
	}
    if ( extra_header != (char*) 0 && extra_header[0] != '\0' )
	{
		buflen = snprintf( buf,LARGE_BUFF, "%s\015\012", extra_header );
		add_to_response( buf, buflen );
	}
    if ( me != (char*) 0 && me[0] != '\0' )
	{
		buflen = snprintf( buf,LARGE_BUFF, "Content-Encoding: %s\015\012", me );
		add_to_response( buf, buflen );
	}
    if ( mt != (char*) 0 && mt[0] != '\0' )
	{
		buflen = snprintf( buf,LARGE_BUFF, "Content-Type: %s\015\012", mt );
		add_to_response( buf, buflen );
	}
    if ( bytes >= 0 )
	{
		buflen = snprintf(
			buf,LARGE_BUFF, "Content-Length: %lld\015\012", (int64_t) bytes );
		add_to_response( buf, buflen );
	}
    if ( p3p != (char*) 0 && p3p[0] != '\0' )
	{
		buflen = snprintf( buf,LARGE_BUFF, "P3P: %s\015\012", p3p );
		add_to_response( buf, buflen );
	}
    if ( max_age >= 0 )
	{
		expires = now + max_age;
		(void) strftime(
			timebuf,SMALL_BUFF, rfc1123_fmt, gmtime( &expires ) );
		buflen = snprintf( buf,LARGE_BUFF,
			"Cache-Control: max-age=%d\015\012Expires: %s\015\012", max_age, timebuf );
		add_to_response( buf, buflen );
	}
    if ( mod != (time_t) -1 )
	{
		(void) strftime(
			timebuf,SMALL_BUFF, rfc1123_fmt, gmtime( &mod ) );
		buflen = snprintf( buf,LARGE_BUFF, "Last-Modified: %s\015\012", timebuf );
		add_to_response( buf, buflen );
	}
    buflen = snprintf( buf,LARGE_BUFF, "Connection: close\015\012\015\012" );
    add_to_response( buf, buflen );
	free(timebuf);
	free(buf);
}


static void
start_request( void )
{
    request_size = 0;
    request_idx = 0;
}

static void
add_to_request( char* str, size_t len )
{
    add_to_buf( &request, &request_size, &request_len, str, len );
}

static char*
get_request_line( void )
{
    int i;
    char c;

    for ( i = request_idx; request_idx < request_len; ++request_idx )
	{
		c = request[request_idx];
		if ( c == '\012' || c == '\015' )
		{
			request[request_idx] = '\0';
			++request_idx;
			if ( c == '\015' && request_idx < request_len &&
			 request[request_idx] == '\012' )
			{
				request[request_idx] = '\0';
				++request_idx;
			}
			return &(request[i]);
		}
	}
    return (char*) 0;
}


static char* response;
static size_t response_size, response_len;

static void
start_response( void )
{
    response_size = 0;
}

static void
add_to_response( char* str, size_t len )
{
    add_to_buf( &response, &response_size, &response_len, str, len );
}

static void
send_response( void )
{
    (void) my_write( response, response_len );
}


static void
send_via_write( int fd, off_t size )
{
    if ( size <= SIZE_T_MAX )
	{
		size_t size_size = (size_t) size;
		void* ptr = mmap( 0, size_size, PROT_READ, MAP_PRIVATE, fd, 0 );
		if ( ptr != (void*) -1 )
		{
			(void) my_write( ptr, size_size );
			(void) munmap( ptr, size_size );
		}
	#ifdef MADV_SEQUENTIAL
		/* If we have madvise, might as well call it.  Although sequential
		** access is probably already the default.
		*/
		//(void) madvise( ptr, size_size, MADV_SEQUENTIAL );
	#endif /* MADV_SEQUENTIAL */
	}
    else
	{
		/* mmap can't deal with files larger than 2GB. */
		char *buf;/*[30000]*/
		ssize_t r, r2;
		if((buf=(char *)malloc(3*LARGE_BUFF))==NULL)
		{
			syslog(LOG_CRIT,"out of memory exiting");
			close(child_accept_fd);
			httpd_cleanup();
			ssl_cleanup();
			exit(1);
		}
		for (;;)
		{
			r = read( fd, buf,3*LARGE_BUFF);
			if ( r < 0 && ( errno == EINTR || errno == EAGAIN ) )
			{
				sleep( 1 );
				continue;
			}
			if ( r <= 0 )
			{
				free(buf);
				return;
			}
			for (;;)
			{
				r2 = my_write( buf, r );
				if ( r2 < 0 && ( errno == EINTR || errno == EAGAIN ) )
				{
					sleep( 1 );
					continue;
				}
				if ( r2 != r )
				{
					free(buf);
					return;
				}
				break;
			}
		}
		free(buf);
	}
}


static ssize_t
my_read( char* buf, size_t size )
{
    fd_set fds;
    struct timeval tv;
    int iSelect = 0;

TRYONCE:
#ifdef USE_SSL
	if (do_ssl_child && do_ssl_con)
	{
		return SSL_read( ssl, buf, size );
	}
    else
//ֻʱγ
	{
		FD_ZERO(&fds);
		FD_SET(conn_fd, &fds);
		tv.tv_sec = 1;    /*ʱ1s, ݣûҪȵ̫ãҳ濨ľ*/
		tv.tv_usec = 0;
		iSelect = select(conn_fd + 1, &fds, NULL, NULL, &tv);
		//if (iSelect <= 0)
		//{
		//    return 0;
		//}
		if(iSelect <= 0)
		{
			if ( errno == EINTR || errno == EAGAIN)
			{
				goto TRYONCE;

			}
			return 0;
		}
		return read( conn_fd, buf, size );
	}
#else /* USE_SSL */

	//ֻʱγ
	/*Modify by Sudenghai 2014-5-19
	 ޸ĳʱʱΪ5s*/
#if 1
  	FD_ZERO(&fds);
    FD_SET(conn_fd, &fds);
    tv.tv_sec = 1;    /*ʱ1s, ݣûҪȵ̫ãҳ濨ľ*/
    tv.tv_usec = 0;
    iSelect = select(conn_fd + 1, &fds, NULL, NULL, &tv);
    if(iSelect <= 0)
	{
		if ( errno == EINTR || errno == EAGAIN)
		{
			goto TRYONCE;

		}
		return 0;
	}
		
#endif

    return read( conn_fd, buf, size );
#endif /* USE_SSL */
}
static ssize_t
my_read_for_cig_input( char* buf, size_t size )
{
    fd_set fds;
    struct timeval tv;
    int iSelect = 0;

TRYONCE:
	
#ifdef USE_SSL
    if ( do_ssl_child && do_ssl_con )
	{
		return SSL_read( ssl, buf, size );
	}
    else
//ֻʱγ
	{	
        FD_ZERO(&fds);
        FD_SET(conn_fd, &fds);
        tv.tv_sec = 15;    /*ʱ*/
        tv.tv_usec = 0;
        iSelect = select(conn_fd + 1, &fds, NULL, NULL, &tv);
        //if (iSelect <= 0)
        //{
        //    return 0;
        //}
        if(iSelect <= 0)
		{
			if ( errno == EINTR || errno == EAGAIN)
			{
				goto TRYONCE;

			}
			return 0;
		}
		
		
		return read( conn_fd, buf, size );
	}
#else /* USE_SSL */

	//ֻʱγ
	/*Modify by Sudenghai 2014-5-19
	 ޸ĳʱʱΪ5s*/
#if 1
  	FD_ZERO(&fds);
    FD_SET(conn_fd, &fds);
    tv.tv_sec = 40;    /*ʱ40s, ݣûҪȵ̫ãҳ濨ľ*/
    tv.tv_usec = 0;
    iSelect = select(conn_fd + 1, &fds, NULL, NULL, &tv);
    if(iSelect <= 0)
	{
		if ( errno == EINTR || errno == EAGAIN)
		{
			goto TRYONCE;

		}
		return 0;
	}
		
#endif

    return read( conn_fd, buf, size );
#endif /* USE_SSL */
}


static ssize_t
my_write( char* buf, size_t size )
{
#ifdef USE_SSL
    if ( do_ssl_child && do_ssl_con )
	{
		return SSL_write( ssl, buf, size );
	}
    else
	{
		return write( conn_fd, buf, size );
	}
#else /* USE_SSL */
	return write( conn_fd, buf, size );
#endif /* USE_SSL */
}


#ifdef HAVE_SENDFILE
static int
my_sendfile( int fd, int socket, off_t offset, size_t nbytes )
{
#ifdef HAVE_LINUX_SENDFILE
	off_t lo = offset;
	return sendfile( socket, fd, &lo, nbytes );
#else /* HAVE_LINUX_SENDFILE */
	return sendfile( fd, socket, offset, nbytes, (struct sf_hdtr*) 0, (off_t*) 0, 0 );
#endif /* HAVE_LINUX_SENDFILE */
}
#endif /* HAVE_SENDFILE */


static void
add_to_buf( char** bufP, size_t* bufsizeP, size_t* buflenP, char* str, size_t len )
{
    /* TBS_TAG: by laisimin 2011-2-10 Desc: ƽջΪBoardConfig.inжMINI_HTTPD_RECVBUFSIZEС */
    if( (*bufsizeP+len) >=  (MINI_HTTPD_RECVBUFSIZE*1024) )
    {
        return;
    }

    if ( *bufsizeP == 0 )
	{
		*bufsizeP = len + 500;
		*buflenP = 0;
		*bufP = (char*) e_malloc( *bufsizeP );
	}
    else if ( *buflenP + len >= *bufsizeP )
	{
		*bufsizeP = *buflenP + len + 500;
		*bufP = (char*) e_realloc( (void*) *bufP, *bufsizeP );
	}
    (void) memmove( &((*bufP)[*buflenP]), str, len );
    *buflenP += len;
    (*bufP)[*buflenP] = '\0';
}

static void ssl_exit(void)
{
#ifdef USE_SSL
	if(do_ssl)
	{
		if(ssl_ctx != NULL)
			SSL_CTX_free(ssl_ctx);
	}
#endif
}
void ssl_cleanup()
{
#ifdef USE_SSL
	if(do_ssl_child && do_ssl_con)
	{
		if(ssl != NULL)
			SSL_free(ssl);
	}
#endif
}

static void ssl_start(void)
{
	#ifdef USE_SSL
    if (do_ssl)
	{
		SSL_load_error_strings();
		SSLeay_add_ssl_algorithms();
		ssl_ctx = SSL_CTX_new( SSLv23_server_method() );
		if ( certfile[0] != '\0' && keyfile[0] != '\0')
			if ( SSL_CTX_use_certificate_file( ssl_ctx, certfile, SSL_FILETYPE_PEM ) == 0 ||
			 SSL_CTX_use_PrivateKey_file( ssl_ctx, keyfile, SSL_FILETYPE_PEM ) == 0 ||
			 SSL_CTX_check_private_key( ssl_ctx ) == 0 )
			{
				ERR_print_errors_fp( stderr );
				/* Free Fix */
				SSL_CTX_free(ssl_ctx);
				exit( 1 );
			}
		//if ( cipher != (char*) 0 )
		{
			//According to customer requirements, the mandatory cipher is as follows: AES128-SHA256, AES128-GCM-SHA256, AES256-GCM-SHA384 --2025/08/27
			const char* request_cipher = "AES128-SHA256:AES128-GCM-SHA256:AES256-GCM-SHA384";
			//if ( SSL_CTX_set_cipher_list( ssl_ctx, cipher ) == 0 )
			if ( SSL_CTX_set_cipher_list( ssl_ctx, request_cipher ) == 0 )
			{
				ERR_print_errors_fp( stderr );
				SSL_CTX_free(ssl_ctx);
				exit( 1 );
			}
		}
	}
#endif /* USE_SSL */
}

static void
make_log_entry( void )
{
    char* ru;
    char *url;/*[500]*/
    char bytes_str[40];
    time_t now;
    struct tm* t;
    const char* cernfmt_nozone = "%d/%b/%Y:%H:%M:%S";
    char *date_nozone;/*[100]*/
    int zone;
    char sign;
    char *date;/*[100]*/
	if((url=(char *)malloc(5*SMALL_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
	if((date_nozone=(char *)malloc(SMALL_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		free(url);
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
	if((date=(char *)malloc(SMALL_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		free(url);
		free(date_nozone);
		close(child_accept_fd);
		httpd_cleanup();
		ssl_cleanup();
		exit(1);
	}
    if ( logfp == (FILE*) 0 )
	{
		free(url);
		free(date_nozone);
		free(date);
		return;
	}

    /* Fill in some null values. */
    if ( protocol == (char*) 0 )
		protocol = "UNKNOWN";
    if ( path == (char*) 0 )
		path = "";
    if ( req_hostname == (char*) 0 )
		req_hostname = hostname;

    /* Format the user. */
    if ( remoteuser != (char*) 0 )
		ru = remoteuser;
    else
		ru = "-";
    now = time( (time_t*) 0 );
    /* If we're vhosting, prepend the hostname to the url.  This is
    ** a little weird, perhaps writing separate log files for
    ** each vhost would make more sense.
    */
    if ( vhost )
		(void) snprintf( url,5*SMALL_BUFF, "/%s%s", req_hostname, path );
    else
		(void) snprintf( url,5*SMALL_BUFF, "%s", path );
    /* Format the bytes. */
    if ( bytes >= 0 )
		(void) snprintf(
			bytes_str, sizeof(bytes_str), "%lld", (int64_t) bytes );
    else
		(void) strcpy( bytes_str, "-" );
    /* Format the time, forcing a numeric timezone (some log analyzers
    ** are stoooopid about this).
    */
    t = localtime( &now );
    (void) strftime( date_nozone,SMALL_BUFF, cernfmt_nozone, t );
#ifdef HAVE_TM_GMTOFF
    //zone = t->tm_gmtoff / 60L;
#else
    zone = - ( timezone / 60L );
    /* Probably have to add something about daylight time here. */
#endif
    if ( zone >= 0 )
		sign = '+';
    else
	{
		sign = '-';
		zone = -zone;
	}
    zone = ( zone / 60 ) * 100 + zone % 60;
    (void) snprintf( date,SMALL_BUFF, "%s %c%04d", date_nozone, sign, zone );
    /* And write the log entry. */
    (void) fprintf( logfp,
	"%.80s - %.80s [%s] \"%.80s %.200s %.80s\" %d %s \"%.200s\" \"%.200s\"\n",
	ntoa( &client_addr ), ru, date, get_method_str( method ), url,
	protocol, status, bytes_str, referer, useragent );
    (void) fflush( logfp );
	free(url);
	free(date_nozone);
	free(date);
}


/* Returns if it's ok to serve the url, otherwise generates an error
** and exits.
*/
static void
check_referer( void )
{
    char* cp;
	
    /* Are we doing referer checking at all? */
    if ( url_pattern == (char*) 0 )
		return;

    /* Is it ok? */
	if ( really_check_referer() )
		return;

    /* Lose. */
    if ( vhost && req_hostname != (char*) 0 )
		cp = req_hostname;
    else
		cp = hostname;
    if ( cp == (char*) 0 )
		cp = "";
    syslog(
	LOG_INFO, "%.80s non-local referer \"%.80s%.80s\" \"%.80s\"",
	ntoa( &client_addr ), cp, path, referer );
    send_error( 403, "Forbidden", "", "You must supply a local referer." );
}


/* Returns 1 if ok to serve the url, 0 if not. */
static int
really_check_referer( void )
{
    char* cp1;
    char* cp2;
    char* cp3;
    char* refhost;
    char *lp;

    /* Check for an empty referer. */
    if ( referer == (char*) 0 || referer[0] == '\0' ||
	 ( cp1 = strstr( referer, "//" ) ) == (char*) 0 )
	{
		/* Disallow if we require a referer and the url matches. */
		if ( no_empty_referers && match( url_pattern, path ) )
			return 0;
		/* Otherwise ok. */
		return 1;
	}
	
    /* Extract referer host. */
    cp1 += 2;
    for ( cp2 = cp1; *cp2 != '/' && *cp2 != ':' && *cp2 != '\0'; ++cp2 )
		continue;
    refhost = (char*) e_malloc( cp2 - cp1 + 1 );
    for ( cp3 = refhost; cp1 < cp2; ++cp1, ++cp3 )
		if ( isupper(*cp1) )
			*cp3 = tolower(*cp1);
		else
			*cp3 = *cp1;
    *cp3 = '\0';

    /* Local pattern? */
    if ( local_pattern != (char*) 0 )
		lp = local_pattern;
    else
	{
		/* No local pattern.  What's our hostname? */
		if ( ! vhost )
		{
			/* Not vhosting, use the server name. */
			lp = hostname;
			if ( lp == (char*) 0 )
			/* Couldn't figure out local hostname - give up. */
			{
				free(refhost);
				return 1;
			}
				
		}
		else
		{
			/* We are vhosting, use the hostname on this connection. */
			lp = req_hostname;
			if ( lp == (char*) 0 )
			/* Oops, no hostname.  Maybe it's an old browser that
			** doesn't send a Host: header.  We could figure out
			** the default hostname for this IP address, but it's
			** not worth it for the few requests like this.
			*/
			{
				free(refhost);
				return 1;
			}
		}
	}

    /* If the referer host doesn't match the local host pattern, and
    ** the URL does match the url pattern, it's an illegal reference.
    */
    if ( ! match( lp, refhost ) && match( url_pattern, path ) )
    {
    	free(refhost);
    	return 0;
    }
		
    /* Otherwise ok. */
	free(refhost);
    return 1;
}


static char*
get_method_str( int m )
{
    switch ( m )
	{
		case METHOD_GET: return "GET";
		case METHOD_HEAD: return "HEAD";
		case METHOD_POST: return "POST";
		default: return "UNKNOWN";
	}
}


struct mime_entry {
    char* ext;
    size_t ext_len;
    char* val;
    size_t val_len;
    };
static struct mime_entry enc_tab[] = {
#include "mime_encodings.h"
    };
static const int n_enc_tab = sizeof(enc_tab) / sizeof(*enc_tab);
static struct mime_entry typ_tab[] = {
#include "mime_types.h"
    };
static const int n_typ_tab = sizeof(typ_tab) / sizeof(*typ_tab);


/* qsort comparison routine - declared old-style on purpose, for portability. */
static int
ext_compare( a, b )
    struct mime_entry* a;
    struct mime_entry* b;
    {
    return safe_strcmp( a->ext, b->ext );
    }


static void
init_mime( void )
{

    int i;
    /* Sort the tables so we can do binary search. */
    qsort( enc_tab, n_enc_tab, sizeof(*enc_tab), ext_compare );
    qsort( typ_tab, n_typ_tab, sizeof(*typ_tab), ext_compare );

    /* Fill in the lengths. */

    for ( i = 0; i < n_enc_tab; ++i )
	{
		enc_tab[i].ext_len = strlen( enc_tab[i].ext );
		enc_tab[i].val_len = strlen( enc_tab[i].val );
	}
    for ( i = 0; i < n_typ_tab; ++i )
	{
		typ_tab[i].ext_len = strlen( typ_tab[i].ext );
		typ_tab[i].val_len = strlen( typ_tab[i].val );
	}
}


/* Figure out MIME encodings and type based on the filename.  Multiple
** encodings are separated by commas, and are listed in the order in
** which they were applied to the file.
*/
static const char*
figure_mime( char* name, char* me, size_t me_size )
{
    char* prev_dot;
    char* dot;
    char* ext;
    int me_indexes[100], n_me_indexes;
    size_t ext_len, me_len;
    int i, top, bot, mid;
    int r;
    const char* default_type = "text/plain; charset=%s";
    const char* type;

    /* Peel off encoding extensions until there aren't any more. */
    n_me_indexes = 0;
    for ( prev_dot = &name[strlen(name)]; ; prev_dot = dot )
	{
		for ( dot = prev_dot - 1; dot >= name && *dot != '.'; --dot )
			;
		if ( dot < name )
		{
			/* No dot found.  No more encoding extensions, and no type
			** extension either.
			*/
			type = default_type;
			goto done;
		}
		ext = dot + 1;
		ext_len = prev_dot - ext;
		/* Search the encodings table.  Linear search is fine here, there
		** are only a few entries.
		*/
		for ( i = 0; i < n_enc_tab; ++i )
		{
			if ( ext_len == enc_tab[i].ext_len && strncasecmp( ext, enc_tab[i].ext, ext_len ) == 0 )
			{
				if ( n_me_indexes < sizeof(me_indexes)/sizeof(*me_indexes) )
				{
					me_indexes[n_me_indexes] = i;
					++n_me_indexes;
				}
				goto next;
			}
		}
		/* No encoding extension found.  Break and look for a type extension. */
		break;

		next: ;
	}

    /* Binary search for a matching type extension. */
    top = n_typ_tab - 1;
    bot = 0;
    while ( top >= bot )
	{
		mid = ( top + bot ) / 2;
		r = strncasecmp( ext, typ_tab[mid].ext, ext_len );
		if ( r < 0 )
			top = mid - 1;
		else if ( r > 0 )
			bot = mid + 1;
		else
			if ( ext_len < typ_tab[mid].ext_len )
				top = mid - 1;
			else if ( ext_len > typ_tab[mid].ext_len )
				bot = mid + 1;
			else
			{
				type = typ_tab[mid].val;
				goto done;
			}
	}
    type = default_type;

    done:

    /* The last thing we do is actually generate the mime-encoding header. */
    me[0] = '\0';
    me_len = 0;
    for ( i = n_me_indexes - 1; i >= 0; --i )
	{
		if ( me_len + enc_tab[me_indexes[i]].val_len + 1 < me_size )
		{
			if ( me[0] != '\0' )
			{
				(void) strcpy( &me[me_len], "," );
				++me_len;
			}
			(void) strcpy( &me[me_len], enc_tab[me_indexes[i]].val );
			me_len += enc_tab[me_indexes[i]].val_len;
		}
	}

    return type;
}


static void
handle_sigterm( int sig )
{
    syslog( LOG_NOTICE, "exiting due to signal %d", sig );
	close(child_accept_fd);
	httpd_cleanup();
	ssl_exit();
    (void) fprintf( stderr, "%s: exiting due to signal %d\n", argv0, sig );
    closelog();
    exit( 1 );
}


/* SIGHUP says to re-open the log file. */
static void
handle_sighup( int sig )
{
    const int oerrno = errno;

#ifndef HAVE_SIGSET
    /* Set up handler again. */
    (void) signal( SIGHUP, handle_sighup );
#endif /* ! HAVE_SIGSET */

    /* Just set a flag that we got the signal. */
    got_hup = 1;

    /* Restore previous errno. */
    errno = oerrno;
}



static void
handle_sigchld( int sig )
{
    const int oerrno = errno;
    pid_t pid;
    int status;

#ifndef HAVE_SIGSET
    /* Set up handler again. */
    (void) signal( SIGCHLD, handle_sigchld );
#endif /* ! HAVE_SIGSET */
	/* Reap defunct children until there aren't any more. */
    for (;;)
	{
	#ifdef HAVE_WAITPID
		pid = waitpid( (pid_t) -1, &status, WNOHANG );
	#else /* HAVE_WAITPID */
		pid = wait3( &status, WNOHANG, (struct rusage*) 0 );
	#endif /* HAVE_WAITPID */
		if ( (int) pid == 0 )		/* none left */
			break;
		if ( (int) pid < 0 )
		{
			if ( errno == EINTR || errno == EAGAIN )
				continue;
			/* ECHILD shouldn't happen with the WNOHANG option,
			** but with some kernels it does anyway.  Ignore it.
			*/
			if ( errno != ECHILD )
			{
				syslog( LOG_ERR, "child wait - %m" );
				perror( "child wait" );
			}
			break;
	    }
#ifdef USE_SEM_SEMUN
		// gxw / 2015-11-11 / ӽ̵cgi򻥳		
		concurrency_cunt++;
#endif
	}

    /* Restore previous errno. */
    errno = oerrno;
}


static void
re_open_logfile( void )
{
    if ( logfp != (FILE*) 0 )
	{
		(void) fclose( logfp );
		logfp = (FILE*) 0;
	}
    if ( logfile != (char*) 0 )
	{
		syslog( LOG_NOTICE, "re-opening logfile" );
		logfp = fopen( logfile, "a" );
		if ( logfp == (FILE*) 0 )
		{
			syslog( LOG_CRIT, "%s - %m", logfile );
			perror( logfile );
			exit( 1 );
		}
	}
}


static void
handle_read_timeout( int sig )
{
    syslog( LOG_INFO, "%.80s connection timed out reading", ntoa( &client_addr ) );
    send_error(
	408, "Request Timeout", "",
	"No request appeared within a reasonable time period." );
}


static void
handle_write_timeout( int sig )
{
    syslog( LOG_INFO, "%.80s connection timed out writing", ntoa( &client_addr ) );
	close(child_accept_fd);
	httpd_cleanup();
	ssl_cleanup();
	exit( 1 );
}


#if 0
static void
lookup_hostname( usockaddr* usa4P, size_t sa4_len, int* gotv4P, usockaddr* usa6P, size_t sa6_len, int* gotv6P )
{
#ifdef USE_IPV6

    struct addrinfo hints;
    char portstr[10];
    int gaierr;
    struct addrinfo* ai;
    struct addrinfo* ai2;
    struct addrinfo* aiv6;
    struct addrinfo* aiv4;
    unsigned int pr_mark = 1;//MINIHTTPD_PR_MARK;

    (void) memset( &hints, 0, sizeof(hints) );
    hints.ai_family = PF_UNSPEC;
    hints.ai_flags = AI_PASSIVE;
    hints.ai_socktype = SOCK_STREAM;
    (void) snprintf( portstr, sizeof(portstr), "%d", (int) port );
    if ( (gaierr = getaddrinfo( hostname, portstr, &hints, &ai )) != 0 )
	{
		syslog(
			LOG_CRIT, "getaddrinfo %.80s - %s", hostname,
			gai_strerror( gaierr ) );
		(void) fprintf(
			stderr, "%s: getaddrinfo %.80s - %s\n", argv0, hostname,
			gai_strerror( gaierr ) );
		exit( 1 );
	}

    /* Find the first IPv6 and IPv4 entries. */
    aiv6 = (struct addrinfo*) 0;
    aiv4 = (struct addrinfo*) 0;
    for ( ai2 = ai; ai2 != (struct addrinfo*) 0; ai2 = ai2->ai_next )
	{
		switch ( ai2->ai_family )
		{
			case AF_INET6:
			if ( aiv6 == (struct addrinfo*) 0 )
			aiv6 = ai2;
			break;
			case AF_INET:
			if ( aiv4 == (struct addrinfo*) 0 )
			aiv4 = ai2;
			break;
		}
	}

    if ( aiv6 == (struct addrinfo*) 0 )
		*gotv6P = 0;
    else
	{
		if ( sa6_len < aiv6->ai_addrlen )
		{
			syslog(
			LOG_CRIT, "%.80s - sockaddr too small (%lu < %lu)",
			hostname, (unsigned long) sa6_len,
			(unsigned long) aiv6->ai_addrlen );
			(void) fprintf(
			stderr, "%s: %.80s - sockaddr too small (%lu < %lu)\n",
			argv0, hostname, (unsigned long) sa6_len,
			(unsigned long) aiv6->ai_addrlen );
			exit( 1 );
		}
		(void) memset( usa6P, 0, sa6_len );
		(void) memmove( usa6P, aiv6->ai_addr, aiv6->ai_addrlen );
		*gotv6P = 1;
	}

    if ( aiv4 == (struct addrinfo*) 0 )
		*gotv4P = 0;
    else
	{
		if ( sa4_len < aiv4->ai_addrlen )
		{
			syslog(
			LOG_CRIT, "%.80s - sockaddr too small (%lu < %lu)",
			hostname, (unsigned long) sa4_len,
			(unsigned long) aiv4->ai_addrlen );
			(void) fprintf(
			stderr, "%s: %.80s - sockaddr too small (%lu < %lu)\n",
			argv0, hostname, (unsigned long) sa4_len,
			(unsigned long) aiv4->ai_addrlen );
			exit( 1 );
		}
		(void) memset( usa4P, 0, sa4_len );
		(void) memmove( usa4P, aiv4->ai_addr, aiv4->ai_addrlen );
		*gotv4P = 1;
	}

    freeaddrinfo( ai );

#else /* USE_IPV6 */

    struct hostent* he;

    *gotv6P = 0;

    (void) memset( usa4P, 0, sa4_len );
    usa4P->sa.sa_family = AF_INET;
    if ( hostname == (char*) 0 )
		usa4P->sa_in.sin_addr.s_addr = htonl( INADDR_ANY );
    else
	{
		usa4P->sa_in.sin_addr.s_addr = inet_addr( hostname );
	if ( (int) usa4P->sa_in.sin_addr.s_addr == -1 )
	{

    /* Adding an option which allows to pass a mark value for a particular
     * socket. */
#if 0
	    he = gethostbyname( hostname );
	    if ( he == (struct hostent*) 0 )
		{
#ifdef HAVE_HSTRERROR
		syslog(
		    LOG_CRIT, "gethostbyname %.80s - %s", hostname,
		    hstrerror( h_errno ) );
		(void) fprintf(
		    stderr, "%s: gethostbyname %.80s - %s\n", argv0, hostname,
		    hstrerror( h_errno ) );
#else /* HAVE_HSTRERROR */
		syslog( LOG_CRIT, "gethostbyname %.80s failed", hostname );
		(void) fprintf(
		    stderr, "%s: gethostbyname %.80s failed\n", argv0,
		    hostname );
#endif /* HAVE_HSTRERROR */
		exit( 1 );
		}
#else
	    he = ti_gethostbyname(hostname, pr_mark);
	    if ( he == (struct hostent*) 0 )
		{
#ifdef HAVE_HSTRERROR
		syslog(
		    LOG_CRIT, "ti_gethostbyname %.80s - %s", hostname,
		    hstrerror( h_errno ) );
		(void) fprintf(
		    stderr, "%s: ti_gethostbyname %.80s - %s\n", argv0, hostname,
		    hstrerror( h_errno ) );
#else /* HAVE_HSTRERROR */
		syslog( LOG_CRIT, "ti_gethostbyname %.80s failed", hostname );
		(void) fprintf(
		    stderr, "%s: ti_gethostbyname %.80s failed\n", argv0,
		    hostname );
#endif /* HAVE_HSTRERROR */
		exit( 1 );
		}
#endif
	    if ( he->h_addrtype != AF_INET )
		{
		syslog( LOG_CRIT, "%.80s - non-IP network address", hostname );
		(void) fprintf(
		    stderr, "%s: %.80s - non-IP network address\n", argv0,
		    hostname );
		exit( 1 );
		}
	    (void) memmove(
		&usa4P->sa_in.sin_addr.s_addr, he->h_addr, he->h_length );
	    }
	}
    usa4P->sa_in.sin_port = htons( port );
    *gotv4P = 1;

#endif /* USE_IPV6 */
}
#endif


static char*
ntoa( usockaddr* usaP )
    {
#ifdef USE_IPV6
    static char *str;/*[200]*/
    unsigned int pr_mark = 1; //MINIHTTPD_PR_MARK;

	if((str=(char *)malloc(2*SMALL_BUFF))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		exit(1);
	}
    /* Adding an option which allows to pass a mark value for a particular
     * socket. */
#if 1
    if ( getnameinfo( &usaP->sa, sockaddr_len( usaP ), str, 2*SMALL_BUFF, 0, 0, NI_NUMERICHOST ) != 0 )
#else
    if (ti_getnameinfo(&usaP->sa, sockaddr_len(usaP), str, 2*SMALL_BUFF, 0, 0, NI_NUMERICHOST, pr_mark) != 0)
#endif
	{
	str[0] = '?';
	str[1] = '\0';
	}
    else if ( IN6_IS_ADDR_V4MAPPED( &usaP->sa_in6.sin6_addr ) && safe_strncmp( str, "::ffff:", 7 ) == 0 )
	/* Elide IPv6ish prefix for IPv4 addresses. */
	(void) strcpy( str, &str[7] );

    return str;

#else /* USE_IPV6 */

    return inet_ntoa( usaP->sa_in.sin_addr );

#endif /* USE_IPV6 */
    }


static int
sockaddr_check( usockaddr* usaP )
    {
    switch ( usaP->sa.sa_family )
	{
	case AF_INET: return 1;
#ifdef USE_IPV6
	case AF_INET6: return 1;
#endif /* USE_IPV6 */
	default:
	return 0;
	}
    }


static size_t
sockaddr_len( usockaddr* usaP )
    {
    switch ( usaP->sa.sa_family )
	{
	case AF_INET: return sizeof(struct sockaddr_in);
#ifdef USE_IPV6
	case AF_INET6: return sizeof(struct sockaddr_in6);
#endif /* USE_IPV6 */
	default:
	return 0;	/* shouldn't happen */
	}
    }


/* Copies and decodes a string.  It's ok for from and to to be the
** same string.
*/
static void
strdecode( char* to, char* from )
    {
    for ( ; *from != '\0'; ++to, ++from )
	{
	if ( from[0] == '%' && isxdigit( from[1] ) && isxdigit( from[2] ) )
	    {
	    *to = hexit( from[1] ) * 16 + hexit( from[2] );
	    from += 2;
	    }
	else
	    *to = *from;
	}
    *to = '\0';
    }


static int
hexit( char c )
    {
    if ( c >= '0' && c <= '9' )
	return c - '0';
    if ( c >= 'a' && c <= 'f' )
	return c - 'a' + 10;
    if ( c >= 'A' && c <= 'F' )
	return c - 'A' + 10;
    return 0;           /* shouldn't happen, we're guarded by isxdigit() */
    }


/* Base-64 decoding.  This represents binary data as printable ASCII
** characters.  Three 8-bit binary bytes are turned into four 6-bit
** values, like so:
**
**   [11111111]  [22222222]  [33333333]
**
**   [111111] [112222] [222233] [333333]
**
** Then the 6-bit values are represented using the characters "A-Za-z0-9+/".
*/

static int b64_decode_table[256] = {
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,  /* 00-0F */
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,  /* 10-1F */
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,62,-1,-1,-1,63,  /* 20-2F */
    52,53,54,55,56,57,58,59,60,61,-1,-1,-1,-1,-1,-1,  /* 30-3F */
    -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9,10,11,12,13,14,  /* 40-4F */
    15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,  /* 50-5F */
    -1,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,  /* 60-6F */
    41,42,43,44,45,46,47,48,49,50,51,-1,-1,-1,-1,-1,  /* 70-7F */
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,  /* 80-8F */
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,  /* 90-9F */
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,  /* A0-AF */
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,  /* B0-BF */
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,  /* C0-CF */
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,  /* D0-DF */
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,  /* E0-EF */
    -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1   /* F0-FF */
    };

/* Do base-64 decoding on a string.  Ignore any non-base64 bytes.
** Return the actual number of bytes generated.  The decoded size will
** be at most 3/4 the size of the encoded, and may be smaller if there
** are padding characters (blanks, newlines).
*/
static int
b64_decode( const char* str, unsigned char* space, int size )
    {
    const char* cp;
    int space_idx, phase;
    int d, prev_d = 0;
    unsigned char c;

    space_idx = 0;
    phase = 0;
    for ( cp = str; *cp != '\0'; ++cp )
	{
	d = b64_decode_table[(int) *cp];
	if ( d != -1 )
	    {
	    switch ( phase )
		{
		case 0:
		++phase;
		break;
		case 1:
		c = ( ( prev_d << 2 ) | ( ( d & 0x30 ) >> 4 ) );
		if ( space_idx < size )
		    space[space_idx++] = c;
		++phase;
		break;
		case 2:
		c = ( ( ( prev_d & 0xf ) << 4 ) | ( ( d & 0x3c ) >> 2 ) );
		if ( space_idx < size )
		    space[space_idx++] = c;
		++phase;
		break;
		case 3:
		c = ( ( ( prev_d & 0x03 ) << 6 ) | d );
		if ( space_idx < size )
		    space[space_idx++] = c;
		phase = 0;
		break;
		}
	    prev_d = d;
	    }
	}
    return space_idx;
    }


/* Set NDELAY mode on a socket. */
static void
set_ndelay( int fd )
    {
    int flags, newflags;

    flags = fcntl( fd, F_GETFL, 0 );
    if ( flags != -1 )
	{
	newflags = flags | (int) O_NDELAY;
	if ( newflags != flags )
	    (void) fcntl( fd, F_SETFL, newflags );
	}
    }


/* Clear NDELAY mode on a socket. */
static void
clear_ndelay( int fd )
    {
    int flags, newflags;

    flags = fcntl( fd, F_GETFL, 0 );
    if ( flags != -1 )
	{
	newflags = flags & ~ (int) O_NDELAY;
	if ( newflags != flags )
	    (void) fcntl( fd, F_SETFL, newflags );
	}
    }


static void*
e_malloc( size_t size )
    {
    void* ptr;

    ptr = malloc( size );
    if ( ptr == (void*) 0 )
	{
	syslog( LOG_CRIT, "out of memory" );
	(void) fprintf( stderr, "%s: out of memory\n", argv0 );

	exit( 1 );
	}
    return ptr;
    }


static void*
e_realloc( void* optr, size_t size )
    {
    void* ptr;

    ptr = realloc( optr, size );
    if ( ptr == (void*) 0 )
	{
	syslog( LOG_CRIT, "out of memory" );
	(void) fprintf( stderr, "%s: out of memory\n", argv0 );
	exit( 1 );
	}
    return ptr;
    }


static char*
e_strdup( char* ostr )
    {
    char* str;

    str = strdup( ostr );
    if ( str == (char*) 0 )
	{
	syslog( LOG_CRIT, "out of memory copying a string" );
	(void) fprintf( stderr, "%s: out of memory copying a string\n", argv0 );
	exit( 1 );
	}
    return str;
    }
int get_interface(void)
{
	struct ifreq* 		ptr_ifr;
	struct sockaddr_in*	ptr_sockaddress;
	struct ifreq 		ifr;
	int					sock;
	struct ifconf		ifcfg;
	char*				limit;
	char*				cp;
	char				*buffer;/*[1024]*/
	if((buffer=(char *)malloc(4*BUFF_SIZE))==NULL)
	{
		syslog(LOG_CRIT,"out of memory exiting");
		ssl_exit();
		exit(1);
	}
	/* Create a socket just for retrieving network list. */
	sock = socket (PF_INET, SOCK_STREAM, 0);
	if (sock < 0)
	{
		syslog(LOG_WARNING,"XXX\tUnable To open Socket\n");
		free(buffer);
		return -1;
	}
	/* Initialize the structure. */
	memset ((void *)&ifcfg, 0, sizeof(ifcfg));
	ifcfg.ifc_len 	= 4*BUFF_SIZE;
	ifcfg.ifc_buf 	= buffer;
	/* Get list of network interfaces present in the system. */
    if (ioctl(sock, SIOCGIFCONF, (void*)&ifcfg) < 0)
	{
		syslog(LOG_WARNING,"XXX\tUnable To get the list of interfaces\n");
		free(buffer);
		close(sock);
		return -1;
	}
	/* Get the pointer to the last interface data that can be present. */
	limit = buffer + ifcfg.ifc_len;

	/* Cycle through all the interfaces */
	for (cp = buffer; cp < limit; cp = cp + sizeof (ptr_ifr->ifr_name) + sizeof(ptr_ifr->ifr_ifru))
	{
		ptr_ifr = (struct ifreq *)cp;
		if(ifcnt==0)
		{
			ifcnt++;
			continue;
		}
		/* Get the pointer to the socket address. */
		ptr_sockaddress = (struct sockaddr_in *)&ptr_ifr->ifr_ifru.ifru_addr;
		strcpy(inf[ifcnt-1].infaddr,inet_ntoa(ptr_sockaddress->sin_addr));
		strcpy(inf[ifcnt-1].infname,ptr_ifr->ifr_ifrn.ifrn_name);
		ifcnt++;
	}
	close(sock);
	free(buffer);
	return 0;
}

char *parse_digest(char *parsestr,char *name)
{
        char *str,*chr,*result;
        int skip;
        int flag=0;
        str=strstr(parsestr,name);
        skip=strspn(str,name);
        str=(str)+skip;

        if(!safe_strcmp(name,"nc="))
        {
                result=(char *)malloc(9*sizeof(char));
                memset(result,0,9);
                if ('"' == str[0])
                {
                    str++;
                }
                strncpy(result,str,8);
                return &result[0];
        }
        else if(!safe_strcmp(name,"qop="))
        {

            if(str[0] == '"')
        	{
                chr=strchr(str,'"');
                chr++;
                str=chr;
                chr=strchr(str,'"');
                skip=chr-str;
                result=(char *)malloc((skip+1)*sizeof(char));
                strncpy(result,str,skip);
                result[skip]='\0';
                return &result[0];
        	}
        	else
            {
                chr=strchr(str,',');
                skip=chr-str;
                result=(char *)malloc((skip+1)*sizeof(char));
                strncpy(result,str,skip);
                result[skip]='\0';
                return &result[0];

            }

        }
        else
        {
			chr=strchr(str,'"');
            chr++;
            str=chr;
            chr=strchr(str,'"');
            skip=chr-str;
            result=(char *)malloc((skip+1)*sizeof(char));
            strncpy(result,str,skip);
            result[skip]='\0';
            return &result[0];
        }
}

static void httpd_cleanup(void)
{
	int cnt = 0;

	for(cnt = 0; cnt < max_services; cnt++) {
		close(fds[cnt]);
	}
}

#ifdef NO_SNPRINTF
/* Some systems don't have snprintf(), so we make our own that uses
** vsprintf().  This workaround is probably vulnerable to buffer overruns,
** so upgrade your OS!
*/
static int
snprintf( char* str, size_t size, const char* format, ... )
    {
    va_list ap;
    int r;

    va_start( ap, format );
    r = vsprintf( str, format, ap );
    va_end( ap );
    return r;
    }
#endif /* NO_SNPRINTF */

#if 0

char*
read_env_str(
        const char * varname,           /* Name of the variable to search */
        const char * result,            /* Put it in this place */
        int len                         /* Don't exceed this much space */
) {
        char * buf;
        char * vptr ;
        int fd ;
        int res ;

        printf("read_env_str: var [%s]\n", varname ) ;

        fd = open(UP_FILE_NAME, O_RDONLY);
        if (fd < 0) return NULL ;

        buf = (char *) malloc( ENV_FILE_LEN ) ;
        if( !buf ) return NULL ;

        if ((res = read(fd, buf, ENV_FILE_LEN-1)) == -1)
        {
                close(fd);
                return NULL ;
        }
        close(fd);
        buf[res] = 0;

        if ((vptr=strstr(buf, varname)) != NULL)
        {
                vptr = strchr(vptr, '\t');
                if (vptr == NULL)
                {
                        printf("TR69Mini_httpd ERROR: Incorrect format for env var %s\n", varname);
                        free( buf ) ;
                        return NULL;
                }
                ++vptr ;
                res = strncpy(result, vptr, len);
                if (res < 1) { printf ("TR69Mini_httpd: ERROR reading env in buffer\n"); free(buf) ; return NULL ; }
                free( buf ) ;
                return result;
        }
        return NULL ;
}
#endif
char *env_getvar(char *name)
{
	char *str = 0;
	int res;
	char *buf = 0, *ptr;
	char *pos, *pos1;
	int fd;

	fd = open(UP_FILE_NAME, O_RDONLY);
	if(fd < 0)
		goto a2exit;

	buf = malloc(BUF_SIZE);
	if(!buf)
		goto a2exit;

	res = read(fd, buf, BUF_SIZE-1);
	if(res <= 0)
		goto a2exit;

	buf[res] = 0;
	ptr = buf;
	while((pos = strchr(ptr, '\n')))
	{
		*pos = 0;
		pos++;
		pos1 = strchr(ptr, '\t');
		if(pos1)
		{
			*pos1 = 0;
			pos1++;
			if(!safe_strcmp(ptr, name))
				str = strdup(pos1);
		}
		ptr = pos;
	}

a2exit:
	close(fd);
	if(buf)
		free(buf);

	return str;
}

int safestrcmp(const char *s1, const char *s2)
{
	if(!s1 && !s2)
		return 0;
	if(!s1)
		return -1;
	if(!s2)
		return 1;
	return strcmp(s1, s2);
}

int	safestrncmp(const char *s1, const char *s2, size_t n)
{
	if(!s1 && !s2)
		return 0;
	if(!s1)
		return -1;
	if(!s2)
		return 1;
	return strncmp(s1, s2, n);
}
