/*
 * Common framework for low-level network console, dump, and debugger code
 *
 * May 16 2014  rongwei <rongwei@twsz.com>
 *
 * based on the netconsole code from:
 *
 * Copyright (C) 2014  T&W, Inc.
 */

/*****************************************************************************
*                                 MACRO                                      *
******************************************************************************/
#define NL_TBS_WLAN0_PID_ENTRY_NAME		"nl_pid_wl0"	/* pid entry name for 2.4G band */
#define NL_TBS_WLAN1_PID_ENTRY_NAME		"nl_pid_wl1"	/* pid entry name for 5.8G band */

/*****************************************************************************
*                                 ENUM                                       *
******************************************************************************/
/* private netlink operate command list */
enum {
	NL_CMD_WLAN_WSC_STATUS_CHG,	/* wps status change from unconfigured to configured */
	NL_CMD_WLAN_WSC_LOACALPIN_START,
	NL_CMD_WLAN_WSC_LOACALPIN_FAIL,
	NL_CMD_URL_HIJACK_CNT
};

/******************************************************************************
 *                                FUNCTION DECLARE                            *
 ******************************************************************************/
extern int tbs_netlink_send_msg( int cmd, char *content );
extern int tbs_netlink_sock_create( int protocol, char *pid_entry_name );
extern void tbs_netlink_sock_destroy( char *pid_entry_name );

