/*=========================================================================
 Copyright (c), 1991-2007, T&W ELECTRONICS(SHENTHEN) Co., Ltd.
 ļ : flash_layout_kernel.c
 ļ : flash layoutز

 б :
				sysdata_get
				sysdata_save
				item_get
				item_save
				item_repeat
				flash_update_bin
				flash_update_img				

 ޶¼ :
          1  : 
             : 2008-7-22
             :

          2 ޶: 
             : 2008-9-10
             : ϢΪĿ

           3 ޶: 
             : 2009-2-18
             : BIN file

           4 ޶: 
             : 2009-3-16
             : ŻĿĲ

           5 ޶: 
             : 2009-5-18
             : Ż

           6޶: 
             : 2012-04-01
             : binļʱmib_rfMACssnĹ

=========================================================================*/

#include <linux/syscalls.h>
#include <linux/vmalloc.h>
#include <linux/flash_layout_kernel.h>
#include "autoconf.h"

#define READ_ITEM_LEN ( 0x1000 )
#define MAX_FLASH_LEN (3932159)    //4M-256K

/*add by huangshuangbang 20120602 for save mib_rf and mac when update bin start*/
#ifdef BACKUP_ITEM_MIB_RF_MAC
static llconfig_syscfg_t syscfg;
static void  llconfig_get_syscfg(  llconfig_syscfg_t *data);
static void  llconfig_set_syscfg(  llconfig_syscfg_t *data);
#endif
#ifdef CONFIG_FLASH_WRITE_PROTECT
 extern char kernal_flash_protect(char isEnable);
#endif
/*add by huangshuangbang 20120602 for save mib_rf and mac when update bin end*/

#ifdef CONFIG_APPS_LOGIC_NMRP
/*add by wyh start at 20140624 to add WIFI NMRP upgrade wirte flash interface*/
mm_segment_t		 g_fs;
struct mtd_info		*g_mtd;
struct mtd_part		*g_part ;
flash_info_t		*g_info;
sys_config_t		*g_sys_data;
update_hdr_t		*g_update_hdr;
unsigned int		 g_start = 0 ;
unsigned int		 g_end = 0;
/*add by wyh end*/
#endif

/*=========================================================================
Ŀдź
=========================================================================*/

DECLARE_MUTEX(item_sem);



/*=========================================================================
 Function:		int  sysdata_get( sys_config_t* syscfg )
 Description:		ȡײllconfig
 Data Accessed:
 Data Updated:
 Input:			
 Output:			
 Return:			0:ɹ
				1:ʧ
 Others:
 				ô˺ǰΪsyscfgڴռ
=========================================================================*/

int  sysdata_get(sys_config_t* syscfg)
{
	unsigned short item_len;
	int ret;

	item_len = SYSCFG_SIZE;
	ret = item_get( syscfg, LLCONFIG_NAME , &item_len );
	if( ret == ERROR_ITEM_OK )
	{
		return 0;
	}
	return 1;
}

/*=========================================================================
 Function:		int  sysdata_save(sys_config_t * syscfg)
 Description:		ײllconfig
 Data Accessed:
 Data Updated:
 Input:			
 Output:			
 Return:			0:ɹ
				1:ʧ
 Others: 				
=========================================================================*/

int  sysdata_save(sys_config_t * 	syscfg)
{
	if( item_save( syscfg , LLCONFIG_NAME , SYSCFG_SIZE ) == ERROR_ITEM_OK )
	{
		return 0;
	}
	return 1;
}
/*=========================================================================
 Function:		int item_check( void )

 Description:		ÿĿ
 Data Accessed:
 Data Updated:
 Input:
 Output:
 Return:			ERROR_ITEM_OK
				ERROR_CONFIG_LOST
 Others:
=========================================================================*/

int item_check( flash_info_t* flash_info_low , struct mtd_info *mtd_master  )
{
	item_t			*item;
	unsigned short	checksum;
	unsigned int		i = 0;
	unsigned int		sum = 0;
	unsigned int		retlen;
	unsigned char		*item_sdram;

		/* ҵFlashʼַ*/	
	while( ( flash_info_low->start[i] - flash_info_low->start[0] ) < BOOTCODE_LENGTH )
		i++;
		
	item_sdram = vmalloc( flash_info_low->start[i+1] - flash_info_low->start[i] );
	if ( item_sdram == NULL )
	{		
		printk("item_sdram malloc wrong\n");
		
		return ERROR_ITEM_MALLOC;
	}
	
	mtd_master->read( mtd_master , flash_info_low->start[i] , (flash_info_low->start[i+1] - flash_info_low->start[i]) , &retlen, item_sdram );

	sum = CONFIG_MARK_LEN;
	while( ( sum + ITEM_HEAD_LEN ) <= ( flash_info_low->start[i+1] - flash_info_low->start[i] ) )
	{
		//mtd_master->read( mtd_master , flash_info_low->start[i] + sum , READ_ITEM_LEN , &retlen, item_sdram );
		
		item = ( item_t * ) ( item_sdram + sum );
		//item = ( item_t * ) ( item_sdram );
		
		if( item->hdr.avail == 0xff )
		{
			/*Ŀ,ôĿΪЧ,ҿԿ϶һĿ*/
			if( check_addr_null( ( unsigned int * )item , (flash_info_low->start[i+1] - flash_info_low->start[i]-sum), mtd_master) == 1 )
			{
				printk("[%s:%d]:Error item, so recopy from backup setor.\n", __FUNCTION__, __LINE__);
				vfree(item_sdram);
				return ERROR_CONFIG_LOST;
			}
			else /*϶һĿ*/
				break;
		}
#if 1
		if((((item->hdr.avail != ITEM_UNAVAIL) && (item->hdr.avail != ITEM_BAD) && (item->hdr.avail != ITEM_AVAIL ))||( item->hdr.len ==0)))
		{
			printk("[%s:%d]:avail=%0x,Error item, so recopy from backup setor.\n", __FUNCTION__, __LINE__,item->hdr.avail);
			vfree(item_sdram);
			return ERROR_CONFIG_LOST;
		}
#endif
		
		if( ( item->hdr.avail == ITEM_UNAVAIL ) )
		{
			sum += ITEM_SIZE( item->hdr.len );

			continue;
		}

		if( item->hdr.avail == ITEM_BAD )
		{
			sum += ITEM_SIZE( 0 );

			continue;
		}
				
		/*ЧĿ*/
		if( item->hdr.avail == ITEM_AVAIL )
		{
			tbs_crc16( item->data , item->hdr.len ,&checksum );
			if( checksum == item->hdr.crc )		/*Ŀ,ָһĿ*/
			{
				sum += ITEM_SIZE( item->hdr.len );

				continue;
			}
			else		/*Ŀ,ôĿΪЧ,ҿԿ϶һĿ*/
			{
				printk("[%s:%d]:Error item, so recopy from backup setor.\n", __FUNCTION__, __LINE__);
				vfree(item_sdram);
				return ERROR_CONFIG_LOST;
			}
		}
	}

	vfree(item_sdram);
	return ERROR_ITEM_OK;
}


/*=========================================================================
 Function:		int item_get( void *data , char *item_name ,unsigned short *len ) 

 Description:		ȡָĿ
 Calls:			
 Data Accessed:
 Data Updated:
 Input:			*item_name:	 Ŀ
 				*data:		ĿݵĴָ
 Output:			*len:		ĿЧݵĳ
 
 Return:			ERROR_ITEM_OK 
				ERROR_MALLOC
				ERROR_NOT_FIND
				ERROR_BIG
				ERROR_FLASH_BUSY
 Others:
 		ϲô˺ʱ*lenֵϲܽյ󳤶ȡ
  Чʵʳȴ*lendataͲֵҷش󣬲
 Ŀ Чݵĳͨ*lenϲ㡣
 ЧʵʳȲ*lenͽݸdataʵʳͨ
 *lenϲ
=========================================================================*/

int item_get( void *data , char *item_name ,unsigned short *len )
{
	item_t				*item;
	unsigned char			*item_sdram;
	unsigned int 			i = 0;
	unsigned int			sum = 0;
	mm_segment_t		fs;
	flash_info_t			*flash_info_low;
	struct mtd_info		*mtd;
	struct mtd_part		*part ;
	unsigned int			retlen;
	
	fs = get_fs();
	set_fs (get_ds());

	/* ȡMTDϢ*/
	mtd = get_mtd_device( NULL, 0 );
	part = PART(mtd);
		
	flash_info_low = vmalloc( sizeof( flash_info_t ) );
	if ( flash_info_low == NULL )
	{
		printk(KERN_EMERG"flash_info_low malloc wrong\n");
		set_fs (fs);
		
		return ERROR_ITEM_MALLOC;
	}

	/* ȡFlashб*/
	flash_info_get( flash_info_low ,  part->master );

	/* ҵFlashʼַ*/
	while( ( flash_info_low->start[i] - flash_info_low->start[0] ) < BOOTCODE_LENGTH )
		i++;

	item_sdram = vmalloc( READ_ITEM_LEN );
	if ( item_sdram == NULL )
	{
		set_fs (fs);
		vfree( flash_info_low );
		
		printk("item_sdram malloc wrong\n");
		
		return ERROR_ITEM_MALLOC;
	}

      if(down_interruptible(&item_sem))
      {
              set_fs (fs);
              vfree(flash_info_low);
              vfree(item_sdram);
              printk("Item get fail,because flash is busy.\n");
              
              return ERROR_FLASH_BUSY;
      }
      
	sum = CONFIG_MARK_LEN;

	/* Ŀ*/
	while( ( sum + ITEM_HEAD_LEN ) <= ( flash_info_low->start[i+1] - flash_info_low->start[i] ) )
	{
		part->master->read( part->master , flash_info_low->start[i] + sum , READ_ITEM_LEN , &retlen, item_sdram );
		item = ( item_t * ) item_sdram;

		/*ÿռѰ*/
		if( item->hdr.avail == 0xff )
		{
			break;
		}

		/*ĿЧ,ָһĿ*/
		if( item->hdr.avail == ITEM_UNAVAIL )
		{
			sum += ITEM_SIZE( item->hdr.len );

			continue;
		}

		/*ĿѾǻ,ָһĿ*/
		if( item->hdr.avail == ITEM_BAD )
		{
			sum += ITEM_SIZE( 0 );

			continue;
		}

		/* ҵЧĿ*/
		if( item->hdr.avail == ITEM_AVAIL )
		{
			/* ԱĿ,жǷΪҪѰҵ*/
			if( strcmp( item->data , item_name ) == 0 )
			{
				/* ĿеݳǷϲڴռ*/
				if( ( item->hdr.len - strlen( item_name ) - 1 )  >  *len )
				{
					/* ,ʧܲʵҪĳ֪ͨϲ*/
					*len = item->hdr.len - strlen( item_name ) - 1;
					set_fs (fs);
					vfree(flash_info_low);
					vfree(item_sdram);
					up(&item_sem);
                    
					return ERROR_ITEM_BIG;					
				}
				else
				{
					/* ݶȡ*/
					*len = item->hdr.len - strlen( item_name ) - 1;
					
					if( ITEM_SIZE( item->hdr.len ) > READ_ITEM_LEN )
					{
						part->master->read( part->master , flash_info_low->start[i] + sum + ITEM_HEAD_LEN + strlen( item_name ) + 1 , *len , &retlen, ( unsigned char * )data );
					}
					else
					{
						memcpy( data, item->data + strlen( item_name ) + 1 , *len );						
					}

					set_fs (fs);
					vfree(flash_info_low);
					vfree(item_sdram);
                                   up(&item_sem);

					return ERROR_ITEM_OK;

				}
			}

			/*ҪҵĿ,Ѱ*/
			sum += ITEM_SIZE( item->hdr.len );
				
			continue;
		}		
#if 1
		if((((item->hdr.avail != ITEM_UNAVAIL) && (item->hdr.avail != ITEM_BAD) && (item->hdr.avail != ITEM_AVAIL ))||( item->hdr.len == 0)))
		{
			printk("[%s:%d]:name=%s,avail=%0x,Error item\n", __FUNCTION__, __LINE__,item_name, item->hdr.avail);
			set_fs (fs);
			vfree(flash_info_low);
			vfree(item_sdram);
			up(&item_sem);
			return ERROR_CONFIG_LOST;
		}
#endif
	}

	set_fs (fs);
	vfree(flash_info_low);
	vfree(item_sdram);
	up(&item_sem);
    
	return ERROR_ITEM_NOT_FIND;
}

/*=========================================================================
 Function:		int item_save( void *data , char *item_name ,unsigned short len ) 

 Description:		ȡָĿ

 Data Accessed:
 Data Updated:
 Input:			*item_name:	 Ŀ
 				*data:		ҪŵĿݵָ 				
				len:		ĿЧݵĳ
 Output:			
 Return:			ERROR_ITEM_OK 
				ERROR_ITEM_MALLOC				
				ERROR_ITEM_BIG
				ERROR_ITEM_REPEAT_FAIL
				ERROR_FLASH_BUSY
 Others:
=========================================================================*/
int item_save( void *data , char *item_name ,unsigned short len )
{
	item_t				*item;
	unsigned char			*item_sdram;
	unsigned int 			i = 0;
	unsigned int 			j = 0;
	unsigned int			sum = 0;
	item_t				*item_data;
	unsigned short		checksum;	
	char					avail;
	unsigned int			item_repeat_addr[2];

	mm_segment_t		fs;
	flash_info_t			*flash_info_low;
	struct mtd_info		*mtd;
	struct mtd_part		*part ;
	unsigned int			retlen;
	int iret = 0;

	fs = get_fs();
	set_fs (get_ds());

	/* ȡMTDϢ*/
	mtd = get_mtd_device( NULL, 0 );
	part = PART(mtd);
		
	flash_info_low = vmalloc( sizeof( flash_info_t ) );
	if ( flash_info_low == NULL )
	{
		printk(KERN_EMERG"flash_info_low malloc wrong\n");
		set_fs (fs);
		
		return ERROR_ITEM_MALLOC;
	}

	/* ȡFlashб*/
	flash_info_get( flash_info_low ,  part->master );

	/* ҵFlashʼַ*/
	while( ( flash_info_low->start[i] - flash_info_low->start[0] ) < BOOTCODE_LENGTH )
		i++;

	item_sdram = vmalloc(READ_ITEM_LEN );
	if ( item_sdram == NULL )
	{
		set_fs (fs);
		vfree( flash_info_low );
		
		printk("item_sdram malloc wrong\n");
		
		return ERROR_ITEM_MALLOC;
	}

      if(down_interruptible(&item_sem))
      {
              set_fs (fs);
              vfree(flash_info_low);
              vfree(item_sdram);
              printk("Item save fail,because flash is busy.\n");

              return ERROR_FLASH_BUSY;
      }
	//add by wyh start at 2016-01-30:УĿЧԣ֤ȷ²Žת
	if (item_check(flash_info_low, part->master) == ERROR_CONFIG_LOST)
	{
		part->master->read( part->master , flash_info_low->start[i+1], CONFIG_MARK_LEN , &retlen, item_sdram );

		if (!strcmp(item_sdram, CONFIG_MARK))
		{
			printk("[%s:%d]:Do the recopy operation from backup setor.\n", __FUNCTION__, __LINE__);
			/* */ 
			kernel_erase( part->master , flash_info_low , flash_info_low->start[i] , flash_info_low->start[i+1] - flash_info_low->start[i] );
			/* Ŀд*/
			kernel_write( part->master , ( char * )( flash_info_low->start[i+1] + CONFIG_MARK_LEN ) , flash_info_low->start[i] + CONFIG_MARK_LEN , flash_info_low->start[i+1] - flash_info_low->start[i]-CONFIG_MARK_LEN );
			kernel_write( part->master , CONFIG_MARK , flash_info_low->start[i] , CONFIG_MARK_LEN );	
		}
		else
		{
			printk("[%s:%d]:ERR---Repeat fail\n", __FUNCTION__, __LINE__);
			set_fs (fs);
            vfree(flash_info_low);
            vfree(item_sdram);
			up(&item_sem);
			return ERROR_ITEM_REPEAT_FAIL;
		}
	}
	//add by wyh end
      
	sum = CONFIG_MARK_LEN;

	/* Ѱҿõÿռ*/
	while( ( sum + ITEM_HEAD_LEN ) <= ( flash_info_low->start[i+1] - flash_info_low->start[i] ) )
	{
		part->master->read( part->master , flash_info_low->start[i] + sum , READ_ITEM_LEN , &retlen, item_sdram );
		item = ( item_t * ) item_sdram;

		/*ҵFLASHյַ*/
		if( item->hdr.avail == 0xff )
		{
			break;
		}
		if((((item->hdr.avail != ITEM_UNAVAIL) && (item->hdr.avail != ITEM_BAD) && (item->hdr.avail != ITEM_AVAIL ))||( item->hdr.len ==0)))
		{
			printk("[%s:%d]:avail=%0x,Error item, so recopy from backup setor.\n", __FUNCTION__, __LINE__,item->hdr.avail);
			break;
		}

		if( ( item->hdr.avail == ITEM_UNAVAIL ) )
		{
			sum += ITEM_SIZE( item->hdr.len );

			continue;
		}

		if( item->hdr.avail == ITEM_BAD )
		{
			sum += ITEM_SIZE( 0 );

			continue;
		}

		if( item->hdr.avail == ITEM_AVAIL )
		{
			/*ֽҪΪЧĿ,ĵַ*/
			if( strcmp( item->data , item_name ) == 0 )
			{
				item_repeat_addr[j++] = flash_info_low->start[i] + sum + ( unsigned int )&( item->hdr.avail ) - ( unsigned int )item_sdram;

				/*ظĿ,ǰһĿΪЧ*/
				if( j == 2 )
				{
					avail = ITEM_UNAVAIL;
				#ifdef CONFIG_FLASH_WRITE_PROTECT
					kernal_flash_protect(0);
				#endif
					kernel_write( part->master , ( char * )&avail , item_repeat_addr[0] , 0x1 );
				#ifdef CONFIG_FLASH_WRITE_PROTECT
					kernal_flash_protect(1);
				#endif
					item_repeat_addr[0] = item_repeat_addr[1];
					j = 1;
				}
			}
			
			sum += ITEM_SIZE( item->hdr.len );

			continue;
		}		
	}
	
	/*ϢϳĿ*/
	item_data = vmalloc( ITEM_HEAD_LEN + strlen( item_name ) + 1 + len );
	if ( item_data == NULL )
	{
		set_fs (fs);
		vfree( flash_info_low );
		vfree( item_sdram );
		up(&item_sem);
		printk("item_data malloc wrong\n");
		
		return ERROR_ITEM_MALLOC;
	}

	item_data->hdr.avail = ITEM_AVAIL;	
	memcpy( item_data->data , item_name , strlen( item_name ) );
	memcpy( item_data->data + strlen( item_name ) , "\0" , 1 );	
	memcpy( item_data->data + strlen( item_name ) + 1 , data , len );	
	item_data->hdr.len = strlen( item_name ) + 1 + len;
	tbs_crc16( item_data->data , item_data->hdr.len ,&checksum );
	item_data->hdr.crc = checksum;

	/*жĿĴСǷ񳬳ʣռ*/
	if( ITEM_SIZE( strlen( item_name ) + 1 + len ) > ( flash_info_low->start[i+1] - flash_info_low->start[i] - sum ) )
	{
		/*,ͨתķʽеЧͻĿ*/
		if( item_repeat( flash_info_low , part->master ) != ERROR_ITEM_REPEAT_OK )
		{
			set_fs (fs);
			vfree( flash_info_low );
			vfree( item_sdram );
			vfree( item_data );
			up(&item_sem);
            
			return ERROR_ITEM_REPEAT_FAIL;
		}
		
		j = 0;
		sum = CONFIG_MARK_LEN;

		/* תٴѰҿõÿռ*/
		while( ( sum + ITEM_HEAD_LEN ) <= ( flash_info_low->start[i+1] - flash_info_low->start[i] ) )
		{
			part->master->read( part->master , flash_info_low->start[i] + sum , READ_ITEM_LEN , &retlen, item_sdram );
			item = ( item_t * ) item_sdram;		

			/*ҵFLASHյַ*/
			if( item->hdr.avail == 0xff )
			{
				break;
			}
			
			if((((item->hdr.avail != ITEM_UNAVAIL) && (item->hdr.avail != ITEM_BAD) && (item->hdr.avail != ITEM_AVAIL ))||( item->hdr.len ==0)))
			{
				printk("[%s:%d]:avail=%0x,Error item, so recopy from backup setor.\n", __FUNCTION__, __LINE__,item->hdr.avail);
				break;
			}

			if( item->hdr.avail == ITEM_AVAIL )
			{
				/*ֽҪΪЧĿ,ĵַ*/
				if( strcmp( item->data , item_name ) ==0 )
				{
					item_repeat_addr[j++] = flash_info_low->start[i] + sum + ( unsigned int )&( item->hdr.avail ) - ( unsigned int )item_sdram;
				}
				
				sum += ITEM_SIZE( item->hdr.len );
				
				continue;
			}			
		}
		
		/*ٴжǷ񳬳ռ*/
		if( ITEM_SIZE( item_data->hdr.len ) > ( flash_info_low->start[i+1] - flash_info_low->start[i] - sum ) )
		{
			/*Ŀ̫,޷,ش*/
			set_fs (fs);
			vfree( flash_info_low );
			vfree( item_sdram );
			vfree( item_data );
			up(&item_sem);
            
			return ERROR_ITEM_BIG;
		}
	}

	/* ϳɵĿдFlash*/
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	iret = kernel_write( part->master , ( unsigned char * ) item_data , flash_info_low->start[i] + sum , ITEM_HEAD_LEN + item_data->hdr.len );
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	/* ĿΪЧ*/
	if(( j == 1 )&&(iret != EFAULT))
	{
		avail = ITEM_UNAVAIL;
	#ifdef CONFIG_FLASH_WRITE_PROTECT
		kernal_flash_protect(0);
	#endif
		kernel_write( part->master , ( char * )&avail , item_repeat_addr[0] , 0x1 );
	#ifdef CONFIG_FLASH_WRITE_PROTECT
		kernal_flash_protect(1);
	#endif	
	}

	set_fs (fs);
	vfree( flash_info_low );
	vfree( item_sdram );
	vfree( item_data );
	up(&item_sem);
    
	return ERROR_ITEM_OK;
}

/*=========================================================================
 Function:		int item_repeat( flash_info_t* flash_info_low , struct mtd_info *mtd_master )

 Description:		ռ䲻ʱͨתתݣת
 				flashһڴ

 Data Accessed:
 Data Updated:
 Input:			
 				flash_info_low:	flashϢ
 				*mtd_master:		flash mtd
 				 				
 Output:			
 Return:			ERROR_ITEM_MALLOC				
				ERROR_ITEM_REPEAT_OK
 Others:
=========================================================================*/

int item_repeat( flash_info_t* flash_info_low , struct mtd_info *mtd_master )
{
	item_t			*item;
	unsigned int 		i = 0;
	unsigned int		sum = 0;
	unsigned int		len = 0;
	unsigned char		*item_sdram;
	unsigned int		addr;
	unsigned int		retlen;
#ifndef CONFIG_FLASH_TRANSFER
	unsigned char		*item_dram_repeat;
#endif

	item_sdram = vmalloc( READ_ITEM_LEN );
	if ( item_sdram == NULL )
	{		
		printk("item_sdram malloc wrong\n");
		
		return ERROR_ITEM_MALLOC;
	}

	/* ҵFlashʼַ*/	
	while( ( flash_info_low->start[i] - flash_info_low->start[0] ) < BOOTCODE_LENGTH )
		i++;

#ifdef CONFIG_FLASH_TRANSFER
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
	#endif
	kernel_erase( mtd_master , flash_info_low , flash_info_low->start[i+1] , flash_info_low->start[i+2] - flash_info_low->start[i+1] );
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
	#endif
	addr = flash_info_low->start[i+1] + CONFIG_MARK_LEN;
#else
	item_dram_repeat = vmalloc( flash_info_low->start[i+1] - flash_info_low->start[i] );
	if ( item_dram_repeat == NULL )
	{		
		printk("item_dram_repeat malloc wrong\n");
		vfree( item_sdram );

		return ERROR_ITEM_MALLOC;
	}
	addr = ( unsigned int )item_dram_repeat;
#endif

	sum = CONFIG_MARK_LEN;

	/* ЧĿת*/
	while( ( sum + ITEM_HEAD_LEN ) <= ( flash_info_low->start[i+1] - flash_info_low->start[i] ) )
	{
		mtd_master->read( mtd_master , flash_info_low->start[i] + sum , READ_ITEM_LEN , &retlen, item_sdram );
		item = ( item_t * ) item_sdram;

		if( item->hdr.avail == 0xff )
		{
#ifdef CONFIG_FLASH_TRANSFER
		#ifdef CONFIG_FLASH_WRITE_PROTECT
			kernal_flash_protect(0);
		#endif
			kernel_write( mtd_master , CONFIG_MARK , flash_info_low->start[i+1] , CONFIG_MARK_LEN );
		#ifdef CONFIG_FLASH_WRITE_PROTECT
			kernal_flash_protect(1);
		#endif
#endif

			break;
		}

		if( ( item->hdr.avail == ITEM_UNAVAIL ) )
		{
			sum += ITEM_SIZE( item->hdr.len );

			continue;
		}

		if( item->hdr.avail == ITEM_BAD )
		{
			sum += ITEM_SIZE( 0 );

			continue;
		}

		if( item->hdr.avail == ITEM_AVAIL )
		{
#ifdef CONFIG_FLASH_TRANSFER
		#ifdef CONFIG_FLASH_WRITE_PROTECT
			kernal_flash_protect(0);
		#endif
			kernel_write( mtd_master , ( unsigned char * )( flash_info_low->start[i] + sum ) , addr , ITEM_SIZE( item->hdr.len ) );
		#ifdef CONFIG_FLASH_WRITE_PROTECT
			kernal_flash_protect(1);
		#endif
#else
			mtd_master->read( mtd_master , flash_info_low->start[i] + sum , ITEM_SIZE( item->hdr.len ) , &retlen, ( unsigned char* )addr );
#endif
			sum += ITEM_SIZE( item->hdr.len );
			addr += ITEM_SIZE( item->hdr.len );
			len += ITEM_SIZE( item->hdr.len );
						
			continue;
		}
	}

	/* */ 
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	kernel_erase( mtd_master , flash_info_low , flash_info_low->start[i] , flash_info_low->start[i+1] - flash_info_low->start[i] );
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	/* Ŀд*/
#ifdef CONFIG_FLASH_TRANSFER
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
	#endif
	kernel_write( mtd_master , ( char * )( flash_info_low->start[i+1] + CONFIG_MARK_LEN ) , flash_info_low->start[i] + CONFIG_MARK_LEN , len );
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
	#endif
#else
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
	#endif
	kernel_write( mtd_master , item_dram_repeat , flash_info_low->start[i] + CONFIG_MARK_LEN , len );
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
	#endif
#endif
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
	#endif
	kernel_write( mtd_master , CONFIG_MARK , flash_info_low->start[i] , CONFIG_MARK_LEN );
	#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
	#endif
	vfree( item_sdram );
#ifndef CONFIG_FLASH_TRANSFER
	vfree( item_dram_repeat );
#endif

	return ERROR_ITEM_REPEAT_OK;
}

/*=========================================================================
 Function:		flash_update_bin( void )
 Description:		ϵͳеBIN file
 				
 Data Accessed:	/var/image.bin
 Data Updated:	flashе
 
 Input:			
 Output:			
 Return:			0:		ɹ
 				:	ʧ
 Others:
=========================================================================*/

int flash_update_bin( void )
{
	unsigned int			end = 0;
	int					len = 0;
	mm_segment_t		fs;
	long					fp_image_bin = -1;
	char					*buff = NULL;
	flash_info_t			*info;
	struct mtd_info		*mtd;
	struct mtd_part		*part ;

//modify by zhengmingming
/* add by huangshuangbang 20120602 for save mib_rf and mac when update bin start    */
#ifdef BACKUP_ITEM_MIB_RF_MAC
    /*
        get wlan cfg from item
        */
    #define EEPROM_SIZE 0x200;

    unsigned char *p = NULL;
    unsigned short rfLen = EEPROM_SIZE;
    int ret_val = ERROR_ITEM_NOT_FIND;
	
    p = kmalloc(rfLen, GFP_KERNEL | __GFP_NOFAIL);
    if(NULL != p )
    {
        ret_val = item_get(p, WLAN_NAME, &rfLen);
        if(ERROR_ITEM_OK != ret_val)
        {
            printk("get wlan cfg fail\n");
        }   
    }
    
    memset(&syscfg, 0, sizeof(llconfig_syscfg_t));
	/*ȡmac*/
	llconfig_get_syscfg(&syscfg);
#endif
/*add by huangshuangbang 20120602 for save mib_rf and mac when update bin end*/
	
	
	fs = get_fs();
	set_fs (get_ds());

	/* ȡMTDϢ*/
	mtd = get_mtd_device( NULL, 0 );
	part = PART(mtd);

	info = vmalloc( ( unsigned long )sizeof( flash_info_t ) );
	if ( info == NULL )
	{
		printk(KERN_EMERG"info malloc wrong\n");
#ifdef BACKUP_ITEM_MIB_RF_MAC
        if(NULL != p)
            kfree( p );
#endif
		return EFAULT;
	}

	/* ȡFlashб*/
	flash_info_get( info , part->master );

	if( ( fp_image_bin = sys_open( BIN_FILE , O_RDONLY , 0 ) ) < 0 )//modify by zhengmingming 20120702
       {
		printk("\nCan't find BIN file\n");
		set_fs (fs);
		vfree( info );		
#ifdef BACKUP_ITEM_MIB_RF_MAC
        if(NULL != p)
            kfree( p );
#endif
		return EFAULT;
	}

	buff = vmalloc(1024);
	if( buff == NULL )
	{
		printk("buff malloc wrong\n");
		sys_close( fp_image_bin );
		set_fs ( fs );
		vfree( info );
#ifdef BACKUP_ITEM_MIB_RF_MAC
        if(NULL != p)
            kfree( p );
#endif		
		return EFAULT;
	}
	
	printk("\nErasing flash");

	/*Flashȫ*/
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif	
	kernel_erase( part->master , info , info->start[0] , info->size );
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	printk("\nBurning flash");

	/*imageдFlash*/
	end = info->start[0];
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	while( ( len = sys_read( fp_image_bin , buff , 1024 )  ) != 0 )
	{	
		kernel_write( part->master , buff , end , len );	
		end += len;

		if( ( end % 0x10000 ) == 0 )
			printk(".");
	}
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	sys_close(fp_image_bin);
	set_fs (fs);
	vfree(buff);
	vfree( info );
//modify by zhengmingming
/*add by huangshuangbang 20120602 for save mib_rf and mac when update bin start*/
#ifdef BACKUP_ITEM_MIB_RF_MAC
    /*
        if get wlan cfg ok,save to item after write all image
      */
    if(ERROR_ITEM_OK == ret_val)
    {
        ret_val = item_save(p, WLAN_NAME, rfLen);
        if(ERROR_ITEM_OK != ret_val)
        {
            printk("save wlan cfg fail\n");
        }
    }
    if(NULL != p)
        kfree( p );
    
	/*ǰmacûȥ*/
	llconfig_set_syscfg(&syscfg);
#endif	
/*add by huangshuangbang 20120602 for save mib_rf and mac when update bin end*/	
	printk("\nFlash Update Completed\n");

	return 0;
}

/*=========================================================================
 Function:		int flash_update_img( void )

 Description:		ϵͳ
 				
 Calls:			sys_open
 				sys_read
 				sys_close
 				kernel_erase
 				kernel_write
 				sysdata_save
 Data Accessed:	/var/image.img
 Data Updated:	flashе
 
 Input:			
 Output:			
 Return:			0:		ɹ
 				:	ʧ
 Others:
=========================================================================*/

int flash_update_img( void )
{
	update_hdr_t			*update_hdr;
	unsigned int			start = 0 ;
	unsigned int			end = 0;
	int					len = 0;
	mm_segment_t		fs;
	long					fp_image_img = -1;
	char					*buff = NULL;
	flash_info_t			*info;
	struct mtd_info		*mtd;
	struct mtd_part		*part ;
	sys_config_t			*sys_data;

	fs = get_fs();
	set_fs (get_ds());

	/* ȡMTDϢ*/
	mtd = get_mtd_device( NULL, 0 );
	part = PART(mtd);
	
	info = vmalloc( ( unsigned long )sizeof( flash_info_t ) );
	if ( info == NULL )
	{
		printk(KERN_EMERG"info malloc wrong\n");
		return EFAULT;
	}

	/* ȡFlashб*/
	flash_info_get( info , part->master );
	
	sys_data = vmalloc( sizeof( sys_config_t ) );		
	if ( sys_data == NULL )
	{
		printk(KERN_EMERG"sys_config_t malloc wrong\n");
		vfree( info );

		return EFAULT;
	}

	/* ȡײϢ*/
	sysdata_get( sys_data );

	if( (fp_image_img= sys_open(IMG_FILE,O_RDONLY,0)) < 0)
       {
		printk("\nUnable to Open the /var/image.img partition\n");
		set_fs (fs);
		vfree(info);
		vfree(sys_data);
		
		return EFAULT;
	}

	buff = vmalloc(1024);
	if(buff == NULL)
	{
		printk("buff malloc wrong\n");
		sys_close(fp_image_img);
		set_fs (fs);
		vfree(info);
		vfree(sys_data);
				
		return EFAULT;
	}

	/* ȡļͷϢ*/
	update_hdr = vmalloc(sizeof(update_hdr_t));		
	if ( update_hdr == NULL )
	{
		printk("update_hdr malloc wrong\n");
		sys_close(fp_image_img);
		vfree(buff);
		vfree(info);
		vfree(sys_data);

		return EFAULT;
	}

	sys_read( fp_image_img , buff , sizeof(update_hdr_t) ) ;
		
	memcpy( update_hdr , buff , sizeof(update_hdr_t) );
	
	strcpy( sys_data->version ,  update_hdr->version );
	strcpy( sys_data->board_id, update_hdr->board_id);
      
      strcpy( sys_data->swversion, update_hdr->swversion);
	  //model_name ,EX3110 EX6110ʱ豸model nameΪEX6110
      //strcpy( sys_data->model_name, update_hdr->model_name);

      //region code
      //strcpy( sys_data->region, update_hdr->region);

#ifdef CONFIG_DOUBLE_BACKUP

	/*ҵҪдimageFlashʼַ*/
	if( sys_data->image_mark == 0 )
	{
		while( sys_data->layout.zone_offset[ZONE_KERNEL_SECOND] > ( info->start[start] - info->start[0] ) )
		{
			start++;
		}
	}
	else
	{
		while( sys_data->layout.zone_offset[ZONE_KERNEL_FIRST] > ( info->start[start] - info->start[0] ) )
		{
			start++;
		}
	}

	printk("\nErasing flash");
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	kernel_erase(part->master,info,info->start[start],update_hdr->image_len);
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	printk("\nBurning flash");

	end = info->start[start];
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	while( ( len = sys_read(fp_image_img,buff,1024) ) != 0 )
	{			
		kernel_write(part->master,buff,end,len);	
		end += len;

		if( ( end % 0x10000 ) == 0 )
			printk(".");
	}
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	/*лimageıʶλ*/
	if( sys_data->image_mark == 0 )
	{
		sys_data->layout.zone_offset[ZONE_ROOTFS_SECOND] = sys_data->layout.zone_offset[ZONE_KERNEL_SECOND] + update_hdr->rootfs_offset - update_hdr->kernel_offset ;
		sys_data->second_image_checksum = update_hdr->image_checksum;
		sys_data->second_image_len = update_hdr->image_len;
		sys_data->image_mark =1;
	}
	else
	{
		sys_data->layout.zone_offset[ZONE_ROOTFS_FIRST] = sys_data->layout.zone_offset[ZONE_KERNEL_FIRST] + update_hdr->rootfs_offset - update_hdr->kernel_offset ;
		sys_data->first_image_checksum = update_hdr->image_checksum;
		sys_data->first_image_len = update_hdr->image_len;
		sys_data->image_mark = 0;
	}

#else

	/*ҵҪдimageFlashʼַ*/
	while(sys_data->layout.zone_offset[ZONE_KERNEL_FIRST] > (info->start[start]-info->start[0]))
		start++;
//ͬĿĬϿwatchdogʱرա
#if defined(CONFIG_RTL_WTDOG)
          printk("--flash_update_img---disabe watchdog---\n");
          *((volatile unsigned long *)0xB800311C) = 0xA5000000;    // disabe watchdog
#endif

	printk("\nErasing flash");
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	kernel_erase(part->master,info,info->start[start],update_hdr->image_len);
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	printk("\nBurning flash");
	end = info->start[start];
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(0);
#endif
	while( ( len = sys_read(fp_image_img,buff,1024) ) != 0 )
	{	
		kernel_write(part->master,buff,end,len);
		end += len;

		if( ( end % 0x10000 ) == 0 )
			printk(".");
	}

	if( ( end % 0x10000 ) != 0 )
		printk(".");
			
#ifdef CONFIG_FLASH_WRITE_PROTECT
	kernal_flash_protect(1);
#endif
	sys_data->layout.zone_offset[ZONE_ROOTFS_FIRST] = sys_data->layout.zone_offset[ZONE_KERNEL_FIRST] + update_hdr->rootfs_offset - update_hdr->kernel_offset ;
	sys_data->first_image_checksum = update_hdr->image_checksum;
	sys_data->first_image_len = update_hdr->image_len;

#endif

	sysdata_save(sys_data); 

	sys_close(fp_image_img);
	set_fs (fs);
	vfree(buff);
	vfree(update_hdr);
	vfree(info);
	vfree(sys_data);

	printk("\nFlash Update Completed\n");

	return 0;
}

/*add by huangshuangbang 20120602 for save mib_rf and mac when update bin start*/

#ifdef CONFIG_APPS_LOGIC_NMRP
/*add by wyh start at 20140624 to add WIFI NMRP upgrade wirte flash interface*/
int flash_nmrp_update_img(int fragmentType, int len, char *buff)
{

	if (fragmentType == NMRP_FIRST_FRAGMENT)
	{
		g_fs = get_fs();
		set_fs (get_ds());

		/* ȡMTDϢ*/
		g_mtd = get_mtd_device( NULL, 0 );
		g_part = PART(g_mtd);
	
		g_info = vmalloc( ( unsigned long )sizeof( flash_info_t ) );
		if ( g_info == NULL )
		{
			printk(KERN_EMERG"info malloc wrong\n");
			return EFAULT;
		}

		/* ȡFlashб*/
		flash_info_get( g_info , g_part->master );
	
		g_sys_data = vmalloc( sizeof( sys_config_t ) );		
		if ( g_sys_data == NULL )
		{
			printk(KERN_EMERG"sys_config_t malloc wrong\n");
			vfree( g_info );

			return EFAULT;
		}

		/* ȡײϢ*/
		sysdata_get( g_sys_data );
		
		/* ȡļͷϢ*/
		g_update_hdr = vmalloc(sizeof(update_hdr_t));		
		if ( g_update_hdr == NULL )
		{
			printk("update_hdr malloc wrong\n");
			vfree(g_info);
			vfree(g_sys_data);

			return EFAULT;
		}
		
		memcpy( g_update_hdr , buff , sizeof(update_hdr_t) );
		
		strcpy( g_sys_data->version ,  g_update_hdr->version );
		strcpy( g_sys_data->board_id, g_update_hdr->board_id);
	    
	    strcpy( g_sys_data->swversion, g_update_hdr->swversion);
		//model_name ,EX3110 EX6110ʱ豸model nameΪEX6110
	    //strcpy( g_sys_data->model_name, g_update_hdr->model_name);

      	//region code
      	//strcpy( sys_data->region, update_hdr->region);

		/*ҵҪдimageFlashʼַ*/
		while(g_sys_data->layout.zone_offset[ZONE_KERNEL_FIRST] > (g_info->start[g_start]-g_info->start[0]))
			g_start++;
		
//ͬĿĬϿwatchdogʱرա
#if defined(CONFIG_RTL_WTDOG)
        printk("--flash_update_img---disabe watchdog---\n");
        *((volatile unsigned long *)0xB800311C) = 0xA5000000;    // disabe watchdog
#endif

		printk("\nErasing flash");
#ifdef CONFIG_FLASH_WRITE_PROTECT
		kernal_flash_protect(0);
#endif
		kernel_erase(g_part->master,g_info,g_info->start[g_start],g_update_hdr->image_len);
#ifdef CONFIG_FLASH_WRITE_PROTECT
		kernal_flash_protect(1);
#endif
		printk("\nBurning flash");
		g_end = g_info->start[g_start];
	}
	else if (fragmentType == NMRP_MIDDLE_FRAGMENT)
	{

#ifdef CONFIG_FLASH_WRITE_PROTECT
		kernal_flash_protect(0);
#endif
		//while( ( len = sys_read(fp_image_img,buff,1024) ) != 0 )
		{	
			kernel_write(g_part->master,buff,g_end,len);
			g_end += len;

			if( ( g_end % 0x10000 ) == 0 )
				printk(".");
		}
		
#ifdef CONFIG_FLASH_WRITE_PROTECT
		kernal_flash_protect(1);
#endif
	}
	else
	{
		g_sys_data->layout.zone_offset[ZONE_ROOTFS_FIRST] = g_sys_data->layout.zone_offset[ZONE_KERNEL_FIRST] + g_update_hdr->rootfs_offset - g_update_hdr->kernel_offset ;
		g_sys_data->first_image_checksum = g_update_hdr->image_checksum;
		g_sys_data->first_image_len = g_update_hdr->image_len;
	
		sysdata_save(g_sys_data); 

		set_fs (g_fs);
		vfree(g_update_hdr);
		vfree(g_info);
		vfree(g_sys_data);
	}

	return 0;
}
/*add by wyh end*/
#endif

#ifdef BACKUP_ITEM_MIB_RF_MAC
/*=========================================================================
 Function:		void  llconfig_get_syscfg(  llconfig_syscfg_t *data)
 Description:		ȡMACֵ
 Data Accessed:
 Data Updated:
 Input:		       
 Output:			*data:	ȡMACֵ
 Return:			
 Others:
=========================================================================*/
static void  llconfig_get_syscfg(  llconfig_syscfg_t *data)
{
	sys_config_t syscfg;
	int i;

	sysdata_get( &syscfg);
	for(i = 0; i < 6; i++)
	{
		data->mac[i] = syscfg.mac[i];
	}

	memcpy(data->region,syscfg.region,REGION_LEN);

	#ifdef PINANDOTHER_ENABLED
		memcpy(data->pinandother,syscfg.pinandother,PINANDOTHER_LEN);    
	#endif 
    /*
        get gui region
        */
    memcpy(data->gui_region, syscfg.gui_region, GUI_REGION_LEN);
}




/*=========================================================================
 Function:		void  llconfig_set_syscfg(  llconfig_syscfg_t *data)
 Description:		ָMACֵ
 Data Accessed:
 Data Updated:
 Input:		       *data:	ָMACֵ
 Output:			
 Return:			
 Others:
=========================================================================*/
static void  llconfig_set_syscfg(  llconfig_syscfg_t *data)
{
	int i;
	sys_config_t syscfg_tmp;
	char mac_and = data->mac[0] & data->mac[1] & data->mac[2] & data->mac[3] & data->mac[4] & data->mac[5];
	char mac_or   = data->mac[0] | data->mac[1] | data->mac[2] | data->mac[3] | data->mac[4] | data->mac[5];

	memset(&syscfg_tmp, 0, sizeof(sys_config_t));
	sysdata_get(&syscfg_tmp);
	if(0xFF == mac_and || 0x00 == mac_or)
	{
		printk("Illegal mac address, recover fail!!!\n");
	}
	else
	{
		for(i = 0; i < 6; i++)
		{
			syscfg_tmp.mac[i] = data->mac[i];
		}
	}

	memcpy(syscfg_tmp.region,data->region,REGION_LEN);

	#ifdef PINANDOTHER_ENABLED
		memcpy(syscfg_tmp.pinandother,data->pinandother,PINANDOTHER_LEN);    
	#endif 
    /*
            save gui region
        */
    memcpy(syscfg_tmp.gui_region, data->gui_region, GUI_REGION_LEN);
    
	sysdata_save( &syscfg_tmp);

}
#endif
/*add by huangshuangbang 20120602 for save mib_rf and mac when update bin end*/

//add by zhengmingming 20120608 repoint the comand line from tbsboot for starting kernel
void repoint_cmdline(char *bootargs)
{
	char *fixed = "console=ttyS0,115200  root=31:2 mtdparts=spi_flash:";
	char *tmp = NULL;
	char *str = bootargs;

	int n[4] = {0};
	int i = 1;
	
	if(NULL == bootargs) 
		return;
	
	tmp = str + strlen(fixed);
	n[0] = simple_strtoul(tmp, NULL, 10);
	tmp = tmp + 1;
	printk("%d\n", n[0]);
	
	while(NULL != (tmp = strstr(tmp + 1, ","))){
		tmp = tmp + 1;
		n[i++] = simple_strtoul(tmp, NULL, 10);
		printk("%d\n", n[i]);
	}
	n[3] = MAX_FLASH_LEN - n[0] -n[1];	
	printk("n[0] = %d, n[1] = %d, n[3] = %d\n", n[0], n[1], n[3]);
	sprintf(str,"%s%d(boot),%d(kernel),%d(rootfs),131072(multi_lang),131072(deflang)", fixed, n[0], n[1], n[3]);
	printk(KERN_EMERG"repoint_cmdline,str:%s\n", str);
}
//add by zhengmingming 20120608 repoint the comand line from tbsboot for starting kernel .end

EXPORT_SYMBOL(item_get);
EXPORT_SYMBOL(item_save);

/*=========================================================================
					File End
=========================================================================*/


