
#include <linux/kobject.h>
#include <linux/string.h>
#include <linux/sysfs.h>
#include <linux/module.h>
#include <linux/init.h> 

unsigned long spi_flash_id = 0;


static ssize_t spi_flash_id_show(struct kobject *kobj, struct kobj_attribute *attr, char *buf)
{
    return sprintf(buf, "%ul\n", spi_flash_id);
}

static struct kobj_attribute spi_flash_id_attribute = __ATTR(flash_id, S_IRUSR, spi_flash_id_show, NULL);

 
static struct attribute *attrs[] = {
        &spi_flash_id_attribute.attr,
        NULL,
};

static struct attribute_group attr_group = {
    .name = NULL,
    .attrs = attrs,
};
 
static struct kobject *spi_info_kobj;

static int __init spi_info_init(void)
{
    int retval;

    spi_info_kobj = kobject_create_and_add("spi_info", kernel_kobj);
    if (!spi_info_kobj)
        return -ENOMEM;

    retval = sysfs_create_group(spi_info_kobj, &attr_group);

    if (retval)
        kobject_put(spi_info_kobj);

    return retval;
}

static void __exit spi_info_exit(void)
{
    kobject_put(spi_info_kobj);
}

module_init(spi_info_init);
module_exit(spi_info_exit);