#ifndef _MTD_SPI_PROBE_H_
#define _MTD_SPI_PROBE_H_
#include <linux/kernel.h>

#define ID_MASK                 0xffff
#define SIZE_64KiB      		0x10000
#define SIZE_64MiB              0x4000000
#define SIZE_32MiB              0x2000000
#define SIZE_16MiB              0x1000000
#define SIZE_8MiB       		0x800000
#define SIZE_4MiB       		0x400000
#define SIZE_2MiB       		0x200000

#define STM_PAGE_SIZE		256

#define SPI_WRITE_ENABLE	0
#define SPI_WRITE_DISABLE	1
#define SPI_RD_STATUS		2
#define SPI_WR_STATUS		3
#define SPI_RD_DATA		4
#define SPI_FAST_RD_DATA	5
#define SPI_PAGE_PROGRAM	6
#define SPI_SECTOR_ERASE	7
#define SPI_BULK_ERASE		8
#define SPI_DEEP_PWRDOWN	9
#define SPI_RD_SIG		10
#define SPI_RD_ID		11
#define SPI_RD_STATUS2		12
#define SPI_HPM_ENABLE		13
#define SPI_MAX_OPCODES		14

#define SFI_WRITE_BUFFER_SIZE	4
#define SFI_FLASH_ADDR_MASK	0x00ffffff

/*
 * ST Microelectronics Opcodes for Serial Flash
 */

#define STM_OP_WR_ENABLE	0x06	/* Write Enable */
#define STM_OP_WR_DISABLE	0x04	/* Write Disable */
#define STM_OP_RD_STATUS	0x05	/* Read Status */
#define STM_OP_RD_STATUS2	0x35	/* Read Status 2 */
#define STM_OP_WR_STATUS	0x01	/* Write Status */
#define STM_OP_RD_DATA		0x03	/* Read Data */
#define STM_OP_FAST_RD_DATA	0x0b	/* Fast Read Data */
#define STM_OP_PAGE_PGRM	0x02	/* Page Program */
#define STM_OP_SECTOR_ERASE	0xd8	/* Sector Erase */
#define STM_OP_BULK_ERASE	0xc7	/* Bulk Erase */
#define STM_OP_DEEP_PWRDOWN	0xb9	/* Deep Power-Down Mode */
#define STM_OP_RD_SIG		0xab	/* Read Electronic Signature */
#define STM_OP_RD_ID		0x9f	/* Read JEDEC ID */
#define STM_OP_HPM		0xa3	/* High Performance Mode */

#define STM_STATUS_WIP		0x01	/* Write-In-Progress */
#define STM_STATUS_WEL		0x02	/* Write Enable Latch */
#define STM_STATUS_BP0		0x04	/* Block Protect 0 */
#define STM_STATUS_BP1		0x08	/* Block Protect 1 */
#define STM_STATUS_BP2		0x10	/* Block Protect 2 */
#define STM_STATUS_SRWD		0x80	/* Status Register Write Disable */

#define STM_STATUS_QE		0x02	/* Quad Enable */

#define SPI_REG_CTL		(RALINK_SPI_BASE + 0x00)
#define SPI_REG_OPCODE		(RALINK_SPI_BASE + 0x04)
#define SPI_REG_DATA0		(RALINK_SPI_BASE + 0x08)
#define SPI_REG_DATA(x)		(SPI_REG_DATA0 + (x * 4))
#define SPI_REG_MASTER		(RALINK_SPI_BASE + 0x28)
#define SPI_REG_MOREBUF		(RALINK_SPI_BASE + 0x2c)
#define SPI_REG_Q_CTL		(RALINK_SPI_BASE + 0x30)
#define SPI_REG_SPACE_CR	(RALINK_SPI_BASE + 0x3c)

#define SPI_CTL_START		0x00000100
#define SPI_CTL_BUSY		0x00010000
#define SPI_CTL_TXCNT_MASK	0x0000000f
#define SPI_CTL_RXCNT_MASK	0x000000f0
#define SPI_CTL_TX_RX_CNT_MASK	0x000000ff
#define SPI_CTL_SIZE_MASK	0x00180000
#define SPI_CTL_ADDREXT_MASK	0xff000000

#define SPI_MBCTL_TXCNT_MASK		0x000001ff
#define SPI_MBCTL_RXCNT_MASK		0x001ff000
#define SPI_MBCTL_TX_RX_CNT_MASK	(SPI_MBCTL_TXCNT_MASK | SPI_MBCTL_RXCNT_MASK)
#define SPI_MBCTL_CMD_MASK		0x3f000000

#define SPI_CTL_CLK_SEL_MASK	0x03000000
#define SPI_OPCODE_MASK		0x000000ff

#define SPI_STATUS_WIP		STM_STATUS_WIP


enum spi_mode {
	SPI_STD_RD			   =	0x0,
	SPI_STD_FAST_RD		   =	0x1,
	SPI_FAST_RD_DUAL_O	   =	0x2,
	SPI_FAST_RD_DUAL_IO	   =	0x3,
	SPI_FAST_RD_QUAD_O	   =	0x4,
	SPI_FAST_RD_QUAD_IO	   =	0x5,
	SPI_BURST_RD_QUAD_IO   =	0x6
};

struct spi_flash_params {
    char *name;
    unsigned long id;              //JEDEC ID
    unsigned long chip_size;       //in bytes
    unsigned long erasesize;       //Erase Size
    unsigned long nr_units;        //Total erase units
    unsigned long page_size;       //in bytes
    int mode;                      //Operation mode;
    char addr4b;
};

const struct spi_flash_params flash_table[]= {
#if 1
	{"FL016AIF"    , 0x010214, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_STD_RD, 0 },
	{"FL064AIF"    , 0x010216, SIZE_8MiB , SIZE_64KiB, 128 , 256, SPI_STD_RD, 0 },
	{"MX25L12805D" , 0xC22018, SIZE_16MiB , SIZE_64KiB, 256 , 256, SPI_STD_RD, 0 },
	{"S25FL129P"   , 0x012018, SIZE_16MiB , SIZE_64KiB, 256 , 256, SPI_STD_RD, 0 },
	{"S25FL164K"   , 0x014017, SIZE_8MiB , SIZE_64KiB, 128 , 256, SPI_STD_RD, 0 },
	{"S25FL132K"   , 0x014016, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_RD, 0 },
	{"S25FL032P"   , 0x010215, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_RD, 0 },
	{"S25FL064P"   , 0x010216, SIZE_8MiB , SIZE_64KiB, 128 , 256, SPI_STD_RD, 0 },
	{"S25FL116K"   , 0x014015, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_STD_RD, 0 },
	{"F25L64QA"    , 0x8C4117, SIZE_8MiB , SIZE_64KiB, 128 , 256, SPI_STD_RD, 0 },
	{"F25L32QA"    , 0x8C4116, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_RD, 0 },
	{"EN25Q32B"    , 0x1C3016, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_RD, 0 },
	{"EN25F64"	   , 0x1C2017, SIZE_8MiB , SIZE_64KiB, 128 , 256, SPI_STD_RD, 0 },
	{"W25Q32BV"    , 0xEF4016, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_RD, 0 },
	{"W25Q64BV"    , 0xEF4017, SIZE_8MiB , SIZE_64KiB, 128 , 256, SPI_STD_RD, 0 },
	{"W25Q128BV"   , 0xEF4018, SIZE_16MiB , SIZE_64KiB, 256 , 256, SPI_STD_RD, 0 },
	{"W25Q256FV"   , 0xEF4019, SIZE_32MiB , SIZE_64KiB, 512 , 256, SPI_STD_RD, 0 },
	{"N25Q032A13ESE40F"   , 0x20ba16, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_RD, 0 },
	{"N25Q064A13ESE40F"   , 0x20ba17, SIZE_8MiB , SIZE_64KiB, 128 , 256, SPI_STD_RD, 0 },
	{"N25Q128A13ESE40F"   , 0x20ba18, SIZE_16MiB , SIZE_64KiB, 256 , 256, SPI_STD_RD, 0 },
	{"GD25Q32B"    , 0xC84016, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_RD, 0 },
	{"GD25Q64B"    , 0xC84017, SIZE_8MiB , SIZE_64KiB, 128 , 256, SPI_STD_RD, 0 },
	{"GD25Q128C"   , 0xC84018, SIZE_16MiB , SIZE_64KiB, 256 , 256, SPI_STD_RD, 0 },
	{"MX25L25635E" , 0xC22019, SIZE_32MiB , SIZE_64KiB, 512 , 256, SPI_STD_RD, 1 },
	{"S25FL256S"   , 0x010219, SIZE_32MiB , SIZE_64KiB, 512 , 256, SPI_STD_RD, 1 },
	{"N25Q256A"    , 0x20ba19, SIZE_32MiB , SIZE_64KiB, 512 , 256, SPI_STD_RD, 1 },
	{"MT25QL512AB" , 0x20ba20, SIZE_64MiB , SIZE_64KiB, 1024 , 256, SPI_STD_RD, 1 },
	{"XT25F64B"   , 0x0B0016, SIZE_8MiB, SIZE_64KiB, 128, 256, SPI_STD_RD, 0 },//XT25F64B
#endif
	{"AT26DF161"   , 0xEF4600, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_STD_RD, 0 },
	{"AT26DF161A"  , 0xEF4601, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_STD_RD, 0 },
	{"AT26DF161A"  , 0xEF4602, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_STD_RD, 0 },
	{"A25L016"     , 0x373015, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_STD_RD, 0 },
	{"EN25P16"     , 0x1C3015, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_FAST_RD_QUAD_IO, 0 },
	{"EN25F16"     , 0x1C3115, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_STD_FAST_RD, 0 },
	{"MX25L1605D"  , 0xc22015, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_STD_FAST_RD, 0 },
	{"MX25L1635D"  , 0xc22415, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_STD_FAST_RD, 0 },
	{"M25P16"      , 0x202015, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_STD_FAST_RD, 0 },//numonyx
	{"W25X16"      , 0xEF3015, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_FAST_RD_DUAL_O, 0 },
	{"W25Q16"      , 0xEF4015, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_FAST_RD_QUAD_IO, 0 },
	{"S25FL016A"   , 0x010214, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_STD_FAST_RD, 0 },
	{"GD25Q16"     , 0xC84015, SIZE_2MiB , SIZE_64KiB, 32 , 256, SPI_STD_FAST_RD, 0 },
	{"AT25DF321"   , 0x1F4700, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_RD, 0 },
	{"AT25DF321"   , 0x1F4701, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_RD, 0 },
	{"A25L032"     , 0x373016, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_RD, 0 },
	{"EN25P32"     , 0x1C2016, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_RD, 0 },
	{"EN25F32"     , 0x1C3116, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_FAST_RD, 0 },
	{"EN25Q32"     , 0x1C3316, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_RD, 0 },
	{"EN25Q32A"    , 0x1C3016, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_FAST_RD_QUAD_IO, 0 },
	{"M25P32"      , 0x202016, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_FAST_RD, 0 },
	{"MX25L3205D"  , 0xc22016, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_FAST_RD, 0 },
	{"MX25L3235D"  , 0xc22416, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_FAST_RD, 0 },
	{"N25S32"      , 0xD53016, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_RD, 0 },
	{"W25X32"      , 0xEF3016, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_FAST_RD_DUAL_O, 0 },
	{"W25Q32"      , 0xEF4016, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_FAST_RD_QUAD_IO, 0 },
	{"S25FL032A"   , 0x010215, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_FAST_RD, 0 },
	{"GD25Q32"     , 0xC84016, SIZE_4MiB , SIZE_64KiB, 64 , 256, SPI_STD_FAST_RD, 0 },
	{"AT25DF641"   , 0x1F4800, SIZE_8MiB , SIZE_64KiB, 128, 256, SPI_STD_RD, 0 },
	{"A25L064"     , 0x373017, SIZE_8MiB , SIZE_64KiB, 128, 256, SPI_STD_RD, 0 },
	{"EN25P64"     , 0x1C2017, SIZE_8MiB , SIZE_64KiB, 128, 256, SPI_STD_RD, 0 },
	{"EN25Q64"     , 0x1C3017, SIZE_8MiB , SIZE_64KiB, 128, 256, SPI_FAST_RD_QUAD_IO, 0 },
	{"M25P64"      , 0x202017, SIZE_8MiB , SIZE_64KiB, 128, 256, SPI_STD_FAST_RD, 0 },
	{"MX25L6405D"  , 0xc22017, SIZE_8MiB , SIZE_64KiB, 128, 256, SPI_STD_FAST_RD, 0 },
	{"W25X64"      , 0xEF3017, SIZE_8MiB , SIZE_64KiB, 128, 256, SPI_FAST_RD_DUAL_O, 0 },
	{"W25Q64"      , 0xEF4017, SIZE_8MiB , SIZE_64KiB, 128, 256, SPI_FAST_RD_QUAD_IO, 0 },//FL064K
	{"S25FL064A"   , 0x010216, SIZE_8MiB , SIZE_64KiB, 128, 256, SPI_STD_FAST_RD, 0 },
	{"GD25Q64"     , 0xC84017, SIZE_8MiB , SIZE_64KiB, 128, 256, SPI_STD_FAST_RD, 0 },
	{"GD25Q128"    , 0xC84018, SIZE_16MiB, SIZE_64KiB, 256, 256, SPI_STD_FAST_RD, 0 },
	{"AT25DF128"   , 0x1F4900, SIZE_16MiB, SIZE_64KiB, 256, 256, SPI_STD_RD, 0 },
	{"A25L128"     , 0x373018, SIZE_16MiB, SIZE_64KiB, 256, 256, SPI_STD_RD, 0 },
	{"EN25P128"    , 0x1C2018, SIZE_16MiB, SIZE_64KiB, 256, 256, SPI_STD_RD, 0 },
	{"EN25Q128"    , 0x1C3018, SIZE_16MiB, SIZE_64KiB, 256, 256, SPI_FAST_RD_QUAD_IO, 0 },
	{"N25Q128"     , 0x20BA18, SIZE_16MiB, SIZE_64KiB, 256, 256, SPI_STD_RD, 0 },//3V
	{"N25Q128A"    , 0x20BB18, SIZE_16MiB, SIZE_64KiB, 256, 256, SPI_STD_RD, 0 },//1.8V
	{"MX25L12805"  , 0xC22018, SIZE_16MiB, SIZE_64KiB, 256, 256, SPI_STD_FAST_RD, 0 },//MX25L12845
	{"W25X128"     , 0xEF3018, SIZE_16MiB, SIZE_64KiB, 256, 256, SPI_FAST_RD_DUAL_O, 0 },
	{"W25Q128"     , 0xEF4018, SIZE_16MiB, SIZE_64KiB, 256, 256, SPI_FAST_RD_QUAD_IO, 0 },
	{"S25FL128P"   , 0x012018, SIZE_16MiB, SIZE_64KiB, 256, 256, SPI_STD_FAST_RD, 0 },//S25L129P
	{"Unknown"     , 0x0     , SIZE_16MiB, SIZE_64KiB, 256, 256, SPI_STD_RD, 0 }
};

#endif
