/**
 * File name: btn_mt7620a.c
 * Note: MT7620Aİť
 * 
 * Author: Su Denghai
 * Date: 2014-01-06
 **/
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/config.h>
#include <linux/module.h>
#include <linux/signal.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <linux/resource.h>
#include <asm/types.h>
#include <asm/irq.h>
#include <asm/mach-ralink/surfboardint.h>

#include <gpio.h>
#include <btn.h>

//#define BTN_DEBUG

#ifdef BTN_DEBUG
    #define BTN_TRACE printk
#else
    #define BTN_TRACE(str, args...)  do { ; } while(0);
#endif


extern struct btn_dev mt7620a_btns[];  /* mt7620a_product.c */
extern void mt7620a_gpio_mode(int gpio);
extern void mt7620a_gpio_config_input(int gpio);
extern btn_status mt7620a_get_in(int gpio);

static void gpio_interrupt_ctrl(struct btn_dev *btn, unsigned char enable)
{
	unsigned char edge = IRQF_TRIGGER_NONE;

	if(enable) {
		if(BTN_LEVEL_HIGH == btn->level) {/* Trigger at rising edge */
			edge = IRQF_TRIGGER_RISING;
		} else {/* Trigger at falling edge */
			edge = IRQF_TRIGGER_FALLING;
		}
	}
	gpio_set_edge(btn->gpio, edge);
}

/* ͨ˺ðť״̬ */
btn_status mt7620a_get_status(struct btn_dev *btn)
{
	int state;
	
	if(btn->gpio < GPIO73) {
		state = gpio_read(btn->gpio);
	} /*else {
		state = btn_level[btn->gpio - GPIO95];
	}*/
	
	BTN_TRACE("button %d is on state %d\n", btn->name, state);

	/* ǵ͵ƽ */
	if(btn->level == BTN_LEVEL_LOW)
	{
		if(state == 0)
			return BTN_DOWN;
		else
			return BTN_UP;
	}
	else
	{   /* Ǹߵƽ */
		if(state == 0)
			return BTN_UP;
		else
			return BTN_DOWN;
	}

}

void mt7620a_button_irq(unsigned long data)
{
    struct btn_dev *btn = (struct btn_dev *)data;
    int state = gpio_read(btn->gpio);

    BTN_TRACE("button %d down, state=%d\n", btn->name, state);

    if ((btn->level == BTN_LEVEL_LOW && !state)
        || (btn->level == BTN_LEVEL_HIGH && state))
    {
        btn->cur_status =  BTN_DOWN;
		BTN_TRACE("button %d down, gpio=%d\n", btn->name, btn->gpio);
		btn_status_query(btn);
    }
    else if ((btn->level == BTN_LEVEL_LOW && state)
        || (btn->level == BTN_LEVEL_HIGH && !state))
    {
		btn->cur_status = BTN_UP;
		BTN_TRACE("button %d up, gpio=%d\n", btn->name, btn->gpio);
    }

    /* Enable IRQ first again */
    gpio_interrupt_ctrl(btn, 1);/* Enable IRQ */
}

irqreturn_t mt7620a_gpio_irq_dispatch(int cpl, void *dev_id)
{
    struct btn_dev *btn = NULL;
	int i;

	//gxw / 2014-09-23 / ͳһʹ.nameΪʵ
    for(i = 0; mt7620a_btns[i].name != btn_end; i++) {
		btn = &mt7620a_btns[i];
		if(gpio_get_ins(btn->gpio)) {/* Read IRQ status and make it clean */
			gpio_interrupt_ctrl(btn, 0);/* Disable IRQ first */
			mt7620a_button_irq(btn);
		}
    }

    return IRQ_HANDLED;
}

static int __init mt7620a_btn_init(void)
{
	int ret;
	int i;
	struct btn_dev *btn = NULL;
	
	for(i=0;mt7620a_btns[i].name != btn_end; i++)
	{
		btn = &mt7620a_btns[i];
		
		/* ʼBTN豸ĳʼ״̬ */
		btn->get_status = mt7620a_get_status;

		btn->cur_status = BTN_UP;

		if(btn->gpio < GPIO73) { /* GPIO 0~72 support interrupt ONLY */
			gpio_config(btn->gpio, GPIO_IN);/* Buttons should be working at GPIO input mode */
			gpio_interrupt_ctrl(btn, 1);/* Enable IRQ */
		}
		
		ret = btn_dev_register(btn);
		if (ret != 0) {
			printk (KERN_ERR "Unable to register btn_dev %d(error %d)\n", btn->name, ret);
			return -1;
		}	
	}

	ret = request_irq(SURFBOARDINT_GPIO, mt7620a_gpio_irq_dispatch, IRQF_SHARED, "TBS_BTN", btn);
	if(ret != 0) {
		printk(KERN_ERR "unable to request IRQ for GPIO (error %d)\n", ret);
	} else {
		printk("TBS button driver for %s initialized, IRQ=%d\n", __FUNCTION__, SURFBOARDINT_GPIO);
	}

	return 0;
}


static void __exit mt7620a_btn_exit(void)
{
	struct btn_dev *btn = NULL;
	int i;

	for(i=0;mt7620a_btns[i].name != btn_end; i++) {
		btn = &mt7620a_btns[i];
		if(btn->gpio < GPIO73) { /* GPIO 0~72 support interrupt ONLY */
			gpio_interrupt_ctrl(btn, 0);/* Disable IRQ first */
		}
		btn->cur_status = BTN_START;
		btn->get_status = NULL;
	}
	free_irq(SURFBOARDINT_GPIO, btn);
}

module_init(mt7620a_btn_init);
module_exit(mt7620a_btn_exit);

MODULE_AUTHOR("Su Denghai");
MODULE_DESCRIPTION("Ralink buttons driver");
MODULE_LICENSE("GPL");
