/*
 * ļ:led.h
 * ˵:TBS LEDͷļ
 * 
 * :Zhang Yu
 *
 */
 
#ifndef __LINUX_LEDS_CORE_H_INCLUDED
#define __LINUX_LEDS_CORE_H_INCLUDED

#if 0
#ifdef __KERNEL__
#include <linux/kernel.h>
#endif
#include <gpio.h>
#endif

#ifdef CONFIG_LED_DEBUG
	#ifdef _LINUX_KERNEL_H
		#define leddebug(fmt, arg...)		 printk(fmt, arg...)
	#else
		#define leddebug(fmt, arg...)		 printf(fmt, arg...)
	#endif
#else
	#define leddebug(fmt, arg...)            do{}while(0)
#endif

#define LED_NAME_MAX	32
#define TRIG_NAME_MAX	32
#define LED_TRIG_TTL_MAX             0x7FFFFFFF


typedef enum  {
	led_power	= 0,	
	led_power_amber,	/* 1 */
	led_power_green,	
	led_power_red,
	led_link_rate_amber,
	led_link_rate_green,/* 5 */
	led_link_rate_red,	
	led_attach,
	led_attach_amber,
	led_attach_green,
	led_attach_red,		/* 10 */
	led_internet,
	led_usb,
	led_wlan,
	led_wps,
	led_wps_green,		/* 15 */
	led_wps_red,		
	led_wps_yellow,
	led_lan_1,
	led_lan_2,
	led_lan_3,			/* 20 */
	led_lan_4,			
	led_lan_5,

	/*For Netgear Repeater add by sudenghai 2014-10-17*/
	led_router_arrow_left,
	led_client_arrow_right,
	led_router_green,   /* 25 */
	led_router_red,
	led_router_amber,
	led_client_green,
	led_client_red,
	led_client_amber,
	/*End by sudenghai 2014-10-17*/

	led_end,		 	/*  */
}led_name;

typedef enum  {
	led_off_trig	= 0,
	led_on_trig,
	led_flash_trig,
	led_flash_4hz_trig,
	led_dataflash_trig,
	led_wps_inprogress_trig,
	led_wps_error_trig,
	led_wps_overlap_trig,
	led_wps_success_trig,
	led_blinking_trig,
	led_end_trig,
}trig_name;

typedef enum  {
	LED_GPIO_LOW  = 0,
	LED_GPIO_HIGH,
}led_level;


typedef enum  {
	LED_BOOT_OFF  = 0,
	LED_BOOT_ON,
}led_boot_default;

struct led_dev {
	led_name    name; 
	int	        gpio;    /* GPIO */
	led_level   level;   /* ߵ͵ƽ */
	trig_name   kernel_default; /* kernelĬ״̬ */
	led_boot_default boot_default; /* BootloaderĬ״̬ */
	struct led_trigger *cur_trig;  /* ǰtrigger */
	void	*trigger_data;
};

struct led_trigger {
	trig_name name;
	void	(*activate)(struct led_dev *led_cdev);
	void	(*deactivate)(struct led_dev *led_cdev);
};


struct led_hw_handler {
	void	(*led_on)(struct led_dev *led_cdev);
	void	(*led_off)(struct led_dev *led_cdev);
};



extern struct led_hw_handler* globe_led_hw_handler;   /* LEDƾȫʹ */

int led_dev_register(struct led_dev *led);
int led_dev_unregister(struct led_dev *led);

int led_trigger_register(struct led_trigger *trig);
int led_trigger_unregister(struct led_trigger *trig);

int led_hw_handle_register(struct led_hw_handler *handler);
int led_hw_handle_unregister(struct led_hw_handler *handler);

int led_trigger_set(led_name led, trig_name trigger);
int led_wps_set(trig_name trigger);

trig_name led_trigger_get(led_name led);
void led_set_on(struct led_dev *led);
void led_set_off(struct led_dev *led);



/* ioctl led  */

struct tbs_ioctl_led_parms
{
	led_name led;
	trig_name trig;
};

#endif		/* __LINUX_LEDS_CORE_H_INCLUDED */
