/*
 * (C) Copyright 2002
 * Sysgo Real-Time Solutions, GmbH <www.elinos.com>
 * Marius Groeger <mgroeger@sysgo.de>
 *
 * Copyright (C) 2001  Erik Mouw (J.A.K.Mouw@its.tudelft.nl)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307	 USA
 *
 */

#include <common.h>
#include <command.h>
#include <image.h>
#include <zlib.h>
#include <asm/byteorder.h>

DECLARE_GLOBAL_DATA_PTR;

//add by wyh start at 2014-05-17
extern unsigned int set_wifi_nmrp;
//add by wyh end
extern int do_reset (cmd_tbl_t *cmdtp, int flag, int argc, char *argv[]);
extern int uncompressLZMA ( Bytef *ptrDest,uLongf *destLen, Bytef *ptrSrc, uLong sourceLen);
extern int	is_sysdata(sys_config_t *syscfg);
extern int flash_read_buf(flash_info_t * info, void* addr, unsigned char ** buf, int len);
static void setup_commandline_tag (bd_t *bd, char *commandline);

/*cmd_boot.c*/

int do_bootm_linux (unsigned int src)
{
	int ret;
	unsigned int entry;
	unsigned int comprLen;
	unsigned int uncompressedLength;
	void (*theKernel)(void );
	unsigned char *buf;

	entry = CFG_SDRAM_BASE + KERNEL_OFFSET;

	/* ע: comprLenʾںѹļvmlinux.bin.lzmaĴС봦ļ
	   Сɶѹں˲޸ĳ3Mѹں˴С*/
	comprLen = 1024*1024*3;

    eth_halt();  /* ֱbootmûйر */
    memset ((void *)entry, 0, comprLen); /* ѹռ */
        
	//reset uncompressedLength again
	uncompressedLength = 0xFFFFFFFF;

	printf ("## Transferring Linux code from 0x%x to 0x%x... ",src,entry);

	/*ע: KERNEL_OFFSET_TMP ʾںѹļflashŵڴеĿʼƫƣƫ֮ǰڴ
	  ǴŽѹںˣں̫ʱƫǰĿռҲҪӴ󣬷û㹻ڴ
	  ţ޸ĳ8MƫƵĵط*/
	buf = ( unsigned char * )( CFG_SDRAM_BASE + KERNEL_OFFSET_TMP );
	flash_read_buf( info , ( unsigned char * ) src , &buf , comprLen );	
	
	src = ( unsigned int )buf;

	ret = uncompressLZMA( ( Bytef *) entry , ( uLongf *) &uncompressedLength , ( Bytef *) src, comprLen);

	theKernel = (void (*)(void))entry;	   

	if(!ret)
	{
		printf("##ok!\n\r");

	}
	else
	{
		printf("##failed!\n\r");
		return 1;
	}

	/* we assume that the kernel is in place */
	if(!ret)
	{
		printf ("Starting kernel111 ...\n\r");

		//cleanup_before_linux ();

		theKernel();
		
		return 0;
	}
	return 0;
}

int prepare_tags()
{
	bd_t *bd = gd->bd;

#ifdef CONFIG_CMDLINE_TAG
//modify by wyh start at 2014-05-27
#ifndef CONFIG_APPS_LOGIC_NMRP
	char *commandline = { CONFIG_BOOTARGS };
#else
	char commandline[128] = { 0 };

	if(set_wifi_nmrp) //if pressed reset&wps button, then set nmrp=1
	{
		sprintf(commandline, CONFIG_BOOTARGS, 1); //set nmrp=1
	}
	else
	{
		sprintf(commandline, CONFIG_BOOTARGS, 0); //set nmrp=0
	}
#endif
//modify by wyh end
#endif

	/* pass tags for Linux kernel */    
	bd->bi_boot_params = BOOTARGS_OFFSET;

#ifdef CONFIG_CMDLINE_TAG
	setup_commandline_tag (bd, commandline);
#endif
	return 0;
}

static void setup_commandline_tag (bd_t *bd, char *commandline)
{
	int n[3] = {0};
#if defined(CONFIG_APPS_LOGIC_NETGEAR_POT) && defined(CONFIG_APPS_LOGIC_MULTILANG)
	/*Netgear spec(5.6 POT Power-on Time) support*/
	#define PARTINFO "%d(boot),%d(pot),%d(kernel),%d(rootfs),%d(rotating),%d(def_lang1),%d(def_lang2),%d(def_lang3),%d(def_lang4),%d(def_lang5),-(tail)"
#elif defined(CONFIG_APPS_LOGIC_NETGEAR_POT) && !defined(CONFIG_APPS_LOGIC_MULTILANG)
	#define PARTINFO "%d(boot),%d(pot),%d(kernel),-(rootfs)"
#elif CONFIG_APPS_LOGIC_MULTILANG
	#define PARTINFO "%d(boot),%d(kernel),%d(rootfs),%d(multi_lang),-(tail)"
#else 
	#define PARTINFO "%d(boot),%d(kernel),-(rootfs)"
#endif
	char *p;
	char partinfo[256];
	sys_config_t* syscfg;
	
	syscfg =(sys_config_t*)SYSCFG_OFFSET;

	if(!is_sysdata(syscfg))
	{
		printf ("syscfg error\n");
		return;
	}

#ifdef CONFIG_DOUBLE_BACKUP
	if( syscfg->image_mark == 0 )
	{
		sprintf(partinfo,  "%d(boot),%d(kernel),%(rootfs)",			
			syscfg->layout.zone_offset[ZONE_KERNEL_FIRST] - syscfg->layout.zone_offset[ZONE_BOOTLOADER],
			syscfg->layout.zone_offset[ZONE_ROOTFS_FIRST] - syscfg->layout.zone_offset[ZONE_KERNEL_FIRST]);
	}
	else
	{
		sprintf(partinfo,  "%d(boot),%d(kernel),-(rootfs)",			
			syscfg->layout.zone_offset[ZONE_KERNEL_SECOND] - syscfg->layout.zone_offset[ZONE_BOOTLOADER],
			syscfg->layout.zone_offset[ZONE_ROOTFS_SECOND] - syscfg->layout.zone_offset[ZONE_KERNEL_SECOND]);
	}

#else
#if 1  
	sprintf(partinfo,  PARTINFO,			
		syscfg->layout.zone_offset[ZONE_KERNEL_FIRST] - syscfg->layout.zone_offset[ZONE_BOOTLOADER] 
#ifdef CONFIG_APPS_LOGIC_NETGEAR_POT
		- NETGEAR_POT_LENGTH,
		NETGEAR_POT_LENGTH
#endif
		,
		syscfg->layout.zone_offset[ZONE_ROOTFS_FIRST] - syscfg->layout.zone_offset[ZONE_KERNEL_FIRST]
    
/*0x10000 is reserve for multi language0*/
/*0x10000 is reserve for multi language1*/
/*0x10000 is reserve for multi language2*/
/*0x10000 is reserve for multi language3*/
/*0x10000 is reserve for multi language4*/
/*0x10000 is reserve for multi language5*/
/*0x10000 is reserve for file crc tail*/
#ifdef CONFIG_APPS_LOGIC_MULTILANG
,syscfg->layout.zone_offset[ZONE_MULTI_LANG] - syscfg->layout.zone_offset[ZONE_ROOTFS_FIRST]
,0x10000,0x10000,0x10000,0x10000,0x10000,0x10000
#endif
);
#else
//add by zhengmingming 
#define DEFLANG_IMAGE_LEN 3735552  //4M - 0x30000(boot) - 0x20000 -0x20000
	n[0] = syscfg->layout.zone_offset[ZONE_KERNEL_FIRST] - syscfg->layout.zone_offset[ZONE_BOOTLOADER];
	n[1] = syscfg->layout.zone_offset[ZONE_ROOTFS_FIRST] - syscfg->layout.zone_offset[ZONE_KERNEL_FIRST];
	n[2] = DEFLANG_IMAGE_LEN - n[1];
	sprintf(partinfo,  PARTINFO, n[0], n[1], n[2], 0x20000, 0x20000);

#endif



#endif

	if (!commandline)
		return;

	/* eat leading white space */
	for (p = commandline; *p == ' '; p++);

	/* skip non-existent command lines so the kernel will still
	 * use its default command line.
	 */
	if (*p == '\0')
	{
		printf("please define CONFIG_BOOTARGS in bootloader header file.\n");
		return;
	}
	
	strcpy ( ( unsigned char * ) bd->bi_boot_params , p );
	strcat ( ( unsigned char * ) bd->bi_boot_params , partinfo );

    	debug("bootargs:%s \n",bd->bi_boot_params);
}
