#define _GNU_SOURCE
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <syslog.h>
#include <time.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/file.h>

#include <sys/time.h>
#include <sys/resource.h>
#include <sys/fcntl.h>
#include <sys/ioctl.h>
#include <net/if.h>

#include <linux/sockios.h>



#include "tbsutil.h"
#include "common_func.h"


int tbsEnableCore(int iFlag)
{
    int iRes = RLIMIT_CORE;
    struct rlimit stRlim;

    /* coreļ */
    stRlim.rlim_cur = stRlim.rlim_max = iFlag ? RLIM_INFINITY : 0;
    if (0 != setrlimit(iRes, &stRlim))
    {
        printf("Error: setrlimit failed, %s\n", strerror(errno));
        return TBS_FAILED;
    }
    else
    {
        /* coreļɵ· */
        system("echo /var/core > /proc/sys/kernel/core_pattern");
        printf("Set coredump file size to %lu, path = /var/core\n", stRlim.rlim_cur);
        return TBS_SUCCESS;
    }

    return TBS_FAILED;
}
int test_tbsSystem(char *command, int printFlag)
{
	int pid = 0, status = 0;

    if( !command )
    {
        printf("tbsSystem: Null Command, Error!");
        return -1;
    }

	pid = fork();
  	if ( pid == -1 )
  	{
		return -1;
	}

  	if ( pid == 0 )
  	{
        char *argv[4];
    	argv[0] = "sh";
    	argv[1] = "-c";
    	argv[2] = command;
    	argv[3] = 0;
    	if (printFlag)
    	{
            printf("[system]: %s\r\n", command);
        }
    	execv("/bin/sh", argv);
    	exit(127);
	}

  	/* wait for child process return */
  	do
  	{
	  	if ( waitpid(pid, &status, 0) == -1 )
    	{
	    	if ( errno != EINTR )
    		{
            	return -1;
      	    }
	    }
    	else
    	{
	    	return status;
		}
	} while ( 1 );

	return status;
}



int main(int argc, char **argv)
{
    int iRet = 0;
    int iType = 0;
    unsigned long long a = 12;
    unsigned long long b = 3;

    iRet = a/b;

    tbsEnableCore(1);

    printf("tbs test tools.\n");
    iType = atoi(argv[1]);

    switch(iType)
    {
        case 0:
        {
            test_tbsSystem("echo add:0#3 0 1 111111111111111111111111111111111111111111111111111111111111 222222222222222222222222222222222222222222222222222222222222 333333333333333333333333333333333333333333333333333333333333 444444444444444444444444444444444444444444444444444444444444 555555555555555555555555555555555555555555555555555555555555 666666666666666666666666666666666666666666666666666666666666 777777777777777777777777777777777777777777777777777777777777 888888888888888888888888888888888888888888888888888888888888 999999999999999999999999999999999999999999999999999999999999#4 3 0 0 0 > /proc/filter_table", 1);
            break;
        }
        case 1:
        {
            printf("core test.\n");
            
            break;
        }
        case 2:
        {
            char *pcPos = NULL;
            printf("Memory leak test.\n");

            pcPos = malloc(100);
            //Mem_PrintStatus();
            break;
        }
        case 3:
        {
            char *pcPos = NULL;
            printf("Memory exceed test.\n");

            pcPos = malloc(100);
            pcPos[101] = 0x01;
            free(pcPos);
            //Mem_PrintStatus();
            break;
        }
        default:
            printf("Usage: %s type", argv[0]);
            break;
    }

    return iRet;
}

