#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "tbserror.h"

typedef struct __error_info
{
  int errnum;
  const char *const msg;
}error_info;


/*
Ҫ:
1. ӦTR069
2. ӢĽ
3. Ľ

*/


static const error_info error_table[] =
{
    {TR069_ERRNO_UNSUP_FUNC,      "Method not supported"},
    {TR069_ERRNO_REJECT,          "Request denied"},
    {TR069_ERRNO_CPE_ERR,         "Internal error"},
    {TR069_ERRNO_INVALID_PARAM,   "Invalid arguments"},
    {TR069_ERRNO_NO_RESOURCE,     "Resources exceeded"},
    {TR069_ERRNO_INVALID_NAME,    "Invalid parameter name"},
    {TR069_ERRNO_INVALID_TYPE,    "Invalid parameter type"},
    {TR069_ERRNO_INVALID_VAL,     "Invalid parameter value"},
    {TR069_ERRNO_WRITE_FORBID,    "Attempt to set a non-writable parameter"},
    {TR069_ERRNO_NOTI_REQ_REJ,    "Notification request rejected"},
    {TR069_ERRNO_DOWNLOAD_FAIL,   "Download failure"},
    {TR069_ERRNO_UPLOAD_FAIL,     "Upload failure"},
    {TR069_ERRNO_FS_AUTHFAIL,     "File transfer server authentication failure"},
    {TR069_ERRNO_FS_NOTSUPP,      "Unsupported protocol for file transfer"},

    {TBS_FAILED,                  "failure"},
    {TBS_MSG_SEND_ERR,            "message sending failed"},
    {TBS_OUT_OF_MEM,              "memory not enough"},
    {TBS_PARAM_ERR,               "Invalid parameter"},
    {TBS_OUT_OF_SRC,              "Resources not enough"},
    {TBS_TIME_OUT,                "timeout"},
    {TBS_COLLISION,               "collision"},
    {TBS_NULL_PTR,                "NULL pointer"},
    {TBS_LIST_NOT_EMPTY,          "List is not empty"},
    {TBS_LIST_EMPTY,              "List is empty"},
    {TBS_INVALID_INDEX,           "Invalid index"},
    {TBS_INDEX_OVERFLOW,          "Index overflow"},
    {TBS_CORRUPT_STRUCT,          "Corrupt struct"},
    {TBS_NO_INSTANCE,             "Do not found the instance"},
    {TBS_MODULE_BUSY,             "Setting up. Wait a moument"},

};

#define num_error_names  (sizeof(error_table)/sizeof(error_info))

/*=========================================================================*/
/*  : tbsstrerr                                                    */
/*  : ҴӦַ                                 */
/*      : errnum: 룬ӦΪ                                     */
/*      : huangce / 2008-03-19                                             */
/*=========================================================================*/

const char *tbsstrerr (int errnum)
{
    int i;
    const char *msg = "";
    static char buf[32];

    for(i = 0; i < num_error_names; i ++)
    {
        if(error_table[i].errnum == errnum)
        {
            msg = error_table[i].msg;
            break;
        }
    }
    if(i == num_error_names)
    {
        sprintf (buf, "Error %d", errnum);
        msg = buf;
    }
    return msg;
}


int tbserr2tr069(int tbserrno)
{
    int i;
    for(i = 0; i < num_error_names; i ++)
    {
        //TBSдǸ
        if((error_table[i].errnum == tbserrno) && (error_table[i].errnum < 0))
        {
            //TR069ԶĴ뷶ΧΪ9800 - 9899
            return 9900 + error_table[i].errnum;
            break;
        }
    }
    return tbserrno;
}



const ST_TBS_ERR_TABLE g_astTbsErrTable[] =
{
    {ERR_NOT_SUPPORT_FUNCTION,      "Not support this function,now", "ʱַ֧"},
    {ERR_IP_INVALID_FORMAT,         "Invalid IP address. Please enter it again", "IPַЧ"},
    {ERR_PORT_INVALID_FORMAT,       "Invalid port", "Ч˿"},
    {ERR_PORT_TOO_SMALL,            "Port cant be zero or negative,should be in 1-65535",
                                    "˿ֵΪ0, ӦΪ1-65535"},
    {ERR_PORT_TOO_BIG,              "Port should be in 1-65535",  "˿ֵЧӦ1-65535"},
    {ERR_PRIORITY_INVALID_VALUE,    "Invalid priority value",  "ȼ1-8֮"},
    {ERR_PRIORITY_TOO_SMALL,        "Priority too small,should be in 1-8",  "ȼ1-8֮"},
    {ERR_PRIORITY_TOO_BIG,          "Priority too big,should be in 1-8",  "ȼ1-8֮"},
    {ERR_MASK_INVALID_FORMAT,       "Net mask invalid format",  "ʽ"},
    {ERR_MASK_EMPTY,                "net mask can not be emty",  "벻Ϊ"},
    {ERR_MAKS_ALL_ZERO,             "net mask can not be zero",  "벻Ϊȫ0"},
    {ERR_MASK_INVALID_VALUE,        "the left part of subnet mask must be continuous binary ",  "Ӧ"},
    {ERR_ENABLE_EMPTY,              "enable should not be zero", "enable Ϊ"},
    {ERR_ENABLE_INVALID_VALUE,      "bool val must be \"0\" or \"1\"", "Ϊ\"0\" \"1\""},
    {ERR_INT_INVALID_VALUE,         "must be int value",  ""},
    {ERR_UINT_INVALID_VALUE,        "must be unsigned int", ""},
    {ERR_MAC_INVALID_VALUE,         "Invalid MAC or format is not \"xx:xx:xx:xx:xx:xx\"",  "ϷMACַʽxx:xx:xx:xx:xx:xxָʽ"},
    {ERR_IPLIST_TOO_MANY,           "ip number more than max limit",  "IP"},
    {ERR_IPLIST_INVALID_FORMAT,     "valid ip list format",  "IP бʽ"},
    {ERR_MACLIST_INVALID_FORMAT,    "valid mac list format",  "MAC бʽ"},
    {ERR_MACLIST_TOO_MANY,          "too many mac",  "mac "},
    {ERR_INSTANCE_TOO_MANY,         "too many instance,can not add new one",  "Ѵʵޣ"},
    {ERR_INSTANCE_IMMUTABLE,        "this instance can not be delete",  "òɾ"},
    {ERR_INNER_MSG_INVALID,         "inner msg format error",  "ڲϢϵ"},
    {ERR_INNER_MSG_REPEATED_NAME,   "inner msg has repeated name",  "ڲϢͬͣϵ"},
    {ERR_INNER_CACHE_INVALID,       "inner cache error",  "ڲṹϵ"},
    {ERR_IP_MASK_NOT_MATCH,         "IP address does not match with the subnet mask ",  "IPַ벻ƥ"},
    {ERR_IP_IS_HOST_ADDR,           "IP address can not be host address ",  "Ϊصַ"},
    {ERR_IP_IS_CAST_ADDR,           "IP address can not be broadcast address ",  "Ϊ㲥ַ"},
    {ERR_IP_ADDR_START_MINOR_END,   "IP End Address can not less than start address ",  "ַСڿʼַ"},
    {ERR_IP_ADDR_POOL_OVERLAP,      "IP address pool overlaps ",  "IPַسͻ"},
    {ERR_STR_TOO_LONG,              "String is too long ",  "ַ"},
    {ERR_CAN_NOT_EMPTY,             "the value can not be empty ",  "Ϊ"},
    {ERR_GET_NODE_VALUE_FAIL,       "get node value failed ",  "ȡڵֵʧ"},
    {ERR_SET_NODE_VALUE_FAIL,       "Set node value failed ",  "ýڵֵʧ"},
    {ERR_INVALID_DOMAIN_NAME,       "Domain name must be \"xxxxx.xxxxxx.xxxx.xxx\" format",
                                    "Ӧ\" xxxx.xxxx.xxxx.xxxx\" ָʽ"},
    {ERR_OUT_OF_RANGE,              "the value out of range", "ֵָķΧ"},
    {ERR_IPLIST_HAS_REPEAT,         "IP list has to repeat", "бظIPַ"},
    {ERR_IP_IS_WRONG_NET_SECTION,   "wrong net section", "IPַδ"},
    {ERR_IP_IS_WRONG_LAN_NET_SECTION, "This IP address should be in the same subnet as the LAN IP address.","IPַӦIPַͬһ."},
    {ERR_IP_IS_CAST_OR_NET_ADDR,    "IP address can not be broadcast address or net address",  "Ϊ㲥ַַ"},
    {ERR_ENABLE_DHCPS_CONFLICT_DHCPR, "DHCP couldnt perform as server and relay simultaneously", "DHCPͬʱServerRelay"},
    {ERR_PORT_RANGE_INVALID,        "invalid portrange (min > max)", "ЧĶ˿ڷΧ(˿>ʼ˿)"},
    {ERR_INVALID_VAL,               "invalid value", "Чֵ"},
    {ERR_LIST_HAS_REPEAT,           "The list are duplicates", "бظ"},
    {ERR_PORT_HAS_OCCUPIED,         "The port has occupied","˿ѱռ"},

    {ERR_MSG_MID_INVALID,           "ERR_MSG_MID_INVALID","ERR_MSG_MID_INVALID"},
    {ERR_MSG_SOCKET,                "ERR_MSG_SOCKET","ERR_MSG_SOCKET"},
    {ERR_MSG_PROC_NOT_FOUND,        "ERR_MSG_PROC_NOT_FOUND","ERR_MSG_PROC_NOT_FOUND"},
    {ERR_MSG_SEND_FAIL,             "ERR_MSG_SEND_FAIL","ERR_MSG_SEND_FAIL"},
    {ERR_MSG_DSTMID_UNREGED,        "ERR_MSG_DSTMID_UNREGED","ERR_MSG_DSTMID_UNREGED"},
    {ERR_MSG_NOT_FULL,              "ERR_MSG_NOT_FULL","ERR_MSG_NOT_FULL"},
    {ERR_MSG_PART_NOEFFECT,         "ERR_MSG_PART_NOEFFECT","ERR_MSG_PART_NOEFFECT"},
    {ERR_MSG_PART_INVALID,          "ERR_MSG_PART_INVALID","ERR_MSG_PART_INVALID"},
    {ERR_MSG_TIMEOUT,               "ERR_MSG_TIMEOUT","ERR_MSG_TIMEOUT"},
    {ERR_MSG_PART_LIST_FULL,        "ERR_MSG_PART_LIST_FULL","ERR_MSG_PART_LIST_FULL"},

    {ERR_MALLOC_FAILED,             "ERR_MALLOC_FAILED","ERR_MALLOC_FAILED"},
    {ERR_BUF_NOT_ENOUGH,            "ERR_BUF_NOT_ENOUGH","ERR_BUF_NOT_ENOUGH"},
    {ERR_INTERNAL_ERR,              "ERR_INTERNAL_ERR","ERR_INTERNAL_ERR"},
    {ERR_PARA_INVALID,              "ERR_PARA_INVALID","ERR_PARA_INVALID"},
    {ERR_FILE_OPEN,                 "ERR_FILE_OPEN","ERR_FILE_OPEN"},
    {ERR_FILE_READ,                 "ERR_FILE_READ","ERR_FILE_READ"},
    {ERR_FILE_WRITE,                "ERR_FILE_WRITE","ERR_FILE_WRITE"},
    {ERR_FILE_CHKSUM,               "ERR_FILE_CHKSUM","ERR_FILE_CHKSUM"},
    {ERR_BUSY,                      "ERR_BUSY","ERR_BUSY"},
    {ERR_CREATE_MSG_FAIL,           "ERR_CREATE_MSG_FAIL","ERR_CREATE_MSG_FAIL"},
    {ERR_MSG_EXT_MID_LIST_FULL,     "ERR_MSG_EXT_MID_LIST_FULL","ERR_MSG_EXT_MID_LIST_FULL"},

    {ERR_FILE_OPEN_EXSITED,         "The file name has exsited!",               "ͬļѾ"},
    {ERR_FILE_WTITE_NOSPACE,        "Has not enoupgh space!",                   "û㹻ռ"},
    {ERR_FILE_NOT_ALLOWED,          "Has no rights to opt the file",            "û㹻Ȩ޲ļ"},
    {ERR_FILE_RM_UNKOWN,            "Unkown error ocurred when remove the file","ɾļʱδ֪"},
    {ERR_FILE_OPEN_UNKOWN,          "Failed to save the file",                  "ļʧ"},
    {ERR_FILE_WRITE_UNKOWN,         "Failed to save the file",                  "ļʧ"},
    {ERR_IP_INVALID_RANGE,     	    "Invalid IP address range",                         "IPַΧЧ"},

#ifdef CONFIG_TBS_SUPPORT_IPV6
	{ERR_IPV6_INVALID_FORMAT,     "Invalid ipv6 address format", "Ƿipv6ַʽ"},
    {ERR_IPV6_ADDR_REPEAT,        "Repetitive ipv6 address exists", "ظipv6ַ"},
    {ERR_IPV6_INVALID_PREFIX_LEN, "Invalid ipv6 prefix length", "Ƿipv6ǰ׺"},
    {ERR_IPV6_INVALID_DUID,       "Invalid DUID", "ǷDUID"},
    {ERR_INVALID_PROTO_TYPE,        "Invalid proto type", "ǷЭ"},
    {ERR_NOT_IPv6_GLOBAL_UNIQUE_ADDR,       "Not global uniquie address", "ȫΨһַ"},
#endif
    {ERR_INVALID_SCHEDULE_PATH,     "Invalid schedule path",                    "Чschdule·"},
    {ERR_INVALID_FILTER_MODE,       "Invalid filter mode",                      "ЧĹģʽ"},
    {ERR_INVALID_CHARACTERS,        "Invalid characters inclued in strings",    "ϢкзǷַ"},
    {ERR_DESCRIPTION_DUPLICATE,     "Duplicate Name",    "ظ"},
    


    {ERR_CFG_ATTR_STAT,             "Stat data not support set noti",             "ͳݲ֧noti"},
    {ERR_CFG_PATH_NOT_EXSITED,      "Path not exists",                            "·"},
    {ERR_CFG_INVALID_OBJ_VAL,       "Attemp to set val to obj",                   "ͼԶ·ֵ"},
    {ERR_CFG_INVALID_STRING,        "Invalid string val",                         "Ƿַ"},
    {ERR_CFG_INVALID_INT_0,         "0 must expressed by \"0\", \"+0\"\"-0\"\"00\" are all invalid", "0ֻ\"0\"ʾ, \"+0\"\"-0\"\"00\"ΪǷ"},
    {ERR_CFG_INVALID_INT_01,        "non-zero int must begin with \"+\" or non-zero number", "0ԷŻֵͷ"},
    {ERR_CFG_INVALID_INT_A,         "include invalid char",                       "зǷַ"},
    {ERR_CFG_INVALID_UINT_0,        "0 must expressed by \"0\", \"+0\"\"-0\"\"00\" are all invalid", "0ֻ\"0\"ʾ, \"+0\"\"-0\"\"00\"ΪǷ"},
    {ERR_CFG_INVALID_UINT_01,       "non-zero uint must begin non-zero number",   "0޷ԷŻֵͷ"},
    {ERR_CFG_INVALID_UINT_A,        "include invalid char",                       "зǷַ"},
    {ERR_CFG_INVALID_BOOL,          "bool val must be \"0\" or \"1\"",                "Ϊ\"0\" \"1\""},
    {ERR_CFG_INVALID_TIME,          "dateTime val must be like \"0000-00-02T03:04:05\"", " \"0000-00-02T03:04:05\""},
    {ERR_CFG_INVALID_HEX,           "Hex val must be number or A-F a-f",          "ʮֻa-f A-F"},
    {ERR_CFG_NOT_WRITABLE,          "The path not writable",                      "·д"},
    {ERR_CFG_NOT_IN_ACCESSLIST,     "Not in accesslist",                          "ڿɷб"},
    {ERR_CFG_PATH_NOT_INST,         "The path is not a valid inst",               "·һϷĶʵ"},
    {ERR_CFG_NOT_STANDARD,          "The path is not a standard path",            "·һ׼·"},
    {ERR_CFG_INVALID_TYPE,          "The node type is invalid",                   "ڵͷǷ"},
    {ERR_CFG_ITEM_OPT_FAIL,         "App config flash opt failed",                "Flashݲʧ"},
    {ERR_CFG_WILDCARD_QUE_FULL,     "Wildcard queue has been full",               "ͨ·"},
    {ERR_CFG_INVALID_PATH,          "Invalid path",                               "Ƿ·"},
    {ERR_CFG_OBJ_INST_FULL,         "Max number of rules reached.",    "Ѵﵽ."},

    {ERR_CMM_NOMID,                 "Not support the opt to this path",           "ǰָ֧·в"},

    {ERR_DGN_INVALID_STATE,         "invalid state (must be \"Requested\")",        "Ƿ״ֵ̬(\"Requested\")"},
    {ERR_DGN_INVALID_INTF,          "invalid intf (not exsited)",                 "Ƿӿ()"},
    {ERR_DGN_INVALID_HOST_IP_PART,  "invalid host (not support partly ip)",  "Ƿ(ǰֲ֧ipַ)"},
    {ERR_DGN_INVALID_HOST_IP_OCT,   "invalid host (not support oct format ip)", "Ƿ(ǰְ֧˽Ƶipַ)"},
    {ERR_DGN_INVALID_HOST_BEGIN,    "invalid host (must begin with number,char or \"_\")", "Ƿ(ĸ\"_\"ʼ)"},
    {ERR_DGN_INVALID_TIMES,         "invalid Repeat times",                      "Ƿظ"},
    {ERR_DGN_INVALID_TO,            "invalid timeout",                            "Ƿʱʱ"},
    {ERR_DGN_INVALID_SIZE,          "invalid data size",                          "ǷݰС"},
    {ERR_DGN_INVALID_DSCP,          "invalid DSCP",                               "ǷDSCPֵ"},
    {ERR_DGN_NOHOST,                "not set host",                               "ǰδ"},
    {ERR_DGN_INVALID_HOST_A,        "invalid host (must not contain char except \".\", \"_\", \"-\", \"@\", a-z A-Z 0-9)",    "Ƿ(ܰ\".\", \"_\", \"-\", \"@\", ĸַ֮)"},
    {ERR_DGN_INVALID_HOST_LEN,      "invalid host (too long, exceeding 256)",    "̫(256ַ)"},

    /* AUTH */
    {ERR_AUTH_CANNOT_CHANGE_USER,   "cannot modify user name","޸û"},
    {ERR_AUTH_CANNOT_CHANGE_LEVEL,  "cannot modify user name","޸û"},
    {ERR_AUTH_CANNOT_REMOVE_ADMIN,  "cannot remove admin","ɾadminû"},
    {ERR_AUTH_HAVE_SAME_USER,       "have same user","ͬû"},
    {ERR_AUTH_PASSWORD_TOO_LONG,    "password length must less than 32","볤ȱС32"},
    {ERR_AUTH_USERNAME_TOO_LONG,    "user name length must less than 32","ûȱС32"},
    {ERR_AUTH_SESSION_FULL,         "Too many users log on, Please wait a minute","¼û"},
    {ERR_AUTH_WRONG_USER,           "Username wrong","û"},
    {ERR_AUTH_WRONG_PASSWORD,       "Password wrong",""},
    {ERR_AUTH_WRONG_USER_OR_PWD,    "Incorrect password. Please try again","û"},
    {ERR_AUTH_SESSION_TIMEOUT,      "Session is timeout","Ựʱ"},
    {ERR_AUTH_SESSION_ILLEGAL,      "Inadequate access","Ȩ޲"},
    {ERR_AUTH_LOGIN_FREQUENT,       "Please login in one minute","һӺٵ¼"},
    {ERR_AUTH_LOGOUT_SUCCESS,       "Logout success","עɹ"},
    {ERR_AUTH_OLDPASSWORD_INVALID,  "The old password is wrong",""},
#ifdef CONFIG_APPS_LOGIC_PASSWORD_RECOVERY    
    {ERR_AUTH_PWRECOVER_ANSWER,	"invalid answer", "شдڷǷַ"},
    {ERR_AUTH_PWRECOVER_ANSWER_TOO_LONG,	"the length of answer must lessthan 64", "شϢȱС64"},
		{ERR_AUTH_PR_ANSER_RIGHT,	"password recoverey answer right", "ָشȷ"},
		{ERR_AUTH_PR_ANSER_WRONG,	"password recoverey answer wrong", "ָش"},
		{ERR_AUTH_PR_SN_RIGHT,	"device serial number right", "豸кȷ"},
		{ERR_AUTH_PR_SN_WRONG,	"device serial number wrong", "豸кŴ"},
		{ERR_AUTH_PR_ANSER1_WRONG,	"password recoverey answer wrong", "ָش"},
		{ERR_AUTH_PR_ANSER2_WRONG,	"password recoverey answer wrong", "ָش"},

#endif

    /* WAN */
    {ERR_WAN_INVALID_INNER_MSG,     "inner msg error",                            "ڲϢ"},
    {ERR_WAN_INVALID_VAL,           "get invalid value",                          "ȡֵЧ"},
    {ERR_WAN_INVALID_SVC_LIST,      "Invalid Service List",                          "Ƿķ"},
    {ERR_WAN_INVALID_CONN_TYPE,     "Invalid Connection Type",                       "Ƿ"},
    {ERR_WAN_INVALID_LAN_INTF,      "Invalid Lan Intf",                              "Ƿlanڰ"},
    {ERR_WAN_LAN_INTF_REPEAT,       "The lan intf mutil bind",                       "lanظ"},
    {ERR_WAN_TOO_MORE_BRIDGE,       "Not allowed to Create more than one bridge on the same vlan", "һwan vlanϲ"},
    {ERR_WAN_BRIDGE_ROUTE_MIX,      "Not allowed to mix bridge and route on the same vlan",        "һwan vlanϲź·ӹӵ"},
    {ERR_WAN_TR069_BRIDGE,          "The TR069 service type is not allowed to config on a bridge conn",  "TR069͵wanӲ"},
    {ERR_WAN_TR069_LAN,             "Not allowed to bind lan to a TR069 wan conn",   "TR069͵wanӲlan"},
    {ERR_WAN_INVALID_CONN_PRIOR,    "Invalid connection prior",       "Ƿwanȼ"},
    {ERR_WAN_CONN_COUNT_FULL,       "Wan conn count has reach max",   "wanӸѾﵽ"},
    {ERR_WAN_SAME_SUBNET_WITH_LAN,       "The IP address conflicts with the LAN IP subnet. Please enter a different IP address. ",   "IPIPַͻһ!"},
    
    {ERR_WAN_NOT_EXIST,             "please select a wan connection",   "ѡһwan"},
    {ERR_WAN_INVALID_VLAN_ID,       "Invalid Vlan ID", "Чvlanid"},
    {ERR_WAN_INVALID_VLAN_PRIO,     "Invalid Vlan priority", "Чvlanȼ"},
    {ERR_WAN_NOREOA_LINK_EXIST,     "For one PVC, only one IPOA or PPPOA can be configured", ""},
    {ERR_WAN_EOA_LINK_EXIST,        "For one PVC, MER, PPPOE and Bridging are exclusive with IPOA and PPPOA", ""},
    {ERR_WAN_TOO_MANY_PVC,          "CPE can support up to 8 PVCs", ""},
    {ERR_WAN_CANNOT_CHNG_LINK_TYPE, "For one PVC, more than one MER, PPPOE or Bridging connetion exist, can not change protocol to IPOA or PPPOA", ""},
    {ERR_WAN_ETH_LINK_CONFLICT,     "For one VLAN,only 1 IPOE, 1 Bridging and 4 PPPOE connections can be configured at the same time", ""},
    {ERR_WAN_DSL_LINK_CONFLICT,     "For one (PVC,VLAN), only 1 MER, 1 Bridging and 4 PPPOE connections can be configured at the same time", "һPVC,VLANֻͬʱһţһMERPPPOEӡ"},
    {ERR_WAN_TOO_MANY_ENABLED_PPP,  "CPE can support up to 4 enabled PPPOA/OE connections", ""},
    {ERR_DSL_TOO_MANY_IP_INST,      "For one (PVC,VLAN), only 1 MER, 1 Bridging connections can be configured at the same time", ""},
    {ERR_ETH_TOO_MANY_IP_INST,      "For one VLAN, only 1 IPOE, 1 Bridging connections can be configured at the same time", ""},
    {ERR_WAN_TOO_MANY_IP_PPP_INST,  "For one VLAN, only 2 IPOE, 4 PPPoE connections can be configured at the same time", ""},


    /* LAN */
    {ERR_LAN_INVALID_IP_FORMAT,     "Invalid IP format",             "ǷIPַʽ"},
    {ERR_LAN_INVALID_LAN_IP,        "Invalid LAN IP",             "ǷLAN IPַ"},
    {ERR_LAN_MACLIST_TOO_LONG,      "Mac addreess list too long",             "macַб"},
    {ERR_LAN_INVALID_MACLIST,       "Invalid Mac address",             "macַ"},
    {ERR_LAN_IP_MASK_CONFLICT,      "Net Mask confilct with IP",             "IPַͻ"},
    {ERR_LAN_IP_CONFLICT,           "Repeated IP",             "IPַIPظ"},
    {ERR_LAN_LAST_INSTANCE,         "This is first IP config,cannot delete",             "һIPòɾ"},
    {ERR_LAN_TOO_MANY_INSTANCE,     "Too many LAN IP config",             "LAN IPѾдﵽޣ޷"},
    {ERR_LAN_SAME_REGION_CONFLICT,  "same net region with other lan device,will bring route error",             "LAN IPLANͬᵼVLAN"},
    {ERR_LAN_NOT_EXIST,             "please select a lan interface",             "ѡһlan"},
    {ERR_LAN_WAN_IP_CONFLICT,       "The IP address conflicts with the WAN IP subnet. Please enter a different IP address.",             "IPIPַͻһ."},
#ifdef CONFIG_TBS_SUPPORT_IPV6
	{ERR_LAN_lINKLOCAL_CONFLICT,    "Link local conflict",             "·صַͻ"},
#endif
    /* DNS */
    {ERR_DNS_VALID_DNS_ADDR,                "invalid DNS address",            "DNSַʽ"},
    {ERR_DNS_HAS_REPEAT,                    "DNS address repeat",             "DNSַظ"},
    {ERR_DNS_CUSTOM_BE_EMPTY,               "When allowed to custom DNS, DNS addresses can not be empty",
                                            "ԶDNSʱ, DNSַΪ"},

    /* ETHLAN & ETHWAN */
    {ERR_ETH_INVALID_BITRATE,               "invalid max bit rate",     "Ƿ"},
    {ERR_ETH_INVALID_DUPLEXMODE,            "invalid duplex mode",     "Ƿ˫ģʽ"},

    /* LSVLAN */
    {ERR_LSVLAN_INVALID_BRIDGENAME,         "invalid bridge name",  "Ƿ"},
    {ERR_LSVLAN_INVALID_VLANID,             "invalid Vlan ID",      "ǷVLAN ID"},
    {ERR_LSVLAN_INVALID_FILTERBRREF,        "invalid Filter Bridge Reference",  "Ƿù˹"},
    {ERR_LSVLAN_INVALID_FILTERIF,           "invalid Filter Interface",  "Ƿӿù˹"},
    {ERR_LSVLAN_TOO_MANY_INSTANCE, 	        "too many instance", "ʵ"},
    {ERR_LSVLAN_DEL_FIRST_BRIDGE,           "the first bridge should not be deleted",  "һŲɾ"},
    {ERR_LSVLAN_INSTANCE_IN_USE,            "the instance which is in use should not be deleted", "ʹʵɾ"},
    {ERR_LSVLAN_BRNAME_CONFLICT,            "Bridge name conflict", "Ƴͻ"},
    {ERR_LSVLAN_BRVLAN_CONFLICT,            "Vlan id conflict", "VLAN IDͻ"},
    {ERR_LSVLAN_IF_CONFLICT,                "One interface must belong to only one LAN Group", "һӿֻһLAN Group"},
    {ERR_LSVLAN_WLAN_IF_TAGGED,             "VAP interface should not be tagged mode", "VAPӿڲtaggedģʽ"},
	{ERR_LSVLAN_SAME_IF_IN_VLAN,            "this interface has been used in this vlan", "һӿһVLANֻһ"},
    {ERR_LSVLAN_IF_CONFLICT,                "this interface has been used as untag mode in other vlan", "ӿѾΪuntagģʽټvlan"},

    /* IPCONN */
    {ERR_IPCONN_NAME_TOO_LONG,              "the length of connection name can not over 256",
                                            "ƳȲܳ256"},
    {ERR_IPCONN_NAME_INVALID,               "invalid connection name (only contains the following characters: [-_.@0-9a-zA-Z] ) ",
                                            "Ч(ַֻ: [-_.@0-9a-zA-Z])"},
    {ERR_IPCONN_ADDR_TYPE_INVALID,          "invalid address type value",
                                            "Чĵַ"},
    {ERR_IPCONN_ACTIVE_CONN_OVER,           "the number of active connections to the ceiling",
                                            "ǰӸѵ"},
    {ERR_IPCONN_WAN_CONN_OVER,              "the number of WAN connections to the ceiling",
                                            "ǰWANӸѵ"},
    {ERR_IPCONN_WAN_IPCONN_OVER,            "Each WAN Device allow to create just a IP Connection",
                                            "һWAN豸ֻһIP"},
    {ERR_IPCONN_IP_GATEWAY_SAME,            "Invalid gateway IP address. Please enter it again.",
                                            "IPַЧ"},
    {ERR_IPCONN_NAME_EXISTS,                "Connection Name has exists",
                                            "ظ"},
    {ERR_IPCONN_CONNTYPE_INVALID,           "invalid connection type",
                                            "Ч"},
    {ERR_PPPOE_ACNAME_INVALID,              "invalid AC name",
                                            "ЧAC"},
    {ERR_PPPOE_SERVICENAME_INVALID,         "invalid service name",
                                            "Чķ"},
    {ERR_IPCONN_IP_GATEWAY_NOT_MATCH,       "Invalid gateway IP address. Please enter it again.",
                                            "IPַЧ"},
    {ERR_IPCONN_INVALID_MTU,                "invalid MTU value,the valid range is 616 to 1500 bytes",
                                            "ЧMTUֵ,ЧֵΧ6161500ֽ"},
    {ERR_IPCONN_INVALID_HOSTNAME,           "invalid host name",
                                            "Ч"},
    {ERR_IPCONN_INVALID_VENDORID,           "invalid vendor class id",
                                            "ЧĹӦ̷ID"},
    {ERR_IPCONN_INVALID_RENEWRELEASE,       "invalid release or renew action",
                                            "ЧReleaseRenew"},
                                            


    /* DHCPS */
    {ERR_DHCPS_INVALID_CLASS_ID,            "Unknown class id ", "δ֪ͻ"},
    {ERR_DHCPS_EXIST_CLASS_ID,              "Already exist class id ", "ѴڵĿͻ"},
    {ERR_DHCPS_IFIP_ADDRPOOL_UNMATCH,       "Interface address and dhcp address pool not match", "ӿڵַַزƥ"},
    {ERR_DHCPS_LEASE_TIME, "Lease time not in the limitation", "Լʱ䲻÷Χ"},
    {ERR_DHCPS_CPEIP_POLL_CONFLICT,         "IP address conflicts with DHCP pool", "IPDHCPַسͻ"},
	{ERR_DHCPS_MAC_CONFLICT,                "MAC address conflicts", "MACַͻ"},
	{ERR_DHCPS_IP_CONFLICT,                 "IP address conflicts", "IPַͻ"},
    {ERR_DHCPS_CPEIP_GW_CONFLICT,           "IP address conflicts with DHCP pool default gateway", "IPDHCPĬسͻ"},
    {ERR_DHCPS_INVALID_HOSTNAME,            "Invalid device name", "Ч豸"},
    {ERR_DHCPS_IFIP_ADDRPOOL_CONFLICT,      "Invalid DHCP ending and starting IP address. Please enter them again", "DHCP ʼͽ IP ַЧ"},


    /* PPPOE */
    {ERR_PPPOE_NO_RESOURSE,                 "no resourse",  "ûԴ"},
    {ERR_PPPOE_INVALID_VAL,                 "invalid value",  "Чֵ"},
    {ERR_PPPOE_INVALID_PATH,	            "invalid path", "Ч·"},
    {ERR_PPPOE_EXCEED_CONNECTION_NUM,	    "exceed connection number", ""},
    {ERR_PPPOE_INVALID_INSTANCE,	        "invalid instance", "Чʵ"},
    {ERR_PPPOE_ENABLE_INVALID,	            "invalid enable", "Чenable"},
    {ERR_PPPOE_USERNAME_INVALID,	        "Invalid login name!", "¼Ч!"},
    {ERR_PPPOE_USERNAME_OVERLENTH,	        "username  over  length", "û"},
    {ERR_PPPOE_USERNAME_EMPTY,	            "username empty", "ûΪ"},
    {ERR_PPPOE_PASSWD_INVALID,	            "invalid passwd", "Ч"},
    {ERR_PPPOE_PASSWD_OVERLENTH,	        "passwd over length", "볬"},
    {ERR_PPPOE_PASSWD_EMPTY,	            "passwd empty", "Ϊ"},
    {ERR_PPPOE_CONNETNAME_INVALID,	        "connected name invalid", "Ч"},
    {ERR_PPPOE_CONNETNAME_OVERLENTH,	    "connected name over length", "Ƴ"},
    {ERR_PPPOE_AUTH_INVALID,	            "invalid auth", "ЧļȨʽ"},
    {ERR_PPPOE_MRU_INVALID,	                "MRU invalid", "ЧMRU"},
    {ERR_PPPOE_TRIGGER_INVALID,	            "invalid trigger", "ЧĴʽ"},
    {ERR_PPPOE_CONNACTION_INVALID,	        "connect button invalid", "ֶʽİťЧ"},
    {ERR_PPPOE_LCPECHO_INVALID,	            "LCPECHO invalid", "ЧLCPECHO"},
    {ERR_PPPOE_ACTIVE_CONN_OVER,	        "exceed active connect", "õ"},
    {ERR_PPPOE_INVALID_INNER_MSG,	        "inner message invalid", "ڲϢ"},
    {ERR_PPPOE_INVALID_MATCH_INDEX,	        "the index of message invalid", "Ϣ"},
    {ERR_PPPOE_TRIGGER_INVALID,	            "invalid trigger", "ЧĴʽ"},
    {ERR_PPPOE_CONNACTION_INVALID,	        "connect button invalid", "ֶʽİťЧ"},
    {ERR_PPPOE_LCPECHO_INVALID,	            "LCPECHO invalid", "ЧLCPECHO"},
    {ERR_PPPOE_ACTIVE_CONN_OVER,	        "exceed active connect", "õ"},
    {ERR_PPPOE_INVALID_INNER_MSG,	        "inner message invalid", "ڲϢ"},
    {ERR_PPPOE_INVALID_MATCH_INDEX,	        "the index of message invalid", "Ϣ"},
    {ERR_PPPOE_NO_PPPSESSION,               "no pppsession in flash", "ûpppsession flash"},
    {ERR_PPPOE_NO_PPPSESSION_IDX,           "invalid pppsession idx", "pppsession idx "},
    {ERR_PPPOE_ERROR_PPPSESSION_VAL,        "pppsession  value error", "pppsession ֵ"},
    {ERR_PPPOE_NAME_REPEATED,               "WAN connected name repeated",  "WANظ"},
    {ERR_PPPOE_IDLETIME_INVALID,            "invalid idle disconnect time(valid value is:0~999)",  "Чóʱʱ(ЧֵΪ:0~999)"},
    {ERR_PPPOE_APN_INVALID,                 "invalid apn",  "ЧAPN"},
    {ERR_PPPOE_APN_EMPTY,	                "apn empty",  "APNΪ"},
    {ERR_PPPOE_APN_OVERLENTH,	            "apn over  length",  "APN"},
    {ERR_PPPOE_DIALNUMBER_INVALID,          "invalid dialnumber",  "ЧĲź"},
    {ERR_PPPOE_DIALNUMBER_EMPTY,            "dialnumber empty",  "źΪ"},
    {ERR_PPPOE_DIALNUMBER_OVERLENTH,	    "dialnumber over length",  "ź볬"},
    {ERR_PPPOE_MTU_INVALID,	            "invalid MTU value,the valid range is 616 to 1492 bytes",
                                            "ЧMTUֵ,ЧֵΧ6161492ֽ"},
    {ERR_PPPOE_TOO_MANY_PPPOU_INST,         "CPE can support up to 1 PPPoU connections", "CPEֻһ3G"},
    {ERR_PPPOE_TOO_MANY_PPTP_INST,          "CPE can support up to 1 PPTP connections", "CPEֻһVPN"},
    {ERR_PPPOE_TOO_MANY_L2TP_INST,          "CPE can support up to 1 L2TP connections", "CPEֻһVPN"},
    {ERR_PPPOE_CONNIDNAME_INVALID,	        "invalid  connection id and name", "Чid "},
    {ERR_PPPOE_CONNIDNAME_OVERLENTH,	    "username  over  length", "id "},
    {ERR_PPPOE_CONNIDNAME_EMPTY,	        "username empty", "idΪ"},
    {ERR_PPPOE_VPN_GATEWAY_DISCONNECT,	    "Please check CPE and gateway of the link if connected", "CPE֮·Ƿͨ"},
    /* QOS */
    {ERR_QOS_INVALID_IF_PATH,               "Invalid egress interface" , "Чӿ"},
#ifdef WLAN_QOS_SUPPORT
    {ERR_QOS_INVALID_COMMITTED_RATE,        "To ethernet interface,rate value should be 100-100000Kbps and to VAP interface it should be 100-30000Kbps",
                                            "̫ӿ,ֵӦΪ100-100000Kbps,VAPӿӦΪ100-30000Kbps"},
    {ERR_QOS_INVALID_PEAK_RATE,             "To ethernet interface,rate value should be 100-100000Kbps and to VAP interface it should be 100-30000Kbps",
                                            "̫ӿ,ֵӦΪ100-100000Kbps,VAPӿӦΪ100-30000Kbps"},
#else
    {ERR_QOS_INVALID_COMMITTED_RATE,        "Invalid committed rate value, should be 100-100000Kbps",
                                            "ЧĳŵֵӦΪ100-100000Kbps"},
    {ERR_QOS_INVALID_PEAK_RATE,             "Invalid peak rate value, should be 100-100000Kbps",
                                            "ЧķֵֵӦΪ100-100000Kbps"},
#endif
    {ERR_QOS_INVALID_BURST_SIZE,            "Invalid burst size, should be 2-100", "Чͻ,ӦΪ2-100"},
    {ERR_QOS_INVALID_QUE_SCH_ALGORITHM,     "Invalid queue scheduler Algorithm, should be DWRR or SP",
                                            "ЧĶеȷʽӦΪDWRRSP"},
    {ERR_QOS_INVALID_QUE_IF,                "Invalid index of interface instance", "ЧĽӿʵ"},
    {ERR_QOS_QUE_IF_NOT_EXIST,              "The interface instance does not exist", "ӿʵ"},
    {ERR_QOS_INVALID_QUE_LEN,               "Queue length should be 20-150packets or 30000-225000bytes",
                                            "гӦΪ20-150packets30000-225000bytes"},
    {ERR_QOS_INVALID_QUE_LEN_TYPE,          "Invalid queue length type, should be 0(packets) or 1(bytes)",
                                            "ЧĶгͣӦΪ0(packets)1(bytes)"},
    {ERR_QOS_INVALID_QUE_WEIGHT,            "Invalid queue weight value,should be 1-99", "ЧĶȨֵ,ӦΪ1-99"},
    {ERR_QOS_INVALID_DROP_ALGORITHM,        "Invalid drop algorithm, should be DT(drop tail)", "ЧĶ㷨,ӦΪDT(β)"},
    {ERR_QOS_INVALID_CLASS_TYPE,            "Invalid classify type, should be 0(L2) or 1(L3)", "Чķ,ӦΪ0(L2)1(L3)"},
    {ERR_QOS_INVALID_CLASS_IF,              "Invalid ingress interface", "Чӿ"},
    {ERR_QOS_INVALID_ETH_TYPE,              "Invalid ethertype field valid", "Чֵֶ̫"},
    {ERR_QOS_INVALID_ETH_PRIO,              "Invalid ethernet priority value, shoud be 0-7", "Ч̫ȼ,ӦΪ0-7"},
    {ERR_QOS_INVALID_VLAN_ID,               "Invalid vlan id, shoud be 1-4094", "ЧVLAN ID,ӦΪ1-4094"},
    {ERR_QOS_INVALID_IP_LEN,                "Invalid ip length value,should be 20-1500", "ЧIPݳ,ӦΪ20-1500"},
    {ERR_QOS_INVALID_DSCP,                  "Invalid DSCP value, should be PHB format", "ЧDSCPֵ,ӦΪPHBʽ"},
    {ERR_QOS_INVALID_PROTOCOL,              "Invalid protocol value, should be 0(tcp&udp),1(icmp),6(tcp),17(udp)",
                                            "ЧЭֵӦΪ0(tcp&udp), 1(icmp), 6(tcp), 17(udp)"},
	{ERR_QOS_INVALID_PORT,					"Invalid protocol port (1-65535)","Ч˿(1-65535)"},
    {ERR_QOS_INVALID_CLASS_QUE,             "Invalid index of queue instance", "ЧĶʵ"},
    {ERR_QOS_CLASS_QUE_NOT_EXIST,           "The queue instance does not exist", "ʵ"},
    {ERR_QOS_SHAPE_RATE_CONFLICT,           "Committed rate should be less than or equal to peak rate", "ŵӦСڵڷֵ"},
    {ERR_QOS_QUEUE_LEN_CONFLICT,            "Queue length should be 20-150packets or 30000-225000bytes",
                                            "гӦΪ20-150packets30000-225000bytes"},
    {ERR_QOS_QUEUE_WEIGHT_CONFLICT,         "The weight sum of all enabled queue binding the same DWRR interface should be less than or equal to 100%",
                                            "󶨵ͬһDWRRӿڵöеȨغӦСڻ100%"},
    {ERR_QOS_QUEUE_PRIO_CONFLICT,           "Two enabled queues binding the same SP interface should not have the same priority",
                                            "󶨵ͬһSPӿڵöеȼͬ"},
    {ERR_QOS_IP_LENGTH_CONFLICT,            "The minimum ip length should be less than or equal to the maximum ip length",
                                            "IPСֵӦСڻIPֵ"},
    {ERR_QOS_PORT_MAX_MIN,           		"Ending Port value should be greater or equal to Starting Port value.",
                                            "˿ֵӦôڵʼ˿ֵ"},
    {ERR_QOS_FOLICYNAME_CONFLICT,			"have same name","ͬ"},
	{ERR_QOS_FOLICYNAME_INVALID,			"Invalid policy name","Ƿ߳ȴ64"},
	{ERR_QOS_PORT_CONFLICT,					"Port conflicts with another rule","˿ѱʹ"},
	{ERR_QOS_MAC_CONFLICT,					"Duplicate MAC address","MACַظ"},	
	{ERR_QOS_DESCNAME_INVALID,				"Invalid Device name","Ƿ豸߳ȴ248"},

	/* node for mindspeed qos */
	{ERR_QOS_INVALID_BANDWIDTH, 		    "invalid bandwidth", "ЧĴ"},
	{ERR_QOS_INVALID_TYPE, 				    "invalid precedence setting type", "Чȼ"},
	{ERR_QOS_INVALID_SIGNALING, 		    "invalid signaling value", "Чźֵ"},
	{ERR_QOS_INVALID_VOICEDATA, 		    "invalid voice data", "Чֵ"},
	{ERR_QOS_INVALID_PRIORITY, 			    "invalid priority", "Чȼ"},
	{ERR_QOS_INVALID_RATELIMIT, 		    "invalid rate limit", "Чıֵ"},

    /* DYNAMIC ROUTE */
    {ERR_DROUTE_INVALID_VAL,                "value invalid",  "ֵЧ"},
    {ERR_DROUTE_INVALID_CONFIG_FILE,        "invalid configurate file",  "ļЧ"},
    {ERR_DROUTE_VERSION_INVALID,            "RIP version invalid",  "Чrip汾"},
    {ERR_DROUTE_INVALID_PC_MSG,             "PC inner message invalid",  "ЧPCڲϢ"},
    {ERR_DROUTE_INVALID_WAN,                "WAN device invalid",  "WAN豸Ч"},
    {ERR_DROUTE_INVALID_INNER_PARA,         "invalid inner parament ",  "Чڲ"},

    {ERR_SROUTE_INVALID_INSTANCE,           "invalid instance",  "Чʵ"},
    {ERR_SROUTE_INTERFACE,                  "invalid interface ",  "Ч豸"},
    {ERR_SROUTE_NO_RESOURSE,                "has no resourse",  "ûԴ"},
    {ERR_SROUTE_INVALID_VAL,                "value invalid",  "ֵЧ"},
    {ERR_SROUTE_ENABLE_INVALID,             "enable invalid",  "ʹܲЧ"},
    {ERR_SROUTE_INVALID_PATH,               "invalid path",  "Ч·"},
    {ERR_SROUTE_INVALID_DEFAULT_PARA,       "invalid default route parament",  "ЧĬ·ɲ"},
    {ERR_SROUTE_INVALID_ROUTE_PARA,         "invalid route para",  "Ч·ɲ"},
    {ERR_SROUTE_INVALID_PARA,               "invalid parament",  "Ч"},
    {ERR_SROUTE_DEL_INSTANCE,               "del instance error",  "ɾʵ"},
    {ERR_SROUTE_INVALID_METRIC,             "invalid metric",  "Чmetric"},
    {ERR_SROUTE_INVALID_IP,                 "invalid IP",  "ЧIP"},
    {ERR_SROUTE_IP_EMPTY,                   "IP value can not be empty",  "IP ַΪ"},
    {ERR_SROUTE_INVALID_MASK,               "Invalid netmask value",  "Ч"},
    {ERR_SROUTE_MASK_EMPTY,                 "Netmask can not be empty",  "벻Ϊ"},
    {ERR_SROUTE_INVALID_GATEWAY,            "The gateway should be on the same subnet as the WAN interface or the LAN interface",  "Ӧӿڻӿͬһ"},
    {ERR_SROUTE_METRIC_OUT_LIMITED,         "metric is out of llimited",  "metricΧ"},
    {ERR_SROUTE_INVALID_LOGFILE,            "invalid log file",  "Чlogļ"},
	{ERR_SROUTE_DEST_CONFLICT,              "Duplicate route condition", "·ظ"},
	{ERR_SROUTE_ROUTE_NAME,                 "Duplicate route name", "·ظ"},

    /* SNMPC */
    {ERR_SNMPC_INVALID_VERSION,             "invalid SNMP version", "ЧSNMP汾"},

    /* MAIL */
    {ERR_INVALID_EMAIL,						"Email value is invalid","EMAILַϷ"},
	{ERR_INVALID_HOST,						"Smtp Server is invalid","ַϷ"},
    {ERR_INVALID_USERNAME,					"Account is invalid","Чû"},
    {ERR_INVALID_PASSWORD,					"Password is invalid","Ч"},
    /* Firewall */
    {ERR_FW_RULES_OVER,                     "The number of rules can not be over 20",
                                            "ӵĹܳ20"},
    {ERR_FW_RULE_EXISTS,                    "this rule has exists in filter table",
                                            "ظĹ"},
    {ERR_FW_SRC_IP_EMPTY,                   "Source IP Address can not be empty !",
                                            "ԴIPַزΪ"},
    {ERR_FW_DEST_IP_EMPTY,                  "Destination IP Address can not be empty !",
                                            "ĿIPַزΪ"},
    {ERR_FW_RULES_OVERLAP,                  "Overlap between rules!",
                                            "֮ص"},
    {ERR_FW_SERVICE_NAME,                   "Duplicate service name",
                                            "ظ"},

    /* SNTP */
    {ERR_SNTP_INVALID_UP_INTERVAL,          "Invalid update interval value, shoud be 1-24(hours)",
                                            "Чĸʱֵ,ӦΪ1-24(Сʱ)"},
    {ERR_SNTP_INVALID_RETRY_INTERVAL,       "Invalid retry interval value, should be 1-60(minutes)",
                                            "Чʱ,ӦΪ1-60()"},
    {ERR_SNTP_INVALID_NTP_SERVER,           "The Ip address or domain name of NTP server is invalid",
                                            "NTPIPַЧ"},
    {ERR_SNTP_INVALID_DATA_TIME,            "Invalid time format",   "ʱʽϷ"},
    {ERR_SNTP_NULL_NTPSERVER_STR,           "Two NTP servers should not be null at the same time",
                                            "NTPͬʱΪ"},
    {ERR_SNTP_NTPSERVERS_CONFLICT,          "Two NTP servers should not be same value",
                                            "NTPͬ"},
    {ERR_SNTP_DST_CONFLICT,                 "The conflict between the start and the end of daylight saving time exist",
                                            "ʱʼͽʱ֮ڳͻ"},
    {ERR_SNTP_DST_OFFSET,                   "Invalid day saving time value",
                                            "ЧĶ/ʱƫ"},

    /*tr069be*/
    {ERR_TR069BE_INVALID_URL,               "invalid URL", "ǷURL"},
    {ERR_USERNAME,                          "invalid username", "Ƿû"},
    {ERR_PASSWORD,                          "invalid password", "Ƿ"},
    {ERROR_TR069_INVALID_CAFILE,            "Invalid CAfile", "Ƿ֤"},

    {ERR_URLFILTER_INVALID_INNER_PARA,      "inner parament error",   "ڲݴ"},
    {ERR_URLFILTER_INVALID_VAL,             "invalid value",   "ֵЧ"},
    {ERR_URLFILTER_ENABLE_EMPTY,            "value enable empty",   "ֵenableΪ"},
    {ERR_URLFILTER_ENABLE_INVALID,          "value enable wrong",   "ֵenable"},
    {ERR_URLFILTER_INVALID_CONFIG_FILE,     "invalid config file",   "Чļ"},
    {ERR_URLFILTER_MODE_EMPTY,              "value mode empty",   "ֵģʽΪ"},
    {ERR_URLFILTER_MODE_INVALID,            "value mode wrong",   "ֵģʽ"},
    {ERR_URLFILTER_URL_CONFLICT,            "URL conflict",   "URL ͻ"},
    {ERR_URLFILTER_URLNUMBER_OVER,          "URL Number is over", "urlĿΧ"},
    {ERR_URLFILTER_URL_LENGTH_OVER,         "URL length is over", "URL"},
  //  {ERR_URLFILTER_URL_ERROR,               "URL must be .,/,0-9,a-z,A-Z.",  "URLϷַ.,/,0-9,a-z,A-Z"},
    {ERR_URLFILTER_URL_ERROR,               "The format of key word or domain name is invalid!",  "ؼֻʽϷ!"},

    {ERR_URLFILTER_INVALID_FILTERMODE,      "Invalid filter mode",  "ЧURLģʽ"},
    {ERR_URLFILTER_INVALID_TIME,            "Invalid time",  "Чʱ"},
    {ERR_URLFILTER_INVALID_DAY,             "Invalid day",  "Ч"},
    {ERR_URLFILTER_TIME_CONFLICT,           "Start time is larger then end time",  "ʼʱڽʱ"},
    {ERR_URLFILTER_MAC_CONFLICT,            "Duplicate MAC address.",  "MACַظ"},
    {ERR_URLFILTER_TOO_MUCH_KEY,            "The rules in the block list has reached the maximum number of 255",  "беĹѴﵽֵ255"},

    /* IPT */
    {ERR_IPT_CONFLICT_DMZ,                  "DMZ host ip should not be null", "DMZַΪ"},

	/* WLAN */
    {ERR_WLAN_NO_RESOURSE,            		"no resourse", "Դȱ"},
    {ERR_WLAN_INVALID_VAL,            		"invalid value",   "ֵЧ"},
    {ERR_WLAN_INVALID_PATH,            		"invalid path",  "Ч·"},
    {ERR_WLAN_VAL_EMPTY,            		"value empty",   "ֵΪ"},
    {ERR_WLAN_EXCEED_VAP_NUM,             	"The number of Vap can not exceed 5","ӵVAPܳ5"},
    {ERR_WLAN_INVALID_INSTANCE,            	"invalid instance", "Чʵ"},
    {ERR_WLAN_INVALID_VAPIDX,            	"invalid Vap index", "ЧVap"},
    {ERR_WLAN_NAME_REPEATED,           		"name repeated", "ظ"},
    {ERR_WLAN_INVALID_SSID,  				"Invalid SSID,SSID should be 1-32 characters", "ЧSSID,SSIDӦ1-32ַ"},
	{ERR_WLAN_IN_OOB,   					"It is already in OOB status", "ѾOOB״̬"},
	{ERR_WLAN_INVALID_SESSION,              "wps session already in prcoess", "WPSЭ"},
	{ERR_WLAN_SSID_CONFLICT,				"The SSID is duplicate,please change to another one.", "SSIDѾڣָһͬSSID"},
	{ERR_WLAN_DEVICENAME_CONFLICT,			"Duplicate device name.", "ظ"},

    /* PORTMAPPING */
    {ERR_PTMP_INVALID_DESCRIPTION,          "Invalid characters inclued in description",
                                            "ϢкзǷַ"},
    {ERR_PTMP_CONFLICT_PORTRANGE,           "The minimum port value should be less than or equal to the maximum port value",
                                            "˿СֵӦСڻڶ˿ֵ"},
    {ERR_PTMP_CONFLICT_TUPLE,               "The specified port(s) are being used by other configurations. Please check your configurations of Remote Management, Port forwarding, Port Triggering, UPnP Port Mapping table, RIP, and Internet connection type",
                                            "ָ˿ѱʹáԶ̹˿ӳ䡢˿ڴUPnP˿ӳRIP͵"},
    {ERR_PTMP_NOTINSAMESUBNET,              "This IP address should be in the same subnet as the LAN IP address",
                                            "IPַӦIPַͬһ"},
    {ERR_PTMP_DUPLICATE_NAME,               "Duplicate service name",
                                            "ظ"},

    /* ACL */
    {ERR_ACL_RULES_OVER,                    "The number of rules can not be over 10",
                                            "ӵķܳ10"},
    {ERR_ACL_RULE_EXISTS,                   "This open port has been occupied",
                                            "˿Ŷ˿Ѿռ"},
    {ERR_ACL_PORT_BE_ZERO,                  "When protocol is ICMP, the port value must be zero",
                                            "ЭΪICMPʱ,˿ֵΪ0"},
    {ERR_ACL_PORT_CANOT_ZERO,               "When protocol is not ICMP, The port value can not be zero",
                                            "Э鲻ΪICMPʱ,˿ֵΪ0"},
    {ERR_ACL_PORT_IN_USE,                   "This port has been used",
                                            "˶˿Ѿʹ"},

    /* LOGGER */
    {ERR_LOGGER_UPLOAD_FAILED,              "Log file upload failed",  "־ļϴʧ"},
    {ERR_LOGGER_INVALID_TFTP_SERVER,        "Invalid TFTP server",  "ǷTFTP"},
    {ERR_LOGGER_CLEAR_FAILED,               "Log file clear failed",  "־ļʧ"},
    {ERR_LOGGER_EMPTY_TFTP_SERVER,          "Server address cannot be empty","ַΪ"},
    {ERR_LOGGER_INVALID_SERVER,             "Invalid server","Ƿķ"},

    /* ATM */
    {ERR_ATM_PVC,                           "VPI/VCI is invalid", "PVCòϷVPI/VCIĸʽд"},
    {ERR_ATM_VPI,                           "Invalid VPI value (0~255)", "VPIֵǷ(0~255)"},
    {ERR_ATM_VCI,                           "Invalid VCI value (32~65535)", "VCIֵǷ(32~65535)"},
    {ERR_ATM_UNKNOWN_ENCAP,                 "Unkown encapsulation", "δ֪װ"},
    {ERR_ATM_UNKNOWN_QOS_TYPE,              "Unkown Qos type", "δ֪Qos"},
    {ERR_ATM_PCR,                           "Invalid PCR value (0~7100)", "ֵԪ/Ԫӳٱ仯ʷǷ(0~7100)"},
    {ERR_ATM_MBS,                           "Invalid MBR value (0~1000000)", "ͻߴǷ(0~1000000)"},
    {ERR_ATM_SCR,                           "Invalid SCR value (0~7099)", "ƽԪʷǷ"},
    {ERR_ATM_MIN_PCR,                       "Wrong MCR value (0~pcr)", "СԪʷǷ"},
    {ERR_ATM_VLAN_ID,                       "Wrong vlan id (0~4095)", "VLAN IDǷ(0~4095)"},
    {ERR_ATM_VLAN_PRIORITY,                 "Wrong vlan priority(0~7)", "VLANȼǷ(0~7)"},
    {ERR_ATM_VLAN_ID_CONFLICT,              "Same vlan id", "VLAN IDظ"},

    /* UPNP */
    {ERR_UPNP_SRCIP_EXIST,                  "This IP address is already in the list","IPַб"},

    /* DDNS */
    {ERR_DDNS_INVALID_DDNSPROVIDER,         "Invalid DDNS provider","ЧĶ̬DNS"},
    {ERR_DDNS_INVALID_HOSTNAME,             "Invalid hostname","Ч"},
    {ERR_DDNS_HOSTNAME_LENGTH_OVER,         "Hostname length is over",""},
    {ERR_DDNS_INVALID_WAN_CONN_SID,         "Invalid WAN connection ID","ЧWAN"},
    {ERR_DDNS_INVALID_USERNAME,             "Invalid username","Чû"},
    {ERR_DDNS_USERNAME_LENGTH_OVER,         "Username length is over","û"},
    {ERR_DDNS_INVALID_PASSWORD,             "Invalid password","Ч"},
    {ERR_DDNS_PASSWORD_LENGTH_OVER,         "Password length is over","볬"},
    {ERR_DDNS_INVALID_EMAIL,                "Invalid email address","Чַ"},
    {ERR_DDNS_EMAIL_LENGTH_OVER,            "Email address length is over","ַ"},
    {ERR_DDNS_INVALID_KEY,                  "Invalid key","ЧԿ"},
    {ERR_DDNS_KEY_LENGTH_OVER,              "Key length is over","Կ"},
    {ERR_DDNS_HOSTNAME_CONFLICT,            "Hostname exist already","Ѿ"},
    {ERR_DDNS_INVALID_DDNS_HOST,            "Invalid DDNS host","ЧDDNS "},
    {ERR_DDNS_DDNS_HOST_LENGTH_OVER,        "DDNS host length is over","DDNSʶ"},
    {ERR_DDNS_HOSTNAME_ILLEGAL,             "DDNS host name must be 0-9,a-z,A-Z,_,-,.,@","DDNSϷַΪ0-9,a-z,A-Z,_,-,.,@"},

    /* SUPP */
    {ERR_SUPP_USERNAME_OR_PASSWORD_BE_EMPTY,    "username or password empty", "ûΪ"},

    /* MACFILTER */
    {ERR_MACFILTER_INVALID_USERNAME,        "Invalid username","Чû"},
    {ERR_MACFILTER_INVALID_FILTERMODE,      "Invalid filter mode","ЧĹģʽ"},
    {ERR_MACFILTER_INVALID_TIME,            "Invalid time","Чʱ"},
    {ERR_MACFILTER_INVALID_DAY,             "Invalid day","Ч"},
    {ERR_MACFILTER_TIME_CONFLICT,           "Start time is larger then end time","ʼʱڽʱ"},
    {ERR_MACFILTER_MAC_CONFLICT,            "Duplicate MAC address.","MACַظ"},
    {ERR_MACFILTER_INVALID_INNER_PARA,      "Invalid inner parameter","Чڲ"},

    /* TRACEROUT */
    {ERR_TRACERT_NOSTART,                   "Traceroute is not started","δ"},
    {ERR_TRACERT_BUSY,                      "Traceroute is running",""},


    /* SCHEDULE */
    {ERR_SCHEDULE_INVALID_NAME,             "Name is invalid.", "ֲϷ"},
    {ERR_SCHEDULE_INVALID_ENABLEALLDAYS,    "Day select is invalid.","ѡ񲻺Ϸ"},
    {ERR_SCHEDULE_INVALID_STARTTIME,        "Start time is invalid.","ʼʱ䲻Ϸ"},
    {ERR_SCHEDULE_INVALID_ENDTIME,          "End time is invalid.","ʱ䲻Ϸ"},
    {ERR_SCHEDULE_INVALID_SPICIFIEDDAY,     "No days are specified.","δָ"},
    {ERR_SCHEDULE_INVALID_SCHEDULEDAYS,     "Day select is invalid.","ѡ񲻺Ϸ"},
    {ERR_SCHEDULE_INVALID_ENABLEALLTIME,    "Start time is invalid.","ʼʱ䲻Ϸ"},
    {ERR_SCHEDULE_TIME_CONFLICT,            "Start time is invalid.","ʼʱ䲻Ϸ"},
    {ERR_SCHEDULE_NAME_CONFLICT,            "Duplicate schedule name.","ظ"},
    {ERR_SCHEDULE_RULE_USED,                "The rule are being used and can not be deleted.","ɾڱõĹ"},
    {ERR_SCHEDULE_INVALID_TIME_RANGE,       "Invalid time range.","Чʱ䷶Χ"},

    /* Diagnostics */
    {ERR_DG_INVALID_STATE,                  "Diagnostics state is invalid.",    "״ֵ̬Ϸ"},
    {ERR_DG_INVALID_INTERFACE,              "Interface is invalid.",            "ӿڲϷ"},
    {ERR_DG_PVC_TOO_MUCH,                   "Too much PVC pairs in search list.", "бPVC̫"},


    //default gateway
    {ERR_DEGW_EMPTY_IP,                     "IP address is empty","IPַΪ"},
    {ERR_DEGW_INVALID_IP,                   "IP address is invalid","IPַЧ"},
    {ERR_DEGW_EMPTY_USERINIF,               "User interface is empty","ûӿΪ"},
    {ERR_DEGW_INVALID_USERINIF,             "User interface is invalid","ûӿЧ"},
    {ERR_DEGW_EMPTY_SELECT,                 "Mode is empty","ģʽΪ"},
    {ERR_DEGW_INVALID_SELECT,               "Mode must be one of AutoDeftGW,GWIP andUserInIf","ģʽΪAutoDeftGW,GWIPUserInIf"},

    //IP ACL
    {ERR_IP_ACL_EMPTY_IP,                   "IP address is empty","IPַΪ"},
    {ERR_IP_ACL_INVALID_IP,                 "IP address is invalid","IPַЧ"},
    {ERR_IP_ACL_IP_ZERO,                    "You can use this function unless there is a IP at least","һ¼ʹ"},

	//upgrader
	{ERR_UPG_GENERAL_ERROR, 				"Unable to complete upgrading",					  	"޷"},
	{ERR_INIT_MODULE_ERROR, 				"Init webupg module error",							"ʼwebupgģ"},
	{ERR_DESTROY_MODULE_ERROR, 				"Destroy webupg module error",						"עwebupgģ"},
	{ERR_REQUEST_METHOD_ERROR, 				"Unsupported Request Method",						"ֵ֧󷽷"},
	{ERR_CONTENT_TYPE_ERROR, 				"Unsupported Content Type",							"ֵ֧ļ"},
	{ERR_CONTENT_LENGTH_ERROR, 				"No Content-Length was sent with the POST request",	"POSTΪ"},
	{ERR_INVALID_VARIABLE_ERROR, 			"Invalid variable name", 							"Чı"},
	{ERR_NO_VARIABLE_ERROR, 				"Not found variable",								"Ҳ"},
	{ERR_MIN_CONTENT_LENGTH_ERROR, 			"File Length less than minimum expected size",		"ļССԤڴС"},
	{ERR_MAX_CONTENT_LENGTH_ERROR, 			"File Length greater than maximum expected size",	"ļȴԤڴС"},
	{ERR_FOPEN_LOG_ERROR, 					"Unable to open log file",							"޷־ļ"},
	{ERR_FOPEN_FW_ERROR, 					"Unable to create temporary storage file",			"޷ʱ洢ļ"},
	{ERR_OPERATE_FW_ERROR, 					"Unable to operation  the firmware file",			"޷Ĺ̼ļ"},
	{ERR_FILE_TYPE_ERROR, 					"File type not suitable for update", 				"ļͲʺϽи"},
	{ERR_FILE_SIZE_ERROR, 					"File size biger than free flash size",				"ļСڿõFLASHռ"},
	{ERR_FILE_PRODUCT_ERROR, 				"File is not suitable for this target board",		"ļʺ˰"},
	{ERR_FILE_CRC_ERROR, 					"File content corrupt when transmission",			"ļݴʱ"},
	{ERR_FILE_UPLOAD_ERROR, 				"Upload file error", 								"ϴļ"},
	{ERR_AUTH_ERROR, 						"Authentication failed", 							"֤ʧ"},
	{ERR_UPG_TIMEOUT, 						"Upgrade timeout", 									"ʱ"},	

#ifdef CONFIG_TBS_SUPPORT_IPV6
	/* V6 Static routing */
    {ERR_V6SROUTE_ENABLE_INVALID, 			"enable invalid",  "ʹܲЧ"},
    {ERR_V6SROUTE_BAD_PREFIX, 				"Invalid Prefix! Valid range is 3-128",  "PrefixȷȷȡֵΧ3-128"},
    {ERR_V6SROUTE_BAD_METRIC, 				"Invalid Metric!",  "Чmetric"},

	/*DHCP6S*/
    {ERR_DHCP6S_LIFE_TIME_OUT_RANGE, 		"the life time is out of range","Чʱ䳬Χ"},
    {ERR_DHCP6S_START_ADDR_BIGGER, 			"the start address is bigger than the end one","ʼַڽַ"},
    {ERR_DHCP6S_INVALID_LIFE_TIME, 			"the life time is out of range","ڳΧ"},
    {ERR_DHCP6S_VALID_LIFE_TIME_SMALLER, 	"the valid life time should bigger than the prefered life time","ЧӦøЩ"},

	/*RADVD*/
    {ERR_HEX_FORMAT_WRONG,          		"invalid hex number","Чʮ"},
    {ERR_GLOBALID_OUT_OF_RANGE, 			"invalid global id,must be 40bit hex number","global idʮ"},
    {ERR_CONFIG_TYPE_INVALID_VALUE, 		"invalid config type,must be Static or Delegated","ͱ StaticDelegated"},
    {ERR_ROUTE_LIFETIME_OUT_OF_RANGE, 		"lifetime range is 20~65535","Ϊ20~65535"},
    {ERR_ROUTE_PREFERENCE_INVALID_VALUE, 	"route preference must be low,medium or high","ȼΪlow,medium or high"},
	{ERR_SUBNET_ID_OUT_OF_RANGE, 			"SubnetID range is 0~255","ΧΪ0~255"},
    {ERR_INVALID_PREFIX_LEN, 				"Invalid prefix length, it should be 0~128","Чĵַǰ׺ȣΧΪ0~128"},
    {ERR_INVALID_PREFIX, 					"Invalid prefix","Чĵַǰ׺"},
    {ERR_NOT_NEED_CHANGE, 					"No need change","ı"},
	{ERR_FLAG_CONF_TYPE_INVALID, 			"Invalid flag config type","Чflag"},
    {ERR_INVALID_MO_FLAG, 					"Invalid MO flag","ЧMO־"},
    {ERR_INVALID_RA_MAX_INTERVAL, 			"RA max interval can not exceed router life time","RAʱܳ·"},
    {ERR_INVALID_RA_MIN_INTERVAL, 			"RA min interval can not exceed RA max interval","СRAʱܳRAʱ"},
    {ERR_INVALID_RA_MIN_INTERVAL_VALUE, 	"min ra interval must be at least 3","СRAʱ䲻С3"},
    {ERR_INVALID_RA_MIN_INTERVAL_MAX, 		"min ra interval must no more than 3/4 of max ra interval","СRAʱ䲻ܴRAʱķ֮"},
    {ERR_RADVD_INVALID_O_FLAGS, 			"while the M flag is TRUE, then O flag must be TRUE, too","MΪ1ʱOǱΪ1"},

	/*V6CONND*/
    {ERR_V6CONN_INVALID_STATIC_ADDR,  		"the ipv6 static addr is wrong","̬IPV6ַ"},
    {ERR_V6CONN_INVALID_DNS_ADDR,         	"Invalid DNS Address", "DNSַʹ"},
    {ERR_V6CONN_INVALID_ROUTER_ADDR, 		"the ipv6 router addr is wrong","ipv6·ɵַ"},
    {ERR_V6CONN_INVALID_ADDR_CONF_TYPE,   	"Invalid IP Address Config Type", "IPַЧ"},
    {ERR_V6CONN_INVALID_ROUTER_CONF_TYPE, 	"Invalid Route Config Type", "·Ч"},
    {ERR_V6CONN_INVALID_DUID_CONF_TYPE, 	"the duid type is wrong","DUIDЧ"},
#endif
	// WEB -> Browser
    {ERR_WEB_VAR_VALUE_ERROR, "Web security vulnerabilities, illegal cross-site script",  "WEB XSS"},
    {0, NULL, NULL}
};



/*============================================================================
                      Debug Utils
=============================================================================*/
#define MSG_TYPE_NAME(name) \
        case name: \
        {\
            strcpy(acMsgTypeName, #name);\
            break;\
        }


/*
*	: 	tbsGetMsgTypeName
*	: 	ԸֵʽMsgTypeתΪַɶʽ
*	: 	usMsgType - MsgTypeֵ
*	ֵ  :	ӦMsgTypeַ֡ںʶΧУ
*				UNKNOWN_MSGTYPE(ddd)ʽ
*	    : 	 / 2008-11-10
*/
const char* tbsGetMsgTypeName(unsigned short usMsgType)
{
    static char acMsgTypeName[64] = {0};
    unsigned short usCvtMsgType = usMsgType;

    if (usMsgType > 0x8000)
        usCvtMsgType = usMsgType & 0x7FFF;

	switch (usCvtMsgType)
    {
        MSG_TYPE_NAME(MSG_POLL_EXIT);

        MSG_TYPE_NAME(MSG_PC_START_PROC);
        MSG_TYPE_NAME(MSG_PC_SEND_SIGNAL);
        MSG_TYPE_NAME(MSG_PC_PROC_STATE);
        MSG_TYPE_NAME(MSG_PC_PROC_OUTPUT);
        MSG_TYPE_NAME(MSG_PC_EXIT);

        MSG_TYPE_NAME(MSG_CMM_GET_VAL);
        MSG_TYPE_NAME(MSG_CMM_SET_VAL);
        MSG_TYPE_NAME(MSG_CMM_ADD_NODE);
        MSG_TYPE_NAME(MSG_CMM_DEL_NODE);
        MSG_TYPE_NAME(MSG_CMM_GET_NAME);
        MSG_TYPE_NAME(MSG_CMM_GET_ATTR);
        MSG_TYPE_NAME(MSG_CMM_SET_ATTR);

        MSG_TYPE_NAME(MSG_CMM_INFORM_NOTI);
        MSG_TYPE_NAME(MSG_CMM_GET_NOTI);
        MSG_TYPE_NAME(MSG_CMM_CLEAR_NOTI);

        MSG_TYPE_NAME(MSG_CMM_COMMIT);
        MSG_TYPE_NAME(MSG_CMM_CANCEL);
        MSG_TYPE_NAME(MSG_CMM_UPDATE);

        MSG_TYPE_NAME(MSG_CMM_SAVE_CFG);
        MSG_TYPE_NAME(MSG_CMM_RECOVER_CFG);
        MSG_TYPE_NAME(MSG_CMM_UPGRADE);
        MSG_TYPE_NAME(MSG_CMM_BACKUP);
        MSG_TYPE_NAME(MSG_CMM_REBOOT);


        MSG_TYPE_NAME(MSG_TIMER_REGSTER);
        MSG_TYPE_NAME(MSG_TIMER_UNREGSTER);
        MSG_TYPE_NAME(MSG_TIMER_TIMEOUT);

        MSG_TYPE_NAME(MSG_WAN_INTERFACE_STATE);
        MSG_TYPE_NAME(MSG_WAN_ADD_CONN);
        MSG_TYPE_NAME(MSG_WAN_DEL_CONN);
        MSG_TYPE_NAME(MSG_WAN_CONN_EST);
        MSG_TYPE_NAME(MSG_WAN_CONN_FIN);
        MSG_TYPE_NAME(MSG_WAN_BRIDGE_EST);
        MSG_TYPE_NAME(MSG_WAN_BRIDGE_FIN);
        MSG_TYPE_NAME(MSG_WAN_LINK_CHG);

	    MSG_TYPE_NAME(MSG_LOGIN_UPDATE);
        MSG_TYPE_NAME(MSG_LAN_IP_UPDATE);
        MSG_TYPE_NAME(MSG_LAN_MACLIST_UPDATE);
        MSG_TYPE_NAME(MSG_LAN_DOMAIN_NAME_UPDATE);

        MSG_TYPE_NAME(MSG_GET_DHOST_LIST);
        MSG_TYPE_NAME(MSG_DNS_CHANGE);

        MSG_TYPE_NAME(MSG_WLAN_ADD_DEVICE);
        MSG_TYPE_NAME(MSG_WLAN_DEL_DEVICE);


        MSG_TYPE_NAME(MSG_TR069_SET_PARKEY);
        MSG_TYPE_NAME(MSG_TR069_GET_EVENTS);
        MSG_TYPE_NAME(MSG_TR069_CLEAR_EVENTS);
        MSG_TYPE_NAME(MSG_TR069_DOWNLOAD);
        MSG_TYPE_NAME(MSG_TR069_UPLOADLOAD);
        MSG_TYPE_NAME(MSG_TR069_REBOOT);
        MSG_TYPE_NAME(MSG_TR069_FACTORYRESET);
        MSG_TYPE_NAME(MSG_TR069_SCHEDULEINFORM);
        MSG_TYPE_NAME(MSG_TR069_GET_TRANSFERCOMPLETEINFO);

        /* LBTģϢ */
        MSG_TYPE_NAME(MSG_LBT_SET_STATE);
        MSG_TYPE_NAME(MSG_LBT_GET);

        MSG_TYPE_NAME(MSG_TR069_HTTPD_CONNECT);
        MSG_TYPE_NAME(MSG_TR069_HTTPD_CREATE_UPFILE);

        MSG_TYPE_NAME(MSG_ETHNET_LINK_STATE);
        MSG_TYPE_NAME(MSG_ETHWAN_INTF_NAME);

        MSG_TYPE_NAME(MSG_MON_INTF_REGISTER);
        MSG_TYPE_NAME(MSG_MON_INTF_UNREGISTER);
        MSG_TYPE_NAME(MSG_MON_INTF_STATUS_QUERY);
        MSG_TYPE_NAME(MSG_MON_INTF_STATUS_INFORM);

        MSG_TYPE_NAME(MSG_AUTH);
        MSG_TYPE_NAME(MSG_WAN_ADD_INST);
        MSG_TYPE_NAME(MSG_WAN_DEL_INST);
        MSG_TYPE_NAME(MSG_LAN_ADD_INST);
        MSG_TYPE_NAME(MSG_LAN_DEL_INST);
        MSG_TYPE_NAME(MSG_WLAN_ADD_INST);
        MSG_TYPE_NAME(MSG_WLAN_DEL_INST);


        MSG_TYPE_NAME(MSG_CMD);

        MSG_TYPE_NAME(MSG_RESP);
        MSG_TYPE_NAME(MSG_RESP_FRAGMENT);
        MSG_TYPE_NAME(MSG_RESP_ERR);

        MSG_TYPE_NAME(MSG_CMM_CLEAR_CFG);

        MSG_TYPE_NAME(MSG_BUTTON);

        MSG_TYPE_NAME(MSG_SNTP_UPDATE_TIME);
        MSG_TYPE_NAME(MSG_SNTP_TIME_CHANGED);
        MSG_TYPE_NAME(MSG_NTPS_CHANGED);

        MSG_TYPE_NAME(MSG_TR111_DEVICE_ADD);
        MSG_TYPE_NAME(MSG_TR111_DEVICE_DEL);

        MSG_TYPE_NAME(MSG_PING_COMPLETE);

        MSG_TYPE_NAME(MSG_MSG4UDP_REGISTER);
        MSG_TYPE_NAME(MSG_MSG4UDP_UNREGISTER);
        MSG_TYPE_NAME(MSG_MSG4UDP_MESSAGE);

        MSG_TYPE_NAME(MSG_WAN_CONN_ENABLE_UPDATE);

        MSG_TYPE_NAME(MSG_VLAN_ADD_BRIDGE);
        MSG_TYPE_NAME(MSG_VLAN_DEL_BRIDGE);
        MSG_TYPE_NAME(MSG_VLAN_BIND_PORT);
        MSG_TYPE_NAME(MSG_VLAN_UNBIND_PORT);

        MSG_TYPE_NAME(MSG_VDSL_BRIEF_STATUS_OF_PORT);
        MSG_TYPE_NAME(MSG_VDSL_EXTENDED_STATUS_OF_PORT);
        MSG_TYPE_NAME(MSG_VDSL_STATUS);
        MSG_TYPE_NAME(MSG_VDSL_SNR_STATUS);
        MSG_TYPE_NAME(MSG_VDSL_BME_FIRMWARE_VERSION);

        MSG_TYPE_NAME(MSG_LAN_ETH_DEL_INST);
        MSG_TYPE_NAME(MSG_LAN_ETH_ADD_INST);

        MSG_TYPE_NAME(MSG_PORTOFF_TRIGGER);

        MSG_TYPE_NAME(MSG_CMM_INST_ADDED);
        MSG_TYPE_NAME(MSG_CMM_INST_DELED);

        MSG_TYPE_NAME(MSG_CMM_GET_VAL_IGNORE_ERR);
        MSG_TYPE_NAME(MSG_TR069_REPORT_MON_EVENT);
        MSG_TYPE_NAME(MSG_TR069_GET_MON_EVENT);

        MSG_TYPE_NAME(MSG_DHCPS_DEVICE_CONNECTED);
        MSG_TYPE_NAME(MSG_DHCPS_DEVICE_DISCONNECTED);
        MSG_TYPE_NAME(MSG_LAN_SUBMASK_CHG);

        MSG_TYPE_NAME(MSG_WAN_CONN_SET_CHNG);
        MSG_TYPE_NAME(MSG_UPDATE_MANAGE_ROUTE);

        MSG_TYPE_NAME(MSG_DEFAULT_CONN_CHNG);
        MSG_TYPE_NAME(MSG_DEFAULT_ROUTE_CHANGE);

        MSG_TYPE_NAME(MSG_WAN_ADD_LINK_DEV);
        MSG_TYPE_NAME(MSG_WAN_DEL_LINK_DEV);
        MSG_TYPE_NAME(MSG_WAN_LINK_DEV_STAT_INFORM);

        MSG_TYPE_NAME(MSG_VOIP_LED_SET);
        MSG_TYPE_NAME(MSG_VOIP_IPT_SET);
        MSG_TYPE_NAME(MSG_VOIP_WAN_PARA_SET);
        MSG_TYPE_NAME(MSG_VOIP_QOS_SET);
        MSG_TYPE_NAME(MSG_VOIP_START_VTP);
        MSG_TYPE_NAME(MSG_VOIP_VOIP_STATUS);
        MSG_TYPE_NAME(MSG_VOIP_PHONE_STATUS);
        MSG_TYPE_NAME(MSG_VOIP_WAN_EST);

        MSG_TYPE_NAME(MSG_TR069_CONNECTSUCCESS);
        MSG_TYPE_NAME(MSG_TR069_GETINTERNETACCOUNT);

        MSG_TYPE_NAME(MSG_WAN_CONN_DEV_CHNG);
        MSG_TYPE_NAME(MSG_INFORM_BIND_INFO);

        MSG_TYPE_NAME(MSG_USB_MODEM_LINK_CHG);

        MSG_TYPE_NAME(MSG_WLAN_ENABLE_UPDATE);
        MSG_TYPE_NAME(MSG_LAN_GROUP_UPDATE);

        /* ں˽ʹõϢ */
        MSG_TYPE_NAME(MSG_BLP_BASE);
        MSG_TYPE_NAME(MSG_BLP_DEVCTL_ADD);
        MSG_TYPE_NAME(MSG_BLP_DEVCTL_DEL);
        MSG_TYPE_NAME(MSG_BLP_DEVCTL_QUERY);
        MSG_TYPE_NAME(MSG_BLP_DEVCTL_CONFIG);

        MSG_TYPE_NAME(MSG_PPPS_CLIENT_CHNG);
        MSG_TYPE_NAME(MSG_UPG_UPGRADE_FAILED);
        MSG_TYPE_NAME(MSG_LOG_SET_LEVEL);
        MSG_TYPE_NAME(MSG_TR069_ACS_CHANGED);

		MSG_TYPE_NAME(MSG_DUAL_ACCESS_CONNECTED);

		MSG_TYPE_NAME(MSG_IP6CONN_STAT_CHANGED);
        MSG_TYPE_NAME(MSG_IP6CONN_ADDR_CHANGED);
        MSG_TYPE_NAME(MSG_IP6CONN_ROUTER_CHANGED);
        MSG_TYPE_NAME(MSG_DFLT_IP6CONN_CHANGED);
        MSG_TYPE_NAME(MSG_IP6LAN_DOMAIN_NAME_UPDATE);
        MSG_TYPE_NAME(MSG_IP6LAN_PREFIX_CHANGED);
        MSG_TYPE_NAME(MSG_IP6LAN_DNS_CHANGED);
        MSG_TYPE_NAME(MSG_IP6LAN_ADDR_CHANGED);
        MSG_TYPE_NAME(MSG_IP6LAN_IFCON_CHANGED);
        MSG_TYPE_NAME(MSG_IP6AAC_NOTIFY);
        MSG_TYPE_NAME(MSG_IP6AAC_REQUEST);
        MSG_TYPE_NAME(MSG_IP6AAC_RELEASE);
        MSG_TYPE_NAME(MSG_IPV6_ADDR_NOTIFY);
        MSG_TYPE_NAME(MSG_IPV6_DFLTGW_NOTIFY);
        MSG_TYPE_NAME(MSG_RS_FAILED);
        MSG_TYPE_NAME(MSG_RA_UPDATE);
        MSG_TYPE_NAME(MSG_IP6CONN_DNS_CHANGED);
        MSG_TYPE_NAME(MSG_PPPV6_CONN_EST);
        MSG_TYPE_NAME(MSG_PPPV6_CONN_FIN);
        MSG_TYPE_NAME(MSG_IP6CONN_NTP_CHANGED);
        MSG_TYPE_NAME(MSG_IP6CONN_PREFIX_CHANGED);
        MSG_TYPE_NAME(MSG_BRIDGE_BIND_PORT);
        MSG_TYPE_NAME(MSG_BRIDGE_UNBIND_PORT);

        MSG_TYPE_NAME(MSG_PUB_END);

     	default:
		{
			sprintf(acMsgTypeName, "UNKNOWN_MSGTYPE(%04x)", usMsgType);
			return acMsgTypeName;
		}
	}

    if (usMsgType > 0x8000)
        strcat(acMsgTypeName, "_ACK");

    return acMsgTypeName;
}

/*
*	: 	tbsGetMIDName
*	: 	ԸֵʽMIDתΪַɶʽ
*	: 	usMID - MIDֵ
*	ֵ  :	ӦMIDַ֡ںʶΧУ
*				UNKNOWN_MID(ddd)ʽ
*	    : 	 / 2008-11-10
*/
const char* tbsGetMIDName(unsigned short usMID)
{
	#define MID_NAME(name) case name: return #name
	switch (usMID)
    {
        MID_NAME(MID_CCP);
        MID_NAME(MID_AUTH);
        MID_NAME(MID_IGMP);
        MID_NAME(MID_CMM);
        MID_NAME(MID_LAN);
        MID_NAME(MID_IPT);
        MID_NAME(MID_ETHLAN);
        MID_NAME(MID_ETHWAN);
        MID_NAME(MID_PPPOE);
        MID_NAME(MID_WLAN);
        MID_NAME(MID_TR069BE);
        MID_NAME(MID_DGN);
        MID_NAME(MID_DHCPR);
        MID_NAME(MID_DHCPS);
        MID_NAME(MID_TIMER);
        MID_NAME(MID_IPCONN);
        MID_NAME(MID_FIREWALL);
        MID_NAME(MID_SNMPC);
        MID_NAME(MID_QOS);
        MID_NAME(MID_SROUTE);
        MID_NAME(MID_VDSL);
        MID_NAME(MID_DNS);
        MID_NAME(MID_ALG);
        MID_NAME(MID_WAN);
        MID_NAME(MID_DROUTE);
        MID_NAME(MID_SNTP);
        MID_NAME(MID_VLAN);
        MID_NAME(MID_USB_MASS);
        MID_NAME(MID_LOG);
        MID_NAME(MID_FTPD);
        MID_NAME(MID_NATPRIO);
        MID_NAME(MID_WPS);
        MID_NAME(MID_ACL);
        MID_NAME(MID_UPNP);
        MID_NAME(MID_LSVLAN);
        MID_NAME(MID_PORTOFF);
        MID_NAME(MID_ANTIATTACK);
        MID_NAME(MID_DEVINFO);
        MID_NAME(MID_PORTMAPPING);
        MID_NAME(MID_URLFILTER);
        MID_NAME(MID_ATM);
        MID_NAME(MID_DSL);
        MID_NAME(MID_DDNS);
        MID_NAME(MID_PROUTE);
        MID_NAME(MID_CFG);
        MID_NAME(MID_SUPP);
        MID_NAME(MID_MACFILTER);
        MID_NAME(MID_TRACERT);
        MID_NAME(MID_IPPD);
        MID_NAME(MID_WEBP);
        MID_NAME(MID_BRIDGE_FILTER);
        MID_NAME(MID_SCHED);
        MID_NAME(MID_PORTTRIGGER);
        MID_NAME(MID_IP_ACL);
        MID_NAME(MID_DEFAULTGW);
        MID_NAME(MID_DIAG);
        MID_NAME(MID_WANSELECT);
        MID_NAME(MID_VOIPBE);
        MID_NAME(MID_AUP);
        MID_NAME(MID_FTPCLIENT);
        MID_NAME(MID_CTQOS);
        MID_NAME(MID_CTMONITOR);
        MID_NAME(MID_NSM);
        MID_NAME(MID_DEVCTL);
        MID_NAME(MID_PORTALMANAGE);
        MID_NAME(MID_PC);
        MID_NAME(MID_MON);
        MID_NAME(MID_LBT);
        MID_NAME(MID_LANG);	
        MID_NAME(MID_MTR);  /* Add by zym september 29 2010 */
        MID_NAME(MID_WEB);
        MID_NAME(MID_LNB);
        MID_NAME(MID_CLI);
        MID_NAME(MID_TR069FE);
        MID_NAME(MID_TR069_HTTPD);
        MID_NAME(MID_SNMPA);
		MID_NAME(MID_MAIL);
        MID_NAME(MID_ELM);
        MID_NAME(MID_UPG);
        MID_NAME(MID_UPGCGI);
        MID_NAME(MID_FTPUPG);
        MID_NAME(MID_TFTPUPG);
        MID_NAME(MID_VDSLD);
        MID_NAME(MID_TM);
        MID_NAME(MID_PTI);
        MID_NAME(MID_MSG4UDP);
        MID_NAME(MID_VOIP);
        MID_NAME(MID_HOTPLUG);
        MID_NAME(MID_NULL);
        MID_NAME(MID_WATCHDOG);
        MID_NAME(MID_TRFFCMTR);  /* Add by zym september 28 2010 */
		MID_NAME(MID_MINIHTTPD_SELF);  /* Add by wujunyong 2011.3.3*/
		MID_NAME(MID_DPROXY_SELF);  /* Add by wujunyong 2011.3.3*/
		MID_NAME(MID_DHCP6S);
        MID_NAME(MID_RAD);
        MID_NAME(MID_RAMON);
        MID_NAME(MID_IP6MON);
        MID_NAME(MID_IP6AAC);
        MID_NAME(MID_V6CONN);
		MID_NAME(MID_DUAL_ACCESS);

        MID_NAME(MID_GRP_MACLIST_UPDATE);
        MID_NAME(MID_GRP_MON_LINK_UPDATE);
        MID_NAME(MID_GRP_WAN_LINK_UPDATE);
        MID_NAME(MID_GRP_WAN_CONN_UPDATE);
        MID_NAME(MID_GRP_DNS_UPDATE);
        MID_NAME(MID_GRP_WAN_DEL_INST);
        MID_NAME(MID_GRP_WAN_ADD_INST);
        MID_NAME(MID_GRP_BUTTON);
        MID_NAME(MID_GRP_TIME_CHANGED);
        MID_NAME(MID_GRP_WAN_CONN_ENABLE_UPDATE);
        MID_NAME(MID_GRP_LAN_DEL_INST);
        MID_NAME(MID_GRP_LAN_ADD_INST);
        MID_NAME(MID_GRP_WLAN_DEL_INST);
        MID_NAME(MID_GRP_WLAN_ADD_INST);
        MID_NAME(MID_GRP_LAN_ETH_INST_CHG);
        MID_NAME(MID_GRP_LAN_IP_UPDATE);
        MID_NAME(MID_GRP_DHCPS_DEVICE_MSG);
        MID_NAME(MID_GRP_LAN_SUBMASK_CHG);
        MID_NAME(MID_GRP_WAN_CONN_SET_CHNG);
        MID_NAME(MID_GRP_DEFAULT_CONN_CHNG);
        MID_NAME(MID_GRP_WAN_CONN_DEV_CHNG);
        MID_NAME(MID_GRP_WLAN_ENABLE_UPDATE);
        MID_NAME(MID_GRP_LAN_GROUP_UPDATE);
        MID_NAME(MID_GRP_DEFAULT_ROUTE_CHANGE);
        MID_NAME(MID_GRP_PPPS_CLIENT_CHNG);
		MID_NAME(MID_GRP_IP6LAN_ADDR_CHANGED);
        MID_NAME(MID_GRP_IP6LAN_PREFIX_CHANGED);
        MID_NAME(MID_GRP_IP6CONN_DNS_CHANGED);
        MID_NAME(MID_GRP_IP6LAN_IFCON_CHANGED);
        MID_NAME(MID_GRP_BR_BIND_PORT);
        MID_NAME(MID_GRP_BR_UNBIND_PORT);
        MID_NAME(MID_GRP_IP6CONN_ADDR_CHANGED);
        MID_NAME(MID_GRP_IP6CONN_ROUTER_CHANGED);
        MID_NAME(MID_GRP_IP6CONN_STAT_CHANGED);
        MID_NAME(MID_GRP_DFLT_IP6CONN_CHANGED);

	 	default:
		{
			static char s_szUnsupported[64];
			sprintf(s_szUnsupported, "UNKNOWN_MID(%04x)", usMID);
			return s_szUnsupported;
		}
	}
}


unsigned short tbsGetMIDByName(const char *pszModName)
{
    unsigned short usMID = 0;

    return usMID;
}

unsigned short tbsGetMsgTypeByName(const char *pszModName)
{
    unsigned short usMsgType = 0;

    return usMsgType;
}


