/******************************************************************************
  Copyright (c), 1991-2007, T&W ELECTRONICS(SHENTHEN) Co., Ltd.

  ļ: tbserror.h
  ļ: ͳһTBSڲ붨弰
  б:
            inline const char *tbsstrerr (int errnum)
  ޶¼:
         1. : tbs
            : 2007-12-28
            : ļ
         2. : huangce
            : 2008-03-19
            : ޸ļ
 ******************************************************************************/


#ifndef __TBS_TBSERROR_H__
#define __TBS_TBSERROR_H__

#include <stdio.h>
#include <stdlib.h>
#include "tbstype.h"

//#defined TBS_SSAP_SUPPORT_IPV6 1

/*--------------------б--------------------------*/
enum
{
    /*--------------------ͨô뷵ֵ--------------------------*/
    TBS_SUCCESS                             = 0,        /* ɹ/*/
    TBS_FAILED                              = -1,   /* ʧ/һ*/
    TBS_MSG_SEND_ERR                        = -2,   /* Ϣʧ*/
    TBS_OUT_OF_MEM                          = -3,   /* ڴ治*/
    TBS_PARAM_ERR                           = -4,   /* ȷ*/
    TBS_OUT_OF_SRC                          = -5,   /* Դ, ƿ...*/
    TBS_TIME_OUT                            = -6,   /* ʱ*/
    TBS_COLLISION                           = -7,   /* ͻ, 繲/Ƿ...*/
    TBS_NULL_PTR                            = -8,   /* ָ */

    /* ˫ĳô */
    TBS_LIST_NOT_EMPTY                      = -9,    /* List is not empty */
    TBS_LIST_EMPTY                          = -10,   /* List is empty */
    TBS_INVALID_INDEX                       = -11,   /* Invalid index, valid index range: 0x1 ~ 0xffffffff */
    TBS_INDEX_OVERFLOW                      = -12,   /* Index overflow, valid index range: 0x1 ~ 0xffffffff */
    TBS_CORRUPT_STRUCT                      = -13,   /* Corrupt struct, meaning struct is not initialized properly */

    TBS_NO_INSTANCE                         = -14,/*ûжӦʵ*/
    TBS_MODULE_BUSY                         = -15 , /* ģæݲϢ*/

    /*--------------------TR069ͨô뷵ֵ--------------------------*/
    TR069_ERRNO_UNSUP_FUNC                  = 9000,  /* ֧*/
    TR069_ERRNO_REJECT                      = 9001,  /* ܾ, δ˵ԭ*/
    TR069_ERRNO_CPE_ERR                     = 9002,  /* ڲ*/
    TR069_ERRNO_INVALID_PARAM               = 9003,  /* Ч*/
    TR069_ERRNO_NO_RESOURCE                 = 9004,  /* ԴޣSetParameterValuesĹʱָʾ*/
    TR069_ERRNO_INVALID_NAME                = 9005,  /* ЧSet/GetParameterValuesGetParameterNamesSet/GetParameterAttributesأ*/
    TR069_ERRNO_INVALID_TYPE                = 9006,  /* ЧͣSetParameterValuesأ*/
    TR069_ERRNO_INVALID_VAL                 = 9007,  /* ЧֵSetParameterValuesأ*/
    TR069_ERRNO_WRITE_FORBID                = 9008,  /* ͼòдĲSetParameterValuesأ*/
    TR069_ERRNO_NOTI_REQ_REJ                = 9009,  /* ֪ͨ󱻾ܾSetParameterAttributesأ*/
    TR069_ERRNO_DOWNLOAD_FAIL               = 9010,  /* ʧܣDownloadTransferCompleteأ*/
    TR069_ERRNO_UPLOAD_FAIL                 = 9011,  /* ʧܣUploadTransferCompleteأ*/
    TR069_ERRNO_FS_AUTHFAIL                 = 9012,  /* ļ֤ʧܣUploadTransferCompleteأ*/
    TR069_ERRNO_FS_NOTSUPP                  = 9013,  /* ֵ֧ļЭ飨UploadTransferCompleteأ*/

    ERR_UNKNOWN                             /* һʱڴǰӴ */

};




#define TBS_ERR_BASE_ADDR                   1000
#define TBS_ERR_CVT(err, std)               ((((unsigned short)(err)) << 16) | (unsigned short)(std))

/* logic еģøúȷַ */
#define TBS_ERR_LOGIC_BASE_ADDR(mid)        (TBS_ERR_BASE_ADDR + ((mid & 0x00ff)) * 100)

/* logic еģøúȷַ */
#define TBS_ERR_OUT_PROC_BASE_ADDR          7000
#define TBS_ERR_PROC_BASE_ADDR(mid)         (TBS_ERR_OUT_PROC_BASE_ADDR + ((mid >> 8)) * 100)


#define TBS_ERR_STAND(err)                  (unsigned short)(((unsigned long)err) & 0x0000ffff)
#define TBS_ERR_INTERNAL(err)               (unsigned short)(((unsigned long)err) >> 16)


/*  */
#define ERR_COMMON_BEGIN_ADDR               TBS_ERR_LOGIC_BASE_ADDR(0)

#define ERR_NOT_SUPPORT_FUNCTION            TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 1,  TR069_ERRNO_INVALID_VAL)
#define ERR_IP_INVALID_FORMAT               TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_PORT_INVALID_FORMAT             TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_PORT_TOO_SMALL                  TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_PORT_TOO_BIG                    TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)
#define ERR_PRIORITY_INVALID_VALUE          TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_VAL)
#define ERR_PRIORITY_TOO_SMALL              TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)
#define ERR_PRIORITY_TOO_BIG                TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 8, TR069_ERRNO_INVALID_VAL)
#define ERR_MASK_INVALID_FORMAT             TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 9, TR069_ERRNO_INVALID_VAL)
#define ERR_MASK_EMPTY                      TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 10, TR069_ERRNO_INVALID_VAL)
#define ERR_MAKS_ALL_ZERO                   TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 11, TR069_ERRNO_INVALID_VAL)
#define ERR_MASK_INVALID_VALUE              TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 12, TR069_ERRNO_INVALID_VAL)
#define ERR_ENABLE_EMPTY                    TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 13, TR069_ERRNO_INVALID_VAL)
#define ERR_ENABLE_INVALID_VALUE            TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 14, TR069_ERRNO_INVALID_VAL)
#define ERR_INT_INVALID_VALUE               TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 15, TR069_ERRNO_INVALID_VAL)
#define ERR_UINT_INVALID_VALUE              TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 16, TR069_ERRNO_INVALID_VAL)
#define ERR_MAC_INVALID_VALUE               TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 17, TR069_ERRNO_INVALID_VAL)
#define ERR_IPLIST_TOO_MANY                 TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 18, TR069_ERRNO_INVALID_VAL)
#define ERR_IPLIST_INVALID_FORMAT           TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 19, TR069_ERRNO_INVALID_VAL)
#define ERR_MACLIST_INVALID_FORMAT          TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 20, TR069_ERRNO_INVALID_VAL)
#define ERR_MACLIST_TOO_MANY                TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 21, TR069_ERRNO_INVALID_VAL)
#define ERR_INSTANCE_TOO_MANY               TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 22, TR069_ERRNO_INVALID_VAL)
#define ERR_INSTANCE_IMMUTABLE              TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 23, TR069_ERRNO_INVALID_VAL)
#define ERR_INNER_MSG_INVALID               TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 24, TR069_ERRNO_CPE_ERR)
#define ERR_INNER_MSG_REPEATED_NAME         TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 25, TR069_ERRNO_REJECT)
#define ERR_INNER_CACHE_INVALID             TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 26, TR069_ERRNO_REJECT)
#define ERR_USERNAME                        TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 27, TR069_ERRNO_INVALID_VAL)
#define ERR_PASSWORD                        TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 28, TR069_ERRNO_INVALID_VAL)
#define ERR_IP_MASK_NOT_MATCH               TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 29, TR069_ERRNO_INVALID_VAL)
#define ERR_ETH_INVALID_BITRATE             TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 30, TR069_ERRNO_INVALID_VAL)
#define ERR_ETH_INVALID_DUPLEXMODE          TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 31, TR069_ERRNO_INVALID_VAL)
#define ERR_IP_IS_CAST_ADDR                 TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 32, TR069_ERRNO_INVALID_VAL)
#define ERR_IP_IS_HOST_ADDR                 TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 33, TR069_ERRNO_INVALID_VAL)
#define ERR_IP_ADDR_START_MINOR_END         TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 34, TR069_ERRNO_INVALID_VAL)
#define ERR_IP_ADDR_POOL_OVERLAP            TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 35, TR069_ERRNO_INVALID_VAL)
#define ERR_STR_TOO_LONG                    TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 36, TR069_ERRNO_INVALID_VAL)
#define ERR_CAN_NOT_EMPTY                   TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 37, TR069_ERRNO_INVALID_VAL)
#define ERR_GET_NODE_VALUE_FAIL             TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 38, TR069_ERRNO_INVALID_VAL)
#define ERR_SET_NODE_VALUE_FAIL             TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 39, TR069_ERRNO_INVALID_VAL)
#define ERR_INVALID_DOMAIN_NAME             TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 40, TR069_ERRNO_INVALID_VAL)
#define ERR_OUT_OF_RANGE                    TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 41, TR069_ERRNO_INVALID_VAL)
#define ERR_IPLIST_HAS_REPEAT               TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 42, TR069_ERRNO_INVALID_VAL)
#define ERR_IP_IS_WRONG_NET_SECTION         TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 43, TR069_ERRNO_INVALID_VAL)
#define ERR_IP_IS_CAST_OR_NET_ADDR          TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 44, TR069_ERRNO_INVALID_VAL)
#define ERR_ENABLE_DHCPS_CONFLICT_DHCPR     TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 45, TR069_ERRNO_INVALID_VAL)
#define ERR_PORT_RANGE_INVALID              TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 46, TR069_ERRNO_INVALID_VAL)
#define ERR_INVALID_VAL                     TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 47, TR069_ERRNO_INVALID_VAL)
#define ERR_LIST_HAS_REPEAT                 TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 48, TR069_ERRNO_INVALID_VAL)
#define ERR_PORT_HAS_OCCUPIED               TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 49, TR069_ERRNO_INVALID_VAL)
#define ERR_IP_IS_WRONG_LAN_NET_SECTION     TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 50, TR069_ERRNO_INVALID_VAL)   

#define ERR_MSG_MID_INVALID                 TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 60, TR069_ERRNO_INVALID_VAL)
#define ERR_MSG_SOCKET                      TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 61, TR069_ERRNO_INVALID_VAL)
#define ERR_MSG_PROC_NOT_FOUND              TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 62, TR069_ERRNO_INVALID_VAL)
#define ERR_MSG_SEND_FAIL                   TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 63, TR069_ERRNO_INVALID_VAL)
#define ERR_MSG_DSTMID_UNREGED              TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 64, TR069_ERRNO_INVALID_VAL)
#define ERR_MSG_NOT_FULL                    TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 65, TR069_ERRNO_INVALID_VAL)
#define ERR_MSG_PART_NOEFFECT               TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 66, TR069_ERRNO_INVALID_VAL)
#define ERR_MSG_PART_INVALID                TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 67, TR069_ERRNO_INVALID_VAL)
#define ERR_MSG_TIMEOUT                     TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 68, TR069_ERRNO_INVALID_VAL)
#define ERR_MSG_PART_LIST_FULL              TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 69, TR069_ERRNO_INVALID_VAL)

#define ERR_MALLOC_FAILED                   TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 70, TR069_ERRNO_CPE_ERR)
#define ERR_BUF_NOT_ENOUGH                  TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 71, TR069_ERRNO_CPE_ERR)
#define ERR_INTERNAL_ERR                    TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 72, TR069_ERRNO_CPE_ERR)
#define ERR_PARA_INVALID                    TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 73, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_OPEN                       TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 74, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_READ                       TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 75, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_WRITE                      TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 76, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_CHKSUM                     TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 77, TR069_ERRNO_CPE_ERR)
#define ERR_BUSY                            TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 78, TR069_ERRNO_CPE_ERR)
#define ERR_CREATE_MSG_FAIL                 TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 79, TR069_ERRNO_CPE_ERR)
#define ERR_MSG_EXT_MID_LIST_FULL           TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 80, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_OPEN_EXSITED               TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 81, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_WTITE_NOSPACE              TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 82, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_NOT_ALLOWED                TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 83, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_RM_UNKOWN                  TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 84, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_OPEN_UNKOWN                TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 85, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_WRITE_UNKOWN               TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 86, TR069_ERRNO_CPE_ERR)
#define ERR_IP_INVALID_RANGE                TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 87, TR069_ERRNO_INVALID_VAL)


/* public in logic */
#define ERR_INVALID_SCHEDULE_PATH           TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 90, TR069_ERRNO_INVALID_VAL)
#define ERR_INVALID_FILTER_MODE             TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 91, TR069_ERRNO_INVALID_VAL)
#define ERR_INVALID_CHARACTERS              TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 92, TR069_ERRNO_INVALID_VAL)
#define ERR_DESCRIPTION_DUPLICATE           TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 93, TR069_ERRNO_INVALID_VAL)

#ifdef TBS_SSAP_SUPPORT_IPV6
/*for ipv6*/
#define ERR_IPV6_INVALID_FORMAT         TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 94, TR069_ERRNO_INVALID_VAL)
#define ERR_IPV6_ADDR_REPEAT            TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 95, TR069_ERRNO_INVALID_VAL)
#define ERR_IPV6_INVALID_PREFIX_LEN     TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 96, TR069_ERRNO_INVALID_VAL)
#define ERR_IPV6_INVALID_DUID           TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 97, TR069_ERRNO_INVALID_VAL)
#define ERR_INVALID_PROTO_TYPE          TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 98, TR069_ERRNO_INVALID_VAL)
#define ERR_NOT_IPv6_GLOBAL_UNIQUE_ADDR TBS_ERR_CVT(ERR_COMMON_BEGIN_ADDR + 99, TR069_ERRNO_INVALID_VAL)
#endif

/* CMM */
#define ERR_CMM_BEGIN_ADDR                  TBS_ERR_LOGIC_BASE_ADDR(MID_CMM)

#define ERR_CMM_NOMID                       TBS_ERR_CVT(ERR_CMM_BEGIN_ADDR + 1,   TR069_ERRNO_CPE_ERR)
#define ERR_CMM_INVALID_INDEX               TBS_ERR_CVT(ERR_CMM_BEGIN_ADDR + 2,   TR069_ERRNO_CPE_ERR)
#define ERR_CMM_NOLEAF                      TBS_ERR_CVT(ERR_CMM_BEGIN_ADDR + 3,   TR069_ERRNO_INVALID_NAME)
#define ERR_CMM_NOITEM                      TBS_ERR_CVT(ERR_CMM_BEGIN_ADDR + 4,   TR069_ERRNO_INVALID_PARAM)
#define ERR_CMM_INVALID_PATH                TBS_ERR_CVT(ERR_CMM_BEGIN_ADDR + 5,   TR069_ERRNO_INVALID_NAME)
#define ERR_CMM_TIMEOUT                     TBS_ERR_CVT(ERR_CMM_BEGIN_ADDR + 6,   TR069_ERRNO_CPE_ERR)


/* CFG */
#define ERR_CFG_BEGIN_ADDR                  (TBS_ERR_LOGIC_BASE_ADDR(MID_CMM) + 50)

#define ERR_CFG_ATTR_STAT                   TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 1,  TR069_ERRNO_INVALID_NAME)
#define ERR_CFG_PATH_NOT_EXSITED            TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 2,  TR069_ERRNO_INVALID_NAME)
#define ERR_CFG_INVALID_OBJ_VAL             TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 3,  TR069_ERRNO_INVALID_NAME)
#define ERR_CFG_INVALID_STRING              TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 4,  TR069_ERRNO_INVALID_VAL)
#define ERR_CFG_INVALID_INT_0               TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 5,  TR069_ERRNO_INVALID_VAL)
#define ERR_CFG_INVALID_INT_01              TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 6,  TR069_ERRNO_INVALID_VAL)
#define ERR_CFG_INVALID_INT_A               TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 7,  TR069_ERRNO_INVALID_VAL)
#define ERR_CFG_INVALID_UINT_0              TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 8,  TR069_ERRNO_INVALID_VAL)
#define ERR_CFG_INVALID_UINT_01             TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 9,  TR069_ERRNO_INVALID_VAL)
#define ERR_CFG_INVALID_UINT_A              TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 10, TR069_ERRNO_INVALID_VAL)
#define ERR_CFG_INVALID_BOOL                TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 11, TR069_ERRNO_INVALID_VAL)
#define ERR_CFG_INVALID_TIME                TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 12, TR069_ERRNO_INVALID_VAL)
#define ERR_CFG_INVALID_HEX                 TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 13, TR069_ERRNO_INVALID_VAL)
#define ERR_CFG_NOT_WRITABLE                TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 14, TR069_ERRNO_WRITE_FORBID)
#define ERR_CFG_NOT_IN_ACCESSLIST           TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 15, TR069_ERRNO_WRITE_FORBID)
#define ERR_CFG_PATH_NOT_INST               TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 16, TR069_ERRNO_INVALID_VAL)
#define ERR_CFG_NOT_STANDARD                TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 17, TR069_ERRNO_INVALID_VAL)
#define ERR_CFG_INVALID_TYPE                TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 18,  TR069_ERRNO_CPE_ERR)
#define ERR_CFG_ITEM_OPT_FAIL               TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 19,  TR069_ERRNO_CPE_ERR)
#define ERR_CFG_WILDCARD_QUE_FULL           TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 20,  TR069_ERRNO_CPE_ERR)

#define ERR_CFG_INVALID_PATH                TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 21,  TR069_ERRNO_INVALID_NAME)
#define ERR_CFG_OBJ_INST_FULL               TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 22,  TR069_ERRNO_NO_RESOURCE)
#define ERR_CFG_TIME_OUT          			TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 23,  TR069_ERRNO_NO_RESOURCE)
#define ERR_CFG_FILE_FOTMAT       			TBS_ERR_CVT(ERR_CFG_BEGIN_ADDR + 24,  TR069_ERRNO_INVALID_VAL)


/* AUTH */
#define ERR_AUTH_BEGIN_ADDR                 TBS_ERR_LOGIC_BASE_ADDR(MID_AUTH)

#define ERR_AUTH_TYPE                       TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_CANNOT_CHANGE_USER         TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_CANNOT_CHANGE_LEVEL        TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_CANNOT_REMOVE_ADMIN        TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_HAVE_SAME_USER             TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_PASSWORD_TOO_LONG          TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_USERNAME_TOO_LONG          TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)

#define ERR_AUTH_SESSION_FULL               TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 8, TR069_ERRNO_NO_RESOURCE)
#define ERR_AUTH_WRONG_USER                 TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 9, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_WRONG_PASSWORD             TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 10, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_WRONG_USER_OR_PWD          TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 11, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_SESSION_TIMEOUT            TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 12, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_SESSION_ILLEGAL            TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 13, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_LOGIN_FREQUENT             TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 14, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_LOGOUT_SUCCESS             TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 15, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_OLDPASSWORD_INVALID        TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 16, TR069_ERRNO_INVALID_VAL)

#ifdef CONFIG_APPS_LOGIC_PASSWORD_RECOVERY
/*PASSWORD RECOVERY, Depend on AUTH*/
#define ERR_AUTH_PWRECOVER_ANSWER          TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 17, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_PWRECOVER_ANSWER_TOO_LONG          TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 18, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_PR_ANSER_RIGHT          TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 19, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_PR_ANSER_WRONG          TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 20, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_PR_SN_RIGHT          TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 21, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_PR_SN_WRONG          TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 22, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_PR_ANSER1_WRONG          TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 23, TR069_ERRNO_INVALID_VAL)
#define ERR_AUTH_PR_ANSER2_WRONG          TBS_ERR_CVT(ERR_AUTH_BEGIN_ADDR + 24, TR069_ERRNO_INVALID_VAL)
#endif

/* PING */
#define ERR_DGN_BEGIN_ADDR                  TBS_ERR_LOGIC_BASE_ADDR(MID_DGN)

#define ERR_DGN_INVALID_STATE               TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_DGN_INVALID_INTF                TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_DGN_INVALID_HOST_IP_PART        TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_DGN_INVALID_HOST_IP_OCT         TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)
#define ERR_DGN_INVALID_HOST_BEGIN          TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_VAL)
#define ERR_DGN_INVALID_TIMES               TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)
#define ERR_DGN_INVALID_TO                  TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 8, TR069_ERRNO_INVALID_VAL)
#define ERR_DGN_INVALID_SIZE                TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 9, TR069_ERRNO_INVALID_VAL)
#define ERR_DGN_INVALID_DSCP                TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 10, TR069_ERRNO_INVALID_VAL)
#define ERR_DGN_NOHOST                      TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 11, TR069_ERRNO_INVALID_VAL)
#define ERR_DGN_INVALID_HOST_A              TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 12, TR069_ERRNO_INVALID_VAL)
#define ERR_DGN_INVALID_HOST_LEN            TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 13, TR069_ERRNO_INVALID_VAL)
#define ERR_DGN_MSG_FORMAT                  TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 14, TR069_ERRNO_INVALID_PARAM)
#define ERR_DGN_PATH                        TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 15, TR069_ERRNO_CPE_ERR)
#define ERR_DGN_NOSTART                     TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 16, TR069_ERRNO_CPE_ERR)
#define ERR_DGN_NOITEM                      TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 17, TR069_ERRNO_CPE_ERR)
#define ERR_DGN_INVALID_IP_TYPE   			TBS_ERR_CVT(ERR_DGN_BEGIN_ADDR + 18, TR069_ERRNO_CPE_ERR)


/* COMMON HANDLER*/
#define ERR_FUNC_BEGIN_ADDR                 TBS_ERR_LOGIC_BASE_ADDR(MID_CCP)

/* LAN */
#define ERR_LAN_BEGIN_ADDR                  TBS_ERR_LOGIC_BASE_ADDR(MID_LAN)

#define ERR_LAN_INVALID_IP_FORMAT           TBS_ERR_CVT(ERR_LAN_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_LAN_INVALID_LAN_IP              TBS_ERR_CVT(ERR_LAN_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_LAN_MACLIST_TOO_LONG            TBS_ERR_CVT(ERR_LAN_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_LAN_INVALID_MACLIST             TBS_ERR_CVT(ERR_LAN_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_LAN_IP_MASK_CONFLICT            TBS_ERR_CVT(ERR_LAN_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)
#define ERR_LAN_IP_CONFLICT                 TBS_ERR_CVT(ERR_LAN_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_VAL)
#define ERR_LAN_LAST_INSTANCE               TBS_ERR_CVT(ERR_LAN_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)
#define ERR_LAN_TOO_MANY_INSTANCE           TBS_ERR_CVT(ERR_LAN_BEGIN_ADDR + 8, TR069_ERRNO_INVALID_VAL)
#define ERR_LAN_SAME_REGION_CONFLICT        TBS_ERR_CVT(ERR_LAN_BEGIN_ADDR + 9, TR069_ERRNO_INVALID_VAL)
#define ERR_LAN_NOT_EXIST                   TBS_ERR_CVT(ERR_LAN_BEGIN_ADDR + 10, TR069_ERRNO_INVALID_VAL)
#define ERR_LAN_WAN_IP_CONFLICT             TBS_ERR_CVT(ERR_LAN_BEGIN_ADDR + 11, TR069_ERRNO_INVALID_VAL)
#ifdef TBS_SSAP_SUPPORT_IPV6
#define ERR_LAN_lINKLOCAL_CONFLICT          TBS_ERR_CVT(ERR_LAN_BEGIN_ADDR + 12, TR069_ERRNO_INVALID_VAL)
#endif

/* WAN */
#define ERR_WAN_BEGIN_ADDR                  TBS_ERR_LOGIC_BASE_ADDR(MID_WAN)

#define ERR_WAN_INVALID_INNER_MSG           TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 1, TR069_ERRNO_CPE_ERR)
#define ERR_WAN_INVALID_VAL                 TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_INVALID_SVC_LIST            TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_INVALID_CONN_TYPE           TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_INVALID_LAN_INTF            TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_LAN_INTF_REPEAT             TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_TOO_MORE_BRIDGE             TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_BRIDGE_ROUTE_MIX            TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 8, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_TR069_BRIDGE                TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 9, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_TR069_LAN                   TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 10, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_INVALID_VLAN_ID             TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 11, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_INVALID_VLAN_PRIO           TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 12, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_NOT_EXIST                   TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 13, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_DSL_LINK_CONFLICT           TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 14, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_ETH_LINK_CONFLICT           TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 15, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_TOO_MANY_IP_PPP_INST        TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 16, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_NOREOA_LINK_EXIST           TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 17, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_EOA_LINK_EXIST              TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 18, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_TOO_MANY_PVC                TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 19, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_CANNOT_CHNG_LINK_TYPE       TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 20, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_TOO_MANY_ENABLED_PPP        TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 21, TR069_ERRNO_INVALID_VAL)
#define ERR_DSL_TOO_MANY_IP_INST            TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 22, TR069_ERRNO_INVALID_VAL)
#define ERR_ETH_TOO_MANY_IP_INST            TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 23, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_TOO_MANY_ENABLED_BR         TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 24, TR069_ERRNO_INVALID_VAL)

#define ERR_WAN_INVALID_CONN_PRIOR          TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 25, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_CONN_COUNT_FULL             TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 26, TR069_ERRNO_INVALID_VAL)
#define ERR_WAN_SAME_SUBNET_WITH_LAN             TBS_ERR_CVT(ERR_WAN_BEGIN_ADDR + 27, TR069_ERRNO_INVALID_VAL)


/* DNS */
#define ERR_DNS_BEGIN_ADDR                  TBS_ERR_LOGIC_BASE_ADDR(MID_DNS)

#define ERR_DNS_VALID_DNS_ADDR              TBS_ERR_CVT(ERR_DNS_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_DNS_HAS_REPEAT                  TBS_ERR_CVT(ERR_DNS_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_DNS_CUSTOM_BE_EMPTY             TBS_ERR_CVT(ERR_DNS_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)

/* DHCPS */
#define ERR_DHCPS_BEGIN_ADDR                TBS_ERR_LOGIC_BASE_ADDR(MID_DHCPS)
#define ERR_DHCPS_INVALID_CLASS_ID          TBS_ERR_CVT(ERR_DHCPS_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_DHCPS_EXIST_CLASS_ID            TBS_ERR_CVT(ERR_DHCPS_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_DHCPS_IFIP_ADDRPOOL_UNMATCH     TBS_ERR_CVT(ERR_DHCPS_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_DHCPS_LEASE_TIME                TBS_ERR_CVT(ERR_DHCPS_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_DHCPS_CPEIP_POLL_CONFLICT       TBS_ERR_CVT(ERR_DHCPS_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)
#define ERR_DHCPS_MAC_CONFLICT              TBS_ERR_CVT(ERR_DHCPS_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_VAL)
#define ERR_DHCPS_IP_CONFLICT               TBS_ERR_CVT(ERR_DHCPS_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)
#define ERR_DHCPS_CPEIP_GW_CONFLICT         TBS_ERR_CVT(ERR_DHCPS_BEGIN_ADDR + 8, TR069_ERRNO_INVALID_VAL)
#define ERR_DHCPS_INVALID_HOSTNAME          TBS_ERR_CVT(ERR_DHCPS_BEGIN_ADDR + 9, TR069_ERRNO_INVALID_VAL)
#define ERR_DHCPS_IFIP_ADDRPOOL_CONFLICT    TBS_ERR_CVT(ERR_DHCPS_BEGIN_ADDR + 10, TR069_ERRNO_INVALID_VAL)


/* ETHLAN */
#define ERR_ETHLAN_BEGIN_ADDR               TBS_ERR_LOGIC_BASE_ADDR(MID_ETHLAN)

/* LSVLAN */
#define ERR_LSVLAN_BEGIN_ADDR               TBS_ERR_LOGIC_BASE_ADDR(MID_LSVLAN)

#define ERR_LSVLAN_INVALID_BRIDGENAME       TBS_ERR_CVT(ERR_LSVLAN_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_LSVLAN_INVALID_VLANID           TBS_ERR_CVT(ERR_LSVLAN_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_LSVLAN_INVALID_FILTERBRREF      TBS_ERR_CVT(ERR_LSVLAN_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_LSVLAN_INVALID_FILTERIF         TBS_ERR_CVT(ERR_LSVLAN_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_LSVLAN_TOO_MANY_INSTANCE        TBS_ERR_CVT(ERR_LSVLAN_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)
#define ERR_LSVLAN_DEL_FIRST_BRIDGE         TBS_ERR_CVT(ERR_LSVLAN_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_VAL)
#define ERR_LSVLAN_INSTANCE_IN_USE          TBS_ERR_CVT(ERR_LSVLAN_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)
#define ERR_LSVLAN_BRNAME_CONFLICT          TBS_ERR_CVT(ERR_LSVLAN_BEGIN_ADDR + 8, TR069_ERRNO_INVALID_VAL)
#define ERR_LSVLAN_BRVLAN_CONFLICT          TBS_ERR_CVT(ERR_LSVLAN_BEGIN_ADDR + 9, TR069_ERRNO_INVALID_VAL)
#define ERR_LSVLAN_IF_CONFLICT              TBS_ERR_CVT(ERR_LSVLAN_BEGIN_ADDR + 10, TR069_ERRNO_INVALID_VAL)
#define ERR_LSVLAN_WLAN_IF_TAGGED           TBS_ERR_CVT(ERR_LSVLAN_BEGIN_ADDR + 11, TR069_ERRNO_INVALID_VAL)
#define ERR_LSVLAN_SAME_IF_IN_VLAN   		TBS_ERR_CVT(ERR_LSVLAN_BEGIN_ADDR + 12, TR069_ERRNO_INVALID_VAL)

/* IPCONN */
#define ERR_IPCONN_BEGIN_ADDR               TBS_ERR_LOGIC_BASE_ADDR(MID_IPCONN)
#define ERR_IPCONN_NAME_TOO_LONG            TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_NAME_INVALID             TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_ADDR_TYPE_INVALID        TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_ACTIVE_CONN_OVER         TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_WAN_CONN_OVER            TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_WAN_IPCONN_OVER          TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_IP_GATEWAY_SAME          TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_NAME_EXISTS              TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 8, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_PPPOA_ADD_IP_INST        TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 9, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_CONNTYPE_INVALID         TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 10, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_CONNTYPE_CONFLICT        TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 11, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_IP_GATEWAY_NOT_MATCH     TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 12, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_TOO_MANY_IPOA_INST       TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 13, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_TOO_MANY_IPOE_INST       TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 14, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_INVALID_MTU              TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 15, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_INVALID_HOSTNAME         TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 16, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_INVALID_VENDORID         TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 17, TR069_ERRNO_INVALID_VAL)
#define ERR_IPCONN_INVALID_RENEWRELEASE     TBS_ERR_CVT(ERR_IPCONN_BEGIN_ADDR + 18, TR069_ERRNO_INVALID_VAL)




/* pppoe */
#define ERR_PPPOE_BEGIN_ADDR                TBS_ERR_LOGIC_BASE_ADDR(MID_PPPOE)

#define ERR_PPPOE_NO_RESOURSE               TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 1, TR069_ERRNO_NO_RESOURCE)
#define ERR_PPPOE_INVALID_VAL               TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_INVALID_PATH              TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_PARAM)
#define ERR_PPPOE_EXCEED_CONNECTION_NUM     TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 4, TR069_ERRNO_NO_RESOURCE)
#define ERR_PPPOE_INVALID_INSTANCE          TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 5, TR069_ERRNO_CPE_ERR)
#define ERR_PPPOE_ENABLE_INVALID            TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_USERNAME_INVALID          TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_USERNAME_OVERLENTH        TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 8, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_USERNAME_EMPTY            TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 9, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_PASSWD_INVALID            TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 10, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_PASSWD_OVERLENTH          TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 11, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_PASSWD_EMPTY              TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 12, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_CONNETNAME_INVALID        TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 13, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_CONNETNAME_OVERLENTH      TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 14, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_AUTH_INVALID              TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 15, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_MRU_INVALID               TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 16, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_TRIGGER_INVALID           TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 17, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_CONNACTION_INVALID        TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 18, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_LCPECHO_INVALID           TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 19, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_ACTIVE_CONN_OVER          TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 20, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_INVALID_INNER_MSG         TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 21, TR069_ERRNO_CPE_ERR)
#define ERR_PPPOE_INVALID_MATCH_INDEX       TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 22, TR069_ERRNO_CPE_ERR)
#define ERR_PPPOE_NO_PPPSESSION             TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 23, TR069_ERRNO_REJECT)
#define ERR_PPPOE_NO_PPPSESSION_IDX         TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 24, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_ERROR_PPPSESSION_VAL      TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 25, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_NAME_REPEATED             TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 26, TR069_ERRNO_NO_RESOURCE)
#define ERR_PPPOE_IDLETIME_INVALID          TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 27, TR069_ERRNO_NO_RESOURCE)
#define ERR_PPPOE_IPOA_ADD_PPP_INST         TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 28, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_TOO_MANY_PPPOA_INST       TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 29, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_TOO_MANY_PPPOE_INST       TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 30, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_APN_INVALID               TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 31, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_APN_EMPTY                 TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 32, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_APN_OVERLENTH             TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 33, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_DIALNUMBER_INVALID        TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 34, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_DIALNUMBER_EMPTY          TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 35, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_DIALNUMBER_OVERLENTH      TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 36, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_MTU_INVALID               TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 37, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_ACNAME_INVALID            TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 38, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_SERVICENAME_INVALID       TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 39, TR069_ERRNO_INVALID_VAL)

#define ERR_PPPOE_PROXY_CONFLICT            TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 40, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_PROXY_USER_OVER           TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 41, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_IDLE_INVALID              TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 42, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_TOO_MANY_PPPOU_INST       TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 43, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_TOO_MANY_PPTP_INST        TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 44, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_TOO_MANY_L2TP_INST        TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 45, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_CONNIDNAME_INVALID        TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 46, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_CONNIDNAME_OVERLENTH      TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 47, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_CONNIDNAME_EMPTY          TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 48, TR069_ERRNO_INVALID_VAL)
#define ERR_PPPOE_VPN_GATEWAY_DISCONNECT    TBS_ERR_CVT(ERR_PPPOE_BEGIN_ADDR + 49, TR069_ERRNO_INVALID_VAL)


/*QOS*/
#define ERR_QOS_BEGIN_ADDR                  TBS_ERR_LOGIC_BASE_ADDR(MID_QOS)

#define ERR_QOS_INVALID_IF_PATH             TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_COMMITTED_RATE      TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_PEAK_RATE           TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_VAP_SHAPERATE       ERR_QOS_INVALID_PEAK_RATE
#define ERR_QOS_INVALID_BURST_SIZE          TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_QUE_SCH_ALGORITHM   TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_QUE_IF              TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_QUE_IF_NOT_EXIST            TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_QUE_LEN             TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 8, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_QUE_LEN_TYPE        TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 9, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_QUE_WEIGHT          TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 10, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_DROP_ALGORITHM      TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 11, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_CLASS_TYPE          TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 12, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_CLASS_IF            TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 13, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_ETH_TYPE            TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 14, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_ETH_PRIO            TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 15, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_VLAN_ID             TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 16, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_IP_LEN              TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 17, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_DSCP                TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 18, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_PROTOCOL            TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 19, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_PORT                TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 20, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_CLASS_QUE           TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 21, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_CLASS_QUE_NOT_EXIST         TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 22, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_SHAPE_RATE_CONFLICT         TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 23, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_QUEUE_LEN_CONFLICT          TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 24, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_QUEUE_WEIGHT_CONFLICT       TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 25, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_QUEUE_PRIO_CONFLICT         TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 26, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_IP_LENGTH_CONFLICT          TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 27, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_PORT_MAX_MIN                TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 28, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_WMMMARK_CONFLICT            TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 29, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_FOLICYNAME_CONFLICT			TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 30, TR069_ERRNO_INVALID_VAL)
/* node for mindspeed qos */
#define ERR_QOS_INVALID_BANDWIDTH           TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 31, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_TYPE                TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 32, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_VOICEDATA           TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 33, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_PRIORITY            TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 34, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_RATELIMIT           TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 35, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_INVALID_SIGNALING           TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 36, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_PORT_CONFLICT				TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 37, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_MAC_CONFLICT				TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 38, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_FOLICYNAME_INVALID			TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 39, TR069_ERRNO_INVALID_VAL)
#define ERR_QOS_DESCNAME_INVALID			TBS_ERR_CVT(ERR_QOS_BEGIN_ADDR + 40, TR069_ERRNO_INVALID_VAL)

/* SNTP */
#define ERR_SNTP_BEGIN_ADDR                 TBS_ERR_LOGIC_BASE_ADDR(MID_SNTP)

#define ERR_SNTP_INVALID_UP_INTERVAL        TBS_ERR_CVT(ERR_SNTP_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_SNTP_INVALID_RETRY_INTERVAL     TBS_ERR_CVT(ERR_SNTP_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_SNTP_INVALID_NTP_SERVER         TBS_ERR_CVT(ERR_SNTP_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_SNTP_INVALID_LOCAL_TZ           TBS_ERR_CVT(ERR_SNTP_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_SNTP_INVALID_LOCAL_TZ_NAME      TBS_ERR_CVT(ERR_SNTP_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)
#define ERR_SNTP_INVALID_DATA_TIME          TBS_ERR_CVT(ERR_SNTP_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_VAL)
#define ERR_SNTP_NULL_NTPSERVER_STR         TBS_ERR_CVT(ERR_SNTP_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)
#define ERR_SNTP_NTPSERVERS_CONFLICT        TBS_ERR_CVT(ERR_SNTP_BEGIN_ADDR + 8, TR069_ERRNO_INVALID_VAL)
#define ERR_SNTP_DST_CONFLICT               TBS_ERR_CVT(ERR_SNTP_BEGIN_ADDR + 9, TR069_ERRNO_INVALID_VAL)
#define ERR_SNTP_DST_OFFSET                 TBS_ERR_CVT(ERR_SNTP_BEGIN_ADDR + 10, TR069_ERRNO_INVALID_VAL)

/* dynamic route */
#define ERR_DROUTE_BEGIN_ADDR               TBS_ERR_LOGIC_BASE_ADDR(MID_DROUTE)

#define ERR_DROUTE_INVALID_VAL              TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_DROUTE_INVALID_CONFIG_FILE      TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 2, TR069_ERRNO_CPE_ERR)
#define ERR_DROUTE_INVALID_INNER_PARA       TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 3, TR069_ERRNO_CPE_ERR)
#define ERR_DROUTE_VERSION_INVALID          TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_DROUTE_INVALID_WAN              TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 5, TR069_ERRNO_CPE_ERR)
#define ERR_DROUTE_INVALID_PC_MSG           TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 6, TR069_ERRNO_CPE_ERR)
#define ERR_DROUTE_INVALID_INSTANCE         TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 7, TR069_ERRNO_CPE_ERR)
#define ERR_DROUTE_INVALID_PATH             TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 8, TR069_ERRNO_INVALID_VAL)
#define ERR_DROUTE_NO_RESOURSE              TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 9, TR069_ERRNO_CPE_ERR)
#define ERR_DROUTE_ENABLE_INVALID           TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 10, TR069_ERRNO_INVALID_VAL)
#define ERR_DROUTE_G_ENABLE_INVALID         TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 11, TR069_ERRNO_INVALID_VAL)
#define ERR_DROUTE_L_ENABLE_INVALID         TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 12, TR069_ERRNO_INVALID_VAL)
#define ERR_DROUTE_INTERFACE_NAME_INVALID   TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 13, TR069_ERRNO_INVALID_VAL)
#define ERR_DROUTE_OPERATE_INVALID          TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 14, TR069_ERRNO_INVALID_VAL)
#define ERR_DROUTE_INTERFACE_CONFLICT       TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 15, TR069_ERRNO_CPE_ERR)
#define ERR_DROUTE_INTERFACE                TBS_ERR_CVT(ERR_DROUTE_BEGIN_ADDR + 16, TR069_ERRNO_CPE_ERR)

/* static route */
#define ERR_SROUTE_BEGIN_ADDR               TBS_ERR_LOGIC_BASE_ADDR(MID_SROUTE)

#define ERR_SROUTE_INVALID_INSTANCE         TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 1, TR069_ERRNO_CPE_ERR)
#define ERR_SROUTE_INTERFACE                TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 2, TR069_ERRNO_CPE_ERR)
#define ERR_SROUTE_NO_RESOURSE              TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 3, TR069_ERRNO_NO_RESOURCE)
#define ERR_SROUTE_INVALID_VAL              TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_SROUTE_ENABLE_INVALID           TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)
#define ERR_SROUTE_INVALID_PATH             TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_PARAM)
#define ERR_SROUTE_INVALID_DEFAULT_PARA     TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)
#define ERR_SROUTE_INVALID_ROUTE_PARA       TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 8, TR069_ERRNO_CPE_ERR)
#define ERR_SROUTE_INVALID_PARA             TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 9, TR069_ERRNO_CPE_ERR)
#define ERR_SROUTE_DEL_INSTANCE             TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 10, TR069_ERRNO_CPE_ERR)
#define ERR_SROUTE_INVALID_METRIC           TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 11, TR069_ERRNO_INVALID_VAL)
#define ERR_SROUTE_INVALID_IP               TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 12, TR069_ERRNO_INVALID_VAL)
#define ERR_SROUTE_IP_EMPTY                 TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 13, TR069_ERRNO_INVALID_VAL)
#define ERR_SROUTE_INVALID_MASK             TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 14, TR069_ERRNO_INVALID_VAL)
#define ERR_SROUTE_MASK_EMPTY               TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 15, TR069_ERRNO_INVALID_VAL)
#define ERR_SROUTE_INVALID_GATEWAY          TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 16, TR069_ERRNO_INVALID_VAL)
#define ERR_SROUTE_METRIC_OUT_LIMITED       TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 17, TR069_ERRNO_INVALID_VAL)
#define ERR_SROUTE_INVALID_LOGFILE          TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 18, TR069_ERRNO_CPE_ERR)
#define ERR_SROUTE_DEST_CONFLICT            TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 19, TR069_ERRNO_INVALID_VAL)
#define ERR_SROUTE_ROUTE_NAME               TBS_ERR_CVT(ERR_SROUTE_BEGIN_ADDR + 20, TR069_ERRNO_INVALID_VAL)


/* SNMPC */
#define ERR_SNMPC_BEGIN_ADDR                TBS_ERR_LOGIC_BASE_ADDR(MID_SNMPC)
#define ERR_SNMPC_INVALID_VERSION           TBS_ERR_CVT(ERR_SNMPC_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)

/* MAIL */
#define ERR_MAIL_BEGIN_ADDR                 TBS_ERR_LOGIC_BASE_ADDR(MID_MAIL)
#define ERR_INVALID_EMAIL                   TBS_ERR_CVT(ERR_MAIL_BEGIN_ADDR + 1, TR069_ERRNO_CPE_ERR)
#define ERR_INVALID_HOST                    TBS_ERR_CVT(ERR_MAIL_BEGIN_ADDR + 2, TR069_ERRNO_CPE_ERR)
#define ERR_INVALID_USERNAME                TBS_ERR_CVT(ERR_MAIL_BEGIN_ADDR + 3, TR069_ERRNO_CPE_ERR)
#define ERR_INVALID_PASSWORD                TBS_ERR_CVT(ERR_MAIL_BEGIN_ADDR + 4, TR069_ERRNO_CPE_ERR)

/* Firewall */
#define ERR_FW_BEGIN_ADDR                   TBS_ERR_LOGIC_BASE_ADDR(MID_FIREWALL)
#define ERR_FW_RULES_OVER                   TBS_ERR_CVT(ERR_FW_BEGIN_ADDR + 1, TR069_ERRNO_NO_RESOURCE)
#define ERR_FW_RULE_EXISTS                  TBS_ERR_CVT(ERR_FW_BEGIN_ADDR + 2, TR069_ERRNO_NO_RESOURCE)
#define ERR_FW_SRC_IP_EMPTY                 TBS_ERR_CVT(ERR_FW_BEGIN_ADDR + 3, TR069_ERRNO_NO_RESOURCE)
#define ERR_FW_DEST_IP_EMPTY                TBS_ERR_CVT(ERR_FW_BEGIN_ADDR + 4, TR069_ERRNO_NO_RESOURCE)
#define ERR_FW_RULES_OVERLAP                TBS_ERR_CVT(ERR_FW_BEGIN_ADDR + 5, TR069_ERRNO_NO_RESOURCE)
#define ERR_FW_SERVICE_NAME                 TBS_ERR_CVT(ERR_FW_BEGIN_ADDR + 6, TR069_ERRNO_NO_RESOURCE)

/* IPT */
#define ERR_IPT_BEGIN_ADDR                  TBS_ERR_LOGIC_BASE_ADDR(MID_IPT)

#define ERR_IPT_INVALID_NATTYPE             TBS_ERR_CVT(ERR_IPT_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_IPT_CONFLICT_DMZ                TBS_ERR_CVT(ERR_IPT_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_IPT_INVALID_SVCTYPE             TBS_ERR_CVT(ERR_IPT_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_IPT_CONFLICT_SVCTYPE            TBS_ERR_CVT(ERR_IPT_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)

/* wlan */
#define ERR_WLAN_BEGIN_ADDR                 TBS_ERR_LOGIC_BASE_ADDR(MID_WLAN)

#define ERR_WLAN_NO_RESOURSE                TBS_ERR_CVT(ERR_WLAN_BEGIN_ADDR + 1, TR069_ERRNO_NO_RESOURCE)
#define ERR_WLAN_INVALID_VAL                TBS_ERR_CVT(ERR_WLAN_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_WLAN_INVALID_PATH               TBS_ERR_CVT(ERR_WLAN_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_PARAM)
#define ERR_WLAN_VAL_EMPTY                  TBS_ERR_CVT(ERR_WLAN_BEGIN_ADDR + 4, TR069_ERRNO_NO_RESOURCE)
#define ERR_WLAN_EXCEED_VAP_NUM             TBS_ERR_CVT(ERR_WLAN_BEGIN_ADDR + 5, TR069_ERRNO_NO_RESOURCE)
#define ERR_WLAN_INVALID_INSTANCE           TBS_ERR_CVT(ERR_WLAN_BEGIN_ADDR + 6, TR069_ERRNO_CPE_ERR)
#define ERR_WLAN_INVALID_VAPIDX             TBS_ERR_CVT(ERR_WLAN_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)
#define ERR_WLAN_INVALID_SESSION            TBS_ERR_CVT(ERR_WLAN_BEGIN_ADDR + 8, TR069_ERRNO_REJECT)
#define ERR_WLAN_IN_OOB     				TBS_ERR_CVT(ERR_WLAN_BEGIN_ADDR + 9, TR069_ERRNO_INVALID_VAL)

#define ERR_WLAN_NAME_REPEATED              TBS_ERR_CVT(ERR_WLAN_BEGIN_ADDR + 26, TR069_ERRNO_NO_RESOURCE)
#define ERR_WLAN_INVALID_SSID               TBS_ERR_CVT(ERR_WLAN_BEGIN_ADDR + 27, TR069_ERRNO_INVALID_VAL)
#define ERR_WLAN_SSID_CONFLICT				TBS_ERR_CVT(ERR_WLAN_BEGIN_ADDR + 28, TR069_ERRNO_INVALID_VAL)
#define ERR_WLAN_DEVICENAME_CONFLICT		TBS_ERR_CVT(ERR_WLAN_BEGIN_ADDR + 29, TR069_ERRNO_INVALID_VAL)


/*tr069be*/
#define ERR_TR069BE_BEGIN_ADDR              TBS_ERR_LOGIC_BASE_ADDR(MID_TR069BE)

#define ERR_TR069BE_INVALID_URL             TBS_ERR_CVT(ERR_TR069BE_BEGIN_ADDR+1, TR069_ERRNO_INVALID_VAL)
#define ERROR_TR069_INVALID_CAFILE          TBS_ERR_CVT(ERR_TR069BE_BEGIN_ADDR+2, TR069_ERRNO_INVALID_VAL)

/* PortMapping */
#define ERR_PTMP_BEGIN_ADDR                 TBS_ERR_LOGIC_BASE_ADDR(MID_PORTMAPPING)

#define ERR_PTMP_INVALID_DURATION           TBS_ERR_CVT(ERR_PTMP_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_PTMP_INVALID_PROTOCOL           TBS_ERR_CVT(ERR_PTMP_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_PTMP_INVALID_DESCRIPTION        TBS_ERR_CVT(ERR_PTMP_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_PTMP_CONFLICT_PORTRANGE         TBS_ERR_CVT(ERR_PTMP_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_PTMP_CONFLICT_TUPLE             TBS_ERR_CVT(ERR_PTMP_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)
#define ERR_PTMP_NOTINSAMESUBNET            TBS_ERR_CVT(ERR_PTMP_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_VAL)
#define ERR_PTMP_DUPLICATE_NAME            TBS_ERR_CVT(ERR_PTMP_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)

/* URL FILTER */
#define ERR_URLFILTER_BEGIN_ADDR            TBS_ERR_LOGIC_BASE_ADDR(MID_URLFILTER)

#define ERR_URLFILTER_INVALID_INNER_PARA    TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR+1, TR069_ERRNO_CPE_ERR)
#define ERR_URLFILTER_INVALID_VAL           TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR+2, TR069_ERRNO_INVALID_VAL)
#define ERR_URLFILTER_ENABLE_EMPTY          TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR+3, TR069_ERRNO_INVALID_VAL)
#define ERR_URLFILTER_ENABLE_INVALID        TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR+4, TR069_ERRNO_INVALID_VAL)
#define ERR_URLFILTER_INVALID_CONFIG_FILE   TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR+5, TR069_ERRNO_CPE_ERR)
#define ERR_URLFILTER_MODE_EMPTY            TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR+6, TR069_ERRNO_INVALID_VAL)
#define ERR_URLFILTER_MODE_INVALID          TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR+7, TR069_ERRNO_INVALID_VAL)
#define ERR_URLFILTER_URL_CONFLICT          TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR+8, TR069_ERRNO_NO_RESOURCE)
#define ERR_URLFILTER_URLNUMBER_OVER        TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR+9, TR069_ERRNO_NO_RESOURCE)
#define ERR_URLFILTER_URL_LENGTH_OVER       TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR+10, TR069_ERRNO_INVALID_VAL)
#define ERR_URLFILTER_URL_ERROR             TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR+11, TR069_ERRNO_INVALID_VAL)
#define ERR_URLFILTER_INVALID_FILTERMODE    TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR + 12, TR069_ERRNO_CPE_ERR)
#define ERR_URLFILTER_INVALID_TIME          TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR + 13, TR069_ERRNO_CPE_ERR)
#define ERR_URLFILTER_INVALID_DAY           TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR + 14, TR069_ERRNO_CPE_ERR)
#define ERR_URLFILTER_TIME_CONFLICT         TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR + 15, TR069_ERRNO_CPE_ERR)
#define ERR_URLFILTER_MAC_CONFLICT          TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR + 16, TR069_ERRNO_CPE_ERR)
#define ERR_URLFILTER_SCHEDULE_MODE         TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR + 17, TR069_ERRNO_CPE_ERR)
#define ERR_URLFILTER_SCHEDULE_PATH         TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR + 18, TR069_ERRNO_CPE_ERR)
#define ERR_URLFILTER_TOO_MUCH_KEY          TBS_ERR_CVT(ERR_URLFILTER_BEGIN_ADDR + 19, TR069_ERRNO_CPE_ERR)

/* ACL */
#define ERR_ACL_BEGIN_ADDR                  TBS_ERR_LOGIC_BASE_ADDR(MID_ACL)

#define ERR_ACL_RULES_OVER                  TBS_ERR_CVT(ERR_ACL_BEGIN_ADDR + 1, TR069_ERRNO_NO_RESOURCE)
#define ERR_ACL_RULE_EXISTS                 TBS_ERR_CVT(ERR_ACL_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_ACL_PORT_BE_ZERO                TBS_ERR_CVT(ERR_ACL_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_ACL_PORT_CANOT_ZERO             TBS_ERR_CVT(ERR_ACL_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_ACL_PORT_IN_USE                 TBS_ERR_CVT(ERR_ACL_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)

/* ATM */
#define ERR_ATM_BEGIN_ADDR                  TBS_ERR_LOGIC_BASE_ADDR(MID_ATM)

#define ERR_ATM_PVC                         TBS_ERR_CVT(ERR_ATM_BEGIN_ADDR + 1, TR069_ERRNO_NO_RESOURCE)
#define ERR_ATM_VPI                         TBS_ERR_CVT(ERR_ATM_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_ATM_VCI                         TBS_ERR_CVT(ERR_ATM_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_ATM_UNKNOWN_ENCAP               TBS_ERR_CVT(ERR_ATM_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_ATM_UNKNOWN_LINK_TYPE           TBS_ERR_CVT(ERR_ATM_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)
#define ERR_ATM_UNKNOWN_QOS_TYPE            TBS_ERR_CVT(ERR_ATM_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_VAL)
#define ERR_ATM_PCR                         TBS_ERR_CVT(ERR_ATM_BEGIN_ADDR + 7, TR069_ERRNO_INVALID_VAL)
#define ERR_ATM_MBS                         TBS_ERR_CVT(ERR_ATM_BEGIN_ADDR + 8, TR069_ERRNO_INVALID_VAL)
#define ERR_ATM_SCR                         TBS_ERR_CVT(ERR_ATM_BEGIN_ADDR + 9, TR069_ERRNO_INVALID_VAL)
#define ERR_ATM_MIN_PCR                     TBS_ERR_CVT(ERR_ATM_BEGIN_ADDR + 10, TR069_ERRNO_INVALID_VAL)
#define ERR_ATM_PVC_CONFLICT                TBS_ERR_CVT(ERR_ATM_BEGIN_ADDR + 11, TR069_ERRNO_INVALID_VAL)
#define ERR_ATM_VLAN_ID                     TBS_ERR_CVT(ERR_ATM_BEGIN_ADDR + 12, TR069_ERRNO_INVALID_VAL)
#define ERR_ATM_VLAN_PRIORITY               TBS_ERR_CVT(ERR_ATM_BEGIN_ADDR + 13, TR069_ERRNO_INVALID_VAL)
#define ERR_ATM_VLAN_ID_CONFLICT            TBS_ERR_CVT(ERR_ATM_BEGIN_ADDR + 14, TR069_ERRNO_INVALID_VAL)

/*LOGGER*/
#define ERR_LOGGER_BEGIN_ADDR               TBS_ERR_PROC_BASE_ADDR(MID_LOG)
#define ERR_LOGGER_UPLOAD_FAILED            TBS_ERR_CVT(ERR_LOGGER_BEGIN_ADDR+1, TR069_ERRNO_UPLOAD_FAIL)
#define ERR_LOGGER_INVALID_TFTP_SERVER      TBS_ERR_CVT(ERR_LOGGER_BEGIN_ADDR+2, TR069_ERRNO_INVALID_VAL)
#define ERR_LOGGER_CLEAR_FAILED             TBS_ERR_CVT(ERR_LOGGER_BEGIN_ADDR+3, TR069_ERRNO_CPE_ERR)
#define ERR_LOGGER_EMPTY_TFTP_SERVER        TBS_ERR_CVT(ERR_LOGGER_BEGIN_ADDR+4, TR069_ERRNO_INVALID_VAL)
#define ERR_LOGGER_INVALID_SERVER           TBS_ERR_CVT(ERR_LOGGER_BEGIN_ADDR+5, TR069_ERRNO_INVALID_VAL)


/* PC */
#define ERR_PC_BEGIN_ADDR                   TBS_ERR_PROC_BASE_ADDR(MID_PC)

#define ERR_PC_PCB_NOT_FOUND                TBS_ERR_CVT(ERR_PC_BEGIN_ADDR + 1, TR069_ERRNO_CPE_ERR)
#define ERR_PC_PCB_FULL                     TBS_ERR_CVT(ERR_PC_BEGIN_ADDR + 2, TR069_ERRNO_CPE_ERR)
#define ERR_PC_NO_EXECV                     TBS_ERR_CVT(ERR_PC_BEGIN_ADDR + 3, TR069_ERRNO_CPE_ERR)
#define ERR_PC_FORK_FAIL                    TBS_ERR_CVT(ERR_PC_BEGIN_ADDR + 4, TR069_ERRNO_CPE_ERR)
#define ERR_PC_REGCOMP                      TBS_ERR_CVT(ERR_PC_BEGIN_ADDR + 5, TR069_ERRNO_CPE_ERR)
#define ERR_PC_COMID                        TBS_ERR_CVT(ERR_PC_BEGIN_ADDR + 6, TR069_ERRNO_CPE_ERR)

/* UPNP */
#define ERR_UPNP_BEGIN_ADDR                 TBS_ERR_LOGIC_BASE_ADDR(MID_UPNP)

#define ERR_UPNP_SRCIP_EXIST                TBS_ERR_CVT(ERR_UPNP_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)

/* DDNS */
#define ERR_DDNS_BEGIN_ADDR                 TBS_ERR_LOGIC_BASE_ADDR(MID_DDNS)

#define ERR_DDNS_INVALID_DDNSPROVIDER       TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 1, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_INVALID_HOSTNAME           TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 2, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_HOSTNAME_LENGTH_OVER       TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 3, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_INVALID_WAN_CONN_SID       TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 4, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_INVALID_USERNAME           TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 5, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_USERNAME_LENGTH_OVER       TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 6, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_INVALID_PASSWORD           TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 7, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_PASSWORD_LENGTH_OVER       TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 8, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_INVALID_EMAIL              TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 9, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_EMAIL_LENGTH_OVER          TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 10, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_INVALID_KEY                TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 11, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_KEY_LENGTH_OVER            TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 12, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_HOSTNAME_CONFLICT          TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 13, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_INVALID_DDNS_HOST          TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 14, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_DDNS_HOST_LENGTH_OVER      TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 15, TR069_ERRNO_CPE_ERR)
#define ERR_DDNS_HOSTNAME_ILLEGAL           TBS_ERR_CVT(ERR_DDNS_BEGIN_ADDR + 16, TR069_ERRNO_CPE_ERR)

/* SUPP */
#define ERR_SUPP_BEGIN_ADDR                 TBS_ERR_LOGIC_BASE_ADDR(MID_SUPP)

#define ERR_SUPP_USERNAME_OR_PASSWORD_BE_EMPTY  TBS_ERR_CVT(ERR_SUPP_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)

/* MACFILTER */
#define ERR_MACFILTER_BEGIN_ADDR            TBS_ERR_LOGIC_BASE_ADDR(MID_MACFILTER)
#define ERR_MACFILTER_INVALID_FILTERMODE    TBS_ERR_CVT(ERR_MACFILTER_BEGIN_ADDR + 1, TR069_ERRNO_CPE_ERR)
#define ERR_MACFILTER_INVALID_TIME          TBS_ERR_CVT(ERR_MACFILTER_BEGIN_ADDR + 2, TR069_ERRNO_CPE_ERR)
#define ERR_MACFILTER_INVALID_DAY           TBS_ERR_CVT(ERR_MACFILTER_BEGIN_ADDR + 3, TR069_ERRNO_CPE_ERR)
#define ERR_MACFILTER_TIME_CONFLICT         TBS_ERR_CVT(ERR_MACFILTER_BEGIN_ADDR + 4, TR069_ERRNO_CPE_ERR)
#define ERR_MACFILTER_MAC_CONFLICT          TBS_ERR_CVT(ERR_MACFILTER_BEGIN_ADDR + 5, TR069_ERRNO_CPE_ERR)
#define ERR_MACFILTER_INVALID_INNER_PARA    TBS_ERR_CVT(ERR_MACFILTER_BEGIN_ADDR + 6, TR069_ERRNO_CPE_ERR)
#define ERR_MACFILTER_INVALID_USERNAME      TBS_ERR_CVT(ERR_MACFILTER_BEGIN_ADDR + 7, TR069_ERRNO_CPE_ERR)
#define ERR_MACFILTER_SCHEDULE_MODE         TBS_ERR_CVT(ERR_MACFILTER_BEGIN_ADDR + 8, TR069_ERRNO_CPE_ERR)
#define ERR_MACFILTER_SCHEDULE_PATH         TBS_ERR_CVT(ERR_MACFILTER_BEGIN_ADDR + 9, TR069_ERRNO_CPE_ERR)

/* TRACERT*/
#define ERR_TRACERT_BEGIN_ADDR              TBS_ERR_LOGIC_BASE_ADDR(MID_TRACERT)

#define ERR_TRACERT_NOSTART                 TBS_ERR_CVT(ERR_TRACERT_BEGIN_ADDR + 1, TR069_ERRNO_CPE_ERR)
#define ERR_TRACERT_BUSY                    TBS_ERR_CVT(ERR_TRACERT_BEGIN_ADDR + 2, TR069_ERRNO_CPE_ERR)


/* Schedule */
#define ERR_SCHEDULE_BEGIN_ADDR             TBS_ERR_LOGIC_BASE_ADDR(MID_SCHED)

#define ERR_SCHEDULE_INVALID_NAME           TBS_ERR_CVT(ERR_SCHEDULE_BEGIN_ADDR+1, TR069_ERRNO_CPE_ERR)
#define ERR_SCHEDULE_INVALID_STARTTIME      TBS_ERR_CVT(ERR_SCHEDULE_BEGIN_ADDR+2, TR069_ERRNO_INVALID_VAL)
#define ERR_SCHEDULE_INVALID_ENDTIME        TBS_ERR_CVT(ERR_SCHEDULE_BEGIN_ADDR+3, TR069_ERRNO_INVALID_VAL)
#define ERR_SCHEDULE_INVALID_SPICIFIEDDAY   TBS_ERR_CVT(ERR_SCHEDULE_BEGIN_ADDR+4, TR069_ERRNO_INVALID_VAL)
#define ERR_SCHEDULE_INVALID_ENABLEALLDAYS  TBS_ERR_CVT(ERR_SCHEDULE_BEGIN_ADDR+5, TR069_ERRNO_INVALID_VAL)
#define ERR_SCHEDULE_INVALID_SCHEDULEDAYS   TBS_ERR_CVT(ERR_SCHEDULE_BEGIN_ADDR+6, TR069_ERRNO_INVALID_VAL)
#define ERR_SCHEDULE_INVALID_ENABLEALLTIME  TBS_ERR_CVT(ERR_SCHEDULE_BEGIN_ADDR+7, TR069_ERRNO_INVALID_VAL)
#define ERR_SCHEDULE_TIME_CONFLICT          TBS_ERR_CVT(ERR_SCHEDULE_BEGIN_ADDR+8, TR069_ERRNO_INVALID_VAL)
#define ERR_SCHEDULE_NAME_CONFLICT          TBS_ERR_CVT(ERR_SCHEDULE_BEGIN_ADDR+9, TR069_ERRNO_INVALID_VAL)
#define ERR_SCHEDULE_RULE_USED              TBS_ERR_CVT(ERR_SCHEDULE_BEGIN_ADDR+10, TR069_ERRNO_INVALID_VAL)
#define ERR_SCHEDULE_INVALID_TIME_RANGE     TBS_ERR_CVT(ERR_SCHEDULE_BEGIN_ADDR+11, TR069_ERRNO_INVALID_VAL)

/* Diagnostics */
#define ERR_DG_BEGIN_ADDR                   TBS_ERR_LOGIC_BASE_ADDR(MID_DIAG)
#define ERR_DG_INVALID_STATE                TBS_ERR_CVT(ERR_DG_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_DG_INVALID_INTERFACE            TBS_ERR_CVT(ERR_DG_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_DG_PVC_TOO_MUCH                 TBS_ERR_CVT(ERR_DG_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)


/* Default Gateway */
#define ERR_DFGW_BEGIN_ADDR                 TBS_ERR_LOGIC_BASE_ADDR(MID_DEFAULTGW)
#define ERR_DEGW_EMPTY_IP                   TBS_ERR_CVT(ERR_DFGW_BEGIN_ADDR+1,TR069_ERRNO_INVALID_VAL)
#define ERR_DEGW_INVALID_IP                 TBS_ERR_CVT(ERR_DFGW_BEGIN_ADDR+2,TR069_ERRNO_INVALID_VAL)
#define ERR_DEGW_EMPTY_USERINIF             TBS_ERR_CVT(ERR_DFGW_BEGIN_ADDR+3,TR069_ERRNO_INVALID_VAL)
#define ERR_DEGW_INVALID_USERINIF           TBS_ERR_CVT(ERR_DFGW_BEGIN_ADDR+4,TR069_ERRNO_INVALID_VAL)
#define ERR_DEGW_EMPTY_SELECT               TBS_ERR_CVT(ERR_DFGW_BEGIN_ADDR+5,TR069_ERRNO_INVALID_VAL)
#define ERR_DEGW_INVALID_SELECT             TBS_ERR_CVT(ERR_DFGW_BEGIN_ADDR+6,TR069_ERRNO_INVALID_VAL)

/* IP ACL */
#define ERR_IP_ACL_BEGIN_ADDR               TBS_ERR_LOGIC_BASE_ADDR(MID_IP_ACL)
#define ERR_IP_ACL_EMPTY_IP                 TBS_ERR_CVT(ERR_IP_ACL_BEGIN_ADDR+1,TR069_ERRNO_INVALID_VAL)
#define ERR_IP_ACL_INVALID_IP               TBS_ERR_CVT(ERR_IP_ACL_BEGIN_ADDR+2,TR069_ERRNO_INVALID_VAL)
#define ERR_IP_ACL_IP_ZERO                  TBS_ERR_CVT(ERR_IP_ACL_BEGIN_ADDR+3,TR069_ERRNO_INVALID_VAL)

/* Traffic Meter -- By zym on september 27 2010 */
#define ERR_TRFFC_MTR_BEGIN_ADDR            TBS_ERR_LOGIC_BASE_ADDR( MID_TRFFCMTR )

/* Upgrader */
#define ERR_UPG_BEGIN_ADDR					TBS_ERR_LOGIC_BASE_ADDR(MID_UPG)
#define ERR_UPG_GENERAL_ERROR				TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+1 , TR069_ERRNO_CPE_ERR)
#define ERR_INIT_MODULE_ERROR          		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+2 , TR069_ERRNO_CPE_ERR)
#define ERR_DESTROY_MODULE_ERROR       		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+3 , TR069_ERRNO_CPE_ERR)
#define ERR_REQUEST_METHOD_ERROR       		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+4 , TR069_ERRNO_CPE_ERR)
#define ERR_CONTENT_TYPE_ERROR         		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+5 , TR069_ERRNO_CPE_ERR)
#define ERR_CONTENT_LENGTH_ERROR       		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+6 , TR069_ERRNO_CPE_ERR)
#define ERR_INVALID_VARIABLE_ERROR     		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+7 , TR069_ERRNO_CPE_ERR)
#define ERR_NO_VARIABLE_ERROR          		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+8 , TR069_ERRNO_CPE_ERR)
#define ERR_MIN_CONTENT_LENGTH_ERROR   		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+9 , TR069_ERRNO_CPE_ERR)
#define ERR_MAX_CONTENT_LENGTH_ERROR   		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+10, TR069_ERRNO_CPE_ERR)
#define ERR_FOPEN_LOG_ERROR            		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+11, TR069_ERRNO_CPE_ERR)
#define ERR_FOPEN_FW_ERROR             		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+12, TR069_ERRNO_CPE_ERR)
#define ERR_OPERATE_FW_ERROR           		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+13, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_TYPE_ERROR            		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+14, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_SIZE_ERROR            		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+15, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_PRODUCT_ERROR         		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+16, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_CRC_ERROR             		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+17, TR069_ERRNO_CPE_ERR)
#define ERR_FILE_UPLOAD_ERROR          		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+18, TR069_ERRNO_CPE_ERR)
#define ERR_AUTH_ERROR                 		TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+19, TR069_ERRNO_CPE_ERR)
#define ERR_UPG_TIMEOUT            			TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+20, TR069_ERRNO_CPE_ERR)

#ifdef TBS_SSAP_SUPPORT_IPV6
/*DHCP6S*/
#define ERR_DHCP6S_BEGIN_ADDR               TBS_ERR_LOGIC_BASE_ADDR(MID_DHCP6S)
#define ERR_DHCP6S_LIFE_TIME_OUT_RANGE      TBS_ERR_CVT(ERR_DHCP6S_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_DHCP6S_START_ADDR_BIGGER        TBS_ERR_CVT(ERR_DHCP6S_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_DHCP6S_INVALID_LIFE_TIME        TBS_ERR_CVT(ERR_DHCP6S_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_DHCP6S_VALID_LIFE_TIME_SMALLER  TBS_ERR_CVT(ERR_DHCP6S_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)

/*RADVD*/
#define ERR_RADVD_BEGIN_ADDR  				TBS_ERR_LOGIC_BASE_ADDR(MID_RAD)
#define ERR_HEX_FORMAT_WRONG     			TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 1, TR069_ERRNO_CPE_ERR)
#define ERR_GLOBALID_OUT_OF_RANGE     		TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 2, TR069_ERRNO_CPE_ERR)
#define ERR_CONFIG_TYPE_INVALID_VALUE     	TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 3, TR069_ERRNO_CPE_ERR)
#define ERR_ROUTE_LIFETIME_OUT_OF_RANGE     TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 4, TR069_ERRNO_CPE_ERR)
#define ERR_ROUTE_PREFERENCE_INVALID_VALUE  TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 5, TR069_ERRNO_CPE_ERR)
#define ERR_SUBNET_ID_OUT_OF_RANGE     		TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 6, TR069_ERRNO_CPE_ERR)
#define ERR_INVALID_PREFIX_LEN     			TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 7, TR069_ERRNO_CPE_ERR)
#define ERR_INVALID_PREFIX     				TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 8, TR069_ERRNO_CPE_ERR)
#define ERR_NOT_NEED_CHANGE 				TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 9, TR069_ERRNO_CPE_ERR)
#define ERR_FLAG_CONF_TYPE_INVALID 			TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 10, TR069_ERRNO_CPE_ERR)
#define ERR_INVALID_MO_FLAG 				TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 11, TR069_ERRNO_CPE_ERR)
#define ERR_INVALID_RA_MAX_INTERVAL 		TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 12, TR069_ERRNO_CPE_ERR)
#define ERR_INVALID_RA_MIN_INTERVAL 		TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 13, TR069_ERRNO_CPE_ERR)
#define ERR_INVALID_RA_MIN_INTERVAL_VALUE 	TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 14, TR069_ERRNO_CPE_ERR)
#define ERR_INVALID_RA_MIN_INTERVAL_MAX 	TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 15, TR069_ERRNO_CPE_ERR)
#define ERR_RADVD_INVALID_O_FLAGS 			TBS_ERR_CVT(ERR_RADVD_BEGIN_ADDR + 16, TR069_ERRNO_CPE_ERR)

/*V6CONN*/
#define ERR_V6CONN_BEGIN_ADDR               TBS_ERR_LOGIC_BASE_ADDR(MID_V6CONN)
#define ERR_V6CONN_INVALID_STATIC_ADDR      TBS_ERR_CVT(ERR_V6CONN_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_V6CONN_INVALID_DNS_ADDR         TBS_ERR_CVT(ERR_V6CONN_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_V6CONN_INVALID_ROUTER_ADDR      TBS_ERR_CVT(ERR_V6CONN_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#define ERR_V6CONN_INVALID_ADDR_CONF_TYPE   TBS_ERR_CVT(ERR_V6CONN_BEGIN_ADDR + 4, TR069_ERRNO_INVALID_VAL)
#define ERR_V6CONN_INVALID_ROUTER_CONF_TYPE TBS_ERR_CVT(ERR_V6CONN_BEGIN_ADDR + 5, TR069_ERRNO_INVALID_VAL)
#define ERR_V6CONN_INVALID_DUID_CONF_TYPE   TBS_ERR_CVT(ERR_V6CONN_BEGIN_ADDR + 6, TR069_ERRNO_INVALID_VAL)


/* IPV6 static routing */
#define ERR_V6SROUTE_BEGIN_ADDR  			TBS_ERR_LOGIC_BASE_ADDR(MID_V6SROUTE)

#define ERR_V6SROUTE_ENABLE_INVALID         TBS_ERR_CVT(ERR_V6SROUTE_BEGIN_ADDR + 1, TR069_ERRNO_INVALID_VAL)
#define ERR_V6SROUTE_BAD_PREFIX             TBS_ERR_CVT(ERR_V6SROUTE_BEGIN_ADDR + 2, TR069_ERRNO_INVALID_VAL)
#define ERR_V6SROUTE_BAD_METRIC             TBS_ERR_CVT(ERR_V6SROUTE_BEGIN_ADDR + 3, TR069_ERRNO_INVALID_VAL)
#endif

/*WEB*/
#define ERR_WEB_BEGIN_ADDR			        TBS_ERR_LOGIC_BASE_ADDR(MID_WEB)
#define ERR_WEB_VAR_VALUE_ERROR			    TBS_ERR_CVT(ERR_UPG_BEGIN_ADDR+23, TR069_ERRNO_INVALID_VAL)



typedef struct
{
    int iErrNo;
    char *pcEnglish;
    char *pcChinese;
} ST_TBS_ERR_TABLE;


/* жϷֵǷ*/
#define RET_SUCCEED(ret) (ret == TBS_SUCCESS)
#define RET_FAILED(ret)  (ret != TBS_SUCCESS)

const char *tbsstrerr (int errnum);
int tbserr2tr069(int tbserrno);

const char* tbsGetMsgTypeName(unsigned short usMsgType);
const char* tbsGetMIDName(unsigned short usMID);


#endif /*__TBS_TBSERROR_H__*/
