﻿/*+-----------------------------------------+
  | FileName : Javascript Common Web Check Function |
  | Edtion   : To Trunk R2                  |
  | Author   : TBS Software                 |
  +-----------------------------------------+*/
  
 /*检测是否全部是数字*/
function validateKey(str)
{
   for (var i=0; i<str.length; i++) {
    if ( (str.charAt(i) >= '0' && str.charAt(i) <= '9') || (str.charAt(i) == '.' ) )
			continue;
	return 0;
  }
  return 1;
}

function _isNumeric(str) {
	var i;
	for(i = 0; i<str.length; i++) {
		var c = str.substring(i, i+1);
		if("0" <= c && c <= "9") {
			continue;
		}
		return false;
	}
	return true;
}

function getDigit(str, num)
{
  i=1;
  if ( num != 1 ) {
  	while (i!=num && str.length!=0) {
		if ( str.charAt(0) == '.' ) {
			i++;
		}
		str = str.substring(1);
  	}
  	if ( i!=num )
  		return -1;
  }
  for (i=0; i<str.length; i++) {
  	if ( str.charAt(i) == '.' ) {
		str = str.substring(0, i);
		break;
	}
  }
  if ( str.length == 0)
  	return -1;
  var d = parseInt(str, 10);
  return d;
}

/*判断地址是否在范围内*/
function checkDigitRange(str, num, min, max)
{
  var d = getDigit(str,num);
  if ( d > max || d < min )
      	return false;
  return true;
}


function checkIpAddr(_value)
{
	if (_value == "...") {
		//alertError('CheckIpValue1',1);
		return false;
	}
	
	if ( validateKey(_value) == 0) {
		//alertError('CheckIpValue2',1);
		return false;
	}
	if ( !checkDigitRange(_value,1,1,223) ) {
		//alertError('CheckIpValue3',1);
		return false;
	}

	if ( getDigit(_value,1) ==127) {
		//alertError('CheckIpValue4',1);
		return false;
	}

	if ( !checkDigitRange(_value,2,0,255) ) {
		//alertError('CheckIpValue5',1);
		return false;
	}
	if ( !checkDigitRange(_value,3,0,255) ) {
		//alertError('CheckIpValue6',1);
		return false;
	}
	if ( !checkDigitRange(_value,4,1,254) ) {
		//alertError('CheckIpValue7',1);
		return false;
	}

	return true;
}


/*检测Mask地址是否合法*/
function checkMask(str, num)
{
  var d = getDigit(str,num);
  if( !(d==0 || d==128 || d==192 || d==224 || d==240 || d==248 || d==252 || d==254 || d==255 ))
  	return false;
  return true;
}

function isValidMask2(str)
{
	
	var _value = str.split('.');
	var _numValue=0;
	var _flag=0;
	
	for(var _i=0; _i<_value.length; _i++)
	{
		var _numValue = parseInt(_value[_i],10);

		for(var _j=0; _j<8; _j++)
		{
			if(parseInt(_numValue&128,10)==128)
			{
				if(_flag==1)
				{
					return false;
				}
			}
			else if(parseInt(_numValue&128,10)!=128)
			{
				_flag=1;
			}
			
			_numValue = _numValue << 1;
			
		}

	}

	return true;

}


/*判断子网掩码的合法性*/
function isValidMask(_value)
{
	
	if (_value=="...") 
	{
		//alertError('STR_routesSubmaskWrong',1);
		return false;
	 }


	if (_value == "255.255.255.255")
	{
		//alertError('STR_routesSubmaskWrong',1);
		return false;
	
	  }
	  
	if (_value == "0.0.0.0")
	{
		//alertError('STR_routesSubmaskWrong',1);
		return false;
	
	 }

  	if ( validateKey(_value) == 0 ) 
	{

      	//alertError('STR_routesSubmaskWrong',1);
		return false;
	 }
	 
	  if ( !checkMask(_value,1)) 
	  {
		//alertError('STR_routesSubmaskWrong',1);
		return false;
	  }

	  if ( !checkMask(_value,2)) {
		 //alertError('STR_routesSubmaskWrong',1);
		return false;
	  }
	  
	  if ( !checkMask(_value,3)) {
		//alertError('STR_routesSubmaskWrong',1);
		return false;
	  }
	  
	  if ( !checkMask(_value,4)) {
		//alertError('STR_routesSubmaskWrong',1);
		return false;
	  }
	
	  if (! ( (getDigit(_value,1) >= getDigit(_value,2))
		&&  (getDigit(_value,2) >= getDigit(_value,3))
		&& (getDigit(_value,3) >= getDigit(_value,4)) ) )
	  {
		//alertError('STR_routesSubmaskWrong',1);
		return false;
	  }
	  
	   if (!isValidMask2(_value)) {
		//alertError('STR_routesSubmaskWrong',1);
		return false;
	  }

	return true;
}



/*判断网关地址是否合法*/
function checkGatewayAddr(_value)
{

	if (_value == "...") {
		//alertError('STR_routesGatewayWrong',1);
		return false;
	}

	   if ( validateKey(_value) == 0) {
      //alertError('STR_routesGatewayWrong',1);
      return false;
   }
   if ( !checkDigitRange(_value,1,1,223) ) {
    //alertError('STR_routesGatewayWrong',1);
      return false;
   }
   if ( getDigit(_value,1) ==127)
   	{
	  //alertError('STR_routesGatewayWrong',1);
      return false;

   }

   if ( !checkDigitRange(_value,2,0,255) ) {
      //alertError('STR_routesGatewayWrong',1);
      return false;
   }
   
   if ( !checkDigitRange(_value,3,0,255) ) {
      //alertError('STR_routesGatewayWrong',1);
      return false;
   }
   
   if ( !checkDigitRange(_value,4,1,254) ) {
     //alertError('STR_routesGatewayWrong',1);
      return false;
   }
	return true;
}








function isSameSubNet(lan1Ip, lan1Mask, lan2Ip, lan2Mask)
{

   var count = 0;

   lan1a = lan1Ip.split('.');
   lan1m = lan1Mask.split('.');
   lan2a = lan2Ip.split('.');
   lan2m = lan2Mask.split('.');

   for (i = 0; i < 4; i++) {
      l1a_n = parseInt(lan1a[i]);
      l1m_n = parseInt(lan1m[i]);
      l2a_n = parseInt(lan2a[i]);
      l2m_n = parseInt(lan2m[i]);
      if ((l1a_n & l1m_n) == (l2a_n & l2m_n))
         count++;
   }
   if (count == 4)
      return true;
   else
      return false;
}




function hideChForWep(_tap,_num,_Bool)
{
	 var _tmpFlag;

	 for(var _i=0; _i < _num; _i++)
	 {
		 _tmpFlag=_tap+(_i+1);
		 _tmpFlag = document.getElementById(_tmpFlag);
		 _tmpFlag.style.display=_Bool;
	 }
}



//for Netgear
function isHex(str) {
    var i;
    for(i = 0; i<str.length; i++) {
        var c = str.substring(i, i+1);
        if(("0" <= c && c <= "9") || ("a" <= c && c <= "f") || ("A" <= c && c <= "F")) {
            continue;
        }
        return false;
    }
    return true;
}






/* Check Numeric*/
function isNumeric(str, max) {
    if(str.value.length == 0 || str.value == null || str.value == "") {
        if (str.focus)
            str.focus();
        return true;
    }
    
    var i = parseInt(str.value,10);
    if(i>max) {
        if (str.focus)
            str.focus();
        return true;
    }
    for(i=0; i<str.value.length; i++) {
        var c = str.value.substring(i, i+1);
        if("0" <= c && c <= "9") {
            continue;
        }
        if (str.focus)
            str.focus();
        return true;
    }
    return false;
}




function checkipaddr(ipaddr)
{
	var form = document.forms[0];
	var ipArray = ipaddr.split(".");
	var ipstr = ipArray[0]+ipArray[1]+ipArray[2]+ipArray[3];
	var i = 0;

	if((ipArray[0]=="")||(ipArray[0]<0)||(ipArray[0]>255)||(ipArray[1]=="")||(ipArray[1]<0)||(ipArray[1]>255)
			||(ipArray[2]=="")||(ipArray[2]<0)||(ipArray[2]>255)||(ipArray[3]=="")||(ipArray[3]<0)||(ipArray[3]>255))
	{
		return false;
	}
	for(i=0;i<ipstr.length;i++)
	{
		if((ipstr.charAt(i)!='0')&&(ipstr.charAt(i)!='1')&&(ipstr.charAt(i)!='2')
				&&(ipstr.charAt(i)!='3')&&(ipstr.charAt(i)!='4')&&(ipstr.charAt(i)!='5')
				&&(ipstr.charAt(i)!='6')&&(ipstr.charAt(i)!='7')&&(ipstr.charAt(i)!='8')
				&&(ipstr.charAt(i)!='9'))
		{
			return false;
		}
	}
	if( ipArray[0] > 223 || ipArray[0] == 0 )
		return false;
	if (ipaddr == "0.0.0.0" || ipaddr == "255.255.255.255")
	{
		return false;
	}

	var each=ipaddr.split(".");
	if (each[0] == "127")
	{
		return false;
	}
	if (!ipArray || ipArray.length != 4)
	{
		return false;
	}
	else
	{
		for (i = 0; i < 4; i++)
		{
			thisSegment = ipArray[i];
			if (thisSegment != "")
			{
				if(i==3){
					if (!((ipArray[3] > 0) && (ipArray[3] < 255)))
					{
						return false;
					}	
				}
				else if (!(thisSegment >=0 && thisSegment <= 255))
				{
					return false;
				}
			} 
			else
			{
				return false;
			}
		}

	}
	return true;
}





