#!/bin/sh

set -x

MODEL=EX6110

kwcheck_prepare() {
    if [ ! -e .kwlp ] || [ ! -e .kwps ]; then
        kwcheck create
        kwcheck set license.host=10.28.101.180 license.port=27000;
    fi
    ./kwcheck/kwinject.sh ./kwcheck/modules_file.txt ./ && kwcheck run -b kwinject.out && kwcheck list -F detailed --report $MODEL-klocwork-report.txt && kwcheck list -F json --report $MODEL-klocwork-report.json

}

kwcheck_run() {
    kwcheck run -b kwinject.out && kwcheck list -F detailed --report $MODEL-klocwork-report.txt && kwcheck list -F json --report $MODEL-klocwork-report.json
}

kwcheck_prepare
kwcheck_run