#!/bin/sh
insmod crypto_k

if [ "$1" == "1" -o "$1" == "3" ]; then
ipsec_add_main_in_conf.sh CONN1 psk 10.10.20.253 "10.10.20.253" "10.10.20.253" single 10.10.20.254 "10.10.20.254" "10.10.20.254" yes 123456789 transport
fi

if [ "$1" == "2" ]; then
ipsec_add_main_in_conf.sh CONN1 psk 10.10.20.253 "10.10.20.253" "10.10.20.253" single 10.10.20.254 "10.10.20.254" "10.10.20.254" no 123456789 transport
fi

if [ "$1" == "0" ]; then
ipsec_add_main_in_conf.sh CONN1 psk @LEFT "10.10.20.253" "10.10.40.0/24" subnet @RIGHT "10.10.20.254" "10.10.10.0/24" yes 123456789 tunnel
route del -net 10.10.10.0 netmask 255.255.255.0
ifconfig br0 10.10.40.254 netmask 255.255.255.0
route add default gw 10.10.20.254
killall -q -USR1 udhcpd
echo "" > /var/udhcpd.leases
dhcp=`nvram_get 2860 dhcpEnabled`
if [ "$dhcp" = "1" ]; then
	#start=`nvram_get 2860 dhcpStart`
	#end=`nvram_get 2860 dhcpEnd`
	start="10.10.40.100"
	end="10.10.40.200"
	lan_if="br0"
	mask=`nvram_get 2860 dhcpMask`
	pd=`nvram_get 2860 dhcpPriDns`
	sd=`nvram_get 2860 dhcpSecDns`
	gw="10.10.40.254"
	#gw='nvram_get 2860 dhcpGateway'
	lease=`nvram_get 2860 dhcpLease`
	static1=`nvram_get 2860 dhcpStatic1 | sed -e 's/;/ /'`
	static2=`nvram_get 2860 dhcpStatic2 | sed -e 's/;/ /'`
	static3=`nvram_get 2860 dhcpStatic3 | sed -e 's/;/ /'`
	config-udhcpd.sh -s $start
	config-udhcpd.sh -e $end
	config-udhcpd.sh -i $lan_if
	config-udhcpd.sh -m $mask
	config-udhcpd.sh -g $gw
	if [ "$pd" != "" -o "$sd" != "" ]; then
		config-udhcpd.sh -d $pd $sd
	fi
	if [ "$lease" != "" ]; then
		config-udhcpd.sh -t $lease
	fi
	config-udhcpd.sh -r 1
fi
fi
ipsec_add_ikekey_in_conf.sh psk aes128 sha1 86400 modp1024 86400 no

#if [ "$1" == "0" ]; then
#iptables -I FORWARD -s 10.10.40.0/24 -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss 1452
#iptables -I FORWARD -d 10.10.10.0/24 -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss 1452
#iptables -I FORWARD -s 10.10.40.0/24 -p tcp --tcp-flags SYN,RST SYN  -j TCPMSS --clamp-mss-to-pmtu
#iptables -I FORWARD -d 10.10.10.0/24 -p tcp --tcp-flags SYN,RST SYN  -j TCPMSS --clamp-mss-to-pmtu
#fi

if [ "$1" == "3" ]; then
iptables -I FORWARD -s 10.10.10.0/24 -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss 1356
iptables -I FORWARD -d 10.10.10.0/24 -p tcp --tcp-flags SYN,RST SYN -j TCPMSS --set-mss 1356
iptables -I FORWARD -s 10.10.10.0/24 -p tcp --tcp-flags SYN,RST SYN  -j TCPMSS --clamp-mss-to-pmtu
iptables -I FORWARD -d 10.10.10.0/24 -p tcp --tcp-flags SYN,RST SYN  -j TCPMSS --clamp-mss-to-pmtu
fi

ipsec_connect.sh ike CONN1&
sleep 3
ipsec auto --up CONN1&
