/* $Id: //WIFI_SOC/MP/SDK_4_2_0_0/RT288x_SDK/source/user/miniupnpd-1.6/upnpdescstrings.h#1 $ */
/* miniupnp project
 * http://miniupnp.free.fr/ or http://miniupnp.tuxfamily.org/
 * (c) 2006-2012 Thomas Bernard
 * This software is subject to the coditions detailed in
 * the LICENCE file provided within the distribution */
#ifndef __UPNPDESCSTRINGS_H__
#define __UPNPDESCSTRINGS_H__

#include "config.h"

/* strings used in the root device xml description */
#ifdef ACOS_PATCH
#include "ambitCfg.h"

#define ROOTDEV_MANUFACTURER		UPnP_MANUFACTURER
#define ROOTDEV_MANUFACTURERURL		UPnP_MANUFACTURER_URL
#define ROOTDEV_MODELNAME			AMBIT_PRODUCT_NAME
#define ROOTDEV_MODELDESCRIPTION	UPnP_MODEL_DESCRIPTION
#define ROOTDEV_MODELURL			UPnP_MODEL_URL

#define WANDEV_FRIENDLYNAME			"WANDevice"
#define WANDEV_MANUFACTURER			ROOTDEV_MANUFACTURER
#define WANDEV_MANUFACTURERURL		ROOTDEV_MANUFACTURERURL
#define WANDEV_MODELNAME			ROOTDEV_MODELNAME
#define WANDEV_MODELDESCRIPTION		ROOTDEV_MODELDESCRIPTION
#define WANDEV_MODELNUMBER			ROOTDEV_MODELNAME
#define WANDEV_MODELURL				ROOTDEV_MODELURL
#define WANDEV_UPC					"MINIUPNPD"

#define WANCDEV_FRIENDLYNAME		"WANConnectionDevice"
#define WANCDEV_MANUFACTURER		WANDEV_MANUFACTURER
#define WANCDEV_MANUFACTURERURL		WANDEV_MANUFACTURERURL
#define WANCDEV_MODELNAME			WANDEV_MODELNAME
#define WANCDEV_MODELDESCRIPTION	WANDEV_MODELDESCRIPTION
#define WANCDEV_MODELNUMBER			WANDEV_MODELNUMBER
#define WANCDEV_MODELURL			WANDEV_MODELURL
#define WANCDEV_UPC					"MINIUPNPD"

#ifdef ENABLE_WSC_SERVICE
#define WLANDEV_FRIENDLYNAME		WPS_FRIENDLY_NAME
#define WLANDEV_MANUFACTURER		WPS_MANUFACTURER
#define WLANDEV_MANUFACTURERURL		WPS_MANUFACTURER_URL
#define WLANDEV_MODELNAME			WPS_MODEL_NAME
#define WLANDEV_MODELDESCRIPTION	WPS_MODEL_DESCRIPTION
#define WLANDEV_MODELNUMBER			WPS_MODEL_NUMBER
#define WLANDEV_MODELURL			WPS_MODEL_URL
#endif /* ENABLE_WSC_SERVICE */
#else
/*#define ROOTDEV_FRIENDLYNAME		OS_NAME " router"*/
#define ROOTDEV_MANUFACTURER		OS_NAME
#define ROOTDEV_MANUFACTURERURL		OS_URL
#define ROOTDEV_MODELNAME			OS_NAME " router"
#define ROOTDEV_MODELDESCRIPTION	OS_NAME " router"
#define ROOTDEV_MODELURL			OS_URL

#define WANDEV_FRIENDLYNAME			"WANDevice"
#define WANDEV_MANUFACTURER			"MiniUPnP"
#define WANDEV_MANUFACTURERURL		"http://miniupnp.free.fr/"
#define WANDEV_MODELNAME			"WAN Device"
#define WANDEV_MODELDESCRIPTION		"WAN Device"
#define WANDEV_MODELNUMBER			UPNP_VERSION
#define WANDEV_MODELURL				"http://miniupnp.free.fr/"
#define WANDEV_UPC					"MINIUPNPD"

#define WANCDEV_FRIENDLYNAME		"WANConnectionDevice"
#define WANCDEV_MANUFACTURER		WANDEV_MANUFACTURER
#define WANCDEV_MANUFACTURERURL		WANDEV_MANUFACTURERURL
#define WANCDEV_MODELNAME			"MiniUPnPd"
#define WANCDEV_MODELDESCRIPTION	"MiniUPnP daemon"
#define WANCDEV_MODELNUMBER			UPNP_VERSION
#define WANCDEV_MODELURL			"http://miniupnp.free.fr/"
#define WANCDEV_UPC					"MINIUPNPD"

#ifdef ENABLE_WSC_SERVICE
#define WLANDEV_FRIENDLYNAME		"RalinkAPS"
#define WLANDEV_MANUFACTURER		"Ralink Technology, Corp."
#define WLANDEV_MANUFACTURERURL		"http://www.ralinktech.com.tw"
#define WLANDEV_MODELNAME			"Ralink Wireless Access Point"
#define WLANDEV_MODELDESCRIPTION	"Ralink AP WPS device"
//Ralink :  need to modified
#define WLANDEV_MODELNUMBER			"RT3062"
#define WLANDEV_MODELURL			"http://www.ralinktech.com.tw"
//#define WLANDEV_UPC					"MINIUPNPD"
#endif /* ENABLE_WSC_SERVICE */
#endif

#endif

