#!/bin/sh
#
# $Id: //WIFI_SOC/MP/SDK_4_2_0_0/RT288x_SDK/source/user/rt2880_app/scripts/internet.sh#9 $
#
# usage: internet.sh
#

. /sbin/config.sh
. /sbin/global.sh

radio_off1=`nvram_get 2860 RadioOff`
if [ "$CONFIG_RTDEV" != "" -o "$CONFIG_RT2561_AP" != "" ]; then
	radio_off2=`nvram_get rtdev RadioOff`
fi
wifi_off=`nvram_get 2860 WiFiOff`
ra_Bssidnum=`nvram_get 2860 BssidNum`
if [ "$CONFIG_RTDEV" != "" -o "$CONFIG_RT2561_AP" != "" ]; then
	rai_Bssidnum=`nvram_get rtdev BssidNum`
fi
rpt_wlanstate1=`nvram get wl_rpt_wlanstate1`
rpt_wlanstate2=`nvram get wl_rpt_wlanstate2`

ifRaxWdsxDown()
{
	brctl delif br0 wds0 1>/dev/null 2>&1
	brctl delif br0 wds1 1>/dev/null 2>&1
	brctl delif br0 wds2 1>/dev/null 2>&1
	brctl delif br0 wds3 1>/dev/null 2>&1
	brctl delif br1 wds0 1>/dev/null 2>&1
	brctl delif br1 wds1 1>/dev/null 2>&1
	brctl delif br1 wds2 1>/dev/null 2>&1
	brctl delif br1 wds3 1>/dev/null 2>&1

	brctl delif br0 apcli0 1>/dev/null 2>&1
	brctl delif br1 apcli0 1>/dev/null 2>&1

	brctl delif br0 mesh0 1>/dev/null 2>&1
	brctl delif br1 mesh0 1>/dev/null 2>&1

	num=16
	while [ "$num" -gt "0" ]
	do
		num=`expr $num - 1`
		brctl delif br0 ra$num 1>/dev/null 2>&1
		brctl delif br1 ra$num 1>/dev/null 2>&1
	done

	ifconfig wds0 down 1>/dev/null 2>&1
	ifconfig wds1 down 1>/dev/null 2>&1
	ifconfig wds2 down 1>/dev/null 2>&1
	ifconfig wds3 down 1>/dev/null 2>&1

	ifconfig apcli0 down 1>/dev/null 2>&1

	ifconfig mesh0 down 1>/dev/null 2>&1

	num=16
	while [ "$num" -gt "0" ]
	do
		num=`expr $num - 1`
		ifconfig ra$num down 1>/dev/null 2>&1
	done

	echo -e "##### disable 1st wireless interface done #####"
}

ifRaixWdsxDown()
{
	brctl delif br0 wdsi0 1>/dev/null 2>&1
	brctl delif br0 wdsi1 1>/dev/null 2>&1
	brctl delif br0 wdsi2 1>/dev/null 2>&1
	brctl delif br0 wdsi3 1>/dev/null 2>&1
	brctl delif br1 wdsi0 1>/dev/null 2>&1
	brctl delif br1 wdsi1 1>/dev/null 2>&1
	brctl delif br1 wdsi2 1>/dev/null 2>&1
	brctl delif br1 wdsi3 1>/dev/null 2>&1

	brctl delif br0 apclii0 1>/dev/null 2>&1
	brctl delif br1 apclii0 1>/dev/null 2>&1

	brctl delif br0 meshi0 1>/dev/null 2>&1
	brctl delif br1 meshi0 1>/dev/null 2>&1

	num=16
	while [ "$num" -gt "0" ]
	do
		num=`expr $num - 1`
		brctl delif br0 rai$num 1>/dev/null 2>&1
		brctl delif br1 rai$num 1>/dev/null 2>&1
	done

	ifconfig wdsi0 down 1>/dev/null 2>&1
	ifconfig wdsi1 down 1>/dev/null 2>&1
	ifconfig wdsi2 down 1>/dev/null 2>&1
	ifconfig wdsi3 down 1>/dev/null 2>&1

	ifconfig apclii0 down 1>/dev/null 2>&1

	ifconfig meshi0 down 1>/dev/null 2>&1

	num=16
	while [ "$num" -gt "0" ]
	do
		num=`expr $num - 1`
		ifconfig rai$num down 1>/dev/null 2>&1
	done

	echo -e "##### disable 2nd wireless interface done #####"
}

addRax2Br0()
{
	num=1 
	brctl addif br0 ra0 1>/dev/null 2>&1
	while [ "$num" -lt "$ra_Bssidnum" ] 
	do 
		ifconfig ra$num 0.0.0.0 1>/dev/null 2>&1
		brctl addif br0 ra$num 1>/dev/null 2>&1
		num=`expr $num + 1` 
	done
	echo -e "##### enable 1st wireless interface done #####"
}

addWds2Br0()
{
	wds_en=`nvram_get 2860 WdsEnable`
	if [ "$wds_en" != "0" ]; then
		ifconfig wds0 up 1>/dev/null 2>&1
		ifconfig wds1 up 1>/dev/null 2>&1
		ifconfig wds2 up 1>/dev/null 2>&1
		ifconfig wds3 up 1>/dev/null 2>&1
		brctl addif br0 wds0 1>/dev/null 2>&1
		brctl addif br0 wds1 1>/dev/null 2>&1
		brctl addif br0 wds2 1>/dev/null 2>&1
		brctl addif br0 wds3 1>/dev/null 2>&1
	fi
}

addMesh2Br0()
{
	meshenabled=`nvram_get 2860 MeshEnabled`
	if [ "$meshenabled" = "1" ]; then
		ifconfig mesh0 up 1>/dev/null 2>&1
		brctl addif br0 mesh0 1>/dev/null 2>&1
		meshhostname=`nvram_get 2860 MeshHostName`
		iwpriv mesh0 set  MeshHostName="$meshhostname"
	fi
}

addRaix2Br0()
{
	if [ "$CONFIG_RT2880_INIC" == "" -a "$CONFIG_RTDEV" == "" ]; then
		return
	fi
	brctl addif br0 rai0 1>/dev/null 2>&1
	num=1
	while [ "$num" -lt "$rai_Bssidnum" ]
	do
		ifconfig rai$num up 1>/dev/null 2>&1
		brctl addif br0 rai$num 1>/dev/null 2>&1
		num=`expr $num + 1`
	done
	echo -e "##### enable 2nd wireless interface done #####"
}

addInicWds2Br0()
{
	if [ "$CONFIG_RT2880_INIC" == "" -a "$CONFIG_RTDEV" == "" ]; then
		return
	fi
	wds_en=`nvram_get rtdev WdsEnable`
	if [ "$wds_en" != "0" ]; then
		ifconfig wdsi0 up 1>/dev/null 2>&1
		ifconfig wdsi1 up 1>/dev/null 2>&1
		ifconfig wdsi2 up 1>/dev/null 2>&1
		ifconfig wdsi3 up 1>/dev/null 2>&1
		brctl addif br0 wdsi0 1>/dev/null 2>&1
		brctl addif br0 wdsi1 1>/dev/null 2>&1
		brctl addif br0 wdsi2 1>/dev/null 2>&1
		brctl addif br0 wdsi3 1>/dev/null 2>&1
	fi
}

addRaL02Br0()
{
	if [ "$CONFIG_RT2561_AP" != "" ]; then
		brctl addif br0 raL0 1>/dev/null 2>&1
	fi
}

# opmode adjustment:
#   if AP client was not compiled and operation mode was set "3" -> set $opmode "1"
#   if Station was not compiled and operation mode was set "2" -> set $opmode "1"
if [ "$opmode" = "3" -a "$CONFIG_RT2860V2_AP_APCLI$CONFIG_RT3090_AP_APCLI$CONFIG_RT5392_AP_APCLI$CONFIG_RT5592_AP_APCLI$CONFIG_RT3593_AP_APCLI$CONFIG_MT7610_AP_APCLI$CONFIG_RT3572_AP_APCLI$CONFIG_RT5572_AP_APCLI$CONFIG_RT3680_iNIC_AP_APCLI$CONFIG_RTPCI_AP_APCLI$CONFIG_APCLI_SUPPORT" == "" ]; then
	opmode="1"
fi
if [ "$opmode" = "2" ]; then
	if [ "$CONFIG_RT2860V2_STA" == "" -o "$CONFIG_RLT_STA_SUPPORT" == "" ]; then
		opmode="1"
	fi
fi

ifconfig br0 down 1>/dev/null 2>&1
ifconfig br1 down 1>/dev/null 2>&1

ifRaxWdsxDown
if [ "$CONFIG_RTDEV" != "" -o "$CONFIG_RT2561_AP" != "" ]; then
	ifRaixWdsxDown
fi

ifconfig br0 up 1>/dev/null 2>&1
brctl delbr br1 1>/dev/null 2>&1

if [ "$CONFIG_RT2860V2_AP" != "" ]; then
	rmmod rt2860v2_ap_net 1>/dev/null 2>&1
	rmmod rt2860v2_ap 1>/dev/null 2>&1
	rmmod rt2860v2_ap_util 1>/dev/null 2>&1
fi
if [ "$CONFIG_RT2860V2_STA" != "" ]; then
	rmmod rt2860v2_sta_net 1>/dev/null 2>&1
	rmmod rt2860v2_sta 1>/dev/null 2>&1
	rmmod rt2860v2_sta_util 1>/dev/null 2>&1
fi
if [ "$CONFIG_RLT_STA_SUPPORT" != "" ]; then
	rmmod rlt_wifi_sta 1>/dev/null 2>&1
fi
if [ "$RT2880v2_INIC_PCI" != "" ]; then
	rmmod iNIC_pci 1>/dev/null 2>&1
fi
#if [ "$CONFIG_RLT_AP_SUPPORT" != "" ]; then
#	rmmod rlt_wifi 1>/dev/null 2>&1
#fi
if [ "$CONFIG_RT3090_AP" != "" ]; then
	rmmod RT3090_ap_net 1>/dev/null 2>&1
	rmmod RT3090_ap 1>/dev/null 2>&1
	rmmod RT3090_ap_util 1>/dev/null 2>&1
fi
if [ "$CONFIG_RT5392_AP" != "" ]; then
	rmmod RT5392_ap 1>/dev/null 2>&1
fi
if [ "$CONFIG_RT5592_AP" != "" ]; then
	rmmod RT5592_ap 1>/dev/null 2>&1
fi
if [ "$CONFIG_RT3593_AP" != "" ]; then
	rmmod RT3593_ap 1>/dev/null 2>&1
fi
if [ "$CONFIG_MT7610_AP" != "" ]; then
	rmmod MT7610_ap 1>/dev/null 2>&1
fi
if [ "$CONFIG_RTPCI_AP" != "" ]; then
	rmmod RTPCI_ap 1>/dev/null 2>&1
fi
if [ "$CONFIG_RT3572_AP" != "" ]; then
	rmmod RT3572_ap_net 1>/dev/null 2>&1
	rmmod RT3572_ap 1>/dev/null 2>&1
	rmmod RT3572_ap_util 1>/dev/null 2>&1
fi
if [ "$CONFIG_RT5572_AP" != "" ]; then
	rmmod RT5572_ap_net 1>/dev/null 2>&1
	rmmod RT5572_ap 1>/dev/null 2>&1
	rmmod RT5572_ap_util 1>/dev/null 2>&1
fi
if [ "$RT305x_INIC_USB" != "" ]; then
	rmmod iNIC_usb 1>/dev/null 2>&1
fi
if [ "$CONFIG_RT3680_iNIC_AP" != "" ]; then
	rmmod RT3680_ap 1>/dev/null 2>&1
fi
if [ "$CONFIG_RT2561_AP" != "" ]; then
	rmmod rt2561ap 1>/dev/null 2>&1
fi

if [ "$CONFIG_RT2860V2_AP_WAPI$CONFIG_RT3090_AP_WAPI$CONFIG_RT5392_AP_WAPI$CONFIG_RT5592_AP_WAPI$CONFIG_RT3593_AP_WAPI$CONFIG_MT7610_AP_WAPI$CONFIG_RT3572_AP_WAPI$CONFIG_RT5572_AP_WAPI$CONFIG_RT3680_iNIC_AP_WAPI$CONFIG_RTPCI_AP_WAPI" != "" ]; then
	ralink_init gen wapi
fi
ralink_init make_wireless_config rt2860
if [ "$CONFIG_RTDEV" != "" -o "$CONFIG_RT2561_AP" != "" ]; then
	ralink_init make_wireless_config rtdev
fi
if [ "$CONFIG_RT2860V2_AP_DFS$CONFIG_RT5592_AP_DFS$CONFIG_RT3593_AP_DFS$CONFIG_MT7610_AP_DFS$CONFIG_RT3572_AP_DFS$CONFIG_RT5572_AP_DFS$CONFIG_RTPCI_AP_DFS" != "" ]; then
	insmod -q rt_timer 1>/dev/null 2>&1
fi
if [ "$stamode" = "y" ]; then
	if [ "$CONFIG_RT2860V2_STA" != "" ]; then
		insmod -q rt2860v2_sta_util 1>/dev/null 2>&1
		insmod -q rt2860v2_sta 1>/dev/null 2>&1
		insmod -q rt2860v2_sta_net 1>/dev/null 2>&1

		if [ "$CONFIG_RT2860V2_STA_WPA_SUPPLICANT" == "y" ]; then
			ralink_init gen cert 1>/dev/null 2>&1
		fi
	elif [ "$CONFIG_RLT_STA_SUPPORT" != "" ]; then
		insmod -q rlt_wifi_sta 1>/dev/null 2>&1
		ralink_init gen cert 1>/dev/null 2>&1
	fi
elif [ "$CONFIG_RT2860V2_AP" != "" ]; then
	insmod -q rt2860v2_ap_util 1>/dev/null 2>&1
	insmod -q rt2860v2_ap 1>/dev/null 2>&1
	insmod -q rt2860v2_ap_net 1>/dev/null 2>&1
fi
# RTDEV_PCI support
if [ "$RT2880v2_INIC_PCI" != "" ]; then
	insmod -q iNIC_pci 1>/dev/null 2>&1
fi
if [ "$CONFIG_RLT_AP_SUPPORT" != "" ]; then
	rlt_wifi_exist=`lsmod | grep rlt_wifi | wc -l`
	if [ "$rlt_wifi_exist" = "0" ]; then
		insmod -q rlt_wifi 1>/dev/null 2>&1
	fi
fi
if [ "$CONFIG_RT3090_AP" != "" ]; then
	insmod -q RT3090_ap_util 1>/dev/null 2>&1
	insmod -q RT3090_ap 1>/dev/null 2>&1
	insmod -q RT3090_ap_net 1>/dev/null 2>&1
fi
if [ "$CONFIG_RT5392_AP" != "" ]; then
	insmod -q RT5392_ap 1>/dev/null 2>&1
fi
if [ "$CONFIG_RT5592_AP" != "" ]; then
	insmod -q RT5592_ap 1>/dev/null 2>&1
fi
if [ "$CONFIG_MT7610_AP" != "" ]; then
	insmod -q MT7610_ap 1>/dev/null 2>&1
fi
if [ "$CONFIG_RT3593_AP" != "" ]; then
	insmod -q RT3593_ap 1>/dev/null 2>&1
fi
if [ "$CONFIG_RTPCI_AP" != "" ]; then
	insmod -q RTPCI_ap 1>/dev/null 2>&1
fi
# RTDEV_USB support
if [ "$RT305x_INIC_USB" != "" ]; then
	insmod -q iNIC_usb 1>/dev/null 2>&1
fi
if [ "$CONFIG_RT3572_AP" != "" ]; then
	insmod -q RT3572_ap_util 1>/dev/null 2>&1
	insmod -q RT3572_ap 1>/dev/null 2>&1
	insmod -q RT3572_ap_net 1>/dev/null 2>&1
fi
if [ "$CONFIG_RT5572_AP" != "" ]; then
	insmod -q RT5572_ap_util 1>/dev/null 2>&1
	insmod -q RT5572_ap 1>/dev/null 2>&1
	insmod -q RT5572_ap_net 1>/dev/null 2>&1
fi
if [ "$CONFIG_RT3680_iNIC_AP" != "" ]; then
	insmod -q RT3680_ap 1>/dev/null 2>&1
fi

# RT2561(Legacy) support
if [ "$CONFIG_RT2561_AP" != "" ]; then
	insmod -q rt2561ap 1>/dev/null 2>&1
fi

if [ "$CONFIG_RTDEV_PLC" != "" ]; then
	ifconfig plc0 up
fi

# config interface
ifconfig ra0 0.0.0.0 1>/dev/null 2>&1
echo -e "##### bring up 1st interface done #####"
if [ "$ethconv" = "y" ]; then
	iwpriv ra0 set EthConvertMode=hybrid
	iwpriv ra0 set EthCloneMac=`nvram_get 2860 ethConvertMAC`
fi
if [ "$radio_off1" = "1" ]; then
	iwpriv ra0 set RadioOn=0
fi
if [ "$CONFIG_RTDEV" != "" -o "$CONFIG_RT2561_AP" != "" ]; then
	ifconfig rai0 0.0.0.0 1>/dev/null 2>&1
	echo -e "##### bring up 2nd interface done #####"
	if [ "$radio_off2" = "1" ]; then
		iwpriv rai0 set RadioOn=0
	fi
fi

# config interface
if [ "$rpt_wlanstate1" = "Disable" ]; then
	ifconfig ra0 down 1>/dev/null 2>&1
	echo -e "##### disable 1st AP interface done #####"
fi
if [ "$CONFIG_RTDEV" != "" -o "$CONFIG_RT2561_AP" != "" ]; then
	if [ "$rpt_wlanstate2" = "Disable" ]; then
		ifconfig rai0 down 1>/dev/null 2>&1
		echo -e "##### disable 2nd AP interface done #####"
	fi
fi

# config LAN/WAN bridge
if [ "$opmode" = "0" ]; then
	brctl setfd br0 15
	brctl stp br0 1
else
	brctl setfd br0 1
	brctl stp br0 0
fi

#
# init ip address to all interfaces for different OperationMode:
#   0 = Bridge Mode
#   1 = Gateway Mode
#   2 = Ethernet Converter Mode
#   3 = AP Client
#
if [ "$opmode" = "0" ]; then
	addRax2Br0
	addWds2Br0
	addMesh2Br0
	APCLI=`nvram_get 2860 apClient`
	if [ "$CONFIG_RT2860V2_AP_APCLI$CONFIG_RT3090_AP_APCLI$CONFIG_RT5392_AP_APCLI$CONFIG_RT5592_AP_APCLI$CONFIG_RT3593_AP_APCLI$CONFIG_MT7610_AP_APCLI$CONFIG_RT3572_AP_APCLI$CONFIG_RT5572_AP_APCLI$CONFIG_RT3680_iNIC_AP_APCLI$CONFIG_RTPCI_AP_APCLI$CONFIG_APCLI_SUPPORT" != "" -a "$APCLI" = "1" ]; then
		ifconfig apcli0 up 1>/dev/null 2>&1
		brctl addif br0 apcli0 1>/dev/null 2>&1
	fi
# RTDEV_MII support: start mii iNIC after network interface is working
	if [ "$CONFIG_RTDEV_MII" != "" ]; then
		rmmod iNIC_mii 1>/dev/null 2>&1
		iNIC_Mii_en=`nvram_get rtdev InicMiiEnable`
		if [ "$iNIC_Mii_en" == "1" ]; then
			ifconfig rai0 down 1>/dev/null 2>&1
			insmod -q iNIC_mii miimaster=eth2 1>/dev/null 2>&1
			ifconfig rai0 up 1>/dev/null 2>&1
		fi
	fi

	if [ "$CONFIG_RTDEV" != "" -o "$CONFIG_RT2561_AP" != "" ]; then
		addRaix2Br0
		addInicWds2Br0
		addRaL02Br0

		APCLI2=`nvram_get rtdev apClient`
		if [ "$CONFIG_RT2860V2_AP_APCLI$CONFIG_RT3090_AP_APCLI$CONFIG_RT5392_AP_APCLI$CONFIG_RT5592_AP_APCLI$CONFIG_RT3593_AP_APCLI$CONFIG_MT7610_AP_APCLI$CONFIG_RT3572_AP_APCLI$CONFIG_RT5572_AP_APCLI$CONFIG_RT3680_iNIC_AP_APCLI$CONFIG_RTPCI_AP_APCLI$CONFIG_APCLI_SUPPORT" != "" -a "$APCLI2" = "1" ]; then
			ifconfig apclii0 up 1>/dev/null 2>&1
			brctl addif br0 apclii0 1>/dev/null 2>&1
		fi
	fi
elif [ "$opmode" = "1" ]; then
	addRax2Br0
	addWds2Br0
	addMesh2Br0

	if [ "$CONFIG_RTDEV" != "" -o "$CONFIG_RT2561_AP" != "" ]; then
		addRaix2Br0
		addInicWds2Br0
		addRaL02Br0
	fi
elif [ "$opmode" = "2" ]; then
	if [ "$CONFIG_RTDEV" != "" -o "$CONFIG_RT2561_AP" != "" ]; then
		addRaix2Br0
		addInicWds2Br0
		addRaL02Br0
	fi
elif [ "$opmode" = "3" ]; then
	addRax2Br0

	brctl addbr br1 1>/dev/null 2>&1
	ifconfig br1 up 1>/dev/null 2>&1
	APCLI=`nvram_get 2860 apClient`
	if [ "$CONFIG_RT2860V2_AP_APCLI$CONFIG_RT3090_AP_APCLI$CONFIG_RT5392_AP_APCLI$CONFIG_RT5592_AP_APCLI$CONFIG_RT3593_AP_APCLI$CONFIG_MT7610_AP_APCLI$CONFIG_RT3572_AP_APCLI$CONFIG_RT5572_AP_APCLI$CONFIG_RT3680_iNIC_AP_APCLI$CONFIG_RTPCI_AP_APCLI$CONFIG_APCLI_SUPPORT" != "" -a "$APCLI" = "1" ]; then
		ifconfig apcli0 up 1>/dev/null 2>&1
		brctl addif br1 apcli0 1>/dev/null 2>&1
	fi

	if [ "$CONFIG_RTDEV" != "" -o "$CONFIG_RT2561_AP" != "" ]; then
		addRaix2Br0
		addInicWds2Br0
		addRaL02Br0

		APCLI2=`nvram_get rtdev apClient`
		if [ "$CONFIG_RT2860V2_AP_APCLI$CONFIG_RT3090_AP_APCLI$CONFIG_RT5392_AP_APCLI$CONFIG_RT5592_AP_APCLI$CONFIG_RT3593_AP_APCLI$CONFIG_MT7610_AP_APCLI$CONFIG_RT3572_AP_APCLI$CONFIG_RT5572_AP_APCLI$CONFIG_RT3680_iNIC_AP_APCLI$CONFIG_RTPCI_AP_APCLI$CONFIG_APCLI_SUPPORT" != "" -a "$APCLI2" = "1" ]; then
			ifconfig apclii0 up 1>/dev/null 2>&1
			brctl addif br1 apclii0 1>/dev/null 2>&1
		fi
	fi
else
	echo "unknown OperationMode: $opmode"
	exit 1
fi

# INIC support
#if [ "$CONFIG_RT2880_INIC" != "" ]; then
#	ifconfig rai0 down
#	rmmod rt_pci_dev
#	ralink_init make_wireless_config rtdev
#	insmod -q rt_pci_dev
#	ifconfig rai0 up
#	RaAP&
#	sleep 3
#fi

m2uenabled=`nvram_get 2860 M2UEnabled`
if [ "$m2uenabled" = "1" ]; then
	iwpriv ra0 set IgmpSnEnable=1
	echo "iwpriv ra0 set IgmpSnEnable=1"
fi

if [ "$wifi_off" = "1" ]; then
	ifRaxWdsxDown
	reg s b0180000
	reg w 400 0x1080
	reg w 1204 8
	reg w 1004 3
fi

if [ "$CONFIG_RALINK_MT7621" = "y" ]; then
	smp.sh wifi
fi

# radvd
#radvd.sh

#ipv6_logo.sh

if [ "$CONFIG_RALINKAPP_HOTSPOT" == "y" ]; then
	hotspot.sh
fi
echo 4096 > /proc/sys/net/ipv4/tcp_max_tw_buckets

if [ "$CONFIG_USER_NFCSD" = "y" ]; then
killall nfchod
killall nfcsd
wps_ra0=`nvram_get 2860 WscModeOption`
nfc_ra0=`nvram_get 2860 NFC_ra0_enable`
if [ "$wps_ra0" = "7" ]; then
if [ "$nfc_ra0" = "1" ]; then
		nfchod &
		sleep 2
		iwpriv ra0 set NfcStatus=1
fi
fi
wps_rai0=`nvram_get rtdev WscModeOption`
nfc_rai0=`nvram_get rtdev NFC_rai0_enable`
if [ "$wps_rai0" = "7" ]; then
if [ "$nfc_rai0" = "1" ]; then
		nfchod -s rai0 &
		sleep 2;
		iwpriv rai0 set NfcStatus=1
fi
fi
fi
