#!/bin/sh
#
# $Id: //WIFI_SOC/MP/SDK_4_2_0_0/RT288x_SDK/source/user/rt2880_app/scripts/internet.sh#5 $
#
# usage: internet.sh
#

. /sbin/config.sh
. /sbin/global.sh

#
#	ipv6 config#
#	$1:	interface name
#	$2:	dad_transmit number
#
enableIPv6dad()
{
	if [ "$CONFIG_IPV6" == "y" -o "$CONFIG_IPV6" == "m" ]; then
		echo "2" > /proc/sys/net/ipv6/conf/$1/accept_dad
		echo $2 > /proc/sys/net/ipv6/conf/$1/dad_transmits
	fi
}

disableIPv6dad()
{
	if [ "$CONFIG_IPV6" == "y" -o "$CONFIG_IPV6" == "m" ]; then
		echo "0" > /proc/sys/net/ipv6/conf/$1/accept_dad
	fi
}

configLAN()
{
	# ip address
	ip=`nvram get lan_ipaddr`
	nm=`nvram get lan_netmask`
	ifconfig $lan_if down 1>/dev/null 2>&1
	ifconfig $lan_if $ip netmask $nm
	opmode=`nvram_get 2860 OperationMode`
	if [ "$opmode" = "0" ]; then
		gw=`nvram_get 2860 wan_gateway`
		pd=`nvram_get 2860 wan_primary_dns`
		sd=`nvram_get 2860 wan_secondary_dns`
		route del default
		route add default gw $gw
		# config-dns.sh $pd $sd
	fi

	ifconfig "br0:9" down 1>/dev/null 2>&1
	ifconfig "eth2:9" down 1>/dev/null 2>&1
	lan2enabled=`nvram_get 2860 Lan2Enabled`
	if [ "$lan2enabled" = "1" ]; then
		ip_2=`nvram_get 2860 lan2_ipaddr`
		nm_2=`nvram_get 2860 lan2_netmask`
		if [ "$opmode" = "0" ]; then
			ifconfig "br0:9" "$ip_2" netmask "$nm_2"
			echo "ifconfig "br0:9" "$ip_2" netmask "$nm_2""
		elif [ "$opmode" = "1" ]; then
			ifconfig "br0:9" "$ip_2" netmask "$nm_2"
			echo "ifconfig "br0:9" "$ip_2" netmask "$nm_2""
		elif [ "$opmode" = "2" ]; then
			ifconfig "eth2:9" "$ip_2" netmask "$nm_2"
			echo "ifconfig "eth2:9" "$ip_2" netmask "$nm_2""
		elif [ "$opmode" = "3" ]; then
			ifconfig "br0:9" "$ip_2" netmask "$nm_2"
			echo "ifconfig "br0:9" "$ip_2" netmask "$nm_2""
		fi
	fi

	# hostname
	host=`nvram get system_name`
	if [ "$host" = "" ]; then
		host=`nvram_get 2860 HostName`
	fi
	hostname $host
	echo "127.0.0.1 localhost.localdomain localhost" > /etc/hosts
	# echo "$ip $host.ralinktech.com $host" >> /etc/hosts
}

# opmode adjustment:
#   if AP client was not compiled and operation mode was set "3" -> set $opmode "1"
#   if Station was not compiled and operation mode was set "2" -> set $opmode "1"
if [ "$opmode" = "3" -a "$CONFIG_RT2860V2_AP_APCLI$CONFIG_RT3090_AP_APCLI$CONFIG_RT5392_AP_APCLI$CONFIG_RT5592_AP_APCLI$CONFIG_RT3593_AP_APCLI$CONFIG_MT7610_AP_APCLI$CONFIG_RT3572_AP_APCLI$CONFIG_RT5572_AP_APCLI$CONFIG_RT3680_iNIC_AP_APCLI$CONFIG_RTPCI_AP_APCLI$CONFIG_APCLI_SUPPORT" == "" ]; then
	opmode="1"
fi
if [ "$opmode" = "2" -a "$CONFIG_RT2860V2_STA" == "" ]; then
	opmode="1"
fi

#
# init ip address to all interfaces for different OperationMode:
#   0 = Bridge Mode
#   1 = Gateway Mode
#   2 = Ethernet Converter Mode
#   3 = AP Client
#
if [ "$opmode" = "0" ]; then
	brctl addif br0 eth2 1>/dev/null 2>&1
	if [ "$CONFIG_GE2_RGMII_AN" = "y" -o "$CONFIG_GE2_INTERNAL_GPHY" = "y" ]; then
		brctl addif br0 eth3 1>/dev/null 2>&1
	fi
elif [ "$opmode" = "1" ]; then
	if [ "$CONFIG_RAETH_ROUTER" = "y" -o "$CONFIG_MAC_TO_MAC_MODE" = "y" -o "$CONFIG_RT_3052_ESW" = "y" ]; then
		if [ "$CONFIG_RAETH_SPECIAL_TAG" == "y" ]; then
			if [ "$CONFIG_WAN_AT_P4" = "y" ]; then
				brctl addif br0 eth2.1 1>/dev/null 2>&1
			fi
			brctl addif br0 eth2.2 1>/dev/null 2>&1
			brctl addif br0 eth2.3 1>/dev/null 2>&1
			brctl addif br0 eth2.4 1>/dev/null 2>&1
			if [ "$CONFIG_WAN_AT_P0" = "y" ]; then
				brctl addif br0 eth2.5 1>/dev/null 2>&1
			fi
		elif [ "y" = "y" ]; then
			echo "##### Single Giga PHY as WAN #####"
		elif [ "$CONFIG_GE2_RGMII_AN" = "y" -o "$CONFIG_GE2_INTERNAL_GPHY" = "y" ]; then
			brctl addif br0 eth2 1>/dev/null 2>&1
		else
			brctl addif br0 eth2.1 1>/dev/null 2>&1
		fi
	fi

	# IC+ 100 PHY (one port only)
	if [ "$CONFIG_ICPLUS_PHY" = "y" ]; then
		echo '##### connected to one port 100 PHY #####'
		#
		# setup ip alias for user to access web page.
		#
		ifconfig eth2:1 172.32.1.254 netmask 255.255.255.0 up
	fi
	if [ "$CONFIG_GE1_RGMII_AN" = "y" -a "$CONFIG_GE2_RGMII_AN" = "y" ]; then
		echo "##### connected to two Giga PHY port #####"
		brctl addif br0 eth2 1>/dev/null 2>&1
	fi
elif [ "$opmode" = "2" ]; then
	brctl addif br0 eth2 1>/dev/null 2>&1
	if [ "$CONFIG_GE2_RGMII_AN" = "y" -o "$CONFIG_GE2_INTERNAL_GPHY" = "y" ]; then
		brctl addif br0 eth3 1>/dev/null 2>&1
	fi
	enableIPv6dad $lan_if 1
	enableIPv6dad $wan_if 1
elif [ "$opmode" = "3" ]; then
	brctl addif br0 eth2 1>/dev/null 2>&1
	if [ "$CONFIG_GE2_RGMII_AN" = "y" -o "$CONFIG_GE2_INTERNAL_GPHY" = "y" ]; then
		brctl addif br0 eth3 1>/dev/null 2>&1
	fi
else
	echo "unknown OperationMode: $opmode"
	exit 1
fi

configLAN
