#!/bin/sh
#
# $Id: //WIFI_SOC/MP/SDK_4_2_0_0/RT288x_SDK/source/user/rt2880_app/scripts/internet.sh#9 $
#
# usage: internet.sh
#

. /sbin/config.sh
. /sbin/global.sh

set_vlan_map()
{
	# vlan priority tag => skb->priority mapping
	vconfig set_ingress_map $1 0 0
	vconfig set_ingress_map $1 1 1
	vconfig set_ingress_map $1 2 2
	vconfig set_ingress_map $1 3 3
	vconfig set_ingress_map $1 4 4
	vconfig set_ingress_map $1 5 5
	vconfig set_ingress_map $1 6 6
	vconfig set_ingress_map $1 7 7

	# skb->priority => vlan priority tag mapping
	vconfig set_egress_map $1 0 0
	vconfig set_egress_map $1 1 1
	vconfig set_egress_map $1 2 2
	vconfig set_egress_map $1 3 3
	vconfig set_egress_map $1 4 4
	vconfig set_egress_map $1 5 5
	vconfig set_egress_map $1 6 6
	vconfig set_egress_map $1 7 7
}

addBr0()
{
	brctl addbr br0 1>/dev/null 2>&1

	# configure stp forward delay
	if [ "$wan_if" = "br0" -o "$lan_if" = "br0" ]; then
		stp=`nvram_get 2860 stpEnabled`
		if [ "$stp" = "1" ]; then
			brctl setfd br0 15
			brctl stp br0 1
		else
			brctl setfd br0 1
			brctl stp br0 0
		fi
		enableIPv6dad br0 2
	fi

}

#
#	ipv6 config#
#	$1:	interface name
#	$2:	dad_transmit number
#
enableIPv6dad()
{
	if [ "$CONFIG_IPV6" == "y" -o "$CONFIG_IPV6" == "m" ]; then
		echo "2" > /proc/sys/net/ipv6/conf/$1/accept_dad
		echo $2 > /proc/sys/net/ipv6/conf/$1/dad_transmits
	fi
}

disableIPv6dad()
{
	if [ "$CONFIG_IPV6" == "y" -o "$CONFIG_IPV6" == "m" ]; then
		echo "0" > /proc/sys/net/ipv6/conf/$1/accept_dad
	fi
}

configVIF()
{
	if [ "$CONFIG_TASKLET_WORKQUEUE_SW" == "y" ]; then
		ifconfig eth2 down
		PLATFORM=`nvram_get 2860 Platform | tr A-Z a-z`
		if [ "$wanmode" == "PPPOE" -o "$wanmode" == "L2TP" -o "$wanmode" == "PPTP" ]; then
			echo 1 > /proc/$PLATFORM/schedule
		else
			echo 0 > /proc/$PLATFORM/schedule
		fi
	fi
	ifconfig eth2 0.0.0.0
	if [ "$CONFIG_GE2_RGMII_AN" = "y" -o "$CONFIG_GE2_INTERNAL_GPHY" = "y" ]; then
		ifconfig eth3 up

	elif [ "$CONFIG_RAETH_ROUTER" = "y" -o "$CONFIG_MAC_TO_MAC_MODE" = "y" -o "$CONFIG_RT_3052_ESW" = "y" ]; then
		vconfig rem eth2.1 1>/dev/null 2>&1
		vconfig rem eth2.2 1>/dev/null 2>&1
		if [ "$CONFIG_RAETH_SPECIAL_TAG" == "y" ]; then
			vconfig rem eth2.3 1>/dev/null 2>&1
			vconfig rem eth2.4 1>/dev/null 2>&1
			vconfig rem eth2.5 1>/dev/null 2>&1
		fi
		rmmod 8021q 1>/dev/null 2>&1
		if [ "$CONFIG_VLAN_8021Q" == "m" ]; then
		insmod -q 8021q 1>/dev/null 2>&1
		fi
		vconfig add eth2 1
		set_vlan_map eth2.1
		vconfig add eth2 2
		set_vlan_map eth2.2
		if [ "$CONFIG_RAETH_SPECIAL_TAG" == "y" ]; then
			vconfig add eth2 3
			set_vlan_map eth2.3
			vconfig add eth2 4
			set_vlan_map eth2.4
			vconfig add eth2 5
			set_vlan_map eth2.5

			if [ "$CONFIG_WAN_AT_P0" = "y" ]; then
				ifconfig eth2.1 down
				wan_mac=`nvram get wan_hwaddr`
				if [ "$wan_mac" != "FF:FF:FF:FF:FF:FF" ]; then
					ifconfig eth2.1 hw ether $wan_mac
				fi
				enableIPv6dad eth2.1 1
			else
				ifconfig eth2.5 down
				wan_mac=`nvram get wan_hwaddr`
				if [ "$wan_mac" != "FF:FF:FF:FF:FF:FF" ]; then
					ifconfig eth2.5 hw ether $wan_mac
				fi
				enableIPv6dad eth2.5 1
			fi
		else
			ifconfig eth2.2 down
			wan_mac=`nvram get wan_hwaddr`
			if [ "$wan_mac" != "FF:FF:FF:FF:FF:FF" ]; then
				ifconfig eth2.2 hw ether $wan_mac
			fi
			enableIPv6dad eth2.2 1
		fi

		ifconfig eth2.1 0.0.0.0 1>/dev/null 2>&1
		ifconfig eth2.2 0.0.0.0 1>/dev/null 2>&1
		if [ "$CONFIG_RAETH_SPECIAL_TAG" == "y" ]; then
			ifconfig eth2.3 0.0.0.0 1>/dev/null 2>&1
			ifconfig eth2.4 0.0.0.0 1>/dev/null 2>&1
			ifconfig eth2.5 0.0.0.0 1>/dev/null 2>&1
		fi

	elif [ "$CONFIG_ICPLUS_PHY" = "y" ]; then
		#remove ip alias
		# it seems busybox has no command to remove ip alias...
		ifconfig eth2:1 0.0.0.0 1>&2 2>/dev/null
	fi
}

# opmode adjustment:
#   if AP client was not compiled and operation mode was set "3" -> set $opmode "1"
#   if Station was not compiled and operation mode was set "2" -> set $opmode "1"
if [ "$opmode" = "3" -a "$CONFIG_RT2860V2_AP_APCLI$CONFIG_RT3090_AP_APCLI$CONFIG_RT5392_AP_APCLI$CONFIG_RT5592_AP_APCLI$CONFIG_RT3593_AP_APCLI$CONFIG_MT7610_AP_APCLI$CONFIG_RT3572_AP_APCLI$CONFIG_RT5572_AP_APCLI$CONFIG_RT3680_iNIC_AP_APCLI$CONFIG_RTPCI_AP_APCLI$CONFIG_APCLI_SUPPORT" == "" ]; then
	nvram_set 2860 OperationMode 1
	opmode="1"
fi
if [ "$opmode" = "2" ]; then
	if [ "$CONFIG_RT2860V2_STA" == "" -o "$CONFIG_RLT_STA_SUPPORT" == "" ]; then
		nvram_set 2860 OperationMode 1
		opmode="1"
	fi
fi

echo 0 > /proc/sys/net/ipv4/ip_forward

# delete ethernet interfaces from bridge
brctl delif br0 eth2 1>/dev/null 2>&1
brctl delif br0 eth3 1>/dev/null 2>&1
brctl delif br0 eth2.1 1>/dev/null 2>&1
brctl delif br0 eth2.2 1>/dev/null 2>&1
brctl delif br0 eth2.3 1>/dev/null 2>&1
brctl delif br0 eth2.4 1>/dev/null 2>&1
brctl delif br0 eth2.5 1>/dev/null 2>&1

brctl delif br1 eth2 1>/dev/null 2>&1
brctl delif br1 eth3 1>/dev/null 2>&1
brctl delif br1 eth2.1 1>/dev/null 2>&1
brctl delif br1 eth2.2 1>/dev/null 2>&1
brctl delif br1 eth2.3 1>/dev/null 2>&1
brctl delif br1 eth2.4 1>/dev/null 2>&1
brctl delif br1 eth2.5 1>/dev/null 2>&1

# delete wireless interfaces from bridge
num=16
while [ "$num" -gt "0" ]
do
	num=`expr $num - 1`
	brctl delif br0 ra$num 1>/dev/null 2>&1
	brctl delif br0 rai$num 1>/dev/null 2>&1

	brctl delif br1 ra$num 1>/dev/null 2>&1
	brctl delif br1 rai$num 1>/dev/null 2>&1
done

brctl delif br0 wds0 1>/dev/null 2>&1
brctl delif br0 wds1 1>/dev/null 2>&1
brctl delif br0 wds2 1>/dev/null 2>&1
brctl delif br0 wds3 1>/dev/null 2>&1
brctl delif br0 wdsi0 1>/dev/null 2>&1
brctl delif br0 wdsi1 1>/dev/null 2>&1
brctl delif br0 wdsi2 1>/dev/null 2>&1
brctl delif br0 wdsi3 1>/dev/null 2>&1

brctl delif br1 wds0 1>/dev/null 2>&1
brctl delif br1 wds1 1>/dev/null 2>&1
brctl delif br1 wds2 1>/dev/null 2>&1
brctl delif br1 wds3 1>/dev/null 2>&1
brctl delif br1 wdsi0 1>/dev/null 2>&1
brctl delif br1 wdsi1 1>/dev/null 2>&1
brctl delif br1 wdsi2 1>/dev/null 2>&1
brctl delif br1 wdsi3 1>/dev/null 2>&1

brctl delif br0 apcli0 1>/dev/null 2>&1
brctl delif br0 apclii0 1>/dev/null 2>&1

brctl delif br1 apcli0 1>/dev/null 2>&1
brctl delif br1 apclii0 1>/dev/null 2>&1

brctl delif br0 mesh0 1>/dev/null 2>&1
brctl delif br0 meshi0 1>/dev/null 2>&1

brctl delif br1 mesh0 1>/dev/null 2>&1
brctl delif br1 meshi0 1>/dev/null 2>&1

# bring down bridge
ifconfig br0 down 1>/dev/null 2>&1
# brctl delbr br0 1>/dev/null 2>&1

ifconfig br1 down 1>/dev/null 2>&1
brctl delbr br1 1>/dev/null 2>&1

# disable ipv6 DAD on all interfaces by default
if [ "$CONFIG_IPV6" == "y" -o "$CONFIG_IPV6" == "m" ]; then
	insmod -q ipv6_spi
	echo "0" > /proc/sys/net/ipv6/conf/default/accept_dad
fi

if [ "$CONFIG_DWC_OTG" == "m" ]; then
usbmod_exist=`lsmod | grep dwc_otg | wc -l`
if [ $usbmod_exist == 0 ]; then
insmod -q lm
insmod -q dwc_otg
fi
fi

if [ "$CONFIG_USB_EHCI_HCD" == "m" ]; then
usbmod_exist=`lsmod | grep ehci-hcd | wc -l`
if [ $usbmod_exist == 0 ]; then
insmod -q ehci-hcd
fi
fi

if [ "$CONFIG_USB_OHCI_HCD" == "m" ]; then
usbmod_exist=`lsmod | grep ohci-hcd | wc -l`
if [ $usbmod_exist == 0 ]; then
insmod -q ohci-hcd
fi
fi

if [ "$CONFIG_MTK_MMC" == "m" ]; then
msdcmod_exist=`lsmod | grep mtk_sd | wc -l`
if [ $msdcmod_exist == 0 ]; then
insmod -q mtk_sd
fi
fi

if [ "$CONFIG_UFSD_FS" == "m" -o "$CONFIG_UFSD_FS" == "y" ]; then
ufsdmod_exist=`lsmod | grep ufsd | wc -l`
if [ $ufsdmod_exist == 0 ]; then
	insmod -q ufsd
fi
fi

if [ "$CONFIG_GE2_RGMII_AN" = "y" -o "$CONFIG_GE2_INTERNAL_GPHY" = "y" ]; then
	ifconfig eth3 down
fi

killall -9 watchdog 1>/dev/null 2>&1
if [ "$CONFIG_RALINK_WATCHDOG" = "m" -o "$CONFIG_RALINK_TIMER_WDG" = "m" ]; then
rmmod ralink_wdt 1>/dev/null 2>&1
fi
if [ "$CONFIG_RA_CLASSIFIER" = "y" -o "$CONFIG_RA_CLASSIFIER" = "m" ]; then
rmmod cls 1>/dev/null 2>&1
fi
if [ "$CONFIG_RA_HW_NAT" = "m" ]; then
rmmod hw_nat 1>/dev/null 2>&1
fi

# insmod all
if [ "$CONFIG_BRIDG" = "m" ]; then
insmod -q bridge 1>/dev/null 2>&1
fi
if [ "$CONFIG_MII" = "m" ]; then
insmod -q mii 1>/dev/null 2>&1
fi
if [ "$CONFIG_RAETH" = "m" ]; then
rmmod raeth 1>/dev/null 2>&1
insmod -q raeth 1>/dev/null 2>&1
fi

# avoid eth2 doing ipv6 DAD
disableIPv6dad eth2

# In 2.6.36 kernel(MT7620& MT7621), avoid ipv6 traffic unless everything ready
if [ "$CONFIG_RALINK_MT7620" = "y" -o "$CONFIG_RALINK_MT7621" = "y" ]; then
if [ "$CONFIG_IPV6" == "y" -o "$CONFIG_IPV6" == "m" ]; then
echo 1 > /proc/sys/net/ipv6/conf/all/disable_ipv6
fi
fi

ifconfig lo 127.0.0.1 1>/dev/null 2>&1

#
# init ip address to all interfaces for different OperationMode:
#   0 = Bridge Mode
#   1 = Gateway Mode
#   2 = Ethernet Converter Mode
#   3 = AP Client
#
if [ "$opmode" = "0" ]; then
	configVIF
	if [ "$CONFIG_RAETH_ROUTER" = "y" -a "$CONFIG_LAN_WAN_SUPPORT" = "y" ]; then
		echo "##### restore IC+ to dump switch #####"
		config-vlan.sh 0 0
	elif [ "$CONFIG_MAC_TO_MAC_MODE" = "y" ]; then
		echo "##### restore Vtss to dump switch #####"
		config-vlan.sh 1 0
		if [ "$CONFIG_IPV6" == "y" -o "$CONFIG_IPV6" == "m" ]; then
			sleep 3
		fi
	elif [ "$CONFIG_RT_3052_ESW" = "y" ]; then
		echo "##### restore Ralink ESW to dump switch #####"
		if [ "$CONFIG_RALINK_RT6855" = "y" -o "$CONFIG_RALINK_RT6855A" = "y" -o "$CONFIG_RALINK_MT7620" = "y" -o "$CONFIG_RALINK_MT7621" = "y" ]; then
			config-vlan.sh 3 0
		else
			config-vlan.sh 2 0
		fi
	fi
	if [ "$CONFIG_IPV6" == "y" -o "$CONFIG_IPV6" == "m" ]; then
		sleep 2
	fi
elif [ "$opmode" = "1" ]; then
	configVIF
	if [ "$CONFIG_RAETH_ROUTER" = "y" -a "$CONFIG_LAN_WAN_SUPPORT" = "y" ]; then
		if [ "$CONFIG_WAN_AT_P0" = "y" ]; then
			echo '##### config IC+ vlan partition (WLLLL) #####'
			config-vlan.sh 0 WLLLL
		else
			echo '##### config IC+ vlan partition (LLLLW) #####'
			config-vlan.sh 0 LLLLW
		fi
	fi
	if [ "$CONFIG_MAC_TO_MAC_MODE" = "y" ]; then
		if [ "$CONFIG_WAN_AT_P0" = "y" ]; then
			echo '##### config Vtss vlan partition (WLLLL) #####'
			config-vlan.sh 1 WLLLL
		else
			echo '##### config Vtss vlan partition (LLLLW) #####'
			config-vlan.sh 1 LLLLW
		fi
		if [ "$CONFIG_IPV6" == "y" -o "$CONFIG_IPV6" == "m" ]; then
			sleep 3
		fi
	fi
	if [ "$CONFIG_RT_3052_ESW" = "y" -a "$CONFIG_LAN_WAN_SUPPORT" = "y" ]; then
		if [ "$CONFIG_P5_RGMII_TO_MAC_MODE" = "y" -o  "$CONFIG_GE2_RGMII_AN" = "y" -o "$CONFIG_GE2_INTERNAL_GPHY" = "y" ]; then
			echo "##### restore Ralink ESW to dump switch #####"
			if [ "$CONFIG_RALINK_RT6855" = "y" -o "$CONFIG_RALINK_RT6855A" -o "$CONFIG_RALINK_MT7620" = "y" -o "$CONFIG_RALINK_MT7621" = "y" ]; then
				config-vlan.sh 3 0 
			else
				config-vlan.sh 2 0
			fi
			if [ "$CONFIG_WAN_AT_P0" = "y" ]; then
				if [ "$CONFIG_RALINK_MT7621" = "y" ]; then
					echo '##### config Switch vlan partition (WLLLL) #####'
					if [ "$CONFIG_RAETH_8023AZ_EEE" = "y" ]; then
					switch vlan  set 1 1 01111011
					switch vlan  set 2 2 10000100
					switch pvid 0 2
					switch pvid 5 2
					switch reg w 2004 ff0003
					switch reg w 2104 ff0003
					switch reg w 2204 ff0003
					switch reg w 2304 ff0003
					switch reg w 2404 ff0003
					switch reg w 2504 ff0003
					switch reg w 2604 ff0003
					fi
				elif [ "$CONFIG_RALINK_RT6855" = "y" -o "$CONFIG_RALINK_RT6855A" = "y" -o "$CONFIG_RALINK_MT7620" = "y" ]; then
					echo '##### config External Switch vlan partition (WLLLL) #####'
				else
					echo '##### config External Switch vlan partition (WLLLL) #####'
					echo "initialize external switch (WLLLL)"
					config-vlan.sh 1 WLLLL
				fi
			else
				if [ "$CONFIG_RALINK_MT7621" = "y" ]; then
					echo '##### config Switch vlan partition (LLLLW) #####'
					if [ "$CONFIG_RAETH_8023AZ_EEE" = "y" ]; then
					switch vlan  set 1 1 11110011
					switch vlan  set 2 2 00001100
					switch pvid 4 2
					switch pvid 5 2
					switch reg w 2004 ff0003
					switch reg w 2104 ff0003
					switch reg w 2204 ff0003
					switch reg w 2304 ff0003
					switch reg w 2404 ff0003
					switch reg w 2504 ff0003
					switch reg w 2604 ff0003
					fi
				elif [ "$CONFIG_RALINK_RT6855" = "y" -o "$CONFIG_RALINK_RT6855A" = "y" -o "$CONFIG_RALINK_MT7620" = "y" ]; then
					echo '##### config External Switch vlan partition (LLLLW) #####'
				else
					echo '##### config External Switch vlan partition (LLLLW) #####'
					echo "initialize external switch (LLLLW)"
					config-vlan.sh 1 LLLLW
				fi
			fi
		else
			if [ "$CONFIG_WAN_AT_P0" = "y" ]; then
				echo '##### config Ralink ESW vlan partition (WLLLL) #####'
				if [ "$CONFIG_RALINK_RT6855" = "y" -o "$CONFIG_RALINK_RT6855A" = "y" -o "$CONFIG_RALINK_MT7620" = "y" -o "$CONFIG_RALINK_MT7621" = "y" ]; then
					config-vlan.sh 3 WLLLL
				else
					config-vlan.sh 2 WLLLL
				fi
			else
				echo '##### config Ralink ESW vlan partition (LLLLW) #####'
				if [ "$CONFIG_RALINK_RT6855" = "y" -o "$CONFIG_RALINK_RT6855A" = "y" -o "$CONFIG_RALINK_MT7620" = "y" -o "$CONFIG_RALINK_MT7621" = "y" ]; then
					config-vlan.sh 3 LLLLW
				else
					config-vlan.sh 2 LLLLW
				fi
			fi
		fi
	fi

	if [ "$CONFIG_IPV6" == "y" -o "$CONFIG_IPV6" == "m" ]; then
		sleep 4
	fi
elif [ "$opmode" = "2" ]; then
	configVIF
	# if (-1 == initStaProfile())
	#   error(E_L, E_LOG, T("internet.c: profiles in nvram is broken"));
	# else
	#   initStaConnection();

	if [ "$CONFIG_RAETH_ROUTER" = "y" -a "$CONFIG_LAN_WAN_SUPPORT" = "y" ]; then
		echo "##### restore IC+ to dump switch #####"
		config-vlan.sh 0 0
	fi
	if [ "$CONFIG_MAC_TO_MAC_MODE" = "y" ]; then
		echo "##### restore External Switch to dump switch #####"
		config-vlan.sh 1 0
	fi
	if [ "$CONFIG_RT_3052_ESW" = "y" ]; then
		if [ "$CONFIG_P5_RGMII_TO_MAC_MODE" = "y" -o "$CONFIG_GE1_RGMII_FORCE_1000" = "y" -o "$CONFIG_GE1_RGMII_FORCE_1200" = "y" ]; then
			echo "##### restore Ralink ESW to dump switch #####"
			if [ "$CONFIG_RALINK_RT6855" = "y" -o "$CONFIG_RALINK_RT6855A" = "y" -o "$CONFIG_RALINK_MT7620" = "y" -o "$CONFIG_RALINK_MT7621" = "y" ]; then
				config-vlan.sh 3 0
			else
				config-vlan.sh 2 0
			fi
			echo "##### restore External Switch to dump switch #####"
			if [ "$CONFIG_RALINK_RT6855" = "y" -o "$CONFIG_RALINK_RT6855A" = "y" -o "$CONFIG_RALINK_MT7620" = "y" -o "$CONFIG_RALINK_MT7621" = "y" ]; then
				echo "initialize external switch"
			else
				config-vlan.sh 1 0
			fi
		else
			echo "##### restore Ralink ESW to dump switch #####"
			if [ "$CONFIG_RALINK_RT6855" = "y" -o "$CONFIG_RALINK_RT6855A" = "y" -o "$CONFIG_RALINK_MT7620" = "y" -o "$CONFIG_RALINK_MT7621" = "y" ]; then
				config-vlan.sh 3 0
			else
				config-vlan.sh 2 0
			fi
		fi
	fi
	if [ "$CONFIG_IPV6" == "y" -o "$CONFIG_IPV6" == "m" ]; then
		sleep 4
	fi
elif [ "$opmode" = "3" ]; then
	configVIF
	if [ "$CONFIG_RAETH_ROUTER" = "y" -o "$CONFIG_MAC_TO_MAC_MODE" = "y" -o "$CONFIG_RT_3052_ESW" = "y" ]; then
		if [ "$CONFIG_RAETH_ROUTER" = "y" ]; then
			echo "##### restore IC+ to dump switch #####"
			config-vlan.sh 0 0
		fi
		if [ "$CONFIG_MAC_TO_MAC_MODE" = "y" ]; then
			echo "##### restore Vtss to dump switch #####"
			config-vlan.sh 1 0
		fi
		if [ "$CONFIG_RT_3052_ESW" = "y" ]; then
			if [ "$CONFIG_P5_RGMII_TO_MAC_MODE" = "y" -o "$CONFIG_GE1_RGMII_FORCE_1000" = "y" -o "$CONFIG_GE1_RGMII_FORCE_1200" = "y" ]; then
				echo "##### restore Ralink ESW to dump switch #####"
				if [ "$CONFIG_RALINK_RT6855" = "y" -o "$CONFIG_RALINK_RT6855A" = "y" -o "$CONFIG_RALINK_MT7620" = "y" -o "$CONFIG_RALINK_MT7621" = "y" ]; then
					config-vlan.sh 3 0
				else
					config-vlan.sh 2 0
				fi
				echo "##### restore External Switch to dump switch #####"
				if [ "$CONFIG_RALINK_RT6855" = "y" -o "$CONFIG_RALINK_RT6855A" = "y" -o "$CONFIG_RALINK_MT7620" = "y" -o "$CONFIG_RALINK_MT7621" = "y" ]; then
					echo "initialize external switch"
				else
					config-vlan.sh 1 0
				fi
			else
				echo "##### restore Ralink ESW to dump switch #####"
				if [ "$CONFIG_RALINK_RT6855" = "y" -o "$CONFIG_RALINK_RT6855A" = "y" -o "$CONFIG_RALINK_MT7620" = "y" -o "$CONFIG_RALINK_MT7621" = "y" ]; then
					config-vlan.sh 3 0
				else
					config-vlan.sh 2 0
				fi
			fi
		fi
	fi
	if [ "$CONFIG_IPV6" == "y" -o "$CONFIG_IPV6" == "m" ]; then
		sleep 4
	fi
else
	echo "unknown OperationMode: $opmode"
	exit 1
fi

addBr0

if [ "$opmode" != "0" ]; then
	echo 1 > /proc/sys/net/ipv4/ip_forward
fi

# in order to use broadcast IP address in L2 management daemon
#if [ "$CONFIG_ICPLUS_PHY" = "y" ]; then
#	route add -host 255.255.255.255 dev $wan_if
#else
#	route add -host 255.255.255.255 dev $lan_if
#fi

RVT=`nvram_get 2860 RVT`
if [ "$RVT" = "1" ]; then
	if [ "$CONFIG_RA_CLASSIFIER" = "y" -o "$CONFIG_RA_CLASSIFIER" = "m" ]; then
	insmod -q cls
	fi
fi

HWNAT=`nvram_get 2860 hwnatEnabled`
if [ "$HWNAT" = "1" ]; then
	insmod -q hw_nat
fi

WDGE=`nvram_get 2860 WatchDogEnable`
if [ "$WDGE" = "1" ]; then
	if [ "$CONFIG_RALINK_WATCHDOG" = "m" -o "$CONFIG_RALINK_TIMER_WDG" = "m" ]; then
	insmod -q ralink_wdt
	fi
	wdg.sh
	watchdog
fi

# In 2.6.36 kernel(MT7620& MT7621), avoid ipv6 traffic unless everything ready
if [ "$CONFIG_RALINK_MT7620" = "y" -o "$CONFIG_RALINK_MT7621" = "y" ]; then
if [ "$CONFIG_IPV6" == "y" -o "$CONFIG_IPV6" == "m" ]; then
echo 0 > /proc/sys/net/ipv6/conf/all/disable_ipv6
fi
fi
