/*******************************************************************************
 * Copyright 2005  Hon Hai Precision Ind. Co. Ltd.
 * All Rights Reserved.
 * No portions of this material shall be reproduced in any form without the
 * written permission of Hon Hai Precision Ind. Co. Ltd.
 *
 * All information contained in this document is Hon Hai Precision Ind.
 * Co. Ltd. company private, proprietary, and trade secret property and
 * are protected by international intellectual property laws and treaties.
 *
****************************************************************************
***
***    Filename: ambit_wlan_region.c
***
***    Description:
***         This file is specific to each project. Every project should have a
***    different copy of this file. It defined channels and country code for 
***    each region.
***
***    History:
***
***	   Modify Reason		       Author        Date       Search Flag(Option)
***	--------------------------------------------------------------------------
***    File Creation              Max Ding     08/13/2013
*******************************************************************************/

#include "wlan_util.h"
#include "wlan_region.h"

char *region_str_id[] =
{
    "coun_select1",
    "coun_af",
    "coun_as",
    "coun_au",
    "coun_ca",
    "coun_eu",
    "coun_is",
    "coun_jp",
    "coun_ko",
    "coun_mx",
    "coun_sa",
    "coun_us",
    "coun_middle_east_sa",
    "",             /* 13. reserve1 */
    "coun_ru",
    "",             /* 15. reserve2 */
    "coun_ch",
    "coun_in",
    "coun_ma",
    "coun_middle_east_ilq",
    "coun_middle_east_tetk", /* 20.Middle East (Turkey/Egypt/Tunisia/Kuwait) */
    "coun_middle_east_asy",
    "coun_middle_east_uae",
    "coun_si",
    "coun_tw"
};

/* region list which is displayed in GUI */
S_region_list region_list = 
{
    22,
    {
    //WL_REGION_SELECT,
    WL_REGION_AFRICA,
    WL_REGION_ASIA,
    WL_REGION_AUSTRALIA,
    WL_REGION_CANADA,
    WL_REGION_CHINA,
    WL_REGION_EUROPE,
    WL_REGION_INDIA,
    WL_REGION_ISRAEL,
    WL_REGION_JAPAN,
    WL_REGION_KOREA,
    WL_REGION_MALAYSIA,
    WL_REGION_MEXICO,
    WL_REGION_MIDDLE_EAST_ASY,
    WL_REGION_MIDDLE_EAST_ILQ,
    WL_REGION_MIDDLE_EAST_TETK,
    WL_REGION_MIDDLE_EAST_SA,
    WL_REGION_MIDDLE_EAST_UAE,
    WL_REGION_RUSSIA,
    WL_REGION_SINGAPORE,
    WL_REGION_SOUTH_AMERICA,
    WL_REGION_TAIWAN,
    WL_REGION_NORTH_AMERICA
    }
};

/* IMPORTANT!!
 * Please disable 5G Auto Channel if CountryRegion can not meet requirement.
 * See ralink_wlan_util.h for details. (Entries marked as FIXME)
 */
S_region_info g_region_info[] =
{
    /* 0. Select Region */
    {11,0,0,21,{153,36,40,44,48,52,56,60,64,100,104,108,112,116,136,140,149,153,157,161,165},
            17,{153,36,40,44,48,52,56,60,64,100,104,108,112,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            17,{153,36,40,44,48,52,56,60,64,100,104,108,112,149,153,157,161},
#else
            0,{0},
#endif
            REGION0_CCODE,0,REGION0_CCODE,0
            },
    /* 1. Africa */
    {13,0,1,16,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,136,140},
            0,{0},
            0,{0},
            REGION1_CCODE,0,REGION1_CCODE,0
            },
    /* 2. Asia */
    {13,0,1,25,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140,149,153,157,161,165},
            23,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            21,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,149,153,157,161},
#else
            0,{0},
#endif
            REGION2_CCODE,0,REGION2_CCODE,0
            },
    /* 3. Australia */
    {13,1,1,22,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,132,136,140,149,153,157,161,165},
            19,{44,36,40,44,48,52,56,60,64,100,104,108,112,132,136,149,153,157,161},
            17,{44,36,40,44,48,52,56,60,64,100,104,108,112,149,153,157,161},
            REGION3_CCODE,0,REGION3_CCODE,0
            },
    /* 4. Canada */
    {11,1,1,21,{153,36,40,44,48,52,56,60,64,100,104,108,112,116,136,140,149,153,157,161,165},
            17,{153,36,40,44,48,52,56,60,64,100,104,108,112,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            17,{153,36,40,44,48,52,56,60,64,100,104,108,112,149,153,157,161},
#else
            0,{0},
#endif
            REGION4_CCODE,0,REGION4_CCODE,0
            },
    /* 5. Europe */
    {13,1,1,20,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140},
            19,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136},
#ifdef SUPPORT_AC_MODE
            17,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128},
#else
            0,{0},
#endif
            REGION5_CCODE,0,REGION5_CCODE,0
            },
    /* 6. Israel */
    {13,0,1,9,{44,36,40,44,48,52,56,60,64},
            0,{0},
            0,{0},
            REGION6_CCODE,0,REGION6_CCODE,0
            },
    /* 7. Japan 1-14? */
    {14,1,1,20,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140},
            19,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136},
#ifdef SUPPORT_AC_MODE
            17,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128},
#else
            0,{0},
#endif
            REGION7_CCODE,0,REGION7_CCODE,0
            },
    /* 8. Korea */
    {13,0,1,21,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,149,153,157,161},
            21,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            21,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,149,153,157,161},
#else
            0,{0},
#endif
            REGION8_CCODE,0,REGION8_CCODE,0
            },
    /* 9. Mexico */
    {11,0,1,14,{44,36,40,44,48,52,56,60,64,149,153,157,161,165},
            13,{44,36,40,44,48,52,56,60,64,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            13,{44,36,40,44,48,52,56,60,64,149,153,157,161},
#else
            0,{0},
#endif
            REGION9_CCODE,0,REGION9_CCODE,0
            },
    /* 10.South America */
    {13,0,1,25,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140,149,153,157,161,165},
            23,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            21,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,149,153,157,161},
#else
            0,{0},
#endif
            REGION10_CCODE,0,REGION10_CCODE,0
            },
    /* 11.US -- North America (include Canada) */
    {11,1,1,24,{153,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,136,140,149,153,157,161,165},
            20,{153,36,40,44,48,52,56,60,64,100,104,108,112,120,124,128,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            20,{153,36,40,44,48,52,56,60,64,100,104,108,112,120,124,128,149,153,157,161},
#else
            0,{0},
#endif
            REGION11_CCODE,0,REGION11_CCODE,0
            },
    /* 12.Middle East - Saudi Arabia */
    {13,0,1,14,{44,36,40,44,48,52,56,60,64,149,153,157,161,165},
            0,{0},
            0,{0},
            REGION12_CCODE,0,REGION12_CCODE,0
            },
    /* 13.Reserve1 */
    {13,0,1,6,{153,149,153,157,161,165},
            5,{153,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            5,{153,149,153,157,161},
#else
            0,{0},
#endif
            REGION13_CCODE,0,REGION13_CCODE,0
            },
    /* 14.Russia */
    {13,0,1,5,{44,36,40,44,48},
            5,{44,36,40,44,48},
#ifdef SUPPORT_AC_MODE
            5,{44,36,40,44,48},
#else
            0,{0},
#endif
            REGION14_CCODE,0,REGION14_CCODE,0
            },
    /* 15.Reserve2 */
    {13,0,1,25,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140,149,153,157,161,165},
            23,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            21,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,149,153,157,161},
#else
            0,{0},
#endif
            REGION15_CCODE,0,REGION15_CCODE,0
            },
    /* 16.China */
    {13,0,1,21,{153,36,40,44,48,52,56,60,64,100,104,108,112,116,136,140,149,153,157,161,165},
            17,{153,36,40,44,48,52,56,60,64,100,104,108,112,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            17,{153,36,40,44,48,52,56,60,64,100,104,108,112,149,153,157,161},
#else
            0,{0},
#endif
            REGION16_CCODE,0,REGION16_CCODE,0
            },
    /* 17.India */
    {13,0,1,14,{44,36,40,44,48,52,56,60,64,149,153,157,161,165},
            13,{44,36,40,44,48,52,56,60,64,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            13,{44,36,40,44,48,52,56,60,64,149,153,157,161},
#else
            0,{0},
#endif
            REGION17_CCODE,0,REGION17_CCODE,0
            },
    /* 18.Malaysia */
    {13,0,1,14,{44,36,40,44,48,52,56,60,64,149,153,157,161,165},
            13,{44,36,40,44,48,52,56,60,64,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            13,{44,36,40,44,48,52,56,60,64,149,153,157,161},
#else
            0,{0},
#endif
            REGION18_CCODE,0,REGION18_CCODE,0
            },
    /* 19.Middle East (Iran/Lebanon/Qatar) */
    {13,0,1,6,{153,149,153,157,161,165},
            5,{153,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            5,{153,149,153,157,161},
#else
            0,{0},
#endif
            REGION19_CCODE,0,REGION19_CCODE,0
            },
    /* 20.Middle East (Turkey/Egypt/Tunisia/Kuwait) */
    {13,0,1,9,{44,36,40,44,48,52,56,60,64},
            0,{0},
            0,{0},
            REGION20_CCODE,0,REGION20_CCODE,0
            },
    /* 21.Middle East (Algeria/Syria/Yemen) */
    {13,0,1,0,{0},
            0,{0},
            0,{0},
            REGION21_CCODE,0,REGION21_CCODE,0
            },
    /* 22.Middle East (United Arab Emirates) */
    {13,0,1,20,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136,140},
            19,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128,132,136},
#ifdef SUPPORT_AC_MODE
            17,{44,36,40,44,48,52,56,60,64,100,104,108,112,116,120,124,128},
#else
            0,{0},
#endif
            REGION22_CCODE,0,REGION22_CCODE,0
            },
    /* 23.Singapore */
    {13,0,1,14,{44,36,40,44,48,52,56,60,64,149,153,157,161,165},
            13,{44,36,40,44,48,52,56,60,64,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            13,{44,36,40,44,48,52,56,60,64,149,153,157,161},
#else
            0,{0},
#endif
            REGION23_CCODE,0,REGION23_CCODE,0
            },
    /* 24.Taiwan */
    {13,0,0,20,{153,56,60,64,100,104,108,112,116,120,124,128,132,136,140,149,153,157,161,165},
            17,{153,60,64,100,104,108,112,116,120,124,128,132,136,149,153,157,161},
#ifdef SUPPORT_AC_MODE
            13,{153,100,104,108,112,116,120,124,128,149,153,157,161},
#else
            0,{0},
#endif
            REGION24_CCODE,0,REGION24_CCODE,0
            },
};

int region_count = sizeof(g_region_info)/sizeof(g_region_info[0]);
