#
# Copyright 2005  Hon Hai Precision Ind. Co. Ltd.
#  All Rights Reserved.
# No portions of this material shall be reproduced in any form without the
# written permission of Hon Hai Precision Ind. Co. Ltd.
#
# All information contained in this document is Hon Hai Precision Ind.
# Co. Ltd. company private, proprietary, and trade secret property and
# are protected by international intellectual property laws and treaties.
#
# $Id$
#

include config.mk
include config.in

#
# Paths
#

SUBDIRS := 

#SUBDIRS += dnsmasq
#SUBDIRS += dnsmasq-2.15
SUBDIRS += udhcpd
#SUBDIRS += ppp/pppoecd
#SUBDIRS += ppp-2.4.4/pppd pppoecd
SUBDIRS += ntpclient
SUBDIRS += bzip2

ifeq ($(CONFIG_RIP),y)
SUBDIRS	+= zebra
endif

ifeq ($(CONFIG_PPTP),y)
#SUBDIRS	+= ppp-2.4.4/pppd pptp
# SUBDIRS	+= ppp/pppd pptp
SUBDIRS	+= pptp
endif

ifeq ($(CONFIG_L2TP),y)
SUBDIRS += l2tpd-0.69
endif

ifeq ($(CONFIG_BPA),y)
SUBDIRS	+= bpalogin
endif

ifeq ($(CONFIG_DLNA),y)
SUBDIRS += minidlna
endif

ifeq ($(AP_MODE),y)
SUBDIRS += zeroconf-0.9
endif

#water, 10/30/2008, @samba
ifeq ($(SAMBA_ENABLE_FLAG),y)
SUBDIRS	+= samba-3.0.13
SUBDIRS	+= bftpd-1.6.6
endif

# pling added 05/04/2009, for NTFS-3g
ifeq ($(CONFIG_NTFS_3G),y)
SUBDIRS += ntfs-3g-2009.3.8
endif
#pling added 05/07/2009, for mtools (to read FAT volume label)
ifeq ($(CONFIG_MTOOLS),y)
SUBDIRS += mtools-4.0.10
#	cd mtools-4.0.10 && \
#	echo "ac_cv_func_setpgrp_void=yes" > config.cache && \
#	echo "ac_cv_lib_ICE_IceConnectionNumber=no" >> config.cache && \
#	CC=$(CC) $(CONFIGURE) -C CFLAGS="$(CFLAGS)" \
#		--disable-floppyd --with-x=no --prefix=$(TARGETDIR)
endif
#Foxconn add start, stanley, 01/16/2010 @IGMP
ifeq ($(CONFIG_IGMP_PROXY),y)
SUBDIRS	+= IGMP-PROXY
endif
#Foxconn add end, stanley, 01/16/2010 @IGMP
#SUBDIRS += iproute2

ifeq ($(CONFIG_OPENSSL),y)
OPENSSL_DIR = $(GPLTOPDIR)/openssl
preobjs += openssl
else
OPENSSL_DIR = $(SRCBASE)/user/openssl-0.9.8e
#OPENSSL_DIR = $(SRCBASE)/user/openssl-1.0.2h
OPENSSL1_DIR = $(GPLTOPDIR)/openssl-1.0.2n
endif

ifeq ($(CONFIG_WGET),y)
preobjs += wget
endif

ifeq ($(CONFIG_CURL),y)
preobjs += curl
endif

ifeq ($(CONFIG_RADVD),y)
preobjs += radvd
endif

ifeq ($(CONFIG_DHCP6),y)
preobjs += dhcp6
endif

all: openssl_make preobj 
	for i in ${SUBDIRS}; do \
		(cd $$i && make) || exit 1; \
	done

preobj:
	for i in ${preobjs}; do \
		$(MAKE) $$i || exit 1; \
	done

preobj-install:
	for i in ${preobjs}; do \
		$(MAKE) $$i-install || exit 1; \
	done

preobj-clean: openssl1-clean
	for i in ${preobjs}; do \
		$(MAKE) $$i-clean || exit 1; \
	done

openssl_config:
	if [ ! -f ./openssl-1.0.2n/Makefile ];then \
		cd openssl-1.0.2n && (CC=gcc CFLAGS="$(CFLAGS)" setarch i386 ./config no-static no-asm shared --openssldir=$(TARGETDIR) && make depend) \
	fi

openssl_make: openssl_config
#cd ./openssl-1.0.2n && make && rm -f libsslA.so && ln -sf libssl.so.1.0.0 libsslA.so && rm -f libcryptoA.so && ln -sf libcrypto.so.1.0.0 libcryptoA.so
#cd $(GPLTOPDIR)/openssl-1.0.2n && install -d $(TARGETDIR)/lib && install -m 755 libssl.so.1.0.0 $(TARGETDIR)/lib && install -m 755 libcrypto.so.1.0.0 $(TARGETDIR)/lib && $(STRIP) $(TARGETDIR)/lib/libssl.so.1.0.0 && $(STRIP) $(TARGETDIR)/lib/libcrypto.so.1.0.0                                                                         
#cd $(TARGETDIR)/lib/ && rm -rf libssl.a libcrypto.a && rm -f libsslA.so && ln -sf libssl.so.1.0.0 libsslA.so && rm -f libssl.so && ln -sf libssl.so.1.0.0 libssl.so && rm -f libcryptoA.so && ln -sf libcrypto.so.1.0.0 libcryptoA.so && rm -f libcrypto.so && ln -sf libcrypto.so.1.0.0 libcrypto.so        
	cd ./openssl-1.0.2n && make && rm -f libssl.so && ln -sf libssl.so.1.0.0 libssl.so && rm -f libcrypto.so && ln -sf libcrypto.so.1.0.0 libcrypto.so
	cd $(GPLTOPDIR)/openssl-1.0.2n && install -d $(TARGETDIR)/lib && install -m 755 libssl.so.1.0.0 $(TARGETDIR)/lib && install -m 755 libcrypto.so.1.0.0 $(TARGETDIR)/lib && $(STRIP) $(TARGETDIR)/lib/libssl.so.1.0.0 && $(STRIP) $(TARGETDIR)/lib/libcrypto.so.1.0.0 && install -d $(TARGETDIR)/bin && install -m 755 ./apps/openssl $(TARGETDIR)/bin/ && $(STRIP) $(TARGETDIR)/bin/openssl                                                                        
	cd $(TARGETDIR)/lib/ && rm -rf libssl.a libcrypto.a && rm -f libssl.so && ln -sf libssl.so.1.0.0 libssl.so && rm -f libcrypto.so && ln -sf libcrypto.so.1.0.0 libcrypto.so        


openssl1-clean:
	[ ! -d openssl-1.0.2n ] || [ ! -f ./openssl-1.0.2n/Makefile ] || $(MAKE) -C openssl-1.0.2n clean

openssl:
ifeq ($(CONFIG_OPENSSL),y)
	[ ! -d openssl ] || [ ! -f openssl/Makefile ] || $(MAKE) -C openssl
endif
#	[ ! -f $(OPENSSL_DIR)/libssl.so ] || (mkdir -p $(OPENSSL_DIR)/lib && cp $(OPENSSL_DIR)/libssl.so $(OPENSSL_DIR)/lib)
	mkdir -p $(OPENSSL1_DIR)/lib && cp $(OPENSSL1_DIR)/*.so $(OPENSSL1_DIR)/lib/ && cp $(OPENSSL1_DIR)/*.so* $(OPENSSL1_DIR)/lib/ && cp $(OPENSSL1_DIR)/*.a $(OPENSSL1_DIR)/lib/

openssl-install:
	[ ! -d openssl ] || [ ! -f openssl/Makefile ] || $(MAKE) -C openssl install

openssl-clean:
	[ ! -d openssl ] || [ ! -f openssl/Makefile ] || $(MAKE) -C openssl clean

wget: openssl
	[ ! -d wget-1.14 ] || ( cd wget-1.14 && CC=$(CC) $(CONFIGURE) \
		CFLAGS="$(CFLAGS) -DMB_CUR_MAX=1" LDFLAGS="$(LDFLAGS) -L$(OPENSSL1_DIR)  -lssl -lcrypto" \
		--with-ssl=openssl --with-libssl-prefix=$(OPENSSL1_DIR) --prefix=$(TARGETDIR) && cd ..)
	[ ! -d wget-1.14 ] || [ ! -f wget-1.14/Makefile ] || $(MAKE) -C wget-1.14

wget-install:
	[ ! -d wget-1.14 ] || [ ! -f wget-1.14/Makefile ] || $(MAKE) -C wget-1.14 install

wget-clean:
	[ ! -d wget-1.14 ] || [ ! -f wget-1.14/Makefile ] || $(MAKE) -C wget-1.14 distclean

curl: openssl
	[ ! -d curl-7.23.1 ] || [ ! -f curl-7.23.1/Makefile ] || $(MAKE) -C curl-7.23.1 SSL_PATH=$(OPENSSL1_DIR)

curl-install:
	[ ! -d curl-7.23.1 ] || [ ! -f curl-7.23.1/Makefile ] || $(MAKE) -C curl-7.23.1 install

curl-clean:
	[ ! -d curl-7.23.1 ] || [ ! -f curl-7.23.1/Makefile ] || $(MAKE) -C curl-7.23.1 distclean

radvd: flex
	[ ! -d radvd ] || [ -f radvd/Makefile ] || ( cd radvd && CC=$(CC) $(CONFIGURE) && cd .. )
	[ ! -d radvd ] || [ ! -f radvd/Makefile ] || $(MAKE) -C radvd CC=$(CC) radvd_LDADD="-L../flex -lfl"

radvd-install:
	[ ! -d radvd ] || install -D -m 755 radvd/radvd $(TARGETDIR)/usr/sbin/radvd
	[ ! -d radvd ] || $(STRIP) $(TARGETDIR)/usr/sbin/radvd

radvd-clean:
	[ ! -d radvd ] || [ ! -f radvd/Makefile ] || $(MAKE) -C radvd distclean

flex:
	[ ! -d flex ] || [ -f flex/Makefile ] || ( cd flex && CC=$(CC) $(CONFIGURE) && cd .. )
	[ ! -d flex ] || [ ! -f flex/Makefile ] || $(MAKE) -C flex CC=$(CC) RANLIB=$(RANLIB)

dhcp6: openssl
	[ ! -d dhcp6 ] || [ -f dhcp6/Makefile ] || (cd dhcp6 && \
		echo "ac_cv_func_setpgrp_void=yes" > config.cache && \
		CC=$(CC) $(CONFIGURE) -C CFLAGS="-I$(LINUXDIR)/include" \
		LDFLAGS="$(LDFLAGS) -L$(OPENSSL1_DIR)" && cd ..)
	[ ! -d dhcp6 ] || [ ! -f dhcp6/Makefile ] || $(MAKE) -C dhcp6 CC=$(CC)

dhcp6-install:
	[ ! -d dhcp6 ] || install -D -m 755 dhcp6/dhcp6s $(TARGETDIR)/usr/sbin/dhcp6s
	[ ! -d dhcp6 ] || $(STRIP) $(TARGETDIR)/usr/sbin/dhcp6s
	[ ! -d dhcp6 ] || install -D -m 755 dhcp6/dhcp6c $(TARGETDIR)/usr/sbin/dhcp6c
	[ ! -d dhcp6 ] || $(STRIP) $(TARGETDIR)/usr/sbin/dhcp6c

dhcp6-clean:
	[ ! -d dhcp6 ] || [ ! -f dhcp6/Makefile ] || $(MAKE) -C dhcp6 distclean

install: preobj-install 
	for i in ${SUBDIRS}; do \
		(cd $$i && make install) || exit 1; \
	done

romfs: install

clean: preobj-clean
	for i in ${SUBDIRS}; do \
		(cd $$i && make clean) || exit 1; \
	done

.PHONY: all install clean romfs preobj preobj-install preobj-clean
.PHONY: openssl openssl-install openssl-clean wget wget-install wget-clean
.PHONY: radvd radvd-install radvd-clean flex dhcp6 dhcp6-install dhcp6-clean

.PHONY: $(SUBDIRS)
