/***************************************************************************
#***
#***    Copyright 2005  Hon Hai Precision Ind. Co. Ltd.
#***    All Rights Reserved.
#***    No portions of this material shall be reproduced in any form without the
#***    written permission of Hon Hai Precision Ind. Co. Ltd.
#***
#***    All information contained in this document is Hon Hai Precision Ind.  
#***    Co. Ltd. company private, proprietary, and trade secret property and 
#***    are protected by international intellectual property laws and treaties.
#***
#****************************************************************************
***
**    Filename: ambitCfg.h
***
***    Description:
***         This file is specific to each project. Every project should have a
***    different copy of this file.
***        Included from ambit.h which is shared by every project.
***
***    History:
***
***	   Modify Reason		                                        Author		         Date		                Search Flag(Option)
***	--------------------------------------------------------------------------------------
***    File Creation                                            Jasmine Yang    11/02/2005
*******************************************************************************/


#ifndef _AMBITCFG_H
#define _AMBITCFG_H

#define WW_VERSION           1 /* WW SKUs */
#define NA_VERSION           2 /* NA SKUs */
#define JP_VERSION           3
#define GR_VERSION           4
#define PR_VERSION           5
#define KO_VERSION           6
#define RU_VERSION           7
#define SS_VERSION           8
#define PT_VERSION           9
#define TWC_VERSION          10
#define BRIC_VERSION         11
#define SK_VERSION           12

#define WLAN_REGION          WW_VERSION
#define FW_REGION            WW_VERSION   /* true f/w region */

/*formal version control*/
#define AMBIT_HARDWARE_VERSION      "U12H319T00"
#define AMBIT_SOFTWARE_VERSION      "V1.0.0.98"
#define AMBIT_UI_VERSION            "1.0.63"
#define STRING_TBL_VERSION          "1.0.0.64_2.1.30.1"
#define AMBIT_DEVICE_ID             "EX3700"
#define AMBIT_HW_VERSION            "V1"

#define AMBIT_PRODUCT_NAME          "EX3700"
#define AMBIT_PRODUCT_DESIGN        "GECKO"
#define AMBIT_PRODUCT_MODEL         "N600"
#define AMBIT_PRODUCT_DESCRIPTION   "N600 Wifi Range Extender EX3700"
#define AMBIT_PRODUCT_BRAND         "NETGEAR"
#define AMBIT_MANUFACTURER          "NETGEAR, Inc."
#define AMBIT_MANUFACTURER_URL      "http://www.netgear.com"
#define AMBIT_MODEL_URL             "http://www.mywifiext.net"
#define DOCUMENT_URL                "http://downloadcenter.netgear.com"
#define SUCCESS_URL                 "http://www.netgear.com/success/ex3700-en.aspx"

#define UPnP_MANUFACTURER           AMBIT_MANUFACTURER
#define UPnP_MANUFACTURER_URL       AMBIT_MANUFACTURER_URL
#define UPnP_MODEL_URL              AMBIT_MODEL_URL
#define UPnP_MODEL_DESCRIPTION      AMBIT_PRODUCT_DESCRIPTION

#define WPS_FRIENDLY_NAME           AMBIT_PRODUCT_NAME
#define WPS_MANUFACTURER            AMBIT_MANUFACTURER
#define WPS_MANUFACTURER_URL        AMBIT_MANUFACTURER_URL
#define WPS_MODEL_DESCRIPTION       AMBIT_PRODUCT_DESCRIPTION
#define WPS_MODEL_NAME              AMBIT_PRODUCT_NAME
#define WPS_MODEL_NUMBER            AMBIT_PRODUCT_NAME
#define WPS_MODEL_URL               AMBIT_MODEL_URL

#define AMBIT_NVRAM_VERSION         "1" /* digital only */
#define SMART_WIZARD_SPEC_VERSION   "0.7"
#define AMBIT_SOAP_VERSION          "1.8"
#define USB_support_level           "0"

#define DF_2G_ROOTAP_SSID           "NETGEAR_EXT"
#define DF_5G_ROOTAP_SSID           "NETGEAR_5GEXT"
#define AP_MODE_DEFAULT_2G_SSID     "NETGEAR_2GEXT"

/****************************************************************************
 * Board-specific defintions
 ****************************************************************************/

/* delay time definitions */
#define DELAY_TIME_RESTART_ALL      (38)
#define DELAY_TIME_RESTART_WLAN     (23)
#define DELAY_TIME_REBOOT           (60)
#define DELAY_TIME_UPGRADE          (33)

/* Interface definitions */
#define ETH_IF_NAME_NUM             "eth2"
#define WAN_IF_NAME_NUM             "eth2.2"
#define LAN_IF_NAME_NUM             "eth2.1"
#define WLAN_IF_NAME_NUM            "ra0"
#define WLAN_N_IF_NAME_NUM          "rai0"
#define WDS_IF_NAME_NUM             "wds0"    /* WDS interface */
#define WLAN_CLI_IF_NAME_NUM        "apcli0"
#define WLAN_5G_CLI_IF_NAME_NUM     "apclii0"
#define LAN_BR_IF_NAME_NUM          "br0"
#define LAN_BR1_IF_NAME_NUM         "br1"

#define WLAN_BSS1_NAME_NUM          "ra1"     /* Multiple BSSID #2 */
#define WLAN_BSS2_NAME_NUM          "ra2"     /* Multiple BSSID #3 */
#define WLAN_BSS3_NAME_NUM          "ra3"     /* Multiple BSSID #4 */

#define WLAN_5G_BSS1_NAME_NUM       "rai1"     /* Multiple BSSID #2 */
#define WLAN_5G_BSS2_NAME_NUM       "rai2"     /* Multiple BSSID #3 */
#define WLAN_5G_BSS3_NAME_NUM       "rai3"     /* Multiple BSSID #4 */

#define WLAN_2G_ANTENA              "2x2"
#define WLAN_5G_ANTENA              "2x2"

/* Switch port definitions */
#define LAN1_PORT_IDX               (0)
#define LAN2_PORT_IDX               (0)
#define LAN3_PORT_IDX               (0)
#define LAN4_PORT_IDX               (0)
#define WAN_PORT_IDX                (0)

/* Rate definitions */
#define RATE_STR_2G_BG              "54Mbps"
#define RATE_STR_2G_HT20            "145Mbps"
#define RATE_STR_2G_HT40            "300Mbps"
#define RATE_STR_5G_BG              "54Mbps"
#define RATE_STR_5G_HT20            "87Mbps"
#define RATE_STR_5G_HT40            "200Mbps"
#define RATE_STR_5G_HT80            "433Mbps"

#define OPMODE_STR_2G_BG            "wlan_mode_54"
#define OPMODE_STR_2G_HT20          "wlan_mode_145"
#define OPMODE_STR_2G_HT40          "wlan_mode_300"
#define OPMODE_STR_5G_BG            "wlan_mode_54"
#define OPMODE_STR_5G_HT20          "wlan_mode_87"
#define OPMODE_STR_5G_HT40          "wlan_mode_200"
#define OPMODE_STR_5G_HT80          "wlan_mode_433"


/* DFS definitions */
#define REGION4_CCODE_MAPPING       /* Canada 4-5; 8-5-2-5 */
#define REGION4_CCODE               "CA"    /* DFS */
#define REGION4_2G_CH_IDX           "0"     /* 11 */
#define REGION4_5G_CH_IDX           "14"    /* 10->(4-5); 14->(8-5-2-5) */
#define REGION4_2G_SKU_IDX          "7"     /* 3: FCC table; 7: IC table */
#define REGION4_5G_SKU_IDX          "7"     /* 3: FCC table; 7: IC table */
#define REGION4_SKU_IDX             "7"     /* 3: FCC table; 7: IC table */

#define REGION5_CCODE_MAPPING       /* Europe 4; 8-11 */
#define REGION5_CCODE               "FR"    /* DFS */
#define REGION5_2G_CH_IDX           "1"     /* 13 */
#define REGION5_5G_CH_IDX           "1"     /* 6->(4); 1->(8-11); 18->(8-5-3) */
#define REGION5_2G_SKU_IDX          "0"
#define REGION5_5G_SKU_IDX          "0"
#define REGION5_SKU_IDX             "0"

#define REGION7_CCODE_MAPPING   /* Japan 4; 8-11 */
#define REGION7_CCODE           "JP"
#define REGION7_2G_CH_IDX       "5"     /* 14 */
#define REGION7_5G_CH_IDX       "1"     /* 6->(4); 1->(8-11) */
#define REGION7_2G_SKU_IDX      "5"
#define REGION7_5G_SKU_IDX      "5"
#define REGION7_SKU_IDX         "5"

#define REGION11_CCODE_MAPPING      /* United States 4-5; 8-5-2-5 */
#define REGION11_CCODE              "US"    /* DFS */
#define REGION11_2G_CH_IDX          "0"     /* 11 */
#define REGION11_5G_CH_IDX          "7"    /* 10->(4-5); 14->(8-5-2-5) */
#define REGION11_2G_SKU_IDX         "3"
#define REGION11_5G_SKU_IDX         "3"
#define REGION11_SKU_IDX            "3"

#define REGION3_CCODE_MAPPING       /* Australia 4-5; 8-5-3-5 */
#define REGION3_CCODE               "AU"
#define REGION3_2G_CH_IDX           "1"     /* 13 */
#define REGION3_5G_CH_IDX           "9"    /* 10->(4-5); 9->(8-5-3-5) */
#define REGION3_2G_SKU_IDX          "4"
#define REGION3_5G_SKU_IDX          "4"
#define REGION3_SKU_IDX             "4"

/* GPIO definitions */
#define gpio_in                     (0)
#define gpio_out                    (1)

/* Active mode mask, bit[12] */
#define GPIO_ACTIVE_MODE_LOW        (0x0000)
#define GPIO_ACTIVE_MODE_HIGH       (0x1000)
#define GPIO_ACTIVE_MODE(x)         ((x) & 0x1000)
#define GPIO_NUM(x)                 ((x) & 0x00FF)

#define GPIO_PIN_UNUSED             (72 | GPIO_ACTIVE_MODE_HIGH)

#define GPIO_POWER_LED_GREEN        (63 | GPIO_ACTIVE_MODE_LOW)
#define GPIO_POWER_LED_AMBER        (68 | GPIO_ACTIVE_MODE_LOW)

#define GPIO_LAN1_LED_GREEN         GPIO_PIN_UNUSED
#define GPIO_LAN1_LED_AMBER         GPIO_PIN_UNUSED
#define GPIO_LAN2_LED_GREEN         GPIO_PIN_UNUSED
#define GPIO_LAN2_LED_AMBER         GPIO_PIN_UNUSED
#define GPIO_LAN3_LED_GREEN         GPIO_PIN_UNUSED
#define GPIO_LAN3_LED_AMBER         GPIO_PIN_UNUSED
#define GPIO_LAN4_LED_GREEN         GPIO_PIN_UNUSED
#define GPIO_LAN4_LED_AMBER         GPIO_PIN_UNUSED

#define GPIO_WAN_LED_GREEN          GPIO_PIN_UNUSED
#define GPIO_WAN_LED_AMBER          GPIO_PIN_UNUSED

#define GPIO_WIFI_2G_LED            GPIO_PIN_UNUSED
#define GPIO_WIFI_5G_LED            GPIO_PIN_UNUSED

#define GPIO_USB_LED                GPIO_PIN_UNUSED
#define GPIO_USB_ENABLE             GPIO_PIN_UNUSED

#define GPIO_WPS_LED                (67 | GPIO_ACTIVE_MODE_LOW)

#define GPIO_RESET_BUTTON           (66 | GPIO_ACTIVE_MODE_LOW)
#define GPIO_WIFI_BUTTON            GPIO_PIN_UNUSED
#define GPIO_WPS_BUTTON             (2 | GPIO_ACTIVE_MODE_LOW)
#define GPIO_RPT_MODE_BUTTON        (70 | GPIO_ACTIVE_MODE_HIGH)

#define GPIO_AP_LINK_LED_GOOD       (65 | GPIO_ACTIVE_MODE_LOW)
#define GPIO_AP_LINK_LED_POOR       (64 | GPIO_ACTIVE_MODE_LOW)
#define GPIO_AP_LOC_LED             (69 | GPIO_ACTIVE_MODE_LOW)
#define GPIO_CLI_LINK_LED_GOOD      (60 | GPIO_ACTIVE_MODE_LOW)
#define GPIO_CLI_LINK_LED_POOR      (61 | GPIO_ACTIVE_MODE_LOW)
#define GPIO_CLI_LOC_LED            (62 | GPIO_ACTIVE_MODE_LOW)

/* MTD definitions */
#define LANG_TBL_MTD_RD             "/dev/mtdblock"
#define LANG_TBL_MTD_WR             "/dev/mtd"

#define ML_MTD_RD                   "/dev/mtdblock"
#define ML_MTD_WR                   "/dev/mtd"

#define ML1_MTD_RD                  "/dev/mtdblock7"
#define ML1_MTD_WR                  "/dev/mtd7"
#define ML2_MTD_RD                  "/dev/mtdblock8"
#define ML2_MTD_WR                  "/dev/mtd8"

#define ST_SUPPORT_NUM              (7)
#define LANG_TBL_MTD_START          (7)
#define LANG_TBL_MTD_END            (LANG_TBL_MTD_START + ST_SUPPORT_NUM - 1)
#define FLASH_MTD_ML_SIZE           (0x20000)
#define BUILTIN_LANGUAGE            "English"

#define ML3_MTD_RD                  "/dev/mtdblock9"
#define ML3_MTD_WR                  "/dev/mtd9"
#define ML4_MTD_RD                  "/dev/mtdblock10"
#define ML4_MTD_WR                  "/dev/mtd10"
#define ML5_MTD_RD                  "/dev/mtdblock11"
#define ML5_MTD_WR                  "/dev/mtd11"
#define ML6_MTD_RD                  "/dev/mtdblock12"
#define ML6_MTD_WR                  "/dev/mtd12"
#define ML7_MTD_RD                  "/dev/mtdblock13"
#define ML7_MTD_WR                  "/dev/mtd13"

#define TF1_MTD_RD                  "/dev/mtdblock14"
#define TF1_MTD_WR                  "/dev/mtd14"
#define TF2_MTD_RD                  "/dev/mtdblock15"
#define TF2_MTD_WR                  "/dev/mtd15"

#define POT_MTD_RD                  "/dev/mtdblock16"
#define POT_MTD_WR                  "/dev/mtd16"

#define BD_MTD_RD                   "/dev/mtdblock17"
#define BD_MTD_WR                   "/dev/mtd17"

#define NVRAM_MTD_RD                "/dev/mtdblock18"
#define NVRAM_MTD_WR                "/dev/mtd18"

#define ALL_MTD_RD                  "/dev/mtdblock0"
#define ALL_MTD_WR                  "/dev/mtd0"

#define BOOT_MTD_RD                 "/dev/mtdblock1"
#define BOOT_MTD_WR                 "/dev/mtd1"

#define KERNEL_MTD_RD               "/dev/mtdblock6"
#define KERNEL_MTD_WR               "/dev/mtd6"

#define ROOTFS_MTD_RD               "/dev/mtdblock6"
#define ROOTFS_MTD_WR               "/dev/mtd6"

#define RALINK_NVRAM_SIZE           (0x10000)
#define RALINK_NVRAM_MTD_RD         "/dev/mtdblock2"
#define RALINK_NVRAM_MTD_WR         "/dev/mtd2"

#define RALINK_BD_SIZE              (0x10000)
#define RALINK_BD_MTD_RD            "/dev/mtdblock3"
#define RALINK_BD_MTD_WR            "/dev/mtd3"

#define LANG_TBL1_MTD_RD            (ML1_MTD_RD)
#define LANG_TBL1_MTD_WR            (ML1_MTD_WR)
#define LANG_TBL2_MTD_RD            (ML2_MTD_RD)
#define LANG_TBL2_MTD_WR            (ML2_MTD_WR)

#define KP_MTD_RD                   (TF2_MTD_RD)
#define KP_MTD_WR                   (TF2_MTD_WR)
#define FLASH_SIZE                  (0x800000) /* 8M */
#define IMAGE_BLOCK_SIZE            (0x20000)   /* 128K, for fast read */

#define SIZE_BOOTCODE               (0x30000)
#define SIZE_ML                     ((ST_SUPPORT_NUM)*(FLASH_MTD_ML_SIZE))
#define SIZE_TM                     (0x10000 * 2)
#define SIZE_POT                    (0x10000)
#define SIZE_BD                     (0x10000)
#define SIZE_NARAM                  (0x10000)
#define SIZE_KERNEL                 (FLASH_SIZE - SIZE_BOOTCODE - SIZE_NARAM \
                                     - SIZE_BD - SIZE_POT - SIZE_TM - SIZE_ML \
                                     - RALINK_NVRAM_SIZE - RALINK_BD_SIZE)

#define MAX_SIZE_FILE               (SIZE_KERNEL - 8)
#define MAX_SIZE_KERNEL             (MAX_SIZE_FILE)
#define MAX_SIZE_ROOTFS             (MAX_SIZE_FILE)

/* in case for opensource firmware */
#define MAX_SIZE_FILE_OPENSOURCE    (MAX_SIZE_FILE + SIZE_ML + SIZE_TM)
#define MAX_SIZE_KERNEL_OPENSOURCE  (MAX_SIZE_FILE_OPENSOURCE)
#define MAX_SIZE_ROOTFS_OPENSOURCE  (MAX_SIZE_FILE_OPENSOURCE)
#define BOARD_ID_OPENSOURCE         "U12H248T99_OPENSOURCE"
#define OPENSOURCE_START_MTD_IDX    (4)     /* "Kernel" */
#define OPENSOURCE_END_MTD_IDX      (13)    /* "T_Meter2" */

#define MAX_IMAGE_SIZE              (MAX_SIZE_FILE)
//#define MAX_IMAGE_SIZE            (MAX_SIZE_FILE_OPENSOURCE)

/* EEPROM OFFSET definitions */
#define EEPROM_FLASH_ID_OFFSET      (0x0000)
#define EEPROM_VERSION_OFFSET       (0x0002)
#define EEPROM_WLAN_MAC_OFFSET      (0x0004)
#define EEPROM_LAN_MAC_OFFSET       (0x0028)
#define EEPROM_WAN_MAC_OFFSET       (0x002E)
#define EEPROM_FLASH2_ID_OFFSET     (0x8000)
#define EEPROM_VERSION2_OFFSET      (0x8002)
#define EEPROM_WLAN2_MAC_OFFSET     (0x8004)

#define BACKUP_FILE_KEY             "NtgrBak"

#endif /*_AMBITCFG_H*/
