#
# Copyright 2005  Hon Hai Precision Ind. Co. Ltd.
#  All Rights Reserved.
# No portions of this material shall be reproduced in any form without the
# written permission of Hon Hai Precision Ind. Co. Ltd.
#
# All information contained in this document is Hon Hai Precision Ind.
# Co. Ltd. company private, proprietary, and trade secret property and
# are protected by international intellectual property laws and treaties.
#
# $Id$
#

include config.mk
include config.in

#
# Paths
#

SUBDIRS := 

ifeq ($(CONFIG_ACOSNAT),y)
SUBDIRS += acos_nat_cli 
SUBDIRS += acos_nat
endif

#SUBDIRS += opendns
#SUBDIRS += l7filter
SUBDIRS += br_dns_hijack
#SUBDIRS += ubd

SUBDIRS += ../../project/acos/nvram
SUBDIRS += shared
SUBDIRS += ../../project/acos/rc
SUBDIRS += ../../project/acos/swresetd
SUBDIRS += ../../project/acos/wpsd
#SUBDIRS += ../../project/acos/usb_hotplug

SUBDIRS += httpd www
SUBDIRS += rc
SUBDIRS += wandetect
SUBDIRS += ddns
SUBDIRS += timesync
SUBDIRS += dns_redirect
SUBDIRS += email
SUBDIRS += heartbeat
SUBDIRS += ftpc
SUBDIRS += wlanconfigd
SUBDIRS += output_image
SUBDIRS += bd
SUBDIRS += wan_debug
SUBDIRS += sche_action
SUBDIRS += check_firmware
SUBDIRS += htmlget
#SUBDIRS += ubdu




ifeq ($(AP_MODE),y)
SUBDIRS += autoipd
endif

ifeq ($(CONFIG_DLNA),y)
SUBDIRS += dlnad
endif

ifeq ($(UPNP_SMARTWIZARD_2_0),y)
//SUBDIRS += upnp_sa
else
//SUBDIRS += upnp
endif

ifeq ($(TRAFFIC_METER_FLAG),y)
export CFLAGS += -DINCLUDE_TRAFFIC_METER
export LIB_NAT_CFLAGS += -DINCLUDE_TRAFFIC_METER
SUBDIRS += traffic_meter
endif

ifeq ($(FW_TYPE),PR)
CFLAGS += -DU12H081_PR
SUBDIRS += ddns_oray
endif

ifeq ($(FW_TYPE),TWC)
CFLAGS += -DBUILD_TWC -DSUPPORT_ACOS_TR69C
export LIB_NAT_CFLAGS += -DSUPPORT_ACOS_TR69C
SUBDIRS += tr-069
endif

ifeq ($(MULTI_LANG_ENABLE),y)
CFLAGS += -DENABLE_ML
endif

ifeq ($(SAMBA_ENABLE_FLAG),y)
#SUBDIRS +=samba_ftp
endif

ifeq ($(POT_ENABLE_FLAG),y)
SUBDIRS += pot
endif

ifeq ($(TELNET_ENABLE_FLAG),y)
SUBDIRS += telnet_enable
endif

ifeq ($(LLTD_ENABLE_FLAG),y)
SUBDIRS += lltd
endif

ifeq ($(CONFIG_MLD),y)
SUBDIRS += mld
endif

ifeq ($(INCLUDE_IPV6_FLAG),y)
SUBDIRS += ipv6_relay/src
SUBDIRS += rtsol
SUBDIRS += ipv6_spi
endif

ifeq ($(MULTIPLE_SSID_ENABLE_FLAG),y)
SUBDIRS += multissidcontrol
endif

ifeq ($(PARSER_ENABLE),y)
SUBDIRS += parser
endif

ifeq ($(CONFIG_REPEATER_MODE),y)
SUBDIRS += ipv6_relay/src
#SUBDIRS += testUtility
#SUBDIRS += log_to_usb
SUBDIRS += check_pass
SUBDIRS += br_dhcp_filter
endif

ifeq ($(CONFIG_PROFILE_FEATURE),y)
SUBDIRS += check_opmode
endif

SUBDIRS += certs

all:
	for i in ${SUBDIRS}; do \
		(cd $$i && make) || exit 1; \
	done

install:
	for i in ${SUBDIRS}; do \
		(cd $$i && make install) || exit 1; \
	done

romfs: install

clean:
	for i in ${SUBDIRS}; do \
		(cd $$i && make clean) || exit 1; \
	done

.PHONY: $(SUBDIRS)
