#ifndef _ACOS_NVRAM_H
#define _ACOS_NVRAM_H

#define ACOS_NVRAM_MAJOR_NUM        104
#define ACOS_NVRAM_DEVNAME          "acos_nvram"
#define ACOS_NVRAM_MTDNAME          "nvram"

#define ACOS_NVRAM_IOCTL_NUM        'W'
#define ACOS_NVRAM_IOCTL_INIT       _IOWR(ACOS_NVRAM_IOCTL_NUM, 0, int *)
#define ACOS_NVRAM_IOCTL_GET        _IOWR(ACOS_NVRAM_IOCTL_NUM, 1, int *)
#define ACOS_NVRAM_IOCTL_GETALL     _IOWR(ACOS_NVRAM_IOCTL_NUM, 2, int *)
#define ACOS_NVRAM_IOCTL_SET        _IOWR(ACOS_NVRAM_IOCTL_NUM, 3, int *)
#define ACOS_NVRAM_IOCTL_UNSET      _IOWR(ACOS_NVRAM_IOCTL_NUM, 4, int *)
#define ACOS_NVRAM_IOCTL_COMMIT     _IOWR(ACOS_NVRAM_IOCTL_NUM, 5, int *)
#define ACOS_NVRAM_IOCTL_CLEAR      _IOWR(ACOS_NVRAM_IOCTL_NUM, 6, int *)
#define ACOS_NVRAM_IOCTL_INVAL      _IOWR(ACOS_NVRAM_IOCTL_NUM, 7, int *)
#define ACOS_NVRAM_IOCTL_DEBUG      _IOWR(ACOS_NVRAM_IOCTL_NUM, 8, int *)

typedef struct acos_nvram_ioctl_s {
    char *name;
    int name_len;
    char *value;
    int value_len;
} acos_nvram_ioctl_t;

#ifdef __KERNEL__
struct nvram_header {
    unsigned long magic;
    unsigned long len;
    unsigned short unused;
    unsigned short checksum;
    unsigned long version;
    unsigned long reserved[4];
};

struct nvram_tuple {
    char *name;
    char *value;
    struct nvram_tuple *next;
};

#define NVRAM_MAGIC                 0x40112791
#define NVRAM_VERSION               1
#define NVRAM_HEADER_SIZE           sizeof(struct nvram_header)
#define NVRAM_SPACE                 0x10000

#ifndef ARRAYSIZE
#define ARRAYSIZE(a)        (sizeof(a)/sizeof(a[0]))
#endif
#ifndef ROUNDUP
#define ROUNDUP(x, y)       ((((x)+((y)-1))/(y))*(y))
#endif

#ifdef ACOS_KERNEL_NVRAM
extern char *nvram_get(const char *name);
extern int nvram_set(const char *name, const char *value);
extern int nvram_unset(const char *name);
extern int nvram_match(const char *name, const char *match);
extern int nvram_commit(void);
#endif

#endif

#endif
